##############################################
# Qwt Widget Library
# Copyright (C) 1997   Josef Wilgen
# Copyright (C) 2002   Uwe Rathmann
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the Qwt License, Version 1.0
##############################################

# pro file for building the makefile for qwt
#
# Qt <  3.x: tmake qwt.pro -o Makefile
# Qt >= 3.x: qmake qwt.pro
#
# HEADERS/SOURCES are separated into plot
# relevant files and others. If you are
# interested in QwtPlot only, you can remove
# the lists at the end of this file.

TARGET            = qwt
TEMPLATE          = lib
VERSION           = 0.4.2
CONFIG           += qt warn_on debug thread staticlib
MOC_DIR           = src/moc
MOC_DIR           = src/moc
OBJECTS_DIR       = src/obj
INCLUDEPATH       = include
DEPENDPATH        = include src

unix:DESTDIR      = lib

win32:TEMPLATE    = vclib
win32:CONFIG     += dll
win32:DEFINES    += QT_DLL QWT_DLL QWT_MAKEDLL

# Current gcc (2.95) doesn't handle large C++ projects
# very well. Because KDE and Qt libraries result
# have reached critical sizes, Linux distributors
# reduce them by excluding support for exceptions.
# If you like to use exceptions you will notice a core
# dump whenever one of your exceptions will pass code
# that is not compiled with exception handling.
# If you need exceptions remove the line below and
# be aware that you propably have to recompile your own
# Qt library as well.

linux-g++:TMAKE_CXXFLAGS += -fno-exceptions

HEADERS = \
    include/qwt_global.h \
    include/qwt.h \
    include/qwt_array.h \
    include/qwt_autoscl.h \
    include/qwt_curve.h \
    include/qwt_dimap.h \
    include/qwt_grid.h \
    include/qwt_legend.h \
    include/qwt_marker.h \
    include/qwt_math.h \
    include/qwt_painter.h \
    include/qwt_paint_buffer.h \
    include/qwt_plot.h \
    include/qwt_plot_layout.h \
    include/qwt_plot_printfilter.h \
    include/qwt_plot_classes.h \
    include/qwt_plot_item.h \
    include/qwt_plot_dict.h \
    include/qwt_plot_canvas.h \
    include/qwt_rect.h \
    include/qwt_scale.h \
    include/qwt_scldiv.h \
    include/qwt_scldraw.h \
    include/qwt_spline.h \
    include/qwt_symbol.h \
    include/qwt_dyngrid_layout.h

SOURCES = \
    src/qwt_autoscl.cpp \
    src/qwt_curve.cpp \
    src/qwt_dimap.cpp \
    src/qwt_grid.cpp \
    src/qwt_legend.cpp \
    src/qwt_marker.cpp \
    src/qwt_math.cpp \
    src/qwt_painter.cpp \
    src/qwt_paint_buffer.cpp \
    src/qwt_plot.cpp \
    src/qwt_plot_axis.cpp \
    src/qwt_plot_curve.cpp \
    src/qwt_plot_grid.cpp \
    src/qwt_plot_item.cpp \
    src/qwt_plot_print.cpp \
    src/qwt_plot_marker.cpp \
    src/qwt_plot_layout.cpp \
    src/qwt_plot_printfilter.cpp \
    src/qwt_plot_canvas.cpp \
    src/qwt_rect.cpp \
    src/qwt_scale.cpp \
    src/qwt_scldiv.cpp \
    src/qwt_scldraw.cpp \
    src/qwt_spline.cpp \
    src/qwt_symbol.cpp \
    src/qwt_dyngrid_layout.cpp
 
##############################################
# If you are interested in the plot widget
# only, you can remove the following 
# HEADERS/SOURCES lists.
##############################################

HEADERS += \
    include/qwt_arrbtn.h \
    include/qwt_compass.h \
    include/qwt_compass_rose.h \
    include/qwt_dial.h \
    include/qwt_dial_needle.h \
    include/qwt_counter.h \
    include/qwt_drange.h \
    include/qwt_knob.h \
    include/qwt_sclif.h \
    include/qwt_sldbase.h \
    include/qwt_slider.h \
    include/qwt_thermo.h \
    include/qwt_wheel.h

SOURCES += \
    src/qwt_arrbtn.cpp \
    src/qwt_compass.cpp \
    src/qwt_compass_rose.cpp \
    src/qwt_dial.cpp \
    src/qwt_dial_needle.cpp \
    src/qwt_counter.cpp \
    src/qwt_drange.cpp \
    src/qwt_knob.cpp \
    src/qwt_sclif.cpp \
    src/qwt_sldbase.cpp \
    src/qwt_slider.cpp \
    src/qwt_thermo.cpp \
    src/qwt_wheel.cpp
