/* -*- mode: C++ ; c-file-style: "stroustrup" -*- *****************************
 * Qwt Widget Library
 * Copyright (C) 1997   Josef Wilgen
 * Copyright (C) 2002   Uwe Rathmann
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the Qwt License, Version 1.0
 *****************************************************************************/

#include "qwt_rect.h"

//! Constructor

QwtRect::QwtRect(): 
    QRect() 
{
}

//! Copy constructor
QwtRect::QwtRect(const QRect &r): 
    QRect(r) 
{
}

QRect QwtRect::cutTop(int h, int distTop, int distBottom)
{
    QRect rv;
    rv.setTop(top() + distTop);
    rv.setHeight(h);
    setTop(rv.bottom() + distBottom + 1);
    rv.setLeft(left());
    rv.setRight(right());
    return rv;
}


QRect QwtRect::cutBottom(int h, int distTop, int distBottom)
{
    QRect rv;
    setBottom(bottom() - h - distBottom - distTop);
    rv.setTop(bottom() + 1 + distTop);
    rv.setHeight(h);
    rv.setLeft(left());
    rv.setRight(right());
    return rv;
}

QRect QwtRect::cutLeft(int w, int distLeft, int distRight)
{
    QRect rv;
    rv.setLeft(left() + distLeft);
    rv.setWidth(w);
    setLeft(rv.right() + distRight + 1);
    rv.setTop(top());
    rv.setBottom(bottom());
    return rv;
}


QRect QwtRect::cutRight(int w, int distLeft, int distRight)
{
    QRect rv;
    setRight(right() - w - distRight - distLeft);
    rv.setLeft(right() + 1 + distLeft);
    rv.setWidth(w);
    rv.setTop(top());
    rv.setBottom(bottom());
    return rv;
}

const QwtRect& QwtRect::cutMargin(int mLeft, int mRight, int mTop, int mBottom)
{
    setHeight(height() - mTop - mBottom);
    setWidth(width() - mLeft - mRight);
    moveBy(mLeft, mTop);
    return *this;
}
