/***************************************************************************
                          generator.cpp  -  description
                             -------------------
    begin                : Mon Feb  4 17:11:52 CET 2002
    copyright            : (C) 2002 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <ctype.h>
#include <stdio.h>
#include "generator.h"
#include "qdatetime.h"

#define ENDL "\n"

void lowerString(char *s)
{
  while(*s != '\0') { *s = tolower(*s); s++; }
}

Generator::Generator()
{
  language = LANGUAGE_C;
  codec = QTextCodec::codecForName("utf8");
}

Generator::~Generator()
{
}

void Generator::setFormat(const char *Language)
{
  if(strcmp(Language,"c"  )    == 0) language = LANGUAGE_C;
  if(strcmp(Language,"cpp")    == 0) language = LANGUAGE_C;
  if(strcmp(Language,"python") == 0) language = LANGUAGE_PYTHON;
  if(strcmp(Language,"php")    == 0) language = LANGUAGE_PHP;
  if(strcmp(Language,"perl")   == 0) language = LANGUAGE_PERL;
  if(strcmp(Language,"tcl")    == 0) language = LANGUAGE_TCL;
  if(strcmp(Language,"pvb")    == 0) language = LANGUAGE_PVB;
}

void Generator::generateTabOrder(ofstream &fout, QDomDocument *uidoc)
{
  unsigned int i;
  QDomNodeList nodes;
  QDomNode node;
  QString id1,id2;

  nodes = uidoc->elementsByTagName("tabstops");
  if(nodes.count() <= 0) return;
  node  = nodes.item(0);
  QDomNodeList childs = node.childNodes();

  for(i=0; i<childs.count()-1; i++)
  {
    id1 = childs.item(i).toElement().text();
    id2 = childs.item(i+1).toElement().text();
    if(language == LANGUAGE_C)
    {
      fout << "  pvTabOrder(p," << id1 << "," << id2 << ");" << ENDL;
    }
    else if(language == LANGUAGE_PYTHON)
    {
      fout << "  ret = pvs.pvTabOrder(p,self." << id1 << ",self." << id2 << ")" << ENDL;
    }
    else if(language == LANGUAGE_PERL)
    {
      fout << "  $ret = pv::pvTabOrder($p,$" << id1 << ",$" << id2 << ");" << ENDL;
    }
    else if(language == LANGUAGE_PHP)
    {
      fout << "  $ret = pvTabOrder($p,$this->" << id1 << ",$this->" << id2 << ");" << ENDL;
    }
    else if(language == LANGUAGE_TCL)
    {
      fout << "  pvTabOrder $p $this::" << id1 << " $this::" << id2 << ENDL;
    }
    else if(language == LANGUAGE_PVB)
    {
    }
  }
}

void Generator::generateHeader(ofstream &fout, QStringList *clist)
{
  if(clist->isEmpty())
  {
    if(language == LANGUAGE_C)
    {
      fout << "////////////////////////////////////////////////////////////////////////////" << ENDL;
      fout << "//"                                                                           << ENDL;
      fout << "// show_" << maskname << " for ProcessViewServer created: " << QDateTime::currentDateTime().toString() << ENDL;
      fout << "//"                                                                           << ENDL;
      fout << "////////////////////////////////////////////////////////////////////////////" << ENDL;
      fout << "#include \"pvapp.h\""                                                         << ENDL;
      fout << ""                                                                             << ENDL;
      fout << "// _begin_of_generated_area_ (do not edit -> use ui2pvc) -------------------" << ENDL;
    }
    else if(language == LANGUAGE_PYTHON)
    {
      fout << "#////////////////////////////////////////////////////////////////////////////" << ENDL;
      fout << "#//"                                                                           << ENDL;
      fout << "#// show_" << maskname << " for ProcessViewServer created: " << QDateTime::currentDateTime().toString() << ENDL;
      fout << "#//"                                                                           << ENDL;
      fout << "#////////////////////////////////////////////////////////////////////////////" << ENDL;
      fout << "import string"                                                                              << ENDL;
      fout << ""                                                                              << ENDL;
      fout << "#// _begin_of_generated_area_ (do not edit -> use ui2pvc) -------------------" << ENDL;
    }
    else if(language == LANGUAGE_PERL)
    {
      fout << "#////////////////////////////////////////////////////////////////////////////" << ENDL;
      fout << "#//"                                                                           << ENDL;
      fout << "#// show_" << maskname << " for ProcessViewServer created: " << QDateTime::currentDateTime().toString() << ENDL;
      fout << "#//"                                                                           << ENDL;
      fout << "#////////////////////////////////////////////////////////////////////////////" << ENDL;
      fout << "package " << maskname << ";"                                                   << ENDL;
      fout << "use String::Scanf;"                                                                              << ENDL;
      fout << ""                                                                              << ENDL;
      fout << "#// _begin_of_generated_area_ (do not edit -> use ui2pvc) -------------------" << ENDL;
    }
    else if(language == LANGUAGE_PHP)
    {
      fout << "<?php"                                                                           << ENDL;
      fout << "#///////////////////////////////////////////////////////////////////////////" << ENDL;
      fout << "#//"                                                                          << ENDL;
      fout << "#// show_" << maskname << " for ProcessViewServer created: " << QDateTime::currentDateTime().toString() << ENDL;
      fout << "#//"                                                                          << ENDL;
      fout << "#///////////////////////////////////////////////////////////////////////////" << ENDL;
      fout << ""                                                                             << ENDL;
      fout << "class " << maskname                                                           << ENDL;
      fout << "{"                                                                            << ENDL;
      fout << "  #// _begin_of_generated_area_ (do not edit -> use ui2pvc) ----------------" << ENDL;
    }
    else if(language == LANGUAGE_TCL)
    {
      fout << "#////////////////////////////////////////////////////////////////////////////" << ENDL;
      fout << "#//"                                                                           << ENDL;
      fout << "#// show_" << maskname << " for ProcessViewServer created: " << QDateTime::currentDateTime().toString() << ENDL;
      fout << "#//"                                                                           << ENDL;
      fout << "#////////////////////////////////////////////////////////////////////////////" << ENDL;
      fout << "namespace eval " << maskname << " {"                                           << ENDL;
      fout << "  namespace eval this {"                                                       << ENDL;
      fout << "    # _begin_of_generated_area_ (do not edit -> use ui2pvc) -----------------" << ENDL;
    }
  }
  else if(language != LANGUAGE_PVB)
  {
    QValueList<QString>::Iterator str;
    for(str=clist->begin(); str != clist->end(); str++)
    {
      fout << *str << ENDL;
      if(strstr(*str,"_begin_of_generated_area_") != NULL) return;
    }
  }
}

void Generator::generateTrailer(ofstream &fout, QStringList *clist)
{
  if(clist->isEmpty())
  {
    if(language == LANGUAGE_C)
    {
      fout << "// _end_of_generated_area_ (do not edit -> use ui2pvc) ---------------------" << ENDL;
      fout << ""                                                                        << ENDL;
      fout << "#include \"" << maskname << "_slots.h\""                               << ENDL;
      fout << ""                                                                        << ENDL;
      fout << "static int defineMask(PARAM *p)"                                         << ENDL;
      fout << "{"                                                                       << ENDL;
      fout << "  if(p == NULL) return 1;"                                               << ENDL;
      fout << "  generated_defineMask(p);"                                              << ENDL;
      fout << "  // (todo: add your code here)"                                         << ENDL;
      fout << "  return 0;"                                                             << ENDL;
      fout << "}"                                                                       << ENDL;
      fout << ""                                                                        << ENDL;
      fout << ""                                                                        << ENDL;
      fout << "static int showData(PARAM *p, DATA *d)"                                  << ENDL;
      fout << "{"                                                                       << ENDL;
      fout << "  if(p == NULL) return 1;"                                               << ENDL;
      fout << "  if(d == NULL) return 1;"                                               << ENDL;
      fout << "  return 0;"                                                             << ENDL;
      fout << "}"                                                                       << ENDL;
      fout <<                                                                              ENDL;
      fout << "static int readData(DATA *d) // from shared memory, database or something else" << ENDL;
      fout << "{"                                                                       << ENDL;
      fout << "  if(d == NULL) return 1;"                                               << ENDL;
      fout << "  // (todo: add your code here)"                                         << ENDL;
      fout << "  return 0;"                                                             << ENDL;
      fout << "}"                                                                       << ENDL;
      fout <<                                                                              ENDL;
      fout <<                                                                              ENDL;
      fout << "int show_" << maskname << "(PARAM *p)"                                   << ENDL;
      fout << "{"                                                                       << ENDL;
      fout << "  DATA d;"                                                               << ENDL;
      fout << "  char event[MAX_EVENT_LENGTH];"                                         << ENDL;
      fout << "  char text[MAX_EVENT_LENGTH];"                                          << ENDL;
      fout << "  char str1[MAX_EVENT_LENGTH];"                                          << ENDL;
      fout << "  int  i,w,h,val,x,y,button,ret;"                                        << ENDL;
      fout << "  float xval, yval;"                                                     << ENDL;
      fout <<                                                                              ENDL;
      fout << "  defineMask(p);"                                                        << ENDL;
      fout << "  //rlSetDebugPrintf(1);"                                                << ENDL;
      fout << "  if((ret=slotInit(p,&d)) != 0) return ret;"                             << ENDL;
      fout << "  readData(&d); // from shared memory, database or something else"       << ENDL;
      fout << "  showData(p,&d);"                                                       << ENDL;
      fout << "  while(1)"                                                              << ENDL;
      fout << "  {"                                                                     << ENDL;
      fout << "    pvPollEvent(p,event);"                                               << ENDL;
      fout << "    switch(pvParseEvent(event, &i, text))"                               << ENDL;
      fout << "    {"                                                                   << ENDL;
      fout << "      case NULL_EVENT:"                                                  << ENDL;
      fout << "        readData(&d); // from shared memory, database or something else" << ENDL;
      fout << "        showData(p,&d);"                                                 << ENDL;
      fout << "        if((ret=slotNullEvent(p,&d)) != 0) return ret;"                  << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case BUTTON_EVENT:"                                                << ENDL;
      fout << "        printf(\"BUTTON_EVENT id=%d\\n\",i);"                            << ENDL;
      fout << "        if((ret=slotButtonEvent(p,i,&d)) != 0) return ret;"              << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case BUTTON_PRESSED_EVENT:"                                        << ENDL;
      fout << "        printf(\"BUTTON_PRESSED_EVENT id=%d\\n\",i);"                    << ENDL;
      fout << "        if((ret=slotButtonPressedEvent(p,i,&d)) != 0) return ret;"       << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case BUTTON_RELEASED_EVENT:"                                       << ENDL;
      fout << "        printf(\"BUTTON_RELEASED_EVENT id=%d\\n\",i);"                   << ENDL;
      fout << "        if((ret=slotButtonReleasedEvent(p,i,&d)) != 0) return ret;"      << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case TEXT_EVENT:"                                                  << ENDL;
      fout << "        printf(\"TEXT_EVENT id=%d %s\\n\",i,text);"                      << ENDL;
      fout << "        if((ret=slotTextEvent(p,i,&d,text)) != 0) return ret;"           << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case SLIDER_EVENT:"                                                << ENDL;
      fout << "        sscanf(text,\"(%d)\",&val);"                                     << ENDL;
      fout << "        printf(\"SLIDER_EVENT val=%d\\n\",val);"                         << ENDL;
      fout << "        if((ret=slotSliderEvent(p,i,&d,val)) != 0) return ret;"          << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case CHECKBOX_EVENT:"                                              << ENDL;
      fout << "        printf(\"CHECKBOX_EVENT id=%d %s\\n\",i,text);"                  << ENDL;
      fout << "        if((ret=slotCheckboxEvent(p,i,&d,text)) != 0) return ret;"       << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case RADIOBUTTON_EVENT:"                                           << ENDL;
      fout << "        printf(\"RADIOBUTTON_EVENT id=%d %s\\n\",i,text);"               << ENDL;
      fout << "        if((ret=slotRadioButtonEvent(p,i,&d,text)) != 0) return ret;"    << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case GL_INITIALIZE_EVENT:"                                         << ENDL;
      fout << "        printf(\"you have to call initializeGL()\\n\");"                 << ENDL;
      fout << "        if((ret=slotGlInitializeEvent(p,i,&d)) != 0) return ret;"        << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case GL_PAINT_EVENT:"                                              << ENDL;
      fout << "        printf(\"you have to call paintGL()\\n\");"                      << ENDL;
      fout << "        if((ret=slotGlPaintEvent(p,i,&d)) != 0) return ret;"             << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case GL_RESIZE_EVENT:"                                             << ENDL;
      fout << "        sscanf(text,\"(%d,%d)\",&w,&h);"                                 << ENDL;
      fout << "        printf(\"you have to call resizeGL(w,h)\\n\");"                  << ENDL;
      fout << "        if((ret=slotGlResizeEvent(p,i,&d,w,h)) != 0) return ret;"        << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case GL_IDLE_EVENT:"                                               << ENDL;
      fout << "        if((ret=slotGlIdleEvent(p,i,&d)) != 0) return ret;"              << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case TAB_EVENT:"                                                   << ENDL;
      fout << "        sscanf(text,\"(%d)\",&val);"                                     << ENDL;
      fout << "        printf(\"TAB_EVENT(%d,page=%d)\\n\",i,val);"                     << ENDL;
      fout << "        if((ret=slotTabEvent(p,i,&d,val)) != 0) return ret;"             << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case TABLE_TEXT_EVENT:"                                            << ENDL;
      fout << "        sscanf(text,\"(%d,%d,\",&x,&y);"                                 << ENDL;
      fout << "        pvGetText(text,str1);"                                           << ENDL;
      fout << "        printf(\"TABLE_TEXT_EVENT(%d,%d,\\\"%s\\\")\\n\",x,y,str1);"     << ENDL;
      fout << "        if((ret=slotTableTextEvent(p,i,&d,x,y,str1)) != 0) return ret;"  << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case TABLE_CLICKED_EVENT:"                                         << ENDL;
      fout << "        sscanf(text,\"(%d,%d,%d)\",&x,&y,&button);"                      << ENDL;
      fout << "        printf(\"TABLE_CLICKED_EVENT(%d,%d,button=%d)\\n\",x,y,button);" << ENDL;
      fout << "        if((ret=slotTableClickedEvent(p,i,&d,x,y,button)) != 0) return ret;" << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case SELECTION_EVENT:"                                             << ENDL;
      fout << "        sscanf(text,\"(%d,\",&val);"                                     << ENDL;
      fout << "        pvGetText(text,str1);"                                           << ENDL;
      fout << "        printf(\"SELECTION_EVENT(column=%d,\\\"%s\\\")\\n\",val,str1);"  << ENDL;
      fout << "        if((ret=slotSelectionEvent(p,i,&d,val,str1)) != 0) return ret;"  << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case CLIPBOARD_EVENT:"                                             << ENDL;
      fout << "        sscanf(text,\"(%d\",&val);"                                      << ENDL;
      fout << "        printf(\"CLIPBOARD_EVENT(id=%d)\\n\",val);"                      << ENDL;
      fout << "        printf(\"clipboard = \\n%s\\n\",p->clipboard);"                  << ENDL;
      fout << "        if((ret=slotClipboardEvent(p,i,&d,val)) != 0) return ret;"       << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case RIGHT_MOUSE_EVENT:"                                           << ENDL;
      fout << "        printf(\"RIGHT_MOUSE_EVENT id=%d text=%s\\n\",i,text);"          << ENDL;
      fout << "        if((ret=slotRightMouseEvent(p,i,&d,text)) != 0) return ret;"     << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case KEYBOARD_EVENT:"                                              << ENDL;
      fout << "        sscanf(text,\"(%d\",&val);"                                      << ENDL;
      fout << "        printf(\"KEYBOARD_EVENT modifier=%d key=%d\\n\",i,val);"         << ENDL;
      fout << "        if((ret=slotKeyboardEvent(p,i,&d,val)) != 0) return ret;"        << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case PLOT_MOUSE_MOVED_EVENT:"                                      << ENDL;
      fout << "        sscanf(text,\"(%f,%f)\",&xval,&yval);"                           << ENDL;
      fout << "        printf(\"PLOT_MOUSE_MOVE %f %f\\n\",xval,yval);"                 << ENDL;
      fout << "        if((ret=slotMouseMovedEvent(p,i,&d,xval,yval)) != 0) return ret;"<< ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case PLOT_MOUSE_PRESSED_EVENT:"                                    << ENDL;
      fout << "        sscanf(text,\"(%f,%f)\",&xval,&yval);"                           << ENDL;
      fout << "        printf(\"PLOT_MOUSE_PRESSED %f %f\\n\",xval,yval);"              << ENDL;
      fout << "        if((ret=slotMousePressedEvent(p,i,&d,xval,yval)) != 0) return ret;" << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case PLOT_MOUSE_RELEASED_EVENT:"                                   << ENDL;
      fout << "        sscanf(text,\"(%f,%f)\",&xval,&yval);"                           << ENDL;
      fout << "        printf(\"PLOT_MOUSE_RELEASED %f %f\\n\",xval,yval);"             << ENDL;
      fout << "        if((ret=slotMouseReleasedEvent(p,i,&d,xval,yval)) != 0) return ret;" << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      case USER_EVENT:"                                                  << ENDL;
      fout << "        printf(\"USER_EVENT id=%d %s\\n\",i,text);"                      << ENDL;
      fout << "        if((ret=slotUserEvent(p,i,&d,text)) != 0) return ret;"           << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "      default:"                                                          << ENDL;
      fout << "        printf(\"UNKNOWN_EVENT id=%d %s\\n\",i,text);"                   << ENDL;
      fout << "        break;"                                                          << ENDL;
      fout << "    }"                                                                   << ENDL;
      fout << "  }"                                                                     << ENDL;
      fout << "}"                                                                       << ENDL;
      generateSlots();
    }
    else if(language == LANGUAGE_PYTHON)
    {
      fout << "  #// _end_of_generated_area_ (do not edit -> use ui2pvc) ---------------------" << ENDL;
      fout << ""                                                                        << ENDL;
      fout << "  def defineMask(self,pvs,p):"                                           << ENDL;
      fout << "    ret = self.generated_defineMask(pvs,p)"                              << ENDL;
      fout << "    # (todo: add your code here)"                                        << ENDL;
      fout << "    return 0"                                                            << ENDL;
      fout << ""                                                                        << ENDL;
      fout << "  def showData(self,pvs,p):"                                             << ENDL;
      fout << "    # (todo: add your code here)"                                        << ENDL;
      fout << "    return 0"                                                            << ENDL;
      fout <<                                                                              ENDL;
      fout << "  def readData(self,pvs,p): # from shared memory, database or something else"  << ENDL;
      fout << "    # (todo: add your code here)"                                        << ENDL;
      fout << "    return 0"                                                            << ENDL;
      fout <<                                                                              ENDL;
      fout << "  def show(self,pvs,p):"                                                 << ENDL;
      fout << "    text = event = str1 = \"\""                                          << ENDL;
      fout << "    val = x = y = button = 0"                                            << ENDL;
      fout << "    ret = self.defineMask(pvs,p)"                                        << ENDL;
      fout << "    ret = self.readData(pvs,p) # from shared memory, database or something else" << ENDL;
      fout << "    ret = self.showData(pvs,p)"                                          << ENDL;
      fout << "    while 1:"                                                            << ENDL;
      fout << "      event  = pvs.pvGetEvent(p)"                                        << ENDL;
      fout << "      result = pvs.pvParseEventStruct(p,event)"                          << ENDL;
      fout << "      id     = result.event"                                             << ENDL;
      fout << "      i      = result.i"                                                 << ENDL;
      fout << "      text   = result.text"                                              << ENDL;
      fout << "      if id == pvs.NULL_EVENT:"                                          << ENDL;
      fout << "        ret = self.readData(pvs,p) # from shared memory, database or something else" << ENDL;
      fout << "        ret = self.showData(pvs,p)"                                      << ENDL;
      fout << "      elif id == pvs.BUTTON_EVENT:"                                      << ENDL;
      fout << "        print 'BUTTON_EVENT id=', i"                                     << ENDL;
      fout << "      elif id == pvs.BUTTON_PRESSED_EVENT:"                              << ENDL;
      fout << "        print 'BUTTON_PRESSED_EVENT id=' ,i"                             << ENDL;
      fout << "      elif id == pvs.BUTTON_RELEASED_EVENT:"                             << ENDL;
      fout << "        print 'BUTTON_RELEASED_EVENT id=' ,i"                            << ENDL;
      fout << "      elif id == pvs.TEXT_EVENT:"                                        << ENDL;
      fout << "        print 'TEXT_EVENT id=',i,' text=',text"                          << ENDL;
      fout << "      elif id == pvs.SLIDER_EVENT:"                                      << ENDL;
      fout << "        val = eval(text)"                                                << ENDL;
      fout << "        print 'SLIDER_EVENT val=',val"                                   << ENDL;
      fout << "      elif id == pvs.CHECKBOX_EVENT:"                                    << ENDL;
      fout << "        print 'CHECKBOX_EVENT id=',i,' text=',text"                      << ENDL;
      fout << "      elif id == pvs.RADIOBUTTON_EVENT:"                                 << ENDL;
      fout << "        print 'RADIOBUTTON_EVENT id=',i,' text=',text"                   << ENDL;
      fout << "      elif id == pvs.GL_INITIALIZE_EVENT:"                               << ENDL;
      fout << "        print 'you have to call initializeGL()'"                         << ENDL;
      fout << "      elif id == pvs.GL_PAINT_EVENT:"                                    << ENDL;
      fout << "        print 'you have to call paintGL()'"                              << ENDL;
      fout << "      elif id == pvs.GL_RESIZE_EVENT:"                                   << ENDL;
      fout << "        #sscanf(text,\"(%d,%d)\",&w,&h);"                                << ENDL;
      fout << "        tmp = text[1:-1]"                                                << ENDL;
      fout << "        tmplist = string.split(tmp,',')"                                 << ENDL;
      fout << "        w = int(tmplist[0])"                                             << ENDL;
      fout << "        h = int(tmplist[1])"                                             << ENDL;
      fout << "        print 'you have to call resizeGL(',w,',',h,')'"                  << ENDL;
      fout << "      elif id == pvs.GL_IDLE_EVENT:"                                     << ENDL;
      fout << "        print 'glIdle()'"                                                << ENDL;
      fout << "      elif id == pvs.TAB_EVENT:"                                         << ENDL;
      fout << "        val = eval(text)"                                                << ENDL;
      fout << "        print 'TAB_EVENT ',i,' val=',val"                                << ENDL;
      fout << "      elif id == pvs.TABLE_TEXT_EVENT:"                                  << ENDL;
      fout << "        #sscanf(text,\"(%d,%d,\",&x,&y);"                                << ENDL;
      fout << "        tmp = text[1:-1]"                                                << ENDL;
      fout << "        tmplist = string.split(tmp,',')"                                 << ENDL;
      fout << "        x = int(tmplist[0])"                                             << ENDL;
      fout << "        y = int(tmplist[1])"                                             << ENDL;
      fout << "        str1 = pvs.pvGetTextParam(p,text)"                               << ENDL;
      fout << "        print 'TABLE_TEXT_EVENT x=' ,x , ' y=' ,y , ' str=', str1"       << ENDL;
      fout << "      elif id == pvs.TABLE_CLICKED_EVENT:"                               << ENDL;
      fout << "        #sscanf(text,\"(%d,%d,%d)\",&x,&y,&button);"                     << ENDL;
      fout << "        tmp = text[1:-1]"                                                << ENDL;
      fout << "        tmplist = string.split(tmp,',')"                                 << ENDL;
      fout << "        x = int(tmplist[0])"                                             << ENDL;
      fout << "        y = int(tmplist[1])"                                             << ENDL;
      fout << "        button = int(tmplist[2])"                                        << ENDL;
      fout << "        print 'TABLE_CLICKED_EVENT x=',x,' y=',y,' button=',button"      << ENDL;
      fout << "      elif id == pvs.SELECTION_EVENT:"                                   << ENDL;
      fout << "        val = eval(text)"                                                << ENDL;
      fout << "        str1 = pvs.pvGetTextParam(p,text)"                               << ENDL;
      fout << "        print 'SELECTION_EVENT(column=',val,' str1=',str1"               << ENDL;
      fout << "      elif id == pvs.CLIPBOARD_EVENT:"                                   << ENDL;
      fout << "        val = eval(text)"                                                << ENDL;
      fout << "        print 'CLIPBOARD_EVENT(id=' ,val"                                << ENDL;
      fout << "        print 'clipboard = ' ,p.clipboard"                               << ENDL;
      fout << "      elif id == pvs.RIGHT_MOUSE_EVENT:"                                 << ENDL;
      fout << "        print 'RIGHT_MOUSE_EVENT id=',i,' text=',text"                   << ENDL;
      fout << "        #ret = pvs.pvPopupMenu(p,-1,\"Menu1,Menu2,,Menu3\")"             << ENDL;
      fout << "      elif id == pvs.KEYBOARD_EVENT:"                                    << ENDL;
      fout << "        val = eval(text)"                                                << ENDL;
      fout << "        print 'KEYBOARD_EVENT modifier=',i,' val=',val"                  << ENDL;
      fout << "      elif id == pvs.PLOT_MOUSE_MOVED_EVENT:"                            << ENDL;
      fout << "        #sscanf(text,\"(%f,%f)\",&xval,&yval);"                          << ENDL;
      fout << "        print 'PLOT_MOUSE_MOVE'"                                         << ENDL;
      fout << "      elif id == pvs.PLOT_MOUSE_PRESSED_EVENT:"                          << ENDL;
      fout << "        #sscanf(text,\"(%f,%f)\",&xval,&yval);"                          << ENDL;
      fout << "        print 'PLOT_MOUSE_PRESSED'"                                      << ENDL;
      fout << "      elif id == pvs.PLOT_MOUSE_RELEASED_EVENT:"                         << ENDL;
      fout << "        #sscanf(text,\"(%f,%f)\",&xval,&yval);"                          << ENDL;
      fout << "        print 'PLOT_MOUSE_RELEASED'"                                     << ENDL;
      fout << "      elif id == pvs.USER_EVENT:"                                        << ENDL;
      fout << "        print 'USER_EVENT id=',i,' text=',text"                          << ENDL;
      fout << "      else:"                                                             << ENDL;
      fout << "        print 'UNKNOWN_EVENT id=',i,' text=',text"                       << ENDL;
    }
    else if(language == LANGUAGE_PERL)
    {
      fout << "#// _end_of_generated_area_ (do not edit -> use ui2pvc) ---------------------" << ENDL;
      fout << ""                                                                        << ENDL;
      fout << "sub defineMask"                                                          << ENDL;
      fout << "{"                                                                       << ENDL;
      fout << "  my $pv  = shift;"                                                      << ENDL;
      fout << "  my $p   = shift;"                                                      << ENDL;
      fout << "  $ret = generated_defineMask($pv,$p);"                                  << ENDL;
      fout << "  # (todo: add your code here)"                                          << ENDL;
      fout << "  return 0;"                                                             << ENDL;
      fout << "}"                                                                       << ENDL;
      fout << ""                                                                        << ENDL;
      fout << "sub showData"                                                            << ENDL;
      fout << "{"                                                                       << ENDL;
      fout << "  my $pv  = shift;"                                                      << ENDL;
      fout << "  my $p   = shift;"                                                      << ENDL;
      fout << "  # (todo: add your code here)"                                          << ENDL;
      fout << "  return 0;"                                                             << ENDL;
      fout << "}"                                                                       << ENDL;
      fout <<                                                                              ENDL;
      fout << "sub readData # from shared memory, database or something else"           << ENDL;
      fout << "{"                                                                       << ENDL;
      fout << "  my $pv  = shift;"                                                      << ENDL;
      fout << "  my $p   = shift;"                                                      << ENDL;
      fout << "  # (todo: add your code here)"                                          << ENDL;
      fout << "  return 0;"                                                             << ENDL;
      fout << "}"                                                                       << ENDL;
      fout <<                                                                            ENDL;
      fout << "sub show"                                                              << ENDL;
      fout << "{"                                                                     << ENDL;
      fout << "  my $obj = shift;"                                                    << ENDL;
      fout << "  my $pv  = shift;"                                                    << ENDL;
      fout << "  my $p   = shift;"                                                    << ENDL;
      fout << "  $text = $event = $str1 = \"\";"                                      << ENDL;
      fout << "  $val = $x = $y = $button = 0;"                                       << ENDL;
      fout << "  $ret = defineMask($pv,$p);"                                          << ENDL;
      fout << "  $ret = readData($pv,$p); # from shared memory, database or something else" << ENDL;
      fout << "  $ret = showData($pv,$p);"                                            << ENDL;
      fout << "  while(1)"                                                            << ENDL;
      fout << "  {"                                                                   << ENDL;
      fout << "    $event  = pv::pvGetEvent($p);"                                     << ENDL;
      fout << "    $result = pv::pvParseEventStruct($p,$event);"                      << ENDL;
      fout << "    $id     = pv::PARSE_EVENT_STRUCT_event_get($result);"              << ENDL;
      fout << "    $i      = pv::PARSE_EVENT_STRUCT_i_get($result);"                  << ENDL;
      fout << "    $text   = pv::PARSE_EVENT_STRUCT_text_get($result);"               << ENDL;
      fout << "    if($id == $pv::NULL_EVENT)"                                        << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      $ret = readData($pv,$p); # from shared memory, database or something else" << ENDL;
      fout << "      $ret = showData($pv,$p);"                                        << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::BUTTON_EVENT)"                                   << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      print \"BUTTON_EVENT id=\", $i, \"\\n\";"                        << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::BUTTON_PRESSED_EVENT)"                           << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      print \"BUTTON_PRESSED_EVENT id=\", $i, \"\\n\";"                << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::BUTTON_RELEASED_EVENT)"                          << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      print \"BUTTON_RELEASED_EVENT id=\", $i, \"\\n\";"               << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::TEXT_EVENT)"                                     << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      print \"TEXT_EVENT id=\", $i,\" text=\", $text, \"\\n\";"        << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::SLIDER_EVENT)"                                   << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      ($val) = sscanf(\"(%d)\",$text);"                                << ENDL;
      fout << "      print \"SLIDER_EVENT val=\", $val, \"\\n\";"                     << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::CHECKBOX_EVENT)"                                 << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      print \"CHECKBOX_EVENT id=\", $i, \" text=\", $text, \"\\n\";"   << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::RADIOBUTTON_EVENT)"                              << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      print \"RADIOBUTTON_EVENT id=\", $i, \" text=\", $text, \"\\n\";"<< ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::GL_INITIALIZE_EVENT)"                            << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      print \"you have to call initializeGL()\\n\";"                   << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::GL_PAINT_EVENT)"                                 << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      print \"you have to call paintGL()\\n\";"                        << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::GL_RESIZE_EVENT)"                                << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      ($w, $h) = sscanf(\"(%d,%d)\",$text);"                           << ENDL;
      fout << "      print \"you have to call resizeGL(\",$w,\",\",$h,\")\\n;\""      << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::GL_IDLE_EVENT)"                                  << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      print \"glIdle()\\n\";"                                          << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::TAB_EVENT)"                                      << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      ($val) = sscanf(\"(%d)\",$text);"                                << ENDL;
      fout << "      print \"TAB_EVENT \",$i,\" val=\",$val,\"\\n\";"                 << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::TABLE_TEXT_EVENT)"                               << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      ($x, $y) = sscanf(\"(%d,%d)\",$text);"                           << ENDL;
      fout << "      $str1 = pv::pvGetTextParam($p,$text);"                           << ENDL;
      fout << "      print \"TABLE_TEXT_EVENT x=\" ,$x , \" y=\" ,$y , \" str=\", $str1, \"\\n\";" << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::TABLE_CLICKED_EVENT)"                            << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      ($x, $y, $button) = sscanf(\"(%d,%d,%d)\",$text);"               << ENDL;
      fout << "      print \"TABLE_CLICKED_EVENT x=\",$x,\" y=\",$y,\" button=\",$button,\"\\n\";" << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::SELECTION_EVENT)"                                << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      ($val) = sscanf(\"(%d)\",$text);"                                << ENDL;
      fout << "      $str1 = pv::pvGetTextParam($p,$text);"                           << ENDL;
      fout << "      print \"SELECTION_EVENT(column=\",$val,\" str1=\",$str1,\"\\n\";"<< ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::CLIPBOARD_EVENT)"                                << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      ($val) = sscanf(\"(%d)\",$text);"                                << ENDL;
      fout << "      print \"CLIPBOARD_EVENT(id=\" ,$val, \"\\n\";"                   << ENDL;
      fout << "      print \"clipboard = \" ,$p.clipboard,\"\\n\";"                   << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::RIGHT_MOUSE_EVENT)"                              << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      print \"RIGHT_MOUSE_EVENT id=\" ,$i, \"text=\",$text,\"\\n\";"   << ENDL;
      fout << "      #$ret = pv.pvPopupMenu($p,-1,\"Menu1,Menu2,,Menu3\\n\");"        << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::KEYBOARD_EVENT)"                                 << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      ($val) = sscanf(\"(%d)\",$text);"                                << ENDL;
      fout << "      print \"KEYBOARD_EVENT modifier=\",$i,\" val=\",$val,\"\\n\";"   << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::PLOT_MOUSE_MOVED_EVENT)"                         << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      ($xval, $yval) = sscanf(\"(%f,%f)\",$text);"                     << ENDL;
      fout << "      print \"PLOT_MOUSE_MOVE \", $xval, \" \", $yval ,\"\\n\";"       << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::PLOT_MOUSE_PRESSED_EVENT)"                       << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      ($xval, $yval) = sscanf(\"(%f,%f)\",$text);"                     << ENDL;
      fout << "      print \"PLOT_MOUSE_PRESSED \", $xval, \" \", $yval ,\"\\n\";"    << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::PLOT_MOUSE_RELEASED_EVENT)"                      << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      ($xval, $yval) = sscanf(\"(%f,%f)\",$text);"                     << ENDL;
      fout << "      print \"PLOT_MOUSE_RELEASED \", $xval, \" \", $yval ,\"\\n\";"   << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    elsif($id == $pv::USER_EVENT)"                                     << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      print \"USER_EVENT id=\", $i,\" text=\", $text, \"\\n\";"        << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "    else"                                                              << ENDL;
      fout << "    {"                                                                 << ENDL;
      fout << "      print \"UNKNOWN_EVENT id=\",$id, \" i=\", $i,\" text=\",$text, \"\\n\";"       << ENDL;
      fout << "    }"                                                                 << ENDL;
      fout << "  }"                                                                   << ENDL;
      fout << "}"                                                                     << ENDL;
      fout << ""                                                                      << ENDL;
      fout << "1;"                                                                    << ENDL;
    }
    else if(language == LANGUAGE_PHP)
    {
      fout << "  #// _end_of_generated_area_ (do not edit -> use ui2pvc) -------------" << ENDL;
      fout << ""                                                                        << ENDL;
      fout << "  function defineMask($p)"                                               << ENDL;
      fout << "  {"                                                                     << ENDL;
      fout << "    $ret = $this->generated_defineMask($p);"                             << ENDL;
      fout << "    # (todo: add your code here)"                                        << ENDL;
      fout << "    return 0;"                                                           << ENDL;
      fout << "  }"                                                                     << ENDL;
      fout << ""                                                                        << ENDL;
      fout << "  function showData($p)"                                                 << ENDL;
      fout << "  {"                                                                     << ENDL;
      fout << "    # (todo: add your code here)"                                        << ENDL;
      fout << "    return 0;"                                                           << ENDL;
      fout << "  }"                                                                     << ENDL;
      fout <<                                                                              ENDL;
      fout << "  function readData($p) # from shared memory, database or something else"<< ENDL;
      fout << "  {"                                                                     << ENDL;
      fout << "    # (todo: add your code here)"                                        << ENDL;
      fout << "    return 0;"                                                           << ENDL;
      fout << "  }"                                                                     << ENDL;
      fout <<                                                                              ENDL;
      fout << "  function show($p)"                                                     << ENDL;
      fout << "  {"                                                                     << ENDL;
      fout << "    $text = $event = $str1 = \"\";"                                      << ENDL;
      fout << "    $val = $x = $y = $button = 0;"                                       << ENDL;
      fout << "    $ret = $this->defineMask($p);"                                       << ENDL;
      fout << "    $ret = $this->readData($p); # from shared memory, database or something else" << ENDL;
      fout << "    $ret = $this->showData($p);"                                         << ENDL;
      fout << "    while(1)"                                                            << ENDL;
      fout << "    {"                                                                   << ENDL;
      fout << "      $event  = pvGetEvent($p);"                                         << ENDL;
      fout << "      $result = pvParseEventStruct($p,$event);"                          << ENDL;
      fout << "      $id     = $result->event;"                                         << ENDL;
      fout << "      $i      = $result->i;"                                             << ENDL;
      fout << "      $text   = $result->text;"                                          << ENDL;
      fout << "      if($id == NULL_EVENT)"                                             << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        $ret = $this->readData($p); # from shared memory, database or something else" << ENDL;
      fout << "        $ret = $this->showData($p);"                                     << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == BUTTON_EVENT)"                                       << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        echo \"BUTTON_EVENT id=$i\\n\";"                                 << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == BUTTON_PRESSED_EVENT)"                               << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        echo \"BUTTON_PRESSED_EVENT id=$i\\n\";"                         << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == BUTTON_RELEASED_EVENT)"                              << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        echo \"BUTTON_RELEASED_EVENT id=$i\\n\";"                        << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == TEXT_EVENT)"                                         << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        echo \"TEXT_EVENT id=$i text=$text\\n\";"                       << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == SLIDER_EVENT)"                                       << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        list($val) = sscanf($text,\"(%d)\");"                            << ENDL;
      fout << "        echo \"SLIDER_EVENT val=$val\\n\";"                              << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == CHECKBOX_EVENT)"                                     << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        echo \"CHECKBOX_EVENT id=$i text=$text\\n\";"                    << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == RADIOBUTTON_EVENT)"                                  << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        echo \"RADIOBUTTON_EVENT id=$i text=$text\\n\";"                 << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == GL_INITIALIZE_EVENT)"                                << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        echo \"you have to call initializeGL()\\n\";"                    << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == GL_PAINT_EVENT)"                                     << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        echo \"you have to call paintGL()\\n\";"                         << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == GL_RESIZE_EVENT)"                                    << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        list($w, $h) = sscanf($text,\"(%d,%d)\");"                       << ENDL;
      fout << "        echo \"you have to call resizeGL($w,$h)\\n\";"                   << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == GL_IDLE_EVENT)"                                      << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        echo \"glIdle()\\n\";"                                           << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == TAB_EVENT)"                                          << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        list($val) = sscanf($text,\"(%d)\");"                            << ENDL;
      fout << "        echo \"TAB_EVENT $i val=$val\\n\";"                              << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == TABLE_TEXT_EVENT)"                                   << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        list($x, $y) = sscanf($text,\"(%d,%d)\");"                       << ENDL;
      fout << "        $str1 = pvGetTextParam($p,$text);"                               << ENDL;
      fout << "        echo \"TABLE_TEXT_EVENT x=$x y=$y str=$str1\\n\";"               << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == TABLE_CLICKED_EVENT)"                                << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        list($x, $y, $button) = sscanf($text,\"(%d,%d,%d)\");"           << ENDL;
      fout << "        echo \"TABLE_CLICKED_EVENT x=$x y=$y button=$button\\n\";"       << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == SELECTION_EVENT)"                                    << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        list($val) = sscanf($text,\"(%d)\");"                            << ENDL;
      fout << "        $str1 = pvGetTextParam($p,$text);"                               << ENDL;
      fout << "        echo \"SELECTION_EVENT(column=$val str1=$str1\\n\";"             << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == CLIPBOARD_EVENT)"                                    << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        list($val) = sscanf($text,\"(%d)\");"                            << ENDL;
      fout << "        echo \"CLIPBOARD_EVENT(id=$val)\\n\";"                           << ENDL;
      fout << "        echo \"clipboard=$p->clipboard\\n\";"                            << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == RIGHT_MOUSE_EVENT)"                                  << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        echo \"RIGHT_MOUSE_EVENT id=$i text=$text\\n\";"                 << ENDL;
      fout << "        #$ret = pvPopupMenu($p,-1,\"Menu1,Menu2,,Menu3\\n\");"           << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == KEYBOARD_EVENT)"                                     << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        list($val) = sscanf($text,\"(%d)\");"                            << ENDL;
      fout << "        echo \"KEYBOARD_EVENT modifier=$i val=$val\\n\";"                << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == PLOT_MOUSE_MOVED_EVENT)"                             << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        list($xval, $yval) = sscanf(text,\"(%f,%f)\");"                  << ENDL;
      fout << "        echo \"PLOT_MOUSE_MOVE $xval $yval\\n\";"                        << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == PLOT_MOUSE_PRESSED_EVENT)"                           << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        list($xval, $yval) = sscanf(text,\"(%f,%f)\");"                  << ENDL;
      fout << "        echo \"PLOT_MOUSE_PRESSED $xval $yval\\n\";"                     << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == PLOT_MOUSE_RELEASED_EVENT)"                          << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        list($xval, $yval) = sscanf(text,\"(%f,%f)\");"                  << ENDL;
      fout << "        echo \"PLOT_MOUSE_RELEASED $xval $yval\\n\";"                    << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      elseif($id == USER_EVENT)"                                         << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        echo \"USER_EVENT id=$i text=$text\\n\";"                       << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "      else"                                                              << ENDL;
      fout << "      {"                                                                 << ENDL;
      fout << "        echo \"UNKNOWN_EVENT id=$id i=$i text=$text\\n\";"               << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "    }"                                                                   << ENDL;
      fout << "  }"                                                                     << ENDL;
      fout << "}"                                                                       << ENDL;
      fout << "?>"                                                                      << ENDL;
    }
    else if(language == LANGUAGE_TCL)
    {
      fout << "  # _end_of_generated_area_ (do not edit -> use ui2pvc) ---------------" << ENDL;
      fout << ""                                                                        << ENDL;
      fout << "  proc defineMask { p } {"                                               << ENDL;
      fout << "    generated_defineMask $p"                                             << ENDL;
      fout << "    # (todo: add your code here)"                                        << ENDL;
      fout << "    return 0"                                                            << ENDL;
      fout << "  }"                                                                     << ENDL;
      fout << ""                                                                        << ENDL;
      fout << "  proc showData { p } {"                                                 << ENDL;
      fout << "    # (todo: add your code here)"                                        << ENDL;
      fout << "    return 0"                                                            << ENDL;
      fout << "  }"                                                                     << ENDL;
      fout <<                                                                              ENDL;
      fout << "  proc readData { p } { # from shared memory, database or something else" << ENDL;
      fout << "    # (todo: add your code here)"                                        << ENDL;
      fout << "    return 0"                                                            << ENDL;
      fout << "  }"                                                                     << ENDL;
      fout <<                                                                              ENDL;
      fout << "  proc show { p } {"                                                     << ENDL;
      fout << "    set text  \"\""                                                      << ENDL;
      fout << "    set event \"\""                                                      << ENDL;
      fout << "    set str1  \"\""                                                      << ENDL;
      fout << "    set val    0"                                                        << ENDL;
      fout << "    set x      0"                                                        << ENDL;
      fout << "    set y      0"                                                        << ENDL;
      fout << "    set xval   0.0"                                                      << ENDL;
      fout << "    set yval   0.0"                                                      << ENDL;
      fout << "    set button 0"                                                        << ENDL;
      fout << "    defineMask $p"                                                       << ENDL;
      fout << "    # from shared memory, database or something else"                    << ENDL;
      fout << "    readData $p"                                                         << ENDL;
      fout << "    showData $p"                                                         << ENDL;
      fout << "    while { 1 } {"                                                       << ENDL;
      fout << "      set event [ pvGetEvent $p ]"                                       << ENDL;
      fout << "      set result [ pvParseEventStruct $p $event ]"                       << ENDL;
      fout << "      set id   [ $result cget -event ]"                                  << ENDL;
      fout << "      set i    [ $result cget -i ]"                                      << ENDL;
      fout << "      set text [ $result cget -text ]"                                   << ENDL;
      fout << "      if       { $id == $::NULL_EVENT } {"                               << ENDL;
      fout << "        # from shared memory, database or something else"                << ENDL;
      fout << "        readData $p"                                                     << ENDL;
      fout << "        showData $p"                                                     << ENDL;
      fout << "      } elseif { $id == $::BUTTON_EVENT } {"                             << ENDL;
      fout << "        puts [ format \"BUTTON_EVENT id=%d\" $i ]"                       << ENDL;
      fout << "      } elseif { $id == $::BUTTON_PRESSED_EVENT } {"                     << ENDL;
      fout << "        puts [ format \"BUTTON_PRESSED_EVENT id=%d\" $i ]"               << ENDL;
      fout << "      } elseif { $id == $::BUTTON_RELEASED_EVENT } {"                    << ENDL;
      fout << "        puts [ format \"BUTTON_RELEASED_EVENT id=%d\" $i ]"              << ENDL;
      fout << "      } elseif { $id == $::TEXT_EVENT } {"                               << ENDL;
      fout << "        puts [ format \"TEXT_EVENT id=%d text=%s\" $i $text ]"           << ENDL;
      fout << "      } elseif { $id == $::SLIDER_EVENT } {"                             << ENDL;
      fout << "        scan $text \"(%d)\" val"                                         << ENDL;
      fout << "        puts [ format \"SLIDER_EVENT val=%d\" $val ]"                    << ENDL;
      fout << "      } elseif { $id == $::CHECKBOX_EVENT } {"                           << ENDL;
      fout << "        puts [ format \"CHECKBOX_EVENT id=%d text=%s\" $i $text ]"       << ENDL;
      fout << "      } elseif { $id == $::RADIOBUTTON_EVENT } {"                        << ENDL;
      fout << "        puts [ format \"RADIOBUTTON_EVENT id=%d text=%s\" $i $text ]"    << ENDL;
      fout << "      } elseif { $id == $::GL_INITIALIZE_EVENT } {"                      << ENDL;
      fout << "        puts \"you have to call initializeGL()\""                        << ENDL;
      fout << "      } elseif { $id == $::GL_PAINT_EVENT } {"                           << ENDL;
      fout << "        puts \"you have to call paintGL()\""                             << ENDL;
      fout << "      } elseif { $id == $::GL_RESIZE_EVENT } {"                          << ENDL;
      fout << "        scan $text \"(%d,%d)\" w h"                                      << ENDL;
      fout << "        puts [ format \"you have to call resizeGL(%d,%d)\" $w $h ]"      << ENDL;
      fout << "      } elseif { $id == $::GL_IDLE_EVENT } {"                            << ENDL;
      fout << "        puts \"glIdle()\""                                               << ENDL;
      fout << "      } elseif { $id == $::TAB_EVENT } {"                                << ENDL;
      fout << "        scan $text \"(%d)\" val"                                         << ENDL;
      fout << "        puts [ format \"TAB_EVENT i=%d val=%d\" $i $val ]"               << ENDL;
      fout << "      } elseif { $id == $::TABLE_TEXT_EVENT } {"                         << ENDL;
      fout << "        scan $text \"(%d,%d)\" x y"                                      << ENDL;
      fout << "        set str1 [ pvGetTextParam $p $text ]"                            << ENDL;
      fout << "        puts [ format \"TABLE_TEXT_EVENT x=%d y=%d str=%s\" $x $y $str1 ]" << ENDL;
      fout << "      } elseif { $id == $::TABLE_CLICKED_EVENT } {"                      << ENDL;
      fout << "        scan $text \"(%d,%d,%d)\" x y button"                            << ENDL;
      fout << "        puts [ format \"TABLE_CLICKED_EVENT x=%d y=%d button=%d\" $x $y $button ]" << ENDL;
      fout << "      } elseif { $id == $::SELECTION_EVENT } {"                          << ENDL;
      fout << "        scan $text \"(%d)\" val"                                         << ENDL;
      fout << "        set str1 [ pvGetTextParam $p $text ]"                            << ENDL;
      fout << "        puts [ format \"SELECTION_EVENT(column=%d str1=%s\" $val $str1 ]" << ENDL;
      fout << "      } elseif { $id == $::CLIPBOARD_EVENT } {"                          << ENDL;
      fout << "        scan $text \"(%d)\" val"                                         << ENDL;
      fout << "        puts [ format \"CLIPBOARD_EVENT id=%d\" $val ]"                  << ENDL;
      fout << "        puts [ format \"clipboard = %s\" [ $p cget -clipboard ] ]"       << ENDL;
      fout << "      } elseif { $id == $::RIGHT_MOUSE_EVENT } {"                        << ENDL;
      fout << "        puts [ format \"RIGHT_MOUSE_EVENT id=%d\" $i \"text=\" $text]"   << ENDL;
      fout << "        # pvPopupMenu $p -1 \"Menu1,Menu2,,Menu3\""                      << ENDL;
      fout << "      } elseif { $id == $::KEYBOARD_EVENT } {"                           << ENDL;
      fout << "        scan $text \"(%d)\" val"                                         << ENDL;
      fout << "        puts [ format \"KEYBOARD_EVENT modifier=%d val=%d\" $i $val ]"   << ENDL;
      fout << "      } elseif { $id == $::PLOT_MOUSE_MOVED_EVENT } {"                   << ENDL;
      fout << "        scan $text \"(%f,%f)\" xval yval"                                << ENDL;
      fout << "        puts [ format \"PLOT_MOUSE_MOVE %f %f\" $xval $yval ]"           << ENDL;
      fout << "      } elseif { $id == $::PLOT_MOUSE_PRESSED_EVENT } {"                 << ENDL;
      fout << "        scan $text \"(%f,%f)\" xval yval"                                << ENDL;
      fout << "        puts [ format \"PLOT_MOUSE_PRESSED %f %f\" $xval $yval ]"        << ENDL;
      fout << "      } elseif { $id == $::PLOT_MOUSE_RELEASED_EVENT } {"                << ENDL;
      fout << "        scan $text \"(%f,%f)\" xval yval"                                << ENDL;
      fout << "        puts [ format \"PLOT_MOUSE_RELEASED %f %f\" $xval $yval ]"       << ENDL;
      fout << "      } elseif { $id == $::USER_EVENT } {"                               << ENDL;
      fout << "        puts [ format \"USER_EVENT id=%d text=%s\" $i $text ]"           << ENDL;
      fout << "      } else {"                                                          << ENDL;
      fout << "        puts [ format \"UNKNOWN_EVENT id=%d text=%s\" $i $text ]"        << ENDL;
      fout << "      }"                                                                 << ENDL;
      fout << "    }"                                                                   << ENDL;
      fout << "  }"                                                                     << ENDL;
      fout << "}"                                                                       << ENDL;
      fout <<                                                                              ENDL;
      fout << "set ret [ " << maskname << "::show $p ]"                                 << ENDL;
      fout << "return $ret"                                                             << ENDL;
    }
  }
  else if(language != LANGUAGE_PVB)
  {
    QValueList<QString>::Iterator str;
    int found = 0;
    for(str=clist->begin(); str != clist->end(); str++)
    {
      if(strstr(*str,"_end_of_generated_area_") != NULL) found = 1;
      if(found == 1) fout << *str << ENDL;
    }
  }
}

void Generator::getMaskname(const char *filename)
{
  char fname[1024],*cptr;

  strcpy(fname,filename);
  cptr = strchr(fname,'.');
  if(cptr != NULL) *cptr = '\0';
#ifdef unix
  cptr = strrchr(fname,'/');
#endif
#ifdef __VMS
  cptr = strrchr(fname,']');
#endif
#ifdef _WIN32
  cptr = strrchr(fname,'\\');
#endif
  if(cptr != NULL) cptr++;
  else             cptr = &fname[0];
  lowerString(cptr);
  maskname = cptr;
}

int Generator::generate(const char *input_name, QDomDocument *uidoc, QStringList *clist, const char *filename)
{
  unsigned int i;
  QDomNodeList nodes;
  QDomNode node;
  ofstream fout(filename);

  getMaskname(filename);

  nodes = uidoc->elementsByTagName("UI");
  node  = nodes.item(0);
  version = node.toElement().attributeNode("version").value();
  if(version.isEmpty()) version = "2";
  printf("Version of ui-file = %s\n", (const char *) version);
  if(version != "2"   &&
     version != "3.0" &&
     version != "3.1" &&
     version != "3.2" &&
     version != "3.3" &&
     version != "3.4")
  {
    printf("Version not supported\n");
    printf("supported: 2 + 3.0 + 3.1 + 3.2 +3.3\n");
  }

  generateHeader(fout,clist);
  nodes = uidoc->elementsByTagName("widget");
  if(language == LANGUAGE_C)
  {
    fout <<                                                                   ENDL;
    fout << "// our mask contains the following objects"                   << ENDL;
    fout << "enum {"                                                       << ENDL;
    fout << "  ID_MAIN_WIDGET = 0,"                                        << ENDL;
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      if(version[0] == '3') parseWidgetV30(node);
      else                  parseWidgetV2(node);
      if(type != "QDialog") fout << "  " << id << ","                      << ENDL;
    }
    fout << "  ID_END_OF_WIDGETS"                                          << ENDL;
    fout << "};"                                                           << ENDL;
    fout <<                                                                   ENDL;
    generateToolTip(fout,nodes);
    fout <<                                                                   ENDL;
    generateWhatsThis(fout,nodes);
    fout <<                                                                   ENDL;
    fout << "static int generated_defineMask(PARAM *p)"                    << ENDL;
    fout << "{"                                                            << ENDL;
    fout << "  int w,h,depth;"                                             << ENDL;
    fout <<                                                                   ENDL;
    fout << "  if(p == NULL) return 1;"                                    << ENDL;
    fout << "  w = h = depth = strcmp(toolTip[0],whatsThis[0]);"           << ENDL;
    fout << "  if(w==h) depth=0; // fool the compiler"                     << ENDL;
    fout << "  pvStartDefinition(p,ID_END_OF_WIDGETS);"                    <<  ENDL;
    fout <<                                                                   ENDL;
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      generateWidget(fout, node);
    }
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      generateLayout(fout, node);
    }
    fout <<                                                                   ENDL;
    fout << "  pvEndDefinition(p);"                                        << ENDL;
    generateTabOrder(fout, uidoc);
    fout << "  return 0;"                                                  << ENDL;
    fout << "}"                                                            << ENDL;
    fout <<                                                                   ENDL;
  }
  else if(language == LANGUAGE_PYTHON)
  {
    ienum = 0;
    fout                                                                   << ENDL;
    fout << "class " << maskname << ":"                                    << ENDL;
    fout << "  # our mask contains the following objects"                  << ENDL;
    fout << "  ID_MAIN_WIDGET = " << ienum++                               << ENDL;
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      if(version[0] == '3') parseWidgetV30(node);
      else                  parseWidgetV2(node);
      if(type != "QDialog") fout << "  " << id << " = " << ienum++         << ENDL;
    }
    fout << "  ID_END_OF_WIDGETS = " << ienum++                            << ENDL;
    fout <<                                                                   ENDL;
    generateToolTip(fout,nodes);
    fout <<                                                                   ENDL;
    generateWhatsThis(fout,nodes);
    fout <<                                                                   ENDL;
    fout << "  def generated_defineMask(self,pvs,p):"                      << ENDL;
    fout << "    w     = pvs.new_int(0)"                                   << ENDL;
    fout << "    h     = pvs.new_int(0)"                                   << ENDL;
    fout << "    depth = pvs.new_int(0)"                                   << ENDL;
    fout << "    ret = pvs.pvStartDefinition(p,self.ID_END_OF_WIDGETS)"    << ENDL;
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      generateWidget(fout, node);
    }
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      generateLayout(fout, node);
    }
    fout <<                                                                   ENDL;
    fout << "    ret = pvs.pvEndDefinition(p)"                                << ENDL;
    fout << "    pvs.delete_int(w)"                                           << ENDL;
    fout << "    pvs.delete_int(h)"                                           << ENDL;
    fout << "    pvs.delete_int(depth)"                                       << ENDL;
    generateTabOrder(fout, uidoc);
    fout << "    return 0"                                                    << ENDL;
    fout <<                                                                      ENDL;
  }
  else if(language == LANGUAGE_PERL)
  {
    ienum = 0;  
    fout                                                                   << ENDL;
    fout << "# our mask contains the following objects"                    << ENDL;
    fout << "my $ID_MAIN_WIDGET = " << ienum++ << ";"                      << ENDL;
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      if(version[0] == '3') parseWidgetV30(node);
      else                  parseWidgetV2(node);
      if(type != "QDialog") fout << "my $" << id << " = " << ienum++ << ";" << ENDL;
    }
    fout << "my $ID_END_OF_WIDGETS = " << ienum++ << ";"                   << ENDL;
    fout <<                                                                   ENDL;
    generateToolTip(fout,nodes);
    fout <<                                                                   ENDL;
    generateWhatsThis(fout,nodes);
    fout <<                                                                   ENDL;
    fout << "sub new"                                                      << ENDL;
    fout << "{"                                                            << ENDL;
    fout << "  my $classname = shift;"                                     << ENDL;
    fout << "  my $ptr = {};"                                              << ENDL;
    fout << "  bless($ptr,$classname);"                                    << ENDL;
    fout << "  return $ptr;"                                               << ENDL;
    fout << "}"                                                            << ENDL;
    fout <<                                                                   ENDL;
    fout << "sub generated_defineMask"                                     << ENDL;
    fout << "{"                                                            << ENDL;
    fout << "  my $pv  = shift;"                                           << ENDL;
    fout << "  my $p   = shift;"                                           << ENDL;
    fout << "  $ret = init();"                                             << ENDL;
    fout << "  $w      = pv::new_int(0);"                                  << ENDL;
    fout << "  $h      = pv::new_int(0);"                                  << ENDL;
    fout << "  $depth  = pv::new_int(0);"                                  << ENDL;
    fout << "  $ret = pv::pvStartDefinition($p,$ID_END_OF_WIDGETS);"       << ENDL;
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      generateWidget(fout, node);
    }
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      generateLayout(fout, node);
    }
    fout <<                                                                   ENDL;
    fout << "  $ret = pv::pvEndDefinition($p);"                              << ENDL;
    fout << "  pv::delete_int($w);"                                          << ENDL;
    fout << "  pv::delete_int($h);"                                          << ENDL;
    fout << "  pv::delete_int($depth);"                                      << ENDL;
    generateTabOrder(fout, uidoc);
    fout << "  return 0;"                                                    << ENDL;
    fout << "}"                                                              << ENDL;
    fout <<                                                                     ENDL;
  }
  else if(language == LANGUAGE_PHP)
  {
    ienum = 0;
    fout <<                                                                   ENDL;
    fout << "  # our mask contains the following objects"                  << ENDL;
    fout << "  var $ID_MAIN_WIDGET = " << ienum++ << ";"                   << ENDL;
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      if(version[0] == '3') parseWidgetV30(node);
      else                  parseWidgetV2(node);
      if(type != "QDialog") fout << "  var $" << id << " = " << ienum++ << ";" << ENDL;
    }
    fout << "  var $ID_END_OF_WIDGETS = " << ienum++ << ";"                << ENDL;
    fout <<                                                                   ENDL;
    generateToolTip(fout,nodes);
    fout <<                                                                   ENDL;
    generateWhatsThis(fout,nodes);
    fout <<                                                                   ENDL;
    fout << "  function generated_defineMask($p)"                          << ENDL;
    fout << "  {"                                                          << ENDL;
    fout << "    $ret = $this->iniToolTip();"                              << ENDL;
    fout << "    $ret = $this->iniWhatsThis();"                            << ENDL;
    fout << "    $w     = new_int(0);"                                     << ENDL;
    fout << "    $h     = new_int(0);"                                     << ENDL;
    fout << "    $depth = new_int(0);"                                     << ENDL;
    fout << "    $ret = pvStartDefinition($p,$this->ID_END_OF_WIDGETS);"   << ENDL;
    fout <<                                                                   ENDL;
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      generateWidget(fout, node);
    }
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      generateLayout(fout, node);
    }
    fout <<                                                                   ENDL;
    fout << "    $ret = pvEndDefinition($p);"                              << ENDL;
    fout << "    delete_int($w);"                                          << ENDL;
    fout << "    delete_int($h);"                                          << ENDL;
    fout << "    delete_int($depth);"                                      << ENDL;
    generateTabOrder(fout, uidoc);
    fout << "    return 0;"                                                << ENDL;
    fout << "  }"                                                          << ENDL;
    fout <<                                                                   ENDL;
  }
  else if(language == LANGUAGE_TCL)
  {
    ienum = 0;
    fout                                                                   << ENDL;
    fout << "    # our mask contains the following objects"                << ENDL;
    fout << "    variable ID_MAIN_WIDGET " << ienum++                      << ENDL;
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      if(version[0] == '3') parseWidgetV30(node);
      else                  parseWidgetV2(node);
      if(type != "QDialog") fout << "    variable " << id << " " << ienum++ << ENDL;
    }
    fout << "    variable ID_END_OF_WIDGETS " << ienum++                   << ENDL;
    fout << "  }"                                                          << ENDL;
    fout <<                                                                   ENDL;
    generateToolTip(fout,nodes);
    fout <<                                                                   ENDL;
    generateWhatsThis(fout,nodes);
    fout <<                                                                   ENDL;
    fout << "  proc generated_defineMask { p } {"                          << ENDL;
    fout << "    init"                                                     << ENDL;
    fout << "    set w     [ new_int 0 ]"                                  << ENDL;
    fout << "    set h     [ new_int 0 ]"                                  << ENDL;
    fout << "    set depth [ new_int 0 ]"                                  << ENDL;
    fout << "    pvStartDefinition $p $this::ID_END_OF_WIDGETS"            << ENDL;
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      generateWidget(fout, node);
    }
    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      generateLayout(fout, node);
    }
    fout <<                                                                   ENDL;
    fout << "    pvEndDefinition $p"                                       << ENDL;
    fout << "    delete_int $w"                                            << ENDL;
    fout << "    delete_int $h"                                            << ENDL;
    fout << "    delete_int $depth"                                        << ENDL;
    generateTabOrder(fout, uidoc);
    fout << "    return 0"                                                 << ENDL;
    fout << "  }"                                                          << ENDL;
    fout <<                                                                   ENDL;
  }
  else if(language == LANGUAGE_PVB)
  {
    QString fname = filename;
    fname = fname.left(fname.find('.'));
    ofstream fout_xsd(fname + ".xsd");
    fout_xsd << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" << ENDL;
    fout_xsd << "<!--" << ENDL;  
    fout_xsd << "/* ns" << ENDL;
    fout_xsd << "   Generated by ui2pvc from " << input_name << ENDL;
    fout_xsd << "   Copyright (C) Dr. Rainer Lehrig All Rights Reserved." << ENDL;
    fout_xsd << "   This software is released under one of the following two licenses:" << ENDL;
    fout_xsd << "   GPL, license for commercial use." << ENDL;
    fout_xsd << "*/-->" << ENDL;
    fout_xsd << " <schema targetNamespace=\"http://pvbrowser.org/pvb.xsd\"" << ENDL;
    fout_xsd << "  xmlns:SOAP-ENV=\"http://www.w3.org/2003/05/soap-envelope\"" << ENDL;
    fout_xsd << "  xmlns:SOAP-ENC=\"http://www.w3.org/2003/05/soap-encoding\"" << ENDL;
    fout_xsd << "  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" << ENDL;
    fout_xsd << "  xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"" << ENDL;
    fout_xsd << "  xmlns:ns=\"http://pvbrowser.org/pvb.xsd\"" << ENDL;
    fout_xsd << "  xmlns=\"http://www.w3.org/2001/XMLSchema\"" << ENDL;
    fout_xsd << "  elementFormDefault=\"unqualified\"" << ENDL;
    fout_xsd << "  attributeFormDefault=\"unqualified\">" << ENDL;
    fout_xsd << "  <import namespace=\"http://www.w3.org/2003/05/soap-encoding\"/>" << ENDL;
    fout_xsd << "" << ENDL;
    fout_xsd << "  <complexType name=\"pvbField\">" << ENDL;
    fout_xsd << "   <sequence>" << ENDL;
    fout_xsd << "     <element name=\"name\" type=\"xsd:string\" minOccurs=\"0\" maxOccurs=\"1\" nillable=\"true\"/>" << ENDL;
    fout_xsd << "     <element name=\"index\" type=\"xsd:string\" minOccurs=\"0\" maxOccurs=\"1\" nillable=\"true\"/>" << ENDL;
    fout_xsd << "     <element name=\"tooltip\" type=\"xsd:string\" minOccurs=\"0\" maxOccurs=\"1\" nillable=\"true\"/>" << ENDL;
    fout_xsd << "     <element name=\"whatsthis\" type=\"xsd:string\" minOccurs=\"0\" maxOccurs=\"1\" nillable=\"true\"/>" << ENDL;
    fout_xsd << "     <element name=\"parent\" type=\"xsd:string\" minOccurs=\"0\" maxOccurs=\"1\" nillable=\"true\"/>" << ENDL;
    fout_xsd << "   </sequence>" << ENDL;
    fout_xsd << "  </complexType>" << ENDL;
    fout_xsd << "  <complexType name=\"pvbFieldList\">" << ENDL;
    fout_xsd << "   <sequence>" << ENDL;
    fout_xsd << "    <element name=\"item\" type=\"ns:FaceplateField\" minOccurs=\"0\" maxOccurs=\"unbounded\" nillable=\"true\"/>" << ENDL;
    fout_xsd << "   </sequence>" << ENDL;
    fout_xsd << "  </complexType>" << ENDL;
    fout_xsd << "" << ENDL;
    fout_xsd << "  <element name=\"faceplateFields\" type=\"ns:pvbFieldList\"/>" << ENDL;
    fout_xsd << "" << ENDL;
    fout_xsd << " </schema>" << ENDL;

    fout << "<?xml version=\"1.0\"?>" << ENDL;
    fout << "<pvbFields" << ENDL;
    fout << "xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"" << ENDL;
    fout << "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"" << ENDL;
    fout << "xmlns:ns=\"http://pvbrowser.org/pvb.xsd\"" << ENDL;
    fout << "xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"" << ENDL;
    fout << "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" << ENDL;
    fout << "xsi:type=\"ns:pvbList\">" << ENDL;
    fout << "" << ENDL;

    for(i=0; i<nodes.count(); i++)
    {
      node = nodes.item(i);
      generateWidget(fout, node);
    }
    fout << "</pvbFields>" << ENDL;
    return 0;
  }
  generateTrailer(fout,clist);

  return 0;
}

void Generator::generateToolTip(ofstream &fout, QDomNodeList &nodes)
{
  QDomNode node;
  unsigned int i;

  if(language == LANGUAGE_C)
  {
    fout << "  static const char *toolTip[] = {"                            << ENDL;
  }
  else if(language == LANGUAGE_PYTHON)
  {
    fout << "  toolTip = ["                                                 << ENDL;
  }
  else if(language == LANGUAGE_PERL)
  {
    fout << "my @toolTip = ();"                                             << ENDL;
    fout << "my @whatsThis = ();"                                           << ENDL;
    fout << "sub init()"                                                    << ENDL;
    fout << "{"                                                             << ENDL;
  }
  else if(language == LANGUAGE_PHP)
  {
    fout << "  var $toolTip;"                                               << ENDL;
    fout << "  function iniToolTip()"                                       << ENDL;
    fout << "  {"                                                           << ENDL;
  }
  else if(language == LANGUAGE_TCL)
  {
    fout << "  proc init {} {"                                              << ENDL;
    fout << "    global toolTip whatsThis"                                  << ENDL;
  }

  for(i=0; i<nodes.count(); i++)
  {
    node = nodes.item(i);
    if(version[0] == '3') parseWidgetV30(node);
    else                  parseWidgetV2(node);
    if(language == LANGUAGE_C)
    {
      fout << "  \"" << tooltip << "\","                                    << ENDL;
    }
    else if(language == LANGUAGE_PYTHON)
    {
      fout << "  '" << tooltip << "',"                                      << ENDL;
    }
    else if(language == LANGUAGE_PERL)
    {
      fout << "  $toolTip[" << i << "] = \"" << tooltip << "\";"            << ENDL;
    }
    else if(language == LANGUAGE_PHP)
    {
      fout << "    $this->toolTip[" << i << "] = \"" << tooltip << "\";"    << ENDL;
    }
    else if(language == LANGUAGE_TCL)
    {
      fout << "    set toolTip(" << i << ") \"" << tooltip << "\""          << ENDL;
    }
    else if(language == LANGUAGE_PVB)
    {
      //fout << "  \"" << tooltip << "\","                                    << ENDL;
    }
  }

  if(language == LANGUAGE_C)
  {
    fout << "  \"\"};"                                                      << ENDL;
  }
  else if(language == LANGUAGE_PYTHON)
  {
    fout << "  '' ]"                                                        << ENDL;
  }
  else if(language == LANGUAGE_PHP)
  {
    fout << "    return 0;"                                                 << ENDL;
    fout << "  }"                                                           << ENDL;
  }
}

void Generator::generateWhatsThis(ofstream &fout, QDomNodeList &nodes)
{
  QDomNode node;
  unsigned int i;

  if(language == LANGUAGE_C)
  {
    fout << "  static const char *whatsThis[] = {"                          << ENDL;
  }
  else if(language == LANGUAGE_PYTHON)
  {
    fout << "  whatsThis = ["                                               << ENDL;
  }
  else if(language == LANGUAGE_PHP)
  {
    fout << "  var $whatsThis;"                                             << ENDL;
    fout << "  function iniWhatsThis()"                                     << ENDL;
    fout << "  {"                                                           << ENDL;
  }

  for(i=0; i<nodes.count(); i++)
  {
    node = nodes.item(i);
    if(version[0] == '3') parseWidgetV30(node);
    else                  parseWidgetV2(node);
    if(language == LANGUAGE_C)
    {
      fout << "  \"" << whatsThis << "\","                                  << ENDL;
    }
    else if(language == LANGUAGE_PYTHON)
    {
      fout << "  '" << whatsThis << "',"                                    << ENDL;
    }
    else if(language == LANGUAGE_PERL)
    {
      fout << "  $whatsThis[" << i << "] = \"" << whatsThis << "\";"        << ENDL;
    }
    else if(language == LANGUAGE_PHP)
    {
      fout << "    $this->whatsThis[" << i << "] = \"" << whatsThis << "\";" << ENDL;
    }
    else if(language == LANGUAGE_TCL)
    {
      fout << "    set whatsThis(" << i << ") \"" << whatsThis << "\""      << ENDL;
    }
    else if(language == LANGUAGE_PVB)
    {
      //fout << "  \"" << whatsThis << "\","                                  << ENDL;
    }
  }

  if(language == LANGUAGE_C)
  {
    fout << "  \"\"};"                                                      << ENDL;
  }
  else if(language == LANGUAGE_PYTHON)
  {
    fout << "  '' ]"                                                        << ENDL;
  }
  else if(language == LANGUAGE_PERL)
  {
    fout << "  return 0;"                                                   << ENDL;
    fout << "}"                                                             << ENDL;
  }
  else if(language == LANGUAGE_PHP)
  {
    fout << "    return 0;"                                                 << ENDL;
    fout << "  }"                                                           << ENDL;
  }
  else if(language == LANGUAGE_TCL)
  {
    fout << "    return 0"                                                  << ENDL;
    fout << "  }"                                                           << ENDL;
  }
}

void Generator::defaultValues()
{
  type = id = parent = x = y = w = h = text = mode = style = shape = shadow = linewidth = margin = "";
  numdigits = editable = "";
  maxlines = "-1";
  pagestep = "10";
  value    = "0";
  minvalue = "0";
  maxvalue = "99";
  progress = "0";
  orientation = insertionpolicy = "";
  tooltip = parentclass = "";
  numRows = numCols = "3";
  checked = echomode = selectionmode = "";
  fontfamily = fontpointsize = fontbold = fontitalic = fontunderline = fontstrikeout = "";
  tabposition = "0";
  foregroundred = foregroundgreen = foregroundblue = backgroundred = backgroundgreen = backgroundblue = "";
  whatsThis = buddy = pixmap = "";
  //QpwPlotWidget
  canvasBackgroundRed = canvasBackgroundGreen = canvasBackgroundBlue = canvasLineWidth = "";
  xBottomAxis = "true";
  xTopAxis    = "false";
  yLeftAxis   = "true";
  yRightAxis  = "false";
  nCurves = nMarker = "0";
  //QwtScale
  position = "Left";
  title = titleFontfamily = "";
  titleFontsize = "10";
  titleFontbold = titleFontitalic = titleFontunderline = titleFontstrikeout = "0";
  titleColorRed = titleColorGreen = titleColorBlue = "";
  //QwtThermo
  //QwtKnob
  readOnly = mass = knobWidth = borderWidth = totalAngle = symbol = "";
  //QwtCounter
  numButtons = basicstep = minValue = maxValue = stepButton1 = stepButton2 = stepButton3 = "";
  //QwtWheel
  viewAngle = tickCnt = internalBorder = "";
  //QwtSlider
  thumbLength = thumbWidth = bgStyle = "";
  scalePos = "Top";
  //QwtCompass
  visibleBackground = frameShadow = origin = wrapping = "";
  timeDisplay = "";
  alignment = "";

  vbox = hbox = grid = "";
  spacer_name = spacer_orientation = spacer_sizetype = spacer_sizehint_width = spacer_sizehint_height = "";
}

void Generator::parseWidgetV2(QDomNode wnode)
{
  QDomNodeList nodes = wnode.childNodes();
  QDomNode node,child;
  unsigned int i,j;

  defaultValues();

  for(i=0; i<nodes.count(); i++)
  {
    node = nodes.item(i);
    if(node.nodeName() == "class")
    {
      type = node.toElement().text();
    }
    else if(node.nodeName() == "attribute")
    {
      QDomNodeList childs = node.childNodes();
      text = childs.item(1).toElement().text();
      quote();
    }
    else if(node.nodeName() == "property")
    {
      QDomNodeList childs = node.childNodes();
      for(j=0; j<childs.count(); j++)
      {
        child = childs.item(j);
        if(child.toElement().text() == "name")
        {
          id = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "geometry")
        {
          QDomNode geom;
          geom = child.nextSibling().firstChild();
          x = geom.toElement().text();
          geom = geom.nextSibling();
          y = geom.toElement().text();
          geom = geom.nextSibling();
          w = geom.toElement().text();
          geom = geom.nextSibling();
          h = geom.toElement().text();
        }
        else if(child.toElement().text() == "paletteForegroundColor")
        {
          QDomNode col;
          col = child.nextSibling().firstChild();
          foregroundred = col.toElement().text();
          col = col.nextSibling();
          foregroundgreen = col.toElement().text();
          col = col.nextSibling();
          foregroundblue = col.toElement().text();
        }
        else if(child.toElement().text() == "paletteBackgroundColor")
        {
          QDomNode col;
          col = child.nextSibling().firstChild();
          backgroundred = col.toElement().text();
          col = col.nextSibling();
          backgroundgreen = col.toElement().text();
          col = col.nextSibling();
          backgroundblue = col.toElement().text();
        }
        else if(child.toElement().text() == "font")
        {
          QDomNode font;
          font = child.nextSibling().firstChild();
          while(!font.isNull())
          {
            if     (font.nodeName() == "family")    fontfamily    = font.toElement().text();
            else if(font.nodeName() == "pointsize") fontpointsize = font.toElement().text();
            else if(font.nodeName() == "bold")      fontbold      = font.toElement().text();
            else if(font.nodeName() == "italic")    fontitalic    = font.toElement().text();
            else if(font.nodeName() == "underline") fontunderline = font.toElement().text();
            else if(font.nodeName() == "strikeout") fontstrikeout = font.toElement().text();
            font = font.nextSibling();
          }
        }
        else if(child.toElement().text() == "name")
        {
          text = child.nextSibling().toElement().text();
          quote();
        }
        else if(child.toElement().text() == "text")
        {
          text = child.nextSibling().toElement().text();
          quote();
        }
        else if(child.toElement().text() == "title")
        {
          text = child.nextSibling().toElement().text();
          quote();
        }
        else if(child.toElement().text() == "mode")
        {
          mode = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "segmentStyle")
        {
          style = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "frameShape")
        {
          shape = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "frameShadow")
        {
          shadow = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "lineWidth")
        {
          linewidth = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "margin")
        {
          margin = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "minValue")
        {
          minvalue = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "maxValue")
        {
          maxvalue = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "maxLines")
        {
          maxlines = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "value")
        {
          value = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "pageStep")
        {
          pagestep = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "orientation")
        {
          orientation = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "insertionPolicy")
        {
          insertionpolicy = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "editable")
        {
          editable = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "readOnly")
        {
          editable = child.nextSibling().toElement().text();
          if(editable == "true") editable = "false";
          else                   editable = "true";
        }
        else if(child.toElement().text() == "enabled")
        {
          editable = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "numDigits")
        {
          numdigits = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "toolTip")
        {
          tooltip = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "numRows")
        {
          numRows = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "numCols")
        {
          numCols = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "progress")
        {
          progress = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "checked")
        {
          checked = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "echoMode")
        {
          echomode = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "selectionMode")
        {
          selectionmode = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "tabPosition")
        {
          tabposition = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "pixmap")
        {
          pixmap = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "buddy")
        {
          buddy = child.nextSibling().toElement().text();
        }
        else if(child.toElement().text() == "whatsThis")
        {
          whatsThis = child.nextSibling().toElement().text();
        }
      }
    }
  }

  parent = "0";
  parentclass = wnode.parentNode().childNodes().item(0).toElement().text();
  nodes = wnode.parentNode().childNodes();
  for(i=0; i<nodes.count(); i++)
  {
    node = nodes.item(i);
    if(node.nodeName() == "class")
    {
      if(node.toElement().text() == "QDialog")
      {
        parentclass = "QDialog";
      }
    }
    else if(node.nodeName() == "property")
    {
      QDomNodeList childs = node.childNodes();
      for(j=0; j<childs.count(); j++)
      {
        child = childs.item(j);
        if(child.toElement().text() == "name" && parentclass != "QDialog")
        {
          parent = child.nextSibling().toElement().text();
          if(parent.isNull()) parent = "0";
        }
      }
    }
  }
}

void Generator::parseWidgetV30(QDomNode wnode)
{
  QDomNodeList nodes = wnode.childNodes();
  QDomNode node,child;
  unsigned int i,j;
  QString name;

  defaultValues();

  type = wnode.toElement().attributeNode("class").value();

  for(i=0; i<nodes.count(); i++)
  {
    node = nodes.item(i);
    if(node.nodeName() == "attribute")
    {
      QDomNodeList childs = node.childNodes();
      text = childs.item(0).toElement().text();
      quote();
    }
    else if(node.nodeName() == "vbox")
    {
      vbox = "vbox";
      layout = node.childNodes();
    }
    else if(node.nodeName() == "hbox")
    {
      hbox = "hbox";
      layout = node.childNodes();
    }
    else if(node.nodeName() == "grid")
    {
      grid = "grid";
      layout = node.childNodes();
    }
    else if(node.nodeName() == "property")
    {
      name = node.toElement().attributeNode("name").value();
      QDomNodeList childs = node.childNodes();
      for(j=0; j<childs.count(); j++)
      {
        child = childs.item(j);

        if(name == "name")
        {
          id = child.toElement().text();
        }
        else if(name == "geometry")
        {
          QDomNode geom;
          geom = child.firstChild();
          x = geom.toElement().text();
          geom = geom.nextSibling();
          y = geom.toElement().text();
          geom = geom.nextSibling();
          w = geom.toElement().text();
          geom = geom.nextSibling();
          h = geom.toElement().text();
        }
        else if(name == "paletteForegroundColor")
        {
          QDomNode col;
          col = child.firstChild();
          foregroundred = col.toElement().text();
          col = col.nextSibling();
          foregroundgreen = col.toElement().text();
          col = col.nextSibling();
          foregroundblue = col.toElement().text();
        }
        else if(name == "paletteBackgroundColor")
        {
          QDomNode col;
          col = child.firstChild();
          backgroundred = col.toElement().text();
          col = col.nextSibling();
          backgroundgreen = col.toElement().text();
          col = col.nextSibling();
          backgroundblue = col.toElement().text();
        }
        else if(name == "font")
        {
          QDomNode font;
          font = child.firstChild();
          while(!font.isNull())
          {
            if     (font.nodeName() == "family")    fontfamily    = font.toElement().text();
            else if(font.nodeName() == "pointsize") fontpointsize = font.toElement().text();
            else if(font.nodeName() == "bold")      fontbold      = font.toElement().text();
            else if(font.nodeName() == "italic")    fontitalic    = font.toElement().text();
            else if(font.nodeName() == "underline") fontunderline = font.toElement().text();
            else if(font.nodeName() == "strikeout") fontstrikeout = font.toElement().text();
            font = font.nextSibling();
          }
        }
        else if(name == "text")
        {
          text = child.toElement().text();
          quote();
        }
        else if(name == "title")
        {
          text = child.toElement().text();
          quote();
        }
        else if(name == "mode")
        {
          mode = child.toElement().text();
        }
        else if(name == "segmentStyle")
        {
          style = child.toElement().text();
        }
        else if(name == "frameShape")
        {
          shape = child.toElement().text();
        }
        else if(name == "frameShadow")
        {
          shadow = child.toElement().text();
        }
        else if(name == "lineWidth")
        {
          linewidth = child.toElement().text();
        }
        else if(name == "margin")
        {
          margin = child.toElement().text();
        }
        else if(name == "minValue")
        {
          minvalue = child.toElement().text();
        }
        else if(name == "maxValue")
        {
          maxvalue = child.toElement().text();
        }
        else if(name == "maxLines")
        {
          maxlines = child.toElement().text();
        }
        else if(name == "value")
        {
          value = child.toElement().text();
        }
        else if(name == "pageStep")
        {
          pagestep = child.toElement().text();
        }
        else if(name == "orientation")
        {
          orientation = child.toElement().text();
        }
        else if(name == "insertionPolicy")
        {
          insertionpolicy = child.toElement().text();
        }
        else if(name == "editable")
        {
          editable = child.toElement().text();
        }
        else if(name == "readOnly")
        {
          editable = child.toElement().text();
          if(editable == "true") editable = "false";
          else                   editable = "true";
        }
        else if(name == "enabled")
        {
          editable = child.toElement().text();
        }
        else if(name == "numDigits")
        {
          numdigits = child.toElement().text();
        }
        else if(name == "toolTip")
        {
          tooltip = child.toElement().text();
          tooltip = tooltip.remove(0x0d);
          tooltip = tooltip.remove(0x0a);
          tooltip = tooltip.replace('"',"\\\"");
        }
        else if(name == "numRows")
        {
          numRows = child.toElement().text();
        }
        else if(name == "numCols")
        {
          numCols = child.toElement().text();
        }
        else if(name == "progress")
        {
          progress = child.toElement().text();
        }
        else if(name == "checked")
        {
          checked = child.toElement().text();
        }
        else if(name == "echoMode")
        {
          echomode = child.toElement().text();
        }
        else if(name == "selectionMode")
        {
          selectionmode = child.toElement().text();
        }
        else if(name == "tabPosition")
        {
          tabposition = child.toElement().text();
        }
        else if(name == "currentIndex")
        {
          tabposition = child.toElement().text();
        }
        else if(name == "pixmap")
        {
          pixmap = child.toElement().text();
        }
        else if(name == "buddy")
        {
          buddy = child.toElement().text();
        }
        else if(name == "whatsThis")
        {
          whatsThis = child.toElement().text();
          whatsThis = whatsThis.remove(0x0d);
          whatsThis = whatsThis.remove(0x0a);
          whatsThis = whatsThis.replace('"',"\\\"");
        }
        else if(name == "canvasBackground")
        {
          QDomNode col;
          col = child.firstChild();
          canvasBackgroundRed = col.toElement().text();
          col = col.nextSibling();
          canvasBackgroundGreen = col.toElement().text();
          col = col.nextSibling();
          canvasBackgroundBlue = col.toElement().text();
        }
        else if(name == "canvasLineWidth")
        {
          canvasLineWidth = child.toElement().text();
        }
        else if(name == "xBottomAxis")
        {
          xBottomAxis = child.toElement().text();
        }
        else if(name == "xTopAxis")
        {
          xTopAxis = child.toElement().text();
        }
        else if(name == "yLeftAxis")
        {
          yLeftAxis = child.toElement().text();
        }
        else if(name == "yRightAxis")
        {
          yRightAxis = child.toElement().text();
        }
        else if(name == "nCurves")
        {
          nCurves = child.toElement().text();
        }
        else if(name == "nMarker")
        {
          nMarker = child.toElement().text();
        }
        //QwtScale
        else if(name == "position")
        {
          position = child.toElement().text();
        }
        else if(name == "title")
        {
          title = child.toElement().text();
        }
        else if(name == "titleFont")
        {
          QDomNode font;
          font = child.firstChild();
          while(!font.isNull())
          {
            if     (font.nodeName() == "family")    titleFontfamily    = font.toElement().text();
            else if(font.nodeName() == "pointsize") titleFontsize      = font.toElement().text();
            else if(font.nodeName() == "bold")      titleFontbold      = font.toElement().text();
            else if(font.nodeName() == "italic")    titleFontitalic    = font.toElement().text();
            else if(font.nodeName() == "underline") titleFontunderline = font.toElement().text();
            else if(font.nodeName() == "strikeout") titleFontstrikeout = font.toElement().text();
            font = font.nextSibling();
          }
        }
        else if(name == "titleColor")
        {
          QDomNode col;
          col = child.firstChild();
          titleColorRed = col.toElement().text();
          col = col.nextSibling();
          titleColorGreen = col.toElement().text();
          col = col.nextSibling();
          titleColorBlue = col.toElement().text();
        }
        //QwtThermo
        //QwtKnob
        else if(name == "readOnly")
        {
          readOnly = child.toElement().text();
        }
        else if(name == "mass")
        {
          mass = child.toElement().text();
        }
        else if(name == "knobWidth")
        {
          knobWidth = child.toElement().text();
        }
        else if(name == "borderWidth")
        {
          borderWidth = child.toElement().text();
        }
        else if(name == "totalAngle")
        {
          totalAngle = child.toElement().text();
        }
        else if(name == "symbol")
        {
          symbol = child.toElement().text();
        }
        //QwtCounter
        else if(name == "numButtons")
        {
          numButtons = child.toElement().text();
        }
        else if(name == "basicstep")
        {
          basicstep = child.toElement().text();
        }
        else if(name == "minValue")
        {
          minValue = child.toElement().text();
        }
        else if(name == "maxValue")
        {
          maxValue = child.toElement().text();
        }
        else if(name == "stepButton1")
        {
          stepButton1 = child.toElement().text();
        }
        else if(name == "stepButton2")
        {
          stepButton2 = child.toElement().text();
        }
        else if(name == "stepButton3")
        {
          stepButton3 = child.toElement().text();
        }
        //QwtWheel
        else if(name == "viewAngle")
        {
          viewAngle = child.toElement().text();
        }
        else if(name == "tickCnt")
        {
          tickCnt = child.toElement().text();
        }
        else if(name == "internalBorder")
        {
          internalBorder = child.toElement().text();
        }
        //QwtSlider
        else if(name == "thumbLength")
        {
          thumbLength = child.toElement().text();
        }
        else if(name == "thumbWidth")
        {
          thumbWidth = child.toElement().text();
        }
        else if(name == "bgStyle")
        {
          bgStyle = child.toElement().text();
        }
        else if(name == "scalePos")
        {
          scalePos = child.toElement().text();
        }
        //QwtCompass
        else if(name == "visibleBackground")
        {
          visibleBackground = child.toElement().text();
        }
        else if(name == "frameShadow")
        {
          frameShadow = child.toElement().text();
        }
        else if(name == "origin")
        {
          origin = child.toElement().text();
        }
        else if(name == "wrapping")
        {
          wrapping = child.toElement().text();
        }
        else if(name == "display")
        {
          timeDisplay = child.toElement().text();
        }
        else if(name == "alignment")
        {
          alignment = child.toElement().text();
        }
      }
    }
  }
  //rl printf("utf8 text=%s\n", (const char *) codec->fromUnicode(text));
  //rl printf("text=%s\n", (const char *) text);

  parentclass = wnode.parentNode().toElement().attributeNode("class").value();
  parent = "0";
  if(wnode.parentNode().nodeName() == "vbox" || wnode.parentNode().nodeName() == "hbox" || wnode.parentNode().nodeName() == "grid")
  {
    QDomNode item = wnode;
    while(item.parentNode().parentNode().toElement().attributeNode("class").value() == "QLayoutWidget")
    {
      item = item.parentNode().parentNode();
    }
    parent = item.parentNode().parentNode().firstChild().firstChild().toElement().text();
    if(parent.isNull()) parent = "0";
    if(item.parentNode().parentNode().toElement().attributeNode("class").value() == "QDialog") parent = "0";
    return;
  }
  if(parentclass == "QDialog") return;
  nodes = wnode.parentNode().childNodes();
  for(i=0; i<nodes.count(); i++)
  {
    node = nodes.item(i);
    if("name" == node.toElement().attributeNode("name").value())
    {
      parent = node.firstChild().toElement().text();
      if(parent.isNull()) parent = "0";
      return;
    }
  }
}

void Generator::generateWidget(ofstream &fout, QDomNode node)
{
  char ctext[4096];

  if(version[0] == '3') parseWidgetV30(node);
  else                  parseWidgetV2(node);

  //cout << "type=" << type << " id=" << id << " parent=" << parent
  //     << " x=" << x << " y=" << y << " w=" << w << " h=" << h << " text=" << text << ENDL;

  strcpy(ctext, (const char *) codec->fromUnicode(text));
  switch(language)
  {
    case LANGUAGE_C:
      generateWidgetC(fout,ctext);
      break;
    case LANGUAGE_PYTHON:
      generateWidgetPython(fout,ctext);
      break;
    case LANGUAGE_PERL:
      generateWidgetPerl(fout,ctext);
      break;
    case LANGUAGE_PHP:
      generateWidgetPhp(fout,ctext);
      break;
    case LANGUAGE_TCL:
      generateWidgetTcl(fout,ctext);
      break;
    case LANGUAGE_PVB:
      generateWidgetPvb(fout,ctext);
      break;
    default:
      break;
  } 
}
  
void Generator::generateWidgetC(ofstream &fout, const char *text)
{
  if(type == "QLayoutWidget")
  {
    if(vbox != "") fout << "  pvQLayoutVbox(p," << id << "," << parent << ");" << ENDL;
    if(hbox != "") fout << "  pvQLayoutHbox(p," << id << "," << parent << ");" << ENDL;
    if(grid != "") fout << "  pvQLayoutGrid(p," << id << "," << parent << ");" << ENDL;
    if(x != "")    fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QDialog")
  {
    if(vbox != "") fout << "  pvQLayoutVbox(p,0,-1);" << ENDL;
    if(hbox != "") fout << "  pvQLayoutHbox(p,0,-1);" << ENDL;
    if(grid != "") fout << "  pvQLayoutGrid(p,0,-1);" << ENDL;
  }
  else if(type == "QPushButton")
  {
    fout << "  pvQPushButton(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "  pvSetText(p," << id << ",\"" << text << "\");" << ENDL;
  }
  else if(type == "QWidget")
  {
    fout << "  pvQWidget(p," << id << "," << parent << ");" << ENDL;
    if(parentclass == "QTabWidget")
    {
      fout << "  pvAddTab(p," << parent << "," << id << ",\"" << text << "\");" << ENDL;
    }
    else if(parentclass == "QToolBox")
    {
      fout << "    pvAddTab(p," << parent << "," << id << ",\"" << text << "\");" << ENDL;
    }
    else
    {
      if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
      fout << "  pvSetText(p," << id << ",\"" << text << "\");" << ENDL;
    }
  }
  else if(type == "QLabel")
  {
    if(whatsThis == "" || whatsThis[0] == '#')
    {
      fout << "  pvQLabel(p," << id << "," << parent << ");" << ENDL;
      if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
      fout << "  pvSetText(p," << id << ",\"" << text << "\");" << ENDL;
      if(alignment != "")
      {
        fout << "  pvSetAlignment(p," << id << "," << alignment << ");" << ENDL;
      }
    }
    else
    {
      if(strstr(whatsThis,".bmp") == NULL && strstr(whatsThis,".BMP") == NULL)
      {
        fout << "  pvDownloadFile(p,\"" << whatsThis << "\");" << ENDL;
        fout << "  pvQImage(p," << id << "," << parent << ",\"" << whatsThis << "\",&w,&h,&depth);" << ENDL;
        if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
      }
      else
      {
        fout << "  pvQImage(p," << id << "," << parent << ",\"" << whatsThis << "\",&w,&h,&depth);" << ENDL;
        if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << ",w,h);" << ENDL;
      }
    }
  }
  else if(type == "QLineEdit")
  {
    fout << "  pvQLineEdit(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "  pvSetText(p," << id << ",\"" << text << "\");" << ENDL;
    if(editable == "false")
    {
      fout << "  pvSetEditable(p," << id << ",0);" << ENDL;
    }
    if(echomode == "Password")
    {
      fout << "  pvSetEchoMode(p," << id << ",2);" << ENDL;
    }
    else if(echomode == "NoEcho")
    {
      fout << "  pvSetEchoMode(p," << id << ",0);" << ENDL;
    }
    if(alignment != "")
    {
      fout << "  pvSetAlignment(p," << id << "," << alignment << ");" << ENDL;
    }
  }
  else if(type == "QMultiLineEdit" || type == "PVMultiLineEdit" || type == "QTextEdit")
  {
    if(editable == "")        editable = "1";
    if(editable == "true")    editable = "1";
    if(editable == "false")   editable = "0";
    if(maxlines != "-1")
    {
      char buf[32];
      int  ival;
      sscanf(maxlines,"%d",&ival);
      sprintf(buf,"%d",-ival);
      maxlines = buf;
    }
    fout << "  pvQMultiLineEdit(p," << id << "," << parent << "," << editable << "," << maxlines << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QTextBrowser")
  {
    fout << "  pvQTextBrowser(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QListView")
  {
    fout << "  pvQListView(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(selectionmode == "Multi")
    {
      fout << "  pvSetMultiSelection(p," << id << ",1);" << ENDL;
    }
    else if(selectionmode == "NoSelection")
    {
      fout << "  pvSetMultiSelection(p," << id << ",2);" << ENDL;
    }
  }
  else if(type == "QComboBox")
  {
    if(insertionpolicy == "") insertionpolicy = "AtTop";
    if(editable == "")        editable = "0";
    if(editable == "true")    editable = "1";
    if(editable == "false")   editable = "0";
    fout << "  pvQComboBox(p," << id << "," << parent << "," << editable << "," << insertionpolicy << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QLCDNumber")
  {
    if(mode      == "") mode      = "Dec";
    if(style     == "") style     = "Outline";
    if(numdigits == "") numdigits = "2";
    fout << "  pvQLCDNumber(p," << id << "," << parent << "," << numdigits << "," << style << "," << mode << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QSlider")
  {
    if(pagestep    == "") pagestep    = "10";
    if(value       == "") value       = "0";
    if(minvalue    == "") minvalue    = "0";
    if(maxvalue    == "") maxvalue    = "99";
    if(orientation == "") orientation = "Vertical";
    fout << "  pvQSlider(p," << id << "," << parent << "," << minvalue << "," << maxvalue << "," << pagestep << "," << value << "," << orientation << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QButtonGroup")
  {
    fout << "  pvQButtonGroup(p," << id << "," << parent << ",-1,HORIZONTAL,\"" << text << "\");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QGroupBox")
  {
    fout << "  pvQGroupBox(p," << id << "," << parent << ",-1,HORIZONTAL,\"" << text << "\");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QListBox")
  {
    fout << "  pvQListBox(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(selectionmode == "Multi")
    {
      fout << "  pvSetSelectionMode(p," << id << ",2);" << ENDL;
    }
    else if(selectionmode == "NoSelection")
    {
      fout << "  pvSetSelectionMode(p," << id << ",0);" << ENDL;
    }
  }
  else if(type == "QIconView")
  {
    fout << "  pvQIconView(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QTable")
  {
    fout << "  pvQTable(p," << id << "," << parent << "," << numRows << "," << numCols << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(editable == "false")
    {
      fout << "  pvSetEditable(p," << id << ",0);" << ENDL;
    }
  }
  else if(type == "QSpinBox")
  {
    fout << "  pvQSpinBox(p," << id << "," << parent << "," << minvalue << "," << maxvalue << ",1);" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QDial")
  {
    fout << "  pvQDial(p," << id << "," << parent << "," << minvalue << "," << maxvalue << "," << pagestep << "," << value << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QProgressBar")
  {
    fout << "  pvQProgressBar(p," << id << "," << parent << "," << progress << ");"            << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QRadioButton")
  {
    fout << "  pvQRadioButton(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "  pvSetText(p," << id << ",\"" << text << "\");" << ENDL;
    if(checked == "true")
    {
      fout << "  pvSetChecked(p," << id << ",1);" << ENDL;
    }
  }
  else if(type == "QCheckBox")
  {
    fout << "  pvQCheckBox(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "  pvSetText(p," << id << ",\"" << text << "\");" << ENDL;
    if(checked == "true")
    {
      fout << "  pvSetChecked(p," << id << ",1);" << ENDL;
    }
  }
  else if(type == "QFrame")
  {
    if(whatsThis == "" || whatsThis[0] == '#')
    {
      if(shape     == "") shape     = "NoFrame";
      if(shadow    == "") shadow    = "Plain";
      if(linewidth == "") linewidth = "1";
      if(margin    == "") margin    = "0";
      fout << "  pvQFrame(p," << id << "," << parent << "," << shape << "," << shadow << "," << linewidth << "," << margin << ");" << ENDL;
      if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    }
    else
    {
      if(strstr(whatsThis,".bmp") == NULL && strstr(whatsThis,".BMP") == NULL)
      {
        fout << "  pvDownloadFile(p,\"" << whatsThis << "\");" << ENDL;
        fout << "  pvQImage(p," << id << "," << parent << ",\"" << whatsThis << "\",&w,&h,&depth);" << ENDL;
        if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
      }
      else
      {
        fout << "  pvQImage(p," << id << "," << parent << ",\"" << whatsThis << "\",&w,&h,&depth);" << ENDL;
        if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << ",w,h);" << ENDL;
      }
    }    
  }
  else if(type == "Line")
  {
    if(shape     == "") shape     = "HLine";
    if(shadow    == "") shadow    = "Plain";
    if(linewidth == "") linewidth = "1";
    if(margin    == "") margin    = "0";
    fout << "  pvQFrame(p," << id << "," << parent << "," << shape << "," << shadow << "," << linewidth << "," << margin << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QDraw")
  {
    fout << "  pvQDraw(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QImage")
  {
    if(strstr(text,".bmp") == NULL && strstr(text,".BMP") == NULL)
    {
      fout << "  pvDownloadFile(p,\"" << text << "\");" << ENDL;
      fout << "  pvQImage(p," << id << "," << parent << ",\"" << text << "\",&w,&h,&depth);" << ENDL;
      if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    }
    else
    {
      fout << "  pvQImage(p," << id << "," << parent << ",\"" << text << "\",&w,&h,&depth);" << ENDL;
      if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << ",w,h);" << ENDL;
    }
  }
  else if(type == "QGLWidget")
  {
    fout << "  pvQGL(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "  pvGlBegin(p," << id << ");" << ENDL;
    fout << "  initializeGL(); // (todo: write your gl initialization routine) see example" << ENDL;
    fout << "  resizeGL(" << w << "," << h << ");  // (todo: write your resize routine) see example" << ENDL;
    fout << "  pvGlEnd(p);" << ENDL;
  }
  else if(type == "QVtkTclWidget")
  {
    fout << "  pvQVtkTclWidget(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QTabWidget")
  {
    fout << "  pvQTabWidget(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(tabposition != "0")
    {
      fout << "  pvSetTabPosition(p," << id << "," << tabposition << ");" << ENDL;
    }
  }
  else if(type == "QToolBox")
  {
    fout << "    pvQToolBox(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(tabposition != "0")
    {
      fout << "    pvSetTabPosition(p," << id << "," << tabposition << ");" << ENDL;
    }
  }
  else if(type == "QwtPlot")
  {
    fout << "  pvQwtPlotWidget(p," << id << "," << parent << "," << nCurves << "," << nMarker << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(canvasBackgroundRed != "")
    {
      fout << "  qpwSetCanvasBackground(p," << id << "," << canvasBackgroundRed   << ","
                                                         << canvasBackgroundGreen << ","
                                                         << canvasBackgroundBlue  << ");" << ENDL;
    }
    if(yLeftAxis   == "true")  fout << "  qpwEnableAxis(p," << id << ",yLeft);"   << ENDL;
    if(yRightAxis  == "true")  fout << "  qpwEnableAxis(p," << id << ",yRight);"  << ENDL;
    if(xBottomAxis == "true")  fout << "  qpwEnableAxis(p," << id << ",xBottom);" << ENDL;
    if(xTopAxis    == "true")  fout << "  qpwEnableAxis(p," << id << ",xTop);"    << ENDL;
    if(text        != "")      fout << "  qpwSetTitle(p,"   << id << ",\"" << text << "\");" << ENDL;
  }
  else if(type == "QwtScale")
  {
    fout << "  pvQwtScale(p," << id << "," << parent << ",0);" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(position == "Left")   fout << "  qwtScaleSetPosition(p," << id << ",ScaleLeft);" << ENDL;
    if(position == "Right")  fout << "  qwtScaleSetPosition(p," << id << ",ScaleRight);" << ENDL;
    if(position == "Top")    fout << "  qwtScaleSetPosition(p," << id << ",ScaleTop);" << ENDL;
    if(position == "Bottom") fout << "  qwtScaleSetPosition(p," << id << ",ScaleBottom);" << ENDL;
    if(title != "") fout << "  qwtScaleSetTitle(p," << id << "," << title << ");" << ENDL;
    if(titleFontfamily != "") fout << "  qwtScaleSetTitleFont(p," << id << ",\"" << titleFontfamily << "\"," << titleFontsize << "," << titleFontbold << "," << titleFontitalic << "," << titleFontunderline << "," << titleFontstrikeout << ");" << ENDL;
    if(titleColorRed != "") fout << "  qwtScaleSetTitleColor(p," << id << "," << titleColorRed << "," << titleColorGreen << "," << titleColorBlue << ");" << ENDL;
  }
  else if(type == "QwtThermo")
  {
    fout << "  pvQwtThermo(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QwtKnob")
  {
    fout << "  pvQwtKnob(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(readOnly == "true" ) fout << "  qwtKnobSetReadOnly(p," << id << ",1);" << ENDL;
    if(readOnly == "false") fout << "  qwtKnobSetReadOnly(p," << id << ",0);" << ENDL;
    if(mass     != "") fout << "  qwtKnobSetMass(p," << id << "," << mass << ");" << ENDL;
    if(orientation != "") fout << "  qwtKnobSetOrientation(p," << id << "," << orientation << ");" << ENDL;
    if(knobWidth   != "") fout << "  qwtKnobSetKnobWidth(p," << id << "," << knobWidth << ");" << ENDL;
    if(borderWidth != "") fout << "  qwtKnobSetBorderWidth(p," << id << "," << borderWidth << ");" << ENDL;
    if(totalAngle  != "") fout << "  qwtKnobSetTotalAngle(p," << id << "," << totalAngle << ");" << ENDL;
    if(symbol == "Line") fout << "  qwtKnobSetSymbol(p," << id << ",KnobLine);" << ENDL;
    if(symbol == "Dot" ) fout << "  qwtKnobSetSymbol(p," << id << ",KnobDot);" << ENDL;
  }
  else if(type == "QwtCounter")
  {
    fout << "  pvQwtCounter(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(numButtons  != "") fout << "  qwtCounterSetNumButtons(p," << id << "," << numButtons << ");" << ENDL;
    if(basicstep   != "") fout << "  qwtCounterSetStep(p," << id << "," << basicstep << ");" << ENDL;
    if(minValue    != "") fout << "  qwtCounterSetMinValue(p," << id << "," << minValue << ");" << ENDL;
    if(maxValue    != "") fout << "  qwtCounterSetMaxValue(p," << id << "," << maxValue << ");" << ENDL;
    if(stepButton1 != "") fout << "  qwtCounterSetStepButton1(p," << id << "," << stepButton1 << ");" << ENDL;
    if(stepButton2 != "") fout << "  qwtCounterSetStepButton2(p," << id << "," << stepButton2 << ");" << ENDL;
    if(stepButton3 != "") fout << "  qwtCounterSetStepButton3(p," << id << "," << stepButton3 << ");" << ENDL;
    if(value       != "") fout << "  qwtCounterSetValue(p," << id << "," << value << ");" << ENDL;
  }
  else if(type == "QwtWheel")
  {
    fout << "  pvQwtWheel(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(readOnly == "true" ) fout << "  qwtWheelSetReadOnly(p," << id << ",1);" << ENDL;
    if(readOnly == "false") fout << "  qwtWheelSetReadOnly(p," << id << ",0);" << ENDL;
    if(mass     != "") fout << "  qwtWheelSetMass(p," << id << "," << mass << ");" << ENDL;
    if(orientation != "") fout << "  qwtWheelSetOrientation(p," << id << "," << orientation << ");" << ENDL;
    if(totalAngle != "") fout << "  qwtWheelSetTotalAngle(p," << id << "," << totalAngle << ");" << ENDL;
    if(viewAngle  != "") fout << "  qwtWheelSetViewAngle(p,"  << id << "," << viewAngle  << ");" << ENDL;
    if(tickCnt    != "") fout << "  qwtWheelSetTickCnt(p,"    << id << "," << tickCnt    << ");" << ENDL;
    if(internalBorder != "") fout << "  qwtWheelSetInternalBorder(p," << id << "," << internalBorder << ");" << ENDL;
  }
  else if(type == "QwtSlider")
  {
    fout << "  pvQwtSlider(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(readOnly == "true" ) fout << "  qwtSliderSetReadOnly(p," << id << ",1);" << ENDL;
    if(readOnly == "false") fout << "  qwtSliderSetReadOnly(p," << id << ",0);" << ENDL;
    if(mass     != "") fout << "  qwtSliderSetMass(p," << id << "," << mass << ");" << ENDL;
    if(orientation != "") fout << "  qwtSliderSetOrientation(p," << id << "," << orientation << ");" << ENDL;
    if(thumbLength != "") fout << "  qwtSliderSetThumbLength(p," << id << "," << thumbLength << ");" << ENDL;
    if(thumbWidth  != "") fout << "  qwtSliderSetThumbWidth(p,"  << id << "," << thumbWidth  << ");" << ENDL;
    if(borderWidth != "") fout << "  qwtSliderSetBorderWidth(p," << id << "," << borderWidth << ");" << ENDL;
    if(bgStyle  == "BgTrough") fout << "  qwtSliderSetBgStyle(p," << id << "," <<  "SliderBgTrough);" << ENDL;
    if(bgStyle  == "BgSlot")   fout << "  qwtSliderSetBgStyle(p," << id << "," <<  "SliderBgSlot);" << ENDL;
    if(bgStyle  == "BgBoth")   fout << "  qwtSliderSetBgStyle(p," << id << "," <<  "SliderBgBoth);" << ENDL;
    if(scalePos == "None")  fout << "  qwtSliderSetScalePos(p,"    << id << ",SliderNone);" << ENDL;
    if(scalePos == "Left")  fout << "  qwtSliderSetScalePos(p,"    << id << ",SliderLeft);" << ENDL;
    if(scalePos == "Right") fout << "  qwtSliderSetScalePos(p,"    << id << ",SliderRight);" << ENDL;
    if(scalePos == "Top")   fout << "  qwtSliderSetScalePos(p,"    << id << ",SliderTop);" << ENDL;
    if(scalePos == "Bottom")fout << "  qwtSliderSetScalePos(p,"    << id << ",SliderBottom);" << ENDL;
    if(value != "") fout << "  qwtSliderSetValue(p," << id << "," << value << ");" << ENDL;
  }
  else if(type == "QwtCompass")
  {
    fout << "  pvQwtCompass(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(readOnly == "true" ) fout << "  qwtCompassSetReadOnly(p," << id << ",1);" << ENDL;
    if(readOnly == "false") fout << "  qwtCompassSetReadOnly(p," << id << ",0);" << ENDL;
    if(mass     != "") fout << "  qwtCompassSetMass(p," << id << "," << mass << ");" << ENDL;
    if(orientation != "") fout << "  qwtCompassSetOrientation(p," << id << "," << orientation << ");" << ENDL;
    if(visibleBackground == "false") fout << "  qwtCompassShowBackground(p," << id << ",0);" << ENDL;
    if(visibleBackground == "true" ) fout << "  qwtCompassShowBackground(p," << id << ",1);" << ENDL;
    if(linewidth         != "") fout << "  qwtCompassSetLineWidth(p," << id << "," << linewidth << ");" << ENDL;
    if(frameShadow == "Plain")  fout << "  qwtCompassSetFrameShadow(p," << id << ",DialPlain);" << ENDL;
    if(frameShadow == "Raised") fout << "  qwtCompassSetFrameShadow(p," << id << ",DialRaised);" << ENDL;
    if(frameShadow == "Sunken") fout << "  qwtCompassSetFrameShadow(p," << id << ",DialSunken);" << ENDL;
    if(origin != "") fout << "  qwtCompassSetOrigin(p," << id << "," << origin << ");" << ENDL;
    if(wrapping == "false") fout << "  qwtCompassSetWrapping(p," << id << ",0);" << ENDL;
    if(wrapping == "true" ) fout << "  qwtCompassSetWrapping(p," << id << ",1);" << ENDL;
  }
  else if(type == "QDateEdit")
  {
    fout << "  pvQDateEdit(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QTimeEdit")
  {
    fout << "  pvQTimeEdit(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(timeDisplay != "")
    {
      int h,m,s,ap;
      h = m = s = ap = 0;
      if(strstr((const char *) timeDisplay, "Hours")   != NULL) h = 1;
      if(strstr((const char *) timeDisplay, "Minutes") != NULL) m = 1;
      if(strstr((const char *) timeDisplay, "Seconds") != NULL) s = 1;
      if(strstr((const char *) timeDisplay, "AMPM")    != NULL) ap = 1;
      fout << "  pvSetTimeEditDisplay(p," << id << "," << h << "," << m << "," << s << "," << ap << ");" << ENDL;
    }
  }
  else if(type == "QDateTimeEdit")
  {
    fout << "  pvQDateTimeEdit(p," << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  pvSetGeometry(p," << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }

  if(foregroundred != "")
  {
    fout << "  pvSetPaletteForegroundColor(p," << id << "," << foregroundred << "," << foregroundgreen << "," << foregroundblue << ");" << ENDL;
  }
  if(backgroundred != "")
  {
    fout << "  pvSetPaletteBackgroundColor(p," << id << "," << backgroundred << "," << backgroundgreen << "," << backgroundblue << ");" << ENDL;
  }

  if(fontfamily != "" || fontpointsize != "" || fontbold != "" || fontitalic != "" || fontunderline != "" || fontstrikeout != "")
  {
    if(fontfamily    == "") fontfamily    = "helvetica";
    if(fontpointsize == "") fontpointsize = "10";
    if(fontbold      == "") fontbold      = "0";
    if(fontitalic    == "") fontitalic    = "0";
    if(fontunderline == "") fontunderline = "0";
    if(fontstrikeout == "") fontstrikeout = "0";
    fout << "  pvSetFont(p," << id << ",\"" << fontfamily << "\"," << fontpointsize << "," << fontbold << ","
         << fontitalic << "," << fontunderline << "," << fontstrikeout << ");" << ENDL;
  }

  if(tooltip   != "") fout << "  pvToolTip(p," << id << ",\"" << tooltip << "\");"        << ENDL;  
  if(shape     != "") fout << "  pvSetStyle(p," << id << "," << shape << ",-1,-1,-1);"    << ENDL;
  if(shadow    != "") fout << "  pvSetStyle(p," << id << ",-1," << shadow <<",-1,-1);"    << ENDL;
  if(linewidth != "") fout << "  pvSetStyle(p," << id << ",-1,-1," << linewidth<< ",-1);" << ENDL;
  if(margin    != "") fout << "  pvSetStyle(p," << id << ",-1,-1,-1," << margin << ");"   << ENDL;
  fout << ENDL;
}

void Generator::generateWidgetPython(ofstream &fout, const char *text)
{ 
  if(parent != "0") parent = "self." + parent;
  if(type == "QLayoutWidget")
  {
    if(vbox != "") fout << "    ret = pvQLayoutVbox(p,self." << id << "," << parent << ")" << ENDL;
    if(hbox != "") fout << "    ret = pvQLayoutHbox(p,self." << id << "," << parent << ")" << ENDL;
    if(grid != "") fout << "    ret = pvQLayoutGrid(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "")    fout << "    ret = pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QDialog")
  {
    if(vbox != "") fout << "    ret = pvQLayoutVbox(p,0,-1)" << ENDL;
    if(hbox != "") fout << "    ret = pvQLayoutHbox(p,0,-1)" << ENDL;
    if(grid != "") fout << "    ret = pvQLayoutGrid(p,0,-1)" << ENDL;
  }
  else if(type == "QPushButton")
  {
    fout << "    ret = pvs.pvQPushButton(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    fout << "    ret = pvs.pvSetText(p,self." << id << ",\"" << text << "\")" << ENDL;
  }
  else if(type == "QWidget")
  {
    fout << "    ret = pvs.pvQWidget(p,self." << id << "," << parent << ")" << ENDL;
    if(parentclass == "QTabWidget")
    {
      fout << "    ret = pvs.pvAddTab(p," << parent << ",self." << id << ",\"" << text << "\")" << ENDL;
    }
    else if(parentclass == "QToolBox")
    {
      fout << "    ret = pvs.pvAddTab(p," << parent << ",self." << id << ",\"" << text << "\");" << ENDL;
    }
    else
    {
      if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
      fout << "    ret = pvs.pvSetText(p,self." << id << ",\"" << text << "\")" << ENDL;
    }
  }
  else if(type == "QLabel")
  {
    if(whatsThis == "" || whatsThis[0] == '#')
    {
      fout << "    ret = pvs.pvQLabel(p,self." << id << "," << parent << ")" << ENDL;
      if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
      fout << "    ret = pvs.pvSetText(p,self." << id << ",\"" << text << "\")" << ENDL;
      if(alignment != "")
      {
        alignment.replace("|","|pvs.");
        fout << "    ret = pvs.pvSetAlignment(p,self." << id << ",pvs." << alignment << ")" << ENDL;
      }
    }
    else
    {
      if(strstr(whatsThis,".bmp") == NULL && strstr(whatsThis,".BMP") == NULL)
      {
        fout << "    ret = pvs.pvDownloadFile(p,\"" << whatsThis << "\")" << ENDL;
        fout << "    ret = pvs.pvQImage(p,self." << id << "," << parent << ",\"" << whatsThis << "\",w,h,depth)" << ENDL;
        if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
      }
      else
      {
        fout << "    ret = pvs.pvQImage(p,self." << id << "," << parent << ",\"" << whatsThis << "\",w,h,depth)" << ENDL;
        if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << ",w,h)" << ENDL;
      }
    }
  }
  else if(type == "QLineEdit")
  {
    fout << "    ret = pvs.pvQLineEdit(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    fout << "    ret = pvs.pvSetText(p,self." << id << ",\"" << text << "\")" << ENDL;
    if(editable == "false")
    {
      fout << "    ret = pvs.pvSetEditable(p,self." << id << ",0)" << ENDL;
    }
    if(echomode == "Password")
    {
      fout << "    ret = pvs.pvSetEchoMode(p,self." << id << ",2)" << ENDL;
    }
    else if(echomode == "NoEcho")
    {
      fout << "    ret = pvs.pvSetEchoMode(p,self." << id << ",0)" << ENDL;
    }
    if(alignment != "")
    {
      alignment.replace("|","|pvs.");
      fout << "    ret = pvs.pvSetAlignment(p,self." << id << ",pvs." << alignment << ")" << ENDL;
    }
  }
  else if(type == "QMultiLineEdit" || type == "PVMultiLineEdit" || type == "QTextEdit")
  {
    if(editable == "")        editable = "1";
    if(editable == "true")    editable = "1";
    if(editable == "false")   editable = "0";
    if(maxlines != "-1")
    {
      char buf[32];
      int  ival;
      sscanf(maxlines,"%d",&ival);
      sprintf(buf,"%d",-ival);
      maxlines = buf;
    }
    fout << "    ret = pvs.pvQMultiLineEdit(p,self." << id << "," << parent << "," << editable << "," << maxlines << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QTextBrowser")
  {
    fout << "    ret = pvs.pvQTextBrowser(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QListView")
  {
    fout << "    ret = pvs.pvQListView(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    if(selectionmode == "Multi")
    {
      fout << "    ret = pvs.pvSetMultiSelection(p,self." << id << ",1)" << ENDL;
    }
    else if(selectionmode == "NoSelection")
    {
      fout << "    ret = pvs.pvSetMultiSelection(p,self." << id << ",2)" << ENDL;
    }
  }
  else if(type == "QComboBox")
  {
    if(insertionpolicy == "") insertionpolicy = "pvs.AtTop";
    if(editable == "")        editable = "0";
    if(editable == "true")    editable = "1";
    if(editable == "false")   editable = "0";
    fout << "    ret = pvs.pvQComboBox(p,self." << id << "," << parent << "," << editable << "," << insertionpolicy << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QLCDNumber")
  {
    if(mode      == "") mode      = "pvs.Dec";
    if(style     == "") style     = "pvs.Outline";
    if(numdigits == "") numdigits = "2";
    fout << "    ret = pvs.pvQLCDNumber(p,self." << id << "," << parent << "," << numdigits << "," << style << "," << mode << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QSlider")
  {
    if(pagestep    == "") pagestep    = "10";
    if(value       == "") value       = "0";
    if(minvalue    == "") minvalue    = "0";
    if(maxvalue    == "") maxvalue    = "99";
    if(orientation == "") orientation = "pvs.Vertical";
    else                  orientation = "pvs." + orientation;
    fout << "    ret = pvs.pvQSlider(p,self." << id << "," << parent << "," << minvalue << "," << maxvalue << "," << pagestep << "," << value << "," << orientation << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QButtonGroup")
  {
    fout << "    ret = pvs.pvQButtonGroup(p,self." << id << "," << parent << ",-1,pvs.HORIZONTAL,\"" << text << "\")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QGroupBox")
  {
    fout << "    ret = pvs.pvQGroupBox(p,self." << id << "," << parent << ",-1,pvs.HORIZONTAL,\"" << text << "\")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QListBox")
  {
    fout << "    ret = pvs.pvQListBox(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    if(selectionmode == "Multi")
    {
      fout << "    ret = pvs.pvSetSelectionMode(p,self." << id << ",2)" << ENDL;
    }
    else if(selectionmode == "NoSelection")
    {
      fout << "    ret = pvs.pvSetSelectionMode(p,self." << id << ",0)" << ENDL;
    }
  }
  else if(type == "QIconView")
  {
    fout << "    ret = pvs.pvQIconView(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QTable")
  {
    fout << "    ret = pvs.pvQTable(p,self." << id << "," << parent << "," << numRows << "," << numCols << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    if(editable == "false")
    {
      fout << "    ret = pvs.pvSetEditable(p,self." << id << ",0)" << ENDL;
    }
  }
  else if(type == "QSpinBox")
  {
    fout << "    ret = pvs.pvQSpinBox(p,self." << id << "," << parent << "," << minvalue << "," << maxvalue << ",1)" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QDial")
  {
    fout << "    ret = pvs.pvQDial(p,self." << id << "," << parent << "," << minvalue << "," << maxvalue << "," << pagestep << "," << value << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QProgressBar")
  {
    fout << "    ret = pvs.pvQProgressBar(p,self." << id << "," << parent << "," << progress << ")"            << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QRadioButton")
  {
    fout << "    ret = pvs.pvQRadioButton(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    fout << "    ret = pvs.pvSetText(p,self." << id << ",\"" << text << "\")" << ENDL;
    if(checked == "true")
    {
      fout << "    ret = pvs.pvSetChecked(p,self." << id << ",1)" << ENDL;
    }
  }
  else if(type == "QCheckBox")
  {
    fout << "    ret = pvs.pvQCheckBox(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    fout << "    ret = pvs.pvSetText(p,self." << id << ",\"" << text << "\")" << ENDL;
    if(checked == "true")
    {
      fout << "    ret = pvs.pvSetChecked(p,self." << id << ",1)" << ENDL;
    }
  }
  else if(type == "QFrame")
  {
    if(whatsThis == "" || whatsThis[0] == '#')
    {
      if(shape     == "") shape     = "pvs.NoFrame";
      else                shape     = "pvs." + shape;
      if(shadow    == "") shadow    = "pvs.Plain";
      else                shadow    = "pvs." + shadow;
      if(linewidth == "") linewidth = "1";
      if(margin    == "") margin    = "0";
      fout << "    ret = pvs.pvQFrame(p,self." << id << "," << parent << "," << shape << "," << shadow << "," << linewidth << "," << margin << ")" << ENDL;
      if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    }
    else
    {
      if(strstr(whatsThis,".bmp") == NULL && strstr(whatsThis,".BMP") == NULL)
      {
        fout << "    ret = pvs.pvDownloadFile(p,\"" << whatsThis << "\")" << ENDL;
        fout << "    ret = pvs.pvQImage(p,self." << id << "," << parent << ",\"" << whatsThis << "\",w,h,depth)" << ENDL;
        if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
      }
      else
      {
        fout << "    ret = pvs.pvQImage(p,self." << id << "," << parent << ",\"" << whatsThis << "\",w,h,depth)" << ENDL;
        if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << ",w,h)" << ENDL;
      }
    }
  }
  else if(type == "Line")
  {
    if(shape     == "") shape     = "pvs.HLine";
    else                shape     = "pvs." + shape;
    if(shadow    == "") shadow    = "pvs.Plain";
    else                shadow    = "pvs." + shadow;
    if(linewidth == "") linewidth = "1";
    if(margin    == "") margin    = "0";
    fout << "    ret = pvs.pvQFrame(p,self." << id << "," << parent << "," << shape << "," << shadow << "," << linewidth << "," << margin << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QDraw")
  {
    fout << "    ret = pvs.pvQDraw(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QImage")
  {
    if(strstr(text,".bmp") == NULL && strstr(text,".BMP") == NULL)
    {
      fout << "    ret = pvs.pvDownloadFile(p,\"" << text << "\")" << ENDL;
      fout << "    ret = pvs.pvQImage(p,self." << id << "," << parent << ",\"" << text << "\",w,h,depth)" << ENDL;
      if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    }
    else
    {
      fout << "    ret = pvs.pvQImage(p,self." << id << "," << parent << ",\"" << text << "\",w,h,depth)" << ENDL;
      if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << ",w,h)" << ENDL;
    }
  }
  else if(type == "QGLWidget")
  {
    fout << "    ret = pvs.pvQGL(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    fout << "    ret = pvs.pvGlBegin(p,self." << id << ")" << ENDL;
    fout << "    initializeGL() # (todo: write your gl initialization routine) see example" << ENDL;
    fout << "    resizeGL(" << w << "," << h << ")  # (todo: write your resize routine) see example" << ENDL;
    fout << "    ret = pvs.pvGlEnd(p)" << ENDL;
  }
  else if(type == "QVtkTclWidget")
  {
    fout << "    ret = pvs.pvQVtkTclWidget(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QTabWidget")
  {
    fout << "    ret = pvs.pvQTabWidget(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    if(tabposition != "0")
    {
      fout << "    ret = pvs.pvSetTabPosition(p,self." << id << "," << tabposition << ")" << ENDL;
    }
  }
  else if(type == "QToolBox")
  {
    fout << "    ret = pvs.pvQToolBox(p,self." << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(tabposition != "0")
    {
      fout << "    ret = pvs.pvSetTabPosition(p,self." << id << "," << tabposition << ");" << ENDL;
    }
  }
  else if(type == "QwtPlot")
  {
    fout << "    ret = pvs.pvQwtPlotWidget(p,self." << id << "," << parent << "," << nCurves << "," << nMarker << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    if(canvasBackgroundRed != "")
    {
      fout << "    ret = pvs.qpwSetCanvasBackground(p,self." << id << "," << canvasBackgroundRed   << ","
                                                         << canvasBackgroundGreen << ","
                                                         << canvasBackgroundBlue  << ")" << ENDL;
    }
    if(yLeftAxis   == "true")  fout << "    ret = pvs.qpwEnableAxis(p,self." << id << ",pvs.yLeft)"   << ENDL;
    if(yRightAxis  == "true")  fout << "    ret = pvs.qpwEnableAxis(p,self." << id << ",pvs.yRight)"  << ENDL;
    if(xBottomAxis == "true")  fout << "    ret = pvs.qpwEnableAxis(p,self." << id << ",pvs.xBottom)" << ENDL;
    if(xTopAxis    == "true")  fout << "    ret = pvs.qpwEnableAxis(p,self." << id << ",pvs.xTop)"    << ENDL;
    if(text        != "")      fout << "    ret = pvs.qpwSetTitle(p,self."   << id << ",\"" << text << "\")" << ENDL;
  }
  else if(type == "QwtScale")
  {
    fout << "    ret = pvs.pvQwtScale(p,self." << id << "," << parent << ",0)" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    if(position == "Left")   fout << "    ret = pvs.qwtScaleSetPosition(p,self." << id << ",pvs.ScaleLeft)" << ENDL;
    if(position == "Right")  fout << "    ret = pvs.qwtScaleSetPosition(p,self." << id << ",pvs.ScaleRight)" << ENDL;
    if(position == "Top")    fout << "    ret = pvs.qwtScaleSetPosition(p,self." << id << ",pvs.ScaleTop)" << ENDL;
    if(position == "Bottom") fout << "    ret = pvs.qwtScaleSetPosition(p,self." << id << ",pvs.ScaleBottom)" << ENDL;
    if(title != "") fout << "    ret = pvs.qwtScaleSetTitle(p,self." << id << "," << title << ")" << ENDL;
    if(titleFontfamily != "") fout << "    ret = pvs.qwtScaleSetTitleFont(p,self." << id << ",\"" << titleFontfamily << "\"," << titleFontsize << "," << titleFontbold << "," << titleFontitalic << "," << titleFontunderline << "," << titleFontstrikeout << ")" << ENDL;
    if(titleColorRed != "") fout << "    ret = pvs.qwtScaleSetTitleColor(p,self." << id << ",pvs." << titleColorRed << "," << titleColorGreen << "," << titleColorBlue << ")" << ENDL;
  }
  else if(type == "QwtThermo")
  {
    fout << "    ret = pvs.pvQwtThermo(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QwtKnob")
  {
    fout << "    ret = pvs.pvQwtKnob(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    if(readOnly == "true" ) fout << "    ret = pvs.qwtKnobSetReadOnly(p,self." << id << ",1)" << ENDL;
    if(readOnly == "false") fout << "    ret = pvs.qwtKnobSetReadOnly(p,self." << id << ",0)" << ENDL;
    if(mass     != "") fout << "    ret = pvs.qwtKnobSetMass(p,self." << id << "," << mass << ")" << ENDL;
    if(orientation != "") fout << "    ret = pvs.qwtKnobSetOrientation(p,self." << id << ",pvs." << orientation << ")" << ENDL;
    if(knobWidth   != "") fout << "    ret = pvs.qwtKnobSetKnobWidth(p,self." << id << "," << knobWidth << ")" << ENDL;
    if(borderWidth != "") fout << "    ret = pvs.qwtKnobSetBorderWidth(p,self." << id << "," << borderWidth << ")" << ENDL;
    if(totalAngle  != "") fout << "    ret = pvs.qwtKnobSetTotalAngle(p,self." << id << "," << totalAngle << ")" << ENDL;
    if(symbol == "Line") fout << "    ret = pvs.qwtKnobSetSymbol(p,self." << id << ",pvs.KnobLine)" << ENDL;
    if(symbol == "Dot" ) fout << "    ret = pvs.qwtKnobSetSymbol(p,self." << id << ",pvs.KnobDot)" << ENDL;
  }
  else if(type == "QwtCounter")
  {
    fout << "    ret = pvs.pvQwtCounter(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    if(numButtons  != "") fout << "    ret = pvs.qwtCounterSetNumButtons(p,self." << id << "," << numButtons << ")" << ENDL;
    if(basicstep   != "") fout << "    ret = pvs.qwtCounterSetStep(p,self." << id << "," << basicstep << ")" << ENDL;
    if(minValue    != "") fout << "    ret = pvs.qwtCounterSetMinValue(p,self." << id << "," << minValue << ")" << ENDL;
    if(maxValue    != "") fout << "    ret = pvs.qwtCounterSetMaxValue(p,self." << id << "," << maxValue << ")" << ENDL;
    if(stepButton1 != "") fout << "    ret = pvs.qwtCounterSetStepButton1(p,self." << id << "," << stepButton1 << ")" << ENDL;
    if(stepButton2 != "") fout << "    ret = pvs.qwtCounterSetStepButton2(p,self." << id << "," << stepButton2 << ")" << ENDL;
    if(stepButton3 != "") fout << "    ret = pvs.qwtCounterSetStepButton3(p,self." << id << "," << stepButton3 << ")" << ENDL;
    if(value       != "") fout << "    ret = pvs.qwtCounterSetValue(p,self." << id << "," << value << ")" << ENDL;
  }
  else if(type == "QwtWheel")
  {
    fout << "    ret = pvs.pvQwtWheel(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    if(readOnly == "true" ) fout << "    ret = pvs.qwtWheelSetReadOnly(p,self." << id << ",1)" << ENDL;
    if(readOnly == "false") fout << "    ret = pvs.qwtWheelSetReadOnly(p,self." << id << ",0)" << ENDL;
    if(mass     != "") fout << "    ret = pvs.qwtWheelSetMass(p,self." << id << "," << mass << ")" << ENDL;
    if(orientation != "") fout << "    ret = pvs.qwtWheelSetOrientation(p,self." << id << ",pvs." << orientation << ")" << ENDL;
    if(totalAngle != "") fout << "    ret = pvs.qwtWheelSetTotalAngle(p,self." << id << "," << totalAngle << ")" << ENDL;
    if(viewAngle  != "") fout << "    ret = pvs.qwtWheelSetViewAngle(p,self."  << id << "," << viewAngle  << ")" << ENDL;
    if(tickCnt    != "") fout << "    ret = pvs.qwtWheelSetTickCnt(p,self."    << id << "," << tickCnt    << ")" << ENDL;
    if(internalBorder != "") fout << "    ret = pvs.qwtWheelSetInternalBorder(p,self." << id << "," << internalBorder << ")" << ENDL;
  }
  else if(type == "QwtSlider")
  {
    fout << "    ret = pvs.pvQwtSlider(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    if(readOnly == "true" ) fout << "    ret = pvs.qwtSliderSetReadOnly(p,self." << id << ",1)" << ENDL;
    if(readOnly == "false") fout << "    ret = pvs.qwtSliderSetReadOnly(p,self." << id << ",0)" << ENDL;
    if(mass     != "") fout << "    ret = pvs.qwtSliderSetMass(p,self." << id << "," << mass << ")" << ENDL;
    if(orientation != "") fout << "    ret = pvs.qwtSliderSetOrientation(p,self." << id << ",pvs." << orientation << ")" << ENDL;
    if(thumbLength != "") fout << "    ret = pvs.qwtSliderSetThumbLength(p,self." << id << "," << thumbLength << ")" << ENDL;
    if(thumbWidth  != "") fout << "    ret = pvs.qwtSliderSetThumbWidth(p,self."  << id << "," << thumbWidth  << ")" << ENDL;
    if(borderWidth != "") fout << "    ret = pvs.qwtSliderSetBorderWidth(p,self." << id << "," << borderWidth << ")" << ENDL;
    if(bgStyle  == "BgTrough") fout << "    ret = pvs.qwtSliderSetBgStyle(p,self." << id << "," <<  "pvs.SliderBgTrough)" << ENDL;
    if(bgStyle  == "BgSlot")   fout << "    ret = pvs.qwtSliderSetBgStyle(p,self." << id << "," <<  "pvs.SliderBgSlot)" << ENDL;
    if(bgStyle  == "BgBoth")   fout << "    ret = pvs.qwtSliderSetBgStyle(p,self." << id << "," <<  "pvs.SliderBgBoth)" << ENDL;
    if(scalePos == "None")  fout << "    ret = pvs.qwtSliderSetScalePos(p,self."    << id << ",pvs.SliderNone)" << ENDL;
    if(scalePos == "Left")  fout << "    ret = pvs.qwtSliderSetScalePos(p,self."    << id << ",pvs.SliderLeft)" << ENDL;
    if(scalePos == "Right") fout << "    ret = pvs.qwtSliderSetScalePos(p,self."    << id << ",pvs.SliderRight)" << ENDL;
    if(scalePos == "Top")   fout << "    ret = pvs.qwtSliderSetScalePos(p,self."    << id << ",pvs.SliderTop)" << ENDL;
    if(scalePos == "Bottom")fout << "    ret = pvs.qwtSliderSetScalePos(p,self."    << id << ",pvs.SliderBottom)" << ENDL;
    if(value != "") fout << "    ret = pvs.qwtSliderSetValue(p,self." << id << "," << value << ")" << ENDL;
  }
  else if(type == "QwtCompass")
  {
    fout << "    ret = pvs.pvQwtCompass(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "    ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    if(readOnly == "true" ) fout << "    ret = pvs.qwtCompassSetReadOnly(p,self." << id << ",1)" << ENDL;
    if(readOnly == "false") fout << "    ret = pvs.qwtCompassSetReadOnly(p,self." << id << ",0)" << ENDL;
    if(mass     != "") fout << "    ret = pvs.qwtCompassSetMass(p,self." << id << "," << mass << ")" << ENDL;
    if(orientation != "") fout << "    ret = pvs.qwtCompassSetOrientation(p,self." << id << ",pvs." << orientation << ")" << ENDL;
    if(visibleBackground == "false") fout << "    ret = pvs.qwtCompassShowBackground(p,self." << id << ",0)" << ENDL;
    if(visibleBackground == "true" ) fout << "    ret = pvs.qwtCompassShowBackground(p,self." << id << ",1)" << ENDL;
    if(linewidth         != "") fout << "    ret = pvs.qwtCompassSetLineWidth(p,self." << id << "," << linewidth << ")" << ENDL;
    if(frameShadow == "Plain")  fout << "    ret = pvs.qwtCompassSetFrameShadow(p,self." << id << ",pvs.DialPlain)" << ENDL;
    if(frameShadow == "Raised") fout << "    ret = pvs.qwtCompassSetFrameShadow(p,self." << id << ",pvs.DialRaised)" << ENDL;
    if(frameShadow == "Sunken") fout << "    ret = pvs.qwtCompassSetFrameShadow(p,self." << id << ",pvs.DialSunken)" << ENDL;
    if(origin != "") fout << "    ret = pvs.qwtCompassSetOrigin(p,self." << id << "," << origin << ")" << ENDL;
    if(wrapping == "false") fout << "    ret = pvs.qwtCompassSetWrapping(p,self." << id << ",0)" << ENDL;
    if(wrapping == "true" ) fout << "    ret = pvs.qwtCompassSetWrapping(p,self." << id << ",1)" << ENDL;
  }
  else if(type == "QDateEdit")
  {
    fout << "  ret = pvs.pvQDateEdit(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "  ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }
  else if(type == "QTimeEdit")
  {
    fout << "  ret = pvs.pvQTimeEdit(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "  ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
    if(timeDisplay != "")
    {
      int h,m,s,ap;
      h = m = s = ap = 0;
      if(strstr((const char *) timeDisplay, "Hours")   != NULL) h = 1;
      if(strstr((const char *) timeDisplay, "Minutes") != NULL) m = 1;
      if(strstr((const char *) timeDisplay, "Seconds") != NULL) s = 1;
      if(strstr((const char *) timeDisplay, "AMPM")    != NULL) ap = 1;
      fout << "  ret = pvs.pvSetTimeEditDisplay(p,self." << id << "," << h << "," << m << "," << s << "," << ap << ")" << ENDL;
    }
  }
  else if(type == "QDateTimeEdit")
  {
    fout << "  ret = pvs.pvQDateTimeEdit(p,self." << id << "," << parent << ")" << ENDL;
    if(x != "") fout << "  ret = pvs.pvSetGeometry(p,self." << id << "," << x << "," << y << "," << w << "," << h << ")" << ENDL;
  }

  if(foregroundred != "")
  {
    fout << "    ret = pvs.pvSetPaletteForegroundColor(p,self." << id << "," << foregroundred << "," << foregroundgreen << "," << foregroundblue << ")" << ENDL;
  }
  if(backgroundred != "")
  {
    fout << "    ret = pvs.pvSetPaletteBackgroundColor(p,self." << id << "," << backgroundred << "," << backgroundgreen << "," << backgroundblue << ")" << ENDL;
  }

  if(fontfamily != "" || fontpointsize != "" || fontbold != "" || fontitalic != "" || fontunderline != "" || fontstrikeout != "")
  {
    if(fontfamily    == "") fontfamily    = "helvetica";
    if(fontpointsize == "") fontpointsize = "10";
    if(fontbold      == "") fontbold      = "0";
    if(fontitalic    == "") fontitalic    = "0";
    if(fontunderline == "") fontunderline = "0";
    if(fontstrikeout == "") fontstrikeout = "0";
    fout << "    ret = pvs.pvSetFont(p,self." << id << ",\"" << fontfamily << "\"," << fontpointsize << "," << fontbold << ","
         << fontitalic << "," << fontunderline << "," << fontstrikeout << ")" << ENDL;
  }

  if(tooltip   != "") fout << "    ret = pvs.pvToolTip(p,self."  << id << ",\"" << tooltip << "\")"       << ENDL;
  if(shape     != "") fout << "    ret = pvs.pvSetStyle(p,self." << id << "," << shape << ",-1,-1,-1)"    << ENDL;
  if(shadow    != "") fout << "    ret = pvs.pvSetStyle(p,self." << id << ",-1," << shadow <<",-1,-1)"    << ENDL;
  if(linewidth != "") fout << "    ret = pvs.pvSetStyle(p,self." << id << ",-1,-1," << linewidth<< ",-1)" << ENDL;
  if(margin    != "") fout << "    ret = pvs.pvSetStyle(p,self." << id << ",-1,-1,-1," << margin << ")"   << ENDL;
  fout << ENDL;
}

void Generator::generateWidgetPerl(ofstream &fout, const char *text)
{ 
  if(parent != "0") parent = "$" + parent;
  if(type == "QLayoutWidget")
  {
    if(vbox != "") fout << "  $ret = pv::pvQLayoutVbox($p,$" << id << "," << parent << ");" << ENDL;
    if(hbox != "") fout << "  $ret = pv::pvQLayoutHbox($p,$" << id << "," << parent << ");" << ENDL;
    if(grid != "") fout << "  $ret = pv::pvQLayoutGrid($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "")    fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QDialog")
  {
    if(vbox != "") fout << "  $ret = pv::pvQLayoutVbox($p,0,-1);" << ENDL;
    if(hbox != "") fout << "  $ret = pv::pvQLayoutHbox($p,0,-1);" << ENDL;
    if(grid != "") fout << "  $ret = pv::pvQLayoutGrid($p,0,-1);" << ENDL;
  }
  else if(type == "QPushButton")
  {
    fout << "  $ret = pv::pvQPushButton($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "  $ret = pv::pvSetText($p,$" << id << ",\"" << text << "\");" << ENDL;
  }
  else if(type == "QWidget")
  {
    fout << "  $ret = pv::pvQWidget($p,$" << id << "," << parent << ");" << ENDL;
    if(parentclass == "QTabWidget")
    {
      fout << "  $ret = pv::pvAddTab($p," << parent << ",$" << id << ",\"" << text << "\");" << ENDL;
    }
    else if(parentclass == "QToolBox")
    {
      fout << "    $ret = pv::pvAddTab($p," << parent << ",$" << id << ",\"" << text << "\");" << ENDL;
    }
    else
    {
      if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
      fout << "  $ret = pv::pvSetText($p,$" << id << ",\"" << text << "\");" << ENDL;
    }
  }
  else if(type == "QLabel")
  {
    if(whatsThis == "" || whatsThis[0] == '#')
    {
      fout << "  $ret = pv::pvQLabel($p,$" << id << "," << parent << ");" << ENDL;
      if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
      fout << "  $ret = pv::pvSetText($p,$" << id << ",\"" << text << "\");" << ENDL;
      if(alignment != "")
      {
        alignment.replace("|","|pv::");
        fout << "  $ret = pv::pvSetAlignment($p,$" << id << ",pv::" << alignment << ");" << ENDL;
      }
    }
    else
    {
      if(strstr(whatsThis,".bmp") == NULL && strstr(whatsThis,".BMP") == NULL)
      {
        fout << "  $ret = pv::pvDownloadFile($p,\"" << whatsThis << "\");" << ENDL;
        fout << "  $ret = pv::pvQImage($p,$" << id << "," << parent << ",\"" << whatsThis << "\",$w,$h,$depth);" << ENDL;
        if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
      }
      else
      {
        fout << "  $ret = pv::pvQImage($p,$" << id << "," << parent << ",\"" << whatsThis << "\",$w,$h,$depth);" << ENDL;
        if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << ",pv::get_int($w),pv::get_int($h));" << ENDL;
      }
    }
  }
  else if(type == "QLineEdit")
  {
    fout << "  $ret = pv::pvQLineEdit($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "  $ret = pv::pvSetText($p,$" << id << ",\"" << text << "\");" << ENDL;
    if(editable == "false")
    {
      fout << "  $ret = pv::pvSetEditable($p,$" << id << ",0);" << ENDL;
    }
    if(echomode == "Password")
    {
      fout << "  $ret = pv::pvSetEchoMode($p,$" << id << ",2);" << ENDL;
    }
    else if(echomode == "NoEcho")
    {
      fout << "  $ret = pv::pvSetEchoMode($p,$" << id << ",0);" << ENDL;
    }
    if(alignment != "")
    {
      alignment.replace("|","|pv::");
      fout << "  $ret = pv::pvSetAlignment($p,$" << id << ",pv::" << alignment << ");" << ENDL;
    }
  }
  else if(type == "QMultiLineEdit" || type == "PVMultiLineEdit" || type == "QTextEdit")
  {
    if(editable == "")        editable = "1";
    if(editable == "true")    editable = "1";
    if(editable == "false")   editable = "0";
    if(maxlines != "-1")
    {
      char buf[32];
      int  ival;
      sscanf(maxlines,"%d",&ival);
      sprintf(buf,"%d",-ival);
      maxlines = buf;
    }
    fout << "  $ret = pv::pvQMultiLineEdit($p,$" << id << "," << parent << "," << editable << "," << maxlines << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QTextBrowser")
  {
    fout << "  $ret = pv::pvQTextBrowser($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QListView")
  {
    fout << "  $ret = pv::pvQListView($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(selectionmode == "Multi")
    {
      fout << "  $ret = pv::pvSetMultiSelection($p,$" << id << ",1);" << ENDL;
    }
    else if(selectionmode == "NoSelection")
    {
      fout << "  $ret = pv::pvSetMultiSelection($p,$" << id << ",2);" << ENDL;
    }
  }
  else if(type == "QComboBox")
  {
    if(insertionpolicy == "") insertionpolicy = "AtTop";
    if(editable == "")        editable = "0";
    if(editable == "true")    editable = "1";
    if(editable == "false")   editable = "0";
    fout << "  $ret = pv::pvQComboBox($p,$" << id << "," << parent << "," << editable << ",pv::" << insertionpolicy << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QLCDNumber")
  {
    if(mode      == "") mode      = "Dec";
    if(style     == "") style     = "Outline";
    if(numdigits == "") numdigits = "2";
    fout << "  $ret = pv::pvQLCDNumber($p,$" << id << "," << parent << "," << numdigits << ",pv::" << style << ",pv::" << mode << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QSlider")
  {
    if(pagestep    == "") pagestep    = "10";
    if(value       == "") value       = "0";
    if(minvalue    == "") minvalue    = "0";
    if(maxvalue    == "") maxvalue    = "99";
    if(orientation == "") orientation = "Vertical";
    fout << "  $ret = pv::pvQSlider($p,$" << id << "," << parent << "," << minvalue << "," << maxvalue << "," << pagestep << "," << value << ",pv::" << orientation << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QButtonGroup")
  {
    fout << "  $ret = pv::pvQButtonGroup($p,$" << id << "," << parent << ",-1,pv::HORIZONTAL,\"" << text << "\");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QGroupBox")
  {
    fout << "  $ret = pv::pvQGroupBox($p,$" << id << "," << parent << ",-1,pv::HORIZONTAL,\"" << text << "\");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QListBox")
  {
    fout << "  $ret = pv::pvQListBox($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(selectionmode == "Multi")
    {
      fout << "  $ret = pv::pvSetSelectionMode($p,$" << id << ",2);" << ENDL;
    }
    else if(selectionmode == "NoSelection")
    {
      fout << "  $ret = pv::pvSetSelectionMode($p,$" << id << ",0);" << ENDL;
    }
  }
  else if(type == "QIconView")
  {
    fout << "  $ret = pv::pvQIconView($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QTable")
  {
    fout << "  $ret = pv::pvQTable($p,$" << id << "," << parent << "," << numRows << "," << numCols << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(editable == "false")
    {
      fout << "  $ret = pv::pvSetEditable($p,$" << id << ",0);" << ENDL;
    }
  }
  else if(type == "QSpinBox")
  {
    fout << "  $ret = pv::pvQSpinBox($p,$" << id << "," << parent << "," << minvalue << "," << maxvalue << ",1);" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QDial")
  {
    fout << "  $ret = pv::pvQDial($p,$" << id << "," << parent << "," << minvalue << "," << maxvalue << "," << pagestep << "," << value << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QProgressBar")
  {
    fout << "  $ret = pv::pvQProgressBar($p,$" << id << "," << parent << "," << progress << ");"            << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QRadioButton")
  {
    fout << "  $ret = pv::pvQRadioButton($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "  $ret = pv::pvSetText($p,$" << id << ",\"" << text << "\");" << ENDL;
    if(checked == "true")
    {
      fout << "  $ret = pv::pvSetChecked($p,$" << id << ",1);" << ENDL;
    }
  }
  else if(type == "QCheckBox")
  {
    fout << "  $ret = pv::pvQCheckBox($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "  $ret = pv::pvSetText($p,$" << id << ",\"" << text << "\");" << ENDL;
    if(checked == "true")
    {
      fout << "  $ret = pv::pvSetChecked($p,$" << id << ",1);" << ENDL;
    }
  }
  else if(type == "QFrame")
  {
    if(whatsThis == "" || whatsThis[0] == '#')
    {
      if(shape     == "") shape     = "NoFrame";
      if(shadow    == "") shadow    = "Plain";
      if(linewidth == "") linewidth = "1";
      if(margin    == "") margin    = "0";
      fout << "  $ret = pv::pvQFrame($p,$" << id << "," << parent << ",pv::" << shape << ",pv::" << shadow << "," << linewidth << "," << margin << ");" << ENDL;
      if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    }
    else
    {
      if(strstr(whatsThis,".bmp") == NULL && strstr(whatsThis,".BMP") == NULL)
      {
        fout << "  $ret = pv::pvDownloadFile($p,\"" << whatsThis << "\");" << ENDL;
        fout << "  $ret = pv::pvQImage($p,$" << id << "," << parent << ",\"" << whatsThis << "\",$w,$h,$depth);" << ENDL;
        if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
      }
      else
      {
        fout << "  $ret = pv::pvQImage($p,$" << id << "," << parent << ",\"" << whatsThis << "\",$w,$h,$depth);" << ENDL;
        if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << ",pv::get_int($w),pv::get_int($h));" << ENDL;
      }
    }
  }
  else if(type == "Line")
  {
    if(shape     == "") shape     = "HLine";
    if(shadow    == "") shadow    = "Plain";
    if(linewidth == "") linewidth = "1";
    if(margin    == "") margin    = "0";
    fout << "  $ret = pv::pvQFrame($p,$" << id << "," << parent << ",pv::" << shape << ",pv::" << shadow << "," << linewidth << "," << margin << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QDraw")
  {
    fout << "  $ret = pv::pvQDraw($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QImage")
  {
    if(strstr(text,".bmp") == NULL && strstr(text,".BMP") == NULL)
    {
      fout << "  $ret = pv::pvDownloadFile($p,\"" << text << "\");" << ENDL;
      fout << "  $ret = pv::pvQImage($p,$" << id << "," << parent << ",\"" << text << "\",$w,$h,$depth);" << ENDL;
      if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    }
    else
    {
      fout << "  $ret = pv::pvQImage($p,$" << id << "," << parent << ",\"" << text << "\",$w,$h,$depth);" << ENDL;
      if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << ",pv::get_int($w),pv::_get_int($h));" << ENDL;
    }
  }
  else if(type == "QGLWidget")
  {
    fout << "  $ret = pv::pvQGL($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "  $ret = pv::pvGlBegin($p,$" << id << ");" << ENDL;
    fout << "  initializeGL(); // (todo: write your gl initialization routine) see example" << ENDL;
    fout << "  resizeGL(" << w << "," << h << ");  // (todo: write your resize routine) see example" << ENDL;
    fout << "  $ret = pv::pvGlEnd($p);" << ENDL;
  }
  else if(type == "QVtkTclWidget")
  {
    fout << "  $ret = pv::pvQVtkTclWidget($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QTabWidget")
  {
    fout << "  $ret = pv::pvQTabWidget($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(tabposition != "0")
    {
      fout << "  $ret = pv::pvSetTabPosition($p,$" << id << "," << tabposition << ");" << ENDL;
    }
  }
  else if(type == "QToolBox")
  {
    fout << "    $ret = pv:pvQToolBox($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pv:pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(tabposition != "0")
    {
      fout << "    $ret = pv:pvSetTabPosition($p,$" << id << "," << tabposition << ");" << ENDL;
    }
  }
  else if(type == "QwtPlot")
  {
    fout << "  $ret = pv::pvQwtPlotWidget($p,$" << id << "," << parent << "," << nCurves << "," << nMarker << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(canvasBackgroundRed != "")
    {
      fout << "  $ret = pv::qpwSetCanvasBackground($p,$" << id << "," << canvasBackgroundRed   << ","
                                                         << canvasBackgroundGreen << ","
                                                         << canvasBackgroundBlue  << ");" << ENDL;
    }
    if(yLeftAxis   == "true")  fout << "  $ret = pv::qpwEnableAxis($p,$" << id << ",pv::yLeft);"   << ENDL;
    if(yRightAxis  == "true")  fout << "  $ret = pv::qpwEnableAxis($p,$" << id << ",pv::yRight);"  << ENDL;
    if(xBottomAxis == "true")  fout << "  $ret = pv::qpwEnableAxis($p,$" << id << ",pv::xBottom);" << ENDL;
    if(xTopAxis    == "true")  fout << "  $ret = pv::qpwEnableAxis($p,$" << id << ",pv::xTop);"    << ENDL;
    if(text        != "")      fout << "  $ret = pv::qpwSetTitle($p,$"   << id << ",\"" << text << "\");" << ENDL;
  }
  else if(type == "QwtScale")
  {
    fout << "  $ret = pv::pvQwtScale($p,$" << id << "," << parent << ",0);" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(position == "Left")   fout << "  $ret = pv::qwtScaleSetPosition($p,$" << id << ",pv::ScaleLeft);" << ENDL;
    if(position == "Right")  fout << "  $ret = pv::qwtScaleSetPosition($p,$" << id << ",pv::ScaleRight);" << ENDL;
    if(position == "Top")    fout << "  $ret = pv::qwtScaleSetPosition($p,$" << id << ",pv::ScaleTop);" << ENDL;
    if(position == "Bottom") fout << "  $ret = pv::qwtScaleSetPosition($p,$" << id << ",pv::ScaleBottom);" << ENDL;
    if(title != "") fout << "  $ret = pv::qwtScaleSetTitle($p,$" << id << "," << title << ");" << ENDL;
    if(titleFontfamily != "") fout << "  $ret = pv::qwtScaleSetTitleFont($p,$" << id << ",\"" << titleFontfamily << "\"," << titleFontsize << "," << titleFontbold << "," << titleFontitalic << "," << titleFontunderline << "," << titleFontstrikeout << ");" << ENDL;
    if(titleColorRed != "") fout << "  $ret = pv::qwtScaleSetTitleColor($p,$" << id << "," << titleColorRed << "," << titleColorGreen << "," << titleColorBlue << ");" << ENDL;
  }
  else if(type == "QwtThermo")
  {
    fout << "  $ret = pv::pvQwtThermo($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QwtKnob")
  {
    fout << "  $ret = pv::pvQwtKnob($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(readOnly == "true" ) fout << "  $ret = pv::qwtKnobSetReadOnly($p,$" << id << ",1);" << ENDL;
    if(readOnly == "false") fout << "  $ret = pv::qwtKnobSetReadOnly($p,$" << id << ",0);" << ENDL;
    if(mass     != "") fout << "  $ret = pv::qwtKnobSetMass($p,$" << id << "," << mass << ");" << ENDL;
    if(orientation != "") fout << "  $ret = pv::qwtKnobSetOrientation($p,$" << id << "," << orientation << ");" << ENDL;
    if(knobWidth   != "") fout << "  $ret = pv::qwtKnobSetKnobWidth($p,$" << id << "," << knobWidth << ");" << ENDL;
    if(borderWidth != "") fout << "  $ret = pv::qwtKnobSetBorderWidth($p,$" << id << "," << borderWidth << ");" << ENDL;
    if(totalAngle  != "") fout << "  $ret = pv::qwtKnobSetTotalAngle($p,$" << id << "," << totalAngle << ");" << ENDL;
    if(symbol == "Line") fout << "  $ret = pv::qwtKnobSetSymbol($p,$" << id << ",pv::KnobLine);" << ENDL;
    if(symbol == "Dot" ) fout << "  $ret = pv::qwtKnobSetSymbol($p,$" << id << ",pv::KnobDot);" << ENDL;
  }
  else if(type == "QwtCounter")
  {
    fout << "  $ret = pv::pvQwtCounter($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(numButtons  != "") fout << "  $ret = pv::qwtCounterSetNumButtons($p,$" << id << "," << numButtons << ");" << ENDL;
    if(basicstep   != "") fout << "  $ret = pv::qwtCounterSetStep($p,$" << id << "," << basicstep << ");" << ENDL;
    if(minValue    != "") fout << "  $ret = pv::qwtCounterSetMinValue($p,$" << id << "," << minValue << ");" << ENDL;
    if(maxValue    != "") fout << "  $ret = pv::qwtCounterSetMaxValue($p,$" << id << "," << maxValue << ");" << ENDL;
    if(stepButton1 != "") fout << "  $ret = pv::qwtCounterSetStepButton1($p,$" << id << "," << stepButton1 << ");" << ENDL;
    if(stepButton2 != "") fout << "  $ret = pv::qwtCounterSetStepButton2($p,$" << id << "," << stepButton2 << ");" << ENDL;
    if(stepButton3 != "") fout << "  $ret = pv::qwtCounterSetStepButton3($p,$" << id << "," << stepButton3 << ");" << ENDL;
    if(value       != "") fout << "  $ret = pv::qwtCounterSetValue($p,$" << id << "," << value << ");" << ENDL;
  }
  else if(type == "QwtWheel")
  {
    fout << "  $ret = pv::pvQwtWheel($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(readOnly == "true" ) fout << "  $ret = pv::qwtWheelSetReadOnly($p,$" << id << ",1);" << ENDL;
    if(readOnly == "false") fout << "  $ret = pv::qwtWheelSetReadOnly($p,$" << id << ",0);" << ENDL;
    if(mass     != "") fout << "  $ret = pv::qwtWheelSetMass($p,$" << id << "," << mass << ");" << ENDL;
    if(orientation != "") fout << "  $ret = pv::qwtWheelSetOrientation($p,$" << id << ",pv::" << orientation << ");" << ENDL;
    if(totalAngle != "") fout << "  $ret = pv::qwtWheelSetTotalAngle($p,$" << id << "," << totalAngle << ");" << ENDL;
    if(viewAngle  != "") fout << "  $ret = pv::qwtWheelSetViewAngle($p,$"  << id << "," << viewAngle  << ");" << ENDL;
    if(tickCnt    != "") fout << "  $ret = pv::qwtWheelSetTickCnt($p,$"    << id << "," << tickCnt    << ");" << ENDL;
    if(internalBorder != "") fout << "  $ret = pv::qwtWheelSetInternalBorder($p,$" << id << "," << internalBorder << ");" << ENDL;
  }
  else if(type == "QwtSlider")
  {
    fout << "  $ret = pv::pvQwtSlider($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(readOnly == "true" ) fout << "  $ret = pv::qwtSliderSetReadOnly($p,$" << id << ",1);" << ENDL;
    if(readOnly == "false") fout << "  $ret = pv::qwtSliderSetReadOnly($p,$" << id << ",0);" << ENDL;
    if(mass     != "") fout << "  $ret = pv::qwtSliderSetMass($p,$" << id << "," << mass << ");" << ENDL;
    if(orientation != "") fout << "  $ret = pv::qwtSliderSetOrientation($p,$" << id << ",pv::" << orientation << ");" << ENDL;
    if(thumbLength != "") fout << "  $ret = pv::qwtSliderSetThumbLength($p,$" << id << "," << thumbLength << ");" << ENDL;
    if(thumbWidth  != "") fout << "  $ret = pv::qwtSliderSetThumbWidth($p,$"  << id << "," << thumbWidth  << ");" << ENDL;
    if(borderWidth != "") fout << "  $ret = pv::qwtSliderSetBorderWidth($p,$" << id << "," << borderWidth << ");" << ENDL;
    if(bgStyle  == "BgTrough") fout << "  $ret = pv::qwtSliderSetBgStyle($p,$" << id << ",pv::" <<  "SliderBgTrough);" << ENDL;
    if(bgStyle  == "BgSlot")   fout << "  $ret = pv::qwtSliderSetBgStyle($p,$" << id << ",pv::" <<  "SliderBgSlot);" << ENDL;
    if(bgStyle  == "BgBoth")   fout << "  $ret = pv::qwtSliderSetBgStyle($p,$" << id << ",pv::" <<  "SliderBgBoth);" << ENDL;
    if(scalePos == "None")  fout << "  $ret = pv::qwtSliderSetScalePos($p,$"    << id << ",pv::SliderNone);" << ENDL;
    if(scalePos == "Left")  fout << "  $ret = pv::qwtSliderSetScalePos($p,$"    << id << ",pv::SliderLeft);" << ENDL;
    if(scalePos == "Right") fout << "  $ret = pv::qwtSliderSetScalePos($p,$"    << id << ",pv::SliderRight);" << ENDL;
    if(scalePos == "Top")   fout << "  $ret = pv::qwtSliderSetScalePos($p,$"    << id << ",pv::SliderTop);" << ENDL;
    if(scalePos == "Bottom")fout << "  $ret = pv::qwtSliderSetScalePos($p,$"    << id << ",pv::SliderBottom);" << ENDL;
    if(value != "") fout << "  $ret = pv::qwtSliderSetValue($p,$" << id << "," << value << ");" << ENDL;
  }
  else if(type == "QwtCompass")
  {
    fout << "  $ret = pv::pvQwtCompass($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(readOnly == "true" ) fout << "  $ret = pv::qwtCompassSetReadOnly($p,$" << id << ",1);" << ENDL;
    if(readOnly == "false") fout << "  $ret = pv::qwtCompassSetReadOnly($p,$" << id << ",0);" << ENDL;
    if(mass     != "") fout << "  $ret = pv::qwtCompassSetMass($p,$" << id << "," << mass << ");" << ENDL;
    if(orientation != "") fout << "  $ret = pv::qwtCompassSetOrientation($p,$" << id << ",pv::" << orientation << ");" << ENDL;
    if(visibleBackground == "false") fout << "  $ret = pv::qwtCompassShowBackground($p,$" << id << ",0);" << ENDL;
    if(visibleBackground == "true" ) fout << "  $ret = pv::qwtCompassShowBackground($p,$" << id << ",1);" << ENDL;
    if(linewidth         != "") fout << "  $ret = pv::qwtCompassSetLineWidth($p,$" << id << "," << linewidth << ");" << ENDL;
    if(frameShadow == "Plain")  fout << "  $ret = pv::qwtCompassSetFrameShadow($p,$" << id << ",pv::DialPlain);" << ENDL;
    if(frameShadow == "Raised") fout << "  $ret = pv::qwtCompassSetFrameShadow($p,$" << id << ",pv::DialRaised);" << ENDL;
    if(frameShadow == "Sunken") fout << "  $ret = pv::qwtCompassSetFrameShadow($p,$" << id << ",pv::DialSunken);" << ENDL;
    if(origin != "") fout << "  $ret = pv::qwtCompassSetOrigin($p,$" << id << ",pv::" << origin << ");" << ENDL;
    if(wrapping == "false") fout << "  $ret = pv::qwtCompassSetWrapping($p,$" << id << ",0);" << ENDL;
    if(wrapping == "true" ) fout << "  $ret = pv::qwtCompassSetWrapping($p,$" << id << ",1);" << ENDL;
  }
  else if(type == "QDateEdit")
  {
    fout << "  $ret = pv::pvQDateEdit($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QTimeEdit")
  {
    fout << "  $ret = pv::pvQTimeEdit($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(timeDisplay != "")
    {
      int h,m,s,ap;
      h = m = s = ap = 0;
      if(strstr((const char *) timeDisplay, "Hours")   != NULL) h = 1;
      if(strstr((const char *) timeDisplay, "Minutes") != NULL) m = 1;
      if(strstr((const char *) timeDisplay, "Seconds") != NULL) s = 1;
      if(strstr((const char *) timeDisplay, "AMPM")    != NULL) ap = 1;
      fout << "  $ret = pv::pvSetTimeEditDisplay($p,$" << id << "," << h << "," << m << "," << s << "," << ap << ");" << ENDL;
    }
  }
  else if(type == "QDateTimeEdit")
  {
    fout << "  $ret = pv::pvQDateTimeEdit($p,$" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pv::pvSetGeometry($p,$" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }

  if(foregroundred != "")
  {
    fout << "  $ret = pv::pvSetPaletteForegroundColor($p,$" << id << "," << foregroundred << "," << foregroundgreen << "," << foregroundblue << ");" << ENDL;
  }
  if(backgroundred != "")
  {
    fout << "  $ret = pv::pvSetPaletteBackgroundColor($p,$" << id << "," << backgroundred << "," << backgroundgreen << "," << backgroundblue << ");" << ENDL;
  }

  if(fontfamily != "" || fontpointsize != "" || fontbold != "" || fontitalic != "" || fontunderline != "" || fontstrikeout != "")
  {
    if(fontfamily    == "") fontfamily    = "helvetica";
    if(fontpointsize == "") fontpointsize = "10";
    if(fontbold      == "") fontbold      = "0";
    if(fontitalic    == "") fontitalic    = "0";
    if(fontunderline == "") fontunderline = "0";
    if(fontstrikeout == "") fontstrikeout = "0";
    fout << "  $ret = pv::pvSetFont($p,$" << id << ",\"" << fontfamily << "\"," << fontpointsize << "," << fontbold << ","
         << fontitalic << "," << fontunderline << "," << fontstrikeout << ");" << ENDL;
  }

  if(tooltip   != "") fout << "  $ret = pv::pvToolTip($p,$"  << id << ",\"" << tooltip << "\");"       << ENDL;
  if(shape     != "") fout << "  $ret = pv::pvSetStyle($p,$" << id << "," << shape << ",-1,-1,-1);"    << ENDL;
  if(shadow    != "") fout << "  $ret = pv::pvSetStyle($p,$" << id << ",-1," << shadow <<",-1,-1);"    << ENDL;
  if(linewidth != "") fout << "  $ret = pv::pvSetStyle($p,$" << id << ",-1,-1," << linewidth<< ",-1);" << ENDL;
  if(margin    != "") fout << "  $ret = pv::pvSetStyle($p,$" << id << ",-1,-1,-1," << margin << ");"   << ENDL;
  fout << ENDL;
}

void Generator::generateWidgetPhp(ofstream &fout, const char *text)
{ 
  if(parent != "0") parent = "$this->" + parent;
  if(type == "QLayoutWidget")
  {
    if(vbox != "") fout << "    $ret = pvQLayoutVbox($p,$this->" << id << "," << parent << ");" << ENDL;
    if(hbox != "") fout << "    $ret = pvQLayoutHbox($p,$this->" << id << "," << parent << ");" << ENDL;
    if(grid != "") fout << "    $ret = pvQLayoutGrid($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "")    fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QDialog")
  {
    if(vbox != "") fout << "    $ret = pvQLayoutVbox($p,0,-1);" << ENDL;
    if(hbox != "") fout << "    $ret = pvQLayoutHbox($p,0,-1);" << ENDL;
    if(grid != "") fout << "    $ret = pvQLayoutGrid($p,0,-1);" << ENDL;
  }
  else if(type == "QPushButton")
  {
    fout << "    $ret = pvQPushButton($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "    $ret = pvSetText($p,$this->" << id << ",\"" << text << "\");" << ENDL;
  }
  else if(type == "QWidget")
  {
    fout << "    $ret = pvQWidget($p,$this->" << id << "," << parent << ");" << ENDL;
    if(parentclass == "QTabWidget")
    {
      fout << "    $ret = pvAddTab($p," << parent << ",$this->" << id << ",\"" << text << "\");" << ENDL;
    }
    else if(parentclass == "QToolBox")
    {
      fout << "    $ret = pvAddTab($p," << parent << ",$this->" << id << ",\"" << text << "\");" << ENDL;
    }
    else
    {
      if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
      fout << "    $ret = pvSetText($p,$this->" << id << ",\"" << text << "\");" << ENDL;
    }
  }
  else if(type == "QLabel")
  {
    if(whatsThis == "" || whatsThis[0] == '#')
    {
      fout << "    $ret = pvQLabel($p,$this->" << id << "," << parent << ");" << ENDL;
      if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
      fout << "    $ret = pvSetText($p,$this->" << id << ",\"" << text << "\");" << ENDL;
      if(alignment != "")
      {
        fout << "    $ret = pvSetAlignment($p,$this->" << id << "," << alignment << ");" << ENDL;
      }
    }
    else
    {
      if(strstr(whatsThis,".bmp") == NULL && strstr(whatsThis,".BMP") == NULL)
      {
        fout << "    $ret = pvDownloadFile($p,\"" << whatsThis << "\");" << ENDL;
        fout << "    $ret = pvQImage($p,$this->" << id << "," << parent << ",\"" << whatsThis << "\",$w,$h,$depth);" << ENDL;
        if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
      }
      else
      {
        fout << "    $ret = pvQImage($p,$this->" << id << "," << parent << ",\"" << whatsThis << "\",$w,$h,$depth);" << ENDL;
        if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << ",get_int($w),get_int($h));" << ENDL;
      }
    }
  }
  else if(type == "QLineEdit")
  {
    fout << "    $ret = pvQLineEdit($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "    $ret = pvSetText($p,$this->" << id << ",\"" << text << "\");" << ENDL;
    if(editable == "false")
    {
      fout << "    $ret = pvSetEditable($p,$this->" << id << ",0);" << ENDL;
    }
    if(echomode == "Password")
    {
      fout << "    $ret = pvSetEchoMode($p,$this->" << id << ",2);" << ENDL;
    }
    else if(echomode == "NoEcho")
    {
      fout << "    $ret = pvSetEchoMode($p,$this->" << id << ",0);" << ENDL;
    }
    if(alignment != "")
    {          
      fout << "    $ret = pvSetAlignment($p,$this->" << id << "," << alignment << ");" << ENDL;
    }
  }
  else if(type == "QMultiLineEdit" || type == "PVMultiLineEdit" || type == "QTextEdit")
  {
    if(editable == "")        editable = "1";
    if(editable == "true")    editable = "1";
    if(editable == "false")   editable = "0";
    if(maxlines != "-1")
    {
      char buf[32];
      int  ival;
      sscanf(maxlines,"%d",&ival);
      sprintf(buf,"%d",-ival);
      maxlines = buf;
    }
    fout << "    $ret = pvQMultiLineEdit($p,$this->" << id << "," << parent << "," << editable << "," << maxlines << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QTextBrowser")
  {
    fout << "    $ret = pvQTextBrowser($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QListView")
  {
    fout << "    $ret = pvQListView($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(selectionmode == "Multi")
    {
      fout << "    $ret = pvSetMultiSelection($p,$this->" << id << ",1);" << ENDL;
    }
    else if(selectionmode == "NoSelection")
    {
      fout << "    $ret = pvSetMultiSelection($p,$this->" << id << ",2);" << ENDL;
    }
  }
  else if(type == "QComboBox")
  {
    if(insertionpolicy == "") insertionpolicy = "AtTop";
    if(editable == "")        editable = "0";
    if(editable == "true")    editable = "1";
    if(editable == "false")   editable = "0";
    fout << "    $ret = pvQComboBox($p,$this->" << id << "," << parent << "," << editable << "," << insertionpolicy << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QLCDNumber")
  {
    if(mode      == "") mode      = "Dec";
    if(style     == "") style     = "Outline";
    if(numdigits == "") numdigits = "2";
    fout << "    $ret = pvQLCDNumber($p,$this->" << id << "," << parent << "," << numdigits << "," << style << "," << mode << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QSlider")
  {
    if(pagestep    == "") pagestep    = "10";
    if(value       == "") value       = "0";
    if(minvalue    == "") minvalue    = "0";
    if(maxvalue    == "") maxvalue    = "99";
    if(orientation == "") orientation = "Vertical";
    fout << "    $ret = pvQSlider($p,$this->" << id << "," << parent << "," << minvalue << "," << maxvalue << "," << pagestep << "," << value << "," << orientation << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QButtonGroup")
  {
    fout << "    $ret = pvQButtonGroup($p,$this->" << id << "," << parent << ",-1,HORIZONTAL,\"" << text << "\");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QGroupBox")
  {
    fout << "    $ret = pvQGroupBox($p,$this->" << id << "," << parent << ",-1,HORIZONTAL,\"" << text << "\");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QListBox")
  {
    fout << "    $ret = pvQListBox($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(selectionmode == "Multi")
    {
      fout << "    $ret = pvSetSelectionMode($p,$this->" << id << ",2);" << ENDL;
    }
    else if(selectionmode == "NoSelection")
    {
      fout << "    $ret = pvSetSelectionMode($p,$this->" << id << ",0);" << ENDL;
    }
  }
  else if(type == "QIconView")
  {
    fout << "    $ret = pvQIconView($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QTable")
  {
    fout << "    $ret = pvQTable($p,$this->" << id << "," << parent << "," << numRows << "," << numCols << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(editable == "false")
    {
      fout << "    $ret = pvSetEditable($p,$this->" << id << ",0);" << ENDL;
    }
  }
  else if(type == "QSpinBox")
  {
    fout << "    $ret = pvQSpinBox($p,$this->" << id << "," << parent << "," << minvalue << "," << maxvalue << ",1);" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QDial")
  {
    fout << "    $ret = pvQDial($p,$this->" << id << "," << parent << "," << minvalue << "," << maxvalue << "," << pagestep << "," << value << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QProgressBar")
  {
    fout << "    $ret = pvQProgressBar($p,$this->" << id << "," << parent << "," << progress << ");"            << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QRadioButton")
  {
    fout << "    $ret = pvQRadioButton($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "    $ret = pvSetText($p,$this->" << id << ",\"" << text << "\");" << ENDL;
    if(checked == "true")
    {
      fout << "    $ret = pvSetChecked($p,$this->" << id << ",1);" << ENDL;
    }
  }
  else if(type == "QCheckBox")
  {
    fout << "    $ret = pvQCheckBox($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "    $ret = pvSetText($p,$this->" << id << ",\"" << text << "\");" << ENDL;
    if(checked == "true")
    {
      fout << "    $ret = pvSetChecked($p,$this->" << id << ",1);" << ENDL;
    }
  }
  else if(type == "QFrame")
  {
    if(whatsThis == "" || whatsThis[0] == '#')
    {
      if(shape     == "") shape     = "NoFrame";
      if(shadow    == "") shadow    = "Plain";
      if(linewidth == "") linewidth = "1";
      if(margin    == "") margin    = "0";
      fout << "    $ret = pvQFrame($p,$this->" << id << "," << parent << "," << shape << "," << shadow << "," << linewidth << "," << margin << ");" << ENDL;
      if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    }
    else
    {
      if(strstr(whatsThis,".bmp") == NULL && strstr(whatsThis,".BMP") == NULL)
      {
        fout << "    $ret = pvDownloadFile($p,\"" << whatsThis << "\");" << ENDL;
        fout << "    $ret = pvQImage($p,$this->" << id << "," << parent << ",\"" << whatsThis << "\",$w,$h,$depth);" << ENDL;
        if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
      }
      else
      {
        fout << "    $ret = pvQImage($p,$this->" << id << "," << parent << ",\"" << whatsThis << "\",$w,$h,$depth);" << ENDL;
        if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << ",get_int($w),get_int($h));" << ENDL;
      }
    }
  }
  else if(type == "Line")
  {
    if(shape     == "") shape     = "HLine";
    if(shadow    == "") shadow    = "Plain";
    if(linewidth == "") linewidth = "1";
    if(margin    == "") margin    = "0";
    fout << "    $ret = pvQFrame($p,$this->" << id << "," << parent << "," << shape << "," << shadow << "," << linewidth << "," << margin << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QDraw")
  {
    fout << "    $ret = pvQDraw($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QImage")
  {
    if(strstr(text,".bmp") == NULL && strstr(text,".BMP") == NULL)
    {
      fout << "    $ret = pvDownloadFile($p,\"" << text << "\");" << ENDL;
      fout << "    $ret = pvQImage($p,$this->" << id << "," << parent << ",\"" << text << "\",$w,$h,$depth);" << ENDL;
      if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    }
    else
    {
      fout << "    $ret = pvQImage($p,$this->" << id << "," << parent << ",\"" << text << "\",$w,$h,$depth);" << ENDL;
      if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << ",get_int($w),get_int($h));" << ENDL;
    }
  }
  else if(type == "QGLWidget")
  {
    fout << "    $ret = pvQGL($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    fout << "    $ret = pvGlBegin($p,$this->" << id << ");" << ENDL;
    fout << "    initializeGL(); // (todo: write your gl initialization routine) see example" << ENDL;
    fout << "    resizeGL(" << w << "," << h << ");  // (todo: write your resize routine) see example" << ENDL;
    fout << "    $ret = pvGlEnd($p);" << ENDL;
  }
  else if(type == "QVtkTclWidget")
  {
    fout << "    $ret = pvQVtkTclWidget($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QTabWidget")
  {
    fout << "    $ret = pvQTabWidget($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(tabposition != "0")
    {
      fout << "    $ret = pvSetTabPosition($p,$this->" << id << "," << tabposition << ");" << ENDL;
    }
  }
  else if(type == "QToolBox")
  {
    fout << "    $ret = pvQToolBox($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(tabposition != "0")
    {
      fout << "    $ret = pvSetTabPosition($p,$this->" << id << "," << tabposition << ");" << ENDL;
    }
  }
  else if(type == "QwtPlot")
  {
    fout << "    $ret = pvQwtPlotWidget($p,$this->" << id << "," << parent << "," << nCurves << "," << nMarker << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(canvasBackgroundRed != "")
    {
      fout << "    $ret = qpwSetCanvasBackground($p,$this->" << id << "," << canvasBackgroundRed   << ","
                                                         << canvasBackgroundGreen << ","
                                                         << canvasBackgroundBlue  << ");" << ENDL;
    }
    if(yLeftAxis   == "true")  fout << "    $ret = qpwEnableAxis($p,$this->" << id << ",yLeft);"   << ENDL;
    if(yRightAxis  == "true")  fout << "    $ret = qpwEnableAxis($p,$this->" << id << ",yRight);"  << ENDL;
    if(xBottomAxis == "true")  fout << "    $ret = qpwEnableAxis($p,$this->" << id << ",xBottom);" << ENDL;
    if(xTopAxis    == "true")  fout << "    $ret = qpwEnableAxis($p,$this->" << id << ",xTop);"    << ENDL;
    if(text        != "")      fout << "    $ret = qpwSetTitle($p,$this->"   << id << ",\"" << text << "\");" << ENDL;
  }
  else if(type == "QwtScale")
  {
    fout << "    $ret = pvQwtScale($p,$this->" << id << "," << parent << ",0);" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(position == "Left")   fout << "    $ret = qwtScaleSetPosition($p,$this->" << id << ",ScaleLeft);" << ENDL;
    if(position == "Right")  fout << "    $ret = qwtScaleSetPosition($p,$this->" << id << ",ScaleRight);" << ENDL;
    if(position == "Top")    fout << "    $ret = qwtScaleSetPosition($p,$this->" << id << ",ScaleTop);" << ENDL;
    if(position == "Bottom") fout << "    $ret = qwtScaleSetPosition($p,$this->" << id << ",ScaleBottom);" << ENDL;
    if(title != "") fout << "    $ret = qwtScaleSetTitle($p,$this->" << id << "," << title << ");" << ENDL;
    if(titleFontfamily != "") fout << "    $ret = qwtScaleSetTitleFont($p,$this->" << id << ",\"" << titleFontfamily << "\"," << titleFontsize << "," << titleFontbold << "," << titleFontitalic << "," << titleFontunderline << "," << titleFontstrikeout << ");" << ENDL;
    if(titleColorRed != "") fout << "    $ret = qwtScaleSetTitleColor($p,$this->" << id << "," << titleColorRed << "," << titleColorGreen << "," << titleColorBlue << ");" << ENDL;
  }
  else if(type == "QwtThermo")
  {
    fout << "    $ret = pvQwtThermo($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QwtKnob")
  {
    fout << "    $ret = pvQwtKnob($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(readOnly == "true" ) fout << "    $ret = qwtKnobSetReadOnly($p,$this->" << id << ",1);" << ENDL;
    if(readOnly == "false") fout << "    $ret = qwtKnobSetReadOnly($p,$this->" << id << ",0);" << ENDL;
    if(mass     != "") fout << "    $ret = qwtKnobSetMass($p,$this->" << id << "," << mass << ");" << ENDL;
    if(orientation != "") fout << "    $ret = qwtKnobSetOrientation($p,$this->" << id << "," << orientation << ");" << ENDL;
    if(knobWidth   != "") fout << "    $ret = qwtKnobSetKnobWidth($p,$this->" << id << "," << knobWidth << ");" << ENDL;
    if(borderWidth != "") fout << "    $ret = qwtKnobSetBorderWidth($p,$this->" << id << "," << borderWidth << ");" << ENDL;
    if(totalAngle  != "") fout << "    $ret = qwtKnobSetTotalAngle($p,$this->" << id << "," << totalAngle << ");" << ENDL;
    if(symbol == "Line") fout << "    $ret = qwtKnobSetSymbol($p,$this->" << id << ",KnobLine);" << ENDL;
    if(symbol == "Dot" ) fout << "    $ret = qwtKnobSetSymbol($p,$this->" << id << ",KnobDot);" << ENDL;
  }
  else if(type == "QwtCounter")
  {
    fout << "    $ret = pvQwtCounter($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(numButtons  != "") fout << "    $ret = qwtCounterSetNumButtons($p,$this->" << id << "," << numButtons << ");" << ENDL;
    if(basicstep   != "") fout << "    $ret = qwtCounterSetStep($p,$this->" << id << "," << basicstep << ");" << ENDL;
    if(minValue    != "") fout << "    $ret = qwtCounterSetMinValue($p,$this->" << id << "," << minValue << ");" << ENDL;
    if(maxValue    != "") fout << "    $ret = qwtCounterSetMaxValue($p,$this->" << id << "," << maxValue << ");" << ENDL;
    if(stepButton1 != "") fout << "    $ret = qwtCounterSetStepButton1($p,$this->" << id << "," << stepButton1 << ");" << ENDL;
    if(stepButton2 != "") fout << "    $ret = qwtCounterSetStepButton2($p,$this->" << id << "," << stepButton2 << ");" << ENDL;
    if(stepButton3 != "") fout << "    $ret = qwtCounterSetStepButton3($p,$this->" << id << "," << stepButton3 << ");" << ENDL;
    if(value       != "") fout << "    $ret = qwtCounterSetValue($p,$this->" << id << "," << value << ");" << ENDL;
  }
  else if(type == "QwtWheel")
  {
    fout << "    $ret = pvQwtWheel($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(readOnly == "true" ) fout << "    $ret = qwtWheelSetReadOnly($p,$this->" << id << ",1);" << ENDL;
    if(readOnly == "false") fout << "    $ret = qwtWheelSetReadOnly($p,$this->" << id << ",0);" << ENDL;
    if(mass     != "") fout << "    $ret = qwtWheelSetMass($p,$this->" << id << "," << mass << ");" << ENDL;
    if(orientation != "") fout << "    $ret = qwtWheelSetOrientation($p,$this->" << id << "," << orientation << ");" << ENDL;
    if(totalAngle != "") fout << "    $ret = qwtWheelSetTotalAngle($p,$this->" << id << "," << totalAngle << ");" << ENDL;
    if(viewAngle  != "") fout << "    $ret = qwtWheelSetViewAngle($p,$this->" << id << "," << viewAngle  << ");" << ENDL;
    if(tickCnt    != "") fout << "    $ret = qwtWheelSetTickCnt($p,$this->" << id << "," << tickCnt    << ");" << ENDL;
    if(internalBorder != "") fout << "    $ret = qwtWheelSetInternalBorder($p,$this->" << id << "," << internalBorder << ");" << ENDL;
  }
  else if(type == "QwtSlider")
  {
    fout << "    $ret = pvQwtSlider($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(readOnly == "true" ) fout << "    $ret = qwtSliderSetReadOnly($p,$this->" << id << ",1);" << ENDL;
    if(readOnly == "false") fout << "    $ret = qwtSliderSetReadOnly($p,$this->" << id << ",0);" << ENDL;
    if(mass     != "") fout << "    $ret = qwtSliderSetMass($p,$this->" << id << "," << mass << ");" << ENDL;
    if(orientation != "") fout << "    $ret = qwtSliderSetOrientation($p,$this->" << id << "," << orientation << ");" << ENDL;
    if(thumbLength != "") fout << "    $ret = qwtSliderSetThumbLength($p,$this->" << id << "," << thumbLength << ");" << ENDL;
    if(thumbWidth  != "") fout << "    $ret = qwtSliderSetThumbWidth($p,$this->" << id << "," << thumbWidth  << ");" << ENDL;
    if(borderWidth != "") fout << "    $ret = qwtSliderSetBorderWidth($p,$this->" << id << "," << borderWidth << ");" << ENDL;
    if(bgStyle  == "BgTrough") fout << "    $ret = qwtSliderSetBgStyle($p,$this->" << id << "," <<  "SliderBgTrough);" << ENDL;
    if(bgStyle  == "BgSlot")   fout << "    $ret = qwtSliderSetBgStyle($p,$this->" << id << "," <<  "SliderBgSlot);" << ENDL;
    if(bgStyle  == "BgBoth")   fout << "    $ret = qwtSliderSetBgStyle($p,$this->" << id << "," <<  "SliderBgBoth);" << ENDL;
    if(scalePos == "None")  fout << "    $ret = qwtSliderSetScalePos($p,$this->" << id << ",SliderNone);" << ENDL;
    if(scalePos == "Left")  fout << "    $ret = qwtSliderSetScalePos($p,$this->" << id << ",SliderLeft);" << ENDL;
    if(scalePos == "Right") fout << "    $ret = qwtSliderSetScalePos($p,$this->" << id << ",SliderRight);" << ENDL;
    if(scalePos == "Top")   fout << "    $ret = qwtSliderSetScalePos($p,$this->" << id << ",SliderTop);" << ENDL;
    if(scalePos == "Bottom")fout << "    $ret = qwtSliderSetScalePos($p,$this->" << id << ",SliderBottom);" << ENDL;
    if(value != "") fout << "    $ret = qwtSliderSetValue($p,$this->" << id << "," << value << ");" << ENDL;
  }
  else if(type == "QwtCompass")
  {
    fout << "    $ret = pvQwtCompass($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "    $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(readOnly == "true" ) fout << "    $ret = qwtCompassSetReadOnly($p,$this->" << id << ",1);" << ENDL;
    if(readOnly == "false") fout << "    $ret = qwtCompassSetReadOnly($p,$this->" << id << ",0);" << ENDL;
    if(mass     != "") fout << "    $ret = qwtCompassSetMass($p,$this->" << id << "," << mass << ");" << ENDL;
    if(orientation != "") fout << "    $ret = qwtCompassSetOrientation($p,$this->" << id << "," << orientation << ");" << ENDL;
    if(visibleBackground == "false") fout << "    $ret = qwtCompassShowBackground($p,$this->" << id << ",0);" << ENDL;
    if(visibleBackground == "true" ) fout << "    $ret = qwtCompassShowBackground($p,$this->" << id << ",1);" << ENDL;
    if(linewidth         != "") fout << "    $ret = qwtCompassSetLineWidth($p,$this->" << id << "," << linewidth << ");" << ENDL;
    if(frameShadow == "Plain")  fout << "    $ret = qwtCompassSetFrameShadow($p,$this->" << id << ",DialPlain);" << ENDL;
    if(frameShadow == "Raised") fout << "    $ret = qwtCompassSetFrameShadow($p,$this->" << id << ",DialRaised);" << ENDL;
    if(frameShadow == "Sunken") fout << "    $ret = qwtCompassSetFrameShadow($p,$this->" << id << ",DialSunken);" << ENDL;
    if(origin != "") fout << "    $ret = qwtCompassSetOrigin($p,$this->" << id << "," << origin << ");" << ENDL;
    if(wrapping == "false") fout << "    $ret = qwtCompassSetWrapping($p,$this->" << id << ",0);" << ENDL;
    if(wrapping == "true" ) fout << "    $ret = qwtCompassSetWrapping($p,$this->" << id << ",1);" << ENDL;
  }
  else if(type == "QDateEdit")
  {
    fout << "  $ret = pvQDateEdit($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }
  else if(type == "QTimeEdit")
  {
    fout << "  $ret = pvQTimeEdit($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
    if(timeDisplay != "")
    {
      int h,m,s,ap;
      h = m = s = ap = 0;
      if(strstr((const char *) timeDisplay, "Hours")   != NULL) h = 1;
      if(strstr((const char *) timeDisplay, "Minutes") != NULL) m = 1;
      if(strstr((const char *) timeDisplay, "Seconds") != NULL) s = 1;
      if(strstr((const char *) timeDisplay, "AMPM")    != NULL) ap = 1;
      fout << "  $ret = pvSetTimeEditDisplay($p,$this->" << id << "," << h << "," << m << "," << s << "," << ap << ");" << ENDL;
    }
  }
  else if(type == "QDateTimeEdit")
  {
    fout << "  $ret = pvQDateTimeEdit($p,$this->" << id << "," << parent << ");" << ENDL;
    if(x != "") fout << "  $ret = pvSetGeometry($p,$this->" << id << "," << x << "," << y << "," << w << "," << h << ");" << ENDL;
  }

  if(foregroundred != "")
  {
    fout << "    $ret = pvSetPaletteForegroundColor($p,$this->" << id << "," << foregroundred << "," << foregroundgreen << "," << foregroundblue << ");" << ENDL;
  }
  if(backgroundred != "")
  {
    fout << "    $ret = pvSetPaletteBackgroundColor($p,$this->" << id << "," << backgroundred << "," << backgroundgreen << "," << backgroundblue << ");" << ENDL;
  }

  if(fontfamily != "" || fontpointsize != "" || fontbold != "" || fontitalic != "" || fontunderline != "" || fontstrikeout != "")
  {
    if(fontfamily    == "") fontfamily    = "helvetica";
    if(fontpointsize == "") fontpointsize = "10";
    if(fontbold      == "") fontbold      = "0";
    if(fontitalic    == "") fontitalic    = "0";
    if(fontunderline == "") fontunderline = "0";
    if(fontstrikeout == "") fontstrikeout = "0";
    fout << "    $ret = pvSetFont($p,$this->" << id << ",\"" << fontfamily << "\"," << fontpointsize << "," << fontbold << ","
         << fontitalic << "," << fontunderline << "," << fontstrikeout << ");" << ENDL;
  }

  if(tooltip   != "") fout << "    $ret = pvToolTip($p,$this->"  << id << ",\"" << tooltip << "\");"       << ENDL;
  if(shape     != "") fout << "    $ret = pvSetStyle($p,$this->" << id << "," << shape << ",-1,-1,-1);"    << ENDL;
  if(shadow    != "") fout << "    $ret = pvSetStyle($p,$this->" << id << ",-1," << shadow <<",-1,-1);"    << ENDL;
  if(linewidth != "") fout << "    $ret = pvSetStyle($p,$this->" << id << ",-1,-1," << linewidth<< ",-1);" << ENDL;
  if(margin    != "") fout << "    $ret = pvSetStyle($p,$this->" << id << ",-1,-1,-1," << margin << ");"   << ENDL;
  fout << ENDL;
}

void Generator::generateWidgetTcl(ofstream &fout, const char *text)
{ 
  if(parent != "0") parent = "$this::" + parent;
  if(type == "QLayoutWidget")
  {
    if(vbox != "") fout << "    pvQLayoutVbox $p $this::" << id << " " << parent << ENDL;
    if(hbox != "") fout << "    pvQLayoutHbox $p $this::" << id << " " << parent << ENDL;
    if(grid != "") fout << "    pvQLayoutGrid $p $this::" << id << " " << parent << ENDL;
    if(x != "")    fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QDialog")
  {
    if(vbox != "") fout << "    pvQLayoutVbox $p 0 -1" << ENDL;
    if(hbox != "") fout << "    pvQLayoutHbox $p 0 -1" << ENDL;
    if(grid != "") fout << "    pvQLayoutGrid $p 0 -1" << ENDL;
  }
  else if(type == "QPushButton")
  {
    fout << "    pvQPushButton $p $this::" << id << " " << parent <<  ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h <<  ENDL;
    fout << "    pvSetText $p $this::" << id << " \"" << text << "\"" << ENDL;
  }
  else if(type == "QWidget")
  {
    fout << "    pvQWidget $p $this::" << id << " " << parent << ENDL;
    if(parentclass == "QTabWidget")
    {
      fout << "    pvAddTab $p " << parent << " $this::" << id << " \"" << text << "\"" << ENDL;
    }
    else if(parentclass == "QToolBox")
    {
      fout << "    pvAddTab($p," << parent << " $this::" << id << " \"" << text << "\"" << ENDL;
    }
    else
    {
      if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
      fout << "    pvSetText $p $this::" << id << " \"" << text << "\"" << ENDL;
    }
  }
  else if(type == "QLabel")
  {
    if(whatsThis == "" || whatsThis[0] == '#')
    {
      fout << "    pvQLabel $p $this::" << id << " " << parent << ENDL;
      if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
      fout << "    pvSetText $p $this::" << id << " \"" << text << "\"" << ENDL;
      if(alignment != "")
      {
        alignment.replace("|","|$::");
        fout << "    pvSetAlignment $p $this::" << id << " $::" << alignment << ENDL;
      }
    }
    else
    {
      if(strstr(whatsThis,".bmp") == NULL && strstr(whatsThis,".BMP") == NULL)
      {
        fout << "    pvDownloadFile $p \"" << whatsThis << "\"" << ENDL;
        fout << "    pvQImage $p $this::" << id << " " << parent << " \"" << whatsThis << "\" $w $h $depth" << ENDL;
        if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
      }
      else
      {
        fout << "    pvQImage $p $this::" << id << " " << parent << " \"" << whatsThis << "\" $w $h $depth" << ENDL;
        if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " [ get_int $w ] [ get_int $h ]" << ENDL;
      }
    }
  }
  else if(type == "QLineEdit")
  {
    fout << "    pvQLineEdit $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    fout << "    pvSetText $p $this::" << id << " \"" << text << "\"" << ENDL;
    if(editable == "false")
    {
      fout << "    pvSetEditable $p $this::" << id << " 0" << ENDL;
    }
    if(echomode == "Password")
    {
      fout << "    pvSetEchoMode $p $this::" << id << " 2" << ENDL;
    }
    else if(echomode == "NoEcho")
    {
      fout << "    pvSetEchoMode $p $this::" << id << " 0" << ENDL;
    }
    if(alignment != "")
    {
      alignment.replace("|","|$::");
      fout << "    pvSetAlignment $p $this::" << id << " $::" << alignment << ENDL;
    }
  }
  else if(type == "QMultiLineEdit" || type == "PVMultiLineEdit" || type == "QTextEdit")
  {
    if(editable == "")        editable = "1";
    if(editable == "true")    editable = "1";
    if(editable == "false")   editable = "0";
    if(maxlines != "-1")
    {
      char buf[32];
      int  ival;
      sscanf(maxlines,"%d",&ival);
      sprintf(buf,"%d",-ival);
      maxlines = buf;
    }
    fout << "    pvQMultiLineEdit $p $this::" << id << " " << parent << " " << editable << " " << maxlines << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QTextBrowser")
  {
    fout << "    pvQTextBrowser $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QListView")
  {
    fout << "    pvQListView $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    if(selectionmode == "Multi")
    {
      fout << "    pvSetMultiSelection $p $this::" << id << " 1" << ENDL;
    }
    else if(selectionmode == "NoSelection")
    {
      fout << "    pvSetMultiSelection $p $this::" << id << " 2" << ENDL;
    }
  }
  else if(type == "QComboBox")
  {
    if(insertionpolicy == "") insertionpolicy = "AtTop";
    if(editable == "")        editable = "0";
    if(editable == "true")    editable = "1";
    if(editable == "false")   editable = "0";
    fout << "    pvQComboBox $p $this::" << id << " " << parent << " " << editable << " $::" << insertionpolicy << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QLCDNumber")
  {
    if(mode      == "") mode      = "Dec";
    if(style     == "") style     = "Outline";
    if(numdigits == "") numdigits = "2";
    fout << "    pvQLCDNumber $p $this::" << id << " " << parent << " " << numdigits << " $::" << style << " $::" << mode << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QSlider")
  {
    if(pagestep    == "") pagestep    = "10";
    if(value       == "") value       = "0";
    if(minvalue    == "") minvalue    = "0";
    if(maxvalue    == "") maxvalue    = "99";
    if(orientation == "") orientation = "Vertical";
    fout << "    pvQSlider $p $this::" << id << " " << parent << " " << minvalue << " " << maxvalue << " " << pagestep << " " << value << " $::" << orientation << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QButtonGroup")
  {
    fout << "    pvQButtonGroup $p $this::" << id << " " << parent << " -1 $::HORIZONTAL \"" << text << "\"" << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QGroupBox")
  {
    fout << "    pvQGroupBox $p $this::" << id << " " << parent << " -1 $::HORIZONTAL \"" << text << "\"" << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QListBox")
  {
    fout << "    pvQListBox $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    if(selectionmode == "Multi")
    {
      fout << "    pvSetSelectionMode $p $this::" << id << " 2" << ENDL;
    }
    else if(selectionmode == "NoSelection")
    {
      fout << "    pvSetSelectionMode $p $this::" << id << " 0" << ENDL;
    }
  }
  else if(type == "QIconView")
  {
    fout << "    pvQIconView $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QTable")
  {
    fout << "    pvQTable $p $this::" << id << " " << parent << " " << numRows << " " << numCols << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    if(editable == "false")
    {
      fout << "    pvSetEditable $p $this::" << id << " 0" << ENDL;
    }
  }
  else if(type == "QSpinBox")
  {
    fout << "    pvQSpinBox $p $this::" << id << " " << parent << " " << minvalue << " " << maxvalue << " 1" << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QDial")
  {
    fout << "    pvQDial $p $this::" << id << " " << parent << " " << minvalue << " " << maxvalue << " " << pagestep << " " << value << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QProgressBar")
  {
    fout << "    pvQProgressBar $p $this::" << id << " " << parent << " " << progress << ""            << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QRadioButton")
  {
    fout << "    pvQRadioButton $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    fout << "    pvSetText $p $this::" << id << " \"" << text << "\"" << ENDL;
    if(checked == "true")
    {
      fout << "    pvSetChecked $p $this::" << id << " 1" << ENDL;
    }
  }
  else if(type == "QCheckBox")
  {
    fout << "    pvQCheckBox $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    fout << "    pvSetText $p $this::" << id << " \"" << text << "\"" << ENDL;
    if(checked == "true")
    {
      fout << "    pvSetChecked $p $this::" << id << " 1" << ENDL;
    }
  }
  else if(type == "QFrame")
  {
    if(whatsThis == "" || whatsThis[0] == '#')
    {
      if(shape     == "") shape     = "NoFrame";
      if(shadow    == "") shadow    = "Plain";
      if(linewidth == "") linewidth = "1";
      if(margin    == "") margin    = "0";
      fout << "    pvQFrame $p $this::" << id << " " << parent << " $::" << shape << " $::" << shadow << " " << linewidth << " " << margin << ENDL;
      if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    }
    else
    {
      if(strstr(whatsThis,".bmp") == NULL && strstr(whatsThis,".BMP") == NULL)
      {
        fout << "    pvDownloadFile $p \"" << whatsThis << "\"" << ENDL;
        fout << "    pvQImage $p $this::" << id << " " << parent << " \"" << whatsThis << "\" $w $h $depth" << ENDL;
        if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
      }
      else
      {
        fout << "    pvQImage $p $this::" << id << " " << parent << " \"" << whatsThis << "\" $w $h $depth" << ENDL;
        if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " [ get_int $w ] [ get_int $h ]" << ENDL;
      }
    }
  }
  else if(type == "Line")
  {
    if(shape     == "") shape     = "HLine";
    if(shadow    == "") shadow    = "Plain";
    if(linewidth == "") linewidth = "1";
    if(margin    == "") margin    = "0";
    fout << "    pvQFrame $p $this::" << id << " " << parent << " $::" << shape << " $::" << shadow << " " << linewidth << " " << margin << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QDraw")
  {
    fout << "    pvQDraw $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QImage")
  {
    if(strstr(text,".bmp") == NULL && strstr(text,".BMP") == NULL)
    {
      fout << "    pvDownloadFile $p \"" << text << "\"" << ENDL;
      fout << "    pvQImage $p $this::" << id << " " << parent << " \"" << text << "\" $w $h $depth" << ENDL;
      if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    }
    else
    {
      fout << "    pvQImage $p $this::" << id << " " << parent << " \"" << text << "\" $w $h $depth" << ENDL;
      if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " [ get_int $w ] [ get_int $h ]" << ENDL;
    }
  }
  else if(type == "QGLWidget")
  {
    fout << "    pvQGL $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    fout << "    pvGlBegin $p $this::" << id << ENDL;
    fout << "    initializeGL() # (todo: write your gl initialization routine) see example" << ENDL;
    fout << "    resizeGL(" << w << " " << h << ")  # (todo: write your resize routine) see example" << ENDL;
    fout << "    pvGlEnd(p" << ENDL;
  }
  else if(type == "QVtkTclWidget")
  {
    fout << "    pvQVtkTclWidget $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QTabWidget")
  {
    fout << "    pvQTabWidget $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    if(tabposition != "0")
    {
      fout << "    pvSetTabPosition $p $this::" << id << " " << tabposition << ENDL;
    }
  }
  else if(type == "QToolBox")
  {
    fout << "    pvQToolBox $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    if(tabposition != "0")
    {
      fout << "    pvSetTabPosition $p $this::" << id << " " << tabposition << ENDL;
    }
  }
  else if(type == "QwtPlot")
  {
    fout << "    pvQwtPlotWidget $p $this::" << id << " " << parent << " " << nCurves << " " << nMarker << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    if(canvasBackgroundRed != "")
    {
      fout << "    qpwSetCanvasBackground $p $this::" << id << " " << canvasBackgroundRed   << " "
                                                         << canvasBackgroundGreen << " "
                                                         << canvasBackgroundBlue  << ENDL;
    }
    if(yLeftAxis   == "true")  fout << "    qpwEnableAxis $p $this::" << id << " $::yLeft"   << ENDL;
    if(yRightAxis  == "true")  fout << "    qpwEnableAxis $p $this::" << id << " $::yRight"  << ENDL;
    if(xBottomAxis == "true")  fout << "    qpwEnableAxis $p $this::" << id << " $::xBottom" << ENDL;
    if(xTopAxis    == "true")  fout << "    qpwEnableAxis $p $this::" << id << " $::xTop"    << ENDL;
    if(text        != "")      fout << "    qpwSetTitle   $p $this::" << id << " \"" << text << "\"" << ENDL;
  }
  else if(type == "QwtScale")
  {
    fout << "    pvQwtScale $p $this::" << id << " " << parent << " 0" << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    if(position == "Left")   fout << "    qwtScaleSetPosition $p $this::" << id << " $::ScaleLeft" << ENDL;
    if(position == "Right")  fout << "    qwtScaleSetPosition $p $this::" << id << " $::ScaleRight" << ENDL;
    if(position == "Top")    fout << "    qwtScaleSetPosition $p $this::" << id << " $::ScaleTop" << ENDL;
    if(position == "Bottom") fout << "    qwtScaleSetPosition $p $this::" << id << " $::ScaleBottom" << ENDL;
    if(title != "") fout << "    qwtScaleSetTitle $p $this::" << id << " " << title << ENDL;
    if(titleFontfamily != "") fout << "    qwtScaleSetTitleFont $p $this::" << id << " \"" << titleFontfamily << "\" " << titleFontsize << " " << titleFontbold << " " << titleFontitalic << " " << titleFontunderline << " " << titleFontstrikeout << ENDL;
    if(titleColorRed != "") fout << "    qwtScaleSetTitleColor $p $this::" << id << " " << titleColorRed << " " << titleColorGreen << " " << titleColorBlue << ENDL;
  }
  else if(type == "QwtThermo")
  {
    fout << "    pvQwtThermo $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QwtKnob")
  {
    fout << "    pvQwtKnob $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    if(readOnly == "true" ) fout << "    qwtKnobSetReadOnly $p $this::" << id << " 1" << ENDL;
    if(readOnly == "false") fout << "    qwtKnobSetReadOnly $p $this::" << id << " 0" << ENDL;
    if(mass     != "") fout << "    qwtKnobSetMass $p $this::" << id << " " << mass << ENDL;
    if(orientation != "")
    {
      fout << "    qwtKnobSetOrientation $p $this::" << id << " $::" << orientation << ENDL;
    }
    if(knobWidth   != "") fout << "    qwtKnobSetKnobWidth $p $this::" << id << " " << knobWidth << ENDL;
    if(borderWidth != "") fout << "    qwtKnobSetBorderWidth $p $this::" << id << " " << borderWidth << ENDL;
    if(totalAngle  != "") fout << "    qwtKnobSetTotalAngle $p $this::" << id << " " << totalAngle << ENDL;
    if(symbol == "Line") fout << "    qwtKnobSetSymbol $p $this::" << id << " $::KnobLine" << ENDL;
    if(symbol == "Dot" ) fout << "    qwtKnobSetSymbol $p $this::" << id << " $::KnobDot" << ENDL;
  }
  else if(type == "QwtCounter")
  {
    fout << "    pvQwtCounter $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    if(numButtons  != "") fout << "    qwtCounterSetNumButtons $p $this::" << id << " " << numButtons << ENDL;
    if(basicstep   != "") fout << "    qwtCounterSetStep $p $this::" << id << " " << basicstep << ENDL;
    if(minValue    != "") fout << "    qwtCounterSetMinValue $p $this::" << id << " " << minValue << ENDL;
    if(maxValue    != "") fout << "    qwtCounterSetMaxValue $p $this::" << id << " " << maxValue << ENDL;
    if(stepButton1 != "") fout << "    qwtCounterSetStepButton1 $p $this::" << id << " " << stepButton1 << ENDL;
    if(stepButton2 != "") fout << "    qwtCounterSetStepButton2 $p $this::" << id << " " << stepButton2 << ENDL;
    if(stepButton3 != "") fout << "    qwtCounterSetStepButton3 $p $this::" << id << " " << stepButton3 << ENDL;
    if(value       != "") fout << "    qwtCounterSetValue $p $this::" << id << " " << value << ENDL;
  }
  else if(type == "QwtWheel")
  {
    fout << "    pvQwtWheel $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    if(readOnly == "true" ) fout << "    qwtWheelSetReadOnly $p $this::" << id << " 1" << ENDL;
    if(readOnly == "false") fout << "    qwtWheelSetReadOnly $p $this::" << id << " 0" << ENDL;
    if(mass     != "") fout << "    qwtWheelSetMass $p $this::" << id << " " << mass << ENDL;
    if(orientation != "")
    {
      fout << "    qwtWheelSetOrientation $p $this::" << id << " $::" << orientation << ENDL;
    }
    if(totalAngle != "") fout << "    qwtWheelSetTotalAngle $p $this::" << id << " " << totalAngle << ENDL;
    if(viewAngle  != "") fout << "    qwtWheelSetViewAngle $p $this::"  << id << " " << viewAngle  << ENDL;
    if(tickCnt    != "") fout << "    qwtWheelSetTickCnt $p $this::"    << id << " " << tickCnt    << ENDL;
    if(internalBorder != "") fout << "    qwtWheelSetInternalBorder $p $this::" << id << " " << internalBorder << ENDL;
  }
  else if(type == "QwtSlider")
  {
    fout << "    pvQwtSlider $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    if(readOnly == "true" ) fout << "    qwtSliderSetReadOnly $p $this::" << id << " 1" << ENDL;
    if(readOnly == "false") fout << "    qwtSliderSetReadOnly $p $this::" << id << " 0" << ENDL;
    if(mass     != "") fout << "    qwtSliderSetMass $p $this::" << id << " " << mass << ENDL;
    if(orientation != "")
    {
      fout << "    qwtSliderSetOrientation $p $this::" << id << " $::" << orientation << ENDL;
    }
    if(thumbLength != "") fout << "    qwtSliderSetThumbLength $p $this::" << id << " " << thumbLength << ENDL;
    if(thumbWidth  != "") fout << "    qwtSliderSetThumbWidth $p $this::"  << id << " " << thumbWidth  << ENDL;
    if(borderWidth != "") fout << "    qwtSliderSetBorderWidth $p $this::" << id << " " << borderWidth << ENDL;
    if(bgStyle  == "BgTrough") fout << "    qwtSliderSetBgStyle $p $this::" << id << " " <<  "$::SliderBgTrough" << ENDL;
    if(bgStyle  == "BgSlot")   fout << "    qwtSliderSetBgStyle $p $this::" << id << " " <<  "$::SliderBgSlot" << ENDL;
    if(bgStyle  == "BgBoth")   fout << "    qwtSliderSetBgStyle $p $this::" << id << " " <<  "$::SliderBgBoth" << ENDL;
    if(scalePos == "None")  fout << "    qwtSliderSetScalePos $p $this::"    << id << " $::SliderNone" << ENDL;
    if(scalePos == "Left")  fout << "    qwtSliderSetScalePos $p $this::"    << id << " $::SliderLeft" << ENDL;
    if(scalePos == "Right") fout << "    qwtSliderSetScalePos $p $this::"    << id << " $::SliderRight" << ENDL;
    if(scalePos == "Top")   fout << "    qwtSliderSetScalePos $p $this::"    << id << " $::SliderTop" << ENDL;
    if(scalePos == "Bottom")fout << "    qwtSliderSetScalePos $p $this::"    << id << " $::SliderBottom" << ENDL;
    if(value != "") fout << "    qwtSliderSetValue $p $this::" << id << " " << value << ENDL;
  }
  else if(type == "QwtCompass")
  {
    fout << "    pvQwtCompass $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "    pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    if(readOnly == "true" ) fout << "    qwtCompassSetReadOnly $p $this::" << id << " 1" << ENDL;
    if(readOnly == "false") fout << "    qwtCompassSetReadOnly $p $this::" << id << " 0" << ENDL;
    if(mass     != "") fout << "    qwtCompassSetMass $p $this::" << id << " " << mass << ENDL;
    if(orientation != "")
    {
      fout << "    qwtCompassSetOrientation $p $this::" << id << " $::" << orientation << ENDL;
    }
    if(visibleBackground == "false") fout << "    qwtCompassShowBackground $p $this::" << id << " 0" << ENDL;
    if(visibleBackground == "true" ) fout << "    qwtCompassShowBackground $p $this::" << id << " 1" << ENDL;
    if(linewidth         != "") fout << "    qwtCompassSetLineWidth $p $this::" << id << " " << linewidth << ENDL;
    if(frameShadow == "Plain")  fout << "    qwtCompassSetFrameShadow $p $this::" << id << " $::DialPlain" << ENDL;
    if(frameShadow == "Raised") fout << "    qwtCompassSetFrameShadow $p $this::" << id << " $::DialRaised" << ENDL;
    if(frameShadow == "Sunken") fout << "    qwtCompassSetFrameShadow $p $this::" << id << " $::DialSunken" << ENDL;
    if(origin != "") fout << "    qwtCompassSetOrigin $p $this::" << id << " " << origin << ENDL;
    if(wrapping == "false") fout << "    qwtCompassSetWrapping $p $this::" << id << " 0" << ENDL;
    if(wrapping == "true" ) fout << "    qwtCompassSetWrapping $p $this::" << id << " 1" << ENDL;
  }
  else if(type == "QDateEdit")
  {
    fout << "  pvQDateEdit $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "  pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }
  else if(type == "QTimeEdit")
  {
    fout << "  pvQTimeEdit $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "  pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
    if(timeDisplay != "")
    {
      int h,m,s,ap;
      h = m = s = ap = 0;
      if(strstr((const char *) timeDisplay, "Hours")   != NULL) h = 1;
      if(strstr((const char *) timeDisplay, "Minutes") != NULL) m = 1;
      if(strstr((const char *) timeDisplay, "Seconds") != NULL) s = 1;
      if(strstr((const char *) timeDisplay, "AMPM")    != NULL) ap = 1;
      fout << "  pvSetTimeEditDisplay $p $this::" << id << " " << h << " " << m << " " << s << " " << ap << ENDL;
    }
  }
  else if(type == "QDateTimeEdit")
  {
    fout << "  pvQDateTimeEdit $p $this::" << id << " " << parent << ENDL;
    if(x != "") fout << "  pvSetGeometry $p $this::" << id << " " << x << " " << y << " " << w << " " << h << ENDL;
  }

  if(foregroundred != "")
  {
    fout << "    pvSetPaletteForegroundColor $p $this::" << id << " " << foregroundred << " " << foregroundgreen << " " << foregroundblue << ENDL;
  }
  if(backgroundred != "")
  {
    fout << "    pvSetPaletteBackgroundColor $p $this::" << id << " " << backgroundred << " " << backgroundgreen << " " << backgroundblue << ENDL;
  }

  if(fontfamily != "" || fontpointsize != "" || fontbold != "" || fontitalic != "" || fontunderline != "" || fontstrikeout != "")
  {
    if(fontfamily    == "") fontfamily    = "helvetica";
    if(fontpointsize == "") fontpointsize = "10";
    if(fontbold      == "") fontbold      = "0";
    if(fontitalic    == "") fontitalic    = "0";
    if(fontunderline == "") fontunderline = "0";
    if(fontstrikeout == "") fontstrikeout = "0";
    fout << "    pvSetFont $p $this::" << id << " \"" << fontfamily << "\" " << fontpointsize << " " << fontbold << " "
         << fontitalic << " " << fontunderline << " " << fontstrikeout << ENDL;
  }

  if(tooltip   != "") fout << "  pvToolTip  $p $this::" << id << " \"" << tooltip << "\""       << ENDL;
  if(shape     != "") fout << "  pvSetStyle $p $this::" << id << " " << shape << " -1 -1 -1 "   << ENDL;
  if(shadow    != "") fout << "  pvSetStyle $p $this::" << id << " -1 " << shadow <<" -1 -1 "   << ENDL;
  if(linewidth != "") fout << "  pvSetStyle $p $this::" << id << " -1 -1 " << linewidth<< " -1" << ENDL;
  if(margin    != "") fout << "  pvSetStyle $p $this::" << id << " -1 -1 -1 " << margin << ""   << ENDL;
  fout << ENDL;
}

void Generator::generateWidgetPvb(ofstream &fout, const char *text)
{
  static int index = 0;

  fout << "        <item xsi:type=\"ns:" << type << "\">" << ENDL;
  fout << "          <name>" << id << "</name>" << ENDL;
  fout << "          <index>" << index++ << "</index>" << ENDL;
  fout << "          <tooltip>" << tooltip << "</tooltip>" << ENDL;
  fout << "          <whatsthis>" << whatsThis << "</whatsthis>" << ENDL;
  fout << "          <parent>" << parent << "</parent>" << ENDL;
  fout << "        </item>" << ENDL;
  if(text == NULL) return;
}

void Generator::quote()
{
  text.replace("\\", "\\\\");
  text.replace("\"", "\\\"");
}

void Generator::generateLayout(ofstream &fout, QDomNode node)
{
  QDomNode inode,lnode;
  QString root,entry,lrow,lcol;
  unsigned int i;

  if(version[0] == '3') parseWidgetV30(node);
  else                  parseWidgetV2(node);

  if(vbox == "" && hbox == "" && grid == "") return;
  //cout << "type=" << type << " id=" << id << " parent=" << parent
  //     << " x=" << x << " y=" << y << " w=" << w << " h=" << h << " text=" << text << ENDL;

  if(type == "QDialog") root = "0";
  else                  root = id;
  for(i=0; i<layout.count(); i++)
  {
    lnode = layout.item(i);
    if(lnode.nodeName() == "widget")
    {
      entry = "0";
      inode = lnode.firstChild();
      while(!inode.isNull())
      {
        if(inode.nodeName() == "property" && inode.toElement().attributeNode("name").value() == "name")
        {
          entry = inode.firstChild().toElement().text();
          break;
        }
        inode = inode.nextSibling();
      }
      lrow  = lnode.toElement().attributeNode("row").value();
      lcol  = lnode.toElement().attributeNode("column").value();
      if(lrow.isNull()) lrow = "-1";
      if(lcol.isNull()) lcol = "-1";
      if(language == LANGUAGE_C)
        fout << "  pvAddWidgetOrLayout(p," << root << "," << entry << "," << lrow << "," << lcol <<");" << ENDL;
      if(language == LANGUAGE_PYTHON)
        fout << "    ret = pvAddWidgetOrLayout(p,self." << root << ",self." << entry << "," << lrow << "," << lcol << ")" << ENDL;
      if(language == LANGUAGE_PHP)
        fout << "    $ret = pvAddWidgetOrLayout($p,$this->" << root << ",$this->" << entry << "," << lrow << "," << lcol << ");" << ENDL;
      if(language == LANGUAGE_PERL)
        fout << "  $ret = pv::pvAddWidgetOrLayout($p,$" << root << ",$" << entry << "," << lrow << "," << lcol << ");" << ENDL;
      if(language == LANGUAGE_TCL)
        fout << "    pvAddWidgetOrLayout $p $this::" << root << " $this::" << entry << " " << lrow << " " << lcol << ENDL;
    }
    else if(lnode.nodeName() == "spacer")
    {
      if(language == LANGUAGE_C)
        fout << "  pvAddStretch(p," << root << ",1);" << ENDL;
      if(language == LANGUAGE_PYTHON)
        fout << "    ret = pvAddStretch(p,self." << root << ",1)" << ENDL;
      if(language == LANGUAGE_PHP)
        fout << "    $ret = pvAddStretch(p,$this->" << root << ",1);" << ENDL;
      if(language == LANGUAGE_PERL)
        fout << "  $ret = pv::pvAddStretch($p,$" << root << ",1);" << ENDL;
      if(language == LANGUAGE_TCL)
        fout << "    pvAddStretch $p $this::" << root << " 1" << ENDL;
    }
  }
}

void Generator::generateSlots()
{
  QString name = maskname;
  name.append("_slots.h");
  ofstream fout(name);

  fout << "//###############################################################" << ENDL;
  fout << "//# " << maskname << "_slots.h for ProcessViewServer created: " << QDateTime::currentDateTime().toString() << ENDL;
  fout << "//# please fill out these slots" << ENDL;
  fout << "//# here you find all possible events" << ENDL;
  fout << "//# Yours: Lehrig Software Engineering" << ENDL;
  fout << "//###############################################################" << ENDL;
  fout << "" << ENDL;
  fout << "// todo: uncomment me if you want to use this data aquisiton" << ENDL;
  fout << "// also uncomment this classes in main.cpp and pvapp.h" << ENDL;
  fout << "// also remember to uncomment rllib in the project file" << ENDL;
  fout << "//extern rlModbusClient     modbus;" << ENDL;
  fout << "//extern rlSiemensTCPClient siemensTCP;" << ENDL;
  fout << "//extern rlPPIClient        ppi;" << ENDL;
  fout << "" << ENDL;
  fout << "typedef struct // (todo: define your data structure here)" << ENDL;
  fout << "{" << ENDL;
  fout << "}" << ENDL;
  fout << "DATA;" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotInit(PARAM *p, DATA *d)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || d == NULL) return -1;" << ENDL;
  fout << "  //memset(d,0,sizeof(DATA));"                                            << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotNullEvent(PARAM *p, DATA *d)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || d == NULL) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotButtonEvent(PARAM *p, int id, DATA *d)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotButtonPressedEvent(PARAM *p, int id, DATA *d)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotButtonReleasedEvent(PARAM *p, int id, DATA *d)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotTextEvent(PARAM *p, int id, DATA *d, const char *text)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || text == NULL) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotSliderEvent(PARAM *p, int id, DATA *d, int val)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || val < -1000) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotCheckboxEvent(PARAM *p, int id, DATA *d, const char *text)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || text == NULL) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotRadioButtonEvent(PARAM *p, int id, DATA *d, const char *text)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || text == NULL) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotGlInitializeEvent(PARAM *p, int id, DATA *d)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotGlPaintEvent(PARAM *p, int id, DATA *d)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotGlResizeEvent(PARAM *p, int id, DATA *d, int width, int height)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || width < 0 || height < 0) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotGlIdleEvent(PARAM *p, int id, DATA *d)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotTabEvent(PARAM *p, int id, DATA *d, int val)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || val < -1000) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotTableTextEvent(PARAM *p, int id, DATA *d, int x, int y, const char *text)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || x < -1000 || y < -1000 || text == NULL) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotTableClickedEvent(PARAM *p, int id, DATA *d, int x, int y, int button)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || x < -1000 || y < -1000 || button < 0) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotSelectionEvent(PARAM *p, int id, DATA *d, int val, const char *text)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || val < -1000 || text == NULL) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotClipboardEvent(PARAM *p, int id, DATA *d, int val)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || val < -1000) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotRightMouseEvent(PARAM *p, int id, DATA *d, const char *text)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || text == NULL) return -1;" << ENDL;
  fout << "  //pvPopupMenu(p,-1,\"Menu1,Menu2,,Menu3\");" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotKeyboardEvent(PARAM *p, int id, DATA *d, int val)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || val < -1000) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotMouseMovedEvent(PARAM *p, int id, DATA *d, float x, float y)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || x < -1000 || y < -1000) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotMousePressedEvent(PARAM *p, int id, DATA *d, float x, float y)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || x < -1000 || y < -1000) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotMouseReleasedEvent(PARAM *p, int id, DATA *d, float x, float y)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || x < -1000 || y < -1000) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
  fout << "" << ENDL;
  fout << "static int slotUserEvent(PARAM *p, int id, DATA *d, const char *text)" << ENDL;
  fout << "{" << ENDL;
  fout << "  if(p == NULL || id == 0 || d == NULL || text == NULL) return -1;" << ENDL;
  fout << "  return 0;" << ENDL;
  fout << "}" << ENDL;
}
