/***************************************************************************
                          generator.h  -  description
                             -------------------
    begin                : Mon Feb  4 17:11:52 CET 2002
    copyright            : (C) 2002 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <fstream.h>
#include "qstring.h"
#include "qstringlist.h"
#include "qdom.h"
#include "qtextcodec.h"

class Generator
{
  public:
    Generator();
    ~Generator();
    int  generate(const char *input_name, QDomDocument *uidoc, QStringList *clist, const char *filename);
    void setFormat(const char *Language);
  private:
    enum generator_language
    {
      LANGUAGE_C   = 0,
      LANGUAGE_PYTHON ,
      LANGUAGE_PHP    ,
      LANGUAGE_PERL   ,
      LANGUAGE_TCL    ,
      LANGUAGE_PVB
    };
    void generateHeader(ofstream &fout, QStringList *clist);
    void generateTrailer(ofstream &fout, QStringList *clist);
    void generateWidget(ofstream &fout, QDomNode node);
    void generateWidgetC(ofstream &fout, const char *text);
    void generateWidgetPython(ofstream &fout, const char *text);
    void generateWidgetPhp(ofstream &fout, const char *text);
    void generateWidgetPerl(ofstream &fout, const char *text);
    void generateWidgetTcl(ofstream &fout, const char *text);
    void generateWidgetPvb(ofstream &fout, const char *text);
    void generateLayout(ofstream &fout, QDomNode node);
    void generateLayoutC(ofstream &fout);
    void generateLayoutPython(ofstream &fout);
    void generateLayoutPerl(ofstream &fout);
    void generateLayoutPhp(ofstream &fout);
    void generateLayoutTcl(ofstream &fout);
    void generateSlots();
    void parseWidgetV2(QDomNode node);
    void parseWidgetV30(QDomNode node);
    void generateToolTip(ofstream &fout, QDomNodeList &nodes);
    void generateWhatsThis(ofstream &fout, QDomNodeList &nodes);
    void getMaskname(const char *filename);
    void defaultValues();
    void quote();
    void generateTabOrder(ofstream &fout, QDomDocument *uidoc);
    QString version;
    QString maskname;
    QString type,id,parent,x,y,w,h,text,mode,style,shape,shadow,linewidth,margin,
            numdigits,editable,pagestep,value,minvalue,maxvalue,orientation,insertionpolicy,
            tooltip,parentclass,numRows,numCols,progress,maxlines,checked,echomode,selectionmode,
            fontfamily,fontpointsize,fontbold,fontitalic,fontunderline,fontstrikeout,tabposition,
            foregroundred,foregroundgreen,foregroundblue,backgroundred,backgroundgreen,backgroundblue,
            whatsThis,buddy,pixmap;
    QString canvasBackgroundRed,canvasBackgroundGreen,canvasBackgroundBlue,canvasLineWidth,
            xBottomAxis,xTopAxis,yLeftAxis,yRightAxis,nCurves,nMarker;
    //QwtScale
    QString position,title,titleFontfamily,titleFontsize,titleFontbold,titleFontitalic,
            titleFontunderline,titleFontstrikeout,titleColorRed,titleColorGreen,titleColorBlue;
    //QwtThermo
    //QwtKnob
    QString readOnly,mass,knobWidth,borderWidth,totalAngle,symbol;
    //QwtCounter
    QString numButtons,basicstep,minValue,maxValue,stepButton1,stepButton2,stepButton3;
    //QwtWheel
    QString viewAngle,tickCnt,internalBorder;
    //QwtSlider
    QString thumbLength,thumbWidth,bgStyle,scalePos;
    //QwtCompass
    QString visibleBackground,frameShadow,origin,wrapping;
    QString timeDisplay,alignment;

    QString vbox, hbox, grid;
    QString spacer_name, spacer_orientation, spacer_sizetype, spacer_sizehint_width, spacer_sizehint_height;
    QDomNodeList layout;

    int language;
    int ienum;

    QTextCodec *codec;
};
