/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Mon Feb  4 17:11:52 CET 2002
    copyright            : (C) 2002 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <iostream.h>
#include <stdlib.h>
#include "qstringlist.h"
#include "qfile.h"
#include "qdom.h"
#include "generator.h"

int readCFile(const char *filename, QStringList *clist)
{
  char line[4096],*cptr;
  FILE *fp;

  fp = fopen(filename,"r");
  if(fp==NULL) return -1;

  while(fgets(line,sizeof(line)-1,fp) != NULL)
  {
    cptr = strchr(line,'\n');
    if(cptr != NULL) *cptr = '\0';
    clist->append(line);
  }

  fclose(fp);
  return 0;
}

int main(int argc, char *argv[])
{

  int ret = 0;

  if(argc != 3)
  {
    cout << "######################################################" << endl;
    cout << "# Convert Qt Designer file input.ui to language file #" << endl;
    cout << "######################################################" << endl;
    cout << "usage:"                                                 << endl;
    cout << "ui2pvc input.ui output.c      # generate C file"        << endl;
    cout << "ui2pvc input.ui output.cpp    # generate CPP file"      << endl;
    cout << "ui2pvc input.ui output.py     # generate Python file"   << endl;
    cout << "ui2pvc input.ui output.pm     # generate Perl file"     << endl;
    cout << "ui2pvc input.ui output.php    # generate PHP file"      << endl;
    cout << "ui2pvc input.ui output.tcl    # generate Tcl file"      << endl;
    cout << "ui2pvc input.ui output.pvb    # generate pvb file"      << endl;
    return 1;
  }
  QDomDocument *uidoc = new QDomDocument();
  QFile *uifile = new QFile(argv[1]);
  if(uifile->open(IO_ReadOnly))
  {
    uidoc->setContent(uifile);
    uifile->close();
    QStringList *clist = new QStringList();
    readCFile(argv[2], clist);
    Generator *gen = new Generator();
    if(strstr(argv[2],".py")   != NULL) gen->setFormat("python");
    if(strstr(argv[2],".php")  != NULL) gen->setFormat("php");
    if(strstr(argv[2],".pm")   != NULL) gen->setFormat("perl");
    if(strstr(argv[2],".tcl")  != NULL) gen->setFormat("tcl");
    if(strstr(argv[2],".pvb")  != NULL) gen->setFormat("pvb");
    ret = gen->generate(argv[1],uidoc,clist,argv[2]);
    delete gen;
    delete clist;
  }
  else
  {
    cout << "could not open " << argv[1] << endl;
    ret = 1;
  }
  delete uifile;
  delete uidoc;
  return ret;
}
