/*
		Paralyze - Copyright (C) 1992, Nick Hilliard.
		=============================================

	The author of this code disclaims ALL responsibility for damage, loss
	of data, breakins, or ANY other inconvenience, consequential or 
	otherwise, caused by the use of or inability to use this program.

        Slightly modified for AXP support by Hunter Goatley, July 5, 1993.

*/

#include <stdio.h>
#include <ctype.h>
#include <descrip.h>
#include <smgdef.h>
#include <ssdef.h>
#include <ttdef.h>
#include <jpidef.h>
#include <uaidef.h>
#include <libclidef.h>

#define MIN(a, b) (a) < (b) ? (a) : (b)
#define libcall(function) \
	{ status = function; if (status != SS$_NORMAL) lib$stop (status); }

typedef unsigned long dword;
typedef unsigned short word;

typedef struct {
	word	buflen;		/* Buffer length */
	word	itmcod;		/* Code for what we want returned */
	dword	bufadr;		/* address of result */
	dword	retadr;		/* length of result */
} ITMLST;

typedef struct __msg_list {
	char *text;
	struct __msg_list *next;
} MESSAGE_LIST;

/* Function prototypes */

init ();
deinit ();
draw_initial_screens ();
put_text ();
get_user_info ();
get_password ();
word check_password ();
incorrect_pass ();
word getkey ();
new_message ();
set_prn ();
kill_proc ();
broadcast_receiver ();
broadcast_printer ();
parse_args (word, char **);


/* Global variables */

static char Ident [] = "Paralyze v1.2 - Copyright (C) 1992 Nick Hilliard";
char logfilename []  = "sys$login:paralyze.log;";

volatile 
unsigned	broadcasts = 0,
		in_broadcast_receiver = 0,
		broadcast_queue = 0;
char 		orig_procname[16],
		username [12],
		password [33],
		hash_algorithm;
dword		display_id,
		pasteboard,
		ctrl_mask,
		keyboard;
word		time_bin [4],
		time_left = 30,		/* Time before you are logged off */
 		hashed_pass [4],
		salt,
		save_messages = 0,	/* Flag to dump messages to file */
		change_process_name = 0;
MESSAGE_LIST	*first_message;
volatile
MESSAGE_LIST	*message_list;

main (word argc, char **argv)
{
	word	password_failures = 0,
		status;

	first_message = message_list = calloc (1, sizeof (MESSAGE_LIST));

	parse_args (argc, argv);
	get_user_info ();
	init ();
	draw_initial_screens ();

	while (1) {
		get_password ();
		if (check_password ())
			break;
		incorrect_pass ();
		password_failures++;
		smg$repaint_screen (&pasteboard);
	}

	libcall (sys$cantim (0, 0));			/* Turn off timer */
	lib$enable_ctrl (&ctrl_mask);			/* reenable CTRL keys */
	deinit ();
	if (password_failures) {
		if (password_failures == 1)
			printf ("There was 1 attempted break-in");
		else 
			printf ("There were %u attempted break-ins", 
				password_failures);
		printf (" while you were gone.\n");
	} else {
		printf ("Nobody tried to break into your account.\n");
	}
	broadcast_printer ();
	exit (0);
}

parse_args (word argc, char **argv)	/* Doesn't use DCL CLI$ functions */
{					/* Real soon now, though... :-) */
	FILE	*outfile;
	char	*p;

	while (--argc) {
		p = argv [argc];
		if (*p == '/' || *p == '-') {
			p++;
			switch (*p) {
				case 's':
					save_messages = 1;
		if (outfile = fopen (logfilename, "w")) {
			fprintf (outfile, 
		"%s.\nParalyze received the following messages:\n\n", Ident);
			fclose (outfile);
		} else {
			printf ("Couldn't open %s\n", logfilename);
			save_messages = 0;
		}
					break;
				case 'p':
					change_process_name = 1;
					break;
				default :
					printf("Unknown argument\n");
				case '?':		/* Fall through */
				case 'h':
					print_help ();
					break;
			}
		} else {
			print_help ();
		}
	}
}

print_help ()
{
	word	i;
	char	*message [] = {
"Paralyze is a terminal locking program which will enable you to leave your",
"terminal unattended for a short period of time, knowing that nobody will",
"be able to gain access to your account. It will trap all broadcasts to the",
"screen and optionally save them. It also tells you if there were any attempts",
"made to access the account. Finally, it logs out after 30 minutes, since any",
"longer than that could be seen as terminal-hogging.",
"\nUsage: PARALYZE [-sh?]",
"\t-s: Save message in log file",
"\t-h/?: This help screen",
"\0"
	};

	printf ("%s\n\n", Ident);
	for (i=0; *message [i]; i++) {
		printf ("%s\n", message [i]);
	}
	exit (1);
}

init ()
{
	word	status;
	$DESCRIPTOR (time_asc, "0000 00:01:00.00"); /* Time: dddd hh:mm:ss.cc */
				/* Note: This is relative time, not absolute  */

	libcall (sys$bintim (&time_asc, &time_bin));  /* time: Asc -> Binary */
	libcall (lib$disable_ctrl ( &(LIB$M_CLI_CTRLT | LIB$M_CLI_CTRLY), 
				&ctrl_mask));   /* Disable CTRL Y and CTRL T */
	libcall (smg$create_pasteboard ( &pasteboard, 0, 0, 0, 0));

	libcall (smg$set_term_characteristics (&pasteboard, &TT$M_PASSALL, &0, 
		&(TT$M_HOSTSYNC | TT$M_TTSYNC) , &0, 0, 0));
					/* disable ^\, ^^, ^T and ^Y*/

	libcall (smg$set_broadcast_trapping (&pasteboard, broadcast_receiver,
				0)); /* All broadcasts trapped using ASTs */
	libcall (smg$create_virtual_display ( &10, &60, &display_id, 
								&SMG$M_BORDER));
	libcall (smg$paste_virtual_display (&display_id, &pasteboard, &4, &10));
			     /* Put the display in the middle of the screen */
	libcall (smg$create_virtual_keyboard (&keyboard));

	time_left ++;
	set_prn();
}

deinit ()
{
	word	status;
	$DESCRIPTOR(procident, orig_procname);

	if (change_process_name) {
		procident.dsc$w_length = strlen (orig_procname);
		sys$setprn (&procident);		/* Reset proc name */
	}

	smg$disable_broadcast_trapping (&pasteboard);

	smg$delete_virtual_display (&display_id);
	smg$delete_pasteboard (&pasteboard, &0);	/* Don't CLS */
	smg$delete_virtual_keyboard (&keyboard);
}

put_text (char *text, dword disp, dword row, dword col, dword attr)
{
	$DESCRIPTOR (textdescrip, text);

	textdescrip.dsc$w_length = strlen (text);
	smg$put_chars (	&disp, &textdescrip, &row, &col, 
			&SMG$M_ERASE_LINE, &attr);
}

draw_initial_screens ()
{
	word	status;
	long	i;
	char	txt [60];


	put_text (Ident, display_id, 1, 6, SMG$M_UNDERLINE );

	sprintf (txt, "This terminal will log itself out in %u minutes.",
								time_left);
	put_text (txt, display_id, 3, 6, 0);
	put_text ("Be back before then!", display_id, 6, 19, 
						SMG$M_BOLD | SMG$M_BLINK);

	libcall (smg$set_cursor_mode (&pasteboard, &SMG$M_CURSOR_OFF));
	libcall (lib$wait (& ((float)5)) );
	libcall (smg$set_cursor_mode (&pasteboard, &SMG$M_CURSOR_ON));

	for (i=3; i<6; i++) {
		libcall (smg$erase_line (&display_id, &i));
	}

	sprintf (txt, "This terminal is being used by %s,", username);

	put_text (txt, display_id, 3, 9, 0);
	put_text ("who will be back shortly.", display_id,
			4, 16, 0);
	put_text ("Enter Password: ", display_id, 6, 12, 0);
}

incorrect_pass ()
{
	put_text ("Incorrect password - Press any key and try again.", 
			display_id, 8, 7, SMG$M_BOLD + SMG$M_BLINK);
	smg$set_cursor_mode (&pasteboard, &SMG$M_CURSOR_OFF);

	getkey ();

	smg$set_cursor_mode (&pasteboard, &SMG$M_CURSOR_ON);
	smg$erase_line (&display_id, &8, &1);
	smg$set_cursor_abs (&display_id, &6, &28);
}

word check_password ()
{
	word		hash [4];
	$DESCRIPTOR	(pass, password);
	$DESCRIPTOR	(user, username);
	word 		i;

	pass.dsc$w_length = strlen (password);
	user.dsc$w_length = strlen (username);

	sys$hash_password (&pass, hash_algorithm, salt, &user, &hash);

	for (i=0; i<4; i++) {
     		if (hash [i] != hashed_pass [i])
			return (0);
	}
	return(1);
}

get_password ()
{
	unsigned	i = 0;
	word		key;

	while (1) {
		if ( !(key = toupper (getkey ()) ) )
			continue;

		if ((key == SMG$K_TRM_CR || key == SMG$K_TRM_LF) && i) {
			password [i] = 0;
			break;
		}
		if (key == SMG$K_TRM_DELETE && i) {
			i--;
			continue;
		}
		if (i == 32 )
			continue;
		if (isalnum (key) || key == '$' || key == '_' ) 
			password [i++] = key;
	}
}

get_user_info ()
{
	word	user_len,
		proc_len,
		status;
	char	user [12];			/* Backup of same */
	$DESCRIPTOR (userident, username);	/* (passed to sys$getuai) */

	ITMLST	uai_itmlst [] = { 		/* necessary UAI info */
		{2, UAI$_ENCRYPT, &hash_algorithm, 0},
		{8, UAI$_PWD, &hashed_pass, 0},
		{4, UAI$_SALT, &salt, 0},
		{0, 0, 0, 0}
	};
	ITMLST	jpi_itmlst [] = { 		/* Get username */
		{sizeof (username), JPI$_USERNAME, &username, &user_len},
		{sizeof (orig_procname), JPI$_PRCNAM, &orig_procname, 
								&proc_len},
		{0, 0, 0, 0}
	};

	libcall (sys$getjpiw (0, 0, 0, &jpi_itmlst, 0, 0, 0));	/* username */

	if (change_process_name)
		orig_procname [proc_len] = 0;

	username [MIN (strcspn (username, " "), user_len-1)] = 0; /* trim it */
	userident.dsc$w_length = (short)strlen (username);
	strcpy (user, username);			/* make copy of name */

	libcall (sys$getuai (0, 0, &userident, &uai_itmlst, 0, 0, 0));
	strcpy (username, user);	/* get all info - sys$getuai destroys */
				   /* username for some reason - not sure why */

}

word getkey ()
{
	dword	timeout = 5;	/* Please do not change this! */
	long	status;
	short	keycode;

	/* Note we need a timeout here because the $SETIMR AST doesn't get */
	/* called until a key is pressed :-( */
retry:
	switch (status = smg$read_keystroke 
			(&keyboard, &keycode, 0, &timeout, 0, 0, 0)) {
		case SS$_NORMAL:
			break;
		case SMG$_EOF:
			keycode = '\032';
			break;
		default:
			goto retry; /* The most efficient way of looping back */
			break;
	}

	if (keycode <= 31 && keycode >= 28)
		keycode = 0;

	return (keycode);
}

broadcast_printer ()
{
	char	buffer   [16384],
		messages [20000];
	$DESCRIPTOR (message, buffer);
	short	length;
	void	*p;

	if (broadcasts) {
		printf (
	"The following messages were received while you were away:\n\n");
	} else  {
		printf (
	"There were no messages received while you were away.\n\n");
		delete (logfilename);
	}

	p = message_list = first_message;
	while ( (message_list = message_list->next) && broadcasts) {
		printf ("%s\n\n", message_list->text);
		free (message_list->text);
		free (p);
		p = message_list;
	}
	free (message_list);
}

new_message (char *text)
{
	FILE 	*outfile;
	short	curr_time [4],
		length;
	char	output_message [16410],	/* 16410 = 16384 (max broad) + a bit */
		asc_time [25];
	$DESCRIPTOR (time_descrip, asc_time);

	sys$gettim (&curr_time);                       
	sys$asctim (&length, &time_descrip, &curr_time, &1);
	asc_time [length-3] = 0;	/* Delete the hundredths of a sec */

	sprintf (output_message, "Message #%u (Received %s)\n%s", 
		broadcasts, asc_time, text);

	if (save_messages) {
		if (outfile = fopen (logfilename, "a+")) {
			fprintf (outfile, "%s\n\n", output_message);
			fclose (outfile);
		} else {
			printf ("[PARALYZE: Couldn't open %s]\n", logfilename);
			save_messages = 0;
			message_list->next = calloc (1, sizeof (MESSAGE_LIST));
			message_list = message_list->next;
			message_list->text = malloc (strlen (logfilename)+30);
			sprintf (message_list->text, 
				"[PARALYZE: Couldn't open %s]\n", logfilename);
		}
	}

	message_list->next = calloc (1, sizeof (MESSAGE_LIST));
	message_list = message_list->next;
	message_list->text = malloc (strlen (output_message)+1);
	strcpy (message_list->text, output_message);
}

/* These last three functions are ASTS */

set_prn ()
{
	char	message[20];
	word	status;
	$DESCRIPTOR(procname, "PARALYZEd (xx)");

	if (!time_left)
		kill_proc ();
	time_left--;
	sprintf (procname.dsc$a_pointer, "PARALYZEd (%u)", time_left);
	sprintf (message, time_left == 1 ? "(%u minute left)" : 
			"(%u minutes left)", time_left);
	put_text (message, display_id, 10, 20, 0);
	smg$set_cursor_abs (&display_id, &6, &28);

	if (change_process_name) {
		procname.dsc$w_length = time_left >= 10 ? 15 : 14;
		sys$setprn (&procname);
	}

	libcall (sys$setimr (0, &time_bin, set_prn, 0, 0));
						/* Call set_prn in 1 min. */
}

broadcast_receiver ()
{
	short	length;
	char	message_buffer [16384],
		asc_time [25];
	$DESCRIPTOR (mess_text, message_buffer);

	if (in_broadcast_receiver) {
		broadcast_queue++;	/* Can't have re-entrancy */
		return;			/* therefore queue messages */
	}

	in_broadcast_receiver = 1;
	broadcasts++;

	if (smg$get_broadcast_message (&pasteboard, &mess_text, &length) 
						== SS$_NORMAL && length != 0) {
		message_buffer [length] = '\0';
		new_message (message_buffer);
	}
	in_broadcast_receiver = 0;
	if (broadcast_queue) {
		broadcast_queue--;
		broadcast_receiver ();
	}
}

kill_proc ()
{
	dword	master_pid;

	ITMLST	jpi_itmlst [] = { 		/* Get Master PID */
		{sizeof (master_pid), JPI$_MASTER_PID, &master_pid, 0},
		{0, 0, 0, 0}
	};

	sys$getjpiw (0, 0, 0, &jpi_itmlst, 0, 0, 0);	/* get user's PID */
	deinit ();
	broadcast_printer ();			/* Print out broadcasts */
	printf ("User %s Logged out.\n\n", username);
	sys$delprc (&master_pid, &0);		/* Hari-Kiri! */

	/* $DELPRC is not a great way of logging out, but there isn't any other
	  simple way of doing it. $DELPRC can cause problems under DECWindows */
}
