ac_help=
ac_default_prefix=sys$system:
ac_help="$ac_help
  --enable-gcc            allow use of gcc if available"
ac_help="$ac_help
  --disable-load          disallow dynamic loading and "load" command"
ac_help="$ac_help
  --enable-symbols        build with debugging symbols"
ac_help="$ac_help
  --enable-shared         build libtcl as a shared library"

build=NONE
cache_file=config.cache
exec_prefix=NONE
host=NONE
no_create=
nonopt=NONE
no_recursion=
prefix=NONE
program_prefix=NONE
program_suffix=NONE
program_transform_name=s,x,x,
silent=
site=
srcdir=
target=NONE
verbose=
x_includes=NONE
x_libraries=NONE
bindir=[.'exec_prefix'.bin]
sbindir=sys$system:
libexecdir=sys$share:
datadir='${prefix}/share'
sysconfdir='${prefix}/etc'
sharedstatedir='${prefix}/com'
localstatedir='${prefix}/var'
libdir='${exec_prefix}/lib'
includedir='${prefix}/include'
oldincludedir='/usr/include'
infodir='${prefix}/info'
mandir=sys$help:

# Initialize some other variables.
subdirs=
MFLAGS= MAKEFLAGS=

ac_prev=
for ac_option
do

  # If the previous option needs an argument, assign it.
  if test -n "$ac_prev"; then
    eval "$ac_prev=\$ac_option"
    ac_prev=
    continue
  fi

  case "$ac_option" in
  -*=*) ac_optarg=`echo "$ac_option" | sed 's/[-_a-zA-Z0-9]*=//'` ;;
  *) ac_optarg= ;;
  esac

  # Accept the important Cygnus configure options, so we can diagnose typos.

  case "$ac_option" in

  -bindir | --bindir | --bindi | --bind | --bin | --bi)
    ac_prev=bindir ;;
  -bindir=* | --bindir=* | --bindi=* | --bind=* | --bin=* | --bi=*)
    bindir="$ac_optarg" ;;

  -build | --build | --buil | --bui | --bu)
    ac_prev=build ;;
  -build=* | --build=* | --buil=* | --bui=* | --bu=*)
    build="$ac_optarg" ;;

  -cache-file | --cache-file | --cache-fil | --cache-fi \
  | --cache-f | --cache- | --cache | --cach | --cac | --ca | --c)
    ac_prev=cache_file ;;
  -cache-file=* | --cache-file=* | --cache-fil=* | --cache-fi=* \
  | --cache-f=* | --cache-=* | --cache=* | --cach=* | --cac=* | --ca=* | --c=*)
    cache_file="$ac_optarg" ;;

  -datadir | --datadir | --datadi | --datad | --data | --dat | --da)
    ac_prev=datadir ;;
  -datadir=* | --datadir=* | --datadi=* | --datad=* | --data=* | --dat=* \
  | --da=*)
    datadir="$ac_optarg" ;;

  -disable-* | --disable-*)
    ac_feature=`echo $ac_option|sed -e 's/-*disable-//'`
    # Reject names that are not valid shell variable names.
    if test -n "`echo $ac_feature| sed 's/[-a-zA-Z0-9_]//g'`"; then
      { echo "configure: error: $ac_feature: invalid feature name" 1>&2; exit 1; }
    fi
    ac_feature=`echo $ac_feature| sed 's/-/_/g'`
    eval "enable_${ac_feature}=no" ;;

  -enable-* | --enable-*)
    ac_feature=`echo $ac_option|sed -e 's/-*enable-//' -e 's/=.*//'`
    # Reject names that are not valid shell variable names.
    if test -n "`echo $ac_feature| sed 's/[-_a-zA-Z0-9]//g'`"; then
      { echo "configure: error: $ac_feature: invalid feature name" 1>&2; exit 1; }
    fi
    ac_feature=`echo $ac_feature| sed 's/-/_/g'`
    case "$ac_option" in
      *=*) ;;
      *) ac_optarg=yes ;;
    esac
    eval "enable_${ac_feature}='$ac_optarg'" ;;

  -exec-prefix | --exec_prefix | --exec-prefix | --exec-prefi \
  | --exec-pref | --exec-pre | --exec-pr | --exec-p | --exec- \
  | --exec | --exe | --ex)
    ac_prev=exec_prefix ;;
  -exec-prefix=* | --exec_prefix=* | --exec-prefix=* | --exec-prefi=* \
  | --exec-pref=* | --exec-pre=* | --exec-pr=* | --exec-p=* | --exec-=* \
  | --exec=* | --exe=* | --ex=*)
    exec_prefix="$ac_optarg" ;;

  -gas | --gas | --ga | --g)
    # Obsolete; use --with-gas.
    with_gas=yes ;;

  -help | --help | --hel | --he)
    # Omit some internal or obsolete options to make the list less imposing.
    # This message is too long to be a string in the A/UX 3.1 sh.
    cat << EOF
Usage: configure [options] [host]
Options: [defaults in brackets after descriptions]
Configuration:
  --cache-file=FILE       cache test results in FILE
  --help                  print this message
  --no-create             do not create output files
  --quiet, --silent       do not print \`checking...' messages
  --version               print the version of autoconf that created configure
Directory and file names:
  --prefix=PREFIX         install architecture-independent files in PREFIX
                          [$ac_default_prefix]
  --exec-prefix=EPREFIX   install architecture-dependent files in EPREFIX
                          [same as prefix]
  --bindir=DIR            user executables in DIR [EPREFIX/bin]
  --sbindir=DIR           system admin executables in DIR [EPREFIX/sbin]
  --libexecdir=DIR        program executables in DIR [EPREFIX/libexec]
  --datadir=DIR           read-only architecture-independent data in DIR
                          [PREFIX/share]
  --sysconfdir=DIR        read-only single-machine data in DIR [PREFIX/etc]
  --sharedstatedir=DIR    modifiable architecture-independent data in DIR
                          [PREFIX/com]
  --localstatedir=DIR     modifiable single-machine data in DIR [PREFIX/var]
  --libdir=DIR            object code libraries in DIR [EPREFIX/lib]
  --includedir=DIR        C header files in DIR [PREFIX/include]
  --oldincludedir=DIR     C header files for non-gcc in DIR [/usr/include]
  --infodir=DIR           info documentation in DIR [PREFIX/info]
  --mandir=DIR            man documentation in DIR [PREFIX/man]
  --srcdir=DIR            find the sources in DIR [configure dir or ..]
  --program-prefix=PREFIX prepend PREFIX to installed program names
  --program-suffix=SUFFIX append SUFFIX to installed program names
  --program-transform-name=PROGRAM
                          run sed PROGRAM on installed program names
EOF
    cat << EOF
Host type:
  --build=BUILD           configure for building on BUILD [BUILD=HOST]
  --host=HOST             configure for HOST [guessed]
  --target=TARGET         configure for TARGET [TARGET=HOST]
Features and packages:
  --disable-FEATURE       do not include FEATURE (same as --enable-FEATURE=no)
  --enable-FEATURE[=ARG]  include FEATURE [ARG=yes]
  --with-PACKAGE[=ARG]    use PACKAGE [ARG=yes]
  --without-PACKAGE       do not use PACKAGE (same as --with-PACKAGE=no)
  --x-includes=DIR        X include files are in DIR
  --x-libraries=DIR       X library files are in DIR
EOF
    if test -n "$ac_help"; then
      echo "--enable and --with options recognized:$ac_help"
    fi
    exit 0 ;;

  -host | --host | --hos | --ho)
    ac_prev=host ;;
  -host=* | --host=* | --hos=* | --ho=*)
    host="$ac_optarg" ;;

  -includedir | --includedir | --includedi | --included | --include \
  | --includ | --inclu | --incl | --inc)
    ac_prev=includedir ;;
  -includedir=* | --includedir=* | --includedi=* | --included=* | --include=* \
  | --includ=* | --inclu=* | --incl=* | --inc=*)
    includedir="$ac_optarg" ;;

  -infodir | --infodir | --infodi | --infod | --info | --inf)
    ac_prev=infodir ;;
  -infodir=* | --infodir=* | --infodi=* | --infod=* | --info=* | --inf=*)
    infodir="$ac_optarg" ;;

  -libdir | --libdir | --libdi | --libd)
    ac_prev=libdir ;;
  -libdir=* | --libdir=* | --libdi=* | --libd=*)
    libdir="$ac_optarg" ;;

  -libexecdir | --libexecdir | --libexecdi | --libexecd | --libexec \
  | --libexe | --libex | --libe)
    ac_prev=libexecdir ;;
  -libexecdir=* | --libexecdir=* | --libexecdi=* | --libexecd=* | --libexec=* \
  | --libexe=* | --libex=* | --libe=*)
    libexecdir="$ac_optarg" ;;

  -localstatedir | --localstatedir | --localstatedi | --localstated \
  | --localstate | --localstat | --localsta | --localst \
  | --locals | --local | --loca | --loc | --lo)
    ac_prev=localstatedir ;;
  -localstatedir=* | --localstatedir=* | --localstatedi=* | --localstated=* \
  | --localstate=* | --localstat=* | --localsta=* | --localst=* \
  | --locals=* | --local=* | --loca=* | --loc=* | --lo=*)
    localstatedir="$ac_optarg" ;;

  -mandir | --mandir | --mandi | --mand | --man | --ma | --m)
    ac_prev=mandir ;;
  -mandir=* | --mandir=* | --mandi=* | --mand=* | --man=* | --ma=* | --m=*)
    mandir="$ac_optarg" ;;

  -nfp | --nfp | --nf)
    # Obsolete; use --without-fp.
    with_fp=no ;;

  -no-create | --no-create | --no-creat | --no-crea | --no-cre \
  | --no-cr | --no-c)
    no_create=yes ;;

  -no-recursion | --no-recursion | --no-recursio | --no-recursi \
  | --no-recurs | --no-recur | --no-recu | --no-rec | --no-re | --no-r)
    no_recursion=yes ;;

  -oldincludedir | --oldincludedir | --oldincludedi | --oldincluded \
  | --oldinclude | --oldinclud | --oldinclu | --oldincl | --oldinc \
  | --oldin | --oldi | --old | --ol | --o)
    ac_prev=oldincludedir ;;
  -oldincludedir=* | --oldincludedir=* | --oldincludedi=* | --oldincluded=* \
  | --oldinclude=* | --oldinclud=* | --oldinclu=* | --oldincl=* | --oldinc=* \
  | --oldin=* | --oldi=* | --old=* | --ol=* | --o=*)
    oldincludedir="$ac_optarg" ;;

  -prefix | --prefix | --prefi | --pref | --pre | --pr | --p)
    ac_prev=prefix ;;
  -prefix=* | --prefix=* | --prefi=* | --pref=* | --pre=* | --pr=* | --p=*)
    prefix="$ac_optarg" ;;

  -program-prefix | --program-prefix | --program-prefi | --program-pref \
  | --program-pre | --program-pr | --program-p)
    ac_prev=program_prefix ;;
  -program-prefix=* | --program-prefix=* | --program-prefi=* \
  | --program-pref=* | --program-pre=* | --program-pr=* | --program-p=*)
    program_prefix="$ac_optarg" ;;

  -program-suffix | --program-suffix | --program-suffi | --program-suff \
  | --program-suf | --program-su | --program-s)
    ac_prev=program_suffix ;;
  -program-suffix=* | --program-suffix=* | --program-suffi=* \
  | --program-suff=* | --program-suf=* | --program-su=* | --program-s=*)
    program_suffix="$ac_optarg" ;;

  -program-transform-name | --program-transform-name \
  | --program-transform-nam | --program-transform-na \
  | --program-transform-n | --program-transform- \
  | --program-transform | --program-transfor \
  | --program-transfo | --program-transf \
  | --program-trans | --program-tran \
  | --progr-tra | --program-tr | --program-t)
    ac_prev=program_transform_name ;;
  -program-transform-name=* | --program-transform-name=* \
  | --program-transform-nam=* | --program-transform-na=* \
  | --program-transform-n=* | --program-transform-=* \
  | --program-transform=* | --program-transfor=* \
  | --program-transfo=* | --program-transf=* \
  | --program-trans=* | --program-tran=* \
  | --progr-tra=* | --program-tr=* | --program-t=*)
    program_transform_name="$ac_optarg" ;;

  -q | -quiet | --quiet | --quie | --qui | --qu | --q \
  | -silent | --silent | --silen | --sile | --sil)
    silent=yes ;;

  -sbindir | --sbindir | --sbindi | --sbind | --sbin | --sbi | --sb)
    ac_prev=sbindir ;;
  -sbindir=* | --sbindir=* | --sbindi=* | --sbind=* | --sbin=* \
  | --sbi=* | --sb=*)
    sbindir="$ac_optarg" ;;

  -sharedstatedir | --sharedstatedir | --sharedstatedi \
  | --sharedstated | --sharedstate | --sharedstat | --sharedsta \
  | --sharedst | --shareds | --shared | --share | --shar \
  | --sha | --sh)
    ac_prev=sharedstatedir ;;
  -sharedstatedir=* | --sharedstatedir=* | --sharedstatedi=* \
  | --sharedstated=* | --sharedstate=* | --sharedstat=* | --sharedsta=* \
  | --sharedst=* | --shareds=* | --shared=* | --share=* | --shar=* \
  | --sha=* | --sh=*)
    sharedstatedir="$ac_optarg" ;;

  -site | --site | --sit)
    ac_prev=site ;;
  -site=* | --site=* | --sit=*)
    site="$ac_optarg" ;;

  -srcdir | --srcdir | --srcdi | --srcd | --src | --sr)
    ac_prev=srcdir ;;
  -srcdir=* | --srcdir=* | --srcdi=* | --srcd=* | --src=* | --sr=*)
    srcdir="$ac_optarg" ;;

  -sysconfdir | --sysconfdir | --sysconfdi | --sysconfd | --sysconf \
  | --syscon | --sysco | --sysc | --sys | --sy)
    ac_prev=sysconfdir ;;
  -sysconfdir=* | --sysconfdir=* | --sysconfdi=* | --sysconfd=* | --sysconf=* \
  | --syscon=* | --sysco=* | --sysc=* | --sys=* | --sy=*)
    sysconfdir="$ac_optarg" ;;

  -target | --target | --targe | --targ | --tar | --ta | --t)
    ac_prev=target ;;
  -target=* | --target=* | --targe=* | --targ=* | --tar=* | --ta=* | --t=*)
    target="$ac_optarg" ;;

  -v | -verbose | --verbose | --verbos | --verbo | --verb)
    verbose=yes ;;

  -version | --version | --versio | --versi | --vers)
    echo "configure generated by autoconf version 2.9"
    exit 0 ;;

  -with-* | --with-*)
    ac_package=`echo $ac_option|sed -e 's/-*with-//' -e 's/=.*//'`
    # Reject names that are not valid shell variable names.
    if test -n "`echo $ac_package| sed 's/[-_a-zA-Z0-9]//g'`"; then
      { echo "configure: error: $ac_package: invalid package name" 1>&2; exit 1; }
    fi
    ac_package=`echo $ac_package| sed 's/-/_/g'`
    case "$ac_option" in
      *=*) ;;
      *) ac_optarg=yes ;;
    esac
    eval "with_${ac_package}='$ac_optarg'" ;;

  -without-* | --without-*)
    ac_package=`echo $ac_option|sed -e 's/-*without-//'`
    # Reject names that are not valid shell variable names.
    if test -n "`echo $ac_package| sed 's/[-a-zA-Z0-9_]//g'`"; then
      { echo "configure: error: $ac_package: invalid package name" 1>&2; exit 1; }
    fi
    ac_package=`echo $ac_package| sed 's/-/_/g'`
    eval "with_${ac_package}=no" ;;

  --x)
    # Obsolete; use --with-x.
    with_x=yes ;;

  -x-includes | --x-includes | --x-include | --x-includ | --x-inclu \
  | --x-incl | --x-inc | --x-in | --x-i)
    ac_prev=x_includes ;;
  -x-includes=* | --x-includes=* | --x-include=* | --x-includ=* | --x-inclu=* \
  | --x-incl=* | --x-inc=* | --x-in=* | --x-i=*)
    x_includes="$ac_optarg" ;;

  -x-libraries | --x-libraries | --x-librarie | --x-librari \
  | --x-librar | --x-libra | --x-libr | --x-lib | --x-li | --x-l)
    ac_prev=x_libraries ;;
  -x-libraries=* | --x-libraries=* | --x-librarie=* | --x-librari=* \
  | --x-librar=* | --x-libra=* | --x-libr=* | --x-lib=* | --x-li=* | --x-l=*)
    x_libraries="$ac_optarg" ;;

  -*) { echo "configure: error: $ac_option: invalid option; use --help to show usage" 1>&2; exit 1; }
    ;;

  *)
    if test -n "`echo $ac_option| sed 's/[-a-z0-9.]//g'`"; then
      echo "configure: warning: $ac_option: invalid host type" 1>&2
    fi
    if test "x$nonopt" != xNONE; then
      { echo "configure: error: can only configure for one host and one target at a time" 1>&2; exit 1; }
    fi
    nonopt="$ac_option"
    ;;

  esac
done

if test -n "$ac_prev"; then
  { echo "configure: error: missing argument to --`echo $ac_prev | sed 's/_/-/g'`" 1>&2; exit 1; }
fi

trap 'rm -fr conftest* confdefs* core core.* *.core $ac_clean_files; exit 1' 1 2 15

# File descriptor usage:
# 0 standard input
# 1 file creation
# 2 errors and warnings
# 3 some systems may open it to /dev/tty
# 4 used on the Kubota Titan
# 6 checking for... messages and results
# 5 compiler messages saved in config.log
if test "$silent" = yes; then
  exec 6>/dev/null
else
  exec 6>&1
fi
exec 5>./config.log

echo "\
This file contains any messages produced by compilers while
running configure, to aid debugging if configure makes a mistake.
" 1>&5

# Strip out --no-create and --no-recursion so they do not pile up.
# Also quote any args containing shell metacharacters.
ac_configure_args=
for ac_arg
do
  case "$ac_arg" in
  -no-create | --no-create | --no-creat | --no-crea | --no-cre \
  | --no-cr | --no-c) ;;
  -no-recursion | --no-recursion | --no-recursio | --no-recursi \
  | --no-recurs | --no-recur | --no-recu | --no-rec | --no-re | --no-r) ;;
  *" "*|*"	"*|*[\[\]\~\#\$\^\&\*\(\)\{\}\\\|\;\<\>\?]*)
  ac_configure_args="$ac_configure_args '$ac_arg'" ;;
  *) ac_configure_args="$ac_configure_args $ac_arg" ;;
  esac
done

# NLS nuisances.
# Only set LANG and LC_ALL to C if already set.
# These must not be set unconditionally because not all systems understand
# e.g. LANG=C (notably SCO).
if test "${LC_ALL+set}" = set; then LC_ALL=C; export LC_ALL; fi
if test "${LANG+set}"   = set; then LANG=C;   export LANG;   fi

# confdefs.h avoids OS command line length limits that DEFS can exceed.
rm -rf conftest* confdefs.h
# AIX cpp loses on an empty file, so make sure it contains at least a newline.
echo > confdefs.h

# A filename unique to this package, relative to the directory that
# configure is in, which we can look for to find out if srcdir is correct.
ac_unique_file=../generic/tcl.h

# Find the source files, if location was not specified.
if test -z "$srcdir"; then
  ac_srcdir_defaulted=yes
  # Try the directory containing this script, then its parent.
  ac_prog=$0
  ac_confdir=`echo $ac_prog|sed 's%/[^/][^/]*$%%'`
  test "x$ac_confdir" = "x$ac_prog" && ac_confdir=.
  srcdir=$ac_confdir
  if test ! -r $srcdir/$ac_unique_file; then
    srcdir=..
  fi
else
  ac_srcdir_defaulted=no
fi
if test ! -r $srcdir/$ac_unique_file; then
  if test "$ac_srcdir_defaulted" = yes; then
    { echo "configure: error: can not find sources in $ac_confdir or .." 1>&2; exit 1; }
  else
    { echo "configure: error: can not find sources in $srcdir" 1>&2; exit 1; }
  fi
fi
srcdir=`echo "${srcdir}" | sed 's%\([^/]\)/*$%\1%'`

# Prefer explicitly selected file to automatically selected ones.
if test -z "$CONFIG_SITE"; then
  if test "x$prefix" != xNONE; then
    CONFIG_SITE="$prefix/share/config.site $prefix/etc/config.site"
  else
    CONFIG_SITE="$ac_default_prefix/share/config.site $ac_default_prefix/etc/config.site"
  fi
fi
for ac_site_file in $CONFIG_SITE; do
  if test -r "$ac_site_file"; then
    echo "loading site script $ac_site_file"
    . "$ac_site_file"
  fi
done

if test -r "$cache_file"; then
  echo "loading cache $cache_file"
  . $cache_file
else
  echo "creating cache $cache_file"
  > $cache_file
fi

ac_ext=c
# CFLAGS is not in ac_cpp because -g, -O, etc. are not valid cpp options.
ac_cpp='$CPP $CPPFLAGS'
ac_compile='${CC-cc} -c $CFLAGS $CPPFLAGS conftest.$ac_ext 1>&5'
ac_link='${CC-cc} -o conftest $CFLAGS $CPPFLAGS $LDFLAGS conftest.$ac_ext $LIBS 1>&5'

if (echo "testing\c"; echo 1,2,3) | grep c >/dev/null; then
  # Stardent Vistra SVR4 grep lacks -e, says ghazi@caip.rutgers.edu.
  if (echo -n testing; echo 1,2,3) | sed s/-n/xn/ | grep xn >/dev/null; then
    ac_n= ac_c='
' ac_t='	'
  else
    ac_n=-n ac_c= ac_t=
  fi
else
  ac_n= ac_c='\c' ac_t=
fi


# RCS: @(#) $Id: configure.in,v 1.28 1999/02/03 18:37:42 stanton Exp $

TCL_VERSION=8.0
TCL_MAJOR_VERSION=8
TCL_MINOR_VERSION=0
TCL_PATCH_LEVEL=".5"
VERSION=${TCL_VERSION}

if test "${prefix}" = "NONE"; then
    prefix=/usr/local
fi
if test "${exec_prefix}" = "NONE"; then
    exec_prefix=$prefix
fi
TCL_SRC_DIR=`cd $srcdir/..; pwd`

# Extract the first word of "ranlib", so it can be a program name with args.
set dummy ranlib; ac_word=$2
echo $ac_n "checking for $ac_word""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_prog_RANLIB'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  if test -n "$RANLIB"; then
  ac_cv_prog_RANLIB="$RANLIB" # Let the user override the test.
else
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:"
  for ac_dir in $PATH; do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      ac_cv_prog_RANLIB="ranlib"
      break
    fi
  done
  IFS="$ac_save_ifs"
  test -z "$ac_cv_prog_RANLIB" && ac_cv_prog_RANLIB=":"
fi
fi
RANLIB="$ac_cv_prog_RANLIB"
if test -n "$RANLIB"; then
  echo "$ac_t""$RANLIB" 1>&6
else
  echo "$ac_t""no" 1>&6
fi

# Check whether --enable-gcc or --disable-gcc was given.
if test "${enable_gcc+set}" = set; then
  enableval="$enable_gcc"
  tcl_ok=$enableval
else
  tcl_ok=no
fi

if test "$tcl_ok" = "yes"; then
    # Extract the first word of "gcc", so it can be a program name with args.
set dummy gcc; ac_word=$2
echo $ac_n "checking for $ac_word""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_prog_CC'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  if test -n "$CC"; then
  ac_cv_prog_CC="$CC" # Let the user override the test.
else
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:"
  for ac_dir in $PATH; do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      ac_cv_prog_CC="gcc"
      break
    fi
  done
  IFS="$ac_save_ifs"
fi
fi
CC="$ac_cv_prog_CC"
if test -n "$CC"; then
  echo "$ac_t""$CC" 1>&6
else
  echo "$ac_t""no" 1>&6
fi

if test -z "$CC"; then
  # Extract the first word of "cc", so it can be a program name with args.
set dummy cc; ac_word=$2
echo $ac_n "checking for $ac_word""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_prog_CC'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  if test -n "$CC"; then
  ac_cv_prog_CC="$CC" # Let the user override the test.
else
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:"
  ac_prog_rejected=no
  for ac_dir in $PATH; do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      if test "$ac_dir/$ac_word" = "/usr/ucb/cc"; then
        ac_prog_rejected=yes
	continue
      fi
      ac_cv_prog_CC="cc"
      break
    fi
  done
  IFS="$ac_save_ifs"
if test $ac_prog_rejected = yes; then
  # We found a bogon in the path, so make sure we never use it.
  set dummy $ac_cv_prog_CC
  shift
  if test $# -gt 0; then
    # We chose a different compiler from the bogus one.
    # However, it has the same basename, so the bogon will be chosen
    # first if we set CC to just the basename; use the full file name.
    shift
    set dummy "$ac_dir/$ac_word" "$@"
    shift
    ac_cv_prog_CC="$@"
  fi
fi
fi
fi
CC="$ac_cv_prog_CC"
if test -n "$CC"; then
  echo "$ac_t""$CC" 1>&6
else
  echo "$ac_t""no" 1>&6
fi

  test -z "$CC" && { echo "configure: error: no acceptable cc found in \$PATH" 1>&2; exit 1; }
fi

echo $ac_n "checking whether we are using GNU C""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_prog_gcc'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.c <<EOF
#ifdef __GNUC__
  yes;
#endif
EOF
if { ac_try='${CC-cc} -E conftest.c'; { (eval echo configure:663: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }; } | egrep yes >/dev/null 2>&1; then
  ac_cv_prog_gcc=yes
else
  ac_cv_prog_gcc=no
fi
fi

echo "$ac_t""$ac_cv_prog_gcc" 1>&6
if test $ac_cv_prog_gcc = yes; then
  GCC=yes
  if test "${CFLAGS+set}" != set; then
    echo $ac_n "checking whether ${CC-cc} accepts -g""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_prog_gcc_g'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  echo 'void f(){}' > conftest.c
if test -z "`${CC-cc} -g -c conftest.c 2>&1`"; then
  ac_cv_prog_gcc_g=yes
else
  ac_cv_prog_gcc_g=no
fi
rm -f conftest*

fi

echo "$ac_t""$ac_cv_prog_gcc_g" 1>&6
    if test $ac_cv_prog_gcc_g = yes; then
      CFLAGS="-g -O"
    else
      CFLAGS="-O"
    fi
  fi
else
  GCC=
  test "${CFLAGS+set}" = set || CFLAGS="-g"
fi

else
    CC=${CC-cc}

fi
# If we cannot run a trivial program, we must be cross compiling.
echo $ac_n "checking whether cross-compiling""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_c_cross'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  if test "$cross_compiling" = yes; then
  ac_cv_c_cross=yes
else
cat > conftest.$ac_ext <<EOF
#line 713 "configure"
#include "confdefs.h"
main(){return(0);}
EOF
{ (eval echo configure:717: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }
if test -s conftest && (./conftest; exit) 2>/dev/null; then
  ac_cv_c_cross=no
else
  ac_cv_c_cross=yes
fi
fi
rm -fr conftest*
fi

echo "$ac_t""$ac_cv_c_cross" 1>&6
cross_compiling=$ac_cv_c_cross


# set the warning flags depending on whether or not we are using gcc
if test "${GCC}" = "yes" ; then
    CFLAGS_WARNING="-Wall -Wconversion"
else
    CFLAGS_WARNING=""
fi

#------------------------------------------------------------------------------
# If we're using GCC, see if the compiler understands -pipe.  If so, use it.
# It makes compiling go faster.  (This is only a performance feature.)
#------------------------------------------------------------------------------

if test -z "$no_pipe"; then
if test -n "$GCC"; then
  echo $ac_n "checking if the compiler understands -pipe""... $ac_c" 1>&6
  OLDCC="$CC"  
  CC="$CC -pipe"
  cat > conftest.$ac_ext <<EOF
#line 749 "configure"
#include "confdefs.h"

int main() { return 0; }
int t() {

; return 0; }
EOF
if { (eval echo configure:757: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  echo "$ac_t""yes" 1>&6
else
  rm -rf conftest*
  CC="$OLDCC"
    echo "$ac_t""no" 1>&6
fi
rm -f conftest*

fi  
fi

#--------------------------------------------------------------------
#	Supply substitutes for missing POSIX library procedures, or
#	set flags so Tcl uses alternate procedures.
#--------------------------------------------------------------------

# Check if Posix compliant getcwd exists, if not we'll use getwd.
for ac_func in getcwd
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 783 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char $ac_func();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:805: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_func=HAVE_`echo $ac_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  cat >> confdefs.h <<EOF
#define $ac_tr_func 1
EOF
 
else
  echo "$ac_t""no" 1>&6
cat >> confdefs.h <<\EOF
#define USEGETWD 1
EOF

fi
done

# Nb: if getcwd uses popen and pwd(1) (like SunOS 4) we should really
# define USEGETWD even if the posix getcwd exists. Add a test ?

for ac_func in opendir strstr
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 841 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char $ac_func();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:863: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
LIBOBJS="$LIBOBJS ${ac_func}.o"
fi

done


for ac_func in strtol tmpnam waitpid
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 891 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char $ac_func();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:913: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
LIBOBJS="$LIBOBJS ${ac_func}.o"
fi

done

echo $ac_n "checking for strerror""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_strerror'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 938 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char strerror(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char strerror();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_strerror) || defined (__stub___strerror)
choke me
#else
strerror();
#endif

; return 0; }
EOF
if { (eval echo configure:960: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_strerror=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_strerror=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'strerror`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
cat >> confdefs.h <<\EOF
#define NO_STRERROR 1
EOF

fi

echo $ac_n "checking for getwd""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_getwd'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 986 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char getwd(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char getwd();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_getwd) || defined (__stub___getwd)
choke me
#else
getwd();
#endif

; return 0; }
EOF
if { (eval echo configure:1008: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_getwd=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_getwd=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'getwd`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
cat >> confdefs.h <<\EOF
#define NO_GETWD 1
EOF

fi

echo $ac_n "checking for wait3""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_wait3'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 1034 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char wait3(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char wait3();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_wait3) || defined (__stub___wait3)
choke me
#else
wait3();
#endif

; return 0; }
EOF
if { (eval echo configure:1056: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_wait3=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_wait3=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'wait3`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
cat >> confdefs.h <<\EOF
#define NO_WAIT3 1
EOF

fi

echo $ac_n "checking for uname""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_uname'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 1082 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char uname(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char uname();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_uname) || defined (__stub___uname)
choke me
#else
uname();
#endif

; return 0; }
EOF
if { (eval echo configure:1104: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_uname=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_uname=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'uname`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
cat >> confdefs.h <<\EOF
#define NO_UNAME 1
EOF

fi


#--------------------------------------------------------------------
#	On a few very rare systems, all of the libm.a stuff is
#	already in libc.a.  Set compiler flags accordingly.
#	Also, Linux requires the "ieee" library for math to work
#	right (and it must appear before "-lm").
#--------------------------------------------------------------------

echo $ac_n "checking for sin""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_sin'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 1138 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char sin(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char sin();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_sin) || defined (__stub___sin)
choke me
#else
sin();
#endif

; return 0; }
EOF
if { (eval echo configure:1160: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_sin=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_sin=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'sin`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  MATH_LIBS=""
else
  echo "$ac_t""no" 1>&6
MATH_LIBS="-lm"
fi

echo $ac_n "checking for -lieee""... $ac_c" 1>&6
ac_lib_var=`echo ieee_main | tr '.-/+' '___p'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lieee  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 1186 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
char main();

int main() { return 0; }
int t() {
main()
; return 0; }
EOF
if { (eval echo configure:1196: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -f conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  MATH_LIBS="-lieee $MATH_LIBS"
else
  echo "$ac_t""no" 1>&6
fi


#--------------------------------------------------------------------
#       On AIX systems, libbsd.a has to be linked in to support
#       non-blocking file IO.  This library has to be linked in after
#       the MATH_LIBS or it breaks the pow() function.  The way to
#       insure proper sequencing, is to add it to the tail of MATH_LIBS.
#        This library also supplies gettimeofday.
#--------------------------------------------------------------------
libbsd=no
if test "`uname -s`" = "AIX" ; then
    echo $ac_n "checking for -lbsd""... $ac_c" 1>&6
ac_lib_var=`echo bsd_gettimeofday | tr '.-/+' '___p'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lbsd  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 1232 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
char gettimeofday();

int main() { return 0; }
int t() {
gettimeofday()
; return 0; }
EOF
if { (eval echo configure:1242: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -f conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  libbsd=yes
else
  echo "$ac_t""no" 1>&6
fi

    if test $libbsd = yes; then
	MATH_LIBS="$MATH_LIBS -lbsd"
    fi
fi

#--------------------------------------------------------------------
#	Supply substitutes for missing POSIX header files.  Special
#	notes:
#	    - stdlib.h doesn't define strtol, strtoul, or
#	      strtod insome versions of SunOS
#	    - some versions of string.h don't declare procedures such
#	      as strstr
#--------------------------------------------------------------------

echo $ac_n "checking dirent.h""... $ac_c" 1>&6
cat > conftest.$ac_ext <<EOF
#line 1276 "configure"
#include "confdefs.h"
#include <sys/types.h>
#include <dirent.h>
int main() { return 0; }
int t() {

#ifndef _POSIX_SOURCE
#   ifdef __Lynx__
	/*
	 * Generate compilation error to make the test fail:  Lynx headers
	 * are only valid if really in the POSIX environment.
	 */

	missing_procedure();
#   endif
#endif
DIR *d;
struct dirent *entryPtr;
char *p;
d = opendir("foobar");
entryPtr = readdir(d);
p = entryPtr->d_name;
closedir(d);

; return 0; }
EOF
if { (eval echo configure:1303: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  tcl_ok=yes
else
  rm -rf conftest*
  tcl_ok=no
fi
rm -f conftest*

if test $tcl_ok = no; then
    cat >> confdefs.h <<\EOF
#define NO_DIRENT_H 1
EOF

fi
echo "$ac_t""$tcl_ok" 1>&6
echo $ac_n "checking how to run the C preprocessor""... $ac_c" 1>&6
# On Suns, sometimes $CPP names a directory.
if test -n "$CPP" && test -d "$CPP"; then
  CPP=
fi
if test -z "$CPP"; then
if eval "test \"`echo '$''{'ac_cv_prog_CPP'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
    # This must be in double quotes, not single quotes, because CPP may get
  # substituted into the Makefile and "${CC-cc}" will confuse make.
  CPP="${CC-cc} -E"
  # On the NeXT, cc -E runs the code through the compiler's parser,
  # not just through cpp.
  cat > conftest.$ac_ext <<EOF
#line 1334 "configure"
#include "confdefs.h"
#include <assert.h>
Syntax Error
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1340: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  :
else
  echo "$ac_err" >&5
  rm -rf conftest*
  CPP="${CC-cc} -E -traditional-cpp"
  cat > conftest.$ac_ext <<EOF
#line 1349 "configure"
#include "confdefs.h"
#include <assert.h>
Syntax Error
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1355: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  :
else
  echo "$ac_err" >&5
  rm -rf conftest*
  CPP=/lib/cpp
fi
rm -f conftest*
fi
rm -f conftest*
  ac_cv_prog_CPP="$CPP"
fi
  CPP="$ac_cv_prog_CPP"
else
  ac_cv_prog_CPP="$CPP"
fi
echo "$ac_t""$CPP" 1>&6

ac_safe=`echo "errno.h" | tr './\055' '___'`
echo $ac_n "checking for errno.h""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 1381 "configure"
#include "confdefs.h"
#include <errno.h>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1386: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
cat >> confdefs.h <<\EOF
#define NO_ERRNO_H 1
EOF

fi

ac_safe=`echo "float.h" | tr './\055' '___'`
echo $ac_n "checking for float.h""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 1415 "configure"
#include "confdefs.h"
#include <float.h>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1420: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
cat >> confdefs.h <<\EOF
#define NO_FLOAT_H 1
EOF

fi

ac_safe=`echo "values.h" | tr './\055' '___'`
echo $ac_n "checking for values.h""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 1449 "configure"
#include "confdefs.h"
#include <values.h>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1454: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
cat >> confdefs.h <<\EOF
#define NO_VALUES_H 1
EOF

fi

ac_safe=`echo "limits.h" | tr './\055' '___'`
echo $ac_n "checking for limits.h""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 1483 "configure"
#include "confdefs.h"
#include <limits.h>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1488: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
cat >> confdefs.h <<\EOF
#define NO_LIMITS_H 1
EOF

fi

ac_safe=`echo "stdlib.h" | tr './\055' '___'`
echo $ac_n "checking for stdlib.h""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 1517 "configure"
#include "confdefs.h"
#include <stdlib.h>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1522: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  tcl_ok=1
else
  echo "$ac_t""no" 1>&6
tcl_ok=0
fi

cat > conftest.$ac_ext <<EOF
#line 1543 "configure"
#include "confdefs.h"
#include <stdlib.h>
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "strtol" >/dev/null 2>&1; then
  :
else
  rm -rf conftest*
  tcl_ok=0
fi
rm -f conftest*

cat > conftest.$ac_ext <<EOF
#line 1557 "configure"
#include "confdefs.h"
#include <stdlib.h>
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "strtoul" >/dev/null 2>&1; then
  :
else
  rm -rf conftest*
  tcl_ok=0
fi
rm -f conftest*

cat > conftest.$ac_ext <<EOF
#line 1571 "configure"
#include "confdefs.h"
#include <stdlib.h>
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "strtod" >/dev/null 2>&1; then
  :
else
  rm -rf conftest*
  tcl_ok=0
fi
rm -f conftest*

if test $tcl_ok = 0; then
    cat >> confdefs.h <<\EOF
#define NO_STDLIB_H 1
EOF

fi
ac_safe=`echo "string.h" | tr './\055' '___'`
echo $ac_n "checking for string.h""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 1596 "configure"
#include "confdefs.h"
#include <string.h>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1601: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  tcl_ok=1
else
  echo "$ac_t""no" 1>&6
tcl_ok=0
fi

cat > conftest.$ac_ext <<EOF
#line 1622 "configure"
#include "confdefs.h"
#include <string.h>
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "strstr" >/dev/null 2>&1; then
  :
else
  rm -rf conftest*
  tcl_ok=0
fi
rm -f conftest*

cat > conftest.$ac_ext <<EOF
#line 1636 "configure"
#include "confdefs.h"
#include <string.h>
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "strerror" >/dev/null 2>&1; then
  :
else
  rm -rf conftest*
  tcl_ok=0
fi
rm -f conftest*

if test $tcl_ok = 0; then
    cat >> confdefs.h <<\EOF
#define NO_STRING_H 1
EOF

fi
ac_safe=`echo "sys/wait.h" | tr './\055' '___'`
echo $ac_n "checking for sys/wait.h""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 1661 "configure"
#include "confdefs.h"
#include <sys/wait.h>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1666: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
cat >> confdefs.h <<\EOF
#define NO_SYS_WAIT_H 1
EOF

fi

ac_safe=`echo "dlfcn.h" | tr './\055' '___'`
echo $ac_n "checking for dlfcn.h""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 1695 "configure"
#include "confdefs.h"
#include <dlfcn.h>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1700: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
cat >> confdefs.h <<\EOF
#define NO_DLFCN_H 1
EOF

fi

for ac_hdr in unistd.h
do
ac_safe=`echo "$ac_hdr" | tr './\055' '___'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 1731 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1736: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | tr 'abcdefghijklmnopqrstuvwxyz./\055' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ___'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done


#---------------------------------------------------------------------------
#	Determine which interface to use to talk to the serial port.
#	Note that #include lines must begin in leftmost column for
#	some compilers to recognize them as preprocessor directives.
#---------------------------------------------------------------------------

echo $ac_n "checking termios vs. termio vs. sgtty""... $ac_c" 1>&6
if test "$cross_compiling" = yes; then
  tk_ok=no
else
cat > conftest.$ac_ext <<EOF
#line 1772 "configure"
#include "confdefs.h"

#include <termios.h>

main()
{
    struct termios t;
    if (tcgetattr(0, &t) == 0) {
	cfsetospeed(&t, 0);
	t.c_cflag |= PARENB | PARODD | CSIZE | CSTOPB;
	return 0;
    }
    return 1;
}
EOF
{ (eval echo configure:1788: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }
if test -s conftest && (./conftest; exit) 2>/dev/null; then
  tk_ok=termios
else
  tk_ok=no
fi
fi
rm -fr conftest*
if test $tk_ok = termios; then
    cat >> confdefs.h <<\EOF
#define USE_TERMIOS 1
EOF

else
if test "$cross_compiling" = yes; then
  tk_ok=no
else
cat > conftest.$ac_ext <<EOF
#line 1806 "configure"
#include "confdefs.h"

#include <termio.h>

main()
{
    struct termio t;
    if (ioctl(0, TCGETA, &t) == 0) {
	t.c_cflag |= CBAUD | PARENB | PARODD | CSIZE | CSTOPB;
	return 0;
    }
    return 1;
}
EOF
{ (eval echo configure:1821: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }
if test -s conftest && (./conftest; exit) 2>/dev/null; then
  tk_ok=termio
else
  tk_ok=no
fi
fi
rm -fr conftest*
if test $tk_ok = termio; then
    cat >> confdefs.h <<\EOF
#define USE_TERMIO 1
EOF

else
if test "$cross_compiling" = yes; then
  tk_ok=none
else
cat > conftest.$ac_ext <<EOF
#line 1839 "configure"
#include "confdefs.h"

#include <sgtty.h>

main()
{
    struct sgttyb t;
    if (ioctl(0, TIOCGETP, &t) == 0) {
	t.sg_ospeed = 0;
	t.sg_flags |= ODDP | EVENP | RAW;
	return 0;
    }
    return 1;
}
EOF
{ (eval echo configure:1855: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }
if test -s conftest && (./conftest; exit) 2>/dev/null; then
  tk_ok=sgtty
else
  tk_ok=none
fi
fi
rm -fr conftest*
if test $tk_ok = sgtty; then
    cat >> confdefs.h <<\EOF
#define USE_SGTTY 1
EOF

fi
fi
fi
echo "$ac_t""$tk_ok" 1>&6

#--------------------------------------------------------------------
#	Include sys/select.h if it exists and if it supplies things
#	that appear to be useful and aren't already in sys/types.h.
#	This appears to be true only on the RS/6000 under AIX.  Some
#	systems like OSF/1 have a sys/select.h that's of no use, and
#	other systems like SCO UNIX have a sys/select.h that's
#	pernicious.  If "fd_set" isn't defined anywhere then set a
#	special flag.
#--------------------------------------------------------------------

echo $ac_n "checking fd_set and sys/select""... $ac_c" 1>&6
cat > conftest.$ac_ext <<EOF
#line 1885 "configure"
#include "confdefs.h"
#include <sys/types.h>
int main() { return 0; }
int t() {
fd_set readMask, writeMask;
; return 0; }
EOF
if { (eval echo configure:1893: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  tk_ok=yes
else
  rm -rf conftest*
  tk_ok=no
fi
rm -f conftest*

if test $tk_ok = no; then
    cat > conftest.$ac_ext <<EOF
#line 1904 "configure"
#include "confdefs.h"
#include <sys/select.h>
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "fd_mask" >/dev/null 2>&1; then
  rm -rf conftest*
  tk_ok=yes
fi
rm -f conftest*

    if test $tk_ok = yes; then
	cat >> confdefs.h <<\EOF
#define HAVE_SYS_SELECT_H 1
EOF

    fi
fi
echo "$ac_t""$tk_ok" 1>&6
if test $tk_ok = no; then
    cat >> confdefs.h <<\EOF
#define NO_FD_SET 1
EOF

fi

#------------------------------------------------------------------------------
#       Find out all about time handling differences.
#------------------------------------------------------------------------------

for ac_hdr in sys/time.h
do
ac_safe=`echo "$ac_hdr" | tr './\055' '___'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 1942 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1947: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | tr 'abcdefghijklmnopqrstuvwxyz./\055' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ___'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

echo $ac_n "checking whether time.h and sys/time.h may both be included""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_time'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 1976 "configure"
#include "confdefs.h"
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
int main() { return 0; }
int t() {
struct tm *tp;
; return 0; }
EOF
if { (eval echo configure:1986: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  ac_cv_header_time=yes
else
  rm -rf conftest*
  ac_cv_header_time=no
fi
rm -f conftest*

fi

echo "$ac_t""$ac_cv_header_time" 1>&6
if test $ac_cv_header_time = yes; then
  cat >> confdefs.h <<\EOF
#define TIME_WITH_SYS_TIME 1
EOF

fi

echo $ac_n "checking whether struct tm is in sys/time.h or time.h""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_struct_tm'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2010 "configure"
#include "confdefs.h"
#include <sys/types.h>
#include <time.h>
int main() { return 0; }
int t() {
struct tm *tp; tp->tm_sec;
; return 0; }
EOF
if { (eval echo configure:2019: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  ac_cv_struct_tm=time.h
else
  rm -rf conftest*
  ac_cv_struct_tm=sys/time.h
fi
rm -f conftest*

fi

echo "$ac_t""$ac_cv_struct_tm" 1>&6
if test $ac_cv_struct_tm = sys/time.h; then
  cat >> confdefs.h <<\EOF
#define TM_IN_SYS_TIME 1
EOF

fi

echo $ac_n "checking for tm_zone in struct tm""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_struct_tm_zone'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2043 "configure"
#include "confdefs.h"
#include <sys/types.h>
#include <$ac_cv_struct_tm>
int main() { return 0; }
int t() {
struct tm tm; tm.tm_zone;
; return 0; }
EOF
if { (eval echo configure:2052: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  ac_cv_struct_tm_zone=yes
else
  rm -rf conftest*
  ac_cv_struct_tm_zone=no
fi
rm -f conftest*

fi

echo "$ac_t""$ac_cv_struct_tm_zone" 1>&6
if test "$ac_cv_struct_tm_zone" = yes; then
  cat >> confdefs.h <<\EOF
#define HAVE_TM_ZONE 1
EOF

else
  echo $ac_n "checking for tzname""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_var_tzname'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2075 "configure"
#include "confdefs.h"
#include <time.h>
#ifndef tzname /* For SGI.  */
extern char *tzname[]; /* RS6000 and others reject char **tzname.  */
#endif
int main() { return 0; }
int t() {
atoi(*tzname);
; return 0; }
EOF
if { (eval echo configure:2086: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  ac_cv_var_tzname=yes
else
  rm -rf conftest*
  ac_cv_var_tzname=no
fi
rm -f conftest*

fi

echo "$ac_t""$ac_cv_var_tzname" 1>&6
  if test $ac_cv_var_tzname = yes; then
    cat >> confdefs.h <<\EOF
#define HAVE_TZNAME 1
EOF

  fi
fi


echo $ac_n "checking tm_tzadj in struct tm""... $ac_c" 1>&6
cat > conftest.$ac_ext <<EOF
#line 2109 "configure"
#include "confdefs.h"
#include <time.h>
int main() { return 0; }
int t() {
struct tm tm; tm.tm_tzadj;
; return 0; }
EOF
if { (eval echo configure:2117: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  cat >> confdefs.h <<\EOF
#define HAVE_TM_TZADJ 1
EOF

         echo "$ac_t""yes" 1>&6
else
  rm -rf conftest*
  echo "$ac_t""no" 1>&6
fi
rm -f conftest*


echo $ac_n "checking tm_gmtoff in struct tm""... $ac_c" 1>&6
cat > conftest.$ac_ext <<EOF
#line 2133 "configure"
#include "confdefs.h"
#include <time.h>
int main() { return 0; }
int t() {
struct tm tm; tm.tm_gmtoff;
; return 0; }
EOF
if { (eval echo configure:2141: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  cat >> confdefs.h <<\EOF
#define HAVE_TM_GMTOFF 1
EOF

         echo "$ac_t""yes" 1>&6
else
  rm -rf conftest*
  echo "$ac_t""no" 1>&6
fi
rm -f conftest*


#
# Its important to include time.h in this check, as some systems (like convex)
# have timezone functions, etc.
#
have_timezone=no
echo $ac_n "checking long timezone variable""... $ac_c" 1>&6
cat > conftest.$ac_ext <<EOF
#line 2162 "configure"
#include "confdefs.h"
#include <time.h>
int main() { return 0; }
int t() {
extern long timezone;
         timezone += 1;
         exit (0);
; return 0; }
EOF
if { (eval echo configure:2172: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  have_timezone=yes
	 cat >> confdefs.h <<\EOF
#define HAVE_TIMEZONE_VAR 1
EOF

         echo "$ac_t""yes" 1>&6
else
  rm -rf conftest*
  echo "$ac_t""no" 1>&6
fi
rm -f conftest*


#
# On some systems (eg IRIX 6.2), timezone is a time_t and not a long.
#
if test "$have_timezone" = no; then
   echo $ac_n "checking time_t timezone variable""... $ac_c" 1>&6
   cat > conftest.$ac_ext <<EOF
#line 2193 "configure"
#include "confdefs.h"
#include <time.h>
int main() { return 0; }
int t() {
extern time_t timezone;
         timezone += 1;
         exit (0);
; return 0; }
EOF
if { (eval echo configure:2203: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  cat >> confdefs.h <<\EOF
#define HAVE_TIMEZONE_VAR 1
EOF

         echo "$ac_t""yes" 1>&6
else
  rm -rf conftest*
  echo "$ac_t""no" 1>&6
fi
rm -f conftest*

fi

#
# AIX does not have a timezone field in struct tm. When the AIX bsd
# library is used, the timezone global and the gettimeofday methods are
# to be avoided for timezone deduction instead, we deduce the timezone
# by comparing the localtime result on a known GMT value.
#
if test $libbsd = yes; then
    cat >> confdefs.h <<\EOF
#define USE_DELTA_FOR_TZ 1
EOF

fi

#--------------------------------------------------------------------
#	Some systems (e.g., IRIX 4.0.5) lack the st_blksize field
#	in struct stat.
#--------------------------------------------------------------------
echo $ac_n "checking for st_blksize in struct stat""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_struct_st_blksize'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2240 "configure"
#include "confdefs.h"
#include <sys/types.h>
#include <sys/stat.h>
int main() { return 0; }
int t() {
struct stat s; s.st_blksize;
; return 0; }
EOF
if { (eval echo configure:2249: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  ac_cv_struct_st_blksize=yes
else
  rm -rf conftest*
  ac_cv_struct_st_blksize=no
fi
rm -f conftest*

fi

echo "$ac_t""$ac_cv_struct_st_blksize" 1>&6
if test $ac_cv_struct_st_blksize = yes; then
  cat >> confdefs.h <<\EOF
#define HAVE_ST_BLKSIZE 1
EOF

fi


#--------------------------------------------------------------------
#	On some systems strstr is broken: it returns a pointer even
#	even if the original string is empty.
#--------------------------------------------------------------------

echo $ac_n "checking proper strstr implementation""... $ac_c" 1>&6
if test "$cross_compiling" = yes; then
  tcl_ok=no
else
cat > conftest.$ac_ext <<EOF
#line 2279 "configure"
#include "confdefs.h"

extern int strstr();
int main()
{
    exit(strstr("\0test", "test") ? 1 : 0);
}

EOF
{ (eval echo configure:2289: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }
if test -s conftest && (./conftest; exit) 2>/dev/null; then
  tcl_ok=yes
else
  tcl_ok=no
fi
fi
rm -fr conftest*
if test $tcl_ok = yes; then
    echo "$ac_t""yes" 1>&6
else
    echo "$ac_t""broken, using substitute" 1>&6
    LIBOBJS="$LIBOBJS strstr.o"
fi

#--------------------------------------------------------------------
#	Check for strtoul function.  This is tricky because under some
#	versions of AIX strtoul returns an incorrect terminator
#	pointer for the string "0".
#--------------------------------------------------------------------

echo $ac_n "checking for strtoul""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_strtoul'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2315 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char strtoul(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char strtoul();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_strtoul) || defined (__stub___strtoul)
choke me
#else
strtoul();
#endif

; return 0; }
EOF
if { (eval echo configure:2337: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_strtoul=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_strtoul=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'strtoul`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  tcl_ok=1
else
  echo "$ac_t""no" 1>&6
tcl_ok=0
fi

if test "$cross_compiling" = yes; then
  tcl_ok=0
else
cat > conftest.$ac_ext <<EOF
#line 2359 "configure"
#include "confdefs.h"

extern int strtoul();
int main()
{
    char *string = "0";
    char *term;
    int value;
    value = strtoul(string, &term, 0);
    if ((value != 0) || (term != (string+1))) {
        exit(1);
    }
    exit(0);
}
EOF
{ (eval echo configure:2375: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }
if test -s conftest && (./conftest; exit) 2>/dev/null; then
  :
else
  tcl_ok=0
fi
fi
rm -fr conftest*
if test "$tcl_ok" = 0; then
    test -n "$verbose" && echo "	Adding strtoul.o."
    LIBOBJS="$LIBOBJS strtoul.o"
fi

#--------------------------------------------------------------------
#	Check for the strtod function.  This is tricky because in some
#	versions of Linux strtod mis-parses strings starting with "+".
#--------------------------------------------------------------------

echo $ac_n "checking for strtod""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_strtod'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2398 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char strtod(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char strtod();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_strtod) || defined (__stub___strtod)
choke me
#else
strtod();
#endif

; return 0; }
EOF
if { (eval echo configure:2420: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_strtod=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_strtod=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'strtod`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  tcl_ok=1
else
  echo "$ac_t""no" 1>&6
tcl_ok=0
fi

if test "$cross_compiling" = yes; then
  tcl_ok=0
else
cat > conftest.$ac_ext <<EOF
#line 2442 "configure"
#include "confdefs.h"

extern double strtod();
int main()
{
    char *string = " +69";
    char *term;
    double value;
    value = strtod(string, &term);
    if ((value != 69) || (term != (string+4))) {
	exit(1);
    }
    exit(0);
}
EOF
{ (eval echo configure:2458: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }
if test -s conftest && (./conftest; exit) 2>/dev/null; then
  :
else
  tcl_ok=0
fi
fi
rm -fr conftest*
if test "$tcl_ok" = 0; then
    test -n "$verbose" && echo "	Adding strtod.o."
    LIBOBJS="$LIBOBJS strtod.o"
fi

#--------------------------------------------------------------------
#	Under Solaris 2.4, strtod returns the wrong value for the
#	terminating character under some conditions.  Check for this
#	and if the problem exists use a substitute procedure
#	"fixstrtod" that corrects the error.
#--------------------------------------------------------------------

echo $ac_n "checking for strtod""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_strtod'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2483 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char strtod(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char strtod();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_strtod) || defined (__stub___strtod)
choke me
#else
strtod();
#endif

; return 0; }
EOF
if { (eval echo configure:2505: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_strtod=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_strtod=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'strtod`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  tcl_strtod=1
else
  echo "$ac_t""no" 1>&6
tcl_strtod=0
fi

if test "$tcl_strtod" = 1; then
    echo $ac_n "checking for Solaris strtod bug""... $ac_c" 1>&6
    if test "$cross_compiling" = yes; then
  tcl_ok=0
else
cat > conftest.$ac_ext <<EOF
#line 2529 "configure"
#include "confdefs.h"

extern double strtod();
int main()
{
    char *string = "NaN";
    char *term;
    strtod(string, &term);
    if ((term != string) && (term[-1] == 0)) {
	exit(1);
    }
    exit(0);
}
EOF
{ (eval echo configure:2544: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }
if test -s conftest && (./conftest; exit) 2>/dev/null; then
  tcl_ok=1
else
  tcl_ok=0
fi
fi
rm -fr conftest*
    if test $tcl_ok = 1; then
	echo "$ac_t""ok" 1>&6
    else
	echo "$ac_t""buggy" 1>&6
	LIBOBJS="$LIBOBJS fixstrtod.o"
	cat >> confdefs.h <<\EOF
#define strtod fixstrtod
EOF

    fi
fi

#--------------------------------------------------------------------
#	Check for various typedefs and provide substitutes if
#	they don't exist.
#--------------------------------------------------------------------

echo $ac_n "checking for ANSI C header files""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_stdc'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2574 "configure"
#include "confdefs.h"
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <float.h>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:2582: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  ac_cv_header_stdc=yes
else
  echo "$ac_err" >&5
  rm -rf conftest*
  ac_cv_header_stdc=no
fi
rm -f conftest*

if test $ac_cv_header_stdc = yes; then
  # SunOS 4.x string.h does not declare mem*, contrary to ANSI.
cat > conftest.$ac_ext <<EOF
#line 2597 "configure"
#include "confdefs.h"
#include <string.h>
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "memchr" >/dev/null 2>&1; then
  :
else
  rm -rf conftest*
  ac_cv_header_stdc=no
fi
rm -f conftest*

fi

if test $ac_cv_header_stdc = yes; then
  # ISC 2.0.2 stdlib.h does not declare free, contrary to ANSI.
cat > conftest.$ac_ext <<EOF
#line 2615 "configure"
#include "confdefs.h"
#include <stdlib.h>
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "free" >/dev/null 2>&1; then
  :
else
  rm -rf conftest*
  ac_cv_header_stdc=no
fi
rm -f conftest*

fi

if test $ac_cv_header_stdc = yes; then
  # /bin/cc in Irix-4.0.5 gets non-ANSI ctype macros unless using -ansi.
if test "$cross_compiling" = yes; then
  :
else
cat > conftest.$ac_ext <<EOF
#line 2636 "configure"
#include "confdefs.h"
#include <ctype.h>
#define ISLOWER(c) ('a' <= (c) && (c) <= 'z')
#define TOUPPER(c) (ISLOWER(c) ? 'A' + ((c) - 'a') : (c))
#define XOR(e, f) (((e) && !(f)) || (!(e) && (f)))
int main () { int i; for (i = 0; i < 256; i++)
if (XOR (islower (i), ISLOWER (i)) || toupper (i) != TOUPPER (i)) exit(2);
exit (0); }

EOF
{ (eval echo configure:2647: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }
if test -s conftest && (./conftest; exit) 2>/dev/null; then
  :
else
  ac_cv_header_stdc=no
fi
fi
rm -fr conftest*
fi
fi

echo "$ac_t""$ac_cv_header_stdc" 1>&6
if test $ac_cv_header_stdc = yes; then
  cat >> confdefs.h <<\EOF
#define STDC_HEADERS 1
EOF

fi

echo $ac_n "checking for mode_t""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_type_mode_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2671 "configure"
#include "confdefs.h"
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#endif
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "mode_t" >/dev/null 2>&1; then
  rm -rf conftest*
  ac_cv_type_mode_t=yes
else
  rm -rf conftest*
  ac_cv_type_mode_t=no
fi
rm -f conftest*

fi
echo "$ac_t""$ac_cv_type_mode_t" 1>&6
if test $ac_cv_type_mode_t = no; then
  cat >> confdefs.h <<\EOF
#define mode_t int
EOF

fi

echo $ac_n "checking for pid_t""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_type_pid_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2702 "configure"
#include "confdefs.h"
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#endif
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "pid_t" >/dev/null 2>&1; then
  rm -rf conftest*
  ac_cv_type_pid_t=yes
else
  rm -rf conftest*
  ac_cv_type_pid_t=no
fi
rm -f conftest*

fi
echo "$ac_t""$ac_cv_type_pid_t" 1>&6
if test $ac_cv_type_pid_t = no; then
  cat >> confdefs.h <<\EOF
#define pid_t int
EOF

fi

echo $ac_n "checking for size_t""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_type_size_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2733 "configure"
#include "confdefs.h"
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#endif
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "size_t" >/dev/null 2>&1; then
  rm -rf conftest*
  ac_cv_type_size_t=yes
else
  rm -rf conftest*
  ac_cv_type_size_t=no
fi
rm -f conftest*

fi
echo "$ac_t""$ac_cv_type_size_t" 1>&6
if test $ac_cv_type_size_t = no; then
  cat >> confdefs.h <<\EOF
#define size_t unsigned
EOF

fi

echo $ac_n "checking for uid_t in sys/types.h""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_type_uid_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2764 "configure"
#include "confdefs.h"
#include <sys/types.h>
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "uid_t" >/dev/null 2>&1; then
  rm -rf conftest*
  ac_cv_type_uid_t=yes
else
  rm -rf conftest*
  ac_cv_type_uid_t=no
fi
rm -f conftest*

fi

echo "$ac_t""$ac_cv_type_uid_t" 1>&6
if test $ac_cv_type_uid_t = no; then
  cat >> confdefs.h <<\EOF
#define uid_t int
EOF

  cat >> confdefs.h <<\EOF
#define gid_t int
EOF

fi


#--------------------------------------------------------------------
#	If a system doesn't have an opendir function (man, that's old!)
#	then we have to supply a different version of dirent.h which
#	is compatible with the substitute version of opendir that's
#	provided.  This version only works with V7-style directories.
#--------------------------------------------------------------------

echo $ac_n "checking for opendir""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_opendir'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2805 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char opendir(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char opendir();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_opendir) || defined (__stub___opendir)
choke me
#else
opendir();
#endif

; return 0; }
EOF
if { (eval echo configure:2827: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_opendir=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_opendir=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'opendir`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
cat >> confdefs.h <<\EOF
#define USE_DIRENT2_H 1
EOF

fi


#--------------------------------------------------------------------
#	The check below checks whether <sys/wait.h> defines the type
#	"union wait" correctly.  It's needed because of weirdness in
#	HP-UX where "union wait" is defined in both the BSD and SYS-V
#	environments.  Checking the usability of WIFEXITED seems to do
#	the trick.
#--------------------------------------------------------------------

echo $ac_n "checking union wait""... $ac_c" 1>&6
cat > conftest.$ac_ext <<EOF
#line 2859 "configure"
#include "confdefs.h"
#include <sys/types.h> 
#include <sys/wait.h>
int main() { return 0; }
int t() {

union wait x;
WIFEXITED(x);		/* Generates compiler error if WIFEXITED
			 * uses an int. */

; return 0; }
EOF
if { (eval echo configure:2872: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  tcl_ok=yes
else
  rm -rf conftest*
  tcl_ok=no
fi
rm -f conftest*

echo "$ac_t""$tcl_ok" 1>&6
if test $tcl_ok = no; then
    cat >> confdefs.h <<\EOF
#define NO_UNION_WAIT 1
EOF

fi

#--------------------------------------------------------------------
#	Check to see whether the system supports the matherr function
#	and its associated type "struct exception".
#--------------------------------------------------------------------

echo $ac_n "checking matherr support""... $ac_c" 1>&6
cat > conftest.$ac_ext <<EOF
#line 2896 "configure"
#include "confdefs.h"
#include <math.h>
int main() { return 0; }
int t() {

struct exception x;
x.type = DOMAIN;
x.type = SING;

; return 0; }
EOF
if { (eval echo configure:2908: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  tcl_ok=yes
else
  rm -rf conftest*
  tcl_ok=no
fi
rm -f conftest*

echo "$ac_t""$tcl_ok" 1>&6
if test $tcl_ok = yes; then
    cat >> confdefs.h <<\EOF
#define NEED_MATHERR 1
EOF

fi

#--------------------------------------------------------------------
#	Check to see whether the system provides a vfork kernel call.
#	If not, then use fork instead.  Also, check for a problem with
#	vforks and signals that can cause core dumps if a vforked child
#	resets a signal handler.  If the problem exists, then use fork
#	instead of vfork.
#--------------------------------------------------------------------

echo $ac_n "checking return type of signal handlers""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_type_signal'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2938 "configure"
#include "confdefs.h"
#include <sys/types.h>
#include <signal.h>
#ifdef signal
#undef signal
#endif
#ifdef __cplusplus
extern "C" void (*signal (int, void (*)(int)))(int);
#else
void (*signal ()) ();
#endif

int main() { return 0; }
int t() {
int i;
; return 0; }
EOF
if { (eval echo configure:2956: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  ac_cv_type_signal=void
else
  rm -rf conftest*
  ac_cv_type_signal=int
fi
rm -f conftest*

fi

echo "$ac_t""$ac_cv_type_signal" 1>&6
cat >> confdefs.h <<EOF
#define RETSIGTYPE $ac_cv_type_signal
EOF


echo $ac_n "checking for vfork""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_vfork'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2978 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char vfork(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char vfork();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_vfork) || defined (__stub___vfork)
choke me
#else
vfork();
#endif

; return 0; }
EOF
if { (eval echo configure:3000: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_vfork=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_vfork=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'vfork`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  tcl_ok=1
else
  echo "$ac_t""no" 1>&6
tcl_ok=0
fi

if test "$tcl_ok" = 1; then
    echo $ac_n "checking vfork/signal bug""... $ac_c" 1>&6;
    if test "$cross_compiling" = yes; then
  tcl_ok=0
else
cat > conftest.$ac_ext <<EOF
#line 3024 "configure"
#include "confdefs.h"

#include <stdio.h>
#include <signal.h>
#include <sys/wait.h>
int gotSignal = 0;
sigProc(sig)
    int sig;
{
    gotSignal = 1;
}
main()
{
    int pid, sts;
    (void) signal(SIGCHLD, sigProc);
    pid = vfork();
    if (pid <  0) {
	exit(1);
    } else if (pid == 0) {
	(void) signal(SIGCHLD, SIG_DFL);
	_exit(0);
    } else {
	(void) wait(&sts);
    }
    exit((gotSignal) ? 0 : 1);
}
EOF
{ (eval echo configure:3052: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }
if test -s conftest && (./conftest; exit) 2>/dev/null; then
  tcl_ok=1
else
  tcl_ok=0
fi
fi
rm -fr conftest*
    if test "$tcl_ok" = 1; then
	echo "$ac_t""ok" 1>&6
    else
	echo "$ac_t""buggy, using fork instead" 1>&6
    fi
fi
rm -f core
if test "$tcl_ok" = 0; then
    cat >> confdefs.h <<\EOF
#define vfork fork
EOF

fi

#--------------------------------------------------------------------
#	Check whether there is an strncasecmp function on this system.
#	This is a bit tricky because under SCO it's in -lsocket and
#	under Sequent Dynix it's in -linet.
#--------------------------------------------------------------------

echo $ac_n "checking for strncasecmp""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_strncasecmp'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 3085 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char strncasecmp(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char strncasecmp();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_strncasecmp) || defined (__stub___strncasecmp)
choke me
#else
strncasecmp();
#endif

; return 0; }
EOF
if { (eval echo configure:3107: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_strncasecmp=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_strncasecmp=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'strncasecmp`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  tcl_ok=1
else
  echo "$ac_t""no" 1>&6
tcl_ok=0
fi

if test "$tcl_ok" = 0; then
    echo $ac_n "checking for -lsocket""... $ac_c" 1>&6
ac_lib_var=`echo socket_strncasecmp | tr '.-/+' '___p'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lsocket  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 3134 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
char strncasecmp();

int main() { return 0; }
int t() {
strncasecmp()
; return 0; }
EOF
if { (eval echo configure:3144: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -f conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  tcl_ok=1
else
  echo "$ac_t""no" 1>&6
tcl_ok=0
fi

fi
if test "$tcl_ok" = 0; then
    echo $ac_n "checking for -linet""... $ac_c" 1>&6
ac_lib_var=`echo inet_strncasecmp | tr '.-/+' '___p'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-linet  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 3173 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
char strncasecmp();

int main() { return 0; }
int t() {
strncasecmp()
; return 0; }
EOF
if { (eval echo configure:3183: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -f conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  tcl_ok=1
else
  echo "$ac_t""no" 1>&6
tcl_ok=0
fi

fi
if test "$tcl_ok" = 0; then
    LIBOBJS="$LIBOBJS strncasecmp.o"
fi

#--------------------------------------------------------------------
#	The code below deals with several issues related to gettimeofday:
#	1. Some systems don't provide a gettimeofday function at all
#	   (set NO_GETTOD if this is the case).
#	2. SGI systems don't use the BSD form of the gettimeofday function,
#	   but they have a BSDgettimeofday function that can be used instead.
#	3. See if gettimeofday is declared in the <sys/time.h> header file.
#	   if not, set the GETTOD_NOT_DECLARED flag so that tclPort.h can
#	   declare it.
#--------------------------------------------------------------------

echo $ac_n "checking for BSDgettimeofday""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_BSDgettimeofday'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 3223 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char BSDgettimeofday(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char BSDgettimeofday();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_BSDgettimeofday) || defined (__stub___BSDgettimeofday)
choke me
#else
BSDgettimeofday();
#endif

; return 0; }
EOF
if { (eval echo configure:3245: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_BSDgettimeofday=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_BSDgettimeofday=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'BSDgettimeofday`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  cat >> confdefs.h <<\EOF
#define HAVE_BSDGETTIMEOFDAY 1
EOF

else
  echo "$ac_t""no" 1>&6
echo $ac_n "checking for gettimeofday""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_gettimeofday'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 3268 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char gettimeofday(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char gettimeofday();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_gettimeofday) || defined (__stub___gettimeofday)
choke me
#else
gettimeofday();
#endif

; return 0; }
EOF
if { (eval echo configure:3290: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_gettimeofday=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_gettimeofday=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'gettimeofday`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
cat >> confdefs.h <<\EOF
#define NO_GETTOD 1
EOF

fi

fi

echo $ac_n "checking for gettimeofday declaration""... $ac_c" 1>&6
cat > conftest.$ac_ext <<EOF
#line 3315 "configure"
#include "confdefs.h"
#include <sys/time.h>
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "gettimeofday" >/dev/null 2>&1; then
  rm -rf conftest*
  echo "$ac_t""present" 1>&6
else
  rm -rf conftest*
  
    echo "$ac_t""missing" 1>&6
    cat >> confdefs.h <<\EOF
#define GETTOD_NOT_DECLARED 1
EOF


fi
rm -f conftest*


#--------------------------------------------------------------------
#	Interactive UNIX requires -linet instead of -lsocket, plus it
#	needs net/errno.h to define the socket-related error codes.
#--------------------------------------------------------------------

echo $ac_n "checking for -linet""... $ac_c" 1>&6
ac_lib_var=`echo inet_main | tr '.-/+' '___p'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-linet  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 3349 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
char main();

int main() { return 0; }
int t() {
main()
; return 0; }
EOF
if { (eval echo configure:3359: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -f conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  LIBS="$LIBS -linet"
else
  echo "$ac_t""no" 1>&6
fi

ac_safe=`echo "net/errno.h" | tr './\055' '___'`
echo $ac_n "checking for net/errno.h""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 3383 "configure"
#include "confdefs.h"
#include <net/errno.h>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:3388: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  cat >> confdefs.h <<\EOF
#define HAVE_NET_ERRNO_H 1
EOF

else
  echo "$ac_t""no" 1>&6
fi


#--------------------------------------------------------------------
#	The following code checks to see whether it is possible to get
#	signed chars on this platform.  This is needed in order to
#	properly generate sign-extended ints from character values.
#--------------------------------------------------------------------

echo $ac_n "checking whether char is unsigned""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_c_char_unsigned'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  if test "$GCC" = yes; then
  # GCC predefines this symbol on systems where it applies.
cat > conftest.$ac_ext <<EOF
#line 3424 "configure"
#include "confdefs.h"
#ifdef __CHAR_UNSIGNED__
  yes
#endif

EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "yes" >/dev/null 2>&1; then
  rm -rf conftest*
  ac_cv_c_char_unsigned=yes
else
  rm -rf conftest*
  ac_cv_c_char_unsigned=no
fi
rm -f conftest*

else
if test "$cross_compiling" = yes; then
    { echo "configure: error: can not run test program while cross compiling" 1>&2; exit 1; }
else
cat > conftest.$ac_ext <<EOF
#line 3446 "configure"
#include "confdefs.h"
/* volatile prevents gcc2 from optimizing the test away on sparcs.  */
#if !defined(__STDC__) || __STDC__ != 1
#define volatile
#endif
main() {
  volatile char c = 255; exit(c < 0);
}
EOF
{ (eval echo configure:3456: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }
if test -s conftest && (./conftest; exit) 2>/dev/null; then
  ac_cv_c_char_unsigned=yes
else
  ac_cv_c_char_unsigned=no
fi
fi
rm -fr conftest*
fi
fi

echo "$ac_t""$ac_cv_c_char_unsigned" 1>&6
if test $ac_cv_c_char_unsigned = yes && test "$GCC" != yes; then
  cat >> confdefs.h <<\EOF
#define __CHAR_UNSIGNED__ 1
EOF

fi

echo $ac_n "checking signed char declarations""... $ac_c" 1>&6
cat > conftest.$ac_ext <<EOF
#line 3477 "configure"
#include "confdefs.h"

int main() { return 0; }
int t() {

signed char *p;
p = 0;

; return 0; }
EOF
if { (eval echo configure:3488: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  tcl_ok=yes
else
  rm -rf conftest*
  tcl_ok=no
fi
rm -f conftest*

echo "$ac_t""$tcl_ok" 1>&6
if test $tcl_ok = yes; then
    cat >> confdefs.h <<\EOF
#define HAVE_SIGNED_CHAR 1
EOF

fi

#--------------------------------------------------------------------
#	Check for the existence of the -lsocket and -lnsl libraries.
#	The order here is important, so that they end up in the right
#	order in the command line generated by make.  Here are some
#	special considerations:
#	1. Use "connect" and "accept" to check for -lsocket, and
#	   "gethostbyname" to check for -lnsl.
#	2. Use each function name only once:  can't redo a check because
#	   autoconf caches the results of the last check and won't redo it.
#	3. Use -lnsl and -lsocket only if they supply procedures that
#	   aren't already present in the normal libraries.  This is because
#	   IRIX 5.2 has libraries, but they aren't needed and they're
#	   bogus:  they goof up name resolution if used.
#	4. On some SVR4 systems, can't use -lsocket without -lnsl too.
#	   To get around this problem, check for both libraries together
#	   if -lsocket doesn't work by itself.
#--------------------------------------------------------------------

tcl_checkBoth=0
echo $ac_n "checking for connect""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_connect'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 3529 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char connect(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char connect();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_connect) || defined (__stub___connect)
choke me
#else
connect();
#endif

; return 0; }
EOF
if { (eval echo configure:3551: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_connect=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_connect=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'connect`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  tcl_checkSocket=0
else
  echo "$ac_t""no" 1>&6
tcl_checkSocket=1
fi

if test "$tcl_checkSocket" = 1; then
    echo $ac_n "checking for -lsocket""... $ac_c" 1>&6
ac_lib_var=`echo socket_main | tr '.-/+' '___p'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lsocket  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 3578 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
char main();

int main() { return 0; }
int t() {
main()
; return 0; }
EOF
if { (eval echo configure:3588: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -f conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  LIBS="$LIBS -lsocket"
else
  echo "$ac_t""no" 1>&6
tcl_checkBoth=1
fi

fi
if test "$tcl_checkBoth" = 1; then
    tk_oldLibs=$LIBS
    LIBS="$LIBS -lsocket -lnsl"
    echo $ac_n "checking for accept""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_accept'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 3616 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char accept(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char accept();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_accept) || defined (__stub___accept)
choke me
#else
accept();
#endif

; return 0; }
EOF
if { (eval echo configure:3638: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_accept=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_accept=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'accept`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  tcl_checkNsl=0
else
  echo "$ac_t""no" 1>&6
LIBS=$tk_oldLibs
fi

fi
echo $ac_n "checking for gethostbyname""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_func_gethostbyname'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 3662 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char gethostbyname(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
char gethostbyname();

int main() { return 0; }
int t() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_gethostbyname) || defined (__stub___gethostbyname)
choke me
#else
gethostbyname();
#endif

; return 0; }
EOF
if { (eval echo configure:3684: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_func_gethostbyname=yes"
else
  rm -rf conftest*
  eval "ac_cv_func_gethostbyname=no"
fi
rm -f conftest*

fi
if eval "test \"`echo '$ac_cv_func_'gethostbyname`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  :
else
  echo "$ac_t""no" 1>&6
echo $ac_n "checking for -lnsl""... $ac_c" 1>&6
ac_lib_var=`echo nsl_main | tr '.-/+' '___p'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lnsl  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 3707 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
char main();

int main() { return 0; }
int t() {
main()
; return 0; }
EOF
if { (eval echo configure:3717: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -f conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  LIBS="$LIBS -lnsl"
else
  echo "$ac_t""no" 1>&6
fi

fi


#--------------------------------------------------------------------
#	The statements below define a collection of symbols related to
#	dynamic loading and shared libraries:
#
#	DL_OBJS -	Name of the object file that implements dynamic
#			loading for Tcl on this system.
#	DL_LIBS -	Library file(s) to include in tclsh and other base
#			applications in order for the "load" command to work.
#	LD_FLAGS -	Flags to pass to the compiler when linking object
#			files into an executable application binary such
#			as tclsh.
#	LD_SEARCH_FLAGS-Flags to pass to ld, such as "-R /usr/local/tcl/lib",
#			that tell the run-time dynamic linker where to look
#			for shared libraries such as libtcl.so.  Depends on
#			the variable LIB_RUNTIME_DIR in the Makefile.
#	MAKE_LIB -	Command to execute to build the Tcl library;
#			differs depending on whether or not Tcl is being
#			compiled as a shared library.
#	SHLIB_CFLAGS -	Flags to pass to cc when compiling the components
#			of a shared library (may request position-independent
#			code, among other things).
#	SHLIB_LD -	Base command to use for combining object files
#			into a shared library.
#	SHLIB_LD_LIBS -	Dependent libraries for the linker to scan when
#			creating shared libraries.  This symbol typically
#			goes at the end of the "ld" commands that build
#			shared libraries. The value of the symbol is
#			"${LIBS}" if all of the dependent libraries should
#			be specified when creating a shared library.  If
#			dependent libraries should not be specified (as on
#			SunOS 4.x, where they cause the link to fail, or in
#			general if Tcl and Tk aren't themselves shared
#			libraries), then this symbol has an empty string
#			as its value.
#	SHLIB_SUFFIX -	Suffix to use for the names of dynamically loadable
#			extensions.  An empty string means we don't know how
#			to use shared libraries on this platform.
#	TCL_LIB_FILE -	Name of the file that contains the Tcl library, such
#			as libtcl7.8.so or libtcl7.8.a.
#	TCL_LIB_SUFFIX -Specifies everything that comes after the "libtcl"
#			in the shared library name, using the $VERSION variable
#			to put the version in the right place.  This is used
#			by platforms that need non-standard library names.
#			Examples:  ${VERSION}.so.1.1 on NetBSD, since it needs
#			to have a version after the .so, and ${VERSION}.a
#			on AIX, since the Tcl shared library needs to have
#			a .a extension whereas shared objects for loadable
#			extensions have a .so extension.  Defaults to
#			${VERSION}${SHLIB_SUFFIX}.
#--------------------------------------------------------------------

# Step 1: set the variable "system" to hold the name and version number
# for the system.  This can usually be done via the "uname" command, but
# there are a few systems, like Next, where this doesn't work.

echo $ac_n "checking system version (for dynamic loading)""... $ac_c" 1>&6
if test -f /usr/lib/NextStep/software_version; then
    system=NEXTSTEP-`awk '/3/,/3/' /usr/lib/NextStep/software_version`
else
    system=`uname -s`-`uname -r`
    if test "$?" -ne 0 ; then
	echo "$ac_t""unknown (can't find uname command)" 1>&6
	system=unknown
    else
	# Special check for weird MP-RAS system (uname returns weird
	# results, and the version is kept in special file).
    
	if test -r /etc/.relid -a "X`uname -n`" = "X`uname -s`" ; then
	    system=MP-RAS-`awk '{print $3}' /etc/.relid'`
	fi
	if test "`uname -s`" = "AIX" ; then
	    system=AIX-`uname -v`.`uname -r`
	fi
	echo "$ac_t""$system" 1>&6
    fi
fi

# Step 2: check for existence of -ldl library.  This is needed because
# Linux can use either -ldl or -ldld for dynamic loading.

echo $ac_n "checking for -ldl""... $ac_c" 1>&6
ac_lib_var=`echo dl_dlopen | tr '.-/+' '___p'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-ldl  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 3826 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
char dlopen();

int main() { return 0; }
int t() {
dlopen()
; return 0; }
EOF
if { (eval echo configure:3836: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -f conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  have_dl=yes
else
  echo "$ac_t""no" 1>&6
have_dl=no
fi


# Step 3: set configuration options based on system name and version.

fullSrcDir=`cd $srcdir; pwd`
EXTRA_CFLAGS=""
TCL_UNSHARED_LIB_SUFFIX=""
TCL_TRIM_DOTS='`echo ${VERSION} | tr -d .`'
ECHO_VERSION='`echo ${VERSION}`'
TCL_LIB_VERSIONS_OK=ok
CFLAGS_DEBUG=-g
CFLAGS_OPTIMIZE=-O
case $system in
    AIX-4.[2-9])
	SHLIB_CFLAGS=""
	SHLIB_LD="$fullSrcDir/ldAix /bin/ld -bhalt:4 -bM:SRE -bE:lib.exp -H512 -T512 -bnoentry"
	SHLIB_LD_LIBS='${LIBS}'
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	LD_FLAGS=""
	LD_SEARCH_FLAGS='-L${LIB_RUNTIME_DIR}'
	AIX=yes
	TCL_SHARED_LIB_SUFFIX='${VERSION}\$\{DBGX\}.a'
	;;
    AIX-*)
	SHLIB_CFLAGS=""
	SHLIB_LD="$fullSrcDir/ldAix /bin/ld -bhalt:4 -bM:SRE -bE:lib.exp -H512 -T512 -bnoentry"
	SHLIB_LD_LIBS='${LIBS}'
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o tclLoadAix.o"
	DL_LIBS="-lld"
	LD_FLAGS=""
	LD_SEARCH_FLAGS='-L${LIB_RUNTIME_DIR}'
	TCL_SHARED_LIB_SUFFIX='${VERSION}\$\{DBGX\}.a'
	;;
    BSD/OS-2.1*|BSD/OS-3*|BSD/OS-4*)
	SHLIB_CFLAGS=""
	SHLIB_LD="shlicc -r"
	SHLIB_LD_LIBS='${LIBS}'
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	LD_FLAGS=""
	LD_SEARCH_FLAGS=""
	;;
    dgux*)
	SHLIB_CFLAGS="-K PIC"
	SHLIB_LD="cc -G"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	LD_FLAGS=""
	LD_SEARCH_FLAGS=""
	;;
    HP-UX-*.08.*|HP-UX-*.09.*|HP-UX-*.10.*)
	SHLIB_SUFFIX=".sl"
	echo $ac_n "checking for -ldld""... $ac_c" 1>&6
ac_lib_var=`echo dld_shl_load | tr '.-/+' '___p'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-ldld  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 3920 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
char shl_load();

int main() { return 0; }
int t() {
shl_load()
; return 0; }
EOF
if { (eval echo configure:3930: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -f conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  tcl_ok=yes
else
  echo "$ac_t""no" 1>&6
tcl_ok=no
fi

	if test "$tcl_ok" = yes; then
	    SHLIB_CFLAGS="+z"
	    SHLIB_LD="ld -b"
	    SHLIB_LD_LIBS=""
	    DL_OBJS="tclLoadShl.o"
	    DL_LIBS="-ldld"
	    LD_FLAGS="-Wl,-E"
	    LD_SEARCH_FLAGS='-Wl,+s,+b,${LIB_RUNTIME_DIR}:.'
	fi
	;;
    IRIX-4.*)
	SHLIB_CFLAGS="-G 0"
	SHLIB_SUFFIX=".a"
	SHLIB_LD="echo tclLdAout $CC \{$SHLIB_CFLAGS\} | `pwd`/tclsh -r -G 0"
	SHLIB_LD_LIBS='${LIBS}'
	DL_OBJS="tclLoadAout.o"
	DL_LIBS=""
	LD_FLAGS="-Wl,-D,08000000"
	LD_SEARCH_FLAGS='-L${LIB_RUNTIME_DIR}'
	TCL_SHARED_LIB_SUFFIX='${VERSION}\$\{DBGX\}.a'
	;;
    IRIX-5.*|IRIX-6.*|IRIX64-6.5*)
	SHLIB_CFLAGS=""
	SHLIB_LD="ld -n32 -shared -rdata_shared"
	SHLIB_LD_LIBS='${LIBS}'
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS=""
	LD_SEARCH_FLAGS='-Wl,-rpath,${LIB_RUNTIME_DIR}'
	if test "$CC" = "gcc" -o `$CC -v 2>&1 | grep -c gcc` != "0" ; then
	    EXTRA_CFLAGS="-mabi=n32"
	    LD_FLAGS="-mabi=n32"
	else
	    case $system in
		IRIX-6.3)
		    # Use to build 6.2 compatible binaries on 6.3.
		    EXTRA_CFLAGS="-n32 -D_OLD_TERMIOS"
		    ;;
		*)
		    EXTRA_CFLAGS="-n32"
		    ;;
	    esac
	    LD_FLAGS="-n32"
	fi
	;;
    IRIX64-6.*)
	SHLIB_CFLAGS=""
	SHLIB_LD="ld -32 -shared -rdata_shared -rpath /usr/local/lib"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS=""
	LD_FLAGS=""
	LD_SEARCH_FLAGS='-Wl,-rpath,${LIB_RUNTIME_DIR}'
	;;
    Linux*)
	SHLIB_CFLAGS="-fPIC"
	SHLIB_LD_LIBS='${LIBS}'
	SHLIB_SUFFIX=".so"
	if test "$have_dl" = yes; then
	    SHLIB_LD="${CC} -shared"
	    DL_OBJS="tclLoadDl.o"
	    DL_LIBS="-ldl"
	    LD_FLAGS="-rdynamic"
	    LD_SEARCH_FLAGS=""
	else
	    ac_safe=`echo "dld.h" | tr './\055' '___'`
echo $ac_n "checking for dld.h""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 4021 "configure"
#include "confdefs.h"
#include <dld.h>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:4026: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  
		SHLIB_LD="ld -shared"
		DL_OBJS="tclLoadDld.o"
		DL_LIBS="-ldld"
		LD_FLAGS=""
		LD_SEARCH_FLAGS=""
else
  echo "$ac_t""no" 1>&6
fi

	fi
	;;
    MP-RAS-02*)
	SHLIB_CFLAGS="-K PIC"
	SHLIB_LD="cc -G"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	LD_FLAGS=""
	LD_SEARCH_FLAGS=""
	;;
    MP-RAS-*)
	SHLIB_CFLAGS="-K PIC"
	SHLIB_LD="cc -G"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	LD_FLAGS="-Wl,-Bexport"
	LD_SEARCH_FLAGS=""
	;;
    NetBSD-*|FreeBSD-*|OpenBSD-*)
	# Not available on all versions:  check for include file.
	ac_safe=`echo "dlfcn.h" | tr './\055' '___'`
echo $ac_n "checking for dlfcn.h""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 4080 "configure"
#include "confdefs.h"
#include <dlfcn.h>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:4085: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  
	    SHLIB_CFLAGS="-fpic"
	    SHLIB_LD="ld -Bshareable -x"
	    SHLIB_LD_LIBS=""
	    SHLIB_SUFFIX=".so"
	    DL_OBJS="tclLoadDl.o"
	    DL_LIBS=""
	    LD_FLAGS=""
	    LD_SEARCH_FLAGS=""
	    TCL_SHARED_LIB_SUFFIX='${TCL_TRIM_DOTS}\$\{DBGX\}.so.1.0'
	
else
  echo "$ac_t""no" 1>&6

	    SHLIB_CFLAGS=""
	    SHLIB_LD="echo tclLdAout $CC \{$SHLIB_CFLAGS\} | `pwd`/tclsh -r"
	    SHLIB_LD_LIBS='${LIBS}'
	    SHLIB_SUFFIX=".a"
	    DL_OBJS="tclLoadAout.o"
	    DL_LIBS=""
	    LD_FLAGS=""
	    LD_SEARCH_FLAGS='-L${LIB_RUNTIME_DIR}'
	    TCL_SHARED_LIB_SUFFIX='${TCL_TRIM_DOTS}\$\{DBGX\}.a'
	
fi


	# FreeBSD doesn't handle version numbers with dots.

	TCL_UNSHARED_LIB_SUFFIX='${TCL_TRIM_DOTS}\$\{DBGX\}.a'
	TCL_LIB_VERSIONS_OK=nodots
	;;
    NEXTSTEP-*)
	SHLIB_CFLAGS=""
	SHLIB_LD="cc -nostdlib -r"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadNext.o"
	DL_LIBS=""
	LD_FLAGS=""
	LD_SEARCH_FLAGS=""
	;;
    OSF1-1.0|OSF1-1.1|OSF1-1.2)
	# OSF/1 1.[012] from OSF, and derivatives, including Paragon OSF/1
	SHLIB_CFLAGS=""
	# Hack: make package name same as library name
	SHLIB_LD='ld -R -export $@:'
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadOSF.o"
	DL_LIBS=""
	LD_FLAGS=""
	LD_SEARCH_FLAGS=""
	;;
    OSF1-1.*)
	# OSF/1 1.3 from OSF using ELF, and derivatives, including AD2
	SHLIB_CFLAGS="-fpic"
	SHLIB_LD="ld -shared"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS=""
	LD_FLAGS=""
	LD_SEARCH_FLAGS=""
	;;
    OSF1-V*)
        # Digital OSF/1
	SHLIB_CFLAGS=""
	SHLIB_LD='ld -shared -expect_unresolved "*"'
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS=""
	LD_FLAGS=""
	LD_SEARCH_FLAGS='-Wl,-rpath,${LIB_RUNTIME_DIR}'
	;;
    RISCos-*)
	SHLIB_CFLAGS="-G 0"
	SHLIB_LD="echo tclLdAout $CC \{$SHLIB_CFLAGS\} | `pwd`/tclsh -r -G 0"
	SHLIB_LD_LIBS='${LIBS}'
	SHLIB_SUFFIX=".a"
	DL_OBJS="tclLoadAout.o"
	DL_LIBS=""
	LD_FLAGS="-Wl,-D,08000000"
	LD_SEARCH_FLAGS='-L${LIB_RUNTIME_DIR}'
	;;
    SCO_SV-3.2*)
        # Note, dlopen is available only on SCO 3.2.5 and greater.  However,
        # this test works, since "uname -s" was non-standard in 3.2.4 and
        # below.
	SHLIB_CFLAGS="-Kpic -belf"
	SHLIB_LD="ld -G"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS=""
	LD_FLAGS="-belf -Wl,-Bexport"
	LD_SEARCH_FLAGS=""
	;;
     SINIX*5.4*)
	SHLIB_CFLAGS="-K PIC"
	SHLIB_LD="cc -G"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	LD_FLAGS=""
	LD_SEARCH_FLAGS=""
	;;
    SunOS-4*)
	SHLIB_CFLAGS="-PIC"
	SHLIB_LD="ld"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	LD_FLAGS=""
	LD_SEARCH_FLAGS='-L${LIB_RUNTIME_DIR}'

	# SunOS can't handle version numbers with dots in them in library
	# specs, like -ltcl7.5, so use -ltcl75 instead.  Also, it
	# requires an extra version number at the end of .so file names.
	# So, the library has to have a name like libtcl75.so.1.0

	TCL_SHARED_LIB_SUFFIX='${TCL_TRIM_DOTS}\$\{DBGX\}.so.1.0'
	TCL_UNSHARED_LIB_SUFFIX='${TCL_TRIM_DOTS}\$\{DBGX\}.a'
	TCL_LIB_VERSIONS_OK=nodots
	;;
    SunOS-5*)
	SHLIB_CFLAGS="-KPIC"
	SHLIB_LD="/usr/ccs/bin/ld -G -z text"

	# Note: need the LIBS below, otherwise Tk won't find Tcl's
	# symbols when dynamically loaded into tclsh.

	SHLIB_LD_LIBS='${LIBS}'
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	LD_FLAGS=""
	LD_SEARCH_FLAGS='-R ${LIB_RUNTIME_DIR}'
	;;
    ULTRIX-4.*)
	SHLIB_CFLAGS="-G 0"
	SHLIB_SUFFIX=".a"
	SHLIB_LD="echo tclLdAout $CC \{$SHLIB_CFLAGS\} | `pwd`/tclsh -r -G 0"
	SHLIB_LD_LIBS='${LIBS}'
	DL_OBJS="tclLoadAout.o"
	DL_LIBS=""
	LD_FLAGS="-Wl,-D,08000000"
	LD_SEARCH_FLAGS='-L${LIB_RUNTIME_DIR}'
	;;
    UNIX_SV* | UnixWare-5*)
	SHLIB_CFLAGS="-KPIC"
	SHLIB_LD="cc -G"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	# Some UNIX_SV* systems (unixware 1.1.2 for example) have linkers
	# that don't grok the -Bexport option.  Test that it does.
	hold_ldflags=$LDFLAGS
	echo $ac_n "checking for ld accepts -Bexport flag""... $ac_c" 1>&6
	LDFLAGS="${LDFLAGS} -Wl,-Bexport"
	cat > conftest.$ac_ext <<EOF
#line 4264 "configure"
#include "confdefs.h"

int main() { return 0; }
int t() {
int i;
; return 0; }
EOF
if { (eval echo configure:4272: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
  rm -rf conftest*
  found=yes
else
  rm -rf conftest*
  found=no
fi
rm -f conftest*

	LDFLAGS=$hold_ldflags
	echo "$ac_t""$found" 1>&6
	if test $found = yes; then
	  LD_FLAGS="-Wl,-Bexport"
	else
	  LD_FLAGS=""
	fi
	LD_SEARCH_FLAGS=""
	;;
esac

# Step 4: If pseudo-static linking is in use (see K. B. Kenny, "Dynamic
# Loading for Tcl -- What Became of It?".  Proc. 2nd Tcl/Tk Workshop,
# New Orleans, LA, Computerized Processes Unlimited, 1994), then we need
# to determine which of several header files defines the a.out file
# format (a.out.h, sys/exec.h, or sys/exec_aout.h).  At present, we
# support only a file format that is more or less version-7-compatible. 
# In particular,
#	- a.out files must begin with `struct exec'.
#	- the N_TXTOFF on the `struct exec' must compute the seek address
#	  of the text segment
#	- The `struct exec' must contain a_magic, a_text, a_data, a_bss
#	  and a_entry fields.
# The following compilation should succeed if and only if either sys/exec.h
# or a.out.h is usable for the purpose.
#
# Note that the modified COFF format used on MIPS Ultrix 4.x is usable; the
# `struct exec' includes a second header that contains information that
# duplicates the v7 fields that are needed.

if test "x$DL_OBJS" = "xtclLoadAout.o" ; then
    echo $ac_n "checking sys/exec.h""... $ac_c" 1>&6
    cat > conftest.$ac_ext <<EOF
#line 4314 "configure"
#include "confdefs.h"
#include <sys/exec.h>
int main() { return 0; }
int t() {

	struct exec foo;
	unsigned long seek;
	int flag;
#if defined(__mips) || defined(mips)
	seek = N_TXTOFF (foo.ex_f, foo.ex_o);
#else
	seek = N_TXTOFF (foo);
#endif
	flag = (foo.a_magic == OMAGIC);
	return foo.a_text + foo.a_data + foo.a_bss + foo.a_entry;

; return 0; }
EOF
if { (eval echo configure:4333: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  tcl_ok=usable
else
  rm -rf conftest*
  tcl_ok=unusable
fi
rm -f conftest*

    echo "$ac_t""$tcl_ok" 1>&6
    if test $tcl_ok = usable; then
	cat >> confdefs.h <<\EOF
#define USE_SYS_EXEC_H 1
EOF

    else
	echo $ac_n "checking a.out.h""... $ac_c" 1>&6
	cat > conftest.$ac_ext <<EOF
#line 4351 "configure"
#include "confdefs.h"
#include <a.out.h>
int main() { return 0; }
int t() {

	    struct exec foo;
	    unsigned long seek;
	    int flag;
#if defined(__mips) || defined(mips)
	    seek = N_TXTOFF (foo.ex_f, foo.ex_o);
#else
	    seek = N_TXTOFF (foo);
#endif
	    flag = (foo.a_magic == OMAGIC);
	    return foo.a_text + foo.a_data + foo.a_bss + foo.a_entry;
	
; return 0; }
EOF
if { (eval echo configure:4370: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  tcl_ok=usable
else
  rm -rf conftest*
  tcl_ok=unusable
fi
rm -f conftest*

	echo "$ac_t""$tcl_ok" 1>&6
	if test $tcl_ok = usable; then
	    cat >> confdefs.h <<\EOF
#define USE_A_OUT_H 1
EOF

	else
	    echo $ac_n "checking sys/exec_aout.h""... $ac_c" 1>&6
	    cat > conftest.$ac_ext <<EOF
#line 4388 "configure"
#include "confdefs.h"
#include <sys/exec_aout.h>
int main() { return 0; }
int t() {

		struct exec foo;
		unsigned long seek;
		int flag;
#if defined(__mips) || defined(mips)
		seek = N_TXTOFF (foo.ex_f, foo.ex_o);
#else
		seek = N_TXTOFF (foo);
#endif
		flag = (foo.a_midmag == OMAGIC);
		return foo.a_text + foo.a_data + foo.a_bss + foo.a_entry;
	    
; return 0; }
EOF
if { (eval echo configure:4407: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  tcl_ok=usable
else
  rm -rf conftest*
  tcl_ok=unusable
fi
rm -f conftest*

	    echo "$ac_t""$tcl_ok" 1>&6
	    if test $tcl_ok = usable; then
		cat >> confdefs.h <<\EOF
#define USE_SYS_EXEC_AOUT_H 1
EOF

	    else
		DL_OBJS=""
	    fi
	fi
    fi
fi

# Step 5: disable dynamic loading if requested via a command-line switch.

# Check whether --enable-load or --disable-load was given.
if test "${enable_load+set}" = set; then
  enableval="$enable_load"
  tcl_ok=$enableval
else
  tcl_ok=yes
fi

if test "$tcl_ok" = "no"; then
    DL_OBJS=""
fi

if test "x$DL_OBJS" != "x" ; then
    BUILD_DLTEST="\$(DLTEST_TARGETS)"
else
    echo "Can't figure out how to do dynamic loading or shared libraries"
    echo "on this system."
    SHLIB_CFLAGS=""
    SHLIB_LD=""
    SHLIB_SUFFIX=""
    DL_OBJS="tclLoadNone.o"
    DL_LIBS=""
    LD_FLAGS=""
    LD_SEARCH_FLAGS=""
    BUILD_DLTEST=""
fi

# If we're running gcc, then change the C flags for compiling shared
# libraries to the right flags for gcc, instead of those for the
# standard manufacturer compiler.

if test "$DL_OBJS" != "tclLoadNone.o" ; then
    if test "$CC" = "gcc" -o `$CC -v 2>&1 | grep -c gcc` != "0" ; then
	case $system in
	    AIX-*)
		;;
	    BSD/OS*)
		;;
	    IRIX*)
		;;
	    NetBSD-*|FreeBSD-*|OpenBSD-*)
		;;
	    RISCos-*)
		;;
	    ULTRIX-4.*)
		;;
	    *)
		SHLIB_CFLAGS="-fPIC"
		;;
	esac
    fi
fi

# Set the default compiler switches based on the --enable-symbols option

# Check whether --enable-symbols or --disable-symbols was given.
if test "${enable_symbols+set}" = set; then
  enableval="$enable_symbols"
  tcl_ok=$enableval
else
  tcl_ok=no
fi

if test "$tcl_ok" = "yes"; then
    CFLAGS_DEFAULT=CFLAGS_DEBUG
    TCL_DBGX=g
else
    CFLAGS_DEFAULT=CFLAGS_OPTIMIZE
    TCL_DBGX=""
fi

#--------------------------------------------------------------------
#	The statements below check for systems where POSIX-style
#	non-blocking I/O (O_NONBLOCK) doesn't work or is unimplemented. 
#	On these systems (mostly older ones), use the old BSD-style
#	FIONBIO approach instead.
#--------------------------------------------------------------------

for ac_hdr in sys/ioctl.h
do
ac_safe=`echo "$ac_hdr" | tr './\055' '___'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 4517 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:4522: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | tr 'abcdefghijklmnopqrstuvwxyz./\055' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ___'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

for ac_hdr in sys/filio.h
do
ac_safe=`echo "$ac_hdr" | tr './\055' '___'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 4554 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:4559: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -f conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | tr 'abcdefghijklmnopqrstuvwxyz./\055' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ___'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

echo $ac_n "checking FIONBIO vs. O_NONBLOCK for nonblocking I/O""... $ac_c" 1>&6
if test -f /usr/lib/NextStep/software_version; then
    system=NEXTSTEP-`awk '/3/,/3/' /usr/lib/NextStep/software_version`
else
    system=`uname -s`-`uname -r`
    if test "$?" -ne 0 ; then
	system=unknown
    else
	# Special check for weird MP-RAS system (uname returns weird
	# results, and the version is kept in special file).
    
	if test -r /etc/.relid -a "X`uname -n`" = "X`uname -s`" ; then
	    system=MP-RAS-`awk '{print $3}' /etc/.relid'`
	fi
	if test "`uname -s`" = "AIX" ; then
	    system=AIX-`uname -v`.`uname -r`
	fi
    fi
fi
case $system in
    # There used to be code here to use FIONBIO under AIX.  However, it
    # was reported that FIONBIO doesn't work under AIX 3.2.5.  Since
    # using O_NONBLOCK seems fine under AIX 4.*, I removed the FIONBIO
    # code (JO, 5/31/97).

    OSF*)
	cat >> confdefs.h <<\EOF
#define USE_FIONBIO 1
EOF

	echo "$ac_t""FIONBIO" 1>&6
	;;
    SunOS-4*)
	cat >> confdefs.h <<\EOF
#define USE_FIONBIO 1
EOF

	echo "$ac_t""FIONBIO" 1>&6
	;;
    ULTRIX-4.*)
	cat >> confdefs.h <<\EOF
#define USE_FIONBIO 1
EOF

	echo "$ac_t""FIONBIO" 1>&6
	;;
    *)
	echo "$ac_t""O_NONBLOCK" 1>&6
	;;
esac

#--------------------------------------------------------------------
#	The statements below define a collection of symbols related to
#	building libtcl as a shared library instead of a static library.
#--------------------------------------------------------------------

realRanlib=$RANLIB
if test "$TCL_SHARED_LIB_SUFFIX" = "" ; then
    TCL_SHARED_LIB_SUFFIX='${VERSION}\$\{DBGX\}${SHLIB_SUFFIX}'
fi
if test "$TCL_UNSHARED_LIB_SUFFIX" = "" ; then
    TCL_UNSHARED_LIB_SUFFIX='${VERSION}\$\{DBGX\}.a'
fi
# Check whether --enable-shared or --disable-shared was given.
if test "${enable_shared+set}" = set; then
  enableval="$enable_shared"
  tcl_ok=$enableval
else
  tcl_ok=no
fi

if test "$tcl_ok" = "yes" -a "${SHLIB_SUFFIX}" != "" ; then
    TCL_SHARED_BUILD=1
    TCL_SHLIB_CFLAGS="${SHLIB_CFLAGS}"
    TCL_LD_SEARCH_FLAGS="${LD_SEARCH_FLAGS}"
    eval "TCL_LIB_FILE=libtcl${TCL_SHARED_LIB_SUFFIX}"
    if test "x$DL_OBJS" = "xtclLoadAout.o"; then
	MAKE_LIB="ar cr \${TCL_LIB_FILE} \${OBJS}"
    else
	MAKE_LIB="\${SHLIB_LD} -o \${TCL_LIB_FILE} \${OBJS} ${SHLIB_LD_LIBS}"
	RANLIB=":"
    fi
else
    TCL_SHARED_BUILD=0
    case $system in
        BSD/OS*)
	    ;;

	AIX-*)
            ;;

        *)
	    SHLIB_LD_LIBS=""
	    ;;
    esac
    TCL_SHLIB_CFLAGS=""
    TCL_LD_SEARCH_FLAGS=""
    eval "TCL_LIB_FILE=libtcl${TCL_UNSHARED_LIB_SUFFIX}"
    MAKE_LIB="ar cr \${TCL_LIB_FILE} \${OBJS}"
fi

# Note:  in the following variable, it's important to use the absolute
# path name of the Tcl directory rather than "..":  this is because
# AIX remembers this path and will attempt to use it at run-time to look
# up the Tcl library.

if test "${TCL_LIB_VERSIONS_OK}" = "ok"; then
    TCL_LIB_FLAG="-ltcl${TCL_VERSION}\${TCL_DBGX}"
else
    TCL_LIB_FLAG="-ltcl`echo ${TCL_VERSION} | tr -d .`\${TCL_DBGX}"
fi
TCL_BUILD_LIB_SPEC="-L`pwd` ${TCL_LIB_FLAG}"
TCL_LIB_SPEC="-L${exec_prefix}/lib ${TCL_LIB_FLAG}"

# tclConfig.sh needs a version of the _LIB_SUFFIX that has been eval'ed
# so that the backslashes quoting the DBX braces are dropped.

# Trick to replace DBGX with TCL_DBGX
DBGX='${TCL_DBGX}'
eval "TCL_LIB_FILE=${TCL_LIB_FILE}"

VERSION='${VERSION}'
eval "CFG_TCL_SHARED_LIB_SUFFIX=${TCL_SHARED_LIB_SUFFIX}"
eval "CFG_TCL_UNSHARED_LIB_SUFFIX=${TCL_UNSHARED_LIB_SUFFIX}"

#--------------------------------------------------------------------
#	The statements below define the symbol TCL_PACKAGE_PATH, which
#	gives a list of directories that may contain packages.  The list
#	consists of one directory for machine-dependent binaries and
#	another for platform-independent scripts.
#--------------------------------------------------------------------

if test "$prefix" != "$exec_prefix"; then
    TCL_PACKAGE_PATH="${exec_prefix}/lib ${prefix}/lib"
else
    TCL_PACKAGE_PATH="${prefix}/lib"
fi




































trap '' 1 2 15
cat > confcache <<\EOF
# This file is a shell script that caches the results of configure
# tests run on this system so they can be shared between configure
# scripts and configure runs.  It is not useful on other systems.
# If it contains results you don't want to keep, you may remove or edit it.
#
# By default, configure uses ./config.cache as the cache file,
# creating it if it does not exist already.  You can give configure
# the --cache-file=FILE option to use a different cache file; that is
# what configure does when it calls configure scripts in
# subdirectories, so they share the cache.
# Giving --cache-file=/dev/null disables caching, for debugging configure.
# config.status only pays attention to the cache file if you give it the
# --recheck option to rerun configure.
#
EOF
# Ultrix sh set writes to stderr and can't be redirected directly,
# and sets the high bit in the cache file unless we assign to the vars.
(set) 2>&1 |
  sed -n "s/^\([a-zA-Z0-9_]*_cv_[a-zA-Z0-9_]*\)=\(.*\)/\1=\${\1='\2'}/p" \
  >> confcache
if cmp -s $cache_file confcache; then
  :
else
  if test -w $cache_file; then
    echo "updating cache $cache_file"
    cat confcache > $cache_file
  else
    echo "not updating unwritable cache $cache_file"
  fi
fi
rm -f confcache

trap 'rm -fr conftest* confdefs* core core.* *.core $ac_clean_files; exit 1' 1 2 15

test "x$prefix" = xNONE && prefix=$ac_default_prefix
# Let make expand exec_prefix.
test "x$exec_prefix" = xNONE && exec_prefix='${prefix}'

# Any assignment to VPATH causes Sun make to only execute
# the first set of double-colon rules, so remove it if not needed.
# If there is a colon in the path, we need to keep it.
if test "x$srcdir" = x.; then
  ac_vpsub='/^[ 	]*VPATH[ 	]*=[^:]*$/d'
fi

trap 'rm -f $CONFIG_STATUS conftest*; exit 1' 1 2 15

# Transform confdefs.h into DEFS.
# Protect against shell expansion while executing Makefile rules.
# Protect against Makefile macro expansion.
cat > conftest.defs <<\EOF
s%#define \([A-Za-z_][A-Za-z0-9_]*\) *\(.*\)%-D\1=\2%g
s%[ 	`~#$^&*(){}\\|;'"<>?]%\\&%g
s%\[%\\&%g
s%\]%\\&%g
s%\$%$$%g
EOF
DEFS=`sed -f conftest.defs confdefs.h | tr '\012' ' '`
rm -f conftest.defs


# Without the "./", some shells look in PATH for config.status.
: ${CONFIG_STATUS=./config.status}

echo creating $CONFIG_STATUS
rm -f $CONFIG_STATUS
cat > $CONFIG_STATUS <<EOF
#! /bin/sh
# Generated automatically by configure.
# Run this file to recreate the current configuration.
# This directory was configured as follows,
# on host `(hostname || uname -n) 2>/dev/null | sed 1q`:
#
# $0 $ac_configure_args
#
# Compiler output produced by configure, useful for debugging
# configure, is in ./config.log if it exists.

ac_cs_usage="Usage: $CONFIG_STATUS [--recheck] [--version] [--help]"
for ac_option
do
  case "\$ac_option" in
  -recheck | --recheck | --rechec | --reche | --rech | --rec | --re | --r)
    echo "running \${CONFIG_SHELL-/bin/sh} $0 $ac_configure_args --no-create --no-recursion"
    exec \${CONFIG_SHELL-/bin/sh} $0 $ac_configure_args --no-create --no-recursion ;;
  -version | --version | --versio | --versi | --vers | --ver | --ve | --v)
    echo "$CONFIG_STATUS generated by autoconf version 2.9"
    exit 0 ;;
  -help | --help | --hel | --he | --h)
    echo "\$ac_cs_usage"; exit 0 ;;
  *) echo "\$ac_cs_usage"; exit 1 ;;
  esac
done

ac_given_srcdir=$srcdir

trap 'rm -fr `echo "Makefile tclConfig.sh" | sed "s/:[^ ]*//g"` conftest*; exit 1' 1 2 15
EOF
cat >> $CONFIG_STATUS <<EOF

# Protect against being on the right side of a sed subst in config.status.
sed 's/%@/@@/; s/@%/@@/; s/%g\$/@g/; /@g\$/s/[\\\\&%]/\\\\&/g;
 s/@@/%@/; s/@@/@%/; s/@g\$/%g/' > conftest.subs <<\\CEOF
$ac_vpsub
$extrasub
s%@CFLAGS@%$CFLAGS%g
s%@CPPFLAGS@%$CPPFLAGS%g
s%@CXXFLAGS@%$CXXFLAGS%g
s%@DEFS@%$DEFS%g
s%@LDFLAGS@%$LDFLAGS%g
s%@LIBS@%$LIBS%g
s%@exec_prefix@%$exec_prefix%g
s%@prefix@%$prefix%g
s%@program_transform_name@%$program_transform_name%g
s%@bindir@%$bindir%g
s%@sbindir@%$sbindir%g
s%@libexecdir@%$libexecdir%g
s%@datadir@%$datadir%g
s%@sysconfdir@%$sysconfdir%g
s%@sharedstatedir@%$sharedstatedir%g
s%@localstatedir@%$localstatedir%g
s%@libdir@%$libdir%g
s%@includedir@%$includedir%g
s%@oldincludedir@%$oldincludedir%g
s%@infodir@%$infodir%g
s%@mandir@%$mandir%g
s%@RANLIB@%$RANLIB%g
s%@CC@%$CC%g
s%@LIBOBJS@%$LIBOBJS%g
s%@CPP@%$CPP%g
s%@BUILD_DLTEST@%$BUILD_DLTEST%g
s%@CFLAGS_DEBUG@%$CFLAGS_DEBUG%g
s%@CFLAGS_DEFAULT@%$CFLAGS_DEFAULT%g
s%@CFLAGS_OPTIMIZE@%$CFLAGS_OPTIMIZE%g
s%@CFLAGS_WARNING@%$CFLAGS_WARNING%g
s%@CFG_TCL_SHARED_LIB_SUFFIX@%$CFG_TCL_SHARED_LIB_SUFFIX%g
s%@CFG_TCL_UNSHARED_LIB_SUFFIX@%$CFG_TCL_UNSHARED_LIB_SUFFIX%g
s%@TCL_DBGX@%$TCL_DBGX%g
s%@DL_LIBS@%$DL_LIBS%g
s%@DL_OBJS@%$DL_OBJS%g
s%@EXTRA_CFLAGS@%$EXTRA_CFLAGS%g
s%@LD_FLAGS@%$LD_FLAGS%g
s%@MAKE_LIB@%$MAKE_LIB%g
s%@MATH_LIBS@%$MATH_LIBS%g
s%@SHLIB_CFLAGS@%$SHLIB_CFLAGS%g
s%@SHLIB_LD@%$SHLIB_LD%g
s%@SHLIB_LD_LIBS@%$SHLIB_LD_LIBS%g
s%@SHLIB_SUFFIX@%$SHLIB_SUFFIX%g
s%@TCL_BUILD_LIB_SPEC@%$TCL_BUILD_LIB_SPEC%g
s%@TCL_LD_SEARCH_FLAGS@%$TCL_LD_SEARCH_FLAGS%g
s%@TCL_LIB_FILE@%$TCL_LIB_FILE%g
s%@TCL_LIB_FLAG@%$TCL_LIB_FLAG%g
s%@TCL_LIB_SPEC@%$TCL_LIB_SPEC%g
s%@TCL_LIB_VERSIONS_OK@%$TCL_LIB_VERSIONS_OK%g
s%@TCL_MAJOR_VERSION@%$TCL_MAJOR_VERSION%g
s%@TCL_MINOR_VERSION@%$TCL_MINOR_VERSION%g
s%@TCL_PACKAGE_PATH@%$TCL_PACKAGE_PATH%g
s%@TCL_PATCH_LEVEL@%$TCL_PATCH_LEVEL%g
s%@TCL_SHARED_LIB_SUFFIX@%$TCL_SHARED_LIB_SUFFIX%g
s%@TCL_SHARED_BUILD@%$TCL_SHARED_BUILD%g
s%@TCL_SHLIB_CFLAGS@%$TCL_SHLIB_CFLAGS%g
s%@TCL_SRC_DIR@%$TCL_SRC_DIR%g
s%@TCL_UNSHARED_LIB_SUFFIX@%$TCL_UNSHARED_LIB_SUFFIX%g
s%@TCL_VERSION@%$TCL_VERSION%g

CEOF
EOF
cat >> $CONFIG_STATUS <<EOF

CONFIG_FILES=\${CONFIG_FILES-"Makefile tclConfig.sh"}
EOF
cat >> $CONFIG_STATUS <<\EOF
for ac_file in .. $CONFIG_FILES; do if test "x$ac_file" != x..; then
  # Support "outfile[:infile]", defaulting infile="outfile.in".
  case "$ac_file" in
  *:*) ac_file_in=`echo "$ac_file"|sed 's%.*:%%'`
       ac_file=`echo "$ac_file"|sed 's%:.*%%'` ;;
  *) ac_file_in="${ac_file}.in" ;;
  esac

  # Adjust relative srcdir, etc. for subdirectories.

  # Remove last slash and all that follows it.  Not all systems have dirname.
  ac_dir=`echo $ac_file|sed 's%/[^/][^/]*$%%'`
  if test "$ac_dir" != "$ac_file" && test "$ac_dir" != .; then
    # The file is in a subdirectory.
    test ! -d "$ac_dir" && mkdir "$ac_dir"
    ac_dir_suffix="/`echo $ac_dir|sed 's%^\./%%'`"
    # A "../" for each directory in $ac_dir_suffix.
    ac_dots=`echo $ac_dir_suffix|sed 's%/[^/]*%../%g'`
  else
    ac_dir_suffix= ac_dots=
  fi

  case "$ac_given_srcdir" in
  .)  srcdir=.
      if test -z "$ac_dots"; then top_srcdir=.
      else top_srcdir=`echo $ac_dots|sed 's%/$%%'`; fi ;;
  /*) srcdir="$ac_given_srcdir$ac_dir_suffix"; top_srcdir="$ac_given_srcdir" ;;
  *) # Relative path.
    srcdir="$ac_dots$ac_given_srcdir$ac_dir_suffix"
    top_srcdir="$ac_dots$ac_given_srcdir" ;;
  esac

  echo creating "$ac_file"
  rm -f "$ac_file"
  configure_input="Generated automatically from `echo $ac_file_in|sed 's%.*/%%'` by configure."
  case "$ac_file" in
  *Makefile*) ac_comsub="1i\\
# $configure_input" ;;
  *) ac_comsub= ;;
  esac
  sed -e "$ac_comsub
s%@configure_input@%$configure_input%g
s%@srcdir@%$srcdir%g
s%@top_srcdir@%$top_srcdir%g
" -f conftest.subs $ac_given_srcdir/$ac_file_in > $ac_file
fi; done
rm -f conftest.subs



exit 0
EOF
chmod +x $CONFIG_STATUS
rm -fr confdefs* $ac_clean_files
test "$no_create" = yes || ${CONFIG_SHELL-/bin/sh} $CONFIG_STATUS || exit 1

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  