  r /*****************************************************************************************************************  B  Program:	SIXEL_DEAMON	Print a Sixel screen dump on an HP LaserJet  Module:	SIXEL_PARSE.C"  Author:	Nick de Smith	August 1989R 		Applied Telematics Group, 7 Vale Avenue, Tunbridge Wells, Kent TN1 1DJ, England.( 		+44 892 511000, PSI%234213300154::NICK
  Description: o  This module implements a state driven parser for DEC sixel strings. The parser is called in the following way:   # 	SIXEL_RESET();				Reset the parser  	get_data(); 	while (data_left) {1 		SIXEL_PARSE_STRING( data_string by decsriptor ) 
 		get_data();  	}. 	SIXEL_FLUSH();				Clear anything left at end.  q  The user (caller) must supply a routine called OUTPUT_LINE( output_string by descriptor ) to write the converted   sixel string to a file/device. /  The overall format of the data stream must be:   / 	DCS P1 ; P2 ; P3 ; q      {sixel-stream}    ST   J  P2 and P3 can be ommitted. If the sixel stream is not bounded by at least  " 	DCS P1 q    {sixel-stream}     ST    No data will be output.  q  There is no colour support in this release. I do not have a HP LaserJet colour printer - I do not know if such a K  thing exists. The SIXEL_STATE routine just ignores colour ('#') sequences. R  I believe that all other sixel control sequences, including scaling, are handled.  J  Copyright (c) 1989 by Applied Telematics Group Limited and Nick de Smith.m  This software is supplied for information only. No guarantee is supplied for this software, and no liability m  will be accepted for any action resulting from the use of this software or the information contained herein. i  Under no circumstances may this software be used for commercial gain, including its sale, lease or loan. N  This software may be copied only with the inclusion of this copyright notice.f  The author is prepared to enter into correspondance with interested parties, but will not necessarily8  maintain this software. Having said all that, enjoy it!    Edit	Edit date	By	Reason U   02	06-Nov-89	NMdS	Include fixes from John Talbot re: FAO problem in Flush_Buffer(). O 				Dramatically improve speed of Flush_Buffer() by using pointers, not arrays. !   01	21-Aug-89	NMdS	First attempt   r *****************************************************************************************************************/   #module		SIXEL_PARSE	"V01.02"   . #include	descrip							/* VMS descriptors			*/3 #include	stsdef							/* VMS system statii bits		*/   J #define	BIT_BUFFER_LENGTH	(300 * 12)				/* Maximum pixel width of page		*/0 									/* (300dpi for 12 inches, landscape)	*/X #define	SIXEL_BUFFER_LENGTH	BIT_BUFFER_LENGTH			/* Maximum number of sixels on a line	*/  0 #define	TRUE	(1==1)							/* Logical .TRUE.			*/2 #define	FALSE	(1==0)							/* Logical .FALSE.			*/   static	enum STATE { , 	INITIAL,							/* Initial (idle) state			*/I 	ESC, DCS, DCS_1, DCS_2, DCS_3, ST,				/* Control sequence processing		*/ / 	SIXELS,								/* General sixel processing		*/ 1 	REPEAT,								/* Set repeat count for sixel		*/ J 	RASTER_ATTRIBUTES, RA_1, RA_2, RA_3, RA_4,			/* Set raster attributes		*/. 	COLOUR_SELECT,							/* Colour selection			*/* 	VALUE, VALUE_1							/* Get a value				*/* } state = INITIAL, return_state = INITIAL;  A static	long	scale_x = 1;						/* X pixel multiplication factor	*/ @ static	long	scale_y = 2;						/* Y  ''         ''         ''		*/D static	long	P2	= 2;						/* 0 or 2 = Overwrite, 1 = strikethrough */= static	long	P3	= 0;						/* Horizontal grid size parameter	*/ A static	long	overstrike = FALSE;					/* Not in overstrike mode		*/ ? static	long	Ph	= 0;						/* Horizontal picture size (pixels)	*/ < static	long	Pv	= 0;						/* Vertical     ''     ''     ''	*/P static unsigned short	sixel_buffer_offset = 0;			/* Offset into sixel buffer		*/[ static unsigned short	saved_sixel_buffer_offset = 0;			/* Saved offset into sixel buffer	*/ P static unsigned char	sixel_buffer[ SIXEL_BUFFER_LENGTH ];		/* Sixel buffer				*/  7 void	SIXEL_RESET();							/* Reset the sixel parser		*/ ? void	SIXEL_PARSE_STRING();						/* Parse a string of sixels		*/ ; void	SIXEL_FLUSH();							/* Flush pending sixel output		*/ C static void SIXEL_STATE();						/* State transition sixel parser	*/   + /* Macro to check returned system status	*/   ! #define	ss_check( command ) {			\  	long status = (command);		\) 	if ( (status & STS$M_SUCCESS) == 0 ) {	\  		LIB$SIGNAL( status );		\ 	}					\ }     r /*****************************************************************************************************************   					S I X E L _ R E S E T  '  Reset the sixel parser for a new file.   r *****************************************************************************************************************/ void
 SIXEL_RESET()  { ? 	state = return_state = INITIAL;					/* Set starting state			*/ 4 	scale_x	= 1;							/* Horizontal scaling factor		*/2 	scale_y	= 2;							/* Vertical scaling factor		*/6 	P2	= 2;							/* Pixels of 0 are set to background	*/4 	P3	= 0;							/* Horizontal grid size parameter?	*// 	Ph = Pv = 0;							/* No picture size yet			*/ 7 	overstrike = FALSE;						/* Not in overstrike mode		*/ < 	sixel_buffer_offset = 0;					/* Back at start of buffer		*/ }   r /*****************************************************************************************************************   					S I X E L _ F L U S H    Flush the sixel buffer.  r *****************************************************************************************************************/ void
 SIXEL_FLUSH()  { o 	if ( sixel_buffer_offset || (overstrike && saved_sixel_buffer_offset) ) { /* If there is some data to flush */ + 		Flush_Buffer();						/* ...flush it				*/  	} }     r /*****************************************************************************************************************  ' 				S I X E L _ P A R S E _ S T R I N G   @  Pass the passed string, character by character, to SIXEL_STATE.  r *****************************************************************************************************************/ void SIXEL_PARSE_STRING( > 	struct	dsc$descriptor *ax_in_buffer	)			/* Input buffer				*/ { T 	unsigned short w_chars = ax_in_buffer->dsc$w_length;		/* Length of input string		*/N 	unsigned char *b_char = ax_in_buffer->dsc$a_pointer;		/* => input string			*/  8 	while ( w_chars-- ) {						/* For each character...		*/; 		SIXEL_STATE( *b_char++ );				/* Process the character		*/  	} }     r /*****************************************************************************************************************   					S I X E L _ S T A T E  S  State driven parser to translate sixel strings into HP LaserJet graphics commands. g  This routine interprets the sixel command string, and buffers the generated data in a form that can be /  later converted by Flush_Buffer() (see below).   r *****************************************************************************************************************/ static void  SIXEL_STATE(8 	unsigned char b_char	)					/* Character to process			*/ { ? 	static	long	l_value = 0;					/* Computed value from string		*/   9 	switch ( state ) {						/* Dispatch on current state		*/  	case INITIAL:= 		switch ( b_char ) {					/* Check for special characters		*/  		case 0x1B:						/* ESC					*/  			state = ESC; J 			return_state = INITIAL;				/* Come back here if unknown ESC sequence */	 			break;  		case 0x90:						/* DCS					*/  			state = DCS; 	 			break;  		}  		break;
 	case ESC: 		switch ( b_char ) { , 		case 'P':						/* DCS (7 bit version)			*/2 			state = VALUE;					/* Pick up DCS P1 value			*/8 			return_state = DCS;				/* ...go to DCS processing		*/	 			break; , 		case '\\':						/* ST (7 bit version)			*/ 			state = ST;	 			break; 
 		default: 			state = return_state;	 			break;  		}  		break;7 	case DCS:							/* DCS P1 ; P2 ; P3 ; q <sixels> ST	*/ 3 		/*	P1	Pixel aspect ratio (vertical:horizontal)...  				missing		2:1	(default) 				0,1		2:1
 				2		5:1 				3,4		3:1 				5,6		2:1 				7,8,9		1:1Z 			DEC now recommend that you don't use P1 (set it to 0) and that you should use the sixel[ 			'set raster attributes' command, '"'. DECwindows tends to send '9' for P1 (which is just  			as well, really!). M 			P2	0 or 2		Pixels specified as 0  are set to the current background colour , 				1		  ''      ''     '' 0  are left aloneP 				HP LaserJet printers cannot do overstrike to the best of my knowledge, so we 				ignore this.U 			P3	Horizontal grid size parameter (distance between two adjacent horizontal pixels O 				We don't use this because I cannot find any meaningful documentation on it.  		*/> 		switch ( l_value ) {					/* Determine pixel aspect ratio		*/ 			case 2:						/* 5:1					*/  				scale_y = 5; scale_x = 1; 
 				break; 			case 3:						/* 3:1					*/ 
 			case 4: 				scale_y = 3; scale_x = 1; 
 				break; 			case 7:						/* 1:1					*/ 
 			case 8:
 			case 9: 				scale_y = 1; scale_x = 1; 
 				break; 			case 0:						/* 2:1					*/ 
 			case 1:
 			case 5:
 			case 6: 			default:  				scale_y = 2; scale_x = 1; 
 				break; 		}  		switch ( b_char ) { . 			case 'q':					/* End of DCS sequence...		*/; 				state = SIXELS;				/* ...so back to sixel processing	*/ 
 				break;/ 			case ';':					/* New value to pick up...		*/ 3 				state = VALUE;				/* ...so get new value...		*/ C 				return_state = DCS_1;			/* ...and continue with DCS sequence	*/ 
 				break;. 			default:					/* Unexpected character...		*/> 				state = SIXELS;				/* ...try to recover by recursing...	*/C 				SIXEL_STATE( b_char );			/* ...the character back as a sixel	*/ 
 				break; 		}  		break; 	case DCS_1: 		P2 = l_value;  		switch ( b_char ) { . 			case 'q':					/* End of DCS sequence...		*/; 				state = SIXELS;				/* ...so back to sixel processing	*/ 
 				break;/ 			case ';':					/* New value to pick up...		*/ 3 				state = VALUE;				/* ...so get new value...		*/ C 				return_state = DCS_2;			/* ...and continue with DCS sequence	*/ 
 				break;. 			default:					/* Unexpected character...		*/> 				state = SIXELS;				/* ...try to recover by recursing...	*/C 				SIXEL_STATE( b_char );			/* ...the character back as a sixel	*/ 
 				break; 		}  		break; 	case DCS_2: 		P3 = l_value;  		switch ( b_char ) { . 			case 'q':					/* End of DCS sequence...		*/; 				state = SIXELS;				/* ...so back to sixel processing	*/ 
 				break;/ 			case ';':					/* New value to pick up...		*/ 3 				state = VALUE;				/* ...so get new value...		*/ C 				return_state = DCS_3;			/* ...and continue with DCS sequence	*/ 
 				break;. 			default:					/* Unexpected character...		*/> 				state = SIXELS;				/* ...try to recover by recursing...	*/C 				SIXEL_STATE( b_char );			/* ...the character back as a sixel	*/ 
 				break; 		}  		break;+ 	case DCS_3:							/* Wait for the 'q'			*/  		switch ( b_char ) { . 			case 'q':					/* End of DCS sequence...		*/; 				state = SIXELS;				/* ...so back to sixel processing	*/ 
 				break;/ 			case ';':					/* New value to pick up...		*/ 3 				state = VALUE;				/* ...so get new value...		*/ C 				return_state = DCS_3;			/* ...and continue with DCS sequence	*/ 
 				break;. 			default:					/* Unexpected character...		*/> 				state = SIXELS;				/* ...try to recover by recursing...	*/C 				SIXEL_STATE( b_char );			/* ...the character back as a sixel	*/ 
 				break; 		}  		break;  * 	case SIXELS:							/* Process sixels			*/ 		switch ( b_char ) { * 		case '!':						/* ! Graphics repeat			*/ 			state = VALUE;  			return_state = REPEAT; 	 			break; , 		case '"':						/* " Raster attributes			*/ 			state = VALUE; $ 			return_state = RASTER_ATTRIBUTES;	 			break; , 		case '#':						/* # Colour introducer			*/ 			state = VALUE;   			return_state = COLOUR_SELECT;	 			break; % 		case '$':						/* Graphics CR				*/ < 			overstrike = TRUE;				/* Say we are in overstrike mode	*/` 			saved_sixel_buffer_offset = sixel_buffer_offset; /* Remember where the end of the line was */< 			sixel_buffer_offset = 0;			/* ...and reset the buffer		*/	 			break; * 		case '-':						/* Graphics NEW-LINE			*/ 			Flush_Buffer();	 			break; ) 		case 0x1B:						/* Embedded escape			*/ > 			state = ESC;					/* Go and process the escape sequence...*/B 			return_state = SIXELS;				/* ...but come back here if needed	*/	 			break;  		case 0x9C:						/* ST					*/ 			state = ST;	 			break; 1 		default:						/* Buffer the sixel character		*/ U 			if ( b_char >= '?' && b_char <= '~' ) {		/* If it is a valid sixel character...	*/ ; 				Buffer_Sixel_Character( b_char );	/* ...buffer it				*/  			}	 			break;  		}  		break;  7 	case REPEAT:							/* !<num><char> Graphics repeat		*/ ; 		state = SIXELS;						/* Go back to sixel processing...	*/ : 		while ( l_value-- ) {					/* Replicate the character		*/I 			SIXEL_STATE( b_char );				/* **RECURSE** to replicate the character */  		}  		break;  : 	case RASTER_ATTRIBUTES:						/* " Pan ; Pad ; Ph ; Pv		*/[ 		/*	Pan / Pad = Pixel aspect ratio, eg. Pan = 2, Pad = 1 means pixels are twice as high as  			they are wide. N 			Ph and Pv define the horizontal and vertical size of the picture in pixels. 		*/9 		scale_y = l_value;					/* Save the Y scaling factor		*/  		switch ( b_char ) { / 			case ';':					/* New value to pick up...		*/ 3 				state = VALUE;				/* ...so get new value...		*/ A 				return_state = RA_1;			/* ...and continue with RA sequence	*/ 
 				break;. 			default:					/* Unexpected character...		*/> 				state = SIXELS;				/* ...try to recover by recursing...	*/C 				SIXEL_STATE( b_char );			/* ...the character back as a sixel	*/ 
 				break; 		}  		break; 	case RA_1: 9 		scale_x = l_value;					/* Save the X scaling factor		*/  		switch ( b_char ) { / 			case ';':					/* New value to pick up...		*/ 3 				state = VALUE;				/* ...so get new value...		*/ A 				return_state = RA_2;			/* ...and continue with RA sequence	*/ 
 				break;. 			default:					/* Unexpected character...		*/> 				state = SIXELS;				/* ...try to recover by recursing...	*/C 				SIXEL_STATE( b_char );			/* ...the character back as a sixel	*/ 
 				break; 		}  		break; 	case RA_2: C 		Ph = l_value;						/* Save horizontal size of picture (pixels) */  		switch ( b_char ) { / 			case ';':					/* New value to pick up...		*/ 3 				state = VALUE;				/* ...so get new value...		*/ A 				return_state = RA_3;			/* ...and continue with RA sequence	*/ 
 				break;. 			default:					/* Unexpected character...		*/> 				state = SIXELS;				/* ...try to recover by recursing...	*/C 				SIXEL_STATE( b_char );			/* ...the character back as a sixel	*/ 
 				break; 		}  		break; 	case RA_3: A 		Pv = l_value;						/* Save vertical size of picture (pixels) */  		switch ( b_char ) { / 			case ';':					/* New value to pick up...		*/ 3 				state = VALUE;				/* ...so get new value...		*/ A 				return_state = RA_4;			/* ...and continue with RA sequence	*/ 
 				break;. 			default:					/* Unexpected character...		*/> 				state = SIXELS;				/* ...try to recover by recursing...	*/C 				SIXEL_STATE( b_char );			/* ...the character back as a sixel	*/ 
 				break; 		}  		break; 	case RA_4:  		switch ( b_char ) { / 			case ';':					/* New value to pick up...		*/ 3 				state = VALUE;				/* ...so get new value...		*/ 9 				return_state = RA_4;			/* ...and wait for the end		*/ 
 				break;. 			default:					/* Unexpected character...		*/> 				state = SIXELS;				/* ...try to recover by recursing...	*/C 				SIXEL_STATE( b_char );			/* ...the character back as a sixel	*/ 
 				break; 		}  		break;  9 	case COLOUR_SELECT:						/* # Pc ; Pu ; Px ; Py ; Pz		*/  		/* 			Pc	0 - 255		Colour number* 			Pu	1,2		1 = HLS folows, 2 = RGB follows 		HLS:	Px	0-360 degrees	Hue  			Py	0-100 percent	Lightness  			Pz	0-100 percent	Saturation% 		RGB:	Px	0-100 percent	Red intensity # 			Py	0-100 percent	Green intensity " 			Pz	0-100 percent	Blue intensity  B 			We ignore all this because I don't have a colour laser printer. 		*/@ 		if ( b_char == ';' ) {					/* If there is another number...	*/: 			state = VALUE;					/* ...Go and pick up the value...	*/
 		} else {; 			state = SIXELS;					/* Go back to sixel processing...	*/ G 			SIXEL_STATE( b_char );				/* **RECURSE** to process the character */  		}  		break;  , 	case ST:							/* String Terminator...			*/5 		Flush_Buffer();						/* Flush the output buffer		*/*8 		state = INITIAL;					/* Not in SIXEL mode any more		*/ 		break;  % 	case VALUE:							/* Get value				*/ 9 		l_value = 0;						/* Initialise the value counter...	*/c3 		state = VALUE_1;					/* Get subsequent digits		*/ " 		/* Fall through to VALUE_1				*/ 	case VALUE_1:J 		if ( b_char >= '0' && b_char <= '9' ) {			/* If its a valid digit...		*/N 			l_value = l_value * 10 + ( b_char - '0' );	/* Add in this digit's value		*/
 		} else {9 			state = return_state;				/* Set the return address		*/ C 			SIXEL_STATE( b_char );				/* **RECURSE** to process character	*/  		}		 		break;	   	 	default:F 		state = INITIAL; 		break; 	} }.    r /*****************************************************************************************************************  / 				B u f f e r _ S i x e l _ C h a r a c t e r     Buffer a sixel character.n  If we are in overstrike mode, .OR. in the new character (remembering the real buffer position), else just add  in the new character.  r *****************************************************************************************************************/ static Buffer_Sixel_Character( / 	char	b_char		)					/* Character to buffer			*/L {A4 	short	scale = scale_x;					/* X scaling factor			*/  6 	while ( scale-- > 0 ) {						/* While scaling...			*/U 		if ( sixel_buffer_offset >= SIXEL_BUFFER_LENGTH ) {	/* If the buffer is full...		*/k+ 			Flush_Buffer();					/* ...empty it				*/f 		}i? 		if ( overstrike ) {					/* If we are in overstrike mode...	*/li 			if ( sixel_buffer_offset >= saved_sixel_buffer_offset ) { /* ...and beyond the old string length... */ T 				sixel_buffer[ sixel_buffer_offset++ ] = b_char - '?';	/* Buffer the character	*/R 				saved_sixel_buffer_offset = sixel_buffer_offset; /* Remember the new length	*/ 			} else {rV 				sixel_buffer[ sixel_buffer_offset++ ] |= (b_char - '?'); /* Add in the new char	*/ 			}
 		} else {T 			sixel_buffer[ sixel_buffer_offset++ ] = b_char - '?';	/* Buffer the character		*/ 		}R 	} }  2  r /*****************************************************************************************************************   					F l u s h _ B u f f e r  >  Flush the constructed sixel buffer to the output file/device.    The logic is as follows:*g  A SIXEL represents SIX rows of bits for the current column. Therefore, 'n' sixels represent 'n' colums   by six rows of data.	i  The HP printer requires a bit-stream for each row, with the most significant bit of the first byte beingT  the leftmost pixel.W  We therefore decode the input sixel stream by processing each of the six rows in turn.Ic  For each row, we test the appropiate bit in the input stream, and set the corresponding bit in the	  output stream..O  We then build up a descriptor for the data and pass it to the user for output.Th  In order to handle picture scaling, we output the final row as many times as is needed for the vertical  scaling factor.  r *****************************************************************************************************************/ static Flush_Buffer() {AT 	static $DESCRIPTOR( x_faoctl, "\x1B*b!UWW" );			/* Format of a HP graphics line		*/M 	static struct dsc$descriptor_d x_output = {			/* Formatted output string		*/T' 		0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 };XS 	unsigned char bit_buffer[ (BIT_BUFFER_LENGTH + 7 ) / 8 ];	/* HP format buffer			*/ ? 	unsigned char *bit_buffer_ptr;					/* => HP format buffer			*/ < 	unsigned char *sixel_buffer_ptr;				/* => Sixel buffer			*/N 	struct dsc$descriptor_s x_bit_buffer = {			/* ''   ''     ''   descriptor		*/0 		0, DSC$K_DTYPE_T, DSC$K_CLASS_S, bit_buffer };E 	long	bit_byte_count;						/* Number of bytes in output bit stream	*/  	unsigned char	mask; 	unsigned short	row, col;o, 	short	scale;							/* Y scaling factor			*/  ? 	if ( overstrike ) {						/* If we are in overstrike mode...	*/sY 		sixel_buffer_offset = saved_sixel_buffer_offset;	/* ...use the maximum buffer length	*/e 	}\ 	bit_byte_count = (sixel_buffer_offset + 7) / 8;			/* Determine number of bytes in output	*/J 	for ( row = 0; row <= 5; row++ ) {				/* For each row in the sixel...		*/^ 		LIB$MOVC5( &0, bit_buffer, &0, &bit_byte_count, bit_buffer ); /* Clear out the bit buffer	*/3 		mask = 1 << row;					/* Bit to test in sixel			*/   D 		sixel_buffer_ptr = sixel_buffer;			/* => Start of sixel string		*/D 		bit_buffer_ptr	 = bit_buffer;				/* => Output HP format buffer		*/K 		for ( col = 0; col < sixel_buffer_offset; ) {		/* For each column...			*/*O 			if ( *sixel_buffer_ptr++ & mask ) {		/* If the bit is set in the sixel...	*/TN 				*bit_buffer_ptr |= (1 << (7 - (col & 7))); /* Bit to set for HP output		*/ 			}? 			if ( !(++col & 7) ) {				/* If we are moving on a byte...	*/*G 				bit_buffer_ptr++;			/* ...move up one character in output buffer */	 			} 		}r  a 		/* Build the output string. Due to LIB$SYS_FAO limiting its output strings to 256 characters ina_ 		   length, we assemble the output string in 2 parts. The first uses LIB$SYS_FAO to add in theoe 		   length infomation, then we use STR$CONCAT to add in the bitmap infomation. Thanks to John Talbot;( 		   for pointing this out (fix V01.02).R 		   This problem manifested itself when there were more than 1992 bits to output: 			1992 bits   = 249 bytes> 			<esc>*b249W = 7 bytes in the HP header string, = 256 total.b 		   1993 bits would mean 250 bytes of bitmap, and therefore 257 characters of output. LIB$SYS_FAO3 		   cannot output strings of this length.							*/*   		ss_check( LIB$SYS_FAO(( 			&x_faoctl		,			/* Control string			*/% 			0			,			/* No returned length			*/u' 			&x_output		,			/* Output string			*/ 1 			bit_byte_count		) )			/* Length of buffer			*/	  G 		x_bit_buffer.dsc$w_length = bit_byte_count;		/* Length of buffer			*/* 		ss_check( STR$CONCAT(*. 			&x_output		,			/* Out: Final HP string			*/1 			&x_output		,			/* In:  Control information		*/s8 			&x_bit_buffer		) )			/* In:  HP bitmap infomation		*/   		scale = scale_y;C 		while ( scale-- > 0 ) {					/* Make certain we scale correctly	*/*F 			OUTPUT_LINE( &x_output );			/* Output line using callers routine	*/ 		}f 	}; 	sixel_buffer_offset = 0;					/* Reset the sixel buffer		*/_? 	overstrike = FALSE;						/* Can't be in overstrike mode now	*/h }* h