/*  ++

     Title:
    	SHOW_KNOWN_LINKS
    
     Version:
    	1.0
    
      Facility:
		System Management Tool

     Abstract:
		This program creates a list of DECnet links from a session control
		port listing and an nsp & osi port listing.

     Environment:
		DECnet/Plus Enviroment

     Author:
    	Mark Oakley	Verizon Wireless	12-Nov-2002
    
     Modified:
    	
    
    --
*/

#include  <file.h>
#include  <iodef.h>
#include  <jpidef.h>
#include  <ssdef.h>
#include  <starlet.h>
#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <unistd.h>
#include  <unixio.h>

#define   NL                   0
#define   BLANK               32
#define   DOLLAR_SIGN         36
#define   RIGHT_PAREN         40
#define   LEFT_PAREN          41
#define   COMMA               44
#define   PERIOD              46
#define   EQUAL_SIGN          61
#define   LEFT_BRACKET        91
#define   RIGHT_BRACKET       93

/* Structure will be used to create a linked list
   of all nsp/osi port information (port id, local
   & remote nsap address, local & remove connection
   ids.   */

typedef   struct port_data_struct
{ struct port_data_struct           *port_ptr;
  char                              ptid[20];
  char                              lnsp[50];
  char                              rnsp[50];
  char                              llnk[10];
  char                              rlnk[10]; } port_data_typedef;

main (int argc, char *argv[])
{
  void           fix_leua ();
  void           fix_reua ();
  void           fix_proc ();
  void           fix_nsap ();
  void           fix_ptid ();
  void           get_prcnam ();
  void           parse_port_info ();
  void           search_port_info ();
  void           check_for_rpid ();

  int            i;
  int            j;
  int            cnt = 0;
  char           buff[255];
  int            file_desc;
  char           tmpc;
  int            flags;
  char           prcnam[16] = "-process  name-";
  char           *blanks = "  ";
  unsigned int   rpid;

  char                     *head_port_ptr;
  struct port_data_struct  *curr_port_ptr;
  struct port_data_struct  *prev_port_ptr;

/* The follow labels (or tags) are used to parse the session control port and 
   nsp/osi port listings.   */

  char           name[40], name_tag[] = "    Name                              =";
  char           leua[40], leua_tag[] = "    Local End User Address            =";
  char           tprt[40], tprt_tag[] = "    Transport Port                    =";
  char           dire[40], dire_tag[] = "    Direction                         =";
  char           reua[15], reua_tag[] = "    Remote End User Address           =";
  char           node[40], node_tag[] = "    Node Name Sent                    =";
  char           proc[40], proc_tag[] = "    Process Identifier                =";
  char           lnsp[50], lnsp_tag[] = "    Local NSAP                        =";
  char           rnsp[50], rnsp_tag[] = "    Remote NSAP                       =";
  char           llnk[10], llnk_tag[] = "    Local Reference                   =";
  char           rlnk[10], rlnk_tag[] = "    Remote Reference                  =";
  char           ptid[20];
  char           pttp[3];
  unsigned int   tag_len;

  if (argc < 3)
   { perror ("Insufficient arguments");
     exit (1); }

  flags = O_RDONLY;
  if ((file_desc = open (argv[2], flags)) == -1)
   { perror ("open");
     exit (1); }

  printf ("------------------------- Local -----------------------------   ");
  printf ("--------------- Remote ------------------\n");
  printf ("Type Direction         Id    Link      Pid           Name          ");
  printf ("Node     Link           Id         Pid\n\n");

  tag_len = strlen (name_tag);

  curr_port_ptr = malloc (sizeof (struct port_data_struct));
  head_port_ptr = (char *) curr_port_ptr;
  prev_port_ptr =          curr_port_ptr;

/* Read each nsp/osi port entry, and create a linked list in memory
   that we use later to lookup these entries.   */

  while ((i = read (file_desc, &buff, 255)) != 0)
   { buff[i-1] = NL;  cnt++; 
     tmpc = buff[tag_len]; buff[tag_len] = NL;
     if (strcmp (name_tag, buff) == 0) strcpy ((char *) curr_port_ptr->ptid, (char *) &buff[tag_len+1]);
     if (strcmp (lnsp_tag, buff) == 0) strcpy ((char *) curr_port_ptr->lnsp, (char *) &buff[tag_len+1]);
     if (strcmp (rnsp_tag, buff) == 0) strcpy ((char *) curr_port_ptr->rnsp, (char *) &buff[tag_len+1]);
     if (strcmp (llnk_tag, buff) == 0) strcpy ((char *) curr_port_ptr->llnk, (char *) &buff[tag_len+1]);
     if (strcmp (rlnk_tag, buff) == 0) 
      { strcpy ((char *) curr_port_ptr->rlnk, (char *) &buff[tag_len+1]);
        fix_ptid (curr_port_ptr->ptid);
        fix_nsap (curr_port_ptr->lnsp);
        fix_nsap (curr_port_ptr->rnsp);
        prev_port_ptr = curr_port_ptr;
        curr_port_ptr = malloc (sizeof (struct port_data_struct));
        prev_port_ptr->port_ptr = curr_port_ptr;
        curr_port_ptr->port_ptr = NL; }  }

  if ((i = close (file_desc)) == -1)
   { perror ("close");
     exit (1); }

  flags = O_RDONLY;
  if ((file_desc = open (argv[1], flags)) == -1)
   { perror ("open");
     exit (1); }

  for (j=0; j<14; j++) reua[j] = BLANK; reua[j] = NL;

/* Read each entry in the session control list file and output the corresponding
   link information.          */

  while ((i = read (file_desc, &buff, 255)) != 0)
   { buff[i-1] = NL;  cnt++;
     tmpc = buff[tag_len]; buff[tag_len] = NL;
     if (strcmp (name_tag, buff) == 0) strcpy ((char *) &name, (char *) &buff[tag_len+1]);
     if (strcmp (leua_tag, buff) == 0) strcpy ((char *) &leua, (char *) &buff[tag_len+1]);
     if (strcmp (tprt_tag, buff) == 0) strcpy ((char *) &tprt, (char *) &buff[tag_len+1]);
     if (strcmp (dire_tag, buff) == 0) strcpy ((char *) &dire, (char *) &buff[tag_len+1]);
     if (strcmp (reua_tag, buff) == 0) strcpy ((char *) &reua, (char *) &buff[tag_len+1]);
     if (strcmp (node_tag, buff) == 0) strcpy ((char *) &node, (char *) &buff[tag_len+1]);
     if (strcmp (proc_tag, buff) == 0) 
      { strcpy ((char *) &proc, (char *) &buff[tag_len+1]);
        check_for_rpid (&reua, &rpid);
        fix_leua (&leua);
        fix_reua (&reua);
        fix_proc (&proc);
        get_prcnam (&proc, &prcnam);
        parse_port_info (&tprt, &ptid, &pttp);
        search_port_info (&ptid, head_port_ptr, &curr_port_ptr);
        if (curr_port_ptr == NL)
         { printf ("%3s   %8s %12s %5s %8s %15s       %6s    %5s%13s    %8.8x\n", 
                   pttp, dire, leua, blanks, proc, prcnam,
                   blanks, blanks, reua, rpid); }
         else
         { printf ("%3s   %8s %12s %5s %8s %15s       %6s    %5s%13s    %8.8x\n", 
                   pttp, dire, leua, curr_port_ptr->llnk, proc, prcnam,
                   curr_port_ptr->rnsp, curr_port_ptr->rlnk, reua, rpid); }

        for (j=0; j<14; j++) reua[j] = BLANK; reua[j] = NL; }
     buff[tag_len] = tmpc; }

  if ((i = close (file_desc)) == -1)
   { perror ("close");
     exit (1); }

}

/*  This routine examines the local end user address and returns
    just the username or id number is one exists.     */

void fix_leua ( char * leua)
{ char         *ptr;

  if ((ptr = strchr (leua, RIGHT_BRACKET)) != NL)
   { while (*ptr != NL)
      { ptr++; 
        *leua = *ptr;
        leua++; }
      *leua = NL; }

  if ((ptr = strchr (leua, EQUAL_SIGN)) != NL)
   { while (*ptr != NL)
      { ptr++; 
        *leua = *ptr;
        leua++; }
      *leua = NL; }
}

/* This routine examines the remote end user address and returns
   just the username or id number if it exists.      */

void fix_reua ( char * reua)
{ char         *ptr;

  if ((ptr = strchr (reua, RIGHT_BRACKET)) != NL)
   { while (*ptr != NL)
      { ptr++; 
        *reua = *ptr;
        reua++; }
      *reua = NL; }

  if ((ptr = strchr (reua, EQUAL_SIGN)) != NL)
   { while (*ptr != NL)
      { ptr++; 
        *reua = *ptr;
        reua++; }
      *reua = NL; }
}

/* This routine strips the leading and trailing double quotes
   from the process id.         */

void fix_proc (char * proc)
{ unsigned int   i;
  char           *ptr1;
  char           *ptr2;

  ptr1 = proc;
  ptr2 = proc;
  ptr2++;

  for (i=0; i<8; i++)
   { *ptr1 = *ptr2;
     ptr1++;
     ptr2++; }

  *ptr1 = NL;
}

/* This routine examines the local nsap and returns just the
   node name.           */

void fix_nsap ( char * nsap)
{ char         *ptr;

  if ((ptr = strchr (nsap, PERIOD)) != NL)
   { while (*ptr != LEFT_PAREN)
      { ptr++; 
        *nsap = *ptr;
        nsap++; }
      nsap--;
      *nsap = NL; }
}

/* This routine returns nsp/osi port id information to the right
   of the dollar sign.         */

void fix_ptid ( char * ptid)
{ char         *ptr;

  if ((ptr = strchr (ptid, DOLLAR_SIGN)) != NL)
   { while (*ptr != NL)
      { ptr++; 
        *ptid = *ptr;
        ptid++; }
      ptid--;
      *ptid = NL; }
}

/* This routine returns port type (NSP or OSI) and id, given 
   the port id field.        */

void parse_port_info ( char * tprt, char * ptid, char * pttp)
{
  unsigned int   i;
  char           *ptr;

  for (i=1; i<4; i++)
   { *pttp = *tprt;
     pttp++;
     tprt++; }
  *pttp = NL;

  if ((ptr = strchr (tprt, DOLLAR_SIGN)) != NL)
   { while (*ptr != NL)
      { ptr++; 
        *ptid = *ptr;
        ptid++; }
      ptid--;
      *ptid = NL; }
}

/* This routine searches a linked list for nsp/osi port informatio
   given a port id from a session control port entry.      */

void search_port_info (char * tprt, char * head_port_ptr, unsigned int * curr_port_ptr)
{
  struct port_data_struct     *srch_port_ptr;

  srch_port_ptr = (struct port_data_struct *) head_port_ptr;
  while (strcmp (tprt, srch_port_ptr->ptid) != 0)
   { srch_port_ptr = srch_port_ptr->port_ptr;
     if (srch_port_ptr == NL) break; }
  *curr_port_ptr = (unsigned int) srch_port_ptr;
}

/* This routine gets the process name given a process id from the process id
   field of a session control port entry.   */

void get_prcnam (char * proc, char * prcnam)
{
  unsigned int    pid;
  unsigned int    status;
  unsigned int    iosb[2];
  unsigned int    process_name_len = 0;
  char            process_name[16];
  
  struct
  { unsigned short   buff;
    unsigned short   code;
    char             *addr;
    char             *retl; } item_list[2];

  sscanf (proc, "%x", &pid);

  item_list[0].buff = sizeof (process_name);
  item_list[0].code = JPI$_PRCNAM;
  item_list[0].addr = (char *) &process_name;
  item_list[0].retl = (char *) &process_name_len;
  item_list[1].buff = 0;
  item_list[1].code = 0;
  if ((status = sys$getjpiw (0, &pid, 0, &item_list, &iosb, 0, 0)) == SS$_NORMAL)
   if (iosb[0] ==  SS$_NORMAL)
    { process_name[process_name_len] = 0;
      strcpy (prcnam, process_name); }

}

/* This routine checks for a valid pid in the remote end user address and returns
   the decoded value if present.      */

void check_for_rpid (char * reua, unsigned int * rpid)
{ char           h_pid[5];
  unsigned int   hpid;
  char           l_pid[5];
  unsigned int   lpid;
  char           t_pid[9];
  unsigned int   tpid;
  char           *ptr;
  unsigned int   i;

  *rpid = 0;

  if ((ptr = strchr (reua, LEFT_BRACKET)) != NL)

   { i = -1;
     while (*ptr != COMMA)
     { ptr++;
       i++;
       l_pid[i] = *ptr; }
     l_pid[i] = NL;
     sscanf (l_pid, "%o", &lpid);

     i = -1;
     while (*ptr != RIGHT_BRACKET)
     { ptr++;
       i++;
       h_pid[i] = *ptr; }
     h_pid[i] = NL;
     sscanf (h_pid, "%o", &hpid);

     sprintf (t_pid, "%4.4x%4.4x", hpid, lpid);
     sscanf  (t_pid, "%x",     &tpid);
     *rpid = tpid;
   }
}
