, #pragma module	SPOP3_NETIO	"SPOP3_NETIO-1-A"  #define	__MODULE__	"SPOP3_NETIO"   /* **++/ **  FACILITY:  StarLet POP3 server form OpenVMS  ** **  MODULE DESCRIPTION:  **2 **	This module covers network I/O  functionality.  ** **  AUTHORS: ** **      Ruslan R. Laishev  ** **  CREATION DATE:  24-MAR-2005  ** **  DESIGN ISSUES: **	  **  MODIFICATION HISTORY:  **2 **	 7-SEP-2005	RRL	Fixed bug in the netio_close().F **	27-DEC-2005	RRL	Fixed possible buffer overflow in the netio_read(). ** **      {@tbs@}... **-- */   #include	<ssdef.h> #include	<starlet.h> #include	<lib$routines.h>  #include	<iledef.h>  #include	<stdio.h> #include	<descrip.h> #include	<iodef.h> #include	<iosbdef.h> #include	<tcpip$inetdef.h> #include	<inet.h>  #include	<in.h>  #include	<netdb.h> #include	<efndef.h>  #include	<string.h>     % $DESCRIPTOR(dsc_ucxdev,"UCX$DEVICE"); ) $DESCRIPTOR(dsc_tcpipdev,"TCPIP$DEVICE");     > #define	INIT_DDESC(dsc)			{(dsc).dsc$b_dtype = DSC$K_DTYPE_T;\= 			(dsc).dsc$b_class = DSC$K_CLASS_D;(dsc).dsc$w_length = 0;\  			(dsc).dsc$a_pointer = 0;}  F #define	INIT_SDESC(dsc, len, ptr)	{(dsc).dsc$b_dtype = DSC$K_DTYPE_T;\J 			(dsc).dsc$b_class = DSC$K_CLASS_S; (dsc).dsc$w_length = (short) (len);\  			(dsc).dsc$a_pointer = (ptr);}   #define	min(x,y)	((x > y)?y:x) #define	max(x,y)	((x < y)?y:x)  # unsigned	sendbfsz = 16384, one = 1;    /* **++ **  FUNCTIONAL DESCRIPTION:  **Q **      Open a passive socket and listening for incomming TCP-connection request.  ** **  FORMAL PARAMETERS: **< **	port:	A local port number, 0 - assume default port number ** **  RETURN VALUE:  ** **	VMS condition code  ** **-- */ int	netio_start	(  		unsigned *	netchan,  		unsigned short	port  			) {  int	status;  const struct  {          short   proto;         char    type;          char    domain; B         } sck_parm = {TCPIP$C_TCP,TCPIP$C_STREAM,TCPIP$C_AF_INET};
 iosb	iosb; struct sockaddr_in home;L const ile2	lhst_adrs = {sizeof(struct sockaddr_in),TCPIP$C_SOCK_NAME,&home},_ 		sock_opt[]={{sizeof(sendbfsz),INET$C_SNDBUF,&sendbfsz},{sizeof(one),TCPIP$C_REUSEADDR,&one}}, : 		itm_lst   = {sizeof(sock_opt),INET$C_SOCKOPT,&sock_opt};   	/*  	** Open a network device  	*/ = 	if ( !(1 & (status = sys$assign(&dsc_ucxdev,netchan,0,0))) )  		{   		if ( status != SS$_NOSUCHDEV ) 			return	status; A 		if ( !(1 & (status = sys$assign( &dsc_tcpipdev,netchan,0,0))) )  			return	status;  		}    	/*  	** Create connection socket 	*/ H 	if ( !(1 & (status = sys$qiow(EFN$C_ENF,*netchan,IO$_SETMODE,&iosb,0,0,E 		       &sck_parm,0,0,0,&itm_lst,0))) || !(iosb.iosb$w_status & 1) )  		{  		sys$dassgn (*netchan);0 		return	(1 & status)?iosb.iosb$w_status:status; 		}    	/* < 	** Initialize structure for creating main listening sockets 	*/ , 	memset(&home,0,sizeof(struct sockaddr_in));   	home.sin_port		= htons(port);# 	home.sin_family		= INET$C_AF_INET; + 	home.sin_addr.s_addr	= TCPIP$C_INADDR_ANY;    	/* . 	** Start waiting incomming connection request 	*/ H 	if ( !(1 & (status = sys$qiow(EFN$C_ENF,*netchan,IO$_SETMODE,&iosb,0,0,? 		       0,0,&lhst_adrs,5,0,0))) || !(iosb.iosb$w_status & 1) ) 0 		return	(1 & status)?iosb.iosb$w_status:status;     	return	status;  }    int	netio_accept	( 		unsigned	netchan,  		unsigned *	chan, 	struct in_addr	*	addr 			) {  unsigned status, nchan = 0;  unsigned short	retlen = 0;
 iosb	iosb; struct sockaddr_in rhost; @ ile3	rhost_item = {sizeof(struct sockaddr_in),0,&rhost,&retlen};  - 	memset(&rhost,0,sizeof(struct sockaddr_in));    	/* & 	** Create a socket for new connection 	*/ < 	if ( !(1 & (status = sys$assign(&dsc_ucxdev,&nchan,0,0))) ) 		{   		if ( status != SS$_NOSUCHDEV ) 			return	status; = 		if ( !(1 & (status = sys$assign(&dsc_tcpipdev,chan,0,0))) )  			return	status;  		}    	/*  	** Accept client connection 	*/ R 	if ( !(1 & (status = sys$qiow(EFN$C_ENF,netchan,IO$_ACCESS|IO$M_ACCEPT,&iosb,0,0,E 		       0,0,&rhost_item,&nchan,0,0))) || !(iosb.iosb$w_status & 1) )  		{  		sys$dassgn (nchan); 0 		return	(1 & status)?iosb.iosb$w_status:status; 		}    	*addr	= rhost.sin_addr; 	*chan	= nchan;    	return status;  }    /* **++ **  FUNCTIONAL DESCRIPTION:  **$ **      Close a network I/O channel. ** **  FORMAL PARAMETERS: **7 **	chan:	A network I/O channel returned by net_accept()  ** **  RETURN VALUE:  ** **	VMS condition code  ** **-- */ int	netio_close	(  		unsigned chan  			) { 
 iosb	iosb;  . 	sys$qiow(EFN$C_ENF,chan,IO$_DEACCESS, &iosb, >                         0, 0, 0, 0, 0, TCPIP$C_DSC_ALL,0, 0);  	return	sys$dassgn (chan); }    /* **++ **  FUNCTIONAL DESCRIPTION:  **K **      Canceling all queued and processed request due of expiration timer.  ** **  FORMAL PARAMETERS: **, **      reqidt:	pointer to a network channel ** **  RETURN VALUE:  ** **      None ** **  SIDE EFFECTS:  **7 **      Cancel _all_ request for the given I/O channel.  **-- */ static	void	timer_ast	(  		unsigned	*reqidt 			) {  	sys$cantim(reqidt,0); 	sys$cancel(*reqidt);  }    /* **++ **  FUNCTIONAL DESCRIPTION:  **U **	Read a data from the specified network channel, if remhost parameter is took place S **	the UDP-style reading is used. In other case is used a TCP-style reading for the S **	speficied amount of data. In case of TCP-style receiving a timeout processing is  **	performed.  ** **  FORMAL PARAMETERS: **G **      chan:	a channel number, given from netio_open() or netio_conn() " **	buf:	a buffer to receiving data4 **	retlen:	a length of a received data in the buffer ** **  RETURN VALUE:  ** **      VMS condition code ** **-- */ int	netio_read	( 		unsigned	chan, 	struct dsc$descriptor	*buf, 		unsigned short	*retlen,  		unsigned	flag, 		int		*iotmo,% 		void		(*astadr) (__unknown_params),  		void	*	astprm  			)               { 3 int	status,reqidt = chan, bufl = buf->dsc$w_length; 
 iosb	iosb;   	/*  	** Some initialization  	*/ 
 	*retlen = 0;    	/* 1 	** Setup timer request if it's a TCP I/O channel  	*/ K 	if ( !(1 & (status = sys$setimr (EFN$C_ENF,iotmo, timer_ast,&reqidt,0))) )  		return	status;   	/*  	** Reading... 	*/  	while ( *retlen < bufl )  		{ G 		if ( !(1 & (status = sys$qiow (EFN$C_ENF,chan,IO$_READVBLK,&iosb,0,0, : 				buf->dsc$a_pointer+(*retlen),bufl-(*retlen),0,0,0,0)))! 			|| !(1 & iosb.iosb$w_status) ) 	 			break;    		*retlen += iosb.iosb$w_bcnt; 		/*( 		** Check for line termination sequence 		*/ 		if ( flag && (*retlen >= 2) 3 			&& (*(buf->dsc$a_pointer+(*retlen) - 2) == '\r') 5 			&& (*(buf->dsc$a_pointer+(*retlen) - 1) == '\n') )  			{ 			*retlen	-= 2;	 			break;  			} 		else	if ( !flag ) 	 			break;  		}    	/*  	** Cancel a timer request 	*/  	sys$cantim(&reqidt,0);   / 	return	(1 & status)?iosb.iosb$w_status:status;  }    /* **++ **  FUNCTIONAL DESCRIPTION:  **+ **	Write a data to a given network channel.  ** **  FORMAL PARAMETERS: **G **      chan:	a channel number, given from netio_open() or netio_conn() " **	buf:	a buffer to receiving data- **	buflen:	the length of a data in the buffer - **	flag:	a flag to send or not send CRLF pair  ** **  RETURN VALUE:  ** **      VMS condition code ** **-- */ int	netio_write	(  		unsigned	chan, 	struct dsc$descriptor	*buf, 		unsigned	flag,% 		void		(*astadr) (__unknown_params),  		void	*	astprm  			) {  int	status; 
 iosb	iosb;\ struct {unsigned l; char *a;} bvec[] = { {buf->dsc$w_length,buf->dsc$a_pointer},{2,"\r\n"}};E struct dsc$descriptor buf_d = { 0, DSC$K_CLASS_S, DSC$K_DTYPE_T, 0} ;    	/*  	** Setup the buffer descriptor  	*/ & 	buf_d.dsc$a_pointer	= (char *) &bvec;8 	buf_d.dsc$w_length	= flag?sizeof(bvec):sizeof(bvec[0]);  ; 	status = sys$qiow (EFN$C_ENF,chan,IO$_WRITEVBLK,&iosb,0,0,  				0,0,0,0,&buf_d,0);/ 	return	(1 & status)?iosb.iosb$w_status:status;  } 