& #pragma module	POP3_SRV	"POP3_SRV-1-F" #define	__MODULE__	"SPOP3_SRV"   /* **++/ **  FACILITY:  StarLet POP3 server form OpenVMS  ** **  MODULE DESCRIPTION:  **J **	This is a POP3 server for OpenVMS based on RFC1460 & RFC1939 & RFC2449. ** **  AUTHORS: ** **      Ruslan R. Laishev  ** **  CREATION DATE:  23-MAR-2005  ** **  DESIGN ISSUES: **	  **  MODIFICATION HISTORY:  **K **	24-AUG-2005	RRL	Added SPOP3_CHARSET configuration logical to put charset  **				into DecNet mail headers. * **	25-AUG-2005	RRL	Fixed EXPIRE 0 problem.2 **	28-AUG-2005	RRL	Changed MCR []SPOP3_SRV SHUT to$ **					MCR []SPOP3_SRV SHUT <node>|*> **	30-AUG-2005	RRL	Some changes of format of intrusion source,2 **				removed "format=flowed" for Decnet messages.G **	31-AUG-2005	RRL	Changed pop3_user() to prevent change username after  **				open session; C **	 1-SEP-2005	RRL	Added SPOP3_PR_THRESHOLD configuration variable. 3 **	 2-SEP-2005	RRL	Added POP3 LAST command support. 8 **	 8-SEP-2005	RRL	Fixed processing TOP <msg> 0 command.U **	17-JAN-2006	RRL	Fixed  pop3_retr(),  pop3_top(): change one-byte string with <dot>  **				to <dot+space>.  ** **      {@tbs@}... **-- */   #include	<ssdef.h> #include	<stsdef.h>  #include	<starlet.h> #include	<lib$routines.h>  #include	<iledef.h>  #include	<stdio.h> #include	<string.h>  #include	<descrip.h> #include	<pthread.h> #include	<reentrancy.h>  #include	<stdarg.h>  #include	<ciadef.h>  #include	<uicdef.h>  #include	<uaidef.h>  #include	<lgidef.h>  #include	<libdef.h>  #include	<libdtdef.h>  #include	<jpidef.h>  #include	<efndef.h>  #include	<ctype.h> #include	<str$routines.h>  #include        <maildef.h>  #include        <mailmsgdef.h> #include	<in.h>  #include	<lksbdef.h> #include	<lckdef.h>  #include	<lkidef.h>  #include	<stdlib.h>  #include	<iosbdef.h> #include	<syidef.h>    #define	__NEW_STARLET	1  #include	<rms.h>; #include	"spop3def.h"	/* StarLet POP3 Server definitions	*/ > #include	"spop3_msg.h"	/* StarLet POP3 Server message codes	*/  F #define	INIT_SDESC(dsc, len, ptr)	{(dsc).dsc$b_dtype = DSC$K_DTYPE_T;\J 			(dsc).dsc$b_class = DSC$K_CLASS_S; (dsc).dsc$w_length = (short) (len);\) 			(dsc).dsc$a_pointer = (char *) (ptr);}     < #define INIT_DDESC(dsc)	{(dsc).dsc$b_dtype = DSC$K_DTYPE_T;\= 			(dsc).dsc$b_class = DSC$K_CLASS_D;(dsc).dsc$w_length = 0;\  			(dsc).dsc$a_pointer = NULL;}    #define	min(x,y)	((x > y)?y:x) #define	max(x,y)	((x < y)?y:x)  ! int	debug_flag	= 1,exit_flag = 0,  	pr_threshold = 0;b #define DEBUG   if(debug_flag)printf("%-24.24s:%-08.0u ",__MODULE__,__LINE__);if(debug_flag)printf     /* **	Forward routines declaration  */ int	netio_start	(...); int	netio_close	(...); int	netio_read	(...);  int	netio_write	(...); int	netio_accept	(...);      int	vmail_init	(...);  int	vmail_shut	(...);  int	vmail_init_ctx	(...);  int	vmail_shut_ctx	(...);  int	vmail_get_msg	(...); int	vmail_msg_end	(...);     /*3 ** Right ID to designate user as "user under debug"  */G $DESCRIPTOR(pop3_iddebug,	"SPOP3_DEBUG");		/* Session is under debug	*/ K $DESCRIPTOR(pop3_idexpire,	"SPOP3_NOTEXPIRE");	/* Mail box never expired	*/ / unsigned	pop3_iddebug_ = 0, pop3_idexpire_ = 0;    /* ** POP3 protocol messages  */N $DESCRIPTOR(dsc_BUSY,		"-ERR POP3 Server is too busy, try again just later."); $DESCRIPTOR(dsc_OK	,	"+OK"); $DESCRIPTOR(dsc_DOT	,	".");  $DESCRIPTOR(dsc_EOM	,	"!/.");   Z $DESCRIPTOR(dsc_WELCOME	,	"+OK StarLet POP3 Srv. for OpenVMS, http://www.StarLet.SPB.RU");> $DESCRIPTOR(dsc_IQUIT	,	"+OK StarLet POP3 Srv. signing off.");y $DESCRIPTOR(dsc_LQUIT	,	"+OK StarLet POP3 Srv. signing off (!UL mail(s) in the VMS MailBox), context = [!2ZB:!AC/!AC]."); * $DESCRIPTOR(dsc_LISTMSG	,	"+OK !UL !UL.");> $DESCRIPTOR(dsc_PASSREQ	,	"+OK Password required for '!AC'.");] $DESCRIPTOR(dsc_LOGGED	,	"+OK POP3 session is opened, context = [!2ZB:!AC/!AC], !UL mails."); K $DESCRIPTOR(dsc_ALIVE	,	"+OK Session is alive, context = [!2ZB:!AC/!AC]."); . $DESCRIPTOR(dsc_UIDL1	,	"+OK !UL !AC_!UL!UL");* $DESCRIPTOR(dsc_UIDLX	,	"!UL !AC_!UL!UL");: $DESCRIPTOR(dsc_DELETED	,	"+OK Message #!UL is deleted.");' $DESCRIPTOR(dsc_STATM	,	"+OK !UL !UL"); ' $DESCRIPTOR(dsc_LIST1	,	"+OK !UL !UL"); B $DESCRIPTOR(dsc_LISTF	,	"+OK !UL messages (!UL bytes estimated)");# $DESCRIPTOR(dsc_LISTX	,	"!UL !UL"); R $DESCRIPTOR(dsc_RSETM	,	"+OK VMS MailBox has !UL messages (!UL bytes estimated)");3 $DESCRIPTOR(dsc_RETRM	,	"+OK !UL bytes estimated"); I $DESCRIPTOR(dsc_DNETHDR	,	"From: !AC!/Date: !%D!/To: !AC!/Subject: !AC!/\ * Content-Type: text/plain; charset=!AC!/");" $DESCRIPTOR(dsc_LAST	,	"+OK !UL");5 $DESCRIPTOR(dsc_CAPA	,	"+OK Capability list follows:\ 4 !/TOP!/USER!/LOGIN-DELAY !UL!/EXPIRE !UL!/UIDL!/.");6 $DESCRIPTOR(dsc_CAPA2	,	"+OK Capability list follows:\6 !/TOP!/USER!/LOGIN-DELAY !UL!/EXPIRE NEVER!/UIDL!/.");  9 $DESCRIPTOR(dsc_NOSUCHMSG,	"-ERR no such message #!UL."); B $DESCRIPTOR(dsc_INVARGLEN,	"-ERR Invalid username length (!UB).");@ $DESCRIPTOR(dsc_ERRLOGIN,	"-ERR Invalid username or password.");A $DESCRIPTOR(dsc_BADCMD	,	"-ERR Unknown/invalid command: '!AS'."); H $DESCRIPTOR(dsc_OUTRANGE,	"-ERR Message #!UL is out of range [1-!UL].");A $DESCRIPTOR(dsc_HASDELTD,	"-ERR Message #!UL has been deleted."); ; $DESCRIPTOR(dsc_NOARG	,	"-ERR Missing required argument.");    unsigned char	charset [ 32 ];    /*# ** Forward POP3 funtion declaration  */< int	pop3_user	(POP3CTX	*,unsigned char	*arg,unsigned short);< int	pop3_pass	(POP3CTX	*,unsigned char	*arg,unsigned short);< int	pop3_quit	(POP3CTX	*,unsigned char	*arg,unsigned short);< int	pop3_noop	(POP3CTX	*,unsigned char	*arg,unsigned short);< int	pop3_uidl	(POP3CTX	*,unsigned char	*arg,unsigned short);< int	pop3_dele	(POP3CTX	*,unsigned char	*arg,unsigned short);< int	pop3_stat	(POP3CTX	*,unsigned char	*arg,unsigned short);< int	pop3_list	(POP3CTX	*,unsigned char	*arg,unsigned short);< int	pop3_rset	(POP3CTX	*,unsigned char	*arg,unsigned short);< int	pop3_retr	(POP3CTX	*,unsigned char	*arg,unsigned short);; int	pop3_top	(POP3CTX	*,unsigned char	*arg,unsigned short); < int	pop3_capa	(POP3CTX	*,unsigned char	*arg,unsigned short);< int	pop3_last	(POP3CTX	*,unsigned char	*arg,unsigned short);  / #define	ASCIC(a)	((unsigned char)sizeof(a)-1),a      struct pop3cmd { 	unsigned char	clen,
 			cname[16]; : 	int	(*fun)	(POP3CTX	*,unsigned char	*arg,unsigned short); 	unsigned	level; 	}; ' const struct pop3cmd pop3cmd_tbl [] = { / 	{ASCIC("user"),	pop3_user,	POP3LVL$K_INITIAL}, / 	{ASCIC("pass"),	pop3_pass,	POP3LVL$K_INITIAL}, / 	{ASCIC("quit"),	pop3_quit,	POP3LVL$K_INITIAL}, . 	{ASCIC("quit"),	pop3_quit,	POP3LVL$K_LOGGED},. 	{ASCIC("noop"),	pop3_noop,	POP3LVL$K_LOGGED},. 	{ASCIC("uidl"),	pop3_uidl,	POP3LVL$K_LOGGED},. 	{ASCIC("dele"),	pop3_dele,	POP3LVL$K_LOGGED},. 	{ASCIC("stat"),	pop3_stat,	POP3LVL$K_LOGGED},. 	{ASCIC("list"),	pop3_list,	POP3LVL$K_LOGGED},. 	{ASCIC("rset"),	pop3_rset,	POP3LVL$K_LOGGED},. 	{ASCIC("retr"),	pop3_retr,	POP3LVL$K_LOGGED},, 	{ASCIC("top"),	pop3_top,	POP3LVL$K_LOGGED},/ 	{ASCIC("capa"),	pop3_capa,	POP3LVL$K_INITIAL}, . 	{ASCIC("capa"),	pop3_capa,	POP3LVL$K_LOGGED},. 	{ASCIC("last"),	pop3_last,	POP3LVL$K_LOGGED},   	{0,NULL,	NULL,		0}};   
 #ifdef  __VAX !         #define LONGWORD_SZ     4  #else !         #define LONGWORD_SZ     8  #endif  A POP3CTX	pop3ctx_tbl [36];		/* A list of free for use contexts		*/   7 int	iotmo [ 2 ],			/* A global network I/O timeout			*/ 7 	mainchan = 0,			/* Main network I/O channel number		*/ G 	expire = 0,			/* A number of days to keep mails before auto-purging	*/ 6 	logintvl = 0;			/* LOGIN-DISABLE in seconds value		*/  L $DESCRIPTOR(resfao,"SPOP3_SRV@!AZ");	/* A template for  for resource name	*/   pthread_attr_t	tattr;      /* **++ **  FUNCTIONAL DESCRIPTION:  **; **      Put message to standard output device (SYS$OUTPUT).  ** **  FORMAL PARAMETERS: ** **      msgid:" **              VMS condition code' **              variable agriments list  ** **  RETURN VALUE:  ** **      VMS condition code ** ** **-- */ char	msg_pref[] = {"!%D "}; . char	msg_pref_ctx[] = {"!%D [!2ZB !AC/!AC] "};     int	spop3__log	( 	POP3CTX *	ctx, 
 			int	msgid,  			... 			) { % long	status,retvalue = msgid,len = 0; 
 va_list	args;  char	buf[1024],outadr[4]; . struct	dsc$descriptor	opr_dsc,buf_dsc,fao_dsc;& int	argc,argl[32],idx = 0,flag=15,lvl; char    msg_buf[1024];   	if ( !ctx )* 		memcpy(buf,msg_pref,sizeof(msg_pref)-1);6 	else	memcpy(buf,msg_pref_ctx,sizeof(msg_pref_ctx)-1);  7 	len	= (ctx)?sizeof(msg_pref_ctx)-1:sizeof(msg_pref)-1;    	/* ' 	** Get a message text with given msgid  	*/ / 	INIT_SDESC(fao_dsc,sizeof(buf)-len,&buf[len]); Y 	if ( !(1 & (status =  sys$getmsg (msgid,&fao_dsc.dsc$w_length,&fao_dsc,flag,&outadr))) )  		lib$signal(status);  	 
 	argl[0] = 0;  	if ( ctx )  		{  		argl[1]	= ctx->pop3ctx$b_idx; ! 		argl[2]	= &ctx->pop3ctx$b_alen; ! 		argl[3]	= &ctx->pop3ctx$b_ulen;  		}    	/* ( 	** Reorganize parameters list for $FAOL 	*/  	va_start(args,msgid); 	va_count(argc); 	argc	-= 2;   3 	for (idx = 0;idx < argc;idx++,args += LONGWORD_SZ) , 		argl[(ctx?4:1)+idx] = *((unsigned *)args);         va_end((char *) msgid);    	/* * 	** Format a message, put it to SYS$OUTPUT 	*/  	fao_dsc.dsc$a_pointer -=len;  	fao_dsc.dsc$w_length  +=len; . 	INIT_SDESC(buf_dsc, sizeof(msg_buf),msg_buf);P 	if ( !(1 & (status = sys$faol(&fao_dsc,&buf_dsc.dsc$w_length,&buf_dsc,argl))) ) 		lib$signal(status);    	lib$put_output(&buf_dsc);   	return	retvalue;  }    int	pop3__send	( 	POP3CTX *	ctx, ! 	struct dsc$descriptor_s	*msgdsc,  			... 			) { & unsigned	status,idx,argc = 0,argl[32];
 va_list	args;  char	buf[8192];  struct	dsc$descriptor	buf_dsc;  % 	INIT_SDESC(buf_dsc,sizeof(buf),buf);    	/* ( 	** Reorganize parameters list for $FAOL 	*/  	va_start(args,msgdsc);  	va_count(argc); 	argc	-= 2; 3 	for (idx = 0;idx < argc;idx++,args += LONGWORD_SZ) " 		argl[idx] = *((unsigned *)args);  O 	if ( !(1 & (status = sys$faol(msgdsc,&buf_dsc.dsc$w_length,&buf_dsc,&argl))) )  		lib$signal(status);             va_end((char *) msgdsc);  O 	if ( !(1 & (status = netio_write(ctx->pop3ctx$l_chan,&buf_dsc,1,NULL,NULL))) )  		return	status;   	if ( ctx->pop3ctx$v_debug )& 		spop3__log(ctx,POP3_DEBUG,&buf_dsc);   	return	SS$_NORMAL;  }      int     spop3__chkid       (+         struct dsc$descriptor_s *dsc$right, %                 int              uic,  		unsigned	*id                         )  { " int     status,uai_id,context = 0;	 struct  {          union uicdef uai_uic;          int     mbz;         } holder = {uic,0};     
         /*9         ** Convert VMS Right id from ASCII to Binary from 
         */F         if ( !(*id) && !(1 & (status = sys$asctoid(dsc$right,id,0))) )                 return  status;   
         /*0         ** Find for presence of right_id for UIC
         */J         while ( 1 & (status = sys$find_held(&holder,&uai_id,0,&context)) )$                 if ( *id == uai_id )                         break;  "         sys$finish_rdb (&context);           return  status;  }    int	pop3_user	(  		POP3CTX	*ctx,  		unsigned char	*arg,  		unsigned short	 arglen 			) {  int	status;    	/* B 	** Don't allow to change usernames if the session has been opened 	*/	0 	if ( ctx->pop3ctx$l_level == POP3LVL$K_LOGGED )! 		return	pop3__send(ctx,&dsc_OK);    	/* Q 	** Check gotten username length, SYSUAF's username length is up to 12 characters  	*/  	if ( arglen > 12 ) / 		return	pop3__send(ctx,&dsc_INVARGLEN,arglen);  	else if ( !arglen || !arg )$ 		return	pop3__send(ctx,&dsc_NOARG);   	/* ( 	** Store username for future processing 	*/ K 	memcpy(ctx->pop3ctx$t_uname,arg,min(sizeof(ctx->pop3ctx$t_uname),arglen)); . 	ctx->pop3ctx$b_ulen	= (unsigned char) arglen;  	for (int  i = 0;i < arglen;i++)= 		ctx->pop3ctx$t_uname[i] = tolower(ctx->pop3ctx$t_uname[i]);    	/* $ 	** Send a prompt for password input 	*/ ; 	return  pop3__send(ctx,&dsc_PASSREQ,&ctx->pop3ctx$b_ulen);  }      int	pop3_pass	(  		POP3CTX	*ctx,  		unsigned char	*arg,  		unsigned short	 arglen 			) {  int	status,uai_flags,  	uai_pwd[2], putative_pw[2],. 	uai_expire_date[2],lgi_time[2],delta_time[2]; union   uicdef uai_uic; & int     uai_salt = 0, uai_encrypt = 0;) char	buf[1024],usr_buf[32],node_buf [32];  short	authlen,buflen;   7 struct dsc$descriptor buf_dsc,usr_dsc,pwd_dsc,node_dsc;    ile3	get_itmlst[] = { 4 	{4,     UAI$_FLAGS,             &uai_flags,     0},4 	{1,     UAI$_ENCRYPT,           &uai_encrypt,   0},4 	{2,     UAI$_SALT,              &uai_salt,      0},5 	{8,     UAI$_PWD,               &uai_pwd,        0}, 5 	{8,     UAI$_EXPIRATION,        &uai_expire_date,0}, ' 	{4,     UAI$_UIC,		&uai_uic,       0},  	{0, 0, 0, 0}};    ile3	set_itmlst[] = { 4 	{8,     UAI$_LASTLOGIN_N,       &lgi_time,      0}, 	{0, 0, 0, 0}};      	if ( !arglen || !arg ) $ 		return	pop3__send(ctx,&dsc_NOARG);  > 	INIT_SDESC(buf_dsc,ctx->pop3ctx$b_ulen,ctx->pop3ctx$t_uname);1 	INIT_SDESC(usr_dsc,ctx->pop3ctx$b_ulen,usr_buf);   	INIT_SDESC(pwd_dsc,arglen,arg);  ! 	INIT_SDESC(node_dsc,0,node_buf); 7 	node_dsc.dsc$w_length	= sprintf(node_buf,"POP3::%.*s", + 		ctx->pop3ctx$b_alen,ctx->pop3ctx$t_addr);   7 	if ( !(1 & (status = str$upcase(&usr_dsc,&buf_dsc))) )  		lib$signal(status);   7 	if ( !(1 & (status = str$upcase(&pwd_dsc,&pwd_dsc))) )  		lib$signal(status);  	  	/* & 	** Get login time for future checking 	*/ / 	if ( !(1 & (status = sys$gettim(&lgi_time))) )  		lib$signal(status);    	/* 5 	** Find & get user's record from SYSUAF.DAT & check:  	** / 	**      - Disabled Account & Restricted flags, % 	**      - Expiration date of account  	**  	*/ C 	status = sys$getuai(EFN$C_ENF, 0, &usr_dsc, &get_itmlst, 0, 0, 0);  	if ( status == RMS$_RNF ) 		{ > 		sys$scan_intrusion (SS$_NOSUCHUSER,&usr_dsc,JPI$K_NETWORK,0, 				&node_dsc,&usr_dsc,0,0,0,0, - 				CIA$M_IGNORE_RETURN|CIA$M_REAL_USERNAME); ! 		spop3__log(ctx,SS$_NOSUCHUSER); ' 		return	pop3__send(ctx,&dsc_ERRLOGIN);  		}  	else if ( !(1 & status) ) 		{ % 		spop3__log(ctx,POP3_GENERR,status); ' 		return	pop3__send(ctx,&dsc_ERRLOGIN);  		}     6 	if ( (!uai_expire_date[0]) && (!uai_expire_date[1]) )/ 		uai_expire_date[0] = uai_expire_date[1] = -1;    	/* : 	** Check DisUser+NoMail flags and account expiration date 	*/ 2 	if ( uai_flags & (UAI$M_DISACNT | UAI$M_NOMAIL) ) 		status = LGI$_DISUSER; 	else	{ ? 		status = lib$sub_times (uai_expire_date,lgi_time,delta_time); = 		status = (status == LIB$_NEGTIM)?LGI$_ACNTEXPIR:SS$_NORMAL;  		}            if ( !(1 & status )) 		{ 6 		sys$scan_intrusion (status,&usr_dsc,JPI$K_NETWORK,0,& 				&node_dsc,&usr_dsc,0,&pwd_dsc,0,0,- 				CIA$M_IGNORE_RETURN|CIA$M_REAL_USERNAME); % 		spop3__log(ctx,POP3_GENERR,status); ' 		return	pop3__send(ctx,&dsc_ERRLOGIN);                  }    	/* H 	** Now hash the putative password to see if it matches the one on file. 	*/ H 	if ( !(1 & (status = sys$hash_password(&pwd_dsc, uai_encrypt, uai_salt, 			&usr_dsc,putative_pw))) ) 		lib$signal(status);   H 	if ( (putative_pw[0] != uai_pwd[0]) || (putative_pw[1] != uai_pwd[1]) )                 { ; 		sys$scan_intrusion (LGI$_INVPWD,&usr_dsc,JPI$K_NETWORK,0, & 				&node_dsc,&usr_dsc,0,&pwd_dsc,0,0,- 				CIA$M_IGNORE_RETURN|CIA$M_REAL_USERNAME);  		spop3__log(ctx,LGI$_INVPWD);' 		return	pop3__send(ctx,&dsc_ERRLOGIN);  		}    	/* 6 	** Set last non-interactive login time in SYSUAF.DAT. 	*/  /*L 	if ( !(1 & (status = sys$setuai(EFN$C_ENF,0,&usr_dsc,&set_itmlst,0,0,0))) ) 		{ % 		spop3__log(ctx,POP3_GENERR,status); ' 		return	pop3__send(ctx,&dsc_ERRLOGIN);  		}  */   	/* ! 	** Is this user is under debug ?  	*/ H 	if ( 1 & spop3__chkid(&pop3_iddebug,uai_uic.uic$l_uic,&pop3_iddebug_) ) 		ctx->pop3ctx$v_debug	= 1;    	/*  	** Mail retention ? 	*/ J 	if ( 1 & spop3__chkid(&pop3_idexpire,uai_uic.uic$l_uic,&pop3_idexpire_) ) 		ctx->pop3ctx$l_expire	= 0;% 	else	ctx->pop3ctx$l_expire	= expire;    	/* & 	** Open & initialize maildrop context 	*/ ) 	ctx->pop3ctx$l_level	= POP3LVL$K_LOGGED; 2 	spop3__log(ctx,POP3_SOPENED,vmail_init_ctx(ctx));  K 	return	pop3__send(ctx,&dsc_LOGGED,ctx->pop3ctx$b_idx,&ctx->pop3ctx$b_ulen, 1 				&ctx->pop3ctx$b_alen,ctx->pop3ctx$l_mlistsz);  }      int	pop3_noop	(  		POP3CTX	*ctx,  		unsigned char	*arg,  		unsigned short	 arglen 			) { K 	return  pop3__send(ctx,&dsc_ALIVE,ctx->pop3ctx$b_idx,&ctx->pop3ctx$b_ulen,  			&ctx->pop3ctx$b_alen);  }    int	pop3_quit	(  		POP3CTX	*ctx,  		unsigned char	*arg,  		unsigned short	 arglen 			) {  	/* 9 	** If session has not been opened send a short "goodbye"  	*/ 1 	if ( ctx->pop3ctx$l_level == POP3LVL$K_INITIAL )  		{  		pop3__send(ctx,&dsc_IQUIT);  		return	SS$_DISCONNECT; 		}    	/* 3 	** Session has been opened - send a some statistic  	*/ H 	pop3__send(ctx,&dsc_LQUIT,ctx->pop3ctx$l_mlistsz-ctx->pop3ctx$l_mdeltd,+ 			ctx->pop3ctx$b_idx,&ctx->pop3ctx$b_ulen, .                         &ctx->pop3ctx$b_alen);   	return	SS$_DISCONNECT;  }      int	pop3_uidl	(  		POP3CTX	*ctx,  		unsigned char	*arg,  		unsigned short	 arglen 			) {  unsigned	msg = 0;   MHDR *mp = ctx->pop3ctx$a_mlist;   	/* # 	** Get message number if presented  	*/  	if ( arglen && arg )  		{  		lib$cvt_dtb(arglen,arg,&msg);  		 		/*& 		** Check that message in legal range 		*// 		if ( !msg || (msg > ctx->pop3ctx$l_mlistsz) ) D 			return  pop3__send(ctx,&dsc_OUTRANGE,msg,ctx->pop3ctx$l_mlistsz); 		}    	/* # 	** UIDL for the particular message  	*/  	if ( msg )  		{    		/*# 		** Try to jump to nearest message  		*/M 		if ( ctx->pop3ctx$a_mlast && (msg >= ctx->pop3ctx$a_mlast->mhdr$l_messid) )  			mp = ctx->pop3ctx$a_mlast;    		/*2 		** Run over the list to find message with the id 		*/> 		for(;mp && (mp->mhdr$l_messid != msg);mp = mp->mhdr$a_next);   		if ( !mp )- 			return	pop3__send(ctx,&dsc_NOSUCHMSG,msg);    		if ( mp->mhdr$v_deleted ) ' 			return	pop3__send(ctx,&dsc_DELETED);    		/*, 		** Store pointer to last processed message 		*/ 		ctx->pop3ctx$a_mlast	= mp;  J 		return	pop3__send(ctx,&dsc_UIDL1,mp->mhdr$l_messid,&ctx->pop3ctx$b_ulen,+ 				mp->mhdr$l_date[1],mp->mhdr$l_date[0]);  		}      	/*  	** UIDL for whole list  	*/  	pop3__send(ctx,&dsc_OK);  	for(;mp;mp = mp->mhdr$a_next) 		{  		if ( mp->mhdr$v_deleted )  			continue;  C 		pop3__send(ctx,&dsc_UIDLX,mp->mhdr$l_messid,&ctx->pop3ctx$b_ulen, + 				mp->mhdr$l_date[1],mp->mhdr$l_date[0]);  		} ! 	return	pop3__send(ctx,&dsc_DOT);  }    int	pop3_dele	(  		POP3CTX	*ctx,  		unsigned char	*arg,  		unsigned short	 arglen 			) {  unsigned	msg = 0;   MHDR *mp = ctx->pop3ctx$a_mlist;   	if ( !arglen || !arg ) $ 		return	pop3__send(ctx,&dsc_NOARG);   	/* # 	** Get message number if presented  	*/  	lib$cvt_dtb(arglen,arg,&msg);   	/* % 	** Check that message in legal range  	*/ . 	if ( !msg || (msg > ctx->pop3ctx$l_mlistsz) )B 		return	pop3__send(ctx,&dsc_OUTRANGE,msg,ctx->pop3ctx$l_mlistsz);   	/* " 	** Try to jump to nearest message 	*/ L 	if ( ctx->pop3ctx$a_mlast && (msg >= ctx->pop3ctx$a_mlast->mhdr$l_messid) ) 		mp = ctx->pop3ctx$a_mlast;   	/* # 	** DELEting the particular message  	*/ = 	for(;mp && (mp->mhdr$l_messid != msg);mp = mp->mhdr$a_next);    	if ( !mp ) , 		return	pop3__send(ctx,&dsc_NOSUCHMSG,msg);   	if ( mp->mhdr$v_deleted )+ 		return	pop3__send(ctx,&dsc_HASDELTD,msg);    	/* D 	** Mark the message as DELTED for future deletion at end of session 	*/  	mp->mhdr$v_deleted	= 1;   	/* + 	** Store pointer to last processed message  	*/  	ctx->pop3ctx$a_mlast	= mp;    	/* ! 	** Increment deleted mails count  	*/  	ctx->pop3ctx$l_mdeltd++; + 	ctx->pop3ctx$l_mlines	-= mp->mhdr$l_lines;   ) 	return	pop3__send(ctx,&dsc_DELETED,msg);  }      int	pop3_stat	(  		POP3CTX	*ctx,  		unsigned char	*arg,  		unsigned short	 arglen 			) { O 	return	pop3__send(ctx,&dsc_STATM,ctx->pop3ctx$l_mlistsz-ctx->pop3ctx$l_mdeltd, + 			ctx->pop3ctx$l_mlines*SPOP3__$K_LINESZ);  }      int	pop3_list	(  		POP3CTX	*ctx,  		unsigned char	*arg,  		unsigned short	 arglen 			) {  unsigned	msg = 0;   MHDR *mp = ctx->pop3ctx$a_mlist;   	/* # 	** Get message number if presented  	*/  	if ( arglen && arg )  		{  		lib$cvt_dtb(arglen,arg,&msg);  		 		/*& 		** Check that message in legal range 		*// 		if ( !msg || (msg > ctx->pop3ctx$l_mlistsz) ) D 			return  pop3__send(ctx,&dsc_OUTRANGE,msg,ctx->pop3ctx$l_mlistsz); 		}    	/* # 	** LIST for the particular message  	*/  	if ( msg )  		{  		/*# 		** Try to jump to nearest message  		*/M 		if ( ctx->pop3ctx$a_mlast && (msg >= ctx->pop3ctx$a_mlast->mhdr$l_messid) )  			mp = ctx->pop3ctx$a_mlast;    		/*2 		** Run over the list to find message with the id 		*/> 		for(;mp && (mp->mhdr$l_messid != msg);mp = mp->mhdr$a_next);   		if ( !mp )- 			return	pop3__send(ctx,&dsc_NOSUCHMSG,msg);    		if ( mp->mhdr$v_deleted ) ' 			return	pop3__send(ctx,&dsc_DELETED);    		/*, 		** Store pointer to last processed message 		*/ 		ctx->pop3ctx$a_mlast	= mp;  X 		return	pop3__send(ctx,&dsc_LIST1,mp->mhdr$l_messid,mp->mhdr$l_lines*SPOP3__$K_LINESZ); 		}      	/* # 	** LIST for whole list of messages  	*/ H 	pop3__send(ctx,&dsc_LISTF,ctx->pop3ctx$l_mlistsz-ctx->pop3ctx$l_mdeltd,+ 			ctx->pop3ctx$l_mlines*SPOP3__$K_LINESZ);  	for(;mp;mp = mp->mhdr$a_next) 		{  		if ( mp->mhdr$v_deleted )  			continue;  Q 		pop3__send(ctx,&dsc_LISTX,mp->mhdr$l_messid,mp->mhdr$l_lines*SPOP3__$K_LINESZ);  		} ! 	return	pop3__send(ctx,&dsc_DOT);  }      int	pop3_rset	(  		POP3CTX	*ctx,  		unsigned char	*arg,  		unsigned short	 arglen 			) {  unsigned	msg = 0;   MHDR *mp = ctx->pop3ctx$a_mlist;   	/* , 	** UnDELEting all marked for death messages 	*/ < 	for(;mp && (mp->mhdr$l_messid != msg);mp = mp->mhdr$a_next) 		{  		if ( mp->mhdr$v_deleted )  			{ 			mp->mhdr$v_deleted	= 0;   			/* # 			** Increment deleted mails count  			*/  			ctx->pop3ctx$l_mdeltd--; - 			ctx->pop3ctx$l_mlines	+= mp->mhdr$l_lines;  			} 		}   a 	return	pop3__send(ctx,&dsc_RSETM,ctx->pop3ctx$l_mlistsz,ctx->pop3ctx$l_mlines*SPOP3__$K_LINESZ);  }      int	pop3_retr	(  		POP3CTX	*ctx,  		unsigned char	*arg,  		unsigned short	 arglen 			) { + unsigned	status = MAIL$_NOMOREREC, msg = 0;   MHDR *mp = ctx->pop3ctx$a_mlist; unsigned char	buf[4096]; struct dsc$descriptor buf_dsc;   	if ( !arglen || !arg ) $ 		return	pop3__send(ctx,&dsc_NOARG);   	/* # 	** Get message number if presented  	*/  	lib$cvt_dtb(arglen,arg,&msg);   	/* ( 	** Check that message is in legal range 	*/ . 	if ( !msg || (msg > ctx->pop3ctx$l_mlistsz) )B 		return	pop3__send(ctx,&dsc_OUTRANGE,msg,ctx->pop3ctx$l_mlistsz);   	/* " 	** Try to jump to nearest message 	*/ L 	if ( ctx->pop3ctx$a_mlast && (msg >= ctx->pop3ctx$a_mlast->mhdr$l_messid) ) 		mp = ctx->pop3ctx$a_mlast;   	/* " 	** FINDing the particular message 	*/ = 	for(;mp && (mp->mhdr$l_messid != msg);mp = mp->mhdr$a_next);    	if ( !mp ) , 		return	pop3__send(ctx,&dsc_NOSUCHMSG,msg);   	if ( mp->mhdr$v_deleted )+ 		return	pop3__send(ctx,&dsc_HASDELTD,msg);    	/* + 	** Store pointer to last processed message  	*/  	ctx->pop3ctx$a_mlast	= mp; > 	pop3__send(ctx,&dsc_RETRM,mp->mhdr$l_lines*SPOP3__$K_LINESZ);   	/* M 	** If it's DECNET mail form a pseudo-internet header and send it before body  	*/  	if ( mp->mhdr$v_decnet )  		{  		/*2 		** <From: !AS!/Date: !%D!/To: !AC!/Subject: !AC> 		*/C 		pop3__send(ctx,&dsc_DNETHDR,&mp->mhdr$b_fromlen,&mp->mhdr$l_date, 3 			&mp->mhdr$b_tolen,&mp->mhdr$b_subjlen,&charset);  		}		     % 	INIT_SDESC(buf_dsc,sizeof(buf),buf); ) 	for (int i = 0;i < mp->mhdr$l_lines;i++)  		{ Y 		if ( !(1 & (status = vmail_get_msg(ctx,mp,!i,buf,sizeof(buf),&buf_dsc.dsc$w_length))) ) 	 			break;  		 		/*K 		** If buffer contains a just dot (".", 0x2E), replace it with <dot+space>  		*/7 		if ( (buf_dsc.dsc$w_length == 1) && (buf[0] == '.') ) % 			buf[buf_dsc.dsc$w_length++]	= ' ';   P 		if ( !(1 & (status = netio_write(ctx->pop3ctx$l_chan,&buf_dsc,1,NULL,NULL))) )	 			break;   % 		buf_dsc.dsc$w_length	= sizeof(buf);  		}   4 	if ( !(1 & status) && (status != MAIL$_NOMOREREC) )% 		spop3__log(ctx,POP3_GENERR,status);      	/* @ 	** Close message retrievibng context and mark message as "sent" 	*/  	vmail_msg_end(ctx,mp);    	mp->mhdr$v_sent	|= 1;  ! 	return	pop3__send(ctx,&dsc_EOM);  }    int	pop3_top	( 		POP3CTX	*ctx,  		unsigned char	*arg,  		unsigned short	 arglen 			) { 6 unsigned	status = MAIL$_NOMOREREC, msg = 0, lines = 0;  MHDR *mp = ctx->pop3ctx$a_mlist; unsigned char	buf[4096]; struct dsc$descriptor buf_dsc;   	if ( !arglen || !arg ) $ 		return	pop3__send(ctx,&dsc_NOARG);   	/* * 	** Get message number and number of lines 	*/  	*(arg + arglen) = '\0';, 	if ( 2 != sscanf(arg,"%u %u",&msg,&lines) )$ 		return	pop3__send(ctx,&dsc_NOARG);   	/* % 	** Check that message in legal range  	*/ . 	if ( !msg || (msg > ctx->pop3ctx$l_mlistsz) )B 		return	pop3__send(ctx,&dsc_OUTRANGE,msg,ctx->pop3ctx$l_mlistsz);   	/* " 	** Try to jump to nearest message 	*/ L 	if ( ctx->pop3ctx$a_mlast && (msg >= ctx->pop3ctx$a_mlast->mhdr$l_messid) ) 		mp = ctx->pop3ctx$a_mlast;   	/* " 	** FINDing the particular message 	*/ = 	for(;mp && (mp->mhdr$l_messid != msg);mp = mp->mhdr$a_next);    	if ( !mp ) , 		return	pop3__send(ctx,&dsc_NOSUCHMSG,msg);   	if ( mp->mhdr$v_deleted )+ 		return	pop3__send(ctx,&dsc_HASDELTD,msg);    	/* + 	** Store pointer to last processed message  	*/  	ctx->pop3ctx$a_mlast	= mp;  	pop3__send(ctx,&dsc_OK);    	/* M 	** If it's DECNET mail form a pseudo-internet header and send it before body  	*/  	if ( mp->mhdr$v_decnet )  		{  		/*2 		** <From: !AS!/Date: !%D!/To: !AC!/Subject: !AC> 		*/C 		pop3__send(ctx,&dsc_DNETHDR,&mp->mhdr$b_fromlen,&mp->mhdr$l_date, 3 			&mp->mhdr$b_tolen,&mp->mhdr$b_subjlen,&charset);  		}		   % 	INIT_SDESC(buf_dsc,sizeof(buf),buf); 7 	for (int i = 0;i < (lines?lines:mp->mhdr$l_lines);i++)  		{ Y 		if ( !(1 & (status = vmail_get_msg(ctx,mp,!i,buf,sizeof(buf),&buf_dsc.dsc$w_length))) ) 	 			break;    		/*, 		** If lines is ZERO we sending only header 		*/? 		if ( !lines && (!buf_dsc.dsc$w_length || mp->mhdr$v_decnet) ) 	 			break;    		/*K 		** If buffer contains a just dot (".", 0x2E), replace it with <dot+space>  		*/7 		if ( (buf_dsc.dsc$w_length == 1) && (buf[0] == '.') ) % 			buf[buf_dsc.dsc$w_length++]	= ' ';   P 		if ( !(1 & (status = netio_write(ctx->pop3ctx$l_chan,&buf_dsc,1,NULL,NULL))) )	 			break;   % 		buf_dsc.dsc$w_length	= sizeof(buf);  		}   4 	if ( !(1 & status) && (status != MAIL$_NOMOREREC) )% 		spop3__log(ctx,POP3_GENERR,status);    	/* @ 	** Close message retrievibng context and mark message as "sent" 	*/  	vmail_msg_end(ctx,mp);    	mp->mhdr$v_sent	|= 1;  ! 	return	pop3__send(ctx,&dsc_EOM);  }    int	pop3_capa	(  		POP3CTX	*ctx,  		unsigned char	*arg,  		unsigned short	 arglen 			) {  	if ( ctx->pop3ctx$l_expire ) B 		return	pop3__send(ctx,&dsc_CAPA,logintvl,ctx->pop3ctx$l_expire);  , 	return	pop3__send(ctx,&dsc_CAPA2,logintvl); }    int	pop3_last	(  		POP3CTX	*ctx,  		unsigned char	*arg,  		unsigned short	 arglen 			) { $ unsigned	status, msg = 0, lines = 0;  MHDR *mp = ctx->pop3ctx$a_mlist; unsigned char	buf[1024]; struct dsc$descriptor buf_dsc;   	/* < 	** Return to client a number last has beed accessed message 	*/ ] 	return	pop3__send(ctx,&dsc_LAST,ctx->pop3ctx$a_mlast?ctx->pop3ctx$a_mlast->mhdr$l_messid:0);  }     # void *	spop3__thread	(POP3CTX	*ctx)  {  int	status,st; unsigned char	buf[255];   struct dsc$descriptor_s buf_dsc; struct pop3cmd	*cmdp;    	//spop3__log(ctx,POP3_OPENED);    	/*  	** Print out WELCOME message  	*/ ' 	status = pop3__send(ctx,&dsc_WELCOME);    	/* ( 	** Main session command processing loop 	*/  	while ( 1 & status )  		{  		/*0 		** Start reading a command from network client 		*/& 		INIT_SDESC(buf_dsc,sizeof(buf),buf);f 		if ( !(1 & (status = netio_read(ctx->pop3ctx$l_chan,&buf_dsc,&buf_dsc.dsc$w_length,1,&iotmo,0,0))) )	 			break;    		/*, 		** Log an input if the session under DEBUG 		*/ 		if ( ctx->pop3ctx$v_debug ) ' 			spop3__log(ctx,POP3_DEBUG,&buf_dsc);    		/*4 		** Run over command table to match gottent command 		*/0 		for ( cmdp = &pop3cmd_tbl[0];cmdp->fun;cmdp++) 			{ 			/* 4 			** Check that current session level is enough for2 			** the command, if not - just skip the command. 			*/ - 			if ( ctx->pop3ctx$l_level != cmdp->level ) 
 				continue;   0 			if ( (buf_dsc.dsc$w_length >= cmdp->clen) && 0 				(!strncasecmp(cmdp->cname,buf,cmdp->clen)) ) 				{  				/*% 				** Dispatch processing of command  				*/ 				status = cmdp->fun(ctx, C 					(buf_dsc.dsc$w_length > cmdp->clen)?buf + cmdp->clen + 1:NULL, N 					(buf_dsc.dsc$w_length > cmdp->clen)?buf_dsc.dsc$w_length-cmdp->clen-1:0);
 				break; 				}  			} 		/*1 		** A command has not been recognized - log this  		*/ 		if ( !cmdp->fun )  			{1 			status = pop3__send(ctx,&dsc_BADCMD,&buf_dsc); ( 			spop3__log(ctx,POP3_ILLCMD,&buf_dsc); 			} 		}; /* while (...) */   	/*  	** Close network stuff  	*/ 7 	if ( !(1 & (st = netio_close (ctx->pop3ctx$l_chan))) ) ! 		spop3__log(ctx,POP3_GENERR,st);    	/*  	** Check a completion status  	*/   	if ( status != SS$_DISCONNECT )% 		spop3__log(ctx,POP3_CLOSED,status);    	/* 4 	** Mark context as "terminated and to be cleanuped" 	*/  	ctx->pop3ctx$v_termd	= 1;  
         /*5         ** Stop sleeping, there is something to do!!! 
         */         sys$wake(0,0);   	pthread_exit(&status); 
 	return	NULL;  }      /* **++ **  FUNCTIONAL DESCRIPTION:  **O **      Send SHUTDON signal. A target(s) node(s) designated by input parameter: 2 **	*	- shutdown SPOP3 server at all cluster member0 **	<node>	- shutdown SPOP3 server at target node **	  ** **  FORMAL PARAMETERS: **
 **      None.  ** **  RETURN VALUE:  ** **      VMS Condition code ** ** **-- */ int	spop3__shut	(  		unsigned	char	*nodemask  			) {   int	status,csid = -1,retlen = 0; lksb    lksb_; iosb    iosb_; char	buf [ 32 ], res [32] ;  struct dsc$descriptor res_dsc;G ile3    items [] = {{sizeof(buf),SYI$_NODENAME,buf,&retlen},{0,0,0,0}};   % 	INIT_SDESC(res_dsc,sizeof(res),res);    	/* # 	** Send signal to a specified node  	*/  	if ( *nodemask	!= '*' ) 		{ S 		if ( !(1 & (status = sys$fao(&resfao,&res_dsc.dsc$w_length,&res_dsc,nodemask))) ) $                 	lib$signal(status);  8 		if ( !(1 & (status = str$upcase(&res_dsc,&res_dsc))) ) 			lib$signal(status);   		/*% 		** We send a signal by $ENQ request  		*/@ 		if ( (1 & (status = sys$enqw (EFN$C_ENF, LCK$K_EXMODE, &lksb_,* 				LCK$M_SYSTEM,&res_dsc,0,0,0,0,0,0))) )- 			status = sys$deq(lksb_.lksb$l_lkid,0,0,0);   1 		spop3__log(NULL,POP3_SENTSHUT,&res_dsc,status);  		return	status; 		}    	/* = 	** If nodemask is "*" - send shutdown signal to  all cluster  	** members  	*/ I 	while ( (1 & (status = sys$getsyiw(EFN$C_ENF,&csid,0,items,&iosb_,0,0))) .                 && (1 & iosb_.iosb$w_status) ) 		{  		buf [ retlen ] = '\0';N 		if ( !(1 & (status = sys$fao(&resfao,&res_dsc.dsc$w_length,&res_dsc,buf))) )$                 	lib$signal(status);  8 		if ( !(1 & (status = str$upcase(&res_dsc,&res_dsc))) ) 			lib$signal(status);   		/*% 		** We send a signal by $ENQ request  		*/@ 		if ( (1 & (status = sys$enqw (EFN$C_ENF, LCK$K_EXMODE, &lksb_,* 				LCK$M_SYSTEM,&res_dsc,0,0,0,0,0,0))) )- 			status = sys$deq(lksb_.lksb$l_lkid,0,0,0);   1 		spop3__log(NULL,POP3_SENTSHUT,&res_dsc,status);  		}      	return	status;  }    int	evt_rtn_blkast	(void)  {  	exit_flag	= 1;          sys$wake(0,0); 	return	netio_close(mainchan); }     ! void  *	connection__thread	(void)  {  int	status,i = 0;  unsigned chan = 0; POP3CTX *newctx; struct	in_addr	addr;   	/*  	** A main loop  	*/  	while ( !exit_flag )  		{  		/*- 		** Start waiting for new connection request  		*/> 		if ( !(1 & (status = netio_accept (mainchan,&chan,&addr))) ) 			{ 			/*  			** Error checking.  			*/  			if ( status == SS$_CANCEL )
 				break; 			else	lib$signal(status);  			}   		/*6 		** Get a free connection/session context from a pool 		*/S 		for (newctx = NULL, i = 0; i < (sizeof(pop3ctx_tbl)/sizeof(pop3ctx_tbl[0])); i++)  			{K 			if ( !pop3ctx_tbl[i].pop3ctx$v_used && !pop3ctx_tbl[i].pop3ctx$v_termd )  				{  				newctx	= &pop3ctx_tbl[i]; 
 				break; 				}  			}   		if ( !newctx ) 			{# 			spop3__log(NULL,POP3_NOFREECTX); % 			netio_write(chan,&dsc_BUSY,1,0,0);  			netio_close(chan);  			continue; 			}   		/*% 		** Clear & Filling new context area  		*/# 		memset(newctx,0,sizeof(POP3CTX)); , 		newctx->pop3ctx$b_idx	= (unsigned char) i;  		newctx->pop3ctx$l_chan	= chan; 		newctx->pop3ctx$v_used	= 1;R`         	newctx->pop3ctx$b_alen  = (unsigned char) sprintf(newctx->pop3ctx$t_addr,"%u.%u.%u.%u",= 	                addr.S_un.S_un_b.s_b1,addr.S_un.S_un_b.s_b2,f>         	        addr.S_un.S_un_b.s_b3,addr.S_un.S_un_b.s_b4);   		/* 		** Start a worker thread 		*/q 		if ( status = pthread_create((pthread_t *)&newctx->pop3ctx$q_tid,&tattr,(void*) spop3__thread,(void *)newctx) )d 			{ 			/*SF 			** If error is occured close connection & return connection/session 			** area to the free" pool 			*/ 5 			spop3__log(NULL,POP3_ERRTHREAD, strerror(status));U 			netio_close(chan);3 			newctx->pop3ctx$v_used	= 0; 			} 		};   	pthread_exit(&status);i
 	return	NULL;	 }e   int	main	(int	argc,char **argv)s {e= int	status,i = 0, ret_code = 0,option =  LIB$K_DELTA_SECONDS,e
 	seconds = 0;* unsigned port = 0; POP3CTX *newctx; struct	in_addr	addr;	 char *cp;r lksb    lksb_; iosb    iosb_; pthread_t	tid; struct dsc$descriptor res_dsc;! unsigned char	buf[32],resbuf[32];gI ile3    items [] = {{sizeof(buf),SYI$_NODENAME,buf,&ret_code},{0,0,0,0}};e   	/*t 	** It's SHUT request ?o 	*/+2 	if ( argc == 3 && !strncasecmp("SHUT",argv[1],4)) 		return	spop3__shut(argv[2]); 	else if ( argc != 1 ) 		return	SS$_INVARG;   	/* < 	** Enqueue a LOCK request to listening for SHUTDOWN command 	**c 	*/<C 	if ( !(1 & (status = sys$getsyiw(EFN$C_ENF,0,0,items,&iosb_,0,0)))</                 || !(1 & iosb_.iosb$w_status) )f3 		sys$exit( 1 & status?iosb_.iosb$w_status:status);c   	buf [ ret_code ] = '\0';i  + 	INIT_SDESC(res_dsc,sizeof(resbuf),resbuf);dM 	if ( !(1 & (status = sys$fao(&resfao,&res_dsc.dsc$w_length,&res_dsc,buf))) )f#                	lib$signal(status);   @ 	if ( !(1 & (status = sys$enqw (EFN$C_ENF, LCK$K_CRMODE, &lksb_,K                         LCK$M_SYSTEM,&res_dsc,0,0,0,evt_rtn_blkast,0,0,0)))h! 		|| !(1 & lksb_.lksb$w_status) )c3 		sys$exit( 1 & status?lksb_.lksb$w_status:status);e   	/*f 	** Get configuration variables. 	*/ ! 	if ( cp = getenv("SPOP3_PORT") )/ 		port	= atoi(cp);  	port	= port?port:POP3__$K_PORT;  # 	if ( cp = getenv("SPOP3_EXPIRE") )a 		expire	= atoi(cp); 	else	expire	= POP3__$K_EXPIRE;\  % 	if ( cp = getenv("SPOP3_LOGINTVL") ); 		logintvl = atoi(cp);/ 	logintvl= logintvl?logintvl:POP3__$K_LOGINTVL;(    ) 	if ( cp = getenv("SPOP3_PR_THRESHOLD") )n 		pr_threshold = atoi(cp);  $ 	if ( cp = getenv("SPOP3_TIMEOUT") ) 		{? 		seconds = atoi(cp);(. 		seconds	= seconds?seconds:SPOP3__$K_TIMEOUT; 		}pK 	if ( !(1 & (status = lib$cvt_to_internal_time(&option,&seconds,&iotmo))) )M 		return  status;f  ' 	if ( !(cp = getenv("SPOP3_CHARSET")) )i 		cp	= "iso-8859-5";  - 	strncpy(&charset[1],cp,sizeof(charset) - 1);n> 	charset[0] = (unsigned char) strnlen(cp,sizeof(charset) - 1);   	/*  	** Initialize VMS MAIL APIn 	*/i& 	if ( !(1 & (status = vmail_init())) ) 		sys$exit(status);x  
         /*N         ** Initialize network socket to listening incomming connection request
         */<         if ( !(1 & (status = netio_start(&mainchan,port))) )#                 lib$signal(status);S   	/*(O 	** Initalize attributes for threads and multithreaded environment of the C RTLd 	*/_& 	decc$set_reentrancy(C$C_MULTITHREAD);  $ 	status = pthread_attr_init(&tattr);F 	status = pthread_attr_setdetachstate(&tattr,PTHREAD_CREATE_JOINABLE);2 	status = pthread_attr_setstacksize(&tattr,96000);   	/*R" 	** Start a main listetning thread 	*/sL 	if ( status = pthread_create(&tid,&tattr,(void*) connection__thread,NULL) ) 		{R 		netio_close(mainchan);; 		return	spop3__log(NULL,POP3_ERRTHREAD, strerror(status));S 		}t  ; 	spop3__log(NULL,POP3_STARTED,port,expire,logintvl,&iotmo);t   	/*B 	** A main loopD 	*/P 	do	{_ 		/*9 		** Performs a cleanuping terminated connections/threadsr 		*/D 		for (i = 0; i < (sizeof(pop3ctx_tbl)/sizeof(pop3ctx_tbl[0])); i++) 			{) 			if ( !pop3ctx_tbl[i].pop3ctx$v_termd )S
 				continue;V   			/*S* 			** Joining with the thread to detach it 			*/S\ 			if ( status = pthread_join((pthread_t) pop3ctx_tbl[i].pop3ctx$q_tid,(void *)&ret_code) ) A 				spop3__log(&pop3ctx_tbl[i],POP3_ERRTHREAD, strerror(status));s   			/*	& 			** Performs VMS Mail Box cleanuping 			*/!B 		        if ( !(1 & (status = vmail_shut_ctx(&pop3ctx_tbl[i]))) )3 				spop3__log(&pop3ctx_tbl[i],POP3_VMSHUT,status);S  ' 			if ( pop3ctx_tbl[i].pop3ctx$l_lkid )L1 				sys$deq(pop3ctx_tbl[i].pop3ctx$l_lkid,0,0,0);_   			/*+" 			** Mark context a "free to use" 			*/_F 			pop3ctx_tbl[i].pop3ctx$v_used	= pop3ctx_tbl[i].pop3ctx$v_termd = 0; 			}. 		} while ( !exit_flag && (1 & sys$hiber()) );   	/*U  	** Close main connection socket 	*/i> 	if ( !(1 & (status = netio_close (mainchan))) && !exit_flag )#                 lib$signal(status);+   	/*b+ 	** Joining with the main connection threadY 	*//5 	if ( status = pthread_join(tid,(void *)&ret_code) ) "4 		spop3__log(NULL,POP3_ERRTHREAD, strerror(status));    	/*6 	** Performs a cleanuping running & terminated threads 	*/NC 	for (i = 0; i < (sizeof(pop3ctx_tbl)/sizeof(pop3ctx_tbl[0])); i++)E 		{k& 		if ( !pop3ctx_tbl[i].pop3ctx$v_termd& 			|| !pop3ctx_tbl[i].pop3ctx$v_used ) 			continue;   		/*) 		** Joining with the thread to detach itg 		*/[ 		if ( status = pthread_join((pthread_t) pop3ctx_tbl[i].pop3ctx$q_tid,(void *)&ret_code) ) n@ 			spop3__log(&pop3ctx_tbl[i],POP3_ERRTHREAD, strerror(status));   		/*% 		** Performs VMS Mail Box cleanuping* 		*/: 		if ( !(1 & (status = vmail_shut_ctx(&pop3ctx_tbl[i]))) )2 			spop3__log(&pop3ctx_tbl[i],POP3_VMSHUT,status);  & 		if ( pop3ctx_tbl[i].pop3ctx$l_lkid )0 			sys$deq(pop3ctx_tbl[i].pop3ctx$l_lkid,0,0,0); 		}3   	return	exit_flag; }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             