0 #pragma	module SPOP3_VMSMAIL	"SPOP3_VMSMAIL-1-C"" #define	__MODULE__	"SPOP3_VMSMAIL"   /* **++. **  FACILITY:  StarLet POP3 Server for OpenVMS ** **  MODULE DESCRIPTION:  **S **      This module contains a routine set which covers VMS MAIL API functionality.  ** **  AUTHORS: ** **      Ruslan R. Laishev  ** **  CREATION DATE: 30-JUL-2005 **R **	25-AUG-2005	RRL	Added additional error conditiona handling into vmail_get_msg()7 **				Fixed logic bug in message expiration processing. S **	26-AUG-2005	RRL	Added informational messages into vmail_init_ctx/vmail_shut_ctx. A **	30-AUG-2005	RRL	Fixed problem with reseting of new mail count. Z **	 1-SEP-2005	RRL	Disabled temporary PURGE/RECLAIM of MAIL.MAI, only purging WASTEBACKET,) **				added pr_threshold global variable; ? **				added controling of access to a user's mailbox with LOCK. J **	 3-SEP-2005	RRL	Fixed MAIL$_INVITMLEN (8290682) in the vmail_get_msg()./ **	 6-SEP-2005	RRL	Fixed PURGE/RECLAIM problem. D **	25-JAN-2006	RRL	Added mutex to ordering access to MAIL$ routines. ** **  MODIFICATION HISTORY:  **
 **	[@tbs@]...  **-- */   /* ** **  INCLUDE FILES  ** */ #include	<starlet.h>   #include	<ssdef.h>   #include	<maildef.h>   #include	<mailmsgdef.h>  #include	<mail$routines.h> #include	<string.h>  #include	<stdio.h> #include	<descrip.h> #include	<iledef.h>  #include	<lgidef.h>  #include	<fibdef.h>  #include	<iodef.h> #include	<iosbdef.h> #include	<uicdef.h>  #include	<lib$routines.h>  #include	<chfdef.h>  #include	<efndef.h>  #include	<libvmdef.h>  #include	<libdtdef.h>  #include	<convdef.h> #include	<conv$routines.h> #include	<lksbdef.h> #include	<lckdef.h>  #include	<lkidef.h>  #include	<pthread.h>     //#include	<dqfdef.h>    #define	__NEW_STARLET	1  #include	<rms.h> #include	"spop3def.h"  #include	"spop3_msg.h"  F #define	INIT_SDESC(dsc, len, ptr) {(dsc).dsc$b_dtype = DSC$K_DTYPE_T;\H 	(dsc).dsc$b_class = DSC$K_CLASS_S; (dsc).dsc$w_length = (short) (len);\ 	(dsc).dsc$a_pointer = (ptr);}    % #define min(x,y)        ((x > y)?y:x) % #define max(x,y)        ((x < y)?y:x)   ; const ile3	nullist [] = {{0,MAIL$_NOSIGNAL,0,0},{0,0,0,0}};   $ extern int	debug_flag, pr_threshold;b #define DEBUG   if(debug_flag)printf("%-24.24s:%-08.0u ",__MODULE__,__LINE__);if(debug_flag)printf     int	spop3__log	(); /*: ** A mutex to controlling ordered access to MAIL$ routines */5 pthread_mutex_t	mail_mtx = PTHREAD_MUTEX_INITIALIZER;    /* **++ **  FUNCTIONAL DESCRIPTION:  **& **      Initalize Virtual Memory ZONE. ** **  FORMAL PARAMETERS: ** **	None. ** **  RETURN VALUE:  ** **      VMS condition code ** **-- */  , $DESCRIPTOR(VMZoneName_MHDR,"Mail Headers"); int     VMZoneId_MHDR;   int	vmail_init	(void)  { & int     status,VMZoneBlockSz,VMZoneSz;  ) const int     VMZoneAlg = LIB$K_VM_FIXED, @         VMZoneFlags = LIB$M_VM_EXTEND_AREA | LIB$M_VM_GET_FILL0;  
         /*=         ** Initialize VM zone for 128 mail headers by default 
         */&         VMZoneBlockSz = sizeof (MHDR);-         VMZoneSz = (VMZoneBlockSz * 128)/512; J         if ( !(1 & (status = lib$create_vm_zone(&VMZoneId_MHDR,&VMZoneAlg," 				&VMZoneBlockSz,&VMZoneFlags,0,K                                 &VMZoneSz,0,0,0,0,&VMZoneName_MHDR,0,0))) ) #                 lib$signal(status);            return  status;  }      /* **++ **  FUNCTIONAL DESCRIPTION:  **T **      Initialize VMS MAIL contexts. Move all messages from NEWMAIL to MAIL folder,0 **	form a mail list by reading from MAIL folder. ** **  FORMAL PARAMETERS: ** **	ctx:		SPOP3 context area  ** **  RETURN VALUE:  ** **      VMS condition code ** **-- */ int	vmail_init_ctx	( 		POP3CTX	*ctx 			) {  int	status,st;: unsigned	userctx = 0,mailfile = 0,count = 0, newcount = 0; unsigned short  retlen = 0;  unsigned char	resname[32]; struct dsc$descriptor res_dsc; lksb    lksb_;   	/* ; 	** First at all get a lock to resources is associated with $ 	** VMS Mail box of particular user. 	*/ Q 	retlen = sprintf(resname,"SPOP3_%.*s",ctx->pop3ctx$b_ulen,ctx->pop3ctx$t_uname); $ 	INIT_SDESC(res_dsc,retlen,resname);@ 	if ( !(1 & (status = sys$enqw (EFN$C_ENF, LCK$K_EXMODE, &lksb_,T                                 LCK$M_SYSTEM | LCK$M_NOQUEUE,&res_dsc,0,0,0,0,0,0)))# 		|| !(1 & (lksb_.lksb$w_status)) )  		{ 6 		int msgvec[] = {1,status}; sys$putmsg(msgvec,0,0,0); 		sys$putmsg(msgvec,0,0,0);    		return	status; 		}   ) 	ctx->pop3ctx$l_lkid	= lksb_.lksb$l_lkid;    	/* @ 	** Get an user HOME Directory from the VMSMail profile datafile 	*/  	{ 	ile3	in_lst[] = {  F 		{ctx->pop3ctx$b_ulen, MAIL$_USER_USERNAME,ctx->pop3ctx$t_uname, 0},  		{0,MAIL$_NOSIGNAL,0,0}, 
 		{0,0,0,0}},  		in_lst2[] = { F 		{ctx->pop3ctx$b_ulen, MAIL$_USER_USERNAME,ctx->pop3ctx$t_uname, 0}, ; 		{sizeof(retlen), MAIL$_USER_SET_NEW_MESSAGES,&retlen, 0},  		{0,MAIL$_NOSIGNAL,0,0}, 
 		{0,0,0,0}},  		out_lst[] = { H 		{255, MAIL$_USER_FULL_DIRECTORY, &ctx->pop3ctx$t_maildir[1], &retlen}, 		{0,0,0,0}};    	/* @ 	** Get an USER's information from the VMSMAIL_PROFILE.DAT file: 	**	MAIL' home directory; # 	** Reset "NEW MAIL COUNT" to zero;  	*/  	pthread_mutex_lock(&mail_mtx);   @ 	if ( 1 & (status = mail$user_begin(&userctx,nullist,nullist)) ) 		{ 9 		status = mail$user_get_info(&userctx,&in_lst,&out_lst); 5 		ctx->pop3ctx$t_maildir[0]	= (unsigned char) retlen;   
 		retlen	= 0;   D 		if ( !(1 & (st = mail$user_set_info(&userctx,&in_lst2,nullist))) )5 			{int msgvec[] = {1,st}; sys$putmsg(msgvec,0,0,0);}   ? 		if ( !(1 & (st = mail$user_end (&userctx,nullist,nullist))) ) 5 			{int msgvec[] = {1,st}; sys$putmsg(msgvec,0,0,0);}  		}   ! 	pthread_mutex_unlock(&mail_mtx);    	if ( !(1 & status) )  		return	status; 	}   	/* 1 	** Open a MAIL.MAI in the user's home directory,  	** create a mailfile context  	*/  	{ 	ile3	in_lst[] = {  S 		{ctx->pop3ctx$t_maildir[0], MAIL$_MAILFILE_NAME, &ctx->pop3ctx$t_maildir[1], 0},   		{0,MAIL$_NOSIGNAL,0,0}, 
 		{0,0,0,0}};    	pthread_mutex_lock(&mail_mtx);   H 	if ( (1 & (status = mail$mailfile_begin (&mailfile,nullist,nullist))) )H 		if ( !(1 & (status = mail$mailfile_open (&mailfile,in_lst,nullist))) ) 			{G 			if ( !(1 & (st = mail$mailfile_close (&mailfile,nullist,nullist))) ) 6 				{int msgvec[] = {1,st}; sys$putmsg(msgvec,0,0,0);}  E 			if ( !(1 & (st = mail$mailfile_end (&mailfile,nullist,nullist))) ) 6 				{int msgvec[] = {1,st}; sys$putmsg(msgvec,0,0,0);} 			}  ! 	pthread_mutex_unlock(&mail_mtx);    	if ( !(1 & status) )  		{ 6 		int msgvec[] = {1,status}; sys$putmsg(msgvec,0,0,0); 		return	status; 		}   ! 	ctx->pop3ctx$l_mfile	= mailfile;  	}   	/*  	** Create a message context 	*/  	{ 	ile3	in_lst[] = {  R 		{sizeof(ctx->pop3ctx$l_mfile), MAIL$_MESSAGE_FILE_CTX,&ctx->pop3ctx$l_mfile,0},  		{0,MAIL$_NOSIGNAL,0,0}, 
 		{0,0,0,0}};    	pthread_mutex_lock(&mail_mtx);   T 	if ( !(1 & (status = mail$message_begin (&ctx->pop3ctx$l_msgctx,in_lst,nullist))) ) 		{ 6 		int msgvec[] = {1,status}; sys$putmsg(msgvec,0,0,0);  " 		pthread_mutex_unlock(&mail_mtx);   		return	status; 		}   ! 	pthread_mutex_unlock(&mail_mtx);    	}   	/* = 	** Open NEWMAIL folder and move all mails to the MAIL folder  	*/  	{ 	unsigned	messid;  	ile3	in_lst[] = {  + 		{7, MAIL$_MESSAGE_FOLDER, "NEWMAIL", 0},  $ 		{0,MAIL$_NOSIGNAL,0,0},{0,0,0,0}}, 	out_lst[] = {  ) 		{4, MAIL$_MESSAGE_SELECTED,&count, 0},  
 		{0,0,0,0}},    	in_lst2[] = {    		{0, MAIL$_MESSAGE_NEXT, 0, 0},$ 		{0,MAIL$_NOSIGNAL,0,0},{0,0,0,0}}, 	out_lst2[] = { 8 		{sizeof(messid),MAIL$_MESSAGE_CURRENT_ID ,&messid,0}, $ 		{0,MAIL$_NOSIGNAL,0,0},{0,0,0,0}}, 	in_lst3[] = {. 		{sizeof(messid),MAIL$_MESSAGE_ID,&messid,0},' 		{4,MAIL$_MESSAGE_FOLDER, "MAIL", 0},   		{0,MAIL$_MESSAGE_DELETE,0,0}, % 		{0,MAIL$_NOSIGNAL,0,0 },{0,0,0,0}};   T 	if ( 1 & (status = mail$message_select( &ctx->pop3ctx$l_msgctx, in_lst, out_lst)) ) 		{  		/* 		** Move messages in loop   		*/(         	for (int i = 0; i < count;i++ ) 			{U 			if ( 1 & (status = mail$message_info(&ctx->pop3ctx$l_msgctx, in_lst2, out_lst2)) ) U 				if ( 1 & (status = mail$message_copy(&ctx->pop3ctx$l_msgctx, in_lst3, nullist)) )  					newcount++;D //???				else	{int msgvec[] = {1,status}; sys$putmsg(msgvec,0,0,0);} 			} 		}    	/*  	** Recreating message context 	*/  	{ 	ile3	in_lst[] = {  R 		{sizeof(ctx->pop3ctx$l_mfile), MAIL$_MESSAGE_FILE_CTX,&ctx->pop3ctx$l_mfile,0}, $ 		{0,MAIL$_NOSIGNAL,0,0},{0,0,0,0}};  S 	if ( !(1 & (status = mail$message_end (&ctx->pop3ctx$l_msgctx,nullist,nullist))) )  		{ 6 		int msgvec[] = {1,status}; sys$putmsg(msgvec,0,0,0); 		return	status; 		}    	pthread_mutex_lock(&mail_mtx);   T 	if ( !(1 & (status = mail$message_begin (&ctx->pop3ctx$l_msgctx,in_lst,nullist))) ) 		{ 6 		int msgvec[] = {1,status}; sys$putmsg(msgvec,0,0,0);  " 		pthread_mutex_unlock(&mail_mtx);   		return	status; 		}   ! 	pthread_mutex_unlock(&mail_mtx);  	}   	/*  	** Open the MAIL folder 	*/ $ 	in_lst[0].ile3$ps_bufaddr	= "MAIL"; 	in_lst[0].ile3$w_length		= 4;W 	if ( !(1 & (status = mail$message_select( &ctx->pop3ctx$l_msgctx, in_lst, out_lst))) )  		{ ; //???		int msgvec[] = {1,status}; sys$putmsg(msgvec,0,0,0);  		return	status; 		}  	}   	/* 0 	** Run over folder and get messages information 	** fillout mails header list  	*/  	{ 	MHDR	*cur = NULL,*prev = NULL; = 	unsigned short fromlen = 0,tolen = 0,subjlen = 0,extlen = 0;  	ile3	in_lst[] = {  		{0,	MAIL$_MESSAGE_NEXT, 0, 0},& 		{0,	MAIL$_NOSIGNAL,0,0 },{0,0,0,0}}, 	out_lst[] = {& 		{4,	MAIL$_MESSAGE_CURRENT_ID,	0,0}, & 		{8,	MAIL$_MESSAGE_BINARY_DATE,	0,0},  		{4,	MAIL$_MESSAGE_SIZE,		0,0},' 		{2,	MAIL$_MESSAGE_RETURN_FLAGS,	0,0}, ) 		{255,	MAIL$_MESSAGE_FROM,		0,&fromlen}, % 		{255,	MAIL$_MESSAGE_TO,		0,&tolen}, , 		{255,	MAIL$_MESSAGE_SUBJECT,		0,&subjlen},) 		{255,	MAIL$_MESSAGE_EXTID,		0,&extlen}, 
 		{0,0,0,0}};   )         	for (int i = 1; i <= count;i++ )  			{ 			/* * 			** If no free VM just stop geting mails 			*/ I 			if ( !(1 & (status = lib$get_vm(&sizeof(MHDR),&cur,&VMZoneId_MHDR))) ) 
 				break;  I                         out_lst[0].ile3$ps_bufaddr	= &cur->mhdr$l_messid; 2 			out_lst[1].ile3$ps_bufaddr	= &cur->mhdr$l_date;3 			out_lst[2].ile3$ps_bufaddr	= &cur->mhdr$l_lines; 3 			out_lst[3].ile3$ps_bufaddr	= &cur->mhdr$w_flags;   2 			out_lst[4].ile3$ps_bufaddr	= &cur->mhdr$t_from;0 			out_lst[5].ile3$ps_bufaddr	= &cur->mhdr$t_to;2 			out_lst[6].ile3$ps_bufaddr	= &cur->mhdr$t_subj;3 			out_lst[7].ile3$ps_bufaddr	= &cur->mhdr$t_extid;  			 T 			if ( !(1 & (status = mail$message_info(&ctx->pop3ctx$l_msgctx,in_lst,out_lst))) ) 				{ K 				if ( !(1 & (status = lib$free_vm(&sizeof(MHDR),&cur,&VMZoneId_MHDR))) )  					lib$signal(status);
 				break; 				} 0 			cur->mhdr$b_fromlen	= (unsigned char)fromlen;, 			cur->mhdr$b_tolen	= (unsigned char)tolen;0 			cur->mhdr$b_subjlen	= (unsigned char)subjlen;. 			cur->mhdr$b_extlen	= (unsigned char)extlen;   			/* 8 			** Is this message was sent with DECNET or Internet ? 			*/ 1 			if ( !strncasecmp(cur->mhdr$t_from,"MX%",3) || / 				!strncasecmp(cur->mhdr$t_from,"SMTP%",5) || + 				!strncasecmp(cur->mhdr$t_from,"IN%",3))  				cur->mhdr$v_decnet	= 0;  			else	cur->mhdr$v_decnet	= 1;  			  			ctx->pop3ctx$l_mlistsz++;. 			ctx->pop3ctx$l_mlines	+= cur->mhdr$l_lines;   			if ( !ctx->pop3ctx$a_mlist )  				{  				ctx->pop3ctx$a_mlist	= cur;  				ctx->pop3ctx$a_mlast	= cur;  				}    			if ( prev ) 				prev->mhdr$a_next	= cur;   			prev = cur; 			} 	}   	if ( !(1 & status) ) 8 		{int msgvec[] = {1,status}; sys$putmsg(msgvec,0,0,0);}  A 	spop3__log(ctx,POP3_INIMAILCTX,ctx->pop3ctx$l_mlistsz,newcount);    	return	status;  }      /*, ** http://www.eight-cubed.com/examples.shtmlI ** http://www.eight-cubed.com/examples/framework.php?file=lib_establish.c ' ** ISUBS.LIS: %sbttl  'reclaim_handler'  */   static unsigned	handler	(  	struct chfdef1	* sigargs, 		unsigned *mechargs 			) { . 	if ( sigargs->chf$is_sig_name == SS$_UNWIND ) 		return	SS$_CONTINUE;  . 	if ( sigargs->chf$is_sig_name == SS$_ACCVIO ) 		return	SS$_RESIGNAL;  ! //	sigargs->chf$is_sig_args	-= 2; - 	sys$putmsg(&sigargs->chf$is_sig_args,0,0,0); ) //	lib$signal(&sigargs->chf$is_sig_args); ! //	sigargs->chf$is_sig_args	+= 2;  		" 	lib$sig_to_ret(sigargs,mechargs);
 	return 0; }      /* **++ **  FUNCTIONAL DESCRIPTION:  **Q **      Close all MAIL related files, deleting mails marked by user for deletion, H **	additionaly performs auto-deletion of mails older then 'expire' days,! **	performs PURGE/RECLAIM action.  ** **  FORMAL PARAMETERS: ** **	ctx:		SPOP3 context area  ** **  RETURN VALUE:  ** **      VMS condition code ** **-- */ int	vmail_shut_ctx	( 		POP3CTX  *ctx  			) { 9 unsigned	status = SS$_NORMAL, option =  LIB$K_DELTA_DAYS, , 		deleted = 0, delcount = 0, sentcount = 0;;* unsigned __int64 expire_date = 0, curtime;% MHDR	*mp = ctx->pop3ctx$a_mlist,*cur;  ile3	in_lst[] = {  		{4,MAIL$_MESSAGE_ID,0,0}, $ 		{0,MAIL$_NOSIGNAL,0,0},{0,0,0,0}};   	if ( !ctx ) 		return	SS$_NORMAL;   	/*  	** Is there expire option ? 	*/ # 	if ( mp && ctx->pop3ctx$l_expire )  		{  		/*' 		** Convert number of days to VMS DATE 
 		*/      - 		if ( 1 & (status = sys$gettim (&curtime)) ) ^ 			if ( 1 & (status = lib$cvt_to_internal_time(&option,&ctx->pop3ctx$l_expire,&expire_date)) )? 				status = lib$sub_times(&curtime,&expire_date,&expire_date);    		if ( !(1 & status) ) 			{ 			int msgvec[] = {1,status};    			sys$putmsg(msgvec,0,0,0); 			expire_date	= 0;  			} 		}  	else	expire_date	= 0;   	/* H 	** Run over the message list, release memory, performs message deletion 	*/ 
 	while ( mp )  		{  		/*! 		** Is there expiration option ?  		*/ 		if ( expire_date ) 			{? 			if ( mp->mhdr$v_deleted |= (mp->mhdr$q_date < expire_date) ) 2 				spop3__log(ctx,POP3_EXPIRED,mp->mhdr$l_messid,+ 					&mp->mhdr$b_fromlen,&mp->mhdr$b_tolen, + 					&mp->mhdr$b_subjlen,&mp->mhdr$q_date);  			}   		if ( mp->mhdr$v_deleted )  			{2 			in_lst[0].ile3$ps_bufaddr	= &mp->mhdr$l_messid;  V 			if ( !(1 & (status = mail$message_delete(&ctx->pop3ctx$l_msgctx,in_lst,nullist))) ): 				{int msgvec[] = {1,status}; sys$putmsg(msgvec,0,0,0);}  9 			spop3__log(ctx,POP3_MDELETE,mp->mhdr$l_messid,status);    			delcount++; 			}   		if ( mp->mhdr$v_sent ) 			sentcount++;  		 		cur	= mp;  		mp	= mp->mhdr$a_next;   I 		if ( !(1 & (status = lib$free_vm(&sizeof(MHDR),&cur,&VMZoneId_MHDR))) )  			lib$signal(status); 		}    	/*  	** Close message context  	*/ l 	if ( ctx->pop3ctx$l_msgctx && !(1 & (status = mail$message_end (&ctx->pop3ctx$l_msgctx,nullist,nullist))) )8 		{int msgvec[] = {1,status}; sys$putmsg(msgvec,0,0,0);}     	/*  	** Close MAIL.MAI file  	*/  	if ( ctx->pop3ctx$l_mfile )   		{  		/*? 		** If there exist deleted messages - purge WASTEBACKET folder  		*/ 		if ( delcount )  			{ 			ile3 out_lst[] = { 1 				{4,MAIL$_MAILFILE_DELETED_BYTES,&deleted,0},   				{0,0,0,0}};   ^ 			if ( !(1 & (status = mail$mailfile_purge_waste(&ctx->pop3ctx$l_mfile,&nullist,&out_lst))) ): 				{int msgvec[] = {1,status}; sys$putmsg(msgvec,0,0,0);} 			}   		/*1 		** Close MAIL.MAI & deallocate MAILFILE context  		*/V 		if ( !(1 & (status = mail$mailfile_close (&ctx->pop3ctx$l_mfile,nullist,nullist))) )9 			{int msgvec[] = {1,status}; sys$putmsg(msgvec,0,0,0);}   T 		if ( !(1 & (status = mail$mailfile_end (&ctx->pop3ctx$l_mfile,nullist,nullist))) )9 			{int msgvec[] = {1,status}; sys$putmsg(msgvec,0,0,0);}  		}    	/* ? 	** If the global PURGE/RECLAIM Threshold has been defined then V 	** check a needness to performs CONVERT/RECLAIM operation on the user's MAIL.MAI file 	*/ ; 	if ( deleted && pr_threshold && (deleted > pr_threshold) )  		{  		unsigned flags = 1;  		unsigned short mfns = 0; 		unsigned char mfna[512]; 		struct dsc$descriptor mfile;, 		struct recl$statistics stat = {4,0,0,0,0};  [ 		mfns = sprintf(mfna,"%.*sMAIL.MAI",ctx->pop3ctx$t_maildir[0],&ctx->pop3ctx$t_maildir[1]);  		 		INIT_SDESC(mfile,mfns,mfna);   		/*H 		** Establishing a condition handler especialy for CONV$RECLAIM routine 		*/ 		lib$establish (&handler);    		/*, 		** Performs a calling CONV$RECLAIM routine 		*/B 		if ( !(1 & (status = conv$reclaim(&mfile,&stat,&flags, NULL))) )9 			{int msgvec[] = {1,status}; sys$putmsg(msgvec,0,0,0);}   L 		spop3__log(ctx,POP3_RECLAIM,stat.recl$l_scan_count,stat.recl$l_data_count,< 				stat.recl$l_index_count,stat.recl$l_total_count,status); 		}   _ 	spop3__log(ctx,POP3_SHUTMAILCTX,delcount,ctx->pop3ctx$l_mlistsz - delcount,sentcount,deleted);   H //	return	ctx->pop3ctx$l_lkid?sys$deq(ctx->pop3ctx$l_lkid,0,0,0):status; 	return	status;  }    /* **++ **  FUNCTIONAL DESCRIPTION:  **J **	Retrievs a body of the specified message. A first call must be with theU **	start argument set to non-zero all next calls should be with the start eqaly zero.  ** **  FORMAL PARAMETERS: ** **	ctx:		SPOP3 context area  **	messid:		a message number1 **	start:		a flag to positioning to begin of mail . **	buf:		a buffer to accept a next mail record  **	buflen:		a size of the buffer7 **	retlen:		a returned actual data length in the buffer  ** **  RETURN VALUE:  ** **      VMS condition code ** **-- */ int	vmail_get_msg	(  		POP3CTX		*ctx, 		MHDR		*mp, 		int		 start,
 		char		*buf,  	unsigned short		 buflen,  	unsigned short		*retlen 				)  { & int	status,st,rtype = 0,mextidlen = 0; char	mextid [ 512 ] ;    ile3	in_lst[] = {   	{0,MAIL$_MESSAGE_CONTINUE,0,0},+ 	{4,MAIL$_MESSAGE_ID,&mp->mhdr$l_messid,0}, # 	{0,MAIL$_NOSIGNAL,0,0},{0,0,0,0}},  	out_lst[] = {3 	{min(255,buflen),MAIL$_MESSAGE_RECORD,buf,retlen}, ) 	{2,	MAIL$_MESSAGE_RECORD_TYPE,&rtype,0},  	{0,0,0,0}}; 	 
 	*retlen	= 0;      	/* H 	** If this mail is not in external file read it with MAIL$ API routines 	*/ , 	if ( !(mp->mhdr$w_flags & MAIL$M_EXTMSG) ||' 		(mp->mhdr$w_flags & MAIL$M_EXTFNF) ||  		!ctx->pop3ctx$t_maildir[0] ) 		{  		/*  		** Extract only a message body 		*/ 		do	{b 			if ( !(1 & (status = mail$message_get(&ctx->pop3ctx$l_msgctx, &in_lst[start == 1], out_lst))) ) 				return	status;  
 			start	= 0;   + 			} while ( rtype != MAIL$_MESSAGE_TEXT );    		return	status; 		}    	/* . 	** The mail has been stored in external file,! 	** read it with RMS API routines  	*/ 
 	if ( start )  		{  		/*+ 		** Construct a full path-name to the file  		*/] 		mextidlen = sprintf(mextid,"%.*s%.*s",ctx->pop3ctx$t_maildir[0],&ctx->pop3ctx$t_maildir[1], ' 			mp->mhdr$b_extlen,mp->mhdr$t_extid);    		/* 		** Open external file  		*/# 		ctx->pop3ctx$r_mfab	= cc$rms_fab; , 		ctx->pop3ctx$r_mfab.fab$b_fac	= FAB$M_GET;/ 		ctx->pop3ctx$r_mfab.fab$b_shr	= FAB$M_SHRGET; $ 		ctx->pop3ctx$r_mfab.fab$v_nql	= 1;$ 		ctx->pop3ctx$r_mfab.fab$v_sqo	= 1;) 		ctx->pop3ctx$r_mfab.fab$l_fna	= mextid; , 		ctx->pop3ctx$r_mfab.fab$b_fns	= mextidlen;  9 		if ( !(1 & (status = sys$open(&ctx->pop3ctx$r_mfab))) )  			{U 			int msgvec[] = {2,status,ctx->pop3ctx$r_mfab.fab$l_stv}; sys$putmsg(msgvec,0,0,0);  			return	status;  			}  # 		ctx->pop3ctx$r_mrab	= cc$rms_rab; 7 		ctx->pop3ctx$r_mrab.rab$l_fab = &ctx->pop3ctx$r_mfab;  		$ 		ctx->pop3ctx$r_mrab.rab$v_nlk	= 1;$ 		ctx->pop3ctx$r_mrab.rab$v_rrl	= 1;$ 		ctx->pop3ctx$r_mrab.rab$b_mbf	= 4;$ 		ctx->pop3ctx$r_mrab.rab$b_mbc	= 4;  < 		if ( !(1 & (status = sys$connect(&ctx->pop3ctx$r_mrab))) ) 			{U 			int msgvec[] = {2,status,ctx->pop3ctx$r_mrab.rab$l_stv}; sys$putmsg(msgvec,0,0,0);  			return	status;  			}$ 		ctx->pop3ctx$r_mrab.rab$v_nlk	= 1;$ 		ctx->pop3ctx$r_mrab.rab$v_rrl	= 1;$ 		ctx->pop3ctx$r_mfab.fab$l_ctx	= 1; 		}    	/* & 	** Read a next record from the stream 	*/ % 	ctx->pop3ctx$r_mrab.rab$l_ubf = buf; ( 	ctx->pop3ctx$r_mrab.rab$w_usz = buflen;  7 	if ( !(1 & (status = sys$get(&ctx->pop3ctx$r_mrab))) )  		{ )                 if ( status != RMS$_EOF ) W 			{int msgvec[] = {2,status,ctx->pop3ctx$r_mrab.rab$l_stv}; sys$putmsg(msgvec,0,0,0);}    		/*/ 		** In case of any error or EOF close the file  		*/; 		if ( !(1 & (st = sys$disconnect(&ctx->pop3ctx$r_mrab))) ) S 			{int msgvec[] = {2,st,ctx->pop3ctx$r_mrab.rab$l_stv}; sys$putmsg(msgvec,0,0,0);}     6 		if ( !(1 & (st = sys$close(&ctx->pop3ctx$r_mfab))) )S 			{int msgvec[] = {2,st,ctx->pop3ctx$r_mfab.fab$l_stv}; sys$putmsg(msgvec,0,0,0);}   $ 		ctx->pop3ctx$r_mfab.fab$l_ctx	= 0; 		}   ) 	*retlen	= ctx->pop3ctx$r_mrab.rab$w_rsz;   4 	return	(status == RMS$_EOF?MAIL$_NOMOREREC:status); }        /* **++ **  FUNCTIONAL DESCRIPTION:  **( **	Close file if it was opened with RMS. ** **  FORMAL PARAMETERS: ** **	ctx:		SPOP3 context area  ** **  RETURN VALUE:  ** **      VMS condition code ** **-- */ int	vmail_msg_end	(  		POP3CTX	*ctx, 
 		MHDR	*mp 			) {  int	st;   , 	if ( !(mp->mhdr$w_flags & MAIL$M_EXTMSG) ||' 		(mp->mhdr$w_flags & MAIL$M_EXTFNF) ||  		!ctx->pop3ctx$t_maildir[0]  % 		|| !ctx->pop3ctx$r_mfab.fab$l_ctx )  		return	SS$_NORMAL;  # 	ctx->pop3ctx$r_mfab.fab$l_ctx = 0;    	/* & 	** Just close external MAI$*.MAI file 	*/ : 	if ( !(1 & (st = sys$disconnect(&ctx->pop3ctx$r_mrab))) )R 		{int msgvec[] = {2,st,ctx->pop3ctx$r_mrab.rab$l_stv}; sys$putmsg(msgvec,0,0,0);}  5 	if ( !(1 & (st = sys$close(&ctx->pop3ctx$r_mfab))) ) R 		{int msgvec[] = {2,st,ctx->pop3ctx$r_mfab.fab$l_stv}; sys$putmsg(msgvec,0,0,0);}   	return	SS$_NORMAL;  }      #if	0    /* **++ **  FUNCTIONAL DESCRIPTION:  **E **	Returns a diskquota information for user defined by given context.  ** **  FORMAL PARAMETERS: ** **	ctx:		VMAIL API context) **	total:		a returned disk quota in bytes ( **	free:		a returned not used free space ** **  RETURN VALUE:  ** **      VMS condition code ** **-- */ int	vmail_get_dquota	( 		struct	vmail_ctx	*ctx, 			unsigned	*total,  			unsigned	*free  				)  {  int	status,chan = 0; iosb	io_status;  struct  _dqf	quota;  struct fibdef1	quota_fib;  struct  simple__desc	         {          int      cnt;          void    *ptr; 5         } qfun = {sizeof(struct fibdef1),&quota_fib}, ( 	  qpar = {sizeof(struct  _dqf),&quota}; struct dsc$descriptor dev_dsc;   	/*  	**  	*/ 
 	sysprv_on();   ' 	memset(&quota,0,sizeof(struct  _dqf)); . 	memset(&quota_fib,0,sizeof(struct  fibdef1));  2 	INIT_SDESC(dev_dsc,ctx->fspec[0],&ctx->fspec[1]);   	quota.dqf$l_uic		 = ctx->uic;, 	quota_fib.fib$w_cntrlfunc= FIB$C_EXA_QUOTA; 	quota_fib.fib$l_cntrlval = 0; 	 7 	if ( 1 & (status = sys$assign(&dev_dsc,&chan,0,0,0)) )  		{ Z 		status = sys$qiow(EFN$C_ENF,chan,IO$_ACPCONTROL,&io_status,0,0,&qfun,&qpar,0,&qpar,0,0); 		sys$dassgn(chan);  		}   $ 	*total	= 512*quota.dqf$l_permquota;7 	*free	= 512*(quota.dqf$l_permquota-quota.dqf$l_usage);   A 	return	sysprv_off(!(1 & status)?status:io_status.iosb$w_status);  }  #endif