 #define version_string "V1.58"- #pragma module T4$UNIX_COLLECT version_string    /*I    Post process a log file containing data from the Tru64 collect utility B    (converted to text), and turn it into a T4 compatible CSV file.  D    Some examples of the collect command used to obtain the data are:  :    collect -R 2d -F -i 60:120 -t -v -M 100,200 -f filespec  D    collect -Hd00:00,14d -F -i 60:360 -t -W 2m -M 500,750 -f filespec  +     Bart Z. Lederman	20-Apr-2005	First pass + 			22-Apr-2005	Remove percentage data items - 			26-Apr-2005	Change to DBASIC$EDIT (native) * 			27-Apr-2005	Modify for Unix client dataD                         27-Jun-2005	Use T4$UNIX_NFS as a base to get) 					started on something to post-process ! 					COLLECT data in text format. ( 			28-Jun-2005	Add single CPU statistics 					Add memory statistics.  					Add disks.   					Prepare for adding filesets 			29-Jun-2005	Add filesets.0 			01-Jul-2005	no upper case, multi-line headers 			14-Jul-2005	Merge in LAN * 					Merge in file system (capacity, used)* 			26-Jul-2005	Add Volume I/O queue values 			27-Jul-2005	Add TTY data % 					Enhanced column headers based on # 					what's in the Collgui utility. & 			29-Jul-2005	Typos in column headers2 			17-Aug-2005	Revise some column headers based on 					the man pages. % 			01-Mar-2006	Add in process counts. 0 			13-Apr-2006	Add in the summaries on users and 					commands." 			18-Apr-2006	Add ksh to commands  			21-Apr-2006	Add more commands* 			26-Apr-2006	Fix missing column headers.4 			27-Apr-2006	Reduce users and images for inclusion  					on the freeware collection. */   #include <STDIO.H> #include <STDLIB.H> ) #include <STRING.H>		/* for strncpy				*/ . #include <LIMITS.H>		/* For maximum sizes			*/, #include <STARLET.H>		/* for SYS$ calls			*/) #include <RMS.H>		/* RMS definitions			*/ 6 #include <SSDEF.H>		/* for exit status definitions		*/- #include <DESCRIP.H>		/* for descriptors			*/ / #include <CLIMSGDEF.H>		/* For CLI$_values			*/ 1 #include <CLI$ROUTINES.H>	/* For CLI parsing			*/ 0 #include <LIB$ROUTINES.H>	/* for LIB$ calls			*/0 #include <STR$ROUTINES.H>	/* For STR$ calls			*// #include <OTS$ROUTINES.H>	/* For OTS$ call			*/   6 #include "BAS$EDIT.H"		/* for calls to DBASIC$EDIT		*/   struct FAB in_fab; struct RAB in_rab;   struct FAB out_fab;  struct RAB out_rab;    /*@    Need a big buffer for input, with a real address for the rab. */   char inbuf [SHRT_MAX];  ! struct dsc$descriptor_s in_desc = 7 	{sizeof (inbuf), DSC$K_DTYPE_T, DSC$K_CLASS_S, inbuf};    /*2    Dynamic string descriptors for line processing. */  " struct dsc$descriptor_s out_desc =& 	{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};  % struct dsc$descriptor_s header_desc = & 	{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};  # struct dsc$descriptor_d temp_desc = & 	{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};  $ struct dsc$descriptor_d temp2_desc =& 	{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};  ) struct dsc$descriptor_d datestring_desc = & 	{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};   short int retlen;    /*G    Fixed string descriptors for parsing or building line elements which &    are used in more than one function. */   $DESCRIPTOR (space, " ");    /*D    Variables to hold process summary data. Placed here so they don't(    have to be passed on a function call. */  @ #define MAX_PROC 11	/* must sync with the number of processes	*/2 			/* (users and commands) that are summarized.	*/  9 double	cpu[MAX_PROC], usrtim[MAX_PROC], systim[MAX_PROC],  	rss[MAX_PROC], vsz[MAX_PROC];2 int	count[MAX_PROC], ibk[MAX_PROC], obk[MAX_PROC], 	maj[MAX_PROC], min[MAX_PROC]; /*0    Variables to hold process summary input data. */   double	cpui, usrtimi, systimi;! int	pidi, ibki, obki, maji, mini;   char	useri[8], rssi[8], vszi[8];  ' int	proc;			/* index to process id			*/   ( /*	*****	FUNCTIONS START HERE	****				*/   void parse_unix_date ()  {      int status;      $DESCRIPTOR (hyphen, "-");  (     struct dsc$descriptor_d temp3_desc =& 	{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0}; /*F    Input is temp2_desc containing the date and time string. It will be8    parsed out and put into the correct format going into    datestring_desc.  */   /*    Start with the numeric day. */@     status = str$element (&temp3_desc, &2, &space, &temp2_desc);  2     if (status != SS$_NORMAL) lib$signal (status);  9     status = str$copy_dx (&datestring_desc, &temp3_desc);   2     if (status != SS$_NORMAL) lib$signal (status);  4     status = str$append (&datestring_desc, &hyphen);  2     if (status != SS$_NORMAL) lib$signal (status); /*    Get the month.  */@     status = str$element (&temp3_desc, &1, &space, &temp2_desc);  2     if (status != SS$_NORMAL) lib$signal (status);  8     status = str$append (&datestring_desc, &temp3_desc);  2     if (status != SS$_NORMAL) lib$signal (status);  4     status = str$append (&datestring_desc, &hyphen);  2     if (status != SS$_NORMAL) lib$signal (status); /*    Get the year. */@     status = str$element (&temp3_desc, &4, &space, &temp2_desc);  2     if (status != SS$_NORMAL) lib$signal (status);  8     status = str$append (&datestring_desc, &temp3_desc);  2     if (status != SS$_NORMAL) lib$signal (status);  3     status = str$append (&datestring_desc, &space);   2     if (status != SS$_NORMAL) lib$signal (status); /*+    Get the time, which is all in one piece.  */@     status = str$element (&temp3_desc, &3, &space, &temp2_desc);  2     if (status != SS$_NORMAL) lib$signal (status);  8     status = str$append (&datestring_desc, &temp3_desc);  2     if (status != SS$_NORMAL) lib$signal (status);       return;  }    void close_files ()  {      int status;  /*    All done, close the files.  */&     status = sys$disconnect (&in_rab);  3     if (status != RMS$_NORMAL) lib$signal (status);   !     status = sys$close (&in_fab);   3     if (status != RMS$_NORMAL) lib$signal (status);   '     status = sys$disconnect (&out_rab);   3     if (status != RMS$_NORMAL) lib$signal (status);   #     status = sys$close (&out_fab);    3     if (status != RMS$_NORMAL) lib$signal (status);        return;  }    int get_record ()  {      int status, status2; /*B    Set processing: remove leading blanks and tabs, remove trailingC    blanks and tabs, and compress multiple blanks and tabs to single     blank spaces. */G     int edit_control =	BAS$M_DISLEAD | BAS$M_COMPRESS | BAS$M_DISTRAIL;     >     status = sys$get (&in_rab, 0, 0);		/* retrieve a record	*/  <     if (status == RMS$_EOF)		/* end of file, time to quit	*/     {  	close_files ();; 	exit (SS$_NORMAL);	/* assume this is supposed to happen	*/      } #     else if (status != RMS$_NORMAL)      { 1 	lib$signal (in_rab.rab$l_sts, in_rab.rab$l_stv);      }      else     { . 	retlen = in_rab.rab$w_rsz;		/* get length		*/< 	in_desc.dsc$w_length = retlen;		/* update the descriptor */  + 	if (retlen > 0)				/* if there was data	*/  	{ /*A    Use a BASIC RTL call that does multiple functions.  This would 8    require multiple calls with other available routines. */@ 	    status2 = DBASIC$EDIT (&temp_desc, &in_desc, edit_control); 	    if (status2 != 1) 	    {( 		printf ("\n edit status %d", status2); 	    }; ) 	};		/* end of record data to process		*/ %     };			/* end of input record				*/        return (retlen); }    void put_record (int rflag)  {      int status;  /*B    Point the output buffers to the current descriptor location andD    size.  Because a dynamic descriptor is used, even the address can,    change; so this has to be done each time. */-     if (rflag == 0)			/* writing out_desc		*/      { , 	out_rab.rab$l_rbf = out_desc.dsc$a_pointer;+ 	out_rab.rab$w_rsz = out_desc.dsc$w_length;      } 4     else if (rflag == 1)		/* writing header_desc		*/     { / 	out_rab.rab$l_rbf = header_desc.dsc$a_pointer; . 	out_rab.rab$w_rsz = header_desc.dsc$w_length;     }      else     { "     	lib$signal (SS$_BADPARAM, 0);     };  <     status = SYS$PUT (&out_rab, 0, 0);		/* write a record	*/  8     if (status != RMS$_NORMAL)			/* if not successful	*/     { 3 	lib$signal (out_rab.rab$l_sts, out_rab.rab$l_stv);      };       return;  }    void sum_proc_data (void)  { H     char mult;	    /* local storage for RSS and VSZ value multiplier.	*/:     double tfloat;  /* temporary floating point value			*/ /*B    Sum up the data items. Start by incrementing the process count. */"     count[proc] = count[proc] + 1; /*G    Very occasionally, there is bad data. Check for this before summing.  */     if (cpui < 100.9)      {  	cpu[proc] = cpu[proc] + cpui;     }; /*C    RSS and VSZ need special processing to separate the numeric part G    from the multiplier, and then convert.  atof is used because it will D    stop converting when (if) it hits a non-numeric character such as(    the letter signifying the multiplier. */:     tfloat = atof (rssi);	/* convert the numeric part.		*/  A     mult = inbuf[25];		/* should always be in a fixed location	*/  /*F    Scaling used to be by the 'true' value.  An examination of the dataG    indicates that all of the numbers come out fairly large, and display A    better if the data is scaled by Megabytes.  So make all of the )    numbers 1000000.0 smaller than before.  */>     if (mult == 'K')		/* scale the input value as indicated	*/     {      	tfloat = tfloat * 0.001;      }      else if (mult == 'G')      {      	tfloat = tfloat * 1000.0;     }      else if (mult != 'M')      { ?     	printf ("\n Unknown RSS multiplier %c, %x\n", mult, mult);      };  8     rss[proc] = rss[proc] + tfloat;	/* sum the data			*/ /*    Repeat for VSZ. */9     tfloat = atof (vszi);	/* convert the numeric part		*/   A     mult = inbuf[30];		/* should always be in a fixed location	*/   >     if (mult == 'K')		/* scale the input value as indicated	*/     {      	tfloat = tfloat * 0.001;      }      else if (mult == 'G')      {      	tfloat = tfloat * 1000.0;     }      else if (mult != 'M')      { ?     	printf ("\n Unknown VSZ multiplier %c, %x\n", mult, mult);      };  #     vsz[proc] = vsz[proc] + tfloat;  /*A    Sum the other items.  Don't increment if the data looks wrong.  */     if (usrtimi < 999.999)     { ' 	usrtim[proc] = usrtim[proc] + usrtimi;      };       if (systimi < 999.99)      { ' 	systim[proc] = systim[proc] + systimi;      };       if (ibki < 999)      {  	ibk[proc] = ibk[proc] + ibki;     };       if (obki < 999)      {  	obk[proc] = obk[proc] + obki;     };       if (maji < 999)      {  	maj[proc] = maj[proc] + maji;     };       if (mini < 999)      {  	min[proc] = min[proc] + mini;     };       return;  }   % /* ***		Program starts here				***	*/    main ()  { +     long status, status2, status3, status4;      int i, j, k,= 	foundline, num_disks, num_filesets, firstdisk, firstfileset, ) 	num_lans, firstlan, num_fsys, firstfsys, - 	num_volque, firstvolque, firsttty, num_proc;      short int str_length; 1     char header[SHRT_MAX], dsknam[32], temp3[16];   )     struct dsc$descriptor_s infile_desc = ' 		{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0}; *     struct dsc$descriptor_s outfile_desc =' 		{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};  /*!    Variables for data file (CLD).  */(     $DESCRIPTOR ( input_desc,  "INPUT");(     $DESCRIPTOR (output_desc, "OUTPUT"); /*    Search strings. */!     $DESCRIPTOR (openparen, "("); "     $DESCRIPTOR (closeparen, ")");     $DESCRIPTOR (comma, ",");      $DESCRIPTOR (kk, "K");     $DESCRIPTOR (mm, "M");  %     $DESCRIPTOR (flagline,	"# OSF1"); -     $DESCRIPTOR (record_line,	"#### RECORD"); 2     $DESCRIPTOR (disk_stats,	"# DISK Statistics");1     $DESCRIPTOR (cpu_sum_stats,	"# CPU SUMMARY"); 6     $DESCRIPTOR (memory_stats,	"# MEMORY STATISTICS");,     $DESCRIPTOR (fileset_stats,	"#fileset");.     $DESCRIPTOR (volque_stats,	"#domain.vol");N     $DESCRIPTOR (network_stats,	"# Network Statistics");    /* single space */;     $DESCRIPTOR (fsys_stats,    "# FileSystem Statistics"); 0     $DESCRIPTOR (tty_stats,	"# TTY Statistics");-     $DESCRIPTOR (numcpus_line,	"# NUM CPUS"); -     $DESCRIPTOR (numlans_line,	"# NUM LANS"); 0     $DESCRIPTOR (advfs_line,	"# AdvFS Domains");$     $DESCRIPTOR (pid_line,	"# PID");"     $DESCRIPTOR (pound_line,	"#");*     $DESCRIPTOR (started_line,	"Started"); /*2    User names to search for when summing PID data. */      $DESCRIPTOR (root,  "root");!     $DESCRIPTOR (admin, "admin");  /*0    Commands to search for when summing PID data. */     $DESCRIPTOR (csh,	"csh");      $DESCRIPTOR (java,	"java");      $DESCRIPTOR (make,	"make");      $DESCRIPTOR (perl,	"perl");      $DESCRIPTOR (ar,	"ar");      $DESCRIPTOR (ld,	"ld");      $DESCRIPTOR (nm,	"nm");      $DESCRIPTOR (ksh,	"ksh");      $DESCRIPTOR (tcsh,	"tcsh");  /*    Header line strings.  */F     $DESCRIPTOR (header1, "Sample Time");   /* try without [DISK]   */  T     $DESCRIPTOR (cpus1, "[CPU]User,[CPU]Sys,[CPU]Idle,[CPU]Wait,[CPU /s]Interupts");     $DESCRIPTOR (cpus2, "[CPU /s]Sys Calls,[CPU /s]Context Switches,[CPU]Processes in Run Queue,[CPU]Load avg 5s,[CPU]Load avg30s");I     $DESCRIPTOR (cpus3, "[CPU]Load avg60s,[CPU /s]Forks,[CPU /s]VForks");   M     $DESCRIPTOR (cpu0, "[CPU0]user,[CPU0]sys,[CPU0]idle,[CPU0]wait for I/O"); M     $DESCRIPTOR (cpu1, "[CPU1]user,[CPU1]sys,[CPU1]idle,[CPU1]wait for I/O"); M     $DESCRIPTOR (cpu2, "[CPU2]user,[CPU2]sys,[CPU2]idle,[CPU2]wait for I/O"); M     $DESCRIPTOR (cpu3, "[CPU3]user,[CPU3]sys,[CPU3]idle,[CPU3]wait for I/O");   ]     $DESCRIPTOR (mem1, "[MEM mb]Free Mem,[MEM mb]Free Swap,[MEM mb]Active,[MEM mb]Inactive"); [     $DESCRIPTOR (mem2, "[MEM mb]Wired,[MEM mb]UBC Mem,[MEM ps]Pages In,[MEM ps]Pages Out"); m     $DESCRIPTOR (mem3, "[MEM ps]Zeroed,[MEM ps]Reactivated,[MEM ps]Copy On Write,[MEM ps]Swapped Processes"); V     $DESCRIPTOR (mem4, "[MEM ps]UBC Hits,[MEM ps]UBC Pushed Pages,[MEM ps]UBC Alloc");  |     $DESCRIPTOR (tty1, "[TTY]Input Char,[TTY]Output Char,[TTY]Input queue CANNON,[TTY]Input queue RAW,[PROC]Process Count");  b     $DESCRIPTOR (oth1, "[USER]OTHER count,[USER]OTHER CPU,[USER]OTHER RSS Mb,[USER]OTHER VSZ Mb");`     $DESCRIPTOR (oth2, "[USER]OTHER UsrTim,[USER]OTHER SysTim,[USER]OTHER IBk,[USER]OTHER OBk");:     $DESCRIPTOR (oth3, "[USER]OTHER Maj,[USER]OTHER Min");  ^     $DESCRIPTOR (roo1, "[USER]root count,[USER]root CPU,[USER]root RSS Mb,[USER]root VSZ Mb");\     $DESCRIPTOR (roo2, "[USER]root UsrTim,[USER]root SysTim,[USER]root IBk,[USER]root OBk");8     $DESCRIPTOR (roo3, "[USER]root Maj,[USER]root Min");  b     $DESCRIPTOR (adm1, "[USER]admin count,[USER]admin CPU,[USER]admin RSS Mb,[USER]admin VSZ Mb");`     $DESCRIPTOR (adm2, "[USER]admin UsrTim,[USER]admin SysTim,[USER]admin IBk,[USER]admin OBk");:     $DESCRIPTOR (adm3, "[USER]admin Maj,[USER]admin Min");  f     $DESCRIPTOR (csh1, "[COMMAND]csh count,[COMMAND]csh CPU,[COMMAND]csh RSS Mb,[COMMAND]csh VSZ Mb");d     $DESCRIPTOR (csh2, "[COMMAND]csh UsrTim,[COMMAND]csh SysTim,[COMMAND]csh IBk,[COMMAND]csh OBk");<     $DESCRIPTOR (csh3, "[COMMAND]csh Maj,[COMMAND]csh Min");  k     $DESCRIPTOR (java1, "[COMMAND]java count,[COMMAND]java CPU,[COMMAND]java RSS Mb,[COMMAND]java VSZ Mb"); i     $DESCRIPTOR (java2, "[COMMAND]java UsrTim,[COMMAND]java SysTim,[COMMAND]java IBk,[COMMAND]java OBk"); ?     $DESCRIPTOR (java3, "[COMMAND]java Maj,[COMMAND]java Min");   s     $DESCRIPTOR (make1, "[COMMAND]*make* count,[COMMAND]*make* CPU,[COMMAND]*make* RSS Mb,[COMMAND]*make* VSZ Mb"); q     $DESCRIPTOR (make2, "[COMMAND]*make* UsrTim,[COMMAND]*make* SysTim,[COMMAND]*make* IBk,[COMMAND]*make* OBk"); C     $DESCRIPTOR (make3, "[COMMAND]*make* Maj,[COMMAND]*make* Min");   k     $DESCRIPTOR (perl1, "[COMMAND]perl count,[COMMAND]perl CPU,[COMMAND]perl RSS Mb,[COMMAND]perl VSZ Mb"); i     $DESCRIPTOR (perl2, "[COMMAND]perl UsrTim,[COMMAND]perl SysTim,[COMMAND]perl IBk,[COMMAND]perl OBk"); ?     $DESCRIPTOR (perl3, "[COMMAND]perl Maj,[COMMAND]perl Min");   a     $DESCRIPTOR (ar1, "[COMMAND]ar count,[COMMAND]ar CPU,[COMMAND]ar RSS Mb,[COMMAND]ar VSZ Mb"); _     $DESCRIPTOR (ar2, "[COMMAND]ar UsrTim,[COMMAND]ar SysTim,[COMMAND]ar IBk,[COMMAND]ar OBk"); 9     $DESCRIPTOR (ar3, "[COMMAND]ar Maj,[COMMAND]ar Min");   a     $DESCRIPTOR (ld1, "[COMMAND]ld count,[COMMAND]ld CPU,[COMMAND]ld RSS Mb,[COMMAND]ld VSZ Mb"); _     $DESCRIPTOR (ld2, "[COMMAND]ld UsrTim,[COMMAND]ld SysTim,[COMMAND]ld IBk,[COMMAND]ld OBk"); 9     $DESCRIPTOR (ld3, "[COMMAND]ld Maj,[COMMAND]ld Min");   a     $DESCRIPTOR (nm1, "[COMMAND]nm count,[COMMAND]nm CPU,[COMMAND]nm RSS Mb,[COMMAND]nm VSZ Mb"); _     $DESCRIPTOR (nm2, "[COMMAND]nm UsrTim,[COMMAND]nm SysTim,[COMMAND]nm IBk,[COMMAND]nm OBk"); 9     $DESCRIPTOR (nm3, "[COMMAND]nm Maj,[COMMAND]nm Min");   f     $DESCRIPTOR (ksh1, "[COMMAND]ksh count,[COMMAND]ksh CPU,[COMMAND]ksh RSS Mb,[COMMAND]ksh VSZ Mb");d     $DESCRIPTOR (ksh2, "[COMMAND]ksh UsrTim,[COMMAND]ksh SysTim,[COMMAND]ksh IBk,[COMMAND]ksh OBk");<     $DESCRIPTOR (ksh3, "[COMMAND]ksh Maj,[COMMAND]ksh Min");  k     $DESCRIPTOR (tcsh1, "[COMMAND]tcsh count,[COMMAND]tcsh CPU,[COMMAND]tcsh RSS Mb,[COMMAND]tcsh VSZ Mb"); i     $DESCRIPTOR (tcsh2, "[COMMAND]tcsh UsrTim,[COMMAND]tcsh SysTim,[COMMAND]tcsh IBk,[COMMAND]tcsh OBk"); ?     $DESCRIPTOR (tcsh3, "[COMMAND]tcsh Maj,[COMMAND]tcsh Min");  /*     T4 type 2 header demarcation. */=     $DESCRIPTOR (start_head, "$$$ START COLUMN HEADERS $$$"); ;     $DESCRIPTOR (  end_head, "$$$ END COLUMN HEADERS $$$");   % /*	******	Code Starts Here	****				*/    /**    Get the initial values for the program.      Get the input file name.  */'     status = cli$present (&input_desc);        if (status == CLI$_PRESENT)      { > 	status2 = cli$get_value (&input_desc, &infile_desc, &retlen);   	if (status2 == CLI$_ABSENT) 	{6 	    printf ("\n input file specification missing\n"); 	    lib$stop (status2); 	}  	else if (status2 != SS$_NORMAL) 	{C 	    printf ("\n something wrong with input file specification\n");  	    lib$stop (status2); 	};      }      else     { 2 	printf ("\n input file specification missing\n"); 	lib$stop (status);      }; /*    Get the output file name. */(     status = cli$present (&output_desc);     if (status == CLI$_PRESENT)      { @ 	status2 = CLI$GET_VALUE (&output_desc, &outfile_desc, &retlen);   	if (status2 == CLI$_ABSENT) 	{7 	    printf ("\n output file specification missing\n");  	    lib$stop (status2); 	}  	else if (status2 != SS$_NORMAL) 	{D 	    printf ("\n something wrong with output file specification\n"); 	    lib$stop (status2); 	};      }      else     { 3 	printf ("\n output file specification missing\n");  	lib$stop (status);      }; /*    Open the input file.  */     in_fab = cc$rms_fab;     in_rab = cc$rms_rab;  B     in_fab.fab$l_fna = infile_desc.dsc$a_pointer; /* file name		*/I     in_fab.fab$b_fns = infile_desc.dsc$w_length;  /* size of file name	*/ 8     in_fab.fab$b_org = FAB$C_SEQ;	/* sequential file		*/2     in_fab.fab$b_fac = FAB$M_GET;	/* get only			*/8     in_fab.fab$b_shr = FAB$M_SHRGET;	/* shared read			*/4     in_rab.rab$l_fab = &in_fab;		/* specify fab			*/4     in_rab.rab$l_ubf = inbuf;		/* specify buffer		*/<     in_rab.rab$w_usz = sizeof (inbuf);	/* size of buffer		*/A     in_rab.rab$b_rac = RAB$C_SEQ;	/* specify sequential access	*/ @     in_rab.rab$l_rop = RAB$M_RRL |	/* read regardless of lock	*/- 		       RAB$M_NLK |	/* don't lock record		*/ ' 		       RAB$M_RAH |	/* read ahead			*/ - 		       RAB$M_WAT;	/* wait if locked (?)		*/   5     status = sys$open (&in_fab);	/* open the file		*/   7     if (status == RMS$_FNF)		/* if "File Not Found"		*/      { - 	exit (status);			/* system emits message		*/      } >     else if (status != RMS$_NORMAL)	/* for any other error		*/     { + 	lib$stop (status);		/* stop with trace		*/      };  D     status = sys$connect (&in_rab);	/* connect to the file stream	*/  8     if (status != RMS$_NORMAL)		/* quit on any error		*/     {  	lib$stop (status);      }; /*    Open the output file. */     out_fab = cc$rms_fab;      out_rab = cc$rms_rab;   C     out_fab.fab$l_fna = outfile_desc.dsc$a_pointer; /* file name	*/ F     out_fab.fab$b_fns = outfile_desc.dsc$w_length;  /* size of file	*/ 						    /* name		*/ 9     out_fab.fab$b_org = FAB$C_SEQ;	/* sequential file		*/ 3     out_fab.fab$b_fac = FAB$M_PUT;	/* put only			*/ :     out_fab.fab$l_fop = FAB$M_TEF |	/* truncate at EOF		*/+ 			FAB$M_MXV;	/* use next version number	*/ @     out_fab.fab$b_rfm = FAB$C_VAR;	/* output records variable	*/<     out_fab.fab$w_mrs = 4096;		/* set maximum record size	*/=     out_fab.fab$b_rat = FAB$M_CR;	/* set carriage control		*/   <     out_fab.fab$l_alq = 8192;		/* estimate based on tests	*/  5     out_rab.rab$l_fab = &out_fab;	/* specify fab			*/ <     out_rab.rab$l_rbf = inbuf;		/* specify (dummy) buffer	*/B     out_rab.rab$b_rac = RAB$C_SEQ;	/* specify sequential access	*/7     out_rab.rab$l_rop = RAB$M_WBH;	/* write behind			*/   <     status = sys$create (&out_fab);	/* create a new file		*/  8     if (status != RMS$_NORMAL)		/* exit on any error		*/     {  	lib$stop (status);      };  ?     status = sys$connect (&out_rab);	/* connect to the file		*/   8     if (status != RMS$_NORMAL)		/* exit on any error		*/     {  	lib$stop (status);      }; /*F    Read until we get to the first header line, which has the node name	    in it.  */     foundline = FALSE;  B     while (!foundline)		/* repeat until we get the line we want	*/     {      	status = get_record ();   	if (status > 0) 	{7 	    status2 = str$position (&temp_desc, &flagline, 0);    	    if (status2 != 0) 	    { 		foundline = TRUE;  	    };  	};      }; /*F    Found the first header line. This can be written out after a littleF    manipulation: pull out the node name, append a comma, then put back%    the rest of the line as a comment.  */=     status = str$element (&out_desc, &2, &space, &temp_desc);   2     if (status != SS$_NORMAL) lib$signal (status);  ,     status = str$append (&out_desc, &comma);  2     if (status != SS$_NORMAL) lib$signal (status);  0     status = str$append (&out_desc, &temp_desc);  2     if (status != SS$_NORMAL) lib$signal (status);       put_record (0);  /*D    The next line (# HOST) should contain the starting date and time.@    This needs to be extracted for the next two CSV header lines. */     status = get_record ();   :     status2 = str$position (&temp_desc, &started_line, 0);  ;     status = str$right (&temp2_desc, &temp_desc, &status2);   2     if (status != SS$_NORMAL) lib$signal (status); /*+    Extract and re-format the date and time.  */     parse_unix_date ();  /*E    The date and time need to go on separate lines. They can be parsed +    out as there is a space separating them.  */C     status = str$element (&out_desc, &0, &space, &datestring_desc);   2     if (status != SS$_NORMAL) lib$signal (status);       put_record (0);   C     status = str$element (&out_desc, &1, &space, &datestring_desc);   2     if (status != SS$_NORMAL) lib$signal (status);       put_record (0);  /*1    Mark the beginning of the column header lines.  */2     status = str$copy_dx (&out_desc, &start_head);  2     if (status != SS$_NORMAL) lib$signal (status);       put_record (0);  /*C    Read until we get to the next header line we want, which has the "    number of CPUs and DISKs in it. */     foundline = FALSE;  B     while (!foundline)		/* repeat until we get the line we want	*/     {      	status = get_record ();   	if (status > 0) 	{; 	    status2 = str$position (&temp_desc, &numcpus_line, 0);    	    if (status2 != 0) 	    { 		foundline = TRUE;  	    };  	};      };  C     firsttty = TRUE;	/* so the header line will be written later	*/        num_disks = 0;     firstdisk = TRUE;  /*G    Pull out the value for the number of disks. This should always be in     the same place. */;     status = str$len_extr (&temp2_desc, &in_desc, &56, &4);   2     if (status != SS$_NORMAL) lib$signal (status); /*G    Use an OTS routine to convert unsigned text to a long integer. The 4 C    means the integer size is four bytes, and the 17 sets flags that &    turn off errors on blanks and tabs. */;     status = ots$cvt_tu_l (&temp2_desc, &num_disks, 4, 17);   2     if (status != SS$_NORMAL) lib$signal (status); /*C    Read until we get to the next header line we want, which has the 2    number of (CPUs and DISKs) LANS and FSYS in it. */     foundline = FALSE;  J     while (!foundline)          /* repeat until we get the line we want */     {  	status = get_record ();   	if (status > 0) 	{; 	    status2 = str$position (&temp_desc, &numlans_line, 0);    	    if (status2 != 0) 	    { 		foundline = TRUE;  	    };  	};      };       num_lans = num_fsys = 0;      firstlan = firstfsys = TRUE; /*F    Pull out the value for the number of LANs. This should always be in    the same place. */;     status = str$len_extr (&temp2_desc, &in_desc, &19, &4);   2     if (status != SS$_NORMAL) lib$signal (status); /*G    Use an OTS routine to convert unsigned text to a long integer. The 4 C    means the integer size is four bytes, and the 17 sets flags that &    turn off errors on blanks and tabs. */:     status = ots$cvt_tu_l (&temp2_desc, &num_lans, 4, 17);  2     if (status != SS$_NORMAL) lib$signal (status); /*A    Pull out the value for the number of file systems. This should     always be in the same place.  */;     status = str$len_extr (&temp2_desc, &in_desc, &56, &4);   2     if (status != SS$_NORMAL) lib$signal (status); /*G    Use an OTS routine to convert unsigned text to a long integer. The 4 C    means the integer size is four bytes, and the 17 sets flags that &    turn off errors on blanks and tabs. */:     status = ots$cvt_tu_l (&temp2_desc, &num_fsys, 4, 17);  2     if (status != SS$_NORMAL) lib$signal (status); /*C    Read until we get to the next header line we want, which has the .    number of AdvFS Domains and Filesets in it. */     foundline = FALSE;  B     while (!foundline)		/* repeat until we get the line we want	*/     {      	status = get_record ();   	if (status > 0) 	{9 	    status2 = str$position (&temp_desc, &advfs_line, 0);    	    if (status2 != 0) 	    { 		foundline = TRUE;  	    };  	};      }; /*G    The number of volume queue statistics can be greater than the number C    of file systems, but for a first pass it will be set to the same 	    value.  */"     num_filesets = num_volque = 0;&     firstfileset = firstvolque = TRUE; /*G    Pull out the value for the number of filesets. This should always be     in the same place.  */;     status = str$len_extr (&temp2_desc, &in_desc, &56, &4);   2     if (status != SS$_NORMAL) lib$signal (status); /*G    Use an OTS routine to convert unsigned text to a long integer. The 4 C    means the integer size is four bytes, and the 17 sets flags that &    turn off errors on blanks and tabs. */>     status = ots$cvt_tu_l (&temp2_desc, &num_filesets, 4, 17);  2     if (status != SS$_NORMAL) lib$signal (status);  >     num_volque = num_filesets + 2;	    /* add safety margin	*/ /*/    Write the first part of the csv header list.  */2     status = str$copy_dx (&header_desc, &header1);  2     if (status != SS$_NORMAL) lib$signal (status);       put_record (1);   2     if (status != SS$_NORMAL) lib$signal (status);  @     num_proc = 0;	/* Initialize here in case there are no PID	*/ 			/* records later.				*/ /*    Reset counters. */.     for (proc = 0;  proc <= MAX_PROC;  proc++)     { / 	cpu[proc] = usrtim[proc] = systim[proc] = 0.0;  	rss[proc] = vsz[proc] = 0.0; ) 	count[proc] = ibk[proc] = obk[proc] = 0;  	maj[proc] = min[proc] = 0;      }; /*D    Next should be the main read loop where the data is collected and    processed */     while (TRUE)     {  	status = get_record ();   	if (status > 0) 	{ /*B    Look for a time stamp.  When we find one, initialize the output    string with it. */: 	    status2 = str$position (&temp_desc, &record_line, 0); 	    if (status2 > 0)  	    { /*=    Find the string using the open parenthesis as a delimiter.  */B 		status3 = str$element (&temp2_desc, &2, &openparen, &temp_desc);   		if (status3 > 0) 		{  /*,    Strip off the trailing close parenthesis. */H 		    status3 = str$element (&temp2_desc, &0, &closeparen, &temp2_desc); /*+    Extract and re-format the date and time.  */ 		    parse_unix_date ();  /*-    String is now ready to go into the record.  */: 		    status4 = str$copy_dx (&out_desc, &datestring_desc);5 		    if (status4 != SS$_NORMAL) lib$signal (status);  		}; 	    };  /*=    Look for the markers that start the various data segments.  */ /*/    Process Statistics. Look for a "# PID" line.  */7 	    status2 = str$position (&temp_desc, &pid_line, 0);    	    if (status2 > 0)  	    { /*    Reset counters. */ 		num_proc = 0;   , 		for (proc = 0;  proc <= MAX_PROC;  proc++) 		{ 4 		    cpu[proc] = usrtim[proc] = systim[proc] = 0.0;" 		    rss[proc] = vsz[proc] = 0.0;. 		    count[proc] = ibk[proc] = obk[proc] = 0;  		    maj[proc] = min[proc] = 0; 		}; /*A    Read and process records until there is a 'blank' record, or a     record starting with "#". */ 		while (get_record () > 0)  		{ : 		    status4 = str$position (&temp_desc, &pound_line, 0);   		    if (status4 > 0) break;  /*3    Count up 1 for each process for the grand total.  */ 		    num_proc = num_proc + 1; /**    Parse out the data from the input line. */; 		    status4 = sscanf (inbuf, "%d%s%lf%s%s%lf%lf%d%d%d%d",  				    &pidi, useri, &cpui, 				    rssi, vszi,  				    &usrtimi, &systimi, $ 				    &ibki, &obki, &maji, &mini); /*E    Using sscanf for the command line appears to have problems; things C    get messed up if the command has a space in it.  Use a different     method to get that. */6 		    status3 = str$element (&temp2_desc, &11, &space, 						&temp_desc);5 		    if (status3 != SS$_NORMAL) lib$signal (status);  /*  Used for debugging.  4     printf ("%d %d %s %f %s %s %f %f %d %d %d %d\n",- 		    status4, pidi, useri, cpui, rssi, vszi, 0 		    usrtimi, systimi, ibki, obki, maji, mini); */   /*6    Look for the processes that are going to be summed. */6 		    proc = 0;	/* indicate that we haven't found a	*/* 				/* matching process, count as OTHER	*/ /*E    Might want to look at the parsed user name, rather than the entire     input line. */4 		    status4 = str$position (&temp_desc, &root, 0);  4 		    if (status4 != 0)	/* string contains 'root'	*/ 		    {  			proc = 1; 		    };  5 		    status4 = str$position (&temp_desc, &admin, 0);   5 		    if (status4 != 0)	/* string contains 'admin'	*/  		    {  			proc = 2; 		    };  5 		    sum_proc_data ();	/* Sum up the process data	*/  /*     Repeat for selected commands. */' 		    proc = 0;		/* reset indicator		*/   4 		    status4 = str$position (&temp2_desc, &csh, 0);  6 		    if (status4 == 1)	/* string starts with "csh"	*/ 		    {  			proc = 3; 		    };  5 		    status4 = str$position (&temp2_desc, &java, 0);   7 		    if (status4 == 1)	/* string starts with "java"	*/  		    {  			proc = 4; 		    };  5 		    status4 = str$position (&temp2_desc, &make, 0);   5 		    if (status4 != 0)	/* command contains "make"	*/  		    {  			proc = 5; 		    };  5 		    status4 = str$position (&temp2_desc, &perl, 0);   7 		    if (status4 == 1)	/* string starts with "perl"	*/  		    {  			proc = 6; 		    };  3 		    status4 = str$position (&temp2_desc, &ar, 0);   5 		    if (status4 == 1)	/* string starts with "ar"	*/  		    {  			proc = 7; 		    };  3 		    status4 = str$position (&temp2_desc, &ld, 0);   5 		    if (status4 == 1)	/* string starts with "ld"	*/  		    {  			proc = 8; 		    };  3 		    status4 = str$position (&temp2_desc, &nm, 0);   5 		    if (status4 == 1)	/* string starts with "nm"	*/  		    {  			proc = 9; 		    };  4 		    status4 = str$position (&temp2_desc, &ksh, 0);  6 		    if (status4 == 1)	/* string starts with "ksh"	*/ 		    { 
 			proc = 10;  		    };  5 		    status4 = str$position (&temp2_desc, &tcsh, 0);   7 		    if (status4 == 1)	/* string starts with "tcsh"	*/  		    { 
 			proc = 11;  		    };  0 		    if (proc != 0)		/* if there was a match */ 		    { ( 			sum_proc_data ();	/* sum the data		*/ 		    };0 		};	    /* end of while looking for PID data	*/ /*E    The actual conversion of data and inclusion in the data line is in D    the "# TTY" section. This is because there isn't always a "# PID"G    data section, as the sampling interval can be less frequent than the     other data items. */& 	    };	/* end of "Process" data				*/ /*    Disk Statistics */9 	    status2 = str$position (&temp_desc, &disk_stats, 0);    	    if (status2 > 0)L 	    { /*    Skip over the header lines. */ 		status3 = get_record (); /*A    Get the data values from this line. If this is the first time,T1    then the CSV header line also has to be built.o */# 		for (j = 0;  j < num_disks;  j++): 		{  		    status3 = get_record ();  : 		    if (firstdisk)  /* pull out disk names for header	*/ 		    {2C 		    	status4 = str$element (&temp2_desc, &1, &space, &temp_desc);s  2 			if (status4 != SS$_NORMAL) lib$signal (status);  - 			strncpy (dsknam, temp2_desc.dsc$a_pointer,- 					temp2_desc.dsc$w_length);  * 			dsknam[temp2_desc.dsc$w_length] = '\0';   			sprintf (header,      "[DISK %s]reads/s,[DISK %s]reads kB/s,[DISK %s]writes/s,[DISK %s]writes kB/s,[DISK %s]average service time mS,[DISK %s]average wait time mS,[DISK %s]active queue len,[DISK %s]wait queue len,[DISK %s]%%busy",2L     dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam);    			str_length = strlen (header);  = 			status4 = str$copy_r (&header_desc, &str_length, &header);   2 			if (status4 != SS$_NORMAL) lib$signal (status);  9 			put_record (1);	    /* write out this header list   */i 		    };  ! 		    for (i = 3;  i <= 11;  i++)	 		    {0? 			status4 = str$element (&temp2_desc, &i, &space, &temp_desc);0  2 			if (status4 != SS$_NORMAL) lib$signal (status);  , 			status4 = str$append (&out_desc, &comma);  2 			if (status4 != SS$_NORMAL) lib$signal (status);  1 			status4 = str$append (&out_desc, &temp2_desc);d  2 			if (status4 != SS$_NORMAL) lib$signal (status); 		    }; 		};   		if (firstdisk) 		{/ 		    firstdisk = FALSE; /*F    Add on the rest of the headers that come between disk data and file    sets. */2 		    status = str$copy_dx (&header_desc, &cpus1);  4 		    if (status != SS$_NORMAL) lib$signal (status);   		    put_record (1);*  2 		    status = str$copy_dx (&header_desc, &cpus2);  4 		    if (status != SS$_NORMAL) lib$signal (status);   		    put_record (1);c  2 		    status = str$copy_dx (&header_desc, &cpus3);  4 		    if (status != SS$_NORMAL) lib$signal (status);   		    put_record (1);   1 		    status = str$copy_dx (&header_desc, &cpu0);l  4 		    if (status != SS$_NORMAL) lib$signal (status);   		    put_record (1);_  1 		    status = str$copy_dx (&header_desc, &cpu1);u  4 		    if (status != SS$_NORMAL) lib$signal (status);   		    put_record (1);h  1 		    status = str$copy_dx (&header_desc, &cpu2);s  4 		    if (status != SS$_NORMAL) lib$signal (status);   		    put_record (1);   1 		    status = str$copy_dx (&header_desc, &cpu3);.  4 		    if (status != SS$_NORMAL) lib$signal (status);   		    put_record (1);;  1 		    status = str$copy_dx (&header_desc, &mem1);K  4 		    if (status != SS$_NORMAL) lib$signal (status);   		    put_record (1);D  1 		    status = str$copy_dx (&header_desc, &mem2);   4 		    if (status != SS$_NORMAL) lib$signal (status);   		    put_record (1);a  1 		    status = str$copy_dx (&header_desc, &mem3);0  4 		    if (status != SS$_NORMAL) lib$signal (status);   		    put_record (1);n  1 		    status = str$copy_dx (&header_desc, &mem4);f  4 		    if (status != SS$_NORMAL) lib$signal (status);   		    put_record (1);m 		;}$ 	    };	/* end of "DISK" data					*/   /*    Volume I/O Queue Statistics */; 	    status2 = str$position (&temp_desc, &volque_stats, 0);	   	    if (status2 > 0)a 	    { /*A    Get the data values from this line. If this is the first time,M1    then the CSV header line also has to be built.n */$ 		for (j = 0;  j < num_volque;  j++) 		{j 		    status3 = get_record (); /*>    Since the number of data lines can be over-estimated, it isD    necessary to check to see that there really is a line to process. */ 		    if (status3 > 0) 		    {i- 			if (firstvolque)	/* pull out domain.vol	*/S 			{			/* names for header	*/rA 			    status4 = str$element (&temp2_desc, &0, &space, &in_desc);"  6 			    if (status4 != SS$_NORMAL) lib$signal (status);  1 			    strncpy (dsknam, temp2_desc.dsc$a_pointer,e 					temp2_desc.dsc$w_length);  . 			    dsknam[temp2_desc.dsc$w_length] = '\0';   			    sprintf (header,     "[volq %s]reads,[volq %s]writes,[volq %s]reads consolidated,[volq %s]reads avg blocks/consolidated,[volq %s]writes consolidated,[volq %s]writes avg blocks/consolidated,[volq %s]queue requests blocking,[volq %s]queue requests flush,[volq %s]queue requests wait lazy,[volq %s]queue requests smooth sync,[volq %s]queue requests ready lazy,[volq %s]queue requests consol,[volq %s]queue requests device",tl     dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam);  $ 			    str_length = strlen (header);  A 			    status4 = str$copy_r (&header_desc, &str_length, &header);   6 			    if (status4 != SS$_NORMAL) lib$signal (status);   			    put_record (1); 			};s   			for (i = 1;  i <= 13;  i++) 			{C 			    status4 = str$element (&temp2_desc, &i, &space, &temp_desc);r  6 			    if (status4 != SS$_NORMAL) lib$signal (status); /*F    Need to strip out numeric part and look to see if there is a "K" orF    "M" suffix.  If so, value needs to be scaled.  Start by copying theA    input text to a character string, because atoi will ignore the )    trailing "K" or "M" during conversion.( */0 			    strncpy (temp3, temp2_desc.dsc$a_pointer, 					temp2_desc.dsc$w_length);  - 			    temp3[temp2_desc.dsc$w_length] = '\0';   3 			    k = atoi (temp3);	/* convert numeric part	*/t  4 			    status4 = str$position (&temp2_desc, &kk, 0);  . 			    if (status4 != 0)	/* a "K" was found	*/ 			    {$ 				k = k * 1000;	/* scale by 1k		*/	 			    };t  4 			    status4 = str$position (&temp2_desc, &mm, 0);  / 			    if (status4 != 0)	/* an "M" was found	*/M 			    {& 				k = k * 1000000;	/* scale by 1M	*/	 			    };i  3 			    sprintf (temp3, "%d", k);	/* back to text	*/s  # 			    str_length = strlen (temp3);   ? 			    status4 = str$copy_r (&temp2_desc, &str_length, &temp3);   6 			    if (status4 != SS$_NORMAL) lib$signal (status);  0 			    status4 = str$append (&out_desc, &comma);  6 			    if (status4 != SS$_NORMAL) lib$signal (status);  5 			    status4 = str$append (&out_desc, &temp2_desc);r  6 			    if (status4 != SS$_NORMAL) lib$signal (status); 			};a4 		    }	/* end of if there is a record to process	*/
 		    else 		    {E9 		    	num_volque = j;	/* set actual number of volumes	*/s, 		    };			/* end of I/O queue processing	*/ 		};   		if (firstvolque) 		{/ /*,    Note that we don't have to do this again. */ 		    firstvolque = FALSE; 		;}  / 	    };	/* end of "volume I/O queue " data			*/  /*    Filesets Statistics */< 	    status2 = str$position (&temp_desc, &fileset_stats, 0);   	    if (status2 > 0)  	    { /*A    Get the data values from this line. If this is the first time,a1    then the CSV header line also has to be built.h */& 		for (j = 0;  j < num_filesets;  j++) 		{  		    status3 = get_record ();  9 		    if (firstfileset)  /* pull out fileset names for	*/u 		    {		       /* header			*/A 		    	status4 = str$element (&temp2_desc, &0, &space, &in_desc);)  2 			if (status4 != SS$_NORMAL) lib$signal (status);  - 			strncpy (dsknam, temp2_desc.dsc$a_pointer,  					temp2_desc.dsc$w_length);  * 			dsknam[temp2_desc.dsc$w_length] = '\0';   			sprintf (header, 8    "[vnode %s]file lookups,[vnode %s]file creates,[vnode %s]get attributes,[vnode %s]file reads,[vnode %s]file writes,[vnode %s]file syncs,[vnode %s]data syncs,[vnode %s]file removes,[vnode %s]file renames,[vnode %s]directory reads,[vnode %s]directory makes,[vnode %s]directory removes,[vnode %s]links created",l     dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam);    			str_length = strlen (header);  = 			status4 = str$copy_r (&header_desc, &str_length, &header);t  2 			if (status4 != SS$_NORMAL) lib$signal (status);   			put_record (1); 		    };  ! 		    for (i = 1;  i <= 13;  i++)e 		    {	? 			status4 = str$element (&temp2_desc, &i, &space, &temp_desc);   2 			if (status4 != SS$_NORMAL) lib$signal (status); /*F    Need to strip out numeric part and look to see if there is a "K" orF    "M" suffix.  If so, value needs to be scaled.  Start by copying theA    input text to a character string, because atoi will ignore the )    trailing "K" or "M" during conversion.r */, 			strncpy (temp3, temp2_desc.dsc$a_pointer, 					temp2_desc.dsc$w_length);  ) 			temp3[temp2_desc.dsc$w_length] = '\0';g  / 			k = atoi (temp3);	/* convert numeric part	*/=  0 			status4 = str$position (&temp2_desc, &kk, 0);  * 			if (status4 != 0)	/* a "K" was found	*/ 			{' 			    k = k * 1000;	/* scale by 1k		*/a 			};u  0 			status4 = str$position (&temp2_desc, &mm, 0);  + 			if (status4 != 0)	/* an "M" was found	*/l 			{* 			    k = k * 1000000;	/* scale by 1M		*/ 			};r  / 			sprintf (temp3, "%d", k);	/* back to text	*/=   			str_length = strlen (temp3);   ; 			status4 = str$copy_r (&temp2_desc, &str_length, &temp3);a  2 			if (status4 != SS$_NORMAL) lib$signal (status);  , 			status4 = str$append (&out_desc, &comma);  2 			if (status4 != SS$_NORMAL) lib$signal (status);  1 			status4 = str$append (&out_desc, &temp2_desc);   2 			if (status4 != SS$_NORMAL) lib$signal (status); 		    }; 		};   		if (firstfileset)l 		{  /*,    Note that we don't have to do this again. */ 		    firstfileset = FALSE;* 		;}  ' 	    };	/* end of "filesets" data				*/  /*    Network Statisticsn */C             status2 = str$position (&temp_desc, &network_stats, 0);r               if (status2 > 0)
             {a /*    Skip over the header lines. */(                 status3 = get_record (); /*F    Get the data values from this line. If this is the first time, then,    the CSV header line also has to be built. */" 		for (j = 0;  j < num_lans;  j++) 		{  		    status3 = get_record ();  : 		    if (firstlan)   /* pull out file system names for	*/ 		    {		    /* header				*/? 			status4 = str$element (&temp2_desc, &1, &space, &temp_desc);   2 			if (status4 != SS$_NORMAL) lib$signal (status);  - 			strncpy (dsknam, temp2_desc.dsc$a_pointer,l 					temp2_desc.dsc$w_length);  * 			dsknam[temp2_desc.dsc$w_length] = '\0';   			sprintf (header,;     "[LAN %s]In pck/s,[LAN %s]In Err/s,[LAN %s]Out pck/s,[LAN %s]Out Err/s,[LAN %s]Collisions /s,[LAN %s]In kB/s,[LAN %s]Out kB/s,[LAN %s]%%BW",E      dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam, dsknam);+    			str_length = strlen (header);  = 			status4 = str$copy_r (&header_desc, &str_length, &header);i  2 			if (status4 != SS$_NORMAL) lib$signal (status);   			put_record (1);                     }; /*    Get data items. */  		    for (i = 2;  i <= 9;  i++) 		    {s? 			status4 = str$element (&temp2_desc, &i, &space, &temp_desc);f  2 			if (status4 != SS$_NORMAL) lib$signal (status);  , 			status4 = str$append (&out_desc, &comma);  2 			if (status4 != SS$_NORMAL) lib$signal (status);  1 			status4 = str$append (&out_desc, &temp2_desc);t  2 			if (status4 != SS$_NORMAL) lib$signal (status); 		    }; 		};   		if (firstlan)c 		{r /*,    Note that we don't have to do this again. */ 		    firstlan = FALSE;l                 ;}J             };  /* end of "LAN" data                                    */ /*    CPU SUMMARY */< 	    status2 = str$position (&temp_desc, &cpu_sum_stats, 0);   	    if (status2 > 0)" 	    { /*    Skip over the header line.D */ 		status3 = get_record (); /*%    Get the data values from this linen */ 		status3 = get_record ();   		for (i = 0;  i <= 12;  i++)  		{SB 		    status4 = str$element (&temp2_desc, &i, &space, &temp_desc);5 		    if (status4 != SS$_NORMAL) lib$signal (status);t/ 		    status4 = str$append (&out_desc, &comma);s5 		    if (status4 != SS$_NORMAL) lib$signal (status);"4 		    status4 = str$append (&out_desc, &temp2_desc);5 		    if (status4 != SS$_NORMAL) lib$signal (status);O 		}; /*C    Assume that what comes next is the single cpu statistics. (CouldTD    check for # SINGLE CPU STATISTICS). Skip over the next two lines. */ 		status3 = get_record (); 		status3 = get_record (); /*D    For now, the extraction process is designed for systems with four    CPUs. */ 		for (j = 0;  j <= 3;  j++) 		{  		    status3 = get_record ();    		    for (i = 1;  i <= 4;  i++) 		    {d? 			status4 = str$element (&temp2_desc, &i, &space, &temp_desc);n2 			if (status4 != SS$_NORMAL) lib$signal (status);, 			status4 = str$append (&out_desc, &comma);2 			if (status4 != SS$_NORMAL) lib$signal (status);1 			status4 = str$append (&out_desc, &temp2_desc);)2 			if (status4 != SS$_NORMAL) lib$signal (status); 		    }; 		};# 	    };	/* end of "CPU" data					*/P /*#    Next marker is MEMORY STATISTICS, */; 	    status2 = str$position (&temp_desc, &memory_stats, 0);a   	    if (status2 > 0)* 	    { /*    Skip over the header lines. */ 		status3 = get_record (); 		status3 = get_record (); /*%    Get the data values from this lineS */ 		status3 = get_record ();   		for (i = 0;  i <= 14;  i++)U 		{ B 		    status4 = str$element (&temp2_desc, &i, &space, &temp_desc);5 		    if (status4 != SS$_NORMAL) lib$signal (status);c/ 		    status4 = str$append (&out_desc, &comma);f5 		    if (status4 != SS$_NORMAL) lib$signal (status);s4 		    status4 = str$append (&out_desc, &temp2_desc);5 		    if (status4 != SS$_NORMAL) lib$signal (status);O 		};  & 	    };	/* end of "MEMORY" data					*/ /*    FileSystem Statistics */9 	    status2 = str$position (&temp_desc, &fsys_stats, 0);    	    if (status2 > 0)m 	    { /*    Skip over the header lines. */ 		status3 = get_record (); /*(   Should check to see it's really "# FS" */   /*A    Get the data values from this line. If this is the first time,S1    then the CSV header line also has to be built.p */" 		for (j = 0;  j < num_fsys;  j++) 		{B 		    status3 = get_record ();  < 		    if (firstfsys)  /* pull out file system names for   */< 		    {               /* header                           */? 			status4 = str$element (&temp2_desc, &1, &space, &temp_desc);R  2 			if (status4 != SS$_NORMAL) lib$signal (status);  - 			strncpy (dsknam, temp2_desc.dsc$a_pointer,T 					temp2_desc.dsc$w_length);  * 			dsknam[temp2_desc.dsc$w_length] = '\0';   			sprintf (header,E, 				"[FSys %s]Capacity MB,[FSys %s]Free MB", 				dsknam, dsknam);    			str_length = strlen (header);  = 			status4 = str$copy_r (&header_desc, &str_length, &header);S  2 			if (status4 != SS$_NORMAL) lib$signal (status);  9 			put_record (1);	    /* write out this header list   */] 		    }; /*    Get data items. */  		    for (i = 2;  i <= 3;  i++) 		    {S? 			status4 = str$element (&temp2_desc, &i, &space, &temp_desc);O  2 			if (status4 != SS$_NORMAL) lib$signal (status);  , 			status4 = str$append (&out_desc, &comma);  2 			if (status4 != SS$_NORMAL) lib$signal (status);  1 			status4 = str$append (&out_desc, &temp2_desc);S  2 			if (status4 != SS$_NORMAL) lib$signal (status); 		    }; 		};   		if (firstfsys) 		{s /*,    Note that we don't have to do this again. */ 		    firstfsys = FALSE; 		;}  J             };  /* end of "fsys" data                                   */ /*'    Next (last) marker is TTY StatisticsO */8 	    status2 = str$position (&temp_desc, &tty_stats, 0);   	    if (status2 > 0)  	    { /*    Skip over the header line.u */ 		status3 = get_record (); /*/   Should check to see it's really in, out, etc.P */   /*%    Get the data values from this linee */ 		status3 = get_record ();   		for (i = 0;  i <= 3;  i++) 		{ B 		    status4 = str$element (&temp2_desc, &i, &space, &temp_desc);5 		    if (status4 != SS$_NORMAL) lib$signal (status);M/ 		    status4 = str$append (&out_desc, &comma);S5 		    if (status4 != SS$_NORMAL) lib$signal (status);T4 		    status4 = str$append (&out_desc, &temp2_desc);5 		    if (status4 != SS$_NORMAL) lib$signal (status);  		}; /*G    Append the "# PID" data as the last data item.  This is done here asAA    the number of samples can be less than that for all other dataD	    items.[  ,    Start with the total number of processes. */$ 		sprintf (header, ",%d", num_proc);   		str_length = strlen (header);M  < 		status3 = str$copy_r (&header_desc, &str_length, &header);  1 		if (status3 != SS$_NORMAL) lib$signal (status);M  1 		status3 = str$append (&out_desc, &header_desc);  /*F    Format the rest of the data. Re-use the header string for temporary    storage.N */, 		for (proc = 0;  proc <= MAX_PROC;  proc++) 		{n 		    sprintf (header,3 			",%d,%3.1f,%3.3f,%3.3f,%5.3f,%5.3f,%d,%d,%d,%d",O4 			    count[proc], cpu[proc], rss[proc], vsz[proc],8 			    usrtim[proc], systim[proc], ibk[proc], obk[proc], 			    maj[proc], min[proc]);M  # 		    str_length = strlen (header);D@ 		    status3 = str$copy_r (&header_desc, &str_length, &header);  5 		    if (status3 != SS$_NORMAL) lib$signal (status);D  5 		    status3 = str$append (&out_desc, &header_desc);   5 		    if (status3 != SS$_NORMAL) lib$signal (status);h 		};   		if (firsttty), 		{A /*,    Note that we don't have to do this again. */ 		    firsttty = FALSE;  /*5    Add on the TTY and total number of processes line.P */2 		    status4 = str$copy_dx (&header_desc, &tty1);  6 		    if (status4 != SS$_NORMAL) lib$signal (status4);   		    put_record (1);U /*,    Add on the user and command header lines. */2 		    status4 = str$copy_dx (&header_desc, &oth1);6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);e  2 		    status4 = str$copy_dx (&header_desc, &oth2);6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);e  2 		    status4 = str$copy_dx (&header_desc, &oth3);6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);   2 		    status4 = str$copy_dx (&header_desc, &roo1);6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);   2 		    status4 = str$copy_dx (&header_desc, &roo2);6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);   2 		    status4 = str$copy_dx (&header_desc, &roo3);6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);a  2 		    status4 = str$copy_dx (&header_desc, &csh1);6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);i  2 		    status4 = str$copy_dx (&header_desc, &csh2);6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);t  2 		    status4 = str$copy_dx (&header_desc, &csh3);6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);)  3 		    status4 = str$copy_dx (&header_desc, &java1); 6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);b  3 		    status4 = str$copy_dx (&header_desc, &java2); 6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);n  3 		    status4 = str$copy_dx (&header_desc, &java3); 6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);R  3 		    status4 = str$copy_dx (&header_desc, &make1);b6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);   3 		    status4 = str$copy_dx (&header_desc, &make2);	6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);r  3 		    status4 = str$copy_dx (&header_desc, &make3);/6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);a  3 		    status4 = str$copy_dx (&header_desc, &perl1);*6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);=  3 		    status4 = str$copy_dx (&header_desc, &perl2); 6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);O  3 		    status4 = str$copy_dx (&header_desc, &perl3);a6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);*  1 		    status4 = str$copy_dx (&header_desc, &ar1);M6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);   1 		    status4 = str$copy_dx (&header_desc, &ar2);b6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);i  1 		    status4 = str$copy_dx (&header_desc, &ar3);l6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);a  1 		    status4 = str$copy_dx (&header_desc, &ld1);_6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);   1 		    status4 = str$copy_dx (&header_desc, &ld2);e6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);	  1 		    status4 = str$copy_dx (&header_desc, &ld3);o6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);   1 		    status4 = str$copy_dx (&header_desc, &nm1);t6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);$  1 		    status4 = str$copy_dx (&header_desc, &nm2);_6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);o  1 		    status4 = str$copy_dx (&header_desc, &nm3);s6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);)  2 		    status4 = str$copy_dx (&header_desc, &ksh1);6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);   2 		    status4 = str$copy_dx (&header_desc, &ksh2);6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);s  2 		    status4 = str$copy_dx (&header_desc, &ksh3);6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);l  3 		    status4 = str$copy_dx (&header_desc, &tcsh1); 6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);   3 		    status4 = str$copy_dx (&header_desc, &tcsh2); 6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);   3 		    status4 = str$copy_dx (&header_desc, &tcsh3);n6 		    if (status4 != SS$_NORMAL) lib$signal (status4); 		    put_record (1);  /*C    This is the last data set (for now), so put out the divider that(,    marks the end of the column header lines. */6 		    status4 = str$copy_dx (&header_desc, &end_head);  6 		    if (status4 != SS$_NORMAL) lib$signal (status4);   		    put_record (1);_                 ;}  ; 	    put_record (0);	/* Last item collected, write data.	*/   # 	    };	/* end of "TTY" data					*/c8 	};	/* end of status > 0 (i.e., something to process)	*/+     };		/* end of big while TRUE loop				*//  	 exit_out:=       close_files ();         return;		/* All done.					*/ }a