) $ SAVE_VERIFY = F$VERIFY(P3) !+ TO.COM     $ > $!   PURPOSE: TO.COM is designed for interactive use to allow D $!            users to change defaults and refer to recent defaults : $!            quickly and easily on Files-11 ODS-2 disks.  $!6 $!   AUTHOR:  Alan E. Feldman  betaneptune\a\yahoo.com $!@ $!   HELP:    Run  @TO.COM -HELP  to see the Quick Help screen.  $!   $!   PARAMETERS: $!? $!   P1:  [disk:][directory], logical name, or reserved keyword  $!  B $!   P2:  1 or Y:  save old default in the recall stack (default) > $!        0 or N:  do not save old default in the recall stack $!   $!   P3:  1 ==> SET VERIFY  ' $!        0 ==> SET NOVERIFY (default)   $!  . $    SET SYMBOL/SCOPE=(NOLOCAL,NOGLOBAL)/VERB  $  $!!  *** User Settings ***I $    STACK_SIZE = 9	! Total number of slots in logical name recall stack. D $    TO_PROMPT = 0	! If true, set prompt string to current default. H $    TO_BRIEF = 0	! If true, omit match value and outgoing recall stack.? $    TO_BACK = 0	! If true, use old nBACK-style logical names.   $ I $!!  *** Logical names for overriding the above default user settings *** N $    IF (F$TRNLNM("TO_PROMPT").NES."") THEN TO_PROMPT = F$TRNLNM("TO_PROMPT") K $    IF (F$TRNLNM("TO_BRIEF").NES."") THEN TO_BRIEF = F$TRNLNM("TO_BRIEF")  H $    IF (F$TRNLNM("TO_BACK").NES."") THEN TO_BACK = F$TRNLNM("TO_BACK")	< $    DEFINE/NOLOG TO_BACK 'TO_BACK'	! For SAVE_DEFAULT.COM.  $   $!!  *** Initialize symbols ***  $    WSC := WRITE SYS$COMMAND  $    WSO := WRITE SYS$OUTPUT  g $    SET_DEFAULT = ""   !! reset in defsski  !! Default after SET DEF 'P1; used to check final default   $    P1 = F$EDIT(P1,"UPCASE") [ $    INITIAL_P1 = P1 	!! reset in defsski  !! P1 as entered by the user after symbol subst. Y $    P1BAD = 0 		!! reset in defsski  !! Flag: 1 ==> problem with P1 (new default is bad) Q $    DEFSSKI = 0 	!! reset in defsski  !! Flag: 1 ==> user was prompted for input Z $    DEF_TO_LOST = 0 	!! only here	     !! Flag: 1 ==> we will define TO_LOST in _SET_LNMSO $    LNMS_OK = 1 	!! only here         !! Flag: 0 ==> a failed run of _SET_LNMS a $    DIFF_DEFAULT_FOUND = 0 	!! only here !! Flag: 1 ==> unexpected old default found (for stack) d $    OTHER_DEFAULT_FOUND = 0 	!! only here !! Flag: 1 ==> unexpected old default found (for message)S $    PATHOLOGICAL = 0	!! only here	     !! Flag: 1 ==> Old default was pathological  $ ! $!!  *** Define status codes ***   $    TO__STATUS = %X18008000  ' $    TO__SUCCESS = TO__STATUS + %X0001  % $    TO__ERROR = TO__STATUS + %X0002  $ $    TO__FATAL = TO__STATUS + %X0004) $    TO__CONTROL_Y = TO__STATUS + %X000C  G $!********************************************************************    $!!  *** Establish handlers ***  $    STATUS = TO__SUCCESS ) $    ON CONTROL_Y THEN EXIT TO__CONTROL_Y / $    ON WARNING THEN EXIT $STATUS.OR.%X10000000  $ > $!!  *** Display help screen if not previously initialized ***? $    IF (P1.EQS."" .AND. F$TRNLNM("TO_0").EQS."") THEN P1 = "H"  $ E $!!  *** Check for old default being unusable (or "pathological") ***  $    GOSUB _PATHOLOGICAL $ & $!!  *** Save value of HERE (TO_0) *** $    OLDDEF = F$TRNLNM("TO_0")  ' $    OLDDEF_RAW = F$TRNLNM("TO_RAW_0")   $ / $!!  *** Define HERE and if requested, init *** E $    GOSUB _DEFINE_HERE           ! Define new value of HERE (TO_0).  + $    IF (P1.EQS."/INIT") THEN GOTO _EXIT4   + $    IF (P1.EQS."-INIT") THEN GOTO _EXIT4    $ 2 $!!  *** Check for unexpected initial default ***  $    INITIAL_DEF = HERE   $    INITIAL_DEF_RAW = HERE_RAW > $    IF ( (OLDDEF .NES. "") .AND. (OLDDEF .NES. INITIAL_DEF) -2        .AND. (OLDDEF_RAW .NES. INITIAL_DEF_RAW) ) 
 $    THEN   $        DIFF_DEFAULT_FOUND = 1 ! $        OTHER_DEFAULT_FOUND = 1  ! $        IF (.NOT.PATHOLOGICAL) - [            THEN WSO "%TO-W-DEFCHGD, default was changed by another program to ",INITIAL_DEF  $    ENDIF   $ . $    IF  (P1.EQS."" .AND. DIFF_DEFAULT_FOUND) 
 $    THEN   $        DIFF_DEFAULT_FOUND = 0 ' $        ON WARNING THEN GOTO _RUN_DEFS  $        GOSUB _SET_LNMSE $        OLDDEF = HERE			!! Because we just ran _set_lnms, we need to < $        OLDDEF_RAW = HERE_RAW		!!   update these variables.X $        WSO "%TO-I-LNMSUPD, LNM recall stack updated with current default ",INITIAL_DEF $    ENDIF   $  $_RUN_DEFS: % $			ON CONTROL_Y THEN GOTO _CONTROL_Y , $    			ON WARNING THEN GOTO _CHECK_DEFSSKI  $ . $    IF (P1.EQS."") THEN GOSUB _GET_NEW_PARAMS$ $    IF (P1.EQS."") THEN GOTO _EXIT3 $ @ $    IF (F$LOCATE(",",P1).NE.F$LENGTH(P1)) THEN GOSUB _2STEP_P1	 $ * $    			IF (P1BAD) THEN GOTO _NO_SUCH_DEF  $    GOSUB _PROCESS_P1  * $    			IF (P1BAD) THEN GOTO _NO_SUCH_DEF  $    GOSUB _CHECK_P1  * $    			IF (P1BAD) THEN GOTO _NO_SUCH_DEF  $    GOSUB _SET_DEF * $    			IF (P1BAD) THEN GOTO _NO_SUCH_DEF  $  $    IF (DIFF_DEFAULT_FOUND)  
 $    THEN J $        DEF_TO_LOST = 1   ! for define to_lost 'initial_def' in set_lnms   $        DIFF_DEFAULT_FOUND = 0  $    ENDIF   $   $    ON WARNING THEN GOTO _EXIT2 $    GOSUB _SET_LNMS   $    GOTO _EXIT2 $ 
 $_CONTROL_Y:   $    STATUS = TO__CONTROL_Y  $    SET NOON 
 $    WSO " "  3 $    WSO " ***  TO.COM aborted by Control/Y  *** "  
 $    WSO " "   $    GOTO _EXIT3 $  $_NO_SUCH_DEF:  
 $    SET NOON 2 $    SET DEFAULT TO_HERE 	! Fix bad SET DEF result $    IF (DIFF_DEFAULT_FOUND)  
 $    THEN   $        DIFF_DEFAULT_FOUND = 0 , $        ON WARNING THEN GOTO _CHECK_DEFSSKI $        GOSUB _SET_LNMS  X $        WSO "%TO-I-LNMSUPD, LNM recall stack updated with current default ",INITIAL_DEF $    ENDIF   $  $_CHECK_DEFSSKI:   $    STATUS = $STATUS  $    SET NOON 2 $    SET DEFAULT TO_HERE 	! Fix bad SET DEF result $    IF (DEFSSKI) 
 $    THEN  $        P1 = ""   $        INITIAL_P1 = ""   $        P1BAD = 0   $        STATUS = TO__SUCCESS  $        DEFSSKI = 0   $        SET_DEFAULT = ""	P $        GOTO _RUN_DEFS  ! Error occurred at TO prompt, so return to TO prompt.  $    ENDIF  R $    GOTO _EXIT2         ! Error occurred at DCL prompt, so return to DCL prompt.  $ 	 $_EXIT2:   $    SET NOON . $    IF (.NOT.TO_BRIEF) THEN GOSUB _SHOW_DEFS  $    WSO  " " 	 $_EXIT3:   $    SET NOON  $    SET DEFAULT TO_HERE   $    WSO "Your default is "  $    SHOW DEFAULT  $    IF (.NOT.LNMS_OK)  
 $    THEN  $        WSO " "  J $        WSO "%TO-W-LNMSUPDERR, error updating LNM defaults recall stack" U $        WSO "-TO-W-LNMSUPDERR, some entries from 1 and up may not have been updated"  $    ENDIF  M $!!  *** Next statement is for the case of ^Y between _SET_DEF and SET_LNMS,  3 $!         since EXIT3 does a SET DEF TO_HERE. ***  ; $    NEWDEF_SET = F$ENVIRONMENT("DEFAULT").EQS.SET_DEFAULT  2 $    IF (INITIAL_P1.NES."" .AND. .NOT.NEWDEF_SET) 
 $    THEN I $        IF ((%X7.AND.F$INTEGER(STATUS)) .NE. 4) THEN STATUS = TO__ERROR   $        WSO " "  4 $        WSO "%TO-E-DEFNOTSET, new default not set"  $    ENDIF  
 $    WSO " "   $_EXIT4:' $    IF (TO_PROMPT) THEN GOSUB _PROMPT   $_EXIT5:G $    EXIT STATUS+0*F$VERIFY(SAVE_VERIFY).OR.%X10000000! Exiting TO.COM   $!  ! $!   *** END OF MAIN PROGRAM ***   $ F $!********************************************************************E $!!  *** This subroutine shows the stack, prompts for new params, and A $!   processes them into their final form for P1, P2, and P3. ***  $ & $_GET_NEW_PARAMS:  ! local subroutine  $  $!!  *** Get user input ***  $  $    N = STACK_SIZE  $    IF (.NOT.TO_BACK) $    THEN		!! to_'n' style' $        TO_SAVE = F$TRNLNM("TO_SAVE")  ' $        TO_LOST = F$TRNLNM("TO_LOST")   $        WSO " "  R $        IF (TO_SAVE.NES."") THEN WSO  "Enter   S   for ", " TO_SAVE = ", TO_SAVE R $        IF (TO_LOST.NES."") THEN WSO  "Enter   L   for ", " TO_LOST = ", TO_LOST ' $    50:     IF (N.LT.1) THEN GOTO 59 	 * $            TO_'N' = F$TRNLNM("TO_''N'") W $            IF (TO_'N'.NES."") THEN WSO  "Enter   ''N'   for ", " TO_''N' = ", TO_'N'   $            N = N - 1   $            GOTO 50  	 $    59:  K $        WSO  "Press <RET> for ", " TO_0 = ", HERE, "  ! (current default)"  $    ELSE		!! nback style ! $        SAVE = F$TRNLNM("SAVE")  ! $        LOST = F$TRNLNM("LOST")   $        WSO " "  I $        IF (SAVE.NES."") THEN WSO  "Enter   S   for ", " SAVE = ", SAVE  I $        IF (LOST.NES."") THEN WSO  "Enter   L   for ", " LOST = ", LOST  ' $    150:    IF (N.LT.2) THEN GOTO 159  + $            TO_'N' = F$TRNLNM("''N'BACK")  W $            IF (TO_'N'.NES."") THEN WSO  "Enter   ''N'   for ", "''N'BACK = ", TO_'N'   $            N = N - 1   $            GOTO 150 
 $    159: ! $        LAST = F$TRNLNM("LAST")  _ $        IF (LAST.NES."" .AND. STACK_SIZE.GE.1) THEN WSO  "Enter   1   for ", " LAST = ", LAST  2 $        WSO  "Press <RET> for ", " HERE = ", HERE
 $    ENDIF $ P $    READ SYS$COMMAND PARAMS /PROMPT="Or enter new default:   " /END_OF_FILE=105
 $    GOTO 109  $105:  $    PARAMS := $109: \ $    WSC  "==============================================================================="  $    DEFSSKI = 1   $ D $!!  *** Note: We could have used INQUIRE above but that puts stuff B $!   in the DCL recall buffer. The "Illegal character" block below; $!   is included in case of use with a captive account. ***  $  $!!  *** Process user input ***  $ O $    IF (F$LOCATE("(",PARAMS).NE.F$LENGTH(PARAMS)) 	!! Forbid lexical functions 
 $    THEN 4 $        WSO "%TO-E-ILLCHAR, Illegal character: ( "  $        P1BAD = 1 $        RETURN  $    ENDIF   $ ? $    PARAMS := 'PARAMS'  ! Needed to perform symbol subst. for  S $!                       ! stuff like 'F.DEV]; trimming and compression is a bonus   $ ! $    P1 = F$ELEMENT(0," ",PARAMS)  $    INITIAL_P1 = P1  ( $    P2 = F$ELEMENT(1," ",PARAMS) - " " ( $    P3 = F$ELEMENT(2," ",PARAMS) - " "  $    JUNK = F$VERIFY(P3) $    RETURN  ! _GET_NEW_PARAMS  F $!********************************************************************A $!   *** This routine checks its input, extracts the two default- E $!   specs from P1, runs the first one thru _PROCESS_P1, sets default D $!   to it, shows this intermediate default, then assigns the second# $!   default-spec to the symbol P1.  $   $_2STEP_P1:  ! local subroutine C $    IF (F$ELEMENT(2,",",P1).NES.",")	! True if more than one comma 	 $    THEN  $        WSO " "L $        WSO "%TO-E-TOOMNYELEM, too many elements in list; reduce to 1 or 2" $        P1BAD = 1 $        RETURN		! _2STEP_P1 0
 $    ENDIF $    P1A = F$ELEMENT(0,",",P1)   $    P1B = F$ELEMENT(1,",",P1) $    P1 = P1A  $    GOSUB _PROCESS_P1  - $    IF (P1BAD) THEN RETURN  		! _2STEP_P1 1  K $    SET DEFAULT 'P1'			! Cannot use F$PARSE because [-] would be relative  B $    WSO "Intermediate default: "	!   to olddef instead of to p1a , $    SHOW DEFAULT			! Default after one step $    P1 = P1B  $    RETURN  !  _2STEP_P1 2 G $!********************************************************************  K $!!  PROCESS P1 converts P1 to proper disk-directory syntax. It will check  G $!   for keywords, strip a leading @, process logical names correctly,  I $!   strip filenames from P1 (checking if P1 is an existing file first),  K $!   remove superfluous 000000's, put in missing directory brackets if the  - $!   initial value of P1 not a logical name.   $ # $_PROCESS_P1:   ! local subroutine   $ ? $    IF (F$EDIT(P1,"COLLAPSE").EQS."")	!! Blank p1 is an error. 	 $    THEN  $        WSO " "2 $        WSO "%TO_PP1-E-MISARG, missing argument " $        P1BAD = 1 $        RETURN 
 $    ENDIF $  $    GOSUB _CHECK_FOR_KEYWORDS  + $    IF (P1BAD) THEN RETURN  ! _PROCESS_P1   $ H $    IF (F$ELEMENT(2,":",P1).NES.":")	!! True if p1 contains >= 2 colons	 $    THEN  $        WSO " "8 $        WSO "%TO_PP1-E-TOOMNYCOL, more than one colon " $        P1BAD = 1 $        RETURN 
 $    ENDIF $ ? $!!  *** If there is a trailing colon, remove it if the result  > $!       is a logical name. This allows analysis of a logical : $!       name that is followed by a colon to proceed. ***  $ a $    COLON_LAST = P1 .EQS. (P1 - ":" + ":") 	!! P1 has only one colon and it is the last char. !! ` $    IF (COLON_LAST .AND. P1.NES.":") 		!! Remove trailing colon if result is a logical name. !! $    THEN 				8 $        IF (F$TRNLNM(P1-":").NES."") THEN P1 = P1 - ":" $    ENDIF   $ Y $    IF (F$TRNLNM(P1).NES."") 				!! _LNM for logical names; _FIX_BRACKETS for all others 
 $    THEN  $        GOSUB _LNM b $        IF (F$TRNLNM(P1).NES."") THEN P1 = P1 + ":"	!! Works better in check_p1 (the 0:: part) !!
 $    ELSE  $        GOSUB _FIX_BRACKETS   $    ENDIF   $  $    RETURN  			! _PROCESS_P1  $ N $!****************************************************************************O $!!  *** If P1 is a reserved value -- 1 thru STACK_SIZE, S, or L -- then P1 is  L $!       replaced by the translation of the appropriate logical name. Also, : $!       the keywords "~" and "." are processed here. ***  $ + $_CHECK_FOR_KEYWORDS:   ! local subroutine   $  $!!  *** Go up -n levels ***@ $    IF (F$TYPE(P1).EQS."INTEGER" .AND. P1.GE.-8 .AND. P1.LE.-1)
 $    THEN 6 $        P1 = "[" + F$EXTRACT(0,-P1,"--------") + "]"  $        RETURN  $    ENDIF     $     5 $!!  *** For any leading subset of /HELP or -HELP *** I $    IF ( F$EXTRACT(0,2,P1).EQS."/H" .OR. F$EXTRACT(0,2,P1).EQS."-H" )  - 8        .AND. F$LOCATE(F$EXTRACT(1,4,P1),"HELP").EQ.0   -        THEN GOTO _CASE1  $ ) $    KEYWORD_LOC = F$LOCATE(P1,"?HWRT~.") ' $!!                             0123456  $    GOTO _CASE'KEYWORD_LOC' $  $_CASE0:! $_CASE1:	! *** Help Function ***   $    GOSUB _HELP 	 $    GOTO _EXIT5 $  $_CASE2:	! *** Write stack *** $    CALL _WRITE_STACK $    GOTO _EXIT4 $  $_CASE3:	! *** Read stack *** D $    INITIAL_P1 = ""	!! To avoid "new default not set" msg. on exit. $    CALL _READ_STACK  $    SET DEFAULT TO_0  $    GOSUB _DEFINE_HERE  $    IF (TO_BACK) 
 $    THEN   $        GOSUB _UPDATE_BACK_LNMSU $        IF (F$TRNLNM("TO_SAVE").NES."") THEN DEFINE/NOLOG SAVE 'F$TRNLNM("TO_SAVE")' U $        IF (F$TRNLNM("TO_LOST").NES."") THEN DEFINE/NOLOG LOST 'F$TRNLNM("TO_LOST")' 
 $    ENDIFK $    IF (OLDDEF.NES.HERE .AND. OLDDEF_RAW.NES.HERE_RAW .AND. OLDDEF.NES."") 	 $    THEN 5 $        IF (TO_BACK) THEN DEFINE/NOLOG LOST 'OLDDEF  S $        IF (TO_BACK) THEN WSO "%TO-I-TO_LOSTDEF, ",OLDDEF," assigned to lnm LOST"  = $        IF (.NOT.TO_BACK) THEN DEFINE/NOLOG TO_LOST 'OLDDEF  [ $        IF (.NOT.TO_BACK) THEN WSO "%TO-I-TO_LOSTDEF, ",OLDDEF," assigned to lnm TO_LOST"  
 $    ENDIF $    GOTO _EXIT2 $   $_CASE4: ! IF (P1.EQS."T") THEN   $    P1 = F$ELEMENT(0,".",HERE)  $    RETURN  $   $_CASE5: ! IF (P1.EQS."~") THEN  $    P1 = "SYS$LOGIN:" $    RETURN  $ % $_CASE6: ! $    IF (P1.EQS.".") THEN   $    P1 = "SYS$DISK:"  $    RETURN  $ " $_CASE7: ! *** Fall-thru block *** $ Q $!!  *** STACK true means user has entered a number between 1 and stack_size. *** j $    STACK = F$TYPE(P1).EQS."INTEGER" .AND. F$EXTRACT(0,1,P1).NES."0" .AND. P1.GE.1 .AND. P1.LE.STACK_SIZEb $    IF .NOT.(STACK .OR. P1.EQS."L" .OR. P1.EQS."S") THEN RETURN	!! p1 is not a keyword, so return $ 8 $!!  ***  Process input referencing the recall stack *** $    IF (TO_BACK) 	 $    THEN * $        IF (P1.EQS."S") THEN P1 = "SAVE" * $        IF (P1.EQS."L") THEN P1 = "LOST" 5 $        IF (STACK) THEN P1 = F$STRING(P1) + "BACK" 	 	 $    ELSE - $        IF (P1.EQS."S") THEN P1 = "TO_SAVE"  - $        IF (P1.EQS."L") THEN P1 = "TO_LOST"  3 $        IF (STACK) THEN P1 = "TO_" + F$STRING(P1)  
 $    ENDIFJ $    IF (F$TRNLNM(P1).EQS."") 	!! Check if referenced stack slot is empty.
 $    THEN  $        WSO " "  L $        WSO "%TO-E-EMPTYSLOT, recall-stack slot ",P1," is currently empty"  $        P1BAD = 1   $        RETURN  $    ENDIF   $    RETURN F $!********************************************************************A $!   PURPOSE: To handle logical names correctly. SET DEFAULT has  D $!   two problems with nested logical names. See ITERATIVE-LNMS.TXT 5 $!   for details. This routine fixes these problems.   $!: $!   This routine stops iterative logical name translation> $!   once it encounters a logical name that is a search list, ; $!   a logical name whose equivalence name is concealed or  A $!   terminal, or an equivalence name which is not a logical name  $!   itself. $!< $!   If appropriate, a call is made to _STRIP which removes 7 $!   the filename, type, and version, if any, from P1. M $  $_LNM:   ! local subroutine  $l= $!!  !! P1 must be a logical name without a trailing colon !!t $   $!!  *** Check for leading @ *** $    EQUIV0 = F$TRNLNM(P1)6 $    P1_STARTS_WITH_AT = F$EXTRACT(0,1,EQUIV0).EQS."@" $    IF (P1_STARTS_WITH_AT) 	 $    THEN- $        P1 = EQUIV0 - "@" $        GOSUB _STRIPR $        RETURN 
 $    ENDIF $i $    GOSUB _NULL_SYNTAX_NODE $    IF (P1BAD) THEN RETURN: $  $_ANALYZE: l $e& $!!  *** Anaylze equivalence name *** . $    MAX_INDEX = F$TRNLNM(P1,,,,,"MAX_INDEX") . $    CONCEALED = F$TRNLNM(P1,,,,,"CONCEALED") - $    TERMINAL  = F$TRNLNM(P1,,,,,"TERMINAL")   $    EQUIV     = F$TRNLNM(P1)  $G@ $!!  *** True if last char is a colon and is the only colon: ***3 $    COLON_LAST = EQUIV .EQS. (EQUIV - ":" + ":") 	  $ B $    IF (MAX_INDEX.GE.1) 		! Search list lnm: strip it and Return.
 $    THEN  $        GOSUB _STRIP ' $        RETURN  ! _LNM  MAX_INDEX.GE.1  $    ENDIF ! $ C $    IF (CONCEALED .OR. TERMINAL) THEN RETURN 		! Cease processing.s $ H $    IF (COLON_LAST) THEN EQUIV = EQUIV - ":" 		! Remove trailing colon. $ 8 $    IF (F$TRNLNM(EQUIV).NES."") 		! Logical name case. 
 $    THEN 3 $        P1 = EQUIV 				! EQUIV is a logical name 	F$ $        GOTO _ANALYZE 				! Iterate $    ENDIF B $ E $    IF (COLON_LAST) 		! Not a logical name, restore colon if needed.D: $    THEN         		! equiv is a disk name; just add colon $        P1 = EQUIV + ":" ) $    ELSE			! equiv is a file-spec; stripT $        P1 = EQUIV  $        GOSUB _STRIP 
 $    ENDIF $e $    RETURN  ! _LNM O $!**************************************************************************** !C $!   PURPOSE: Strips off any file name, type, and version from P1.  C $!            This way you can, e.g., do TO SYSUAF and TO.COM will  A $!            take you to the directory in which SYSUAF resides. o $ 6 $_STRIP:   ! local subroutine   Input: P1  Output: P1  $  $    STRIP_INPUT = P1  $L $    GOSUB _NULL_SYNTAX_NODE $    IF (P1BAD) THEN RETURN  $gC $!   We cannot use PARSE_TEST = (PARSE1.EQS.PARSE2) as it does not n= $!   work for disk:[dir-spec]A, e.g. This check tells us that ! $!   there is something to strip.o $ 8 $    PARSE1 = F$PARSE(P1,"A.A;1",,,"SYNTAX_ONLY") 	!! OK3 $    PARSE2 = F$PARSE(P1,"B.B;2",,,"SYNTAX_ONLY") 	:Y $    PARSE_TEST = (PARSE1 - "A.A;1" .EQS. PARSE1)  .OR.  (PARSE2 - "B.B;2" .EQS. PARSE2) UX $!!                PARSE1 does not contain A.A;1          PARSE2 does not contain B.B;2  $ & $    IF (.NOT.PARSE_TEST) THEN RETURN  $ ' $!!  *** Check for a matching file ***   $    FOUND_FILE = F$SEARCH(P1) * $    IF (FOUND_FILE.NES."") 
 $    THEN  $        P1 = FOUND_FILE  ; $        WSO "%TO_STRIP-I-FILEFND, found file ",FOUND_FILE  
 $    ENDIF $  $!!  *** Strip! *** i $    P1 = F$PARSE(P1,,,"DEVICE") + F$PARSE(P1,,,"DIRECTORY") 	! Do not add [] because F$SEARCH wouldn't. .N $    WSO "%TO_STRIP-I-STRIPPED, extracted """,P1,""" from """,STRIP_INPUT,"""" $    RETURN  ! _STRIP N $!!***************************************************************************K $!!  This subroutine checks for null argument, invalid syntax, and presence"> $!   of a node-spec, any of which indicate an error condition. $ & $_NULL_SYNTAX_NODE:	! local subroutine $n% $!!  *** Check for null file-spec ***.& $    IF (F$EDIT(P1,"COLLAPSE").EQS."")	 $    THEN- $        WSO " "+ $        WSO "%TO-E-NULLFS, null file-spec"n $        P1BAD = 1 $        RETURN=
 $    ENDIF $I $!!  *** Check syntax *** R $    P1_SYNTAX = F$PARSE(P1,"[]",,,"SYNTAX_ONLY") 		! Do NOT remove "[]" ! OK  DM? $    IF (P1_SYNTAX.EQS."")  
 $    THEN  $        WSO " " LH $        WSO "%TO-E-INVSTX, invalid syntax"  ! Invalid file-spec syntax.8 $        IF (F$TRNLNM(P1).NES."") THEN SHOW LOGICAL 'P1' $        P1BAD = 1 p $        RETURN  $    ENDIF E $F! $!!  *** Check for node-spec *** I: $    IF (F$PARSE(P1,,,"NODE","SYNTAX_ONLY").NES."") 	!! OK
 $    THEN  $        WSO " " G4 $        WSO "%TO-E-NODESPEC, node-spec not allowed" $        P1BAD = 1 s $        RETURN  $    ENDIF d $  $    RETURNDF $!********************************************************************B $!   PURPOSE: This subroutine puts in any needed missing brackets G $!            and also eliminates superfluous occurences of "000000.".  = $!	      It also process the keywords ".." and "\" and allows.A $!	      one to use a root-spec. (They need to be in this routine3: $!	      because P1 might be of the form "<disk>:\", e.g.) $ % $_FIX_BRACKETS:   ! local subroutine O $O $!!  *** Extract disk-spec ***! $    COLON_LOC = F$LOCATE(":",P1)_7 $    IF (COLON_LOC.EQ.F$LENGTH(P1)) THEN COLON_LOC = -1T- $    DISK_SPEC = F$EXTRACT(0,COLON_LOC+1,P1)   $	 $!!  *** Extract dir-spec ***_: $    DIR_SPEC = P1 - DISK_SPEC - "><" - "][" - "]<" - ">["* $    DIR_SPEC = F$ELEMENT(0,"]",DIR_SPEC) * $    DIR_SPEC = F$ELEMENT(0,">",DIR_SPEC)  $ & $!!  *** Remove remaining brackets ***f $    IF (F$EXTRACT(F$LENGTH(DIR_SPEC)-1,1,DIR_SPEC).EQS."[") -             !! Forgive last char = "[" D          THEN DIR_SPEC = F$EXTRACT(0,F$LENGTH(DIR_SPEC)-1,DIR_SPEC) a $    IF (F$EXTRACT(0,1,DIR_SPEC).EQS."[") THEN DIR_SPEC = DIR_SPEC - "["   !! Remove leading "["  a $    IF (F$EXTRACT(0,1,DIR_SPEC).EQS."<") THEN DIR_SPEC = DIR_SPEC - "<"   !! Remove leading "<"   $ ? $    IF (DIR_SPEC.EQS."\") THEN DIR_SPEC = "000000" 	!! KeywordF< $    IF (DIR_SPEC.EQS."..") THEN DIR_SPEC = "-" 	!! Keyword  $MN $!!  *** Remove 000000. when going "down" from [000000] with [.<some-top-dir>] $    IF ( - M           (F$DIRECTORY().EQS."[000000]" .OR. F$DIRECTORY().EQS."<000000>") -	E1           .AND. F$EXTRACT(0,1,DIR_SPEC).EQS."." - 3           .AND. F$EXTRACT(0,3,DIR_SPEC).NES."..." -B         ) - %        THEN DIR_SPEC = DIR_SPEC - "."F $ E $    DIR_SPEC = "[" + DIR_SPEC + "]" 	! Add proper directory bracketsc $    DIR_SPEC_ORIG = DIR_SPECo $ F $!!      *** Can use F$PARSE from this point on in this subroutine *** $ C $    DIR_SPEC = F$PARSE(DIR_SPEC,"[]",,"DIRECTORY","SYNTAX_ONLY") -IP                 - "][" - "><" - "]<" - ">[" 		! To allow roots in dir-spec  ! OK $ P $    IF (DIR_SPEC.EQS."")				! This block added because the parse command       B $    THEN						! might produce a null string. For example,        J $        P1BAD = 1					! when P1 is $%^ or too many levels of directories. $        WSO " "					eF $        WSO "%TO_FB-E-INVDEF, invalid directory-spec: ",DIR_SPEC_ORIG1 $        RETURN 					! _FIX_BRACKETS bad-dir-specD
 $    ENDIF $,T $    P1 = DISK_SPEC + DIR_SPEC 		! Using F$PARSE would ruin a search list of disks.  $(  $    RETURN  ! _FIX_BRACKETS endF $!********************************************************************9 $_CHECK_P1:	! local subroutine	! Input:  local symbol P1 R" $					! Output: local symbol P1BAD $T $    GOSUB _NULL_SYNTAX_NODE $    IF (P1BAD) THEN RETURNO $"+ $!!  *** Tell user what we're checking *** _> $    PARSE1 = F$PARSE(P1,"[AAA]",,"DIRECTORY","SYNTAX_ONLY") 	> $    PARSE2 = F$PARSE(P1,"[BBB]",,"DIRECTORY","SYNTAX_ONLY") 	+ $    P1_CONTAINS_DIR = (PARSE1.EQS.PARSE2) *% $    IF (.NOT.P1_CONTAINS_DIR) THEN -!b        P1 = P1 + F$PARSE("[]",,,"DIRECTORY","SYNTAX_ONLY")	! To avoid showing just device portion. $    WSO " " $    WSO "Checking ",P1  $_+ $!!  *** Check for improper root syntax *** ? $    P1_AUX_DIR = F$PARSE(P1,"[]",,"DIRECTORY","SYNTAX_ONLY") 	.A $    IF (P1_AUX_DIR - "><" - ">[" - "]>" - "][" .NES. P1_AUX_DIR)T	 $    THEN  $        WSO " "T $        WSO "%TO-E-ROOT, rooted equivalence name must have the concealed attribute" $        P1BAD = 1 $        RETURNV
 $    ENDIF $ g $    P1_DEVICE = F$PARSE(P1,,,"DEVICE","NO_CONCEAL") ! No syntax_only so that we get the right device. O $ B $!!  *** Check if p1_device is null. Highly unlikely, but protects9 $!       against null first-argument for f$getdvi("") ***  $' $    IF (P1_DEVICE.EQS."")  
 $    THEN  $        WSO " "= $        WSO "  ***  %TO-W-P1DEVNUL, device is null!!!  *** "! $        P1BAD = 1 $        RETURNb $    ENDIF   $ G $    IF (F$PARSE(P1_DEVICE,"[]",,"DIRECTORY").EQS."")	!! to catch PPF's 
 $    THEN  $        WSO " " E2 $        WSO "*** Inappropriate logical name ***"  $        P1BAD = 1 $        RETURN  $    ENDIF   $ $ $!!  *** Does the device exist? ***  $ + $    EXISTS = F$GETDVI(P1_DEVICE,"EXISTS")   $    IF (.NOT. EXISTS)  
 $    THEN  $        WSO  " " T $        WSO  "*** Device ",P1_DEVICE," does not exist or no such logical name ***"  $        P1BAD = 1 $        RETURN  $    ENDIF R $ * $!!  *** Is the device file-oriented? ***  $ % $    FOD = F$GETDVI(P1_DEVICE,"FOD") " $    IF (.NOT. FOD) 
 $    THEN  $        WSO  " " D $        WSO  "*** Device ", P1_DEVICE, " is not file-oriented ***"  $        P1BAD = 1 $        RETURN  $    ENDIF   $ & $!!  *** Is the device available? ***  $ $ $    AVL= F$GETDVI(P1_DEVICE,"AVL")  $    IF (.NOT. AVL) 
 $    THEN  $        WSO  " " @ $        WSO  "*** Device ", P1_DEVICE, " is not available ***"  $        P1BAD = 1 $        RETURN  $    ENDIF f $ $ $!!  *** Is the device mounted? ***  $ $ $    MNT= F$GETDVI(P1_DEVICE,"MNT")  $    IF (.NOT. MNT) 
 $    THEN  $        WSO  " " > $        WSO  "*** Device ", P1_DEVICE, " is not mounted ***"  $        P1BAD = 1 $        RETURN  $    ENDIF " $-  $!!  *** Check for wildcards ***0 $    WILDCARDS = P1 - "*" - "%" - "..." .NES. P1 $    IF (WILDCARDS) 
 $    THEN  $        GOSUB _WILDCARD $        IF (P1BAD) 
 $        THEN  $            RETURN; $        ENDIF	 $    ELSEs2 $!!      *** Check for existence of default:  *** C $        PARSE_CHECK = F$PARSE(P1,"[]") 		! Do NOT remove "[]" ! OK ! $        IF (PARSE_CHECK.EQS."")   $        THEN  $            WSO  " " 0 $            WSO  "*** Directory not found ***"  $            P1BAD = 1 $            RETURN  $        ENDIF n* $!!      *** Check if 1st equiv exists ***Q $        P1_SYNTAX = F$PARSE(P1,"[]",,,"SYNTAX_ONLY")   ! Do NOT remove "[]" ! OK ' $        IF (P1_SYNTAX.NES.PARSE_CHECK) 
 $        THENo $            WSO " "I $            WSO "*** Warning: First equivalence-name default d.n.e. ***"T $        ENDIF   	
 $    ENDIF $t $    RETURN  ! _CHECK_P1  G $!******************************************************************** s  $_SET_DEF:   ! local subroutine  $    SET NOON  $    SET DEFAULT 'P1'  $    SET_DEF_STATUS = $STATUS  $    SET ON  $  $    IF (.NOT.SET_DEF_STATUS) 	 $    THEN  $        P1BAD = 1 1 $        RETURND $    ENDIF   $!= $!!  *** Check default again in case we missed something. ***c $    IF (F$PARSE("").EQS."")	 $    THENn $        WSO " ", $        WSO "%TO-E-BADDEF, no such default" $        P1BAD = 1 $        RETURN 
 $    ENDIF $ ? $    SET_DEFAULT = F$ENVIRONMENT("DEFAULT")	!! For exit3 block.* $* $    RETURN  ! _SET_DEF F $!********************************************************************G $!   PURPOSE: To define logical names for easy reference in subsequent  5 $!   commands and for the logical name recall stack.   $i! $_SET_LNMS:   ! local subroutine r $vF $!!  *** Input:	current default for HERE, HERE_RAW, NEWDEF, NEWDEF_RAW9 $!		DEF_TO_LOST, INITIAL_DEF, INITIAL_DEF_RAW for TO_LOST1) $!		OLDDEF, OLDDEF_RAW for LAST, LAST_RAWI $!		OTHER_DEFAULT_FOUND! $!		P2 $!  < $    LNMS_OK = 0		!! Indicates we are about to update LNM's.9 $    GOSUB _DEFINE_HERE 	!! Define HERE for final answer.  $ 3 $    IF (OLDDEF.EQS."") THEN GOTO _SET_LNMS_EXIT  	  $ E $!!  *** Check if the new default is the same as the old default *** "? $!   *** Check both regular and raw in case the new default is  3 $!       actually a synonym for the old default ***  $  $    NEWDEF = HERE   $    NEWDEF_RAW = HERE_RAW   $ A $    IF ( (NEWDEF_RAW.EQS.OLDDEF_RAW) .OR. (NEWDEF.EQS.OLDDEF) )  
 $    THEN ' $        IF (.NOT.OTHER_DEFAULT_FOUND) l $        THEN  $            WSO  " " + $            WSO  "You are already there!"   $        ENDIF 1 $        GOTO _SET_LNMS_LOST $    ENDIF   $ 2 $    IF (STACK_SIZE.LE.0) THEN GOTO _SET_LNMS_EXIT $D $    GOSUB _GET_LNM_DATA $    GOSUB _FIND_LOWEST_MATCHo5 $    IF (P2 .OR. P2.EQS."") 	! Default for P2 is TRUE1
 $    THEN  $        GOSUB _STACK_UPDATE F	 $    ELSE Z $        WSO "%TO-I-REMOLDDEF, removing old default from stack by request (P2 was false)" 4 $        IF (ACTUAL_MATCH) THEN GOSUB _STACK_SHRINK 
 $    ENDIF $P/ $    IF (TO_BACK) THEN GOSUB _UPDATE_BACK_LNMS	  $t $_SET_LNMS_LOST:A $    IF  ((DEF_TO_LOST) .AND. (INITIAL_DEF_RAW.NES.NEWDEF_RAW) -  =                         .AND. (INITIAL_DEF.NES.NEWDEF)     ) *
 $    THEN : $        IF (TO_BACK) THEN DEFINE/NOLOG LOST 'INITIAL_DEF'X $        IF (TO_BACK) THEN WSO "%TO-I-TO_LOSTDEF, ",INITIAL_DEF," assigned to lnm LOST" C $        IF (.NOT.TO_BACK) THEN DEFINE/NOLOG TO_LOST 'INITIAL_DEF'  ` $        IF (.NOT.TO_BACK) THEN WSO "%TO-I-TO_LOSTDEF, ",INITIAL_DEF," assigned to lnm TO_LOST"  $    ENDIF I $F $_SET_LNMS_EXIT:
 $    SET NOONGM $    LNMS_OK = 1 		!! Indicates successful completion of subroutine set_lnms." $    RETURN  ! _SET_LNMS  N $!**************************************************************************** $_GET_LNM_DATA:C $    TO_0 = OLDDEF R $    TO_RAW_0 = OLDDEF_RAW ) $  $    INDEXVAR = 1 4 $10:     TO_'INDEXVAR' = F$TRNLNM("TO_''INDEXVAR'") < $        TO_RAW_'INDEXVAR' = F$TRNLNM("TO_RAW_''INDEXVAR'") < $        INDEXVAR = INDEXVAR + 1 			! Increment loop counterS $        IF (INDEXVAR .LE. STACK_SIZE+1) THEN GOTO 10	! The +1 simplifies logic in T$ $19: 							!   stack shrink routine $    RETURNCN $!****************************************************************************J $!!  Results: MATCH - int - number of lowest slot that matches new defaultC $!            ACTUAL_MATCH - Boolean - true implies an actual matchT $A( $_FIND_LOWEST_MATCH: 	! local subroutine $    INDEXVAR = 1 M $20:     IF (     (NEWDEF .EQS. TO_'INDEXVAR')  -		! We have a match 	! until L              .OR. (NEWDEF_RAW .EQS. TO_RAW_'INDEXVAR') -	! We have a match 	H              .OR. (TO_'INDEXVAR' .EQS. "") -			! null; no more defaults Y              .OR. (TO_RAW_'INDEXVAR' .EQS. "")  ) -    		! prevents incorrect RAW value.                THEN GOTO 29 = $        INDEXVAR = INDEXVAR + 1 				! increment loop counter E $        IF (INDEXVAR .LE. STACK_SIZE) THEN GOTO 20		! while in stack. $29: B $    MATCH = INDEXVAR m $    ACTUAL_MATCH = TO_'MATCH'.NES."" .AND. MATCH.LE.STACK_SIZE ! Added 2nd comparison for stack size changesEG $    IF (ACTUAL_MATCH .AND. .NOT.TO_BRIEF) THEN WSO "  MATCH = ",MATCH . $    RETURN N $!****************************************************************************# $_STACK_UPDATE: 	! local subroutineR $  $    INDEXVAR = 1FE $30:     IF (INDEXVAR.GT.MATCH) THEN GOTO 39 			! until we pass matchm# $        INDEXVARM1 = INDEXVAR - 1  6 $        DEFINE/NOLOG TO_'INDEXVAR'  &TO_'INDEXVARM1' > $        DEFINE/NOLOG TO_RAW_'INDEXVAR'  &TO_RAW_'INDEXVARM1' 8 $        INDEXVAR = INDEXVAR + 1 				! increment counterG $        IF (INDEXVAR.LE.STACK_SIZE) THEN GOTO 30    		! while in stacke $39: a $    RETURNIN $!****************************************************************************# $_STACK_SHRINK: 	! local subroutine  $  $    INDEXVAR = MATCH$# $40:     INDEXVARP1 = INDEXVAR + 1  H $        IF (TO_'INDEXVARP1'.EQS."") THEN GOTO 49		! until entry is null6 $        DEFINE/NOLOG TO_'INDEXVAR'  &TO_'INDEXVARP1' > $        DEFINE/NOLOG TO_RAW_'INDEXVAR'  &TO_RAW_'INDEXVARP1' = $        INDEXVAR = INDEXVAR + 1 				! increment loop counterWI $        IF (INDEXVAR.LE.STACK_SIZE) THEN GOTO 40 		! while in stack sizet $49: yH $    IF (F$TRNLNM("TO_''INDEXVAR'").NES."") THEN DEASSIGN TO_'INDEXVAR' P $    IF (F$TRNLNM("TO_RAW_''INDEXVAR'").NES."") THEN DEASSIGN TO_RAW_'INDEXVAR'  $o $    RETURNaN $!**************************************************************************** $_UPDATE_BACK_LNMS:. $  $    TO_LNM := TO_1h $    BACK_LNM := LASTp $    GOSUB _UPDATE_LNM $o
 $    N = 1F $210:    IF (N.GT.STACK_SIZE) THEN GOTO 219	! until we leave the stack $        TO_LNM := TO_'N'  $        BACK_LNM := 'N'BACK $        GOSUB _UPDATE_LNMR $        IF (F$TRNLNM(TO_LNM).EQS."") THEN RETURN	! Stop *after* first null to_'n' $        N = N + 1 $        GOTO 210d $219:T $  $    RETURN N $!****************************************************************************
 $_UPDATE_LNM:l $!" $    IF (F$TRNLNM(TO_LNM).NES."") 
 $    THEN 1 $        DEFINE/NOLOG 'BACK_LNM 'F$TRNLNM(TO_LNM) 	 $    ELSE ? $        IF (F$TRNLNM(BACK_LNM).NES."") THEN DEASSIGN 'BACK_LNMS
 $    ENDIF $P $    RETURN_N $!****************************************************************************" $_SHOW_DEFS:   ! local subroutine  $L $    N = STACK_SIZE  $    IF (.NOT.TO_BACK) $    THEN 		!! to_'n' styleA' $        TO_SAVE = F$TRNLNM("TO_SAVE") D' $        TO_LOST = F$TRNLNM("TO_LOST") C $        WSO " " (N $        IF (TO_SAVE.NES."") THEN WSO  "                 TO_SAVE = ", TO_SAVE N $        IF (TO_LOST.NES."") THEN WSO  "                 TO_LOST = ", TO_LOST - $    90:     IF (N.LT.1) THEN GOTO 99 			    V+ $            TO_'N' = F$TRNLNM("TO_''N'") 	)T $            IF (TO_'N'.NES."") THEN WSO  "                 TO_''N' = ", TO_'N'      $            N = N - 1 D $            GOTO 90  	 $    99:  K $        WSO  "                ", " TO_0 = ", HERE, "  ! (current default)"L $    ELSE		!! nback style ! $        SAVE = F$TRNLNM("SAVE")  ! $        LOST = F$TRNLNM("LOST") 	 $        WSO " " eE $        IF (SAVE.NES."") THEN WSO  "                 SAVE = ", SAVE  E $        IF (LOST.NES."") THEN WSO  "                 LOST = ", LOST S. $    190:    IF (N.LT.2) THEN GOTO 199 			    * $            TO_'N' = F$TRNLNM("''N'BACK")T $            IF (TO_'N'.NES."") THEN WSO  "                ''N'BACK = ", TO_'N'      $            N = N - 1 I $            GOTO 190 
 $    199: $ $        LAST = F$TRNLNM("LAST") 			\ $        IF (LAST.NES."" .AND. STACK_SIZE.GE.1) THEN WSO  "                 LAST = ", LAST 	/ $        WSO  "                 HERE = ", HERE	 
 $    ENDIF $h $    RETURN F $!********************************************************************A $!!  PURPOSE: To define HERE so that it can be used as a logical n4 $!            name to represent the current default.< $!            A check is made to see if SYS$DISK contains a A $!            directory-spec. If it does, then the [dir] part of oA $!            current default is not included in the equivalence tC $!            name for HERE. Simply using F$ENVIRONMENT("DEFAULT") 1A $!            for HERE will, in some cases, cause commands using ,; $!            HERE to fail. For example, TO DISK:[FELDMAN]  9 $!            followed by TO SYS$STARTUP would produce a  C $!            nonsensical value of SYS$STARTUP:[FELDMAN] for HERE. i $ $ $_DEFINE_HERE:   ! local subroutine  $ 8 $    PARSE1 = F$PARSE("SYS$DISK","[AAA]",,"DIRECTORY") 	8 $    PARSE2 = F$PARSE("SYS$DISK","[BBB]",,"DIRECTORY") 	3 $    SYS$DISK_CONTAINS_DIR = (PARSE1 .EQS. PARSE2) O  $    IF (SYS$DISK_CONTAINS_DIR) 
 $    THEN % $        HERE = F$TRNLNM("SYS$DISK")  
 $    ELSE ) $        HERE = F$ENVIRONMENT("DEFAULT") C $    ENDIF n $  $!!  *** Compute HERE_RAW ***  $ B $    IF (F$TRNLNM(F$TRNLNM("SYS$DISK")-":",,,,,"MAX_INDEX").GE.1) 7 $    THEN 								! New default contains a search list.*W $        HERE_RAW = F$ENVIRONMENT("DEFAULT")				! Just change angle to square brackets. * $        LEFT_ANG = F$LOCATE("<",HERE_RAW)K $        IF (LEFT_ANG.NE.F$LENGTH(HERE_RAW)) THEN HERE_RAW[LEFT_ANG,1] := [S+ $        RIGHT_ANG = F$LOCATE(">",HERE_RAW)CM $        IF (RIGHT_ANG.NE.F$LENGTH(HERE_RAW)) THEN HERE_RAW[RIGHT_ANG,1] := ]-	 $    ELSEWG $        FULLDEVNAM = F$PARSE("",,,"DEVICE") 				! Do NOT add "[]" ! OK ; $        IF (FULLDEVNAM.EQS."") THEN GOTO _SKIP_FULLDEVNAM  7 $        DEVICE_EXISTS = F$GETDVI(FULLDEVNAM,"EXISTS") NP $        IF (DEVICE_EXISTS) THEN FULLDEVNAM = F$GETDVI(FULLDEVNAM,"FULLDEVNAM")  $    _SKIP_FULLDEVNAM: -G $        BARE_DIR = F$PARSE("",,,"DIRECTORY","NO_CONCEAL") - 						! OKNc                     - "][" - "><" - "]<" -  ">[" - "[000000." - "<000000." - "[" - "]" - "<" - ">" *6 $        HERE_RAW = FULLDEVNAM + "[" + BARE_DIR + "]" 
 $    ENDIF $", $!!  *** Assign results to logical names *** $    SET NOCONTROL=Y' $        		   DEFINE/NOLOG TO_0 'HERE'  ) $        		   DEFINE/NOLOG TO_HERE 'HERE'F3 $        IF (TO_BACK) THEN DEFINE/NOLOG HERE 'HERE'*4 $        IF (TO_BACK) THEN DEFINE/NOLOG 0BACK 'HERE'. $        		   DEFINE/NOLOG TO_RAW_0 'HERE_RAW'' $    ON CONTROL_Y THEN GOTO _CONTROL_Y u $    SET CONTROL=Y $  $    RETURN F $!********************************************************************# $_PATHOLOGICAL:		! local subroutineoE $!!  *** Check for old default being unusable (or "pathological") ***\+ $    IF    (F$PARSE("",,,"DEVICE").EQS."" -u.        .OR. F$PARSE("",,,"DIRECTORY").EQS."" -]        .OR. F$ELEMENT(2,":",F$ENVIRONMENT("DEFAULT")).NES.":")	!  contains more than 2 colonsD
 $    THEN U $        WSO "%TO-W-INVOLDDEF, old default is pathological or contains a node-spec: "D $        SHOW DEFAULT-: $        WSO "%TO-I-GOHOME, setting default to SYS$LOGIN " $        SET DEFAULT SYS$LOGIN! $        OTHER_DEFAULT_FOUND = 1 n $        PATHOLOGICAL = 1F
 $    ENDIF $    RETURNCF $!******************************************************************** $_PROMPT:	! local subroutine $F $    LEN = F$LENGTH(HERE)C $  $    IF LEN.LE.310	 $    THEN) $        PROMPT = HERE + ">"	 $    ELSE 7 $        PROMPT = "~" + F$EXTRACT(LEN-30,30,HERE) + ">")
 $    ENDIF $D $    SET PROMPT=&PROMPT  $    RETURNaF $!********************************************************************C $!!  PURPOSE:	To provide matching dir-specs to a wildcard dir-spec.  $M $_WILDCARD:  $!( $!!  *** Check for trailing ellipsis *** $[ $    LEN = F$LENGTH(P1) ) $    IF (F$EXTRACT(LEN-4,3,P1).EQS."...")]	 $    THENR $        WSO " "= $        WSO "TO.COM does not support the trailing ellipsis." 5 $        WSO "You can, however, use a trailing ...* "  $        P1BAD = 1 $        RETURNR
 $    ENDIF $ # $    CALL _DIR2FILE TO_DIRFILE 'P1'" $  $    MATCHING_FILE_FOUND = 0 $NEXT_DIRSPEC:) $    FOUND_DIRFILE = F$SEARCH(TO_DIRFILE)F $    IF (FOUND_DIRFILE.EQS."")  
 $    THEN  $        P1BAD = 1 $        GOTO _WRAPUP]
 $    ENDIF $    MATCHING_FILE_FOUND = 1 $ . $    CALL _FILE2DIR TO_DIRSPEC 'FOUND_DIRFILE' $i4 $    RSC_PROMPT = "Go to " + TO_DIRSPEC + " ? [N]: "@ $    READ SYS$COMMAND/PROMPT=&RSC_PROMPT ANSWER /END_OF_FILE=115
 $    GOTO 119a $115:t $    ANSWER = "QUIT" $119: ) $    IF (ANSWER.EQS."") THEN ANSWER = "N"o? $    IF (F$LOCATION(F$EDIT(ANSWER,"UPCASE,TRIM"),"QUIT").EQ.0) O	 $    THENI $        P1BAD = 1 $        GOTO _WRAPUPR
 $    ENDIF, $    IF (.NOT.ANSWER) THEN GOTO NEXT_DIRSPEC $E, $!!  *** Deliver the result and clean up *** $g $    P1 = TO_DIRSPEC	 $_WRAPUP:  $    IF (P1BAD) 	 $    THEN! $        WSO " "" $        IF (MATCHING_FILE_FOUND) 
 $        THEN*: $            WSO "No matching directory selected by user."
 $        ELSE 1 $            WSO "No matching directories found."G $        ENDIF
 $    ENDIFH $    IF (F$TYPE(TO_DIRFILE).NES."") THEN DELETE/SYMBOL/GLOBAL TO_DIRFILEH $    IF (F$TYPE(TO_DIRSPEC).NES."") THEN DELETE/SYMBOL/GLOBAL TO_DIRSPEC $  $    RETURN"F $!********************************************************************6 $!!  PURPOSE: Convert a dir-spec to its .DIR file-spec $P7 $!!  PARAMS:	P1:	A global symbol to receive the result.v $!!		P2:	Input dir-speco $o $_DIR2FILE: SUBROUTINE) $    ON CONTROL_Y THEN EXIT TO__CONTROL_Yi/ $    ON WARNING THEN EXIT $STATUS.OR.%X10000000S $1 $    'P1' == """ $Y $    DIRSPEC = P2 , $    HAS_PERIOD = DIRSPEC-"." .NES. DIRSPEC	 $    IF (.NOT.HAS_PERIOD) 	 $    THENW) $        BRA_LOC = F$LOCATE("[",DIRSPEC) ua $        DIRSPEC = F$EXTRACT(0,BRA_LOC+1,DIRSPEC) + "000000." + F$EXTRACT(BRA_LOC+1,9999,DIRSPEC) 
 $    ENDIF $I $!!  *** Find last period ***C $E $    LEN = F$LENGTH(DIRSPEC)		 $    LOC = LEN $10: $    LOC = LOC - 1F $    IF (F$EXTRACT(LOC,1,DIRSPEC).NES."." .AND. LOC.GE.0) THEN GOTO 10 $19: $    PERIOD_LOC = LOCt $(- $!!  *** Change last . to ] and append .DIR;1  $E $    DIRSPEC = DIRSPEC - "]"  $    DIRSPEC[PERIOD_LOC,1] := ]	J $    IF (F$LOCATE("..]",DIRSPEC).NE.F$LENGTH(DIRSPEC))	!! Broken ellipsis		 $    THENF' $        LOC = F$LOCATE("..]",DIRSPEC)	"O $        DIRSPEC = F$EXTRACT(0,LOC,DIRSPEC) + "." + F$EXTRACT(LOC,9999,DIRSPEC)i
 $    ENDIF" $    DIRSPEC = DIRSPEC + ".DIR;1"	 $					 $DONE: $    'P1' == DIRSPEC $    EXIT TO__SUCCESSt $    ENDSUBROUTINEF $!********************************************************************< $!!  PURPOSE: To convert a .DIR;1 file-spec into a dir-spec. $o7 $!!  PARAMS:	P1: A global symbol to receive the result.D# $!!		P2: The input .DIR;1 file-spec  $ = $!!  RESTRICTIONS:	Angle brackets ("<",">") must be convertedT1 $!!			to square brackets ("[","]") before callingT $!!			this routine.  $  $_FILE2DIR: SUBROUTINE) $    ON CONTROL_Y THEN EXIT TO__CONTROL_Y / $    ON WARNING THEN EXIT $STATUS.OR.%X10000000F $  $    'P1' == ""h $e $    KET_LOC = F$LOCATE("]",P2)L $    P2[KET_LOC,1] := ." $    P2 = P2 - ".DIR;1" + "]"T3 $    IF (F$LOCATE("[000000.",P2).NE.F$LENGTH(P2)) -,        THEN P2 = P2 - "000000."* $  $    'P1' == P21 $    EXIT TO__SUCCESS  $    ENDSUBROUTINEF $!********************************************************************> $!!  PURPOSE: To read the logical name recall stack from disk. $_READ_STACK: SUBROUTINE $    STATUS = TO__SUCCESS & $    ON CONTROL_Y THEN GOTO _CONTROL_Y  $    ON WARNING THEN GOTO _ERROR3 $    IF (F$SEARCH("SYS$LOGIN:TO_STACK.DAT").EQS."").	 $    THEN1@ $        WSO "%TO-E-NOSTKFIL, no recall-stack file to read from" $        EXIT TO__ERROR 
 $    ENDIF $    CLOSE/NOLOG RECALL_FILE1 $    OPEN/READ RECALL_FILE SYS$LOGIN:TO_STACK.DAT  $10:( $    READ/END_OF_FILE=19 RECALL_FILE REC& $    REC = F$EDIT(REC,"TRIM,COMPRESS") $    LNM = F$ELEMENT(0," ",REC) ! $    EQUIV = F$ELEMENT(3," ",REC)  $    DEFINE/NOLOG 'LNM' 'EQUIV'o $    GOTO 10 $19:A $    WSO "%TO-S-RDSTK, stack read in from SYS$LOGIN:TO_STACK.DAT"  $    GOTO _EXIT  $_CONTROL_Y: $    STATUS = TO__CONTROL_YF $    GOTO _EXIT" $_ERROR: $    STATUS = $STATUS[ $    GOTO _EXIT  $_EXIT:Y
 $    SET NOONC $    CLOSE/NOLOG RECALL_FILE $    EXIT STATUS.OR.%X10000000 $    ENDSUBROUTINEF $!********************************************************************: $!!  PURPOSE: Write the logical name recall stack to disk. $_WRITE_STACK: SUBROUTINE* $    STATUS = TO__SUCCESS   & $    ON CONTROL_Y THEN GOTO _CONTROL_Y  $    ON WARNING THEN GOTO _ERROR< $    SHOW LOGICAL/FULL TO_* /OUTPUT=SYS$SCRATCH:TO_STACK.TMPI $    SEARCH SYS$SCRATCH:TO_STACK.TMP " = " /OUTPUT=SYS$LOGIN:TO_STACK.DAT!? $    WSO "%TO-S-WRSTK, stack written to SYS$LOGIN:TO_STACK.DAT" ! $    PURGE SYS$LOGIN:TO_STACK.DATT $    GOTO _EXITO $_CONTROL_Y: $    STATUS = TO__CONTROL_Ye $    GOTO _EXITP $_ERROR: $    STATUS = $STATUSE $    GOTO _EXITT $_EXIT:=
 $    SET NOON"9 $    IF (F$SEARCH("SYS$SCRATCH:TO_STACK.TMP;").NES."")  - -        THEN DELETE SYS$SCRATCH:TO_STACK.TMP;** $    EXIT STATUS.OR.%X10000000 $    ENDSUBROUTINEF $!******************************************************************** $_HELP: ! local subroutine $    TYPE SYS$INPUT 
 $    DECK O =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=RN Format:  $ TO [new-default] [save-old-default (def=Y)] [verification (def=N)]   N new-default: [device:][dir] - Directory brackets are optional. Device can be aM logical name. If just a logical name is given and it points to a file, TO.COMiN will set default to the directory in which that file resides. Input which doesM not contain delimiters is interpreted with the following precedence: reserved"J values, logical names, directory-specs. Add a trailing colon or bracket ifN needed to force desired interpretation. Wildcards are permitted; the user will5 be offered matching directory-specs. Reserved values:D  G              <null> - Show LNM Recall Stack and prompt for new default.E/      H, -HELP, or ? - Display this help screen. M 1 thru 'STACK_SIZE' - Go that many defaults back. (Default stack size is 9.) GE default-1,default-2 - Go to default-1 and from there go to default-2.TE          -1 thru -8 - Go up *-1 levels  ~ - Go to SYS$LOGIN  .. = [-]_J L - Go to TO_LOST   S - Go to TO_SAVE   T - Go to top level   \ = [000000]E W - Write recall stack to disk  R - Read saved recall stack from diskE  F You can use logical names from the LNM Recall Stack in other commands.  % Add the following to your LOGIN.COM:       $ TO :== @<location>TO.COM'     $ TO -INIT  ! to initialize TO.COM _	 $    EOD S $    RETURN( $!#  *** END OF PROCEDURE *** 