J 90000   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         !  PARSE_USING.INC -0         !    parses the screen file for maintainF         !    Creates a list of fields, in order, to substitute for the1         !      list created normally by Maintain. 	         ! F         !    Note that ANY arrays used by these (to mean, for example,M         !       display only) should be set by store_def_info in maintain.int K         !       to the default.  DO NOT rely upon Intouch's initialization. 	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*         !  U S E   C O M M A N D   F I L EJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%M         !  Read a file for the list of fields usable and other such commands.          !  File format is:         !     $field fieldname         !     $option display %         !     $field anotherfieldname          !     $valid Y,N	         ! I         ! Expected: par_usefile$  = name of a file containing field names H         !       This file must exist - if it doesn't, the program halts.:         !           valid_options$ = list of valid optionsK         !           all_valid_options$ = list of all possible valid options          ! Result: F         !           the file is read, the fields designated are loadedI         !       and modified as necessary, and valid_options$ is modified          !       as directed.C         !          display_file$ has the name of the "display" file H         !       with background screen information; "" if not specified.	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine use_command_file           error = true$         gosub initialize_to_use_file%         if  _error  then exit routine          when exception in            do-             line input #field_ch: using_line$ I             if trim$(using_line$) = ''  or  using_line$[1:1] = '!' then &                    repeat do 7             last_line$ = last_line$ + " " + using_line$ 1             if  right$(using_line$,1) = "&"  then >               last_line$[len(last_line$):len(last_line$)] = ""               repeat do              end if+             using_line$ = trim$(last_line$)              last_line$ = "" !             gosub parse_file_line $             if  _error  then exit do           loop         use            error = false          end when         close #field_ch            end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%6         !  I N I T I A L I Z E   T O   U S E   F I L EJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%?         !  Initialize variables to "use" a file; open the file.          !  Result::         !    in_field   = false (not currently in a field):         !    nbr_fields = 0     (not using any fields YET)5         !    last_line$ = ""    (last line was empty) J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    routine initialize_to_use_file  ;         in_field = false        !  Not currently in a field "         z = pos(par_usefile$, "]")#         z1 = pos(par_usefile$, ".") '         if  z1 = 0  or  z1 < z  then  & 1             par_usefile$ = par_usefile$ + ".MAIN" !         default_uppercase = false          when exception in +           open #field_ch: name par_usefile$          use 9           message error: extext$ + ' for ' + par_usefile$          end when         nbr_fields = 0         last_line$ = ""            end routine       J 91000   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(         !  P A R S E   F I L E   L I N EJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%L         ! This routine will parse a line of the file and break the data into         ! seperate arrays B         ! If in_field = false then skip the option and valid lines	         !          ! Expected: =         !          using_line$ = one line from the using file >         !          in_field = true if the field last mentioned2         !               can be handled by Maintain;         !          nbr_fields = the number of fields so far :         !           valid_options$ = list of valid optionsK         !           all_valid_options$ = list of all possible valid options 	         !          ! Result  : I         !    If the field is not found or an invalid command is entered,  >         !      it stops parsing and displays an error message.5         !          if $field then the field is set up <         !          if $option then field_option$() is loaded;         !          if $valid then  field_valid$() is loaded J         !          if  $field and the field cannot be handled by Maintain,(         !               in_field = false=         !          if $menu  then valid_options$ is modified. I         !      Store_def_info is used to store the definition information F         !          nbr_fields = the number of fields so far is updated	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine parse_file_line   G 91020   z = min(pos(using_line$ + " "," "), pos(using_line$ + ":",":")) 2         first$ = ucase$(trim$(using_line$[1:z-1]))-         the_rest$ = trim$(using_line$[z:999]) (         if  the_rest$[1:1] = ":"  then &-           the_rest$ = trim$(the_rest$[2:999]) +         second$ = element$(the_rest$,1," ")          select case first$           case '$DEFAULT' '             gosub parse_default_command "           case '$BEGIN_BACKGROUND'"             gosub parse_background            case '$USE_BACKGROUND'#             gosub parse_screen_name            case '$MODE'"             gosub parse_start_mode           case '$OPEN'             gosub parse_open           case '$RELATE'             gosub parse_relate           case '$FIELD'              show_error = true              gosub parse_field            case '$KEY' #             gosub parse_key_command            case '$LABEL'              show_error = false             gosub parse_field            case '$UPPERCASE' @             if  in_field  then  fld_uppercase(nbr_fields) = true           case '$LOWERCASE' A             if  in_field  then  fld_uppercase(nbr_fields) = false            case '$ROW' 7             if  in_field  then  gosub parse_row_request            case '$COLUMN':             if  in_field  then  gosub parse_column_request           case '$OPTION'2             if  in_field  then  gosub parse_option           case '$VALID' <             if  in_field  then  gosub parse_validation_rules           case '$ATTRIBUTE' 5             if  in_field  then  gosub parse_attribute            case '$MENU')             gosub parse_menu_modification            case '$PROMPT'6             if  in_field  then  gosub parse_new_prompt!           case '$DLEN', '$LENGTH' ;             if  in_field  then  gosub parse_new_display_len             case '$FORMAT','$MASK'4             if  in_field  then  gosub parse_new_mask(           case '$MSG','$MESSAGE','$HELP'4             if  in_field  then  gosub parse_new_help           case else >             message error : "Unknown command:  " + using_line$#         end select                     91099   end routine           J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%4         !  P A R S E   D E F A U L T   C O M M A N DJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%F         !  They said "$DEFAULT" + something.  Change the default stuff7         !       accordingly (such as DEFAULT UPPERCASE)          !  Expects: 0         !       second$ has the second parameter         !  Result:G         !       default_uppercase = true or false, depending on second$ J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine parse_default_command   #         select case ucase$(second$) 5           case "UPPERCASE":  default_uppercase = true 6           case "LOWERCASE":  default_lowercase = falseK           case else : message error : "Unknown default option:  " + second$          end select           end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%,         !  P A R S E   R O W   R E Q U E S TJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%L         !  They said "$ROW", so store it.  Check integer; check legal value.@         !       if row not_displayed  then  set the column, too.         !  Expects: *         !       second$ has the row number8         !       nbr_fields = the number of fields so far7         !       background_start = starting row allowed 3         !       background_end   = last row allowed          !  Result:J         !       req_row(nbr_fields) has the requested row (after checking)J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine parse_row_request   +         if  valid(second$, "INTEGER")  then            z = val(second$)'           if  z = not_displayed  then   /             req_col(nbr_fields) = not_displayed              exit routine           end if) !++ debug djs ++ 09-01-89 if  z < 0  then X !++ debug djs ++ 09-01-89   message error : "Negative rows not allowed:  " + using_line$@           if  z < background_start  or  z > background_end  thenC             message error : "Row is out of bounds:  " + using_line$            else#             req_row(nbr_fields) = z            end if         elseH           message error : "Integer row number expected:  " + using_line$         end if           end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%2         !  P A R S E   C O L U M N   R E Q U E S TJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O         !  They said "$COLUMN", so store it.  Check integer; check legal value. K         !       If it is already set to not_displayed then don't change it.          !  Expects: -         !       second$ has the column number 8         !       nbr_fields = the number of fields so far         !  Result:M         !       req_col(nbr_fields) has the requested column (after checking) J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine parse_column_request  +         if  valid(second$, "INTEGER")  then            z = val(second$)           if  z < 0 then  K             message error : "Negative columns not allowed:  " + using_line$            else<             if  req_col(nbr_fields) <> not_displayed  then &%               req_col(nbr_fields) = z            end if         elseK           message error : "Integer column number expected:  " + using_line$          end if           end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%,         !  P A R S E   S C R E E N   N A M EJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%K         !  They said "$USE_BACKGROUND".  Store the rest of the line as the  6         !       screenname, trimmed and in upper case.J         !  This is not a subcommand of $FIELD, so reset in_field to false.         !  Expects: 3         !       the_rest$ has the rest of the input 8         !       nbr_fields = the number of fields so far         !  Result:=         !       The screen name is stored FOR THE NEXT FIELD. @         !       req_screen$(nbr_fields + 1) has the screen name.          !       in_field = falseJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine parse_screen_name            gosub unquote_the_rest%         z$ = ucase$(trim$(the_rest$))          if  z$ = ""  then 3           req_screen$(nbr_fields + 1) = new_screen$            in_field = false         else@           req_screen$(nbr_fields + 1) = ucase$(trim$(the_rest$))           in_field = false         end if           end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%A         ! C H E C K   V A L I D   B A C K G R O U N D   N A M E S J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%E         ! check for the background names used if any.  Make sure that .         ! the background text was found for it	         ! 2         ! this routine is called from maintain.int	         !          ! Expected: L         !       req_screen$(field_number) = background name or blank        F         !       screen_names$             = names of backgrounds found	         !          ! Result  : 8         !       _error = true if there were any problems	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%,         routine check_valid_background_names           screen_names$[1:1] = "" *         for change_field = 1 to nbr_fields(           z$ = req_screen$(change_field)>           if  z$ = ""  or  z$ = new_screen$  then  iterate for1           if  match(screen_names$, z$) = 0  then  A             message error : "Unknown background name:  " + z$ + & 7                 " at field: " + str_name$(change_field)              exit routine           end if         next change_field            end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*         !  P A R S E   S T A R T   M O D EJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%I         !  They said "$MODE".  Store the rest of the line as the starting          !       mode (width)J         !  This is not a subcommand of $FIELD, so reset in_field to false.         !  Expects: 3         !       the_rest$ has the rest of the input          !  Result:3         !       start_mode$ = the rest of the input           !       in_field = falseJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine parse_start_mode           gosub unquote_the_rest<         if  match("WIDE,NARROW,132,80", the_rest$) = 0  thenE           message error : "Unrecognized screen mode:  " + using_line$            exit routine         end if         start_mode$ = the_rest$            end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*         !  P A R S E   B A C K G R O U N DJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%M         !  They said "$BEGIN_BACKGROUND".  Store the rest of the line as the           !       background name          !  Expects: 3         !       the_rest$ has the rest of the input          !  Result:8         !       display_filename$ = the display filenameJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine parse_background           gosub unquote_the_rest?         screen_names$ = screen_names$ + "," + ucase$(the_rest$) &         gosub start_new_display_screen         gosub read_background            end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*         !  P A R S E   N E W   P R O M P TJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%J         !  They said "$PROMPT".  Store the rest of the line as the prompt.         !  Expects: 3         !       the_rest$ has the rest of the input 8         !       nbr_fields = the number of fields so far         !  Result:H         !       str_prompt$(nbr_fields) is changed to the desired promptJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine parse_new_prompt           gosub unquote_the_rest/         if  str_prompt$(nbr_fields) = ""  and & 7             fld_option$(nbr_fields) = "DISPLAY"  then & ?             fld_option$(nbr_fields) = ""        ! Allow them to I                                                 ! use fields which didn't @                                                 ! have a prompt.+         str_prompt$(nbr_fields) = the_rest$            end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%4         !  P A R S E   N E W   D I S P L A Y   L E NJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%H         !  They said "$DLEN" or "$LENGTH".  Store the new display length         !  Expects: 6         !       second$ has the desired display length8         !       nbr_fields = the number of fields so far         !  Result:=         !       second$ is checked for positive integer valuee4         !       _error = true if there was a problemE         !       str_dlen(nbr_fields) is changed to the display lengthAJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine parse_new_display_len   /         if  not(valid(second$,"INTEGER"))  thenDL           message error : "Numeric display length expected:  " + using_line$           exit routine         end if         dlen = val(second$)E         if  dlen < 0  thenM           message error : "Positive display length expected:  " + using_line$            exit routine         end if  N         if  str_dlen(nbr_fields) > dlen  then & ! The mask is too long, cut it?           str_mask$(nbr_fields) = str_mask$(nbr_fields)[1:dlen]dG                                 ! Close enough.  If they don't like it,tN                                 !  they can create their own masks, which fit.#         str_dlen(nbr_fields) = dlen            end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%&         !  P A R S E   N E W   M A S KJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(         !  They said "$MASK".  Store it.         !  Expects:r3         !       the_rest$ has the rest of the inputs8         !       nbr_fields = the number of fields so far         !  Result:I         !       str_mask$(nbr_fields) is changed to the desired printmask.J         !       str_dlen(nbr_fields) is changed to the appropriate display         !               lengthJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine parse_new_mask           gosub unquote_the_rest)         str_mask$(nbr_fields) = the_rest$iK         str_dlen(nbr_fields) = len(the_rest$) - elements(the_rest$,'~') + 1[           end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%&         !  P A R S E   N E W   H E L PJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%J         !  They said "$HELP" or "$MSG" or "$MESSAGE"; store the help text.         !  Expects: )         !       the_rest$ has the message          !  Result:D         !       str_help$(nbr_fields) is changed to the help messageJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine parse_new_help           gosub unquote_the_rest)         str_help$(nbr_fields) = the_rest$            end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%8         !  P A R S E   M E N U   M O D I F I C A T I O NJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%@         !  They said "$MENU"; check to see what the next word is9         !    and set/change the menu options accordingly.s         !  Expects: :         !           valid_options$ = list of valid optionsK         !           all_valid_options$ = list of all possible valid options          !  Result:*         !       valid_options$ is modifiedJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%!   routine parse_menu_modification=  )         z = pos(the_rest$ + " ", " ") + 1e<         items$ = ucase$(change$(the_rest$[z:999],"'" + '"'))'                 ! Upper case, no quotes !         gosub check_ok_menu_items'%         if  _error  then exit routinen#         select case ucase$(second$)t/           case 'ITEMS': valid_options$ = items$            case 'REMOVE'%             z1$ = ""1             for t = 1 to elements(valid_options$)E.               z$ = element$(valid_options$, t)B               if  match(items$, z$) = 0  then z1$ = z1$ + ',' + z$             next t,             valid_options$ = z1$[2:len(z1$)]           case else C             message error : "Unknown $MENU subcommand:  " + second$          end select           end routinei      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%0         !  C H E C K   O K   M E N U   I T E M SJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;         !  Check that the items in items$ are truely valid.d         !  Expects: 0         !    items$ = the list of items to checkD         !    all_valid_options$ = list of all possible menu options.         !  Result:P         !    Message is printed and the program stops parsing if any of them are         !       invalid.J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine check_ok_menu_itemsd  %         for t = 1 to elements(items$)d!           z$ = element$(items$,t) 5           if  match(all_valid_options$, z$) = 0  thent7             message error : "Invalid menu item:  " + z$              exit for           end if         next t           end routinei      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"         !  P A R S E   O P T I O NJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%E         !  They said "$OPTION".  Check that it is valid and store it._         !  Expects:(5         !       second$ has the option they selected.(B         !       in_field = false if the field is being skipped (do         !         nothing)J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine parse_option           gosub unquote_the_rest!         second$ = ucase$(second$) @         if  match("DISPLAY,NOCHANGES,HIDDEN", second$) = 0  thenB           message error : "Unknow $OPTION subcommand:  " + second$         end if  )         fld_option$(nbr_fields) = second$eI         if  second$ = 'HIDDEN'  then  req_row(nbr_fields) = not_displayed G                 ! don't want hidden fields taking up room on the screen_         end routinee      J 93000   !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5         ! P A R S E   V A L I D A T I O N   R U L E S J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         ! >         ! This routine parses the $valid line of the text file>         !    Makes no checks on what the validation rules are.@         !    The validation rules can be found in validation.inc	         !          ! Expected: >         !       using_line$ has the current line from the file	         !          ! Result  :eA         !       valid_element$(,) = array with valid line, parsed D         !       max_validation() = has number of validation elements	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    routine parse_validation_rules   93020   z$ = parse$(the_rest$)/         nbr_valids = max_validation(nbr_fields)mE                                         ! Might have validation from  :                                         !   store_def_info         parameters_needed = 0 
         do           rule$ = parse$$           if rule$ = "" then exit doN           if rule$ = ";"  then repeat do        ! Concatenate rules with a ";"%           nbr_valids = nbr_valids + 1u7           valid_element$(nbr_fields,nbr_valids) = rule$g)           if  parameters_needed = 0  then$'             gosub check_need_parameters            else$             gosub check_ok_parameter           end if'           if  _error  then exit routine          loop  /         max_validation(nbr_fields) = nbr_valids%   93099   end routine%      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%4         !  C H E C K   N E E D   P A R A M E T E R SJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%B         !  See if this is something which needs parameters; if so,I         !    set the number of parameters expected and what they must be.%         !  Expects:%F         !       rule$ = the validatin rule, upper case with no leading+         !               or trailing spaces."         !  Result:H         !       parameters_needed = # parameters needed for this command=         !       param_integer = true if they must be integers:J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine check_need_parameters%           select case rule$%6           case 'NUMBER', 'INTEGER', 'DATE', 'REQUIRED'!             parameters_needed = 0%"           case 'ALLOW', 'CONTAINS'!             parameters_needed = 1t!             param_integer = false.            case 'RANGE', 'DIGITS'!             parameters_needed = 2               param_integer = true           case else @             message error : "Unknown validation rule:  " + rule$         end select           end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%.         !  C H E C K   O K   P A R A M E T E RJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%D         !  Check that the parameter is of the proper type; decrementC         !    the counter which says how many parameters are needed.          !  Expects:_9         !    parameters_needed = # parameters needed (>0)iF         !    param_integer = true if the parameter must be an integer.)         !    rule$ = the parameter itself0=         !    using_line$ = the entire line, for error displaygJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine check_ok_parameter  1         parameters_needed = parameters_needed - 1 C         if  param_integer  and  not(valid(rule$,"INTEGER"))  then & G           message error : "Integer parameter expected:  " + using_line$            end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(         !  R E A D   B A C K G R O U N DJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%&         !  Read the background screens         !  Expects:s         !                !  Result:G         !       store_contents$(*,*) contains stored screen informationcF         !       screen_names$ is a list of screen names, uppercase and=         !         trimmed, in the order that they are stored.fJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine read_background            when exception in%           do)             line input #field_ch: d_line$a$             select case d_line$[1:1]               case "!":e2               case "$": gosub display_file_command               case elsegF                 if  in_screen and store_line <= background_end  then &K                   store_contents$(nbr_stored_screens, store_line) = d_line$ +                 store_line = store_line + 1              end select0           loop while (not(problem) and not(eos))         usee         end when         set error off $         if problem then set error on           end routine%      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%2         !  D I S P L A Y   F I L E   C O M M A N DJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%C         !  In the display file, they used a command.  Interpret the 8         !       command and set variables appropriately.         !  Expects: B         !       d_line$ has the line of text; it begins with a "$"         !  Result:E         !       in_screen, store_line, nbr_screens, and screen_names$ +         !         are modified as necessaryEJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine display_file_command  ?         z = min(pos(d_line$ + " "," "), pos(d_line$ + ":",":"))%.         first$ = ucase$(trim$(d_line$[1:z-1])))         the_rest$ = trim$(d_line$[z:999])r(         if  the_rest$[1:1] = ":"  then &-           the_rest$ = trim$(the_rest$[2:999])_         gosub unquote_the_rest           select case first$           case "$TITLE"1!             if  in_screen  then & @                     store_title$(nbr_stored_screens) = the_rest$            case "$END_BACKGROUND"             in_screen = false%             eos = true           case "$PRINT" F                 if  in_screen and store_line <= background_end  then &K                   store_contents$(nbr_stored_screens, store_line) = d_line$e+                 store_line = store_line + 1k           case else B             message error : "Unknown display command:  " + d_line$             problem = true         end select           end routine_      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%:         !  S T A R T   N E W   D I S P L A Y   S C R E E NJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%A         !  Start a new background screen.  Increase the number of%=         !       screens and reset the screen itself to blank.          !  Expects:=H         !       nbr_stored_screens = the number of screens stored so farH         !       background_start = the line number the background screen         !         starts atc         !  Result:;         !       in_screen is true (you are now in a screen)eN         !       store_line = background_start (store at the top of the screen)1         !       nbr_stored_screens is incrementedcG         !       screen_contents$(nbr_stored_screens,*) is set to blank.%J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"   routine start_new_display_screen           in_screen = true         eos = false%         problem = false"%         store_line = background_startt3         nbr_stored_screens = nbr_stored_screens + 1 2         for z = background_start to background_end5           store_contents$(nbr_stored_screens, z) = ""_         next z           end routine              J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         ! P A R S E   O P E N%J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%H         ! Found an $open statement.  parse the file name(s) and open the         ! structure.	         !          ! Expected: 8         !       the_rest$ = the using line without $open	         !          ! Result  : -         !       the structure has been openednA         !       the name has been included into valid_structures$%	         !%J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine parse_open           gosub unquote_the_restK         the_rest$ = change$(the_rest$, ",", " ") !in case the seperate by , 1         the_rest$ = ucase$(edit$(the_rest$, 16%))          structure_given = falseo         datafile_given = false         name_given = false         par_structure$ = ""e         par_datafile$ = ""         par_filename$ = ""
         t = 0%
         do           t = t + 1 1           select case element$(the_rest$, t, ' ')m             case '': exit do             case 'DATAFILE'u(               if  datafile_given  then &<                  message error : "Cannot use two data files"#               datafile_given = true%               t = t + 1 9               par_datafile$ = element$(the_rest$, t, ' ')%             case "STRUCTURE"             case "NAME"%$               if  name_given  then &7                  message error : "Cannot use two names"s               name_given = true                t = t + 1 9               par_filename$ = element$(the_rest$, t, ' ')              case else )               if  structure_given  then &t<                  message error : "Cannot use two structures"$               structure_given = true:               par_structure$ = element$(the_rest$, t, ' ')           end select"           if  _error  then exit do         loop                 gosub open_structure           end routineb      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         ! O P E N   S T R U C T U R E J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%H         ! Actually open a structure. Only the main structure is open for         ! modification	         !%J         ! This routine is longer than 22 lines due to the select case stmt	         !          ! Expected:%:         !       par_structure$ = name of structure to open8         !       par_datafile$  = name of datafile if any4         !       par_filename$  = synonym name if anyC         !       open_structures = number of structures already openfC         !       valid_structures$ = names of already open structuref	         !          ! Result  : .         !       open_structures is incrementedO         !       valid_structures$ is updated with the name of the new structure%	         !%J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine open_structure  !         gosub open_structure_init &         if  _error  then  exit routine#         select case open_structures          case 1           when exception inn$             if  datafile_given  thenF               open structure str1:name par_structure$, access outin, &'                  datafile par_datafile$              elseD               open structure str1: name par_structure$, access outin             end if
           usel?             message error: extext$ + '  for  ' + par_structure$            end when(           if  _error  then  exit routine$           ask structure str1 : id z$           str_id$(1) = z$ %           set structure struc : id z$ *           main_structure$ = par_structure$         case 2           when exception in%$             if  datafile_given  thenF               open structure str2:name par_structure$, access outin, &'                  datafile par_datafile$M             elseD               open structure str2: name par_structure$, access outin             end if
           uset:             message error: extext$ + '  for  ' + the_rest$           end when)           if  _error  then  exit  routine $           ask structure str2 : id z$           str_id$(2) = z$e         case 3           when exception in $             if  datafile_given  thenF               open structure str3:name par_structure$, access outin, &'                  datafile par_datafile$b             elseD               open structure str3: name par_structure$, access outin             end if
           use :             message error: extext$ + '  for  ' + the_rest$           end when)           if  _error  then  exit  routine $           ask structure str3 : id z$           str_id$(3) = z$%         case 4           when exception inS$             if  datafile_given  thenF               open structure str4:name par_structure$, access outin, &'                  datafile par_datafile$(             elseD               open structure str4: name par_structure$, access outin             end if
           useo:             message error: extext$ + '  for  ' + the_rest$           end when)           if  _error  then  exit  routine $           ask structure str4 : id z$           str_id$(4) = z$%         case 5           when exception inU$             if  datafile_given  thenF               open structure str5:name par_structure$, access outin, &'                  datafile par_datafile$              elseD               open structure str5: name par_structure$, access outin             end if
           usei:             message error: extext$ + '  for  ' + the_rest$           end when)           if  _error  then  exit  routine $           ask structure str5 : id z$           str_id$(5) = z$%         case 6           when exception in%$             if  datafile_given  thenF               open structure str6:name par_structure$, access outin, &'                  datafile par_datafile$"             elseD               open structure str6: name par_structure$, access outin             end if
           usen:             message error: extext$ + '  for  ' + the_rest$           end when)           if  _error  then  exit  routine $           ask structure str6 : id z$           str_id$(6) = z$E         case 7           when exception in $             if  datafile_given  thenF               open structure str7:name par_structure$, access outin, &'                  datafile par_datafile$e             elseD               open structure str7: name par_structure$, access outin             end if
           use :             message error: extext$ + '  for  ' + the_rest$           end when)           if  _error  then  exit  routineE$           ask structure str7 : id z$           str_id$(7) = z$%         case 8           when exception inm$             if  datafile_given  thenF               open structure str8:name par_structure$, access outin, &'                  datafile par_datafile$o             elseD               open structure str8: name par_structure$, access outin             end if
           use :             message error: extext$ + '  for  ' + the_rest$           end when)           if  _error  then  exit  routinen$           ask structure str8 : id z$           str_id$(8) = z$=         case 9           when exception in_$             if  datafile_given  thenF               open structure str9:name par_structure$, access outin, &'                  datafile par_datafile$              elseD               open structure str9: name par_structure$, access outin             end if
           useO:             message error: extext$ + '  for  ' + the_rest$           end when)           if  _error  then  exit  routinee$           ask structure str9 : id z$           str_id$(9) = z$          case 10a           when exception in $             if  datafile_given  thenG               open structure str10:name par_structure$, access outin, &%'                  datafile par_datafile$%             elseE               open structure str10: name par_structure$, access outind             end if
           usea:             message error: extext$ + '  for  ' + the_rest$           end when)           if  _error  then  exit  routine %           ask structure str10 : id z$i           str_id$(10) = z$         end select@         valid_structures$ = valid_structures$ + "," + open_name$1         if  valid_structures$[1:1] = ","  then  &_<                 valid_structures$ = valid_structures$[2:999]           end routine%      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%/         ! O P E N   S T R U C T U R E   I N I T%J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'         ! initialize for open structure :         ! get structure name without directory or logicals-         ! make sure it hasn't been opened yet F         ! make sure not more than max_structures structures are opened	         !f         ! Expected: H         !       par_structure$ is the name of the structure to be openedK         !       par_filename$ is the synonym name of the structure if givenoK         !       valid_structures$ contains the names of already opened str.%=         !       open_structures = number of opened structures B         !       max_structures  = max number of structures allowed	         !          ! Result  : .         !       open_structures is incrementedH         !       open_name$ = name of structure to be opened without dir.	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#         routine open_structure_initp  %         if  par_filename$ <> ""  then"$           open_name$ = par_filename$         else&           z = pos(par_structure$, ']')           if  z = 0  thena(             z = pos(par_structure$, ':')           end if.           open_name$ = par_structure$[z+1:999]         end if;         if  match(valid_structures$, open_name$) <> 0  then P           message error : "Structure " + open_name$ + " has already been opened"           exit routine         end if2         if  open_structures = max_structures  thenC           message error : "Attempt to open more than 10 structures"%           error = true           exit routine         end if-         open_structures = open_structures + 1s           end routines      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%!         ! P A R S E   R E L A T EaJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%J         ! Parse a relate statement.  Will establish a relationship between'         ! two already opened structures 	         !e         ! Expected: 7         !       the_rest$ = the relationship expression%	         !%         ! Result  : B         !       relate_str(x,x) = the two structures to be related:         !       relate_fld$(,)  = the two fields to relate.         !       nbr_relates     is incremented	         !'J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine parse_relate            gosub parse_relate_setup&         if  _error  then  exit routine$         for  rel = 1 to rel_elements4           the_field$ = element$(the_rest$, rel, ' ')2           if  the_field$ = 'TO'  then  iterate for"           gosub breakout_structure(           if  _error  then  exit routine(           gosub parse_relate_field_check(           if  _error  then  exit routine%           rel_phrase = rel_phrase + 1C<           relate_str(nbr_relates, rel_phrase) = u_str_number9           relate_fld$(nbr_relates, rel_phrase) = u_field$d         next rel!         gosub parse_relate_finishe           end routined      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-         ! P A R S E   R E L A T E   S E T U P J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%6         ! initialize for parsing the relate expression	         !n         ! Expected: -         !       the_rest$ = relate expression C         !       nbr_relates = number of relates already establishede?         !       max_relates = maximum number of relates allowed 	         !          ! Result  :n*         !       nbr_relates is incremented         !       rel_phrase = 0	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"         routine parse_relate_setup           gosub unquote_the_rest1         the_rest$ = ucase$(edit$(the_rest$, 16%)) /         rel_elements = elements(the_rest$, " ")(+         if  nbr_relates = max_relates  then M           message error : "Maximum number of relates has been exceeded: " + & 1                 "maximum is " + str$(max_relates)            error = true           exit routine         end if%         nbr_relates = nbr_relates + 1          rel_phrase = 0           end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%9         ! P A R S E   R E L A T E   F I E L D   C H E C K_J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%D         ! check to make sure that the field is part of the structure	         !s         ! Expected: 8         !       u_str_number = structure number to check2         !       u_field$     = field name to check	         !t         ! Result  : 4         !       _error is true if there is a problem	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(         routine parse_relate_field_check  6         set structure struc : id str_id$(u_str_number)7         ask structure struc, field #u_field$ : number z%         if  z = 0  thenI6           message error : "Relate invalid: Field " + &?                 u_field$ + " is not a field in structure: " + & >                 element$(valid_structures$, u_str_number, ',')         end if           end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%/         ! P A R S E   R E L A T E   F I N I S H%J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%G         ! check to see that the relate expression was okay.  Check that <         ! relate to field is a key in the related structure..         ! check that all elements were defined	         !e         ! Expected:&=         !       relate_str(,)  = the two structures to relate 9         !       relate_fld$(,) = the two fields to relatea1         !       nbr_relates    = the relate index 6         !       the_rest$      = the relate expression	         !          ! Result  :G	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#         routine parse_relate_finisht           for z = 1 to 23           if  relate_str(nbr_relates, z) = 0  or  &d4               relate_fld$(nbr_relates, z) = ""  thenE             message error : "Invalid relate expression: " + the_rest$o             error = true             exit routine           end if         next z         gosub relate_key_field         if  _error  then           error = true           exit routine         end if           end routineI      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)         ! R E L A T E   K E Y   F I E L DbJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%2         ! check to see if the field given is a key	         !          ! Expected:e9         !       relate_str(,2)  = number of the structurea3         !       relate_fld$(,2) = name of the fieldn8         !       nbr_relates     = index to relate arrays	         !n         ! Result  :a8         !       _error is true if the field is not a key	         !sJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          routine relate_key_field  D         set structure struc : id str_id$(relate_str(nbr_relates, 2))I         ask structure struc, field #relate_fld$(nbr_relates, 2) : keyed zp!         if  z  then  exit routinerL         message error : "related structure/field is not a keyed field: " + &                 the_rest$t         error = true           end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%/         ! F I N I S H   R E L A T E   S E T U P J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-         ! finish processing the relate arrays 5         ! check for multiple relates to one structure%J         ! store the related structure index for the field if it is the key         ! to a relatee	         !          ! Expected: 9         !       nbr_relates = number of relations definedn6         !       nbr_fields  = number of fields defined;         !       relate_str() = relate structure information 6         !       relate_fld$()   = relation information,         !       str_name$() = name of fields	         !%         ! Result  :%J         !       fld_relate_key$() is set to relation indexs that the field*         !                         triggersI         !       fld_relate_in()   is set to relation index that finds the 7         !                         record for this fieldn	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#         routine finish_relate_setup   "         gosub finish_relate_arrays*         gosub finish_relate_check_multiple,         gosub finish_relate_check_structures           end routineA      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%1         ! F I N I S H   R E L A T E   A R R A Y SeJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%J         ! store the related structure index for the field if it is the key         ! to a relate 	         !          ! Expected: 9         !       nbr_relates = number of relations defineda6         !       nbr_fields  = number of fields defined;         !       relate_str() = relate structure informationa6         !       relate_fld$()   = relation information,         !       str_name$() = name of fields	         !"         ! Result  :tJ         !       fld_relate_key$() is set to relation indexs that the field*         !                         triggersI         !       fld_relate_in()   is set to relation index that finds the 7         !                         record for this field%	         !%J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%$         routine finish_relate_arrays            for z = 1 to nbr_relates           z2 = relate_str(z, 1)l            z$ = relate_fld$(z, 1)"           for z1 = 1 to nbr_fields*             if  str_name$(z1) = z$  and  &,                 fld_structure(z1) = z2  thenG               fld_relate_key$(z1) = fld_relate_key$(z1) + " " + str$(z) 8               if  fld_relate_key$(z1)[1:1] = " "  then &@                 fld_relate_key$(z1) = fld_relate_key$(z1)[2:999]             end if:             if  fld_structure(z1) = relate_str(z, 2)  then#               fld_relate_in(z1) = zo             end if           next z1e         next z           end routinee      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%A         ! F I N I S H   R E L A T E   C H E C K   M U L T I P L E%J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%K         ! check to see if a structure is the target of more than one relate 	         !s         ! Expected: ;         !       max_relates = number of relates establisheda?         !       relate_str(x, 2) = target structure of a relater	         !c         ! Result  : 7         !       _error = true if multiple relates found 	         !nJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%,         routine finish_relate_check_multiple            for z = 1 to nbr_relates           z1 = relate_str(z, 2)r$           for  z2 = 1 to nbr_relates)             if  z2 = z  then  iterate for),             if  relate_str(z2, 2) = z1  then/               message error : "Structure: " + & 8                 element$(valid_structures$, z1, ',') + &4                 ' is the target of multiple relates'               exit for             end if           next z2l         next z           end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%E         ! F I N I S H   R E L A T E   C H E C K   S T R U C T U R E SeJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%E         ! check to make sure that each of the supplemental structuresa"         ! has an associated relate	         !          ! Expected:h@         !       valid_structures$ = names of all structures openI         !       relate_str(x, 2)  = structure number of related structure 	         !n         ! Result  : @         !       _error = true if a structure hasn't been related	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%.         routine finish_relate_check_structures  ,         z = elements(valid_structures$, ',')         for z1 = 2 to z            str_ok = false#           for z2 = 1 to nbr_relates :             if  z1 <> relate_str(z2, 2)  then  iterate for             str_ok = true              exit for           next z2e'           if  str_ok  then  iterate for 3           z$ = element$(valid_structures$, z1, ',') E           message error : "Structure " + z$ + " has not been related"          next z1n           end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         ! P A R S E   F I E L DhJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%G         ! parse the field name.  Make sure that it is a valid field (infF         ! one structure only or else that the structure was explicitly<         ! given) and that the data type is one we can handle	         !          ! Expected:o:         !       the_rest$ = the using line being processed	         !e         ! Result  :tF         !       u_str_number = number of the structure the field is in0         !       u_field$     = name of the field2         !       fld          = number of the field	         !sJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine parse_field            gosub unquote_the_rest&         the_field$ = ucase$(the_rest$)          gosub breakout_structure&         if  _error  then  exit routine          gosub process_field_name&         if  _error  then  exit routine6         set structure struc : id str_id$(u_str_number)         gosub get_def_info#         if  data_type$ = "UN"  or & 7             (data_type$ = "DS" and struc_len = 8)  thenu9           in_field = false      !  Can't handle the field H           exit routine          !    if it is an unsupported data type  >         end if                  !  (unknown or VMS date stamp)         in_field = true #         nbr_fields = nbr_fields + 1tI         fld_option$(nbr_fields) = "" ! blank it out so it isn't left over          gosub store_def_info5         fld_uppercase(nbr_fields) = default_uppercase 0         fld_structure(nbr_fields) = u_str_number/         if  str_prompt$(nbr_fields) = ""  or  &e0             fld_structure(nbr_fields) > 1  then -           fld_option$(nbr_fields) = "DISPLAY"          end if           end routine_      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-         ! B R E A K O U T   S T R U C T U R E J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%F         ! Get the structure and field broken apart.  Expecting either G         ! name or str(name).  If the structure is explicitly given thenp2         ! verify that it is a valid structure name	         !          ! Expected:_7         !       the_field$ contains the using line dataeD         !       valid_structures$ is a list of valid structure names	         !          ! Result  :::         !       u_structure$ = name of the structure given0         !       u_field$     = name of the field:         !       u_str_number = the number of the structure	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"         routine breakout_structure            z = pos(the_field$, '(')         if  z = 0  thena           u_structure$ = ""            u_field$ = the_field$            u_str_number = 0           exit routine         end if6         z$ = edit$(change$(the_field$, "()", " "), 16)+         u_structure$ = element$(z$, 1, " ")r'         u_field$ = element$(z$, 2, " ")t=         u_str_number = match(valid_structures$, u_structure$) "         if  u_str_number = 0  thenJ           message error : using_line$ + " references an unknown structure"           exit routine         end if           end routiner      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-         ! P R O C E S S   F I E L D   N A M E J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%0         ! make sure that the field name is validH         ! if a structure was specified then make sure the field is in itH         ! if not then search all of the structures.  Also make sure thatC         ! the field isn't ambiguous if a structure wasn't specified 	         !          ! Expected: L         !       u_str_number = index to structure array that the field is in	         !e         ! Result  :nD         !       u_str_number = actual structure index for this field	         !mJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"         routine process_field_name           u_ambiguous = 0 "         if  u_str_number > 0  then           gosub check_field $           if  not(field_found)  then             gosub bad_fieldm           end if           exit routine         end if/         for u_str_number = 1 to open_structures%           gosub check_field !           if  field_found  then   )             u_ambiguous = u_ambiguous + 1 #             str_save = u_str_number              fld_save = fld           end if         next u_str_number "         if  u_ambiguous <> 1  then           gosub bad_field            exit routine         end if         u_str_number = str_savea         fld = fld_save           end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         ! C H E C K   F I E L DnJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%I         ! check a structure to see if a field is a field in the structure 	         !x         ! Expected:n2         !       str_id$() = array of structure idsK         !       u_str_number = index to str_id array for the struc to check%2         !       u_field$     = field name to check	         !a         ! Result  :%@         !       field_found  = true if field is in the structure8         !       fld          = field number of the field	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine check_fielde           field_found = false 6         set structure struc : id str_id$(u_str_number)9         ask structure struc, field #u_field$ : number flde-         if  fld > 0  then  field_found = true                   end routinee      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         ! B A D   F I E L DaJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%F         ! a bad field was found ( not in a structure or was ambiguous)         ! print a message 	         !          ! Expected:OI         !       u_ambiguous = count of the number of structures the fieldr*         !                     was found in	         !e         ! Result  :f          !       in_field = false	         !hJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine bad_fieldf  !         if  u_ambiguous = 0  thend5           z$ = "Field " + u_field$ + " was not found"e         else4           z$ = "Field " + u_field$ + " is ambiguous"         end if         if  show_error  then &           message error : z$         in_field = false           end routine%      J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%+         ! P A R S E   K E Y   C O M M A N D J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	         !e         ! Brief description:B         !       user wants to select the keys that can be accessed	         !          ! Expected: 	         !          ! Locals:e	         !          ! Results:	         ! J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%!         routine parse_key_commande           gosub unquote_the_rest&         the_field$ = ucase$(the_rest$)          gosub breakout_structure&         if  _error  then  exit routine          gosub process_field_name&         if  _error  then  exit routine"         if  u_str_number <> 1 then)           message error : using_line$ + & ?                 ' - key fields must be from the main structure'e           exit routine         end if8         ask structure str1, field #u_field$ : keyed z, &#                 description f_desc$%         if  not z then?           message error : using_line$ + ' - is not a key field'            exit routine         end if         nbr_keys = nbr_keys + 1%2         if  f_desc$ = ''  then  f_desc$ = u_field$2         keys$(nbr_keys) = u_field$ + '|' + f_desc$          user_defined_keys = true  6         set structure struc : id str_id$(u_str_number)                  end routine       J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'         ! P A R S E   A T T R I B U T E%J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%M         ! parse the attribute command.  Break out the selected attributes andm1         ! set a bit in the str_attribute() array.:	         !          ! Expected:e:         !       the_rest$ = the display attributes desired3         !       nbr_field = index into field arraysu	         !          ! Result  :nB         !       str_attribute$() will be loaded with the requested*         !                       attributes	         !%J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         routine parse_attribute%           gosub unquote_the_rest1         the_rest$ = ucase$(edit$(the_rest$, 16%))h.         str_attribute$(nbr_fields) = the_rest$           end routines        J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*         !  U N Q U O T E   T H E   R E S TJ         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%:         !  If the_rest$ has quotes around it, remove them.J         !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   routine unquote_the_rest           z$ = trim$(the_rest$) /         if  (left$(z$,1) = right$(z$,1))  and &%4             (z$[1:1] = "'" or z$[1:1] = '"')  then &'           the_rest$ = z$[2:len(z$) - 1]            end routine       