 /* verb_find_entity.c   : 	This module has the pleasure of figuring out what commandB         block actually references the given entity block. This is 1         used for displaying the disallows clause.   A         Modified 30-Apr-2003 Stephen Hoffman, OpenVMS Engineering ;                 $VMS_STATUS_SUCCESS, removed /STANDARD=VAXC    */ #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <lib$routines.h>  #include <ssdef.h> #include <stsdef.h>    #include "verb.h"   < CommandBlock *verb_find_entity(VectorBlock *, CommandBlock*,=                                CommandBlock *, EntityBlock*);   C CommandBlock *verb_find_entity_in_cmd(VectorBlock *, CommandBlock*, 4                                       EntityBlock*);  C CommandBlock *verb_find_entity_in_ent(VectorBlock *, CommandBlock*, B                                       EntityBlock*, EntityBlock*);  C CommandBlock *verb_find_entity_in_typ(VectorBlock *, CommandBlock*, @                                       EntityBlock*, TypeBlock*);   #define MAX_ENTITIES 8192    static struct info_block {    CommandBlock *command;   EntityBlock *entity; } lookup_table[MAX_ENTITIES]; + /* static CommandBlock *verb_in_use = 0; */  static int max_entity = 0;  2 CommandBlock *check_entity_table(EntityBlock *ent) {    int i;"   for (i = 0; i < max_entity; ++i)   { F     if (lookup_table[i].entity == ent) return lookup_table[i].command;   }    return NULL; }   8 add_to_entity_table(CommandBlock *cmd, EntityBlock *ent) { "     if (max_entity < MAX_ENTITIES)     { /         lookup_table[max_entity].command = cmd; .         lookup_table[max_entity].entity = ent;         ++max_entity;      }      else     { J         printf("Internal error: MAX_ENTITIES in %s needs to be larger!\n",             __FILE__);         lib$signal(SS$_ABORT);     }  }   F CommandBlock *verb_find_entity(VectorBlock *table, CommandBlock *verb,8                     CommandBlock *cmd, EntityBlock *ent) {    CommandBlock *tmp = 0;   /* **  if (verb_in_use != verb) **  {  **    verb_in_use = verb;  **    max_entity = 0;  **  }  */      tmp = check_entity_table(ent);   if (tmp) return tmp;  ?   /* first check to see if 'ent' is found in the 'cmd' block */ 1   tmp = verb_find_entity_in_cmd(table, cmd, ent);    if (tmp) return tmp;  4   /* then start traversing the whole verb (ouch). */2   tmp = verb_find_entity_in_cmd(table, verb, ent);   if (tmp) return tmp;  C   /* Otherwise, start traversing the whole verb tree (big ouch). */    {      CommandTableBlock *cmds;     VerbTableBlock *verbs;     int i, verb_count;  -     verbs = TRO(table, table->vec_l_verbtbl); -     cmds  = TRO(table, table->vec_l_comdptr);   >     verb_count = (verbs->verb_w_size - VERB_K_HEADER_LENGTH) //                  sizeof(verbs->verb_l_name[0]);   $     for (i = 0; i < verb_count; ++i)     { =       CommandBlock *cmd = TRO(table, cmds->comd_l_cmdtro[i]);   5       tmp = verb_find_entity_in_cmd(table, cmd, ent);        if (tmp) return tmp;     }    }   6   /* otherwise, we couldn't find the thing (error?) */   return NULL; }   9 CommandBlock *verb_find_entity_in_cmd(VectorBlock *table, 8                     CommandBlock *cmd, EntityBlock *ent) {    CommandBlock *tmp;     if (cmd->cmd_l_parms)    { 2     tmp = verb_find_entity_in_ent(table, cmd, ent,@                                   TRO(table, cmd->cmd_l_parms));     if (tmp) return tmp;   }      if (cmd->cmd_l_quals)    { 2     tmp = verb_find_entity_in_ent(table, cmd, ent,@                                   TRO(table, cmd->cmd_l_quals));     if (tmp) return tmp;   }      return NULL; }   L CommandBlock *verb_find_entity_in_ent(VectorBlock *table, CommandBlock *cmd,:                     EntityBlock *target, EntityBlock *ent) { !   CommandBlock *tmp, *retval = 0;      if (check_entity_table(ent))   { 1     return NULL; /* already checked this fully */    }    else   { "     add_to_entity_table(cmd, ent);   }      if (target == ent)#     retval = cmd; /* is it here? */      if (ent->ent_l_next)   { 5     tmp = verb_find_entity_in_ent(table, cmd, target, ?                                   TRO(table, ent->ent_l_next)); %     if (tmp && !retval) retval = tmp;    }      if (ent->ent_l_syntax)   { G     tmp = verb_find_entity_in_cmd(table, TRO(table, ent->ent_l_syntax), *                                   target);%     if (tmp && !retval) retval = tmp;    }      if (ent->ent_l_user_type)    { 5     tmp = verb_find_entity_in_typ(table, cmd, target, D                                   TRO(table, ent->ent_l_user_type));%     if (tmp && !retval) retval = tmp;    }      return retval; }     L CommandBlock *verb_find_entity_in_typ(VectorBlock *table, CommandBlock *cmd,8                     EntityBlock *target, TypeBlock *typ) {    CommandBlock *tmp;  B   if (target == (EntityBlock *) typ) return cmd; /* is it here? */     if (typ->type_l_keywords)    { 5     tmp = verb_find_entity_in_ent(table, cmd, target, D                                   TRO(table, typ->type_l_keywords));     if (tmp) return tmp;   }      return NULL; } 