 /*         Visual Queue Manager4       Copyright (C) 1992-1993 by Brandeis University       Author: Vadim Gorokhovsky        Created: v1.0 Summer 1992 +       Revised: v2.0, v2.1, v2.2 Spring 1993        Revised: v3.0 Summer 1993        Revised: v3.1 Autumn 1993        File: screen.c  G       You are given permission to distribute and/or modify this program J       under the terms of the GNU general license as long as this copyright?       notice is retained.  See README.DOC for more information.  */   #include "vqm.h"  9 extern int marker, scroll_point, new_broadcast, status;   ; extern long int row_view, col_view, view_l, view_w, term_l; < extern unsigned long int cont_display, cont_paste, keyboard;   void cursor_off(void)  { 4    unsigned long int cursor_flag = SMG$M_CURSOR_OFF;  ;    status = SMG$SET_CURSOR_MODE(&cont_paste, &cursor_flag); &    echeck(status, __LINE__, __FILE__); }    void cursor_on(void) { 3    unsigned long int cursor_flag = SMG$M_CURSOR_ON;   ;    status = SMG$SET_CURSOR_MODE(&cont_paste, &cursor_flag); &    echeck(status, __LINE__, __FILE__); }    void delete_screen(void) {     cursor_on(); 9    status = SMG$DISABLE_BROADCAST_TRAPPING(&cont_paste);  &    echeck(status, __LINE__, __FILE__);3    status = SMG$DELETE_VIRTUAL_KEYBOARD(&keyboard); &    echeck(status, __LINE__, __FILE__);/    status = SMG$DELETE_VIEWPORT(&cont_display); &    echeck(status, __LINE__, __FILE__);6    status = SMG$DELETE_VIRTUAL_DISPLAY(&cont_display);&    echeck(status, __LINE__, __FILE__);/    status = SMG$DELETE_PASTEBOARD(&cont_paste); &    echeck(status, __LINE__, __FILE__); }   # void change_view(long int row_view)  { W    status = SMG$CHANGE_VIEWPORT(&cont_display, &row_view, &col_view, &view_l, &view_w); &    echeck(status, __LINE__, __FILE__); }   N void output_info(int num, Vertex node, void (*make_line)(int, Vertex, char*),                   int mark_flag)  { .    long int row, col, rend_mask=SMG$M_REVERSE;.    char line[TERMWIDTH-1], line1[TERMWIDTH-1];    $DESCRIPTOR(line_d, line);     int status;      line1[0]='\0'; "    (*make_line)(num, node, line1);    line_d.dsc$a_pointer=line1;%    line_d.dsc$w_length=strlen(line1);     col = 1; row = num;    if (mark_flag == TRUE){O      status = SMG$PUT_CHARS(&cont_display, &line_d, &row, &col, 0, &rend_mask); (      echeck(status, __LINE__, __FILE__);    } else { A      status = SMG$PUT_CHARS(&cont_display, &line_d, &row, &col);  (      echeck(status, __LINE__, __FILE__);    } }        int read_key(int timeout_flag) {     unsigned short int c;    long int timeout = 1;      if (timeout_flag){ 5       SMG$READ_KEYSTROKE(&keyboard, &c, 0, &timeout);     } else { (       SMG$READ_KEYSTROKE(&keyboard, &c);    }    return (int) c; }    int read_string(char *text)  {    char str[LINELEN];   $DESCRIPTOR(text_d, str);    unsigned long int modifiers;   long int max_len=LINELEN-1; &   unsigned short res_len, termin_code;     cursor_on();7   modifiers = (TRM$M_TM_NORECALL | TRM$M_TM_TRMNOECHO); E   SMG$READ_STRING(&keyboard, &text_d, 0, &max_len, &modifiers, 0, 0,  +                   &res_len, &termin_code);     str[res_len]='\0';   strcpy(text, str);   cursor_off();    return termin_code;  }    void erase_screen(void)  { -    status = SMG$ERASE_DISPLAY(&cont_display); &    echeck(status, __LINE__, __FILE__); }    void refresh_screen(void)  { ,    status = SMG$REPAINT_SCREEN(&cont_paste);&    echeck(status, __LINE__, __FILE__); }    void reset_viewport(void)  {         row_view=1;    col_view=1;    scroll_point=1;W    status = SMG$CHANGE_VIEWPORT(&cont_display, &row_view, &col_view, &view_l, &view_w); &    echeck(status, __LINE__, __FILE__); }     ( void erase_below_line(int long line_num) { ,    long int start_row=line_num, start_col=1;  E    status = SMG$ERASE_DISPLAY(&cont_display, &start_row, &start_col); &    echeck(status, __LINE__, __FILE__); }    void move_cursor_home(void)  {     long int row=1, col=1;   :    status = SMG$SET_CURSOR_ABS(&cont_display, &row, &col);&    echeck(status, __LINE__, __FILE__); }   ! void make_header(char que_name[])  { @    long int row, col, attrib=SMG$M_BORDER, rend_mask=SMG$M_BOLD;$    static unsigned long int display;"    char longblank[]=MSG_LONGBLANK;    static int init_counter; !    $DESCRIPTOR(text_d, que_name); #    $DESCRIPTOR(blank_d, longblank);          if (! init_counter++){ !       row = 1; col = TERMWIDTH-1; I       status = SMG$CREATE_VIRTUAL_DISPLAY(&row, &col, &display, &attrib); )       echeck(status, __LINE__, __FILE__);     }    row=1; col=1;:    status = SMG$PUT_CHARS(&display, &blank_d, &row, &col);&    echeck(status, __LINE__, __FILE__);!    text_d.dsc$a_pointer=que_name; (    text_d.dsc$w_length=strlen(que_name);1    row = 1; col = (TERMWIDTH-strlen(que_name))/2; H    status = SMG$PUT_CHARS(&display, &text_d, &row, &col, 0, &rend_mask);&    echeck(status, __LINE__, __FILE__);    row = 2; col = 2;I    status = SMG$PASTE_VIRTUAL_DISPLAY(&display, &cont_paste, &row, &col); &    echeck(status, __LINE__, __FILE__); }   & void make_message_line(char message[]) {     long int row, col; $    static unsigned long int display;3    char text[TERMWIDTH], longblank[]=MSG_LONGBLANK;     $DESCRIPTOR(text_d, text); #    $DESCRIPTOR(blank_d, longblank);     static init_counter;           text_d.dsc$a_pointer=message;'    text_d.dsc$w_length=strlen(message);     if (! init_counter++){        row = 1; col = TERMWIDTH; @       status = SMG$CREATE_VIRTUAL_DISPLAY(&row, &col, &display);)       echeck(status, __LINE__, __FILE__);     }    row = 1; col = 1;:    status = SMG$PUT_CHARS(&display, &blank_d, &row, &col);&    echeck(status, __LINE__, __FILE__);0    row = 1; col = (TERMWIDTH-strlen(message))/2;9    status = SMG$PUT_CHARS(&display, &text_d, &row, &col); &    echeck(status, __LINE__, __FILE__);    row = term_l; col = 2; I    status = SMG$PASTE_VIRTUAL_DISPLAY(&display, &cont_paste, &row, &col); &    echeck(status, __LINE__, __FILE__); }   ) /* text can't be longer than TERMWIDTH */  void make_menu_bar(char text[])  { 4    long int row, col, rend_mask=SMG$M_REVERSE, i, j;$    static unsigned long int display;    char bar[TERMWIDTH];     $DESCRIPTOR(bar_d, bar);     static init_counter;   +    for(i=0; i<TERMWIDTH-1; bar[i++] = ' ');     bar[TERMWIDTH-1] = '\0'; O    for(i=(TERMWIDTH-strlen(text))/2, j=0; text[j] != '\0'; bar[i++]=text[j++]);     if (! init_counter++){        row = 1; col = TERMWIDTH; @       status = SMG$CREATE_VIRTUAL_DISPLAY(&row, &col, &display);)       echeck(status, __LINE__, __FILE__);     }    bar_d.dsc$a_pointer=bar; "    bar_d.dsc$w_length=strlen(bar);:    status = SMG$PUT_LINE(&display, &bar_d, 0, &rend_mask);&    echeck(status, __LINE__, __FILE__);    row = term_l-1; col = 2; I    status = SMG$PASTE_VIRTUAL_DISPLAY(&display, &cont_paste, &row, &col); &    echeck(status, __LINE__, __FILE__); }   # void make_column_title(char text[])  { 7    long int row, col, line_adv=1, rend_mask=SMG$M_BOLD; $    static unsigned long int display;    $DESCRIPTOR(text_d, text);     static init_counter;   $    text_d.dsc$w_length=strlen(text);    text_d.dsc$a_pointer=text;     if (! init_counter++){ !       row = 1; col = TERMWIDTH-1; @       status = SMG$CREATE_VIRTUAL_DISPLAY(&row, &col, &display);)       echeck(status, __LINE__, __FILE__);     }C    status = SMG$PUT_LINE(&display, &text_d, &line_adv, &rend_mask); &    echeck(status, __LINE__, __FILE__);    row = 5; col = 2;I    status = SMG$PASTE_VIRTUAL_DISPLAY(&display, &cont_paste, &row, &col);  }    void show_broadcast(void)  { @    long int row, col, rend_mask=SMG$M_BOLD, attrib=SMG$M_BORDER;7    unsigned short int text_len, c = SMG$K_TRM_TIMEOUT;  &    static unsigned long int display;  <    char text[BROADCAST_LENGTH], head[]=MSG_BROADCAST_HEADER;    $DESCRIPTOR(text_d, text);     $DESCRIPTOR(head_d, head);     static int init_counter;       if (! init_counter++){ /      row = BROADCAST_WINDOW; col = TERMWIDTH-1; H      status = SMG$CREATE_VIRTUAL_DISPLAY(&row, &col, &display, &attrib);(      echeck(status, __LINE__, __FILE__);?      row = 1; col = (TERMWIDTH-strlen(MSG_BROADCAST_HEADER))/2; J      status = SMG$PUT_CHARS(&display, &head_d, &row, &col, 0, &rend_mask);(      echeck(status, __LINE__, __FILE__);    }#    make_message_line(MSG_CONTINUE); #    while (c == SMG$K_TRM_TIMEOUT){  I      status = SMG$GET_BROADCAST_MESSAGE(&cont_paste, &text_d, &text_len); #      if (status != SMG$_NO_MORMSG){         row=3; col=1;8        status = SMG$ERASE_DISPLAY(&display, &row, &col);*        echeck(status, __LINE__, __FILE__);        text[text_len] = '\0'; K        status = SMG$PUT_LINE(&display, &text_d, 0, 0, 0, &SMG$M_WRAP_WORD); *        echeck(status, __LINE__, __FILE__);        row = 5; col = 2;M        status = SMG$PASTE_VIRTUAL_DISPLAY(&display, &cont_paste, &row, &col); *        echeck(status, __LINE__, __FILE__);      }      c = read_key(1);     }$    make_message_line(MSG_LONGBLANK);?    status = SMG$UNPASTE_VIRTUAL_DISPLAY(&display, &cont_paste); &    echeck(status, __LINE__, __FILE__);    new_broadcast = FALSE;  }    void trap_broadcast(void)  {     new_broadcast = TRUE; }    void create_screen(void) {     long row, col;   &    row = DISPLEN-1; col = TERMWIDTH-1;B    status = SMG$CREATE_VIRTUAL_DISPLAY(&row, &col, &cont_display);&    echeck(status, __LINE__, __FILE__);W    status = SMG$CREATE_VIEWPORT(&cont_display, &row_view, &col_view, &view_l, &view_w); &    echeck(status, __LINE__, __FILE__);;    status = SMG$CREATE_PASTEBOARD(&cont_paste, 0, &term_l);     if (term_l < TERM_MIN){      fake_error(2);     }    view_l = term_l - 9; &    echeck(status, __LINE__, __FILE__);3    status = SMG$CREATE_VIRTUAL_KEYBOARD(&keyboard); &    echeck(status, __LINE__, __FILE__);E    status = SMG$SET_BROADCAST_TRAPPING(&cont_paste, &trap_broadcast); &    echeck(status, __LINE__, __FILE__);    cursor_off(); }    void paste_to_screen(void) {     long row, col;       row = 7; col = 2;N    status = SMG$PASTE_VIRTUAL_DISPLAY(&cont_display, &cont_paste, &row, &col);&    echeck(status, __LINE__, __FILE__); }    void show_help(void) { @    long int row, col, rend_mask=SMG$M_BOLD, attrib=SMG$M_BORDER;=    unsigned short int help_size, c = SMG$K_TRM_TIMEOUT, i=0;  &    static unsigned long int display;  >    char line [LINELEN], text[LINELEN], head[]=MSG_HELP_HEADER;    $DESCRIPTOR(text_d, text);     $DESCRIPTOR(head_d, head);     static int init_counter;     char *help[][3] = { 	{"?", "Help", "Help"}, (         {"<SPACE>", "Update", "Update"},-         {"Ctrl-A", "Start", "Release After"},  	{"Ctrl-B", "Up", "Up"}, 	{"Ctrl-D", "Pause", "Delete"},  	{"Ctrl-F", "Down", "Down"}, 	{"Ctrl-H", "Stop", "Hold"},%         {"Ctrl-J", "---", "Requeue"}, ' 	{"Ctrl-K", "Type Select", "No After"}, ( 	{"Ctrl-M, <RETURN>", "Select", "Menu"},5 	{"Ctrl-N, Next Scr.", "Next Screen", "Next Screen"}, E         {"Ctrl-P, Prev. Scr.", "Previous Screen", "Previous Screen"},   	{"Ctrl-R", "Reset", "No Hold"},* 	{"Ctrl-V", "VQM Version", "VQM Version"}," 	{"Ctrl-W", "Refresh", "Refresh"},  	{"Ctrl-Z, F10", "Exit", "Exit"}    };       if (! init_counter++){ 1      help_size = sizeof(help)/(3*sizeof(char *)); ,      row = help_size + 2; col = TERMWIDTH-1;H      status = SMG$CREATE_VIRTUAL_DISPLAY(&row, &col, &display, &attrib);(      echeck(status, __LINE__, __FILE__);      row = 1; col = 28; J      status = SMG$PUT_CHARS(&display, &head_d, &row, &col, 0, &rend_mask);(      echeck(status, __LINE__, __FILE__);      row = 3;  col = 3;       while (i < help_size){  	make_help_line(line, help, i); )         text_d.dsc$w_length=strlen(line); #         text_d.dsc$a_pointer=line;  >         status = SMG$PUT_CHARS(&display, &text_d, &row, &col);+         echeck(status, __LINE__, __FILE__);          i++;         row++;	      }        }#    make_message_line(MSG_CONTINUE);     row = 5; col = 2;I    status = SMG$PASTE_VIRTUAL_DISPLAY(&display, &cont_paste, &row, &col); &    echeck(status, __LINE__, __FILE__);:    c = read_key(FALSE);                   /* no timeout */$    make_message_line(MSG_LONGBLANK);?    status = SMG$UNPASTE_VIRTUAL_DISPLAY(&display, &cont_paste); &    echeck(status, __LINE__, __FILE__); }   ' int input_select_loop(int type_flags[])  {    int c, type;  *   c = read_key(FALSE);    /* no timeout */   switch(c){      case 'b':        type = 0;
        break;       case 'p':        type = 1;
        break;       case 's':        type = 2;
        break;       case 't':        type = 3;
        break;       case 'g':        type = 4;
        break; 
      default:         type = 5;
        break;    }    if (type != 5){      if (type_flags[type]){        type_flags[type] = 0;     } else {        type_flags[type] = 1;     }    }    return c;  }    void select_queue_type(void) { 5    long int row, col, rend_mask, attrib=SMG$M_BORDER; %    unsigned short int i=0, type_size; $    static unsigned long int display;    char text[TERMWIDTH];    $DESCRIPTOR(text_d, text);     static init_counter; F    char *type[]={"Batch", "Printer", "Server", "Terminal", "Generic"};+    char *ftype[]={"B", "P", "S", "T", "G"}; ,    int type_flags[5], c = SMG$K_TRM_TIMEOUT;  -    type_size = sizeof(type)/(sizeof(char *)); ,    for(i=0; i<type_size; type_flags[i++]=0);    if (! init_counter++){ '       row = type_size; col = TYPEWIDTH; I       status = SMG$CREATE_VIRTUAL_DISPLAY(&row, &col, &display, &attrib); )       echeck(status, __LINE__, __FILE__);        row = 1; col = 2; *       for(i=0; i < type_size; i++, row++){,         text_d.dsc$w_length=strlen(type[i]);&         text_d.dsc$a_pointer=type[i]; >         status = SMG$PUT_CHARS(&display, &text_d, &row, &col);+         echeck(status, __LINE__, __FILE__); 
       }       }&    make_message_line(MSG_TYPE_SELECT);     raise_type_flags(type_flags);    while (c != SMG$K_TRM_CR){       col = 2; row = 1;)      for(i=0; i < type_size; i++, row++){         if (type_flags[i]){           rend_mask = SMG$M_BOLD;        } else {           rend_mask = 0;         },        text_d.dsc$w_length=strlen(ftype[i]);&        text_d.dsc$a_pointer=ftype[i]; L        status = SMG$PUT_CHARS(&display, &text_d, &row, &col, 0, &rend_mask);*        echeck(status, __LINE__, __FILE__);      }  ,      col = (TERMWIDTH-TYPEWIDTH)/2; row = 8;K      status = SMG$PASTE_VIRTUAL_DISPLAY(&display, &cont_paste, &row, &col); (      echeck(status, __LINE__, __FILE__);'      c = input_select_loop(type_flags);     }    raise_flags(type_flags); ?    status = SMG$UNPASTE_VIRTUAL_DISPLAY(&display, &cont_paste); &    echeck(status, __LINE__, __FILE__);$    make_message_line(MSG_LONGBLANK); } 