 /*         Visual Queue Manager4       Copyright (C) 1992-1993 by Brandeis University       Author: Vadim Gorokhovsky        Created: v1.0 Summer 1992 +       Revised: v2.0, v2.1, v2.2 Spring 1993        Revised: v3.0 Summer 1993        Revised: v3.1 Autumn 1993        File: vqm.c   G       You are given permission to distribute and/or modify this program J       under the terms of the GNU general license as long as this copyright?       notice is retained.  See README.DOC for more information.  */   #include "vqm.h"  > int entry_num, marker=1, marker_direct=FALSE, scroll_point=1, @     confirm_flag=FALSE, que_type, new_broadcast=FALSE, status;   char device[QUELEN]; Vertex current_node;E long int row_view=1, col_view=1, view_l, view_w=TERMWIDTH-1, term_l,        que_search_flags;5 unsigned long int cont_display, cont_paste, keyboard;    main() {    int mode;      mode = get_command_line();   create_screen();   while(mode != END){      switch(mode){ ,        case JOB:  mode=manage_jobs(); break;.        case QUE:  mode=manage_queues(); break;     }    } 
   clean_up();  }   - void echeck(int status, int line, char *file)  { D    if (! (status & SS$_NORMAL)){                                           delete_screen();K       fprintf(stderr, "\nVQM failure\n");                                   N       fprintf(stderr, "Error status %d in line %d\n", status, line);          D       fprintf(stderr, "File %s\n", file);                                  lib$signal(status); K       fprintf(stderr, "Please contact the author with the above info.\n");         exit(EXIT_FAILURE); K    }                                                                         }   " void raise_flags(int type_flags[]) {     que_search_flags = 0;    if (type_flags[0]){  ,      que_search_flags |= QUI$M_SEARCH_BATCH;    }      if (type_flags[1]){.      que_search_flags |= QUI$M_SEARCH_PRINTER;    }    if (type_flags[2]){-      que_search_flags |= QUI$M_SEARCH_SERVER;     }    if (type_flags[3]){/      que_search_flags |= QUI$M_SEARCH_TERMINAL;     }    if (type_flags[4]){.      que_search_flags |= QUI$M_SEARCH_GENERIC;    } }   ' void raise_type_flags(int type_flags[])  { 5    if ((que_search_flags & QUI$M_SEARCH_BATCH) != 0){       type_flags[0] = TRUE;    }8    if ((que_search_flags & QUI$M_SEARCH_PRINTER) != 0) {      type_flags[1] = TRUE;    }7    if ((que_search_flags & QUI$M_SEARCH_SERVER) != 0) {       type_flags[2] = TRUE;    }9    if ((que_search_flags & QUI$M_SEARCH_TERMINAL) != 0) {       type_flags[3] = TRUE;    }8    if ((que_search_flags & QUI$M_SEARCH_GENERIC) != 0) {      type_flags[4] = TRUE;    } }   8 /* get a device name using Command Definition Utility */ int get_command_line(void) {    int que_flags[5], i;   unsigned short int length;   $DESCRIPTOR(p1,"device");     $DESCRIPTOR(device_d, device);#   $DESCRIPTOR(confirm_d,"CONFIRM"); %   $DESCRIPTOR(batch_d, "TYPE.BATCH"); )   $DESCRIPTOR(printer_d, "TYPE.PRINTER"); +   $DESCRIPTOR(terminal_d, "TYPE.TERMINAL"); '   $DESCRIPTOR(server_d, "TYPE.SERVER"); )   $DESCRIPTOR(generic_d, "TYPE.GENERIC");   &   for(i=0; i < 5; que_flags[i++] = 0);#   status = CLI$PRESENT(&confirm_d);    if (status == CLI$_PRESENT){     confirm_flag = TRUE;   } !   status = CLI$PRESENT(&batch_d); :   if (status == CLI$_PRESENT || status == CLI$_DEFAULTED){     que_flags[0] = TRUE;   } #   status = CLI$PRESENT(&printer_d); :   if (status == CLI$_PRESENT || status == CLI$_DEFAULTED){     que_flags[1] = TRUE;   } "   status = CLI$PRESENT(&server_d);:   if (status == CLI$_PRESENT || status == CLI$_DEFAULTED){     que_flags[2] = TRUE;   } $   status = CLI$PRESENT(&terminal_d);:   if (status == CLI$_PRESENT || status == CLI$_DEFAULTED){     que_flags[3] = TRUE;   } /   if (CLI$PRESENT(&generic_d) == CLI$_PRESENT){      que_flags[4] = TRUE;   }    raise_flags(que_flags); H   if (CLI$GET_VALUE(&p1, &device_d, &length) == CLI$_ABSENT) return QUE;   device[length]='\0';
   return JOB;  }    int fill_queue_list(Header que)  { 8   static char que_name[QUELEN], search_name[QUELEN]="*";
   int n=0;6   static long int search_flags, que_status, que_flags;!   static ilist3_t itemlist0[] = { E                         {QUELEN-1, QUI$_SEARCH_NAME, search_name, 0}, @ 			{sizeof(search_flags), QUI$_SEARCH_FLAGS, &search_flags, 0}, , 			{QUELEN-1, QUI$_QUEUE_NAME, que_name, 0},; 			{sizeof(que_status), QUI$_QUEUE_STATUS, &que_status, 0}, 8 			{sizeof(que_flags), QUI$_QUEUE_FLAGS, &que_flags, 0},%                         {0, 0, 0, 0},                          };  !   static iosb_t iosb = {0, 0, 0};   "   search_flags = que_search_flags;D   status = SYS$GETQUIW(0, QUI$_CANCEL_OPERATION, 0, 0, &iosb, 0, 0);%   echeck(status, __LINE__, __FILE__); 4   while ((iosb.status | 0x00040000) == JBC$_NORMAL){K     status = SYS$GETQUIW(0, QUI$_DISPLAY_QUEUE, 0, itemlist0, &iosb, 0, 0); '     echeck(status, __LINE__, __FILE__); 3     if ((iosb.status | 0x00040000) == JBC$_NORMAL){ 
          n++;           if (n >= DISPLEN){             fake_error(3); 
          }D          fill_list(que, que_name, NIL, que_flags, que_status, 0, 0);     }    }    return n;  }     int confirm(char message_text[]) {    char text[LINELEN];    int cmp_len;  "   make_message_line(message_text);   read_string(text);#   make_message_line(MSG_LONGBLANK);    uppercase_string(text); -   if ((cmp_len=strlen(text)) <= 0) cmp_len=1; '   if (! strncmp(text, "YES", cmp_len)){       return TRUE;   
   } else {      return FALSE;   }  }   , int fill_job_list(Header job, long *qstatus) { F   static char que_name[QUELEN], job_name[JOBLEN], search_name[QUELEN], 	      username[USRNAM];   int n=0, ratio; 9   static long int search_flags0 = 0, search_flags1 = 0,   B 	      entry_num, comp_blocks, total_size, job_status, que_status, 	      que_flags; ,   static unsigned short int search_name_len;!   static ilist3_t itemlist0[] = { E                         {QUELEN-1, QUI$_SEARCH_NAME, search_name, 0}, B 			{sizeof(search_flags0), QUI$_SEARCH_FLAGS, &search_flags0, 0}, , 			{QUELEN-1, QUI$_QUEUE_NAME, que_name, 0},; 			{sizeof(que_status), QUI$_QUEUE_STATUS, &que_status, 0}, 8 			{sizeof(que_flags), QUI$_QUEUE_FLAGS, &que_flags, 0},%                         {0, 0, 0, 0},                          };  !   static ilist3_t itemlist1[] = { Y                         {sizeof(search_flags1), QUI$_SEARCH_FLAGS, &search_flags1, 0},    B                         {JOBLEN-1, QUI$_JOB_NAME, job_name, 0},   ?                         {USRNAM-1, QUI$_USERNAME, username, 0}, N                         {sizeof(entry_num), QUI$_ENTRY_NUMBER, &entry_num, 0},A 			{sizeof(comp_blocks), QUI$_COMPLETED_BLOCKS, &comp_blocks, 0}, L                         {sizeof(total_size), QUI$_JOB_SIZE, &total_size, 0},9 			{sizeof(job_status), QUI$_JOB_STATUS, &job_status, 0}, $                         {0, 0, 0, 0}                         };!   static iosb_t iosb = {0, 0, 0};   (   search_flags0 = QUI$M_SEARCH_WILDCARD;B   search_flags1 = (QUI$M_SEARCH_WILDCARD | QUI$M_SEARCH_ALL_JOBS);   strcpy(search_name, device);'   itemlist0[0].len=strlen(search_name); D   status = SYS$GETQUIW(0, QUI$_CANCEL_OPERATION, 0, 0, &iosb, 0, 0);%   echeck(status, __LINE__, __FILE__); I   status = SYS$GETQUIW(0, QUI$_DISPLAY_QUEUE, 0, itemlist0, &iosb, 0, 0); %   echeck(status, __LINE__, __FILE__); 1   if ((iosb.status | 0x00040000) != JBC$_NORMAL){       fake_error(1);    }    strcpy(device, que_name); '   que_type=decode_que_flags(que_flags); 4   while ((iosb.status | 0x00040000) == JBC$_NORMAL){I     status = SYS$GETQUIW(0, QUI$_DISPLAY_JOB, 0, itemlist1, &iosb, 0, 0); '     echeck(status, __LINE__, __FILE__); 3     if ((iosb.status | 0x00040000) == JBC$_NORMAL){         n++;         if (n >= DISPLEN){           fake_error(3);         }@        ratio = (total_size==0 ? 0 : comp_blocks*100/total_size);I        fill_list(job, job_name, username, total_size, ratio, job_status,                    entry_num);      }    }    *qstatus=que_status;     return n; }	  & void update_one_queue(Vertex que_node) { 4   static char que_name[QUELEN], search_name[QUELEN];
   int n=0;:   static long int search_flags = 0, que_status, que_flags;!   static ilist3_t itemlist0[] = { E                         {QUELEN-1, QUI$_SEARCH_NAME, search_name, 0}, , 			{QUELEN-1, QUI$_QUEUE_NAME, que_name, 0},; 			{sizeof(que_status), QUI$_QUEUE_STATUS, &que_status, 0}, 8 			{sizeof(que_flags), QUI$_QUEUE_FLAGS, &que_flags, 0},%                         {0, 0, 0, 0},                          };  !   static iosb_t iosb = {0, 0, 0};   +   strcpy(search_name, que_node->str_data1); D   status = SYS$GETQUIW(0, QUI$_CANCEL_OPERATION, 0, 0, &iosb, 0, 0);%   echeck(status, __LINE__, __FILE__); I   status = SYS$GETQUIW(0, QUI$_DISPLAY_QUEUE, 0, itemlist0, &iosb, 0, 0); %   echeck(status, __LINE__, __FILE__); 1   if ((iosb.status | 0x00040000) == JBC$_NORMAL){ $     que_node->num_data1 = que_flags;%     que_node->num_data2 = que_status;    }  }    void screen_init(void) { "    row_view=marker=scroll_point=1; }    void screen_up(void) {     marker--; scroll_point--; }    void screen_down(void) {     marker++; scroll_point++; }   < int update_time(time_t *previous_time, time_t *current_time) {     int time_diff;       time(current_time);=    time_diff = (int) difftime(*current_time, *previous_time); &    if (time_diff >= DEFAULT_INTERVAL){       return TRUE;    } else {        return FALSE;     } }   % /* return TRUE if ok, FALSE if not */  int check_bounds(int n)  {    int return_status=TRUE;      if (n==0)       return FALSE;K   if ((n >= marker) && (scroll_point > view_l) && (marker_direct == DOWN)){       change_view(++row_view);       scroll_point--;   }   D   if ((scroll_point < 1) && (marker >= 1) && (marker_direct == UP)){      change_view(--row_view);       scroll_point++;   }      if (marker < 1){      marker++;      scroll_point++;$      make_message_line(MSG_NOABOVE);      return_status=FALSE;    }    if (n < marker){      marker--;      scroll_point--;$      make_message_line(MSG_NOBELOW);      return_status=FALSE;    }    return return_status;  }   0 void check_update_bounds(Header list, int total) { 
   int change;   N   if ((marker <= 0) && (total > 0)){  /* protective -- marker can't be <= 0 */      screen_init();    } N   if (total < marker){                /* if number of entries < current pos */9      change=marker-total;             /* cacl the diff */ E      marker=total;                    /* move marker to the bottom */ O      if (scroll_point - change <= 0){ /* if change not within current window */ H         if (marker-view_l < 1){       /* if top of list within view_l */;            row_view=1;                /* reset view port */ H            scroll_point=marker;       /* reset scroll_point to marker */D         }else{                        /* if top not within view_l */N            row_view=marker-view_l+1;  /* set marker at bottom of view port */ P            scroll_point = view_l;     /* set scroll_point at bottom of window */	         } K      }else{                           /* if change within current window */ K         scroll_point-=change;         /* move scroll_point up the change */       }      change_view(row_view);    } O   current_node = move_forward(list->first, marker-1);  /* reset current node */  }    void queue_screen_draw(void) {      make_menu_bar(MSG_MENU_2);!     make_header(MSG_MAIN_HEADER);      make_column(QUE);      reset_viewport();  }   6 void update_queue_list(Header que, int *total_queues)  { $   make_message_line(MSG_UPDATE_QUE);$   destroy(que); que=create_header();   if (que_search_flags) { '     *total_queues=fill_queue_list(que); 
   } else {     *total_queues = 0;   } *   check_update_bounds(que, *total_queues);.   make_message_line(MSG_LONGBLANK);           %   display_list(que, make_queue_line);  }    int manage_queues(void)  { N     static int init_counter, total_queues, save_marker, save_scroll, save_row;
     int c;     char que_name[QUELEN];     static Header que;     static Vertex save_current;        queue_screen_draw();     if(! init_counter++){ '        make_message_line(MSG_LOAD_QUE);         que=create_header();         if (que_search_flags){ +          total_queues=fill_queue_list(que);         } else {           total_queues=0;        }        screen_init(); ,        save_current=current_node=que->first;         save_scroll=scroll_point;        save_row=row_view;         save_marker=marker;     }      current_node=save_current;     marker=save_marker;      scroll_point=save_scroll;      row_view=save_row;     change_view(row_view);%     make_message_line(MSG_LONGBLANK);      move_cursor_home(); )     display_list(que, make_queue_line);   
     while(1){        if (new_broadcast){          show_broadcast();        } !       if (current_node != NULL){  0         strcpy(device, current_node->str_data1);       } <       c = read_key(TRUE);                 /* with timeout */       switch (c){ &          case SMG$K_TRM_QUESTION_MARK: 	    show_help();  	    break; 6          case SMG$K_TRM_CTRLA:		/* ctrl-h start que */?             if (total_queues != 0 && control_queue(QUE_START)){ /                 update_one_queue(current_node); ; 		output_info(marker, current_node, make_queue_line, TRUE); 
             }              break;5          case SMG$K_TRM_CTRLH:		/* ctrl-h stop que */ >             if (total_queues != 0 && control_queue(QUE_STOP)){/                 update_one_queue(current_node); ; 		output_info(marker, current_node, make_queue_line, TRUE); 
             }              break;6          case SMG$K_TRM_CTRLR:		/* ctrl-r reset que */?             if (total_queues != 0 && control_queue(QUE_RESET)){ /                 update_one_queue(current_node); ; 		output_info(marker, current_node, make_queue_line, TRUE); 
             }              break;6          case SMG$K_TRM_CTRLD:		/* ctrl-h pause que */?             if (total_queues != 0 && control_queue(QUE_PAUSE)){ /                 update_one_queue(current_node); ; 		output_info(marker, current_node, make_queue_line, TRUE); 
             }              break;D          case SMG$K_TRM_CTRLM:                   /* ctrl-m select */#             if (total_queues != 0){                erase_screen(); (               save_current=current_node;'               save_scroll=scroll_point;                 save_row=row_view;!               save_marker=marker;    	      return JOB;
             }  	    break; F 	 case SMG$K_TRM_CTRLW:                          /* ctrl-w refresh */ $             refresh_screen(); break;          case SMG$K_TRM_F10:G 	 case SMG$K_TRM_CTRLZ:                            /* control-Z exit */ &              destroy(que); return END;N          case SMG$K_TRM_SPACE:                         /* update queue list */2             update_queue_list(que, &total_queues);             break;          case SMG$K_TRM_CTRLK:              select_queue_type();2             update_queue_list(que, &total_queues);             break;>          case SMG$K_TRM_CTRLB:		    /* enable ctrl-b for up */          case SMG$K_TRM_UP: # 	    marker_direct=UP; screen_up(); ' 	    make_message_line(MSG_LONGBLANK);  4             if (check_bounds(total_queues) == TRUE){5                change_highlight(UP, make_queue_line); 
             }  	    break; N          case SMG$K_TRM_CTRLF:                    /* enable ctrl-f for down */          case SMG$K_TRM_DOWN: .             marker_direct=DOWN; screen_down();-             make_message_line(MSG_LONGBLANK); 4             if (check_bounds(total_queues) == TRUE){7                change_highlight(DOWN, make_queue_line); 
             }  	    break; P          case SMG$K_TRM_CTRLN:                   /* enable ctlr-n for pg down */$          case SMG$K_TRM_NEXT_SCREEN:-             make_message_line(MSG_LONGBLANK); ?             move_page_down(total_queues, que, make_queue_line);              break;N          case SMG$K_TRM_CTRLP:                   /* enable ctrl-p for pg up */$          case SMG$K_TRM_PREV_SCREEN:-             make_message_line(MSG_LONGBLANK); =             move_page_up(total_queues, que, make_queue_line);              break;          case SMG$K_TRM_CTRLV:&   	    make_message_line(MSG_VERSION); 	    break;9       }y1       if ((c>=97 && c<=122) || (c>=65 && c<=90)){k*          make_message_line(MSG_LONGBLANK);.          search_char(que, c, make_queue_line);       }.     }r }9   int manage_jobs(void)u {n     int total_jobs, c;     long int que_status;     Header job;t(     clock_t current_time, previous_time;  $     make_message_line(MSG_LOAD_JOB);     job=create_header();/     total_jobs=fill_job_list(job, &que_status);      current_node=job->first;     screen_init();     reset_viewport();r(     job_screen_draw(device, que_status);%     display_list(job, make_job_line);s%     make_message_line(MSG_LONGBLANK);;     if (current_node != NULL){)        entry_num=current_node->num_data4;M     } else {        entry_num=0;_     }      time(&previous_time);l
     while(1){         if (new_broadcast){          show_broadcast();        }7        if (update_time(&previous_time, &current_time)){t9           update_job_list(job, &que_status, &total_jobs); %           previous_time=current_time;r        }G        c = read_key(TRUE);                           /* with timeout */i        switch (c){  &          case SMG$K_TRM_QUESTION_MARK: 	    show_help();  	    break;rO           case SMG$K_TRM_CTRLD:                             /* ctrl-d delete */ -             make_message_line(MSG_LONGBLANK);iG             if (total_jobs != 0 && control_job(JOB_DELETE, entry_num)){l>                update_job_list(job, &que_status, &total_jobs);$                time(&previous_time);
             }              break;N           case SMG$K_TRM_CTRLH:                            /* ctrl-h hold   */-             make_message_line(MSG_LONGBLANK);sE             if (total_jobs != 0 && control_job(JOB_HOLD, entry_num)){{>                update_job_list(job, &que_status, &total_jobs);$                time(&previous_time);
             }C             break;;           case SMG$K_TRM_CTRLM:			     /* ctrl-m menu    */E)             destroy(job); erase_screen();q             return QUE;SN           case SMG$K_TRM_CTRLR:                           /* ctrl-r release */-             make_message_line(MSG_LONGBLANK);gH             if (total_jobs != 0 && control_job(JOB_RELEASE, entry_num)){>                update_job_list(job, &que_status, &total_jobs);$                time(&previous_time);
             }]             break;;           case SMG$K_TRM_CTRLJ:		/* ctrl-j requeue a job */p-             make_message_line(MSG_LONGBLANK);aH             if (total_jobs != 0 && control_job(JOB_REQUEUE, entry_num)){>                update_job_list(job, &que_status, &total_jobs);$                time(&previous_time);
             }u             break;3           case SMG$K_TRM_CTRLA:		/* ctrl-a after */ -             make_message_line(MSG_LONGBLANK); F             if (total_jobs != 0 && control_job(JOB_AFTER, entry_num)){>                update_job_list(job, &que_status, &total_jobs);$                time(&previous_time);
             }D             break;6           case SMG$K_TRM_CTRLK:		/* ctrl-a no after */-             make_message_line(MSG_LONGBLANK);)I             if (total_jobs != 0 && control_job(JOB_NO_AFTER, entry_num)){r>                update_job_list(job, &que_status, &total_jobs);$                time(&previous_time);
             }t             break;N           case SMG$K_TRM_CTRLW:                          /* ctrl-w refresh */ $             refresh_screen(); break;           case SMG$K_TRM_F10:FG  	  case SMG$K_TRM_CTRLZ:                          /* control-Z exit */d%             destroy(job); return END;tM           case SMG$K_TRM_SPACE:                          /* space - update */&;             update_job_list(job, &que_status, &total_jobs);D!             time(&previous_time);;-             make_message_line(MSG_LONGBLANK);R             break;5           case SMG$K_TRM_CTRLB:			/* ctrl-b for up */(           case SMG$K_TRM_UP:# 	    marker_direct=UP; screen_up(); -             make_message_line(MSG_LONGBLANK);n2             if (check_bounds(total_jobs) == TRUE){3                change_highlight(UP, make_job_line); 
             }n 	    break;s7           case SMG$K_TRM_CTRLF:			/* ctrl-f for down */            case SMG$K_TRM_DOWN:,      	    marker_direct=DOWN; screen_down();-             make_message_line(MSG_LONGBLANK);r2             if (check_bounds(total_jobs) == TRUE){. 	       change_highlight(DOWN, make_job_line);
             }s 	    break;iN           case SMG$K_TRM_CTRLN:                /* enable ctlr-n for pg down */%           case SMG$K_TRM_NEXT_SCREEN: -             make_message_line(MSG_LONGBLANK);h;             move_page_down(total_jobs, job, make_job_line);N             break;O           case SMG$K_TRM_CTRLP:                   /* enable ctrl-p for pg up */x%           case SMG$K_TRM_PREV_SCREEN:=-             make_message_line(MSG_LONGBLANK);09             move_page_up(total_jobs, job, make_job_line);              break;           case SMG$K_TRM_CTRLV: &   	    make_message_line(MSG_VERSION); 	    break;         }!        if (current_node != NULL){_,           entry_num=current_node->num_data4;        } else {            entry_num=0;        }     }r }s    void uppercase_string(char *str) {                        while (*str=toupper(*str))
        str++;r }(   void decode_message(int id)_ {G&   unsigned long int msgid=id, flags=0;   unsigned int msglen;   char text[MESSAGE_LENGTH];   $DESCRIPTOR(text_d, text);  =   flags |= 1;                                 /* text only */ 9   status = sys$getmsg(msgid, &msglen, &text_d, flags, 0);t%   echeck(status, __LINE__, __FILE__);EH   text[0]=toupper(text[0]);                   /* up-case first letter */   text[msglen]='\0';   make_message_line(text); }    % int control_job(int code, long entry)z {j   static long int entry_num;H   static char que_name[QUELEN], target_que[QUELEN], after_time[LINELEN];!   static unsigned long i_time[2]; )   static $DESCRIPTOR(time_d, after_time);c    static ilist3_t itemlist[] = {<                         {QUELEN-1, SJC$_QUEUE, que_name, 0},: 			{sizeof(entry_num), SJC$_ENTRY_NUMBER, &entry_num, 0},  			{0, 0, 0, 0}, _%                         {0, 0, 0, 0},I%                         {0, 0, 0, 0},                          };  !   static iosb_t iosb = {0, 0, 0};t   static short int func;   int c;  3   func = SJC$_ALTER_JOB;              /* default */_   entry_num = entry;   strcpy(que_name, device); #   itemlist[0].len=strlen(que_name);e   itemlist[2].len = 0;   itemlist[2].buffer = 0;    itemlist[2].code = 0;    itemlist[3].len = 0;   itemlist[3].buffer = 0;Y   itemlist[3].code = 0;    switch(code){l   case JOB_HOLD:	E 	itemlist[2].code=SJC$_HOLD; 	break;    case JOB_RELEASE:	  	itemlist[2].code=SJC$_NO_HOLD;  	break;,   case JOB_NO_AFTER:	)& 	itemlist[2].code=SJC$_NO_AFTER_TIME;  	break;    case JOB_AFTER:0 	make_message_line(MSG_TIME);; 	c = read_string(after_time); 4 	if (c == SMG$K_TRM_CTRLZ || after_time[0] == '\0'){$ 	  make_message_line(MSG_LONGBLANK);    	  return FALSE;S   	} 	uppercase_string(after_time);( 	time_d.dsc$w_length=strlen(after_time);' 	status = sys$bintim(&time_d, &i_time);T 	if (status == SS$_IVTIME){c# 	  make_message_line(MSG_INV_TIME);  	  return FALSE;   	})         itemlist[2].len = sizeof(i_time); 7 	itemlist[2].code = SJC$_AFTER_TIME;  /* put on wait */.%         itemlist[2].buffer = &i_time; 7 	itemlist[3].code = SJC$_NO_HOLD;     /* and release */  	break;e   case JOB_REQUEUE:_$ 	make_message_line(MSG_DESTINATION); 	c = read_string(target_que);t4 	if (c == SMG$K_TRM_CTRLZ || target_que[0] == '\0'){$ 	  make_message_line(MSG_LONGBLANK);    	  return FALSE;    	})   	if (strlen(target_que) > QUELEN-1){    .        	  make_message_line(MSG_INV_DEST_QUE);      	  return FALSE;    	}& 	itemlist[2].len = strlen(target_que);2         itemlist[2].code = SJC$_DESTINATION_QUEUE;(         itemlist[2].buffer = target_que;         break;   case JOB_DELETE: 	if (confirm_flag == TRUE){=' 	  if (! confirm(MSG_CONFIRM_DEL_JOB)){d& 	    make_message_line(MSG_NO_DELETE); 	    return FALSE;	      	  }r   	}         func = SJC$_DELETE_JOB;l         break;   }=;   status = SYS$SNDJBCW(0, func, 0, &itemlist, &iosb, 0, 0); %   echeck(status, __LINE__, __FILE__);I1   if ((iosb.status | 0x00040000) == JBC$_NORMAL){$&      make_message_line(MSG_LONGBLANK);      return TRUE;E   }A+   decode_message(iosb.status | 0x00040000);,   return FALSE;, }u   int control_queue(int mode)  { 
   char *mess;    static char que_name[QUELEN];     static ilist3_t itemlist[] = {<                         {QUELEN-1, SJC$_QUEUE, que_name, 0},%                         {0, 0, 0, 0},,                         };  !   static iosb_t iosb = {0, 0, 0};=   static short int func;      switch(mode){0P     case QUE_STOP:   func = SJC$_STOP_QUEUE; mess = MSG_CONFIRM_STOP_QUE; break;R     case QUE_START:  func = SJC$_START_QUEUE; mess = MSG_CONFIRM_START_QUE; break;R     case QUE_PAUSE:  func = SJC$_PAUSE_QUEUE; mess = MSG_CONFIRM_PAUSE_QUE; break;R     case QUE_RESET:  func = SJC$_RESET_QUEUE; mess = MSG_CONFIRM_RESET_QUE; break;     default: 	     break;    }e   if (confirm_flag == TRUE){      if (! confirm(mess)){'         make_message_line(MSG_NO_OPER);t         return FALSE;(      }   };   strcpy(que_name, device);m#   itemlist[0].len=strlen(que_name); ;   status = SYS$SNDJBCW(0, func, 0, &itemlist, &iosb, 0, 0);}%   echeck(status, __LINE__, __FILE__); 1   if ((iosb.status | 0x00040000) == JBC$_NORMAL){c&      make_message_line(MSG_LONGBLANK);      return TRUE;=   } +   decode_message(iosb.status | 0x00040000);c   return FALSE;_ }&  % int decode_que_flags(long int status)_ {w.         if ((status & QUI$M_QUEUE_BATCH) != 0)            return BATCH;. 	else if ((status & QUI$M_QUEUE_GENERIC) != 0) 	   return GENERIC;). 	else if ((status & QUI$M_QUEUE_PRINTER) != 0) 	   return PRINTER; / 	else if ((status & QUI$M_QUEUE_TERMINAL) != 0)N 	   return TERMINAL;- 	else if ((status & QUI$M_QUEUE_SERVER) != 0)m 	   return SERVER;         else 	   return FALSE;e }G  > void decode_type_status(long int status, char status_string[]) { ) 	if ((status & QUI$M_QUEUE_GENERIC) != 0)t% 	   strcpy(status_string, "Generic");f, 	else if ((status & QUI$M_QUEUE_BATCH) != 0)# 	   strcpy(status_string, "Batch");r. 	else if ((status & QUI$M_QUEUE_PRINTER) != 0)% 	   strcpy(status_string, "Printer");r/ 	else if ((status & QUI$M_QUEUE_TERMINAL) != 0) & 	   strcpy(status_string, "Terminal");- 	else if ((status & QUI$M_QUEUE_SERVER) != 0)m$ 	   strcpy(status_string, "Server");         else%            strcpy(status_string, "");  }	      = void decode_job_status(long int status, char status_string[])  { /         if ((status & QUI$M_JOB_ABORTING) != 0)*& 	   strcpy(status_string, "Aborting");. 	else if ((status & QUI$M_JOB_EXECUTING) != 0))  	   strcpy(status_string, "Executing"); i, 	else if ((status & QUI$M_JOB_HOLDING) != 0)& 	   strcpy(status_string, "Holding"); , 	else if ((status & QUI$M_JOB_PENDING) != 0)& 	   strcpy(status_string, "Pending"); , 	else if ((status & QUI$M_JOB_REFUSED) != 0)& 	   strcpy(status_string, "Refused"); - 	else if ((status & QUI$M_JOB_RETAINED) != 0) ' 	   strcpy(status_string, "Retained");  - 	else if ((status & QUI$M_JOB_STARTING) != 0)r& 	   strcpy(status_string, "Starting");. 	else if ((status & QUI$M_JOB_SUSPENDED) != 0)( 	   strcpy(status_string, "Suspended"); 2 	else if ((status & QUI$M_JOB_TIMED_RELEASE) != 0)& 	   strcpy(status_string, "Waiting"); 1 	else if ((status & QUI$M_JOB_INACCESSIBLE) != 0)i* 	   strcpy(status_string, "Inaccessible"); 	else $ 	   strcpy(status_string, "");       }e  = void decode_que_status(long int status, char status_string[])s {u/         if ((status & QUI$M_QUEUE_CLOSED) != 0) $ 	   strcpy(status_string, "Closed");- 	else if ((status & QUI$M_QUEUE_PAUSED) != 0) % 	   strcpy(status_string, "Paused"); ). 	else if ((status & QUI$M_QUEUE_PAUSING) != 0)& 	   strcpy(status_string, "Pausing"); 0 	else if ((status & QUI$M_QUEUE_RESETTING) != 0)( 	   strcpy(status_string, "Resetting"); . 	else if ((status & QUI$M_QUEUE_STALLED) != 0)& 	   strcpy(status_string, "Stalled"); / 	else if ((status & QUI$M_QUEUE_STARTING) != 0) & 	   strcpy(status_string, "Starting");. 	else if ((status & QUI$M_QUEUE_STOPPED) != 0)& 	   strcpy(status_string, "Stopped"); / 	else if ((status & QUI$M_QUEUE_STOPPING) != 0)t' 	   strcpy(status_string, "Stopping"); e2 	else if ((status & QUI$M_QUEUE_UNAVAILABLE) != 0)) 	   strcpy(status_string, "Unavailable");e 	else $ 	   strcpy(status_string, "");       }a  I /* concatate string str2 to str1, add blank spaces if num is greater than >    the length of str2, add a space at the end if the resulting    string is longer than num */i2 void add_strcat(char str1[], char str2[], int num) {      int length, end_of_string;       strncat(str1, str2, num-1);      end_of_string=strlen(str1); '     if ((length=strlen(str2)) > num-1){t        str1[end_of_string++]=' ';     }      while(num > length++){        str1[end_of_string++]=' ';     }      str1[end_of_string]='\0';s }_   void clean_up(void)  {     make_message_line(MSG_WAIT);r    delete_screen(); 9    printf("Thank you for using Visual Queue Manager.\n");     printf("Goodbye.\n");    exit(EXIT_SUCCESS); }	  E void display_list(Header list, void (*make_line)(int, Vertex, char*))  {    Vertex temp;
   int n=0;     move_cursor_home();c   temp=list->first;    while (temp != NULL){s     n++;     if (n==marker){)-        output_info(n, temp, make_line, TRUE);d     } else {.        output_info(n, temp, make_line, FALSE);     }      temp=next(temp);   }r   erase_below_line(n+1);   paste_to_screen(); }e  6 void search_char(Header list, unsigned short smg_num, 7                  void (*make_line)(int, Vertex, char*))t {d     char text[TERMWIDTH+1];u     int ch, ch_count;l  3     ch=toupper(smg_num);   /* move to upper case */ 5     if ((ch_count=find_first_letter(list, ch)) >= 0){ ;        output_info(marker, current_node, make_line, FALSE); :        current_node=move_forward(list->first, ch_count-1);'        marker=ch_count; scroll_point=1;T:        output_info(marker, current_node, make_line, TRUE);        row_view=ch_count;         change_view(ch_count); 
     }else{F        strcpy(text, "No entry starting with letter   has been found");        text[30]=smg_num;        make_message_line(text);t     }  }    /* marker already advanced */ H void change_highlight(int direct, void (*make_line)(int, Vertex, char*)) {    Vertex temp;     if (direct == UP){;      output_info(marker+1, current_node, make_line, FALSE);))      current_node=previous(current_node);a8      output_info(marker, current_node, make_line, TRUE);	    }else{ ;      output_info(marker-1, current_node, make_line, FALSE);R%      current_node=next(current_node);a8      output_info(marker, current_node, make_line, TRUE);    }    paste_to_screen();; }       F void update_job_list(Header job, long *que_status, int *total_jobs)    {e     int change;&  &     make_message_line(MSG_UPDATE_JOB);     destroy(job);      job=create_header();/     *total_jobs=fill_job_list(job, que_status);r*     check_update_bounds(job, *total_jobs);)     job_screen_draw(device, *que_status);(%     display_list(job, make_job_line); %     make_message_line(MSG_LONGBLANK);q }e  N void move_page_down(int n, Header list, void (*make_line)(int, Vertex, char*)) {    if (n==0)       return;   if (marker==n){ $      make_message_line(MSG_NOBELOW);"   }else if (marker+view_l-1 <= n){9      output_info(marker, current_node, make_line, FALSE);c      row_view+=view_l-1;      marker+=view_l-1;      change_view(row_view);e7      current_node=move_forward(current_node, view_l-1);M8      output_info(marker, current_node, make_line, TRUE);	   } else{       if (row_view+view_l < n){         row_view=n-view_l+1;         scroll_point=view_l;           change_view(row_view);
      } else {n          scroll_point+=n-marker;       }1      output_info(n, list->last, make_line, TRUE);o9      output_info(marker, current_node, make_line, FALSE); '      marker=n; current_node=list->last;    }  }o  L void move_page_up(int n, Header list, void (*make_line)(int, Vertex, char*)) {    if (n==0)L      return;   if (marker==1){V$      make_message_line(MSG_NOABOVE);"   }else if (marker-(view_l-1)>=1){9      output_info(marker, current_node, make_line, FALSE);       if (row_view <= view_l-1){u         reset_viewport();       }else{a         row_view-=view_l-1;o         change_view(row_view);      }      marker-=view_l-1;8      current_node=move_backward(current_node, view_l-1);8      output_info(marker, current_node, make_line, TRUE);	   } else{i      if (row_view <= view_l)   n         reset_viewport();e2      output_info(1, list->first, make_line, TRUE);9      output_info(marker, current_node, make_line, FALSE);n(      marker=1; current_node=list->first;   }  }f  5 void job_screen_draw(char *que_name, long que_status)n {d<   char header[QUELEN+STATLEN+2], que_status_string[STATLEN];  3   decode_que_status(que_status, que_status_string);a   strcpy(header, que_name);(   strcat(header, " ");$   strcat(header, que_status_string);   make_menu_bar(MSG_MENU_1);   make_header(header);   make_column(JOB);  }    void fake_error(int code)  {    switch(code){r	   case 1:E     delete_screen();_     fprintf(stderr, "\n%%VQM-E-NOSUCHQUE, invalid queue name - check validity and spelling\n");o)     fprintf(stderr, " \\%s\\\n", device);G
     break;	   case 2: V     fprintf(stderr, "\n%%VQM-E-TERMLEN, Terminal page length is too small for VQM\n");
     break;	   case 3:o     delete_screen();V     fprintf(stderr, "\n%%VQM-E-ENTLIM, Current maximum entry limit is %d\n", DISPLEN);l     fprintf(stderr, "-VQM-I-CHANGE, Please change '#define DISPLEN %d' in vqm.h and re-build VQM", DISPLEN);
     break;   }    exit(EXIT_SUCCESS);  }/  8 void make_help_line(char text[], char *help[][3], int i) {f    text[0]='\0';$    add_strcat(text, help[i][0], 25);$    add_strcat(text, help[i][1], 25);$    add_strcat(text, help[i][2], 25); }   9 void make_queue_line(int num, Vertex node, char result[])  { L    char num_string[6], que_type_string[STATLEN], que_status_string[STATLEN];    r8    decode_type_status(node->num_data1, que_type_string);9    decode_que_status(node->num_data2, que_status_string); #    sprintf(num_string, "%3d", num);_&    add_strcat(result, num_string, 13);+    add_strcat(result, node->str_data1, 26);{+    add_strcat(result, que_type_string, 20);a-    add_strcat(result, que_status_string, 17);u }       7 void make_job_line(int num, Vertex node, char result[])T {CI    char num_string[4], size_string[7], ratio_string[5],  entry_string[6],L         status[STATLEN];   _  .    decode_job_status(node->num_data3, status);#    sprintf(num_string, "%3d", num); 1    sprintf(entry_string, "%5d", node->num_data4);e0    sprintf(size_string, "%6d", node->num_data1);1    sprintf(ratio_string, "%3d", node->num_data2);     strcat(ratio_string, "%");(%    add_strcat(result, num_string, 5);_+    add_strcat(result, node->str_data1, 20);)+    add_strcat(result, node->str_data2, 14);s'    add_strcat(result, entry_string, 7);(    if (que_type != BATCH){%       add_strcat(result, status, 13);e)       add_strcat(result, size_string, 9); +       add_strcat(result, ratio_string, 10); 	    }else{ %       add_strcat(result, status, 32);N    } }        void make_column(int type) {o    char text[TERMWIDTH-1];      if (type == JOB){       strcpy(text, MSG_COL_1);       if (que_type != BATCH){ !          strcat(text, MSG_COL_2);        } 	    }else{        strcpy(text, MSG_COL_3);    }    make_column_title(text);  }e