I /************************************************************************ I **                                                                      * 6 ** Copyright  1996 Digital Equipment Corporation.			*I ** All rights reserved.                                                 * I **                                                                      * I ** Redistribution and use in source and binary forms are permitted      * I ** provided that the above copyright notice and this paragraph are      * I ** duplicated in all such forms and that any documentation,             * I ** advertising materials, and other materials related to such           * I ** distribution and use acknowledge that the software was developed     * I ** by Digital Equipment Corporation.  The name of the                   * I ** Corporation may not be used to endorse or promote products derived   * I ** from this software without specific prior written permission.        * I ** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       * I ** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       * I ** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * I **                                                                      * I **                                                                      * I ************************************************************************* I **                                                                      * I **      Important Note:                                                 * I **                                                                      * I **         This coding example uses privileged OpenVMS interfaces.      * I **         OpenVMS does not guarantee that these interfaces will        * I **         be supported indefinitely, and may change these interfaces   * I **         without prior notice.                                        * I **                                                                      * I *************************************************************************  **++
 **  FACILITY:  ** **      ip_vcm.c **
 **  ABSTRACT:  **; **      This module implements a basic VCM for testing PPP.  ** **  AUTHORS: **; **      Patrick Crilly,   Networks Engineering (Australia).  ** **  CREATION DATE: ** **      25-March-1996  ** **  MODIFICATION HISTORY:  ** **# **	12-March-1997     Joe P. Tavares I **                        Add fork_lock and fork_unlock to startProtocol.  **, **      17-December-1996  Barry W. KiersteinF **                        Replaced the standard Digital copyright with@ **                        one compatible with the CMU copyright. ** **& **	 1-October-1996	  Forrest A. Kenney4 **			  Remove 4 character terminal name restriction. **, **       1-August-1996    Barry W. Kierstein< **                        Added "Important Note" disclaimer. **, **      24-July-1996      Barry W. Kierstein5 **                        Corrected copyright notice.  **+ **      25-March-1996     Original version.  ** **-- */  B #define VCIBDEF vcibdef /* work around broken vcibdef.h in V7.1 */ #define	MAX_TERMINAL_NAME 20   /* ** Include files */< #include "ssdef.h"       /* Include SS$_xxx defintions    */< #include "string.h"      /* Include string defintions     */< #include "vcrpdef.h"     /* Include vcrp defintions       */< #include "vcibdef.h"     /* Include vcib defintions       */< #include "ppp_vci_if.h"  /* Include PPP VCI defintions    */< #include "ppp_lib.h"     /* Include PPP library prototype */< #include "vms_drivers.h" /* VMS device driver macros      */   /* ** Global variables  */N VCIRTNS *VCIFns;        /* Pointer to PPP VCI's create/delete port routines */N VCIBPPPDEF IPVcib;      /* VCIB for connecting to PPP VCM                   */N struct vcrpdef mgmtReq; /* VCRP for issuing PortMgmt_Initiate requests      */N int IPPktsSent;         /* Count of packets transmitted                     */   /* external functions */ extern int  VCICreate(); extern int VCIDelete();  extern void VCICall();   /* forward declare routines */% int startProtocol( char *ttDevName );  void stopProtocol( void );   /* Transmit Complete */ \ #pragma linkage VCITxComplLnkg = (parameters(r4,r3), preserved(r2,r4,r5), nopreserve(r0,r1))/ #pragma use_linkage VCITxComplLnkg (VCITxCompl) = void VCITxCompl( VCIBPPPDEF *vcib, struct vcrpdef *request );    /* PortMgmt Complete */ ^ #pragma linkage VCIMgmtComplLnkg = (parameters(r4,r3), preserved(r2,r4,r5), nopreserve(r0,r1))3 #pragma use_linkage VCIMgmtComplLnkg (VCIMgmtCompl) ? void VCIMgmtCompl( VCIBPPPDEF *vcib, struct vcrpdef *request );   
 /* Receive */ W #pragma linkage VCIRxLnkg = (parameters(r4,r3), preserved(r2,r4,r5), nopreserve(r0,r1)) * #pragma use_linkage VCIRxLnkg (VCIRxCompl)= void VCIRxCompl( VCIBPPPDEF *vcib, struct vcrpdef *request );    /* Events */Y #pragma linkage VCIReportLnkg = (parameters(r4,r1, r2), preserved(r5), nopreserve(r0,r1)) / #pragma use_linkage VCIReportLnkg (VCIRptEvent) < void VCIRptEvent( VCIBPPPDEF *vcib, int event, int reason );     /* **++ **  FUNCTION NAME: ** **      startProtocol  ** **  FUNCTIONAL DESCRIPTION:  **D **      This routine is called to start a protocol (in this case IP)@ **      running over PPP.  It just creates a VCI port to PPP and< **      then issues a PortMgmt_Initiate ENABLE_PORT request. **F **      Because of the way his routine is coded the name of the deviceD **      can't be more than 5 characters.   Hey - this is sample code2 **      afterall, I've left the good bits for you. ** **  FORMAL PARAMETERS: **@ **      ttDevName    Name of PPP device to start the protocol on ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **5 **      status returned by PPP VCI CreatePort routine  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */$ int startProtocol( char *ttDevName ) {      int saved_ipl;     int status;      struct PPPItemList     {   	int            length;     	void           *addr;     	unsigned short size;      	unsigned char  type;      	unsigned char  subType; 	unsigned short protoLen;  	unsigned short protoItem; 	unsigned short proto;    	unsigned short nameLen;  	unsigned short nameItem; ( 	unsigned char  name[MAX_TERMINAL_NAME];=     } PPPItemList;    /* Item list for Enable Port request */   *     /* initialise count of packets sent */     IPPktsSent = 0;   /     /* get pointer to create/delete routines */ 5     VCIFns = (VCIRTNS *)PPPD$LIBRTNS( PPP_VCI_RTNS );      if ( !VCIFns )     {  	return ( SS$_ABORT );     }   /     /* Set up the VCIB for connecting to PPP */ J     IPVcib.vcib$r_vcibdef.vcib$a_portmgmt_complete = (void *)VCIMgmtCompl;H     IPVcib.vcib$r_vcibdef.vcib$a_transmit_complete = (void *)VCITxCompl;H     IPVcib.vcib$r_vcibdef.vcib$a_receive_complete  = (void *)VCIRxCompl;I     IPVcib.vcib$r_vcibdef.vcib$a_report_event      = (void *)VCIRptEvent;   )     fork_lock(SPL$C_IOLOCK8, &saved_ipl);      /* create a port to PPP */6     status = VCICreate( VCIFns->createport, &IPVcib );       /* enable port */      if ( status == SS$_NORMAL )      { >         /* Set up the item list for the Enable Port request */"         PPPItemList.protoLen  = 6;0         PPPItemList.protoItem = PPPD$K_PROTOCOL;0         PPPItemList.proto     = 0x0021; /* IP */  6         PPPItemList.nameLen   = strlen(ttDevName) + 4;,         PPPItemList.nameItem  = PPPD$K_NAME;J         strncpy( (char *)PPPItemList.name, ttDevName, strlen(ttDevName) );  K         PPPItemList.length    = PPPItemList.nameLen + PPPItemList.protoLen; 6         PPPItemList.addr      = &PPPItemList.protoLen;4         PPPItemList.size      = sizeof(PPPItemList);  0        /* Set up VCRP for Enable Port request */5    	mgmtReq.vcrp$a_input_list = (void *)&PPPItemList; 5     	mgmtReq.vcrp$l_function = VCRP$K_FC_ENABLE_PORT;            /* Call Enable Port */=     	VCICall( IPVcib.vcib$r_vcibdef.vcib$a_portmgmt_initiate, %                  &mgmtReq, &IPVcib );       }7      fork_unlock(SPL$C_IOLOCK8, saved_ipl, SMP_RESTORE)        return (status); }    /* **++ **  FUNCTION NAME: ** **      stopProtocol ** **  FUNCTIONAL DESCRIPTION:  **C **      This routine is called to stop a protocol running over PPP. @ **      It just issues a PortMgmt_Initiate DISABLE_PORT request. ** **  FORMAL PARAMETERS: **
 **      None.  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */ void stopProtocol( ) { *     /* Set up VCRP for Disable  request */"     mgmtReq.vcrp$a_input_list = 0;5     mgmtReq.vcrp$l_function = VCRP$K_FC_DISABLE_PORT;        /* Call disable routine */<     VCICall( IPVcib.vcib$r_vcibdef.vcib$a_portmgmt_initiate,!              &mgmtReq, &IPVcib );    }      /* **++ **  FUNCTION NAME: ** **      VCIMgmtCompl ** **  FUNCTIONAL DESCRIPTION:  **? **      This function processes the asychronous completion of a " **      PortMgmt_Initiate request. ** **  FORMAL PARAMETERS: **? **      vcib       Pointer to the vcib the request completed on F **      request    Pointer to the vcrp containing the request transmit ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */> void VCIMgmtCompl( VCIBPPPDEF *vcib, struct vcrpdef *request ) { <     if ( mgmtReq.vcrp$l_function == VCRP$K_FC_DISABLE_PORT )     { 
         /*A 	 ** Really should check status of disable here.   Disable should J          ** only fail though if called more than once without a completionK          ** being received so I going to be slack, this is only an example.           */    	/* close PPP port */ * 	VCIDelete( VCIFns->deleteport, &IPVcib );     }      else     {  	/* an enable request */9        if ( mgmtReq.vcrp$l_request_status != SS$_NORMAL )         { 	    stopProtocol();        }     }      return;* }*   /* **++ **  FUNCTION NAME: ** **      VCIRxCompl ** **  FUNCTIONAL DESCRIPTION:  **2 **      This function processes a received packet.< **      For this example when send the packet straight back.5 **      After sending 6 packets we stop the protocol.  ** **  FORMAL PARAMETERS: **4 **      vcib       Pointer to the vcib the packet onE **      request    Pointer to the vcrp containing the received packetp ** **  IMPLICIT INPUTS: **
 **      None.h ** **  IMPLICIT OUTPUTS:* **
 **      None.s **& **  function value or completion codes **
 **      None.i ** **  SIDE EFFECTS:e **
 **      None.  ** **-- */< void VCIRxCompl( VCIBPPPDEF *vcib, struct vcrpdef *request ) { 2     /* Turn the receive into a  transmit packet */2     request->vcrp$l_function = VCRP$K_FC_TRANSMIT;       /* Call transmit routine */pP     VCICall( IPVcib.vcib$r_vcibdef.vcib$a_transmit_initiate, request, &IPVcib );     IPPktsSent++;   0     /* After 6 packet sent sent stop protocol */     if ( IPPktsSent > 5 )      {I     	stopProtocol();     }H       return;    }M /* **++ **  FUNCTION NAME: ** **      VCITxCompl ** **  FUNCTIONAL DESCRIPTION:  **? **      This function processes the asychronous completion of a " **      Transmit_Initiate request. ** **  FORMAL PARAMETERS: **@ **      vcib       Pointer to the vcib the transmit completed onH **      request    Pointer to the vcrp containing the completed transmit ** **  IMPLICIT INPUTS: **
 **      None.n ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.i ** **-- */< void VCITxCompl( VCIBPPPDEF *vcib, struct vcrpdef *request ) { B     /* If the transmit failed for any reason stop the protocol  */7     if ( request->vcrp$l_request_status != SS$_NORMAL )      {  	stopProtocol();     }.     return;  }      /* **++ **  FUNCTION NAME: ** **      VCIRptEvent  ** **  FUNCTIONAL DESCRIPTION:  **< **      This function processes the asychronous notification **      of an event  ** **  FORMAL PARAMETERS: **< **      vcib       Pointer to the vcib the event occurred on* **      event      The event that occurredW **      reason     Reason that caused the event (to be honest I don't care - you might)T ** **  IMPLICIT INPUTS: **
 **      None.I ** **  IMPLICIT OUTPUTS:* **
 **      None.J **& **  function value or completion codes **
 **      None.k ** **  SIDE EFFECTS:l **
 **      None.D ** **-- */; void VCIRptEvent( VCIBPPPDEF *vcib, int event, int reason )a {r     switch (event)     {*       case PPPD$K_PORT_FAILED:'         /* stop the protocol running */*         stopProtocol();t
       	break;	         case PPPD$K_PORT_USABLE:/         /* can start transmitting IP packets */r
       	break;           case PPPD$K_PORT_UNUSABLE:/         /* must stop transmitting IP packets */6
       	break;K       }      return;  }   