I /************************************************************************ I **                                                                      * I ** Copyright  1996 Digital Equipment Corporation.                      * I ** All rights reserved.                                                 * I **                                                                      * I ** Redistribution and use in source and binary forms are permitted      * I ** provided that the above copyright notice and this paragraph are      * I ** duplicated in all such forms and that any documentation,             * I ** advertising materials, and other materials related to such           * I ** distribution and use acknowledge that the software was developed     * I ** by Digital Equipment Corporation.  The name of the                   * I ** Corporation may not be used to endorse or promote products derived   * I ** from this software without specific prior written permission.        * I ** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       * I ** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       * I ** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * I **                                                                      * I *************************************************************************  **++
 **  FACILITY:  ** **      magic.c  **
 **  ABSTRACT:  **= **      This module contains routines to implement a function 4 **      for generating the magic number used by PPP  ** **  AUTHORS: **; **      Patrick Crilly,   Networks Engineering (Australia).  ** **  CREATION DATE: ** **      6-December-1995  ** **  MODIFICATION HISTORY:  **, **      17-December-1996  Barry W. KiersteinF **                        Replaced the standard Digital copyright with@ **                        one compatible with the CMU copyright. **, **      24-July-1996      Barry W. Kierstein5 **                        Corrected copyright notice.  *** **      6-December-1995  Original version. ** **-- */   /* ** Include files */   /* ** ** import definitions: **        types  ** */ #ifndef _PPPD_H_ #include "pppd.h"  #endif   /* ** ** import definitions:' **        prototypes for magic routines  ** */ #ifndef _MAGIC_H_  #include "magic.h" #endif   #ifdef USER  /* ** ** import definitions: **        sys$gettime  ** */ #ifndef __STARLET_LOADED #include "starlet.h" #endif #endif /* USER */    /* ** Global Variables  */I static u_int32_t randNum;	/* Used to store calculated reandom number   */    /* ** External defintions */ #ifndef USER0 extern __int64 EXE$GQ_SYSTIME;	/* System time */ #endif     /* **++ **  FUNCTION NAME: ** **      magic_init ** **  FUNCTIONAL DESCRIPTION:  **4 **      This function initialises the algorithm used( **      by PPP to generate magic numbers ** **  FORMAL PARAMETERS: **
 **      None.  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */ void magic_init(void)  { '     __int64 daytim;		/* current time */         #ifdef USER      /*7      ** Ignore return status from function to get time. A      ** If it fails use the value in daytim which will be picked  ;      ** up from the stack - should be random enough anyway.       */          (void)sys$gettim(&daytim); #else      daytim = EXE$GQ_SYSTIME; #endif     pppSrand( (u_int)daytim );     return;  }      /* **++ **  FUNCTION NAME: **
 **      magic  ** **  FUNCTIONAL DESCRIPTION:  **D **      This function is called to obtain a magic number to be used , **      by LCP ifor the magic number option. ** **  FORMAL PARAMETERS: **
 **      None.  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **? **      A integer to use as a magic number in LCP negotiations.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */ u_int32_t magic()  {      return (pppRand());  }      /* **++ **  FUNCTION NAME: ** **      pppRand  ** **  FUNCTIONAL DESCRIPTION:  **C **      This function is used to generate a random number.  It uses @ **      the alogrithm used by the 'C' rand rouitne.   I'll admit@ **      it's not very random but it's good enough for what we're% **      doing and that's what counts.  ** **  FORMAL PARAMETERS: **
 **      None.  ** **  IMPLICIT INPUTS: **A **      randNum    The value of the last random number generated.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes ** **      A random integer value.  ** **  SIDE EFFECTS:  **E **      randNum will be updated with the new random number generated.  ** **-- */ static u_int32_t pppRand() { <     randNum = ( randNum * 1103515245 + 12345 ) & 0x7fffffff;     return (randNum);  }      /* **++ **  FUNCTION NAME: ** **      pppSrand ** **  FUNCTIONAL DESCRIPTION:  **G **      This function is used to initialise the random number generator  ** **  FORMAL PARAMETERS: **I **      seed      The initial value to use in the random number algorithm  ** **  IMPLICIT INPUTS: **A **      randNum    The value of the last random number generated.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */ void pppSrand( int seed )  {      randNum = seed;      (void)pppRand();     return;  }     