I /************************************************************************ I **                                                                      * I ** Copyright  1996 Digital Equipment Corporation.                      * I ** All rights reserved.                                                 * I **                                                                      * I ** Redistribution and use in source and binary forms are permitted      * I ** provided that the above copyright notice and this paragraph are      * I ** duplicated in all such forms and that any documentation,             * I ** advertising materials, and other materials related to such           * I ** distribution and use acknowledge that the software was developed     * I ** by Digital Equipment Corporation.  The name of the                   * I ** Corporation may not be used to endorse or promote products derived   * I ** from this software without specific prior written permission.        * I ** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       * I ** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       * I ** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * I **                                                                      * I *************************************************************************  **++
 **  FACILITY:  ** **      ppp_async.c  **
 **  ABSTRACT:  **D **      This module implements routines required to interface to the7 **      asynchronous device driver via a VCI interface.  ** **  AUTHORS: **; **      Patrick Crilly,   Networks Engineering (Australia).  ** **  CREATION DATE: ** **      29-November-1995 ** **  MODIFICATION HISTORY:  **C **      X-6     BWK002          Barry W. Kierstein      17-Dec-1996 < **              Replaced the standard Digital copyright with6 **              one compatible with the CMU copyright. **C **      X-5     PWC             Patrick W. Crilly       28-Aug-1996 / **              In deviceTransmit should use ho / **              In deviceReceive  should use go  **C **      X-3     BWK001          Barry W. Kierstein      24-JUL-1996 + **              Corrected copyright notice.  **, **	X-2	FAK001		Forrest A. Kenney	14-May-1996% **		Add code to shut down the logger.  **+ **      29-November-1995  Original version.  ** **-- */   /* ** Include files */   /* ** ** import definitions: **        lineId ** */ #ifndef _PPPD_H_ #include "pppd.h"  #endif   /* ** ** import definitions: **        lcp_options  ** */ #ifndef _LCP_VMS_H_  #include "lcp_vms.h" #endif   /* ** ** import definitions: **        LTRM_UCB ** */ #ifndef __TTYUCBDEF_LOADED #include "ttyucbdef.h" #endif   /* ** ** import definitions: **        ASN$xxx defines  ** */ #ifndef __ASNDEF_LOADED  #include "asndef.h"  #endif   /* ** ** import definitions: **        ASNUCB ** */ #ifndef __ASNMISCDEF_LOADED  #include "asnmiscdef.h"  #endif   /* ** ** import definitions: **        IOC$M_ANY  ** */ #ifndef __IOCDEF_LOADED  #include "iocdef.h"  #endif   /* ** ** import definitions: **        ioc_std$searchint  **        ioc_std$parsdevnam ** */ #ifndef __IOC_ROUTINES_LOADED  #include "ioc_routines.h"  #endif   /* ** ** import definitions: **        $DESCRIPTOR  ** */ #ifndef __DESCRIP_LOADED #include "descrip.h" #endif   /* ** ** import definitions: **        fsm_data **        fsm_is_registered  ** */ #ifndef _FSM_VMS_H #include "fsm_vms.h" #endif   /* ** ** import definitions: **        BUF_ALLOC  ** */ #ifndef _PPP_BUF_  #include "ppp_buf.h" #endif   /* ** ** import definitions: **        asnvcibdef ** */ #ifndef __ASNVCIBDEF_LOADED  #define _VCIBDEF_H_ B #define VCIBDEF vcibdef /* work around broken vcibdef.h in V7.1 */ #include "asnvcibdef.h"  #endif   /* ** ** import definitions: **        ppp vcib defines ** */ #ifndef _PPP_VCIB_H_ #include "ppp_vcib.h"  #endif   /* ** ** import definitions:/ **        prototypes for this module's routines  ** */ #ifndef _PPP_ASYNC_H_  #include "ppp_async.h" #endif   /* string for ASN device */  #define ASN0     "ASN0"   A /* structure to store ASN driver's create/delete port routines */  struct   { K     int (*createPort)();  /* Address of ASN driver's create port routine */ K     int (*deletePort)();  /* Address of ASN driver's delete port routine */ 
 } devInfo;   /* ** Declare external routines */ extern u_int VCICall();  extern u_int VCICreate();  extern u_int VCIDelete();      /* **++ **  FUNCTION NAME: ** **      deviceClose  ** **  FUNCTIONAL DESCRIPTION:  **I **      This function is used to close the connection to the asynchronous L **      device.   Firstly a disconnect is issued to the asynchronous device.J **      The async. driver's delete port routine is then called, regardless, **      of whether the disconnect succeeded. ** **  FORMAL PARAMETERS: **. **      line      Identifier for the PPP line. ** **  IMPLICIT INPUTS: **J **      devInfo   Structure containing the async drivers' delete port rtn. ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **; **      status returned by async devices deletePort routine  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */  u_int deviceClose( lineId line ) { D     struct vcrpdef *disconReq;	/* vcrp to build disconnect in     */@     ASNVCIB *vcib;	        /* pointer to vcib for the device  */<     qioItem *itemPtr;		/* pointer to a QIO item           */E     u_int    status;            /* function return status          */   %     vcib = &(LINE_ENTRY(line)->vcib);           /*  >      ** We attempt to disconnect the device.  If this fails we4      ** don't care, we go ahead and delete the vcib.      */       MGMT_BUF_ALLOC( disconReq );     if ( disconReq != NULL )     { / 	ALLOC_MEM( itemPtr, sizeof(qioItem), void * );  	if ( itemPtr != NULL )  	{0 	    /* construct the list of items to be set */+ 	    itemPtr->code       = ASN$_DISCONNECT;  	    itemPtr->len        = 0;  	    itemPtr->data.value = 0;  	    itemPtr->retAddr    = 0;  	     5 	    disconReq->vcrp$a_input_list          = itemPtr; = 	    disconReq->vcrp$t_mgmt_information[0] = sizeof(qioItem); ; 	    disconReq->vcrp$l_function            = VCRP$K_FC_SET; : 	    VCICall( vcib->VCIBPortmgmtSynch, disconReq, vcib );  	    DEALLOC_MEM( itemPtr ); 	} 	MGMT_BUF_DEALLOC( disconReq );      }   "     /* call delete port routine */3     status = VCIDelete( devInfo.deletePort, vcib );        return;  }      /* **++ **  FUNCTION NAME: ** **      deviceDisable  ** **  FUNCTIONAL DESCRIPTION:  **H **      This function is used to disable the reception of data from the  **      asychronous device.  ** **  FORMAL PARAMETERS: **, **      line    Identifier for the PPP line. ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **? **      TRUE    Data reception on the device has been disabled. 0 **      FALSE   Couldn't disable data reception. ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */! char deviceDisable( lineId line )  { E     struct vcrpdef *disableReq;	/* vcrp to build disable in        */ ?     ASNVCIB        *vcib;	/* pointer to vcib for the device  */ B     char   disabled = FALSE;	/* TRUE if deviceDisable succeeded */  %     vcib = &(LINE_ENTRY(line)->vcib); !     MGMT_BUF_ALLOC( disableReq );      if ( disableReq != NULL )      { 6 	disableReq->vcrp$l_function = VCRP$K_FC_DISABLE_PORT;7 	VCICall( vcib->VCIBPortmgmtSynch, disableReq, vcib );  7 	if ( disableReq->vcrp$l_request_status == SS$_NORMAL )  	{ 	    disabled = TRUE;  	}  	MGMT_BUF_DEALLOC( disableReq );     }        return (disabled); }      /* **++ **  FUNCTION NAME: ** **      deviceEnable ** **  FUNCTIONAL DESCRIPTION:  **G **      This function is used to enable the reception of data from the   **      asychronous device.  ** **  FORMAL PARAMETERS: **+ **      line    Identifier for the PPP line  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **> **      TRUE    Data reception on the device has been rnabled./ **      FALSE   Couldn't rnable data reception.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */  char deviceEnable( lineId line ) { C     struct vcrpdef *enableReq;	/* vcrp to build enable in        */ ?     ASNVCIB *vcib;	        /* pointer to vcib for the device */ @     char   enabled = FALSE;	/* TRUE if deviceEnable succeeded */  %     vcib = &(LINE_ENTRY(line)->vcib);       MGMT_BUF_ALLOC( enableReq );     if ( enableReq != NULL )     { 4 	enableReq->vcrp$l_function = VCRP$K_FC_ENABLE_PORT;6 	VCICall( vcib->VCIBPortmgmtSynch, enableReq, vcib ); 6 	if ( enableReq->vcrp$l_request_status == SS$_NORMAL ) 	{ 	    enabled = TRUE; 	} 	MGMT_BUF_DEALLOC( enableReq );      }        return (enabled);  }      /* **++ **  FUNCTION NAME: ** **      deviceGetUCB ** **  FUNCTIONAL DESCRIPTION:  **? **      This function takes a device name e.g. TTA0 and returns % **      a pointer to the devices UCB.  **; **      NOTE:  Because of the way the ioc routines work the @ **      device name cannnot have the leading _ or the trailing : **      in it. ** **  FORMAL PARAMETERS: **5 **      devName    Name of the device to find UCB for 9 **      ucbPtr     Pointer to the device's UCB (returned)  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **C **      status values returned by IOC$_PARSDEVNAM & IOC$_SEARCHINT.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */C u_int deviceGetUCB( char *devName, int32 devNameLen, UCB **ucbPtr )  { L     DDB    *ddbPtr;           /* pointer to device's data block           */L     SB     *sbPtr;            /* pointer to device's system control block */L     u_int   status;           /* return code from ioc function call       */L     int32   unit;             /* unit number of device                    */L     int32   scsLen;           /* length of scs field in device            */L     int     flagsIn;          /* flags to pass to search                  */L     int32   flagsOut;         /* flags returned by search                 */I     void   *lockPtr;	      /* pointer to device's lock                 */ L     char   *devNameOut;       /* pointer to parsed dev name               */L     int32   devNameLenOut;    /* length of parsed dev name                */ 	gL     flagsIn = IOC$M_ANY | IOC$M_PHY;  /* we're at IPL8 so ANY must be set */5     status = ioc_std$parsdevnam( devNameLen, devName,m. 				 flagsIn, &unit, &scsLen, &devNameLenOut,  				 &devNameOut, &flagsOut );          if ( status == SS$_NORMAL )e     { F 	status = ioc_std$searchint( unit, scsLen, devNameLenOut, devNameOut,  				    flagsIn, ucbPtr, m$ 				    &ddbPtr, &sbPtr, &lockPtr );     }        return ( status ); }f     /* **++ **  FUNCTION NAME: ** **      deviceHangup ** **  FUNCTIONAL DESCRIPTION:S **K **      This routine is used to process a hangup on the asychronous device. 8 **      If the PPP line is transient it will be deleted. ** **  FORMAL PARAMETERS: **; **      vcib    Pointer to the vcib hangup received on.      ** **  IMPLICIT INPUTS: **
 **      None.* ** **  IMPLICIT OUTPUTS:* **
 **      None.* **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */) void deviceHangup( struct VCIBDEF *vcib )  {nA     PPPLine *linePtr;		/* pointer to the line packet rcvd on   */           linePtr = (PPPLine *)vcib;	n  -     /* tell state machine lower layer gone */ !     lcp_lowerdown( linePtr->id );O          /* close state machine */      lcp_close( linePtr->id );e     1     /* if this is a transient line - delete it */a%     if ( linePtr->type == Transient )      {n 	linePtr->delete = TRUE; 	lcp_shutLine( linePtr->id );      }        return;  }C     /* **++ **  FUNCTION NAME: ** **      deviceInit ** **  FUNCTIONAL DESCRIPTION:n **L **      This routine is used to find the create/delete port routines of the I **      async driver which are stored in the UCB of ASN0:  We need to do *F **      this because we are not guaranteed of having the VCI registry  **      routines present.N ** **  FORMAL PARAMETERS: **
 **      None.  ** **  IMPLICIT INPUTS: **K **      devInfo    Structure containing the async drivers' delete port rtn.i7 **      asnDesc    String descriptor for ASN0: device. : ** **  IMPLICIT OUTPUTS:* **
 **      None.V **& **  function value or completion codes **K **      TRUE     Found ASN device and saved pointers to create/delete rtns.D, **      FALSE    Couldn't locate ASN device. ** **  SIDE EFFECTS:* **
 **      None.i ** **-- */ u_char deviceInit( void )i {uF     u_char  devFound;   /* TRUE if the device found                 */F     ASNUCB  *ucbPtr;    /* pointer to device's unit control block   */F     u_int   status;    /* status returned from GetUCB function      */  @    status = deviceGetUCB( ASN0, strlen(ASN0), (UCB **)&ucbPtr );    if ( status == SS$_NORMAL )    {         devFound = TRUE;  D        /* save pointers to the createPort and deletePort routines */9        devInfo.createPort = ucbPtr->ucb$l_asn_createport; 9        devInfo.deletePort = ucbPtr->ucb$l_asn_deleteport;"     }.     else     {  	devFound = FALSE; 	devInfo.createPort = NULL;*&       	devInfo.deletePort = NULL;          }M       return (devFound); }    f /* **++ **  FUNCTION NAME: ** **      deviceOpen ** **  FUNCTIONAL DESCRIPTION:i **J **      Open a connection to the async. device.   All this routine does isK **      to call the createPort routine as the vcib will have been setup by E  **      the managment routines.  ** **  FORMAL PARAMETERS: **, **      line    Identifier for the PPP line. ** **  IMPLICIT INPUTS: **K **      devInfo    Structure containing the async drivers' create port rtn.* ** **  IMPLICIT OUTPUTS:* **
 **      None.f **& **  function value or completion codes **7 **      SS$_NORMAL        Successfully opened device   o6 **      SS$_DEVALLOC      The device is already in use7 **      SS$_NOSUCHDEV     The device is not avavailable 4 **      SS$_IVDEVNAM      The device name is invalidA **      SS$_DEVOFFLINE    The create/deleteport routines are NULLA@ **      SS$_DEVREQERR     Unexpected error returned by device    ** **  SIDE EFFECTS:t **
 **      None.i ** **-- */ u_int deviceOpen( lineId line )e {uB     u_int  status;  /* function return code                     */B     ASNVCIB *vcib;  /* pointer to vcib for the device           */     %     vcib = &(LINE_ENTRY(line)->vcib);a  B     /* get a pointer to the UCB for the ASN: device in the line */p    status = deviceGetUCB( LINE_ENTRY(line)->comPort, LINE_ENTRY(line)->comPortLen, (UCB **)&vcib->VCIBAsnUCB );   "     /* call create port routine */#     if ( status == SS$_NORMAL )          {n&         /* check device initialised */)         if ( devInfo.createPort != NULL ) 	         {t5 	    status = VCICreate( devInfo.createPort,  vcib );T 	} 	else  	{ 	    status = SS$_DEVOFFLINE;l 	}     }e     !     if ( status != SS$_NORMAL && y 	 status != SS$_DEVALLOC &&  	 status != SS$_NOSUCHDEV && * 	 status != SS$_DEVOFFLINE &&  	 status != SS$_IVDEVNAM )     {  	status = SS$_DEVREQERR;     }/          return ( status ); }      /* **++ **  FUNCTION NAME: ** **      deviceReceivee ** **  FUNCTIONAL DESCRIPTION:o **L **      This rouitne is used to process a packet received on the asynchonousJ **      device.  The asychronous device will have unquoted the packet and I **      checked and removed the FCS.  This routine removes the PPP header*O **      in packet and passes the packet onto either the ports or state machine,c3 **      depending on the protocol, to be processed.C ** **  FORMAL PARAMETERS: **B **      vcib    Pointer to the vcib that the packet was recived on< **      buf     Pointer to the buffer containing the packet. ** **  IMPLICIT INPUTS: **
 **      None.i ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.i ** **  SIDE EFFECTS:q **
 **      None.m ** **-- */  : void deviceReceive( struct VCIBDEF *vcib, PPPBuffer *buf ) {$A     u_short protocol;		/* protocol type in packet              */)@     fsm     *lcpFsm;		/* fsm for the line                     */A     PPPLine *linePtr;		/* pointer to the line packet rcvd on   */II     int     processed = FALSE;	/* TRUE if pkt handled by protocol rtn  */*@     u_int   dataLen;		/* length of data in packet             */D     int     pktOK = TRUE;	/* TRUE if this is a vlaid PPP packet   */G     lcp_options *go;	        /* options we agreed with peer          */T?     u_char  *dataP;		/* pointer to data in packet            */M       linePtr = (PPPLine *)vcib;	 !     lcpFsm  = &(linePtr->lcpFsm); "     dataLen = BUF_DATA_LEN( buf );&     dataP   = BUF_DATA_PTR( buf );    -     go      = &(LCP_GOTOPTIONS(linePtr->id));   7     /* check bufffer to see if it has an error in it */ 3     if ( buf->vcrp$l_request_status == SS$_NORMAL )r     {D& 	/* Verify and remove address field */  	if ( dataLen && pktOK == TRUE ) 	{ 	    /* 3 	     ** If first byte isn't PPP control byte then c. 	     ** address compression must be in effect 	     */% 	    if ( *dataP != PPP_ALLSTATIONS )  	    { 		if ( !go->neg_accompression )G 		{F 		    pktOK = FALSE; 		}  	    }	 	    elseN 	    { 		/* Next byte should be UI */, 		if ( dataLen < 2 || *(dataP+1) != PPP_UI ) 		{B 		    pktOK = FALSE; 		}v 		else 		{  		    dataP   +=2; 		    dataLen -=2;? 		    BUF_DATA_TRIM( buf, 2 ); /* remove addr/control fields */d 		}e 	    } 	     + 	    /* Verify and remove protocol field */ $ 	    if ( dataLen && pktOK == TRUE ) 	    { 		/*  3 		 ** If last bit is set then protocol compression s 		 ** is in effect 		 */o 		if ( *dataP & 1 )  		{ ! 		    if ( go->neg_pcompression )M 		    {T 			GETCHAR( protocol, dataP ); 			protocol &= 0xff;
 			dataLen--;C7 			BUF_DATA_TRIM( buf, 1 ); /* remove protocol field */  		    } 
 		    else 		    {u 			pktOK = FALSE;			     		    }* 		}  		else 		{a' 		    /* Usual 2 byte protocol field */e* 		    if ( dataLen < 2 || *(dataP+1) & 0 ) 		    {  			pktOK = FALSE;S 		    }*
 		    else 		    {- 			GETSHORT( protocol, dataP );i 			dataLen -= 2;;t7 			BUF_DATA_TRIM( buf, 2 ); /* remove protocol field */  		    }V 		}v 	    } 	      	    /* 6 	     ** Pass the packet onto the appropriate routine 6 	     ** for processing according to the protocol type 	     */$ 	    if ( dataLen && pktOK == TRUE ) 	    { 		if ( protocol == PPP_LCP ) 		{ 7 		    fsm_input( lcpFsm, BUF_DATA_PTR(buf), dataLen ); V 		}l 		else C 		{t1 		    /* only pass packet on if LCP is running */r$ 		    if ( lcpFsm->state == OPENED ) 		    {a 			/* protocol packet ? */ 			if ( protocol < 0x8000 )  			{1 			    processed = VCIReceive( linePtr->id, buf, I 						    protocol );e 			}! 			/* control protcol packet ? */N  			else if ( protocol < 0xc000 ) 			{4 			    processed = fsm_data( linePtr->id, protocol, $ 						 BUF_DATA_PTR(buf), dataLen ); 			} 			/* 7 			 ** If the packet wasn't processed this means there n7 			 ** isn't a port trying to use this protocol at the  9 			 ** moment.  If the protocol isn't registed then send t8 			 ** a protocol reject as it's not supported.  If the 4 			 ** protocol is registered then just discard the  			 ** packet. 			 */ 			if ( !processed && 1 			     !fsm_isNCPRegistered(protocol | 0x8000) )p 			{- 			    /* restore protocol field to packet */O! 			    BUF_DATA_EXPAND( buf, 2 );*# 			    dataP = BUF_DATA_PTR( buf );e# 			    PUTSHORT( protocol, dataP );  			    N' 			    /* send out the reject packet */ 0 			    fsm_sdata( lcpFsm, PROTREJ, ++lcpFsm->id,1 				      BUF_DATA_PTR(buf), BUF_DATA_LEN(buf) );  			} 		    }t! 		} /* end-if protocol == LCP */	  	    } /* end-if pktOK */  	} /* end-if packetLen */o(     } /* end-if buf->l_request_status */       /*  :      ** Free the packet if it wasn't a protocol packet or       ** it wasn't processed       **/.     if ( !(protocol < 0x80000) || !processed )     {  	BUF_DEALLOC( buf );     }  	      return;/ }  n /* **++ **  FUNCTION NAME: ** **      deviceSetChar  ** **  FUNCTIONAL DESCRIPTION:; **D **      This routine is sued to notify the asynch. device of certain1 **      line characteristics which have been set.  ** **  FORMAL PARAMETERS: **, **      line    Identifier for the PPP line. ** **  IMPLICIT INPUTS: **
 **      None.H ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **A **      TRUE     The characteristics have been set in the device.tA **      FALSE    Failed to set the characteristics in the device.a ** **  SIDE EFFECTS:( **
 **      None.a ** **-- */! char deviceSetChar( lineId line )m {	E     struct  vcrpdef *setReq;	  /* vcrp to build disable in         */f;     ASNVCIB *vcib;	  /* pointer to vcib for the device   */pH     char    setSucceeded = FALSE; /* TRUE if deviceSetChar succeeded  */@     void    *itemList;		  /* pointer to itemlist for set call */B     char    itemListSize;	  /* size of itmelist                 */?     qioItem *itemPtr;		  /* pointer to a QIO item            */   %     vcib = &(LINE_ENTRY(line)->vcib);      MGMT_BUF_ALLOC( setReq );      if ( setReq != NULL )c     {l 	/* 6 	 ** Allocate a buffer to build the "set" itemlist in.5 	 ** The async. driver doesn't use network itemlists u7 	 ** as is usual for VCI, but uses QIO style itemlists. 4 	 ** We need to specify 4 items for the set, so this+ 	 ** determines the size of the itemlist.  t 	 */ 	 $ 	itemListSize = 4 * sizeof(qioItem);- 	ALLOC_MEM( itemList, itemListSize, void * );c 	if ( itemList != NULL ) 	{0 	    /* construct the list of items to be set *// 	    itemPtr             = (qioItem *)itemList;n  ) 	    itemPtr->code       = ASN$_ACCM_RCV;l 	    itemPtr->len        = 4; 9 	    itemPtr->data.value = LCP_GOTOPTIONS(line).asyncmap;: 	    itemPtr->retAddr    = 0;* 	    itemPtr++;R  * 	    itemPtr->code       = ASN$_ACCM_XMIT; 	    itemPtr->len        = 32;4 	    itemPtr->data.addr  = LINE_ENTRY(line)->txAccm; 	    itemPtr->retAddr    = 0;o 	    itemPtr++;b  $ 	    itemPtr->code       = ASN$_MRU; 	    itemPtr->len        = 4;n4 	    itemPtr->data.value = LCP_GOTOPTIONS(line).mru; 	    itemPtr->retAddr    = 0;: 	    itemPtr++;I  $ 	    itemPtr->code       = ASN$_MTU; 	    itemPtr->len        = 4; 4 	    itemPtr->data.value = LCP_HISOPTIONS(line).mru; 	    itemPtr->retAddr    = 0;*  3 	    setReq->vcrp$a_input_list          = itemList;s7 	    setReq->vcrp$t_mgmt_information[0] = itemListSize;s8 	    setReq->vcrp$l_function            = VCRP$K_FC_SET;  , 	    /* call driver routine to set values */7 	    VCICall( vcib->VCIBPortmgmtSynch, setReq, vcib );  7 	    if ( setReq->vcrp$l_request_status == SS$_NORMAL )  	    { 		setSucceeded = TRUE; 	    } 	    DEALLOC_MEM( itemList );  	} /* end-if itemList */ 	MGMT_BUF_DEALLOC( setReq );     } /* end-if setReq */        return (setSucceeded); }    n /* **++ **  FUNCTION NAME: ** **      deviceTransmit ** **  FUNCTIONAL DESCRIPTION:  **J **      This routine is used to build a PPP packet and transmit it on the  **      asynch device.   **J **      NOTE: we are guaranteed to be passed a buffer that has enough roomK **            in it for the largest possible PPP header.  The routine does L0 **            not check this requirement is met. ** **  FORMAL PARAMETERS: **/ **     line        Identifier for the PPP line.e< **     protocol    Protocol number of the packet to be sent.? **     buf         Pointer to the buffer containing the packet.  ** **  IMPLICIT INPUTS: **
 **      None.b ** **  IMPLICIT OUTPUTS:  **
 **      None.n **& **  function value or completion codes **
 **      None.d ** **  SIDE EFFECTS:n **
 **      None.T ** **-- */D void deviceTransmit( lineId line, u_short protocol, PPPBuffer *buf ) {n<     int          retCode;  /* function return code        */=     lcp_options *ho;	   /* options peer is using       */     <     ASNVCIB     *devVcib;  /* pointer to device vcib      */<     u_char      *dataP;	   /* pointer to data in buffer   */       ho = &LCP_HISOPTIONS(line);V          /* append protocol field */ 2     if ( ho->neg_pcompression && protocol < 0xff )     {e 	BUF_DATA_EXPAND( buf, 1 );  	dataP = BUF_DATA_PTR(buf);  	PUTCHAR( protocol, dataP ); C     }*     else     {  	BUF_DATA_EXPAND( buf, 2 );n 	dataP = BUF_DATA_PTR(buf);n 	PUTSHORT( protocol, dataP );c     }   &     /* append address/control field */8     if ( !ho->neg_accompression || protocol == PPP_LCP )     {L 	BUF_DATA_EXPAND( buf, 2 );  	dataP = BUF_DATA_PTR(buf); # 	PUTCHAR( PPP_ALLSTATIONS, dataP );  	PUTCHAR( PPP_UI, dataP );     }l     @     /* push protocol onto context stack - used for completion */0     BUF_PUSH( buf, protocol, sizeof(protocol) );  (     /* call device's transmit routine */.     buf->vcrp$l_function = VCRP$K_FC_TRANSMIT;(     devVcib = &(LINE_ENTRY(line)->vcib);;     VCICall( devVcib->VCIBTransmitInitiate, buf, devVcib );e       return;s }u   S /* **++ **  FUNCTION NAME: ** **      deviceTransmitCompl  ** **  FUNCTIONAL DESCRIPTION:  **L **      This routine handles the notification that a transmit has completed.G **      Processing is simple, if this was a protocol packet it's passedsF **      back to the port; otherwise the packet is freed as the control8 **      protocols don't care about transmits completing. ** **  FORMAL PARAMETERS: **6 **      vcib    Pointer to vcib transmit completed on.D **      buf     Pointer to the buffer containing transmitted packet. ** **  IMPLICIT INPUTS: **
 **      None.P ** **  IMPLICIT OUTPUTS:e **
 **      None.c **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:p **
 **      None.  ** **-- */? void deviceTransmitCmpl( struct VCIBDEF *vcib, PPPBuffer *buf )  {iA     u_short protocol; /* protocol number of completed transmit */.  3     BUF_POP( buf, protocol, sizeof(protocol) );          if ( protocol < 0x8000 )     {  	VCITransmitCompl( buf );      }i     else     {  	BUF_DEALLOC((buf));     }C       return;  }o  