I /************************************************************************ I **                                                                      * I ** Copyright  1996 Digital Equipment Corporation.                      * I ** All rights reserved.                                                 * I **                                                                      * I ** Redistribution and use in source and binary forms are permitted      * I ** provided that the above copyright notice and this paragraph are      * I ** duplicated in all such forms and that any documentation,             * I ** advertising materials, and other materials related to such           * I ** distribution and use acknowledge that the software was developed     * I ** by Digital Equipment Corporation.  The name of the                   * I ** Corporation may not be used to endorse or promote products derived   * I ** from this software without specific prior written permission.        * I ** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       * I ** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       * I ** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * I **                                                                      * I *************************************************************************  **++
 **  FACILITY:  ** **      ppp_mgmt.c **
 **  ABSTRACT:  **B **      This module implements routines required to implement the % **      management of the PPP module.  **       ** **  AUTHORS: **; **      Patrick Crilly,   Networks Engineering (Australia).  ** **  CREATION DATE: ** **      4-December-1996  ** **  MODIFICATION HISTORY:  **, **      17-December-1996  Barry W. KiersteinF **                        Replaced the standard Digital copyright with@ **                        one compatible with the CMU copyright. **+ **      4-Decemebr-1996   Original version.  ** **-- */   /* ** Include files */   /* ** ** import definitions: **        SS$_xxx  ** */ #ifndef __SSDEF_LOADED #include "ssdef.h" #endif   /* ** ** import definitions: **        $DESCRIPTOR  ** */ #ifndef __DESCRIP_LOADED #include "descrip.h" #endif   /* ** ** import definitions: **        PPPLine  ** */ #ifndef _LCP_VMS_H_  #include "lcp_vms.h" #endif   /* ** ** import definitions: **        fsm_init ** */ #ifndef _FSM_VMS_H_  #include "fsm_vms.h" #endif   /* ** ** import definitions: **        ppp vcib defines ** */ #ifndef _PPP_VCIB_H_ #include "ppp_vcib.h"  #endif   /* ** ** import definitions: **        device routines  ** */ #ifndef _PPP_ASYNC_H_  #include "ppp_async.h" #endif   /* ** ** import definitions: **        magic  ** */ #ifndef _MAGIC_H_  #include "magic.h" #endif   /* ** ** import definitions: **        DYN$C_DECNET **        DYN$C_NET_ITEM **        DYN$C_NET_VCI_VCIB ** */ #ifndef __DYNDEF_LOADED  #include "dyndef.h"  #endif   /* ** ** import definitions: **        SPL$C_IOLOCK8  ** */ #ifndef __SPLCODDEF_LOADED #include "splcoddef.h" #endif   /* ** ** import definitions: **        item tags  ** */ #ifndef _PPP_MGMT_IF_H_  #include "ppp_mgmt_if.h" #endif   /* ** ** import definitions:/ **        prototypes for this module's routines  ** */ #ifndef _PPP_MGMT_H_ #include "ppp_mgmt.h"  #endif   /*	 ** Macros  */  K #define EXTRACT_INT( itemP, value ) ((value) = *(u_int *)(itemP->ITEMdata)) . #define EXTRACT_STR( itemP, string, length ) \ { \ ,     if ( item->ITEMlength - ITEM_HDR_SIZE) \     { \ L         BCOPY( itemP->ITEMdata, string, item->ITEMlength - ITEM_HDR_SIZE); \6         (length) = item->ITEMlength - ITEM_HDR_SIZE; \     } \ 
     else \     { \          (length) = 0; \      } \  }    /* ** Global variables  */   static parseItem mgmtItems[] = { <    LONG_SIZE, LONG_SIZE,	        /* PPPD$K_DEBUG          */C    MIN_STRING_SIZE, MAX_STRING_SIZE,    /* PPPD$K_DEBUG_MBX      */ @    MIN_STRING_SIZE, MAX_STRING_SIZE,	/* PPPD$K_COM_PORT       */5    LONG_SIZE, LONG_SIZE,		/* PPPD$K_RX_ACCM        */ @    LONG_SIZE, 8 * LONG_SIZE,	        /* PPPD$K_TX_ACCM        */5    LONG_SIZE, LONG_SIZE,		/* PPPD$K_MRU            */ 5    LONG_SIZE, LONG_SIZE,		/* PPPD$K_MTU            */ 5    LONG_SIZE, LONG_SIZE,		/* PPPD$K_MODE           */ 5    LONG_SIZE, LONG_SIZE,		/* PPPD$K_LINE_TYPE      */ 5    LONG_SIZE, LONG_SIZE,		/* PPPD$K_MAX_CONFIGURE  */ 5    LONG_SIZE, LONG_SIZE,		/* PPPD$K_MAX_FAILURE    */ 5    LONG_SIZE, LONG_SIZE,		/* PPPD$K_MAX_TERMINATE  */ 5    LONG_SIZE, LONG_SIZE,		/* PPPD$K_AC_COMPRESS    */ 5    LONG_SIZE, LONG_SIZE,		/* PPPD$K_PROTO_COMPRESS */ 5    LONG_SIZE, LONG_SIZE,		/* PPPD$K_FCS_RX         */ 6    LONG_SIZE, LONG_SIZE,		/* PPPD$K_FCS_TX         */ 6    LONG_SIZE, LONG_SIZE,		/* PPPD$K_MAGIC_RETRIES  */ 6    LONG_SIZE, LONG_SIZE,		/* PPPD$K_RESTART_TIMER  */ 6    LONG_SIZE, LONG_SIZE,		/* PPPD$K_ECHO_INTERVALS */ 6    LONG_SIZE, LONG_SIZE,		/* PPPD$K_ECHO_FAILURE   */  };  @ #define NUM_MGMT_ITEMS     (sizeof(mgmtItems)/sizeof(parseItem))   mgmtRtns mgmtVector =  {      mgmtCreateLine,      mgmtDeleteLine,      mgmtDisableLine,     mgmtEnableLine,      mgmtGetLineId,     mgmtSetLine,     mgmtShowLine };     /* **++ **  FUNCTION NAME: ** **      mgmtAllocItemList  ** **  FUNCTIONAL DESCRIPTION:  **4 **      This functions allocates a network itemlist. ** **  FORMAL PARAMETERS: **H **      size    The size of the item list to allocate (not including the" **              item list header). ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes *** **      Pointer to the itemlist allocated.1 **      NULL if an itemlist couldn't be allocated  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */) ItemList *mgmtAllocItemList( u_int size )  { @     ItemList *itmlp = NULL;	/* pointer to allocated item list */     >     ALLOC_MEM( itmlp, size + ITEMLIST_HDR_SIZE , ItemList * );     if ( itmlp )     { 0 	itmlp->ITEMLsize    = size + ITEMLIST_HDR_SIZE; 	itmlp->ITEMLlength  = 0; + 	itmlp->ITEMLaddress = itmlp->ITEMLentries; $ 	itmlp->ITEMLtype    = DYN$C_DECNET;& 	itmlp->ITEMLsubtype = DYN$C_NET_ITEM;     }      return (itmlp);  }      /* **++ **  FUNCTION NAME: ** **      mgmtAppendItem ** **  FUNCTIONAL DESCRIPTION:  **L **      This function appends an item to an itemlist.   This routine checks O **      there is enough room left in the item list for the item to be appended. > **      The item will not be added if there isn't enough room. ** **  FORMAL PARAMETERS: **( **     list     Pointer to the itemlist  **     tag      Item tag' **     len      Length of the item data ( **     value    Pointer to the item data ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **8 **      Amount of free space remaining in the item list.C **      If there isn't enough room for the item to be appended this  **      value will be negative.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */  C int mgmtAppendItem( ItemList *list, int tag, int len, void *value )  {    ItemEntry *nextItem;   int        freeSpace;   0   /* determine where next item can go in list */M   nextItem   = (ItemEntry *)((char *)list->ITEMLaddress + list->ITEMLlength); =   freeSpace  = (int) ((char *)list + (int)list->ITEMLsize) -  :            (int)((char *)nextItem + len + ITEM_HDR_SIZE );      /* copy in the item */   if ( freeSpace >= 0 )    { 1       nextItem->ITEMlength = len + ITEM_HDR_SIZE; !       nextItem->ITEMtag    = tag; .       BCOPY( value, nextItem->ITEMdata, len );1       list->ITEMLlength += (len + ITEM_HDR_SIZE);    }       return (freeSpace);  }      /* **++ **  FUNCTION NAME: ** **      mgmtCreateLine ** **  FUNCTIONAL DESCRIPTION:  **H **      This function creates and initialises a PPP line.  This functionK **      requires that the lineName argument is NOT NULL and the lineNameLen  **      is non-zero. **J **      NOTE: for asynchronous devices the name of the line corresponds to7 **            the physical device being used e.g. TTA1:  ** **  FORMAL PARAMETERS: **D **      id             Identifier of of the created line  - returned0 **      lineName       Name to give the PPP line4 **      lineNameLen    Length of the lineName string ** **  IMPLICIT INPUTS: **- **      lineTbl    The global array of lines.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **- **      SS$_NORMAL      Successful completion C **      SS$_INSFMEM     Insufficient memory to create a PPP line or > **                      no more room in global array of lines.A **      SS$_DEVALLOC    A PPP line with "lineName" already exists  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */E u_int mgmtCreateLine( lineId *id, char *lineName, u_int lineNameLen )  { ;     u_int   status; /* function return code              */ ;     PPPLine *line;  /* pointer to line                   */ ;     u_short  ref;   /* reference part of line identifier */ ;     int      index; /* loop variable                     */           /*F      ** Check to see if line with the required name is already in use.      */ 8     status = mgmtGetLineId( id, lineName, lineNameLen );"     if ( status == SS$_NOSUCHDEV )     { * 	/* find a free entry in the line table */ 	for ( index = 0; < 	      index < MAX_LINES && lineTbl[index].linePtr != NULL;  	      index++ ) 	  	    ; 	if ( index < MAX_LINES )  	{3 	    ALLOC_MEM( line, sizeof(PPPLine), PPPLine * );  	    if ( line != NULL ) 	    { 		/* save line in table */  		lineTbl[index].linePtr = line;0 		ref = (lineTbl[index].id >> LINEREFSHIFT) + 1;4 		lineTbl[index].id = (ref << LINEREFSHIFT) | index;( 		*id               = lineTbl[index].id; 		! 		/* initialise line structure */ ! 		BZERO( line, sizeof(PPPLine) ); 1 		line->state                              = Off; 7 		line->type                               = Transient; 1 		line->id                                 = *id; 3 		line->delete                             = FALSE;*3 		line->devClosed                          = FALSE; 3 		line->devFail                            = FALSE;*2 		line->ports                              = NULL;- 		BCOPY( lineName, line->name, lineNameLen ); 9 		line->nameLen                            = lineNameLen; 3 		line->debug                              = FALSE; / 		line->debugMbxLen                        = 0;n/ 		line->debugMbxUCB                        = 0; / 		line->comPortLen                         = 0;h< 		line->maxConfigure                       = DEFMAXCONFREQS;< 		line->maxFailure                         = DEFMAXNAKLOOPS;< 		line->maxTerminate                       = DEFMAXTERMREQS;0 		line->restartTimer                       = 30;8 		line->txAccm[0]                          = 0xffffffff;8 		line->txAccm[3]                          = 0x60000000; 		& 		/* initialise lcp options we want *// 		line->lcp_wantoptions.neg_mru            = 1;n/ 		line->lcp_wantoptions.neg_asyncmap       = 1;D/ 		line->lcp_wantoptions.neg_magicnumber    = 1; / 		line->lcp_wantoptions.neg_pcompression   = 1;I/ 		line->lcp_wantoptions.neg_accompression  = 1;N4 		line->lcp_wantoptions.mru                = DEFMRU;8 		line->lcp_wantoptions.asyncmap           = 0xffffffff;5 		line->lcp_wantoptions.magicnumber        = magic();*/ 		line->lcp_wantoptions.numloops           = 5;I  9 		/* initialise lcp options we allow peer to negotiate */ / 		line->lcp_allowoptions.neg_mru           = 1;l/ 		line->lcp_allowoptions.neg_asyncmap      = 1; / 		line->lcp_allowoptions.neg_magicnumber   = 1; / 		line->lcp_allowoptions.neg_pcompression  = 1; / 		line->lcp_allowoptions.neg_accompression = 1; 4 		line->lcp_allowoptions.mru               = DEFMRU;/ 		line->lcp_allowoptions.asyncmap          = 0;  		8 		/* set default options for actual negotiated values */4 		line->lcp_gotoptions.mru                 = DEFMRU;8 		line->lcp_gotoptions.asyncmap            = 0xffffffff;4 		line->lcp_hisoptions.mru                 = DEFMRU;< 		line->lcp_hisoptions.asyncmap            = 0xffffffff;       		/* initialise device vcib */= 		line->vcib.VCIBSize                      = sizeof(PPPLine); @ 		line->vcib.VCIBType                      = DYN$C_NET_VCI_VCIB;? 		/* line->vcib.VCIBVciId                     = VCI$K_ID_PP; */VG 		line->vcib.VCIBTransmitComplete          = (int *)deviceTransmitCmpl;*B 		line->vcib.VCIBReceiveComplete           = (int *)deviceReceive;A 		line->vcib.VCIBReportEvent               = (int *)deviceHangup;n   		/* initialise fork block */ 7 		line->frkBlck.fkb$b_type                 = DYN$C_FRK;i; 		line->frkBlck.fkb$b_flck                 = SPL$C_IOLOCK8;C    		status = SS$_NORMAL;"  	    } /* end-if line != NULL */	 	    else* 	    { 		status = SS$_INSFMEM;M 	    }	 ! 	} /* end-if index < MAX_LINES */* 	elsep 	{ 	    status = SS$_INSFMEM; 	}     } /* end-if GetLineId */       else     {E 	status = SS$_DEVALLOC;e     }D     return ( status ); }f     /* **++ **  FUNCTION NAME: ** **      mgmtDeallocItemListK ** **  FUNCTIONAL DESCRIPTION:O **6 **      This functions deallocates a network itemlist. ** **  FORMAL PARAMETERS: **' **      list    Pointer to the itmelistu ** **  IMPLICIT INPUTS: **
 **      None.r ** **  IMPLICIT OUTPUTS:r **
 **      None.o **& **  function value or completion codes **
 **      None.g ** **  SIDE EFFECTS:* **
 **      None.f ** **-- */* void mgmtDeallocItemList( ItemList *list ) {I     DEALLOC_MEM( list );     return;  }i   e /* **++ **  FUNCTION NAME: ** **      mgmtDeleteLine ** **  FUNCTIONAL DESCRIPTION:P **H **      This routine is used to delete a PPP line.   The line must be in- **      be in the "Off" state to be deleted.   ** **  FORMAL PARAMETERS: ** **      id    Line indentifier ** **  IMPLICIT INPUTS: **
 **      None.m ** **  IMPLICIT OUTPUTS:_ **
 **      None.  **& **  function value or completion codes **: **      SS$_NORMAL       The line was successfully deleted6 **      SS$_DEVACTIVE    The line is in the "On" state7 **      SS$_IVCHAN       The line identifier is invalid* ** **  SIDE EFFECTS:O **
 **      None.  ** **-- */  ! u_int mgmtDeleteLine( lineId id )	 {PL     u_int   status = SS$_NORMAL; /* function return code - assume success */       if ( LINEID_VALID(id) )*     {_$ 	if ( LINE_ENTRY(id)->state == Off ) 	{ 	    /* ;              ** If device closed remove line from table of A< 	     ** lines otherwise mark it for delete.  The completion0              ** of the shut will delete the line 	     */,             if ( LINE_ENTRY(id)->devClosed )             {      	        lcp_deleteLine( id ); 	    }	 	    else 
             { +             	LINE_ENTRY(id)->delete = TRUE;L
             }S 	} 	elseP 	{ 	    status = SS$_DEVACTIVE; 	}     } /* end-if line valid */R	     else       {I 	status = SS$_IVCHAN;$     }R          return ( status ); }S   	 /* **++ **  FUNCTION NAME: ** **      mgmtDisableLineP ** **  FUNCTIONAL DESCRIPTION:d **J **      This routine puts the PPP line into a state where it can no longerJ **      be used.  It stops any protocols and controls protocols running onJ **      over the PPP line.   If the line is already in an "Off" state then **      no action is taken.  ** **  FORMAL PARAMETERS: ** **      id    Line identifierN ** **  IMPLICIT INPUTS: **
 **      None.a ** **  IMPLICIT OUTPUTS:. **
 **      None.R **& **  function value or completion codes **0 **      SS$_NORMAL    The line has been disabled8 **      SS$_IVCHAN    The line identifier is invalid     ** **  SIDE EFFECTS:M **
 **      None.* ** **-- */" u_int mgmtDisableLine( lineId id ) {n/     u_int    status; /* function return code */a/     PPPLine *line;   /* pointer to line      */o       if ( LINEID_VALID(id) )      {  	line = LINE_ENTRY(id);  	if ( line->state != Off ) 	{ 	    /* 1 	     ** Tell ports the someone doesn't want the o 	     ** line to be used.  	     */% 	    VCIMgmtEvent( id, MgmtDisable );e 	      	    /* % 	     **  Close the state machine.     	     */ 	    lcp_close( id );m  T             /* The close can cause the line to be deleted - check the id is valid */%             if ( LINEID_VALID( id ) )e
             {E 	        lcp_shutLine( id );	  	        line->state = Off;C
             }  	} 	  	status = SS$_NORMAL;        } /* end-if line valid */ 	     else n     {p 	status = SS$_IVCHAN;m     }           return ( status ); }r   e /* **++ **  FUNCTION NAME: ** **      mgmtEnableLine ** **  FUNCTIONAL DESCRIPTION:e **G **      This routine is used to put a PPP line in a state where it can sI **      be used.  The "comPort" field of the line must be non-NULL or theeH **      enable will fail.  If the line is in the "On" state no action is **      taken. **L **      NOTE:  This function does not start LCP on the line.  LCP is started5 **             by a protocol wanting to use the line.r ** **  FORMAL PARAMETERS: ** **      id    line identifiero ** **  IMPLICIT INPUTS: **
 **      None.* ** **  IMPLICIT OUTPUTS:e **
 **      None.F **& **  function value or completion codes **3 **      SS$_NORMAL       The line has been disabledd; **      SS$_IVCHAN       The line identifier is invalid    eC **      SS$_DEVREQERR    The communications port couldn't be opened=I **      SS$_INSFARG      The communications port has been set in the linecL **      SS$_DEVALLOC     The communications port is in use by another entity ** **  SIDE EFFECTS:H **
 **      None.* ** **-- */  ! u_int mgmtEnableLine( lineId id )  { <     u_int    status = SS$_NORMAL; /* function return code */<     PPPLine *line;                /* pointer to line      */       if ( LINEID_VALID(id) )t     {e 	line = LINE_ENTRY(id);  	if ( line->state == Off ) 	{4 	    /* check a com port has been set in the line */! 	    if ( line->comPortLen != 0 )R 	    {' 		/* open a connection to the device */n 		status = deviceOpen( id ); 		if ( status == SS$_NORMAL )h 		{e+ 		    /* initalise the lcp state machine */ 3 		    fsm_init( &line->lcpFsm, id, NULL, PPP_LCP );o  	 		    /* t> 		     ** Fill in fsm unit and line fields.  Normally the fsm D                      ** routines do this but we need to do this here9                      ** because lcp is special case NCP. d 	             */,                      line->lcpFsm.unit = id;,                      line->lcpFsm.line = id;                   + 		    /* inform any ports hanging around */l% 		    VCIMgmtEvent( id, MgmtEnable );  		     		    line->state = On;v 		    status = SS$_NORMAL; 		}  	    } /* end-if comPortLen */	 	    else  	    { S 		status = SS$_INSFARG;t 	    } 	} /* end-if state == Off */	      } /* end-if line valid */i	     else r     {i 	status = SS$_IVCHAN;L     }           return ( status ); }e     /* **++ **  FUNCTION NAME: ** **      mgmtGetLineId/ ** **  FUNCTIONAL DESCRIPTION:d **J **      This function retruns the line identifier of for a given line nameJ **      This function requires that the lineName argument is NOT NULL and $ **      the lineNameLen is non-zero. ** **  FORMAL PARAMETERS: **< **      id             Identifier of of the line  - returned3 **      lineName       Name of the PPP line to findh4 **      lineNameLen    Length of the lineName string ** **  IMPLICIT INPUTS: **- **      lineTbl    The global array of lines.C ** **  IMPLICIT OUTPUTS:f **
 **      None.n **& **  function value or completion codes **, **      SS$_NORMAL        The line was found/ **      SS$_NOSUCHDEV    The line doesn't existI ** **  SIDE EFFECTS:M **
 **      None.P ** **-- */D u_int mgmtGetLineId( lineId *id, char *lineName, u_int lineNameLen ) {iG     u_int    status = SS$_NOSUCHDEV; /* return code - be a pessimist */ ;     PPPLine *line;		     /* pointer to line              */	<     int      index;		     /* loop variable                */  1     /* check lineName is not NULL and non-zero */ /     if ( lineName != NULL && lineNameLen != 0 )      {e          /* find matching line */5         for ( index = 0; index < MAX_LINES; index++ ) 	         { # 	    line = lineTbl[index].linePtr; 3 	    if ( line != NULL && line->delete == FALSE &&  J 	         !strncmp(line->name, lineName, MIN(line->nameLen, lineNameLen))) 	    { 	        status = SS$_NORMAL;=$ 	        *id    = lineTbl[index].id; 	        break; /* exit loop */  	    }         } /* end-for index */n     } /* end-if lineName */      else     {= 	status = SS$_IVDEVNAM;x     }      return( status );n }	   > /* **++ **  FUNCTION NAME: ** **      mgmtNextItem ** **  FUNCTIONAL DESCRIPTION:h **K **      This item returns a pointer to the next item in an item list, with e) **      the search starting at curItem_p.  ** **  FORMAL PARAMETERS: *** **      itml_p       Pointer to itemlist. J **      curItem_p    Pointer to item in list to commence search at - NULL G **                   indicates to commence at start of list.  On return;1 **                   will point to returned item.e ** **  IMPLICIT INPUTS: **
 **      None.	 ** **  IMPLICIT OUTPUTS:s **
 **      None.  **& **  function value or completion codes ** **      Pointer to item.& **      NULL if no more items in list. ** **  SIDE EFFECTS:s **
 **      None.> ** **-- */B ItemEntry *mgmtNextItem( ItemList *itml_p, ItemEntry **curItem_p ) { <     ItemEntry  *item_p;	/* pointer to next item in list   */:     char       *curr;	/* address of item to be returned */<     char       *last;   /* addres of end of item list     */          if ( *curItem_p == NULL )      {= 	/* check list isn't empty */n 	if ( itml_p->ITEMLlength )e 	{' 	    *curItem_p = itml_p->ITEMLaddress;	 	} 	return( *curItem_p );     }s     $     /* point current to next Item */E     curr    = (char *)(*curItem_p) + (int)((*curItem_p)->ITEMlength); F     last    = (char *)itml_p->ITEMLaddress + (int)itml_p->ITEMLlength;     1     /* Is the current item still in this list? */t8     if ( (unsigned long)(curr) < (unsigned long)(last) )     {a 	item_p = (ItemEntry *)curr; 	*curItem_p = item_p;u     }      else     {;4 	item_p = ( (ItemEntry *)NULL );	/* no more items */     }        return ( item_p ); }i     /* **++ **  FUNCTION NAME: ** **      mgmtParseItemList  ** **  FUNCTIONAL DESCRIPTION:  **I **      This function checks an itemlist is valid i.e. that all the items J **      in the list had valid tags and that the size of the item is valid.N **      The tbl parameter is an array containing the mimimum and maximum size : **      of each item.  The array is indexed by item tag.   ** **  FORMAL PARAMETERS: **? **      list           Pointer to the item list to be validatedCK **      tbl            Table of supported items and their min and max sizesa= **      numItems       The number of items in the parse table*K **      qual           Contains the tsg of the invalid item if the list is * **                     invalid ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **' **      TRUE     The item list is validlL **      FALSE    The item list contains an invalid item code or an item with& **               an incorrect length.  ** **  SIDE EFFECTS:* **
 **      None.e ** **-- */G char mgmtParseItemList( ItemList *list, parseItem tbl[], int numItems, U 		        u_int *qual )  { N     ItemEntry *item = NULL;    /* pointer to current item in input list     */N     ItemEntry *itemCtx = NULL; /* pointer to last processed item in list    */N     char validList = TRUE;     /* TRUE if the list and item codes are valid */  3     while ( item = mgmtNextItem( list, &itemCtx ) )S     {N! 	if ( item->ITEMtag >= numItems )d 	{ 	    validList = FALSE;l 	    *qual     = item->ITEMtag;  	    break; /* exit loop */  	} 	elseM 	{L 	    if ( item->ITEMlength < (tbl[item->ITEMtag].minSize + ITEM_HDR_SIZE )||C 		item->ITEMlength > (tbl[item->ITEMtag].maxSize + ITEM_HDR_SIZE ))* 	    { 		validList = FALSE; 		*qual     = item->ITEMtag; 		break; /* exit lopp */ 	    } 	}     } /* end-while item */          return (validList);  }    S /* **++ **  FUNCTION NAME: ** **      mgmtSetLine  ** **  FUNCTIONAL DESCRIPTION:  **I **      This routine is used to modify the characteristics of a PPP line.SG **      The PPP line must be in the "Off" for the characteristics to be_ **      changed. ** **  FORMAL PARAMETERS: **& **      id             Line identifierL **      lineDetails    Itemlist containing the characteristics to be changedM **      qual           Contains the code of the invalid item or item with an  I **                     invalid value, if SS$_BADPARAM or SS$_VALNOTVALID  ! **                     returned    ** **  IMPLICIT INPUTS: **
 **      None.L ** **  IMPLICIT OUTPUTS:E **
 **      None.  **& **  function value or completion codes **@ **      SS$_NORMAL         Characteristics successfully updated.8 **      SS$_DEVACTIVE      The line is in the "On" state9 **      SS$_IVCHAN         The line identifier is invalidPH **      SS$_VALNOTVALID    The value specified for an item is not valid.H **      SS$_BADPARAM       The lineDetails itemlist contains an invalid $ **                         item code ** **  SIDE EFFECTS:P **
 **      None.i ** **-- */B u_int mgmtSetLine( lineId id, ItemList *lineDetails, u_int *qual ) {RK     u_int      status = SS$_NORMAL; /* return code                       */*H     PPPLine   *line;	       /* pointer to line                        */K     PPPLine    lineCopy;       /* copy of the line to perfrom set on     */iK     ItemEntry *item = NULL;    /* pointer to current item in input list  */EK     ItemEntry *itemCtx = NULL; /* pointer to last processed item in list */dK     u_int      tmpValue;       /* variable for storing value of item     */           if ( LINEID_VALID(id) )      {N 	line = LINE_ENTRY(id);  	if ( line->state == Off ) 	{E 	    if ( mgmtParseItemList( lineDetails, mgmtItems, NUM_MGMT_ITEMS, s 				     qual) ) 	    {- 		/* take a copy of line to perform set on */i, 		BCOPY( line, &lineCopy, sizeof(PPPLine) ); 		 		/*5 		 ** Go through each item specified in the itemlist, 6 		 ** check it's value is okay and update the item in " 		 ** the copy we took of the line 		 */ $ 		while ( (status == SS$_NORMAL)  &&: 		        (item = mgmtNextItem( lineDetails, &itemCtx )) )
 		         		{  		    switch ( item->ITEMtag ) 		    {  		    case PPPD$K_DEBUG:' 			EXTRACT_INT( item, lineCopy.debug );H	 			break;  			  		    case PPPD$K_DEBUG_MBX:) 			EXTRACT_STR( item, lineCopy.debugMbx,   				     lineCopy.debugMbxLen);I	 			break;P 			e 		    case PPPD$K_COM_PORT: ( 			EXTRACT_STR( item, lineCopy.comPort,  				     lineCopy.comPortLen);	 			break;l 			t 		    case PPPD$K_RX_ACCM:: 			EXTRACT_INT( item, lineCopy.lcp_wantoptions.asyncmap );- 			lineCopy.lcp_wantoptions.neg_asyncmap = 1; 	 			break;  			i 			e 		    case PPPD$K_TX_ACCM:* 			BCOPY( item->ITEMdata, lineCopy.txAccm,& 			        sizeof(lineCopy.txAccm) ); ; 			lineCopy.lcp_allowoptions.asyncmap = lineCopy.txAccm[0]; 	 			break;P 			  		    case PPPD$K_MRU:! 			EXTRACT_INT( item, tmpValue ); ! 			/* mru is stored as a short */o 			if ( tmpValue < 0xffff )S 			{8 			    lineCopy.lcp_wantoptions.mru = (u_short)tmpValue;, 			    lineCopy.lcp_wantoptions.neg_mru = 1; 			} 			elseR 			{  			    status = SS$_VALNOTVALID; 			}	 			break;  			N 		    case PPPD$K_MTU:! 			EXTRACT_INT( item, tmpValue );c! 			/* mtu is stored as a short */u 			if ( tmpValue < 0xffff )n 			{9 			    lineCopy.lcp_allowoptions.mru = (u_short)tmpValue;-- 			    lineCopy.lcp_allowoptions.neg_mru = 1;  			} 			elsea 			{  			    status = SS$_VALNOTVALID; 			}	 			break;  			; 		    case PPPD$K_MODE:r! 			EXTRACT_INT( item, tmpValue );_$ 			if ( tmpValue == PPPD$K_PASSIVE ) 			{+ 			    lineCopy.lcp_wantoptions.silent = 1;h 			}( 			else if ( tmpValue == PPPD$K_ACTIVE ) 			{+ 			    lineCopy.lcp_wantoptions.silent = 0;  			} 			elseh 			{  			    status = SS$_VALNOTVALID; 			}	 			break;  			$ 		    case PPPD$K_LINE_TYPE:! 			EXTRACT_INT( item, tmpValue );	& 			if ( tmpValue == PPPD$K_TRANSIENT ) 			{! 			    lineCopy.type = Transient;i 			}+ 			else if ( tmpValue == PPPD$K_PERMANENT )  			{! 			    lineCopy.type = Permanent;w 			} 			elsei 			{  			    status = SS$_VALNOTVALID; 			}	 			break;s 			.  		    case PPPD$K_MAX_CONFIGURE:. 			EXTRACT_INT( item, lineCopy.maxConfigure );	 			break;- 			s 		    case PPPD$K_MAX_FAILURE:, 			EXTRACT_INT( item, lineCopy.maxFailure );	 			break;M 			e  		    case PPPD$K_MAX_TERMINATE:. 			EXTRACT_INT( item, lineCopy.maxTerminate );	 			break;  			/ 		    case PPPD$K_AC_COMPRESS:! 			EXTRACT_INT( item, tmpValue );G 			if ( tmpValue  )- 			{7 			    lineCopy.lcp_wantoptions.neg_accompression  = 1;r7 			    lineCopy.lcp_allowoptions.neg_accompression = 1;n 			} 			elsee 			{7 			    lineCopy.lcp_wantoptions.neg_accompression  = 0;/7 			    lineCopy.lcp_allowoptions.neg_accompression = 0;t 			}	 			break;i 			e! 		    case PPPD$K_PROTO_COMPRESS:*! 			EXTRACT_INT( item, tmpValue );h 			if ( tmpValue  )s 			{6 			    lineCopy.lcp_wantoptions.neg_pcompression  = 1;6 			    lineCopy.lcp_allowoptions.neg_pcompression = 1; 			} 			elsee 			{6 			    lineCopy.lcp_wantoptions.neg_pcompression  = 0;6 			    lineCopy.lcp_allowoptions.neg_pcompression = 0; 			} 			 	 			break;P 			   		    case PPPD$K_FCS_RX:7 			/* FCS size is fixed to 16 bytes for this release */*! 			EXTRACT_INT( item, tmpValue );e 			if ( tmpValue != 16 ) 			{  			    status = SS$_VALNOTVALID; 			}	 			break;_    		    case PPPD$K_FCS_TX:7 			/* FCS size is fixed to 16 bytes for this release */*! 			EXTRACT_INT( item, tmpValue );  			if ( tmpValue != 16 ) 			{  			    status = SS$_VALNOTVALID; 			}	 			break;/ 			u  		    case PPPD$K_MAGIC_RETRIES:: 			EXTRACT_INT( item, lineCopy.lcp_wantoptions.numloops );+ 			if ( lineCopy.lcp_wantoptions.numloops )  			{5 			    lineCopy.lcp_wantoptions.neg_magicnumber  = 1;o5 			    lineCopy.lcp_allowoptions.neg_magicnumber = 1;  			} 			else  			{5 			    lineCopy.lcp_wantoptions.neg_magicnumber  = 0;X5 			    lineCopy.lcp_allowoptions.neg_magicnumber = 0;e 			}	 			break;  			   		    case PPPD$K_RESTART_TIMER:. 			EXTRACT_INT( item, lineCopy.restartTimer );	 			break;-  ! 		    case PPPD$K_ECHO_INTERVALS: 3 			EXTRACT_INT( item, lineCopy.lcp_echo_interval );[	 			break;  			  		    case PPPD$K_ECHO_FAILURE:}0 			EXTRACT_INT( item, lineCopy.lcp_echo_fails );	 			break;  			  		    }  		} /* end-while item */ 		 		/*  ) 		 ** If all items were successfully set  + 		 ** copy changed attributes back to line  , 		 ** otherwise update the qual parameter to1 		 ** with the tag of the item that stuffed us upi 		 */t 		if ( status == SS$_NORMAL )a 		{ 0 		    BCOPY( &lineCopy, line, sizeof(PPPLine) ); 		}  		else 		{P 		    *qual = item->ITEMtag; 		}e  ! 	    } /* end-if ParseItemList */m	 	    else  	    { 		status = SS$_BADPARAM; 	    } 	} /* end-if state == Off */ 	else  	{ 	    status = SS$_DEVACTIVE; 	}     } /* end-if line valid */L	     else :     {* 	status = SS$_IVCHAN;M     }O       return( status );e }    * /* **++ **  FUNCTION NAME: ** **      mgmtShowLine ** **  FUNCTIONAL DESCRIPTION:r **J **      This routine is used to display the characteristics of a PPP line.I **      The itemlist handed in as input parameter on retrun contains the m" **      values of the items to be  ** **  FORMAL PARAMETERS: **& **      id             Line identifierJ **      lineDetails    Itemlist containing the characteristics to be shownM **      qual           Contains the code of the invalid item or item with an l? **                     invalid value if SS$_BADPARAM returned    ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:e **
 **      None.  **& **  function value or completion codes **B **      SS$_NORMAL         Characteristics successfully displayed.9 **      SS$_IVCHAN         The line identifier is invalids. **      SS$_INSFMEM        Insufficient memoryH **      SS$_BADPARAM       The lineDetails itemlist contains an invalid $ **                         item code ** **  SIDE EFFECTS:N **
 **      None.t ** **-- */C u_int mgmtShowLine( lineId id, ItemList *lineDetails, u_int *qual )* {*N     u_int      status;	          /* function return code                    */O     PPPLine   *line;              /* pointer to line                         */aO     ItemEntry *item = NULL;       /* pointer to current item in input list   */sO     ItemEntry *itemCtx = NULL;    /* pointer to last processed item in list  */rO     ItemList  *rtnDetails = NULL; /* item list to build return values in     */ O     u_int      tmpValue;          /* variable for storing value of item      */p          if ( LINEID_VALID(id) )i     {* 	line = LINE_ENTRY(id);nG 	if ( mgmtParseItemList(lineDetails, mgmtItems, NUM_MGMT_ITEMS, qual) )s 	{ 	    /*l1 	     ** Allocate an itemlist to return values inv 	     */@ 	    rtnDetails = mgmtAllocItemList( lineDetails->ITEMLlength ); 	    if ( rtnDetails ) 	    { 		/*5 		 ** Go through each item specified in the itemlist,i9 		 ** and copy the value stored in line into the itemlist  		 */l8 		while ( item = mgmtNextItem( lineDetails, &itemCtx ) ) 		{g 		    switch ( item->ITEMtag ) 		    {  		    case PPPD$K_DEBUG:- 			mgmtAppendItem( rtnDetails, PPPD$K_DEBUG, b0 				        sizeof(line->debug), &line->debug );	 			break;n 			i 		    case PPPD$K_DEBUG_MBX:1 			mgmtAppendItem( rtnDetails, PPPD$K_DEBUG_MBX, e1 				        line->debugMbxLen, line->debugMbx ); i	 			break;  			r 		    case PPPD$K_COM_PORT:E0 			mgmtAppendItem( rtnDetails, PPPD$K_COM_PORT, / 				        line->comPortLen, line->comPort );  	 			break;  			> 		    case PPPD$K_RX_ACCM:. 			mgmtAppendItem( rtnDetails, PPPD$K_RX_ACCM,3 				        sizeof(line->lcp_wantoptions.asyncmap), - 				        &line->lcp_wantoptions.asyncmap);M	 			break;e   		    case PPPD$K_TX_ACCM:. 			mgmtAppendItem( rtnDetails, PPPD$K_TX_ACCM,0 				        sizeof(line->txAccm), line->txAccm);	 			break;m 			M 		    case PPPD$K_MRU:7 			/* MRU is stored as a short but in list is an int */ 8 			mgmtAppendItem( rtnDetails, PPPD$K_MRU, sizeof(int), ) 				        &line->lcp_wantoptions.mru );I	 			break;P 			  		    case PPPD$K_MTU:7 			/* MTU is stored as a short but in list is an int */ 8 			mgmtAppendItem( rtnDetails, PPPD$K_MTU, sizeof(int), * 				        &line->lcp_allowoptions.mru );	 			break;T 			  		    case PPPD$K_MODE: + 			if ( line->lcp_wantoptions.silent == 1 )l 			{! 			    tmpValue = PPPD$K_PASSIVE;c 			} 			else  			{  			    tmpValue = PPPD$K_ACTIVE; 			}, 			mgmtAppendItem( rtnDetails, PPPD$K_MODE, * 				        sizeof(tmpValue), &tmpValue );	 			break;  			  		    case PPPD$K_LINE_TYPE:! 			if ( line->type == Transient )  			{# 			    tmpValue = PPPD$K_TRANSIENT;* 			} 			else* 			{# 			    tmpValue = PPPD$K_PERMANENT;* 			}1 			mgmtAppendItem( rtnDetails, PPPD$K_LINE_TYPE,  * 				        sizeof(tmpValue), &tmpValue );	 			break;  			s  		    case PPPD$K_MAX_CONFIGURE:4 			mgmtAppendItem( rtnDetails, PPPD$K_MAX_CONFIGURE,' 				        sizeof(line->maxConfigure),o" 				        &line->maxConfigure );	 			break;t 			i 		    case PPPD$K_MAX_FAILURE:2 			mgmtAppendItem( rtnDetails, PPPD$K_MAX_FAILURE,% 				        sizeof(line->maxFailure),/  				        &line->maxFailure );	 			break;e 			l  		    case PPPD$K_MAX_TERMINATE:4 			mgmtAppendItem( rtnDetails, PPPD$K_MAX_TERMINATE,' 				        sizeof(line->maxTerminate),*" 				        &line->maxTerminate );	 			break;  			n 		    case PPPD$K_AC_COMPRESS:5 			if ( line->lcp_wantoptions.neg_accompression == 1)  			{ 			    tmpValue = 1; 			} 			elsep 			{ 			    tmpValue = 0; 			}3 			mgmtAppendItem( rtnDetails, PPPD$K_AC_COMPRESS, ** 				        sizeof(tmpValue), &tmpValue );	 			break;i 			l! 		    case PPPD$K_PROTO_COMPRESS:L4 			if ( line->lcp_wantoptions.neg_pcompression == 1) 			{ 			    tmpValue = 1; 			} 			elseg 			{ 			    tmpValue = 0; 			}6 			mgmtAppendItem( rtnDetails, PPPD$K_PROTO_COMPRESS, * 				        sizeof(tmpValue), &tmpValue );	 			break;n 			i 		    case PPPD$K_FCS_RX: + 			/* FCS size is fixed for this release */d 			tmpValue = 16; . 			mgmtAppendItem( rtnDetails, PPPD$K_FCS_RX, * 				        sizeof(tmpValue), &tmpValue );	 			break;h   		    case PPPD$K_FCS_TX: + 			/* FSC size is fixed for this release */l 			tmpValue = 16;	. 			mgmtAppendItem( rtnDetails, PPPD$K_FCS_TX, * 				        sizeof(tmpValue), &tmpValue );	 			break;m 			e  		    case PPPD$K_MAGIC_RETRIES:4 			mgmtAppendItem( rtnDetails, PPPD$K_MAGIC_RETRIES,2 				       sizeof(line->lcp_wantoptions.numloops),- 				       &line->lcp_wantoptions.numloops ); 	 			break;T 			   		    case PPPD$K_RESTART_TIMER:5 			mgmtAppendItem( rtnDetails, PPPD$K_RESTART_TIMER, P' 				        sizeof(line->restartTimer),o" 				        &line->restartTimer );	 			break;_ 			p! 		    case PPPD$K_ECHO_INTERVALS: 6 			mgmtAppendItem( rtnDetails, PPPD$K_ECHO_INTERVALS, , 				        sizeof(line->lcp_echo_interval),' 				        &line->lcp_echo_interval );l	 			break;a 			a 		    case PPPD$K_ECHO_FAILURE:k4 			mgmtAppendItem( rtnDetails, PPPD$K_ECHO_FAILURE, ) 				        sizeof(line->lcp_echo_fails),o$ 				        &line->lcp_echo_fails );	 			break;  		    }. 		} /* end-while item */   		/* a0 		 ** Copy rtnDetails back to itemlist handed in 		 ** by client. 		 */	5 		lineDetails->ITEMLlength = rtnDetails->ITEMLlength;   		if ( rtnDetails->ITEMLlength ) 		{ ' 		    BCOPY( rtnDetails->ITEMLaddress, s! 			   lineDetails->ITEMLaddress, f  			   rtnDetails->ITEMLlength ); 		}o 		status = SS$_NORMAL; 	    } /* end-if rtnDetails */	 	    elsen 	    { 		status = SS$_INSFMEM;{ 	    } 	} /* end-if ParseItemList */} 	elsee 	{ 	    status = SS$_BADPARAM;E 	}     } /* end-if line valid */)	     else       {e 	status = SS$_IVCHAN;	     }           return( status );i }t            