I /************************************************************************ I **                                                                      * I ** Copyright  1996 Digital Equipment Corporation.                      * I ** All rights reserved.                                                 * I **                                                                      * I ** Redistribution and use in source and binary forms are permitted      * I ** provided that the above copyright notice and this paragraph are      * I ** duplicated in all such forms and that any documentation,             * I ** advertising materials, and other materials related to such           * I ** distribution and use acknowledge that the software was developed     * I ** by Digital Equipment Corporation.  The name of the                   * I ** Corporation may not be used to endorse or promote products derived   * I ** from this software without specific prior written permission.        * I ** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       * I ** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       * I ** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * I **                                                                      * I *************************************************************************  **++
 **  FACILITY:  ** **      ppp_vci.c  **
 **  ABSTRACT:  **A **      This module implements routines required to provide a VCI  **      interface to PPP.  ** **  AUTHORS: **; **      Patrick Crilly,   Networks Engineering (Australia).  ** **  CREATION DATE: ** **      29-November-1995 ** **  MODIFICATION HISTORY:  **C **      X-9     BWK002          Barry W. Kierstein      17-DEC-1996 < **              Replaced the standard Digital copyright with6 **              one compatible with the CMU copyright. **C **      X-8     PWC          Patrick W. Crilly          12-Sep-1996 F **              In VCILineEvent for failures always call fsm_lowerdown@ **              even in Unusable state (last fix didn't do this)@ **              as port can get there with active state machine. **C **      X-7     PWC          Patrick W. Crilly          28-Aug-1996 F **              In VCILineEvent for failures always call fsm_lowerdown **C **      X-6     PWC          Patrick W. Crilly          28-Aug-1996 ; **              Allow IP to transmit VJ compression packets  **C **      X-3     BWK001          Barry W. Kierstein      24-Jul-1996 + **              Corrected copyright notice.  **, **	X-1	FAK001		Forrest A. Kenney	29-May-1996D **		in VCILineEvent rework code to no longer reference deleted line  **		structure. **+ **      29-November-1995  Original version.  ** **-- */   /* ** Include files */   /* ** ** import definitions: **        types  ** */ #ifndef _PPPD_H_ #include "pppd.h"  #endif   /* ** ** import definitions: **        LINE_ENTRY ** */ #ifndef _LCP_VMS_H_  #include "lcp_vms.h" #endif   /* ** ** import definitions: **        deviceTransmit ** */ #ifndef _PPP_ASYNC_H_  #include "ppp_async.h" #endif   /* ** ** import definitions: **        fsm_stopCP ** */ #ifndef _FSM_VMS_H_  #include "fsm_vms.h" #endif   /* ** ** import definitions: **        ItemEntry  **        mgmtNextItem **        mgmtGetLineId  ** */ #ifndef _PPP_MGMT_H_ #include "ppp_mgmt.h"  #endif   /* ** ** import definitions: **        ppp vcib defines ** */ #ifndef _PPP_VCIB_H_ #include "ppp_vcib.h"  #endif   /* ** ** import definitions:/ **        prototypes for this module's routines  ** */ #ifndef _PPP_VCI_H_  #include "ppp_vci.h" #endif   /* ** Global variables  */ static parseItem VCIItems[] =  { :    MIN_STRING_SIZE, MAX_STRING_SIZE, /* PPPD$K_NAME     */3    WORD_SIZE, WORD_SIZE		     /* PPPD$K_PROTOCOL */  };  > #define NUM_VCI_ITEMS     (sizeof(VCIItems)/sizeof(parseItem))   VCIRTNS VCIVector =  {      VCICreatePort,     VCIDeletePort  };   /*   ** External routines */ extern void VCICall(); extern void VCIForkCall(); extern void VCIReportEvent();      /* **++ **  FUNCTION NAME: ** **      VCICreatePort  ** **  FUNCTIONAL DESCRIPTION:  **O **      The VCICreatePort entry point is used by the VCI registry when an upper J **      VCM wants to create a port to the PPP VCM.  It is called with one M **      parameter, the VCIB, which the upper VCM has already initialised with M **      it's field's and entry points.  The PPP driver will initialise PPP's  > **      VCI entry points and the relevant fileds in the VCIB.  ** **  FORMAL PARAMETERS: **A **      vcib    A pointer to the VCIB allocated by the upper VCM.  ** **  IMPLICIT INPUTS: **> **      VCIPortMgmtInit    Address of PPP's port mgmt routine.< **      VCITransmitInit    Address of PPP's transmit routine ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **3 **      SS$_NORMAL    Normal successful completion.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */% int VCICreatePort( VCIBPPPDEF *vcib )  { )     vcib->VCIBVersionLower = PPP_VERSION;   8     /* fill in the vcib with pointers to our routines */#     vcib->VCIBPortmgmtSynch    = 0; 8     vcib->VCIBPortmgmtInitiate = (int *)VCIPortMgmtInit;#     vcib->VCIBControlSynch     = 0; #     vcib->VCIBControlInitiate  = 0; 8     vcib->VCIBTransmitInitiate = (int *)VCITransmitInit;  +     /* initialise PPP extensions to vcib */       vcib->VCIBPPPPortId  = NULL;&     vcib->VCIBPPPFcsSize = PPP_FCSLEN;&     vcib->VCIBPPPHdrSize = PPP_HDRLEN;#     vcib->VCIBPPPMtu     = PPP_MRU;  	      return( SS$_NORMAL );  }      /* **++ **  FUNCTION NAME: ** **      VCIDeletePort  ** **  FUNCTIONAL DESCRIPTION:  **O **      The VCIDeletePort entry point is used by the VCI registry when an upper O **      VCM wants to delete a port to the PPP VCM.  The function is called with M **      one parameter which is the VCIB that describes the connection to the  O **      lower VCM.  This routine performs all decommissioning for this VCI port K **      and zero's the fileds initialised by PPP in the VCiCreatePort call. O **      The upper VCM is responsible for deallocating ther VCIB when this call   **      completes. ** **  FORMAL PARAMETERS: **3 **      vcib   A pointer to the VCIB to be deleted.  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **5 **      SS$_NORMAL       Normal successful completion < **      SS$_DEVACTIVE    The port has not been disabled.     ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */% int VCIDeletePort( VCIBPPPDEF *vcib )  { K     int status = SS$_DEVACTIVE; /* function return code - assume failure */   B     /* A port cannot be in existence for the VCIB to be deleted */&     if ( vcib->VCIBPPPPortId == NULL )     { " 	/* zero out PPP fields of VCIB */  	vcib->VCIBPortmgmtInitiate = 0;  	vcib->VCIBTransmitInitiate = 0;  	vcib->VCIBPPPFcsSize       = 0;  	vcib->VCIBPPPHdrSize       = 0;  	vcib->VCIBPPPMtu           = 0; 	  	status = SS$_NORMAL;      }        return ( status ); }      /* **++ **  FUNCTION NAME: ** **      VCIDemuxprotrej  ** **  FUNCTIONAL DESCRIPTION:  **< **      This function is called to process a protocol reject< **      received on a line.   The port using the protocol is: **      notfied that the NCP has failed.  If no port using4 **      the protocol is found the reject is ignored. ** **  FORMAL PARAMETERS: **= **      line        Identifier of the line reject received on + **      protocol    Protocol being rejected  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */5 void VCIDemuxprotrej( lineId line, u_short protocol )  { <     PPPPort  *port;	/* pointer to a port structure        */  @     /* find port that the reject was for and report the event */)     for ( port = LINE_ENTRY(line)->ports;  	  port != NULL; 	  port = port->next )     { " 	if ( port->protocol == protocol ) 	{; 	    if ( port->state == Usable || port->state == Enabled )  	    { 		port->state = Failed; ; 		VCIReportEvent( port->vcib->VCIBReportEvent, port->vcib,  3 			        PPPD$K_PORT_FAILED, PPPD$K_NCP_FAILED );  	    } 	    break;  	}     }        return;  }      /* **++ **  FUNCTION NAME: ** **      VCIDisablePort ** **  FUNCTIONAL DESCRIPTION:  **F **      The VCIDIsablePort routine is used by the upper VCM to request? **      a protocol no longer be run over a communications port.  ** **  FORMAL PARAMETERS: **> **      vcib       Pointer to the VCIB for the request        : **      request    The vcrp containing the disable request ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  **< **      The function is completed by calling the upper VCM's@ **      PORTMGMT_COMPLETE service and the status of the functionA **      is set in the vcrp$l_request_status field of the request.  ** **  SIDE EFFECTS:  **
 **      none.  ** **-- */@ void VCIDisablePort( VCIBPPPDEF *vcib, struct vcrpdef *request ) { F     PPPPort *port = vcib->VCIBPPPPortId; /* port for request        */F     u_int    pending = FALSE;  /* if TRUE wait for NCP to terminate */  5     /* Check the port is in a state to be disabled */      if ( port == NULL )      { / 	request->vcrp$l_request_status = SS$_DEVINACT; 6 	VCICall( vcib->VCIBPortmgmtComplete, request, vcib );     } -     else if ( port->state == DisablePending )      { 0 	request->vcrp$l_request_status = SS$_OPINCOMPL;6 	VCICall( vcib->VCIBPortmgmtComplete, request, vcib );     }      else     {  	/* Stop the NCP - if any */ 	if ( port->fsmPtr ) 	{+ 	    fsm_stopNCP( port->fsmPtr, &pending );  	}   	/* C 	 ** If we have to wait for the NCP to terminate queue the disable  F 	 ** request.  When the NCP terminates the client will be notified of ' 	 ** completion of the disable request. @ 	 ** If the NCP has terminated delete the port and complete the  	 ** disable request   	 */ 	if ( pending )  	{$ 	    port->state   = DisablePending;" 	    port->request = request;	     	} 	elseo 	{  	    port->NCPTerminated = TRUE;1 	    request->vcrp$l_request_status = SS$_NORMAL; * 	    VCIDisablePortCompl( port, request ); 	}       }        return;  }      /* **++ **  FUNCTION NAME: ** **      VCIDisablePortComplp ** **  FUNCTIONAL DESCRIPTION:t **H **      This function is called to complete a disable an a port.  It is I **      required because on disable can be queued pending the terminationt6 **      of the assiociated network control protocol.   ** **  FORMAL PARAMETERS: **? **      port    Pointer to the port to complete the disable on.mB **      request	   Pointer to the disable request to be completed  ** **  IMPLICIT INPUTS: **
 **      None.u ** **  IMPLICIT OUTPUTS:h **
 **      None.  **& **  function value or completion codes **
 **      None.I ** **  SIDE EFFECTS:D **
 **      None.S ** **-- */C void VCIDisablePortCompl( PPPPort *port,  struct vcrpdef *request )  { ?     lineId      line;    /* line port attached to            */U?     PPPPort    *cpPtr;   /* temporary pointer to a port      */ ?     PPPPort    *prevPtr; /* temporary pointer to a port      */*?     VCIBPPPDEF *vcib;    /* Pointer to vcib port attached to */        line = port->line;     vcib = port->vcib;     ;     if ( port->NCPTerminated == TRUE && port->writes == 0 )f     {P!     	if ( LINEID_VALID( line )  )      	{- 	    /* remove the port from list of ports */*5 	    for ( cpPtr = prevPtr = LINE_ENTRY(line)->ports;  	          cpPtr != port; 1 	          prevPtr = cpPtr, cpPtr = cpPtr->next )e 	        ; C 	    if ( prevPtr == cpPtr ) 	    {) 	        LINE_ENTRY(line)->ports = NULL;   	     / 	        /* no more ports on line - stop LCP */- 	        lcp_close( line );  	    }	 	    elseS 	    {% 	        prevPtr->next = cpPtr->next;a 	    }	         }f     ?         /* Delete the port and it's associated state machine */o         if ( port->fsmPtr )r	         {h! 	    DEALLOC_MEM( port->fsmPtr ); 	         }          DEALLOC_MEM( port );#         vcib->VCIBPPPPortId = NULL;      "         /* Complete the request */4         request->vcrp$l_request_status = SS$_NORMAL;A         VCIForkCall( vcib->VCIBPortmgmtComplete, request, vcib );       } /* end-if NCPTerminated */     return;- }    0 /* **++ **  FUNCTION NAME: ** **      VCIEnablePort  ** **  FUNCTIONAL DESCRIPTION:e **I **      The VCIEnablePort function is called when a upper VCM requests a kF **      protocol be run over a communications.   Successful completionD **      of this routine does not mean that the upper VCM is able to J **      transmit or receive date, only that PPP has initiated the actions G **      required to put it into this state.   If a protocol requires a  E **      network control protocol and one has not been registered the " **      function will fail.  ** **  FORMAL PARAMETERS: **> **      vcib       Pointer to the VCIB for the request        9 **      request    The vcrp containing the enable requestp ** **  IMPLICIT INPUTS: **
 **      None.s ** **  IMPLICIT OUTPUTS:  **
 **      None.n **& **  function value or completion codes **
 **      None.t **< **      The function is completed by calling the upper VCM's@ **      PORTMGMT_COMPLETE service and the status of the functionA **      is set in the vcrp$l_request_status field of the request.  ** **  SIDE EFFECTS:i **
 **      None.r ** **-- */? void VCIEnablePort( VCIBPPPDEF *vcib, struct vcrpdef *request )p {cN     PPPPort   *port = NULL;    /* port for request                          */N     fsm       *fsmPtr = NULL;  /* pointer to state machine for protocol     */N     u_int     status = SS$_NORMAL; /* status of request - assume success    */N     u_short   protocol = 0;    /* number of the protocol to be started      */J     lineId    line;	       /* identifier of line to start protocol on   */N     char      *devName;	       /* name of the line to start protocol on     */N     u_int     devNameLen = 0;  /* length of devName                         */N     ItemEntry *item = NULL;    /* pointer to current item in input list     */N     ItemEntry *itemCtx = NULL; /* pointer to last processed item in list    */  4     /* Check the port is in a state to be enabled */+     if ( vcib->vcib$a_ppp_port_id != NULL )a     {y 	status = SS$_DEVACTIVE;     }t  3     /* Check that an itme list has been supplied */n     if ( status == SS$_NORMAL )O     {R# 	if ( !request->vcrp$a_input_list )e 	{ 	    status = SS$_INSFARG; 	}     }   '     /* parse the input item list */    r     if ( status == SS$_NORMAL )t     {oN 	if ( mgmtParseItemList( request->vcrp$a_input_list, VCIItems, NUM_VCI_ITEMS, 2 			        &request->vcrp$l_request_status_qual) ) 	{- 	    /* Save values of items in input list */LJ 	    while ( item = mgmtNextItem( request->vcrp$a_input_list, &itemCtx ) ) 	    { 		switch ( item->ITEMtag ) 		{P 		  case PPPD$K_NAME: * 		    devName    = (char *)item->ITEMdata;5 		    devNameLen = item->ITEMlength - ITEM_HDR_SIZE;   		    break; 		     		  case PPPD$K_PROTOCOL:C, 		    protocol = *(u_short *)item->ITEMdata; 		    break; 		}o 	    } /* end-while item */C   	    /* 8 	     ** Get line identifier - an error will be returned( 	     ** if the device name isn't valid. 	     */: 	    status = mgmtGetLineId( &line, devName, devNameLen ); 	} 	elseP 	{ 	    status = SS$_BADPARAM;i 	}     }R  >     /* Verify that a protocol and device name were supplied */+     if ( devNameLen == 0 || protocol == 0 )M     {  	status = SS$_INSFARG;     }      :     /* Check protocol isn't already in use on this line */     if ( status == SS$_NORMAL )n     {e& 	for ( port = LINE_ENTRY(line)->ports; 	      port != NULL; c 	      port = port->next ) 	{& 	    if ( port->protocol == protocol ) 	    { 		status = SS$_DEVALLOC; 		break; /* exit loop */ 	    } 	}     }o     B     /* Check if control protocol required and one is registered */     if ( status == SS$_NORMAL )      { # 	if ( fsm_isNCPRequired(protocol) )a 	{2 	    if ( fsm_isNCPRegistered(protocol | 0x8000) ) 	    {) 		ALLOC_MEM( fsmPtr, sizeof(fsm), fsm *);p 		if ( fsmPtr == NULL )d 		{d 		    status = SS$_INSFMEM;  		}* 	    }	 	    else* 	    { 		status = SS$_DEVOFFLINE; 	    } 	}     }i 	v(     /* Allocate and initialise a port */     if ( status == SS$_NORMAL )m     { * 	ALLOC_MEM(port, sizeof(port), PPPPort *); 	if ( port == NULL ) 	{ 	    status == SS$_INSFMEM;  	}   	else* 	{ 	    /* init PPP fields */  	    port->vcib          = vcib;$ 	    port->protocol      = protocol;  	    port->line          = line;# 	    port->state         = Enabled;e  	    port->NCPTerminated = TRUE;$             port->writes        = 0;  	    port->request       = NULL;H   	    port->fsmPtr        = fsmPtr; /* will be NULL if no NCP needed */    	    /* reset vcib fields */! 	    vcib->VCIBPPPPortId  = port;-' 	    vcib->VCIBPPPFcsSize = PPP_FCSLEN; ' 	    vcib->VCIBPPPHdrSize = PPP_HDRLEN;u$ 	    vcib->VCIBPPPMtu     = PPP_MRU;    :
      	    /* C6              ** If this is the first port on the line ;              ** start LCP on the line if it is enabled.  If*9              ** the line is disabled lcp will get started !              ** after an enable. i              */u+ 	    if ( LINE_ENTRY(line)->ports == NULL )t
             {*-         	if ( LINE_ENTRY(line)->state == On )              	{ 	            lcp_start( line );                  }t
             }c  0 	    /* add port to linked list of ports */	    7 	    port->next              = LINE_ENTRY(line)->ports;u+             LINE_ENTRY(line)->ports = port;  	      	    /* 2 	     ** Start NCP if one is required.  The fsmPtr5              ** will be non-NULL if an NCP is needed                */t!             if ( fsmPtr != NULL ) 
             {*>   	    	fsm_startNCP( fsmPtr, line, port, (0x8000|protocol) );,                 port->NCPTerminated = FALSE; 	    }   	}     }		o  9     /* If the request failed free any allocated memory */      if ( status != SS$_NORMAL )p     {a 	if ( fsmPtr != NULL ) 	{ 	    DEALLOC_MEM( fsmPtr );R 	} 	if ( port != NULL ) 	{ 	    DEALLOC_MEM( port );	 	}     }P  %     /* Complete the Enable request */ ,     request->vcrp$l_request_status = status;=     VCIForkCall( vcib->VCIBPortmgmtComplete, request, vcib );e       return;U }I   D /* **++ **  FUNCTION NAME: ** **      VCILineEvent ** **  FUNCTIONAL DESCRIPTION:  **K **      This function communicates an event that has occurred on a PPP linePH **      to the protocols using the line.   The routine goes through eachJ **      of the protocols (i.e. ports) using this line and takes any action? **      required according to the type of event that occurred. * ** **  FORMAL PARAMETERS: **? **      line     Identifier for the line this event occurred on , **      event    Type of event that occurred ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.c **& **  function value or completion codes **
 **      None.S ** **  SIDE EFFECTS:  **
 **      None.V ** **-- */1 void VCILineEvent( lineId line, lineEvent event )  {PC     PPPPort  *nextPort; /* pointer to next port structure        */ <     PPPPort  *port;	/* pointer to a port structure        */         /* *F      ** Go through each port on this line.  Determine the appropriate G      ** action to take depending on the state of the port and the eventc      ** received.p      */u     #     port = LINE_ENTRY(line)->ports;t     while (port != NULL)     {          nextPort = port->next; 	switch( port->state ) 	{ 	  case Disabled:o 	  case Failed:v 	    /* do nothing */e 	    break;  	    e 	  case Unusable:i 	    switch( event ) 	    { 	      case LCPUp:' 		/* fill in relevant fields of port */e. 		if ( LCP_GOTOPTIONS(line).neg_pcompression ) 		{b' 		    port->vcib->VCIBPPPHdrSize -= 1; t 		}e/ 		if ( LCP_GOTOPTIONS(line).neg_accompression )t 		{s' 		    port->vcib->VCIBPPPHdrSize -= 2; n 		}d4 		port->vcib->VCIBPPPMtu = LCP_GOTOPTIONS(line).mru;  2 		/* inform state machine we have a lower layer */ 		if ( port->fsmPtr )r 		{q" 		    fsm_lowerup( port->fsmPtr ); 		}  		break; 	    t 	      case DeviceFail:> 		port->state = Failed;S 		if ( port->fsmPtr )a 		{r$ 		    fsm_lowerdown( port->fsmPtr ); 		} ; 		VCIReportEvent( port->vcib->VCIBReportEvent, port->vcib,  3 			        PPPD$K_PORT_FAILED, PPPD$K_DEV_FAILED );N 		break; 	  	    case LineDeleted: 		port->state = Failed;n 		if ( port->fsmPtr )  		{u$ 		    fsm_lowerdown( port->fsmPtr ); 		}n; 		VCIReportEvent( port->vcib->VCIBReportEvent, port->vcib, l5 			        PPPD$K_PORT_FAILED, PPPD$K_LINE_DELETED );o 		break;   	      default:c 		break;   	    } /* end-switch event */    	    break;    	  case Enabled: 	  case Usable:  	    switch( event ) 	    { 	      case LCPDown: 		/* O6 		 ** Set the port state before doing anything else.  / 		 ** If we don't do this sending the lowerdownE6 		 ** makes the state machine send an event indicating6 		 ** the control protocol failed which isn't strictly 		 ** true.i 		 */  		port->state = Unusable;a 		if ( port->fsmPtr )  		{P$ 		    fsm_lowerdown( port->fsmPtr ); 		}a; 		VCIReportEvent( port->vcib->VCIBReportEvent, port->vcib,  5 			        PPPD$K_PORT_UNUSABLE, PPPD$K_LCP_FAILED );                  break;   	      case LCPFinished: 		port->state = Unusable;  		if ( port->fsmPtr )P 		{n$ 		    fsm_lowerdown( port->fsmPtr ); 		}P; 		VCIReportEvent( port->vcib->VCIBReportEvent, port->vcib, t5 			        PPPD$K_PORT_UNUSABLE, PPPD$K_LCP_FAILED );P 		break;   	      case LCPUp:' 		/* fill in relevant fields of port */e. 		if ( LCP_HISOPTIONS(line).neg_pcompression ) 		{ ' 		    port->vcib->VCIBPPPHdrSize -= 1;   		}N/ 		if ( LCP_HISOPTIONS(line).neg_accompression )/ 		{m' 		    port->vcib->VCIBPPPHdrSize -= 2;   		}c4 		port->vcib->VCIBPPPMtu = LCP_HISOPTIONS(line).mru;  2 		/* inform state machine we have a lower layer */ 		if ( port->fsmPtr )  		{a" 		    fsm_lowerup( port->fsmPtr ); 		}  		else 		{-J                 	VCIReportEvent( port->vcib->VCIBReportEvent, port->vcib, A 		                        PPPD$K_PORT_USABLE, PPPD$K_NO_REASON );           	}C 		break; 	    s 	      case DeviceFail:r 		port->state = Failed;N 		if ( port->fsmPtr )C 		{v$ 		    fsm_lowerdown( port->fsmPtr ); 		} ; 		VCIReportEvent( port->vcib->VCIBReportEvent, port->vcib, *3 			        PPPD$K_PORT_FAILED, PPPD$K_DEV_FAILED );  		break; 	C 	      case LineDeleted:; 		/* don't expect the line to be deleted in these states */  		break;   	      default:l	 		break;	r 		 	    } /* end-switch event */p 	    break;  	  t 	  case DisablePending:  	    /* F 	     ** If the port is in this state we just complete this disable asF 	     ** the only events we should receive will indicate some sort of E 	     ** LCP or line failure (i.e. we shouldn't get an LCPUp event ).s 	     */ 	    if ( port->fsmPtr ) 	    {  		fsm_lowerdown( port->fsmPtr ); 	    }'             port->NCPTerminated = TRUE;B0 	    VCIDisablePortCompl( port, port->request ); 	    break;g 	    a 	} /* end-switch port->state */P           port = nextPort;     } /* end-while port */       return;n }      /* **++ **  FUNCTION NAME: ** **      VCIMgmtEvent ** **  FUNCTIONAL DESCRIPTION:e **M **      This function is used to process a event from the management rouitnes J **      At the moment management signals to the ports disables and enables **      of the PPP line. i ** **  FORMAL PARAMETERS: **? **      line     Identifier for the line this event occurred on , **      event    Type of event that occurred ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:/ **
 **      None.m **& **  function value or completion codes **
 **      None./ ** **  SIDE EFFECTS:s **
 **      None.  ** **-- */2 void  VCIMgmtEvent( lineId line, mgmtEvent event ) {d     PPPPort *port;       switch (event)     {r       case MgmtDisable:l/ 	/* do nothing - the ports will see LCP fail */o 	break;e         case MgmtEnable: 	/* 7 	 ** If there are any ports till in the Unusable state   	 ** attempt to restart LCPn 	 */ 	  	break;        }e     return;i }    p /* **++ **  FUNCTION NAME: ** **      VCINCPEvente ** **  FUNCTIONAL DESCRIPTION:  **G **      This function processes a event that has occurred on the state vG **      machine associated with the port.  The routine takes any action ? **      required according to the type of event that occurred. a ** **  FORMAL PARAMETERS: **: **      port    Pointer to the port this event occurred on4 **      event      Type of event that occurred       ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:s **
 **      None.i **& **  function value or completion codes **
 **      None.$ ** **  SIDE EFFECTS:) **
 **      None.v ** **-- */1 void VCINCPEvent( PPPPort *port, NCPEvent event )m {e     switch( event )i     {e       case NCPDown:w       case NCPFinished:	       case NCPStopped:% 	if ( port->state == DisablePending )E 	{  	    port->NCPTerminated = TRUE;0 	    VCIDisablePortCompl( port, port->request ); 	}< 	else if ( port->state == Enabled || port->state == Usable ) 	{ 	    port->state = Unusable;> 	    VCIReportEvent( port->vcib->VCIBReportEvent, port->vcib, 1 			    PPPD$K_PORT_UNUSABLE, PPPD$K_NCP_FAILED );n 	} 	break;i         case NCPUp:a 	port->state = Usable;: 	VCIReportEvent( port->vcib->VCIBReportEvent, port->vcib, 1 		        PPPD$K_PORT_USABLE, PPPD$K_NO_REASON );o 	break;          default: 	break;/     }f          return;| }      = /* **++ **  FUNCTION NAME: ** **      VCIPortMgmtInit* ** **  FUNCTIONAL DESCRIPTION:u **J **      The VCIPortMgmtInit routine is called up the upper VCM to perform L **      functions on the VCI port.  All this routine does is to look at the M **      function requested and pass it on to another routine to be processed.a **G **      NOTE:  The routines called to process the event are responsiblelF **      for the asychronous completion of the request.   If an invalidL **      function is requested this routine wil complete the request with an  **      error. ** **  FORMAL PARAMETERS: **> **      vcib       Pointer to the VCIB for the request        ; **      request    The vcrp containing the PortMgmt requestt ** **  IMPLICIT INPUTS: **
 **      None.v ** **  IMPLICIT OUTPUTS:a **
 **      None.  **& **  function value or completion codes **
 **      None.o **C **      The request is completed asychronously by the routine which  **      processes it./ ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */A void VCIPortMgmtInit( VCIBPPPDEF *vcib, struct vcrpdef *request ); { <     /* Dispatch request to appropriate processing routine */&     switch( request->vcrp$l_function )     { !       case VCRP$K_FC_ENABLE_PORT:   	VCIEnablePort( vcib, request ); 	break;   "       case VCRP$K_FC_DISABLE_PORT:! 	VCIDisablePort( vcib, request );I 	break;d         default: 	/*  	 ** Complete the VCRP 	 */1 	request->vcrp$l_request_status = SS$_ILLIOFUNC; -? 	VCIForkCall( vcib->VCIBPortmgmtComplete, request, vcib );    	      }        return;r }n   l /* **++ **  FUNCTION NAME: ** **      VCIReceive ** **  FUNCTIONAL DESCRIPTION:  **L **     This routine is used to process a protocol packet received on a line.C **     The list of ports using this line is scanned to find the one G **     using this protocol and the packet then handed to the upper VCM.  ** **  FORMAL PARAMETERS: **> **      line        Identifier of the line packet received on.6 **      buf         Buffer containing recieved packet.9 **      protocol    Protocol of recieved packet.           ** **  IMPLICIT INPUTS: **
 **      None.i ** **  IMPLICIT OUTPUTS:P **
 **      None.  **& **  function value or completion codes **4 **      TRUE    A port using the protocol was found.6 **      FALSE   No port using this protocol was found. ** **  SIDE EFFECTS:  **
 **      None.r ** **-- */? int VCIReceive( lineId line, PPPBuffer *buf, u_short protocol )n {l@     int  match = FALSE;	/* TRUE if port using protocol found  */;     PPPPort *port;	/* pointer to a port structure        */        /* U.      ** Find port using this protocol and pass"      ** the buffer onto the client      */ )     for ( port = LINE_ENTRY(line)->ports;  	  port != NULL; 	  port = port->next )     {e$ 	if ((port->protocol == protocol) ||" 	    (port->protocol == PPP_IP && ? 	    (protocol == PPP_VJC_COMP || protocol == PPP_VJC_UNCOMP)))  	{ 	    match = TRUE; 	    /* A 	     ** If the port is in a Usable state then pass the buffer upg 	     ** to the client 	     */! 	    if ( port->state == Usable )( 	    {' 		buf->vcrp$l_connection_id = protocol; 1 		VCICall( port->vcib->VCIBReceiveComplete, buf, t 			 port->vcib );* 	    }  	    break; /* exit port loop */ 	} /* end-if port->protocol */     } /* end-for port */          return (match);  }u     /* **++ **  FUNCTION NAME: ** **      VCITransmitInitC ** **  FUNCTIONAL DESCRIPTION:  **L **      This routine is called to transmit data on the VCI port.  The callerJ **      of this routine must have left HDR_SIZE bytes at the start of the I **      packet and FCS_SIZE bytes at the end of the packet.   The routinerK **      does not verify that these conditions have been met.  If the packet @ **      is too long or zero in length an error will be returned. **T **      The protocol to send is specified by the connection_id field of the request.S **      If this value is zero then the protocol field in the port is used.  If the  S **      value is non-zero then the field must either match the value in the port or S **      be an associated protocol e.g. VJ compressed packet if the protocol is IP. c ** **  FORMAL PARAMETERS: **8 **      vcib       Pointer to the VCIB for the transmit.A **      request    Buffer containing the packet to be transmitted	 ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:( **
 **      None.s **& **  function value or completion codes **
 **      None.	 **< **      The function is completed by calling the upper VCM's@ **      TRANSMIT_COMPLETE service and the status of the functionA **      is set in the vcrp$l_request_status field of the request.  ** **  SIDE EFFECTS:	 **
 **      None.d ** **-- */< void VCITransmitInit( VCIBPPPDEF *vcib, PPPBuffer *request ) {	L     u_int     status = SS$_NORMAL; /* status of transmit - assume success */A     PPPPort   *port;		   /* pointer to the port using the vcib */eD     u_int     protocol;		   /* protocol to send                   */  4     /* check that the buffer length is acceptable */5     if ( BUF_DATA_LEN(request) > vcib->VCIBPPPMtu || P%          BUF_DATA_LEN(request) == 0 )o     {a 	status = SS$_IVBUFLEN;	     }      else     {w/ 	/* check port is in a state to send packets */:% 	if ( vcib->VCIBPPPPortId == NULL || )B              ((PPPPort *)(vcib->VCIBPPPPortId))->state != Usable ) 	{ 	    status = SS$_DEVINACT;  	} 	else  	{      	    port = vcib->VCIBPPPPortId; 		) 	    /* Determine the protocol to send */	. 	    protocol = request->vcrp$l_connection_id; 	    if ( protocol != 0 )  	    {# 		if ( protocol != port->protocol )t 		{ ) 		    if (!( port->protocol == PPP_IP &&  ? 			  (protocol == PPP_VJC_COMP || protocol == PPP_VJC_UNCOMP)))  		    {  			status = SS$_BADPARAM;P 		    }A 		}) 	    }	 	    else  	    { 		protocol = port->protocol; 	    }    	    if ( status == SS$_NORMAL ) 	    { 		/*B 		 ** Transmit the packet - saving a ptr to port for the TxCompl.  		 */B+ 		BUF_PUSH( request, port, sizeof(port) ); _2 		deviceTransmit( port->line, protocol, request ); 	    } 	}     }	3     /* increment count of outstanding writes */    S     port->writes++;m  C     /* complete the transmit back to client if an error occurred */(     if ( status != SS$_NORMAL )e     {/) 	request->vcrp$l_request_status = status; 6 	VCICall( vcib->VCIBTransmitComplete, request, vcib );     };        return;  }    n /* **++ **  FUNCTION NAME: ** **      VCITransmitCompl ** **  FUNCTIONAL DESCRIPTION:  **K **      This routine handles a completed transmit request.  The VCIB of the K **      upper VCM that orignated the request is obtained by popping it off )N **      the context stack of the buffer.   The buffer is then returned to the  **      upper VCM.       ** **  FORMAL PARAMETERS: **8 **      buf    Buffer containing the completed transmit. ** **  IMPLICIT INPUTS: **
 **      None._ ** **  IMPLICIT OUTPUTS:L **
 **      None.C **& **  function value or completion codes **
 **      None.l ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */' void VCITransmitCompl( PPPBuffer *buf )* { =     PPPPort  *port;		/* pointer to the port using the vcib */*       /* t6      ** Pop the port off the stack and decrement count#      ** count of outstanding writese      */i'     BUF_POP( buf, port, sizeof(port) );f     port->writes--;d  !     /* return buffer to client */ I     VCIForkCall( port->vcib->VCIBTransmitComplete, buf, port->vcib );       2     /* If a disable is pending then complete it */(     if ( port->state == DisablePending )     {g- 	VCIDisablePortCompl( port, port->request );       }o          return;  }*        