I /************************************************************************ I **                                                                      * I ** Copyright  1996 Digital Equipment Corporation.                      * I ** All rights reserved.                                                 * I **                                                                      * I ** Redistribution and use in source and binary forms are permitted      * I ** provided that the above copyright notice and this paragraph are      * I ** duplicated in all such forms and that any documentation,             * I ** advertising materials, and other materials related to such           * I ** distribution and use acknowledge that the software was developed     * I ** by Digital Equipment Corporation.  The name of the                   * I ** Corporation may not be used to endorse or promote products derived   * I ** from this software without specific prior written permission.        * I ** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       * I ** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       * I ** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * I **                                                                      * I *************************************************************************  **++
 **  FACILITY:  ** **      ppp_vci.h. **
 **  ABSTRACT:  **G **      Constant defintions and external defs of variables in ppp_vci.c  ** **  AUTHORS: **; **      Patrick Crilly,   Networks Engineering (Australia).  ** **  CREATION DATE: **, **      17-December-1996  Barry W. KiersteinF **                        Replaced the standard Digital copyright with@ **                        one compatible with the CMU copyright. **, **      24-July-1996      Barry W. Kierstein5 **                        Corrected copyright notice.  ** **      27-November-1995 ** **  MODIFICATION HISTORY:  **+ **      27-November-1995  Original version.  ** **-- */ #ifndef _PPP_VCI_H_  #define _PPP_VCI_H_    /* ** ** import definitions: **        prototype macro  **        types  ** */ #ifndef _PPPD_H_ #include "pppd.h"  #endif   /* ** ** import definitions:
 **        fsm  ** */ #ifndef _FSM_H_  #include "fsm.h" #endif   /* ** ** import definitions: **        PPPBuffer  ** */ #ifndef _PPP_BUF_H_  #include "ppp_buf.h" #endif   /* ** ** import definitions: **        SS$_xxx  ** */ #ifndef __SSDEF_LOADED #include "ssdef.h" #endif   /* ** ** import definitions: **        vcrp ** */ #ifndef __VCRPDEF_LOADED #include "vcrpdef.h" #endif   /* ** ** import definitions: **        vcibdef  ** */ #ifndef _VCIBDEF_H_  #define _VCIBDEF_H_ B #define VCIBDEF vcibdef /* work around broken vcibdef.h in V7.1 */ #include "vcibdef.h" #endif   /* ** ** import definitions: **        vcibpppdef ** */ #ifndef __PPP_VCI_IF_LOADED  #include "ppp_vci_if.h"  #endif  4 #define PPP_VERSION  1		/* Version of the PPP VCM */   /*: ** Definitions for accessing fields in a PPPVcib structure */0 #define VCIBPPPPortId	        vcib$a_ppp_port_id+ #define VCIBPPPFcsSize		vcib$b_ppp_fcs_size 2 #define VCIBPPPHdrSize	        vcib$b_ppp_hdr_size) #define VCIBPPPMtu	        vcib$w_ppp_mtu    /*3 ** Define Events that can be received from the line  */ typedef enum _lineEvent  { =     LCPDown,		/* LCP has left the OPENED state             */ @     LCPFinished,	/* LCP no longer requires the comm. port     */;     LCPUp,		/* LCP has entered the OPENED state          */ @     DeviceFail,		/* The comm. port has failed                 */F     LineDeleted        /* The PPP line has been deleted             */ } lineEvent;   /*< ** Define Events that can be received from the state machine */ typedef enum _NCPEvent { =     NCPDown,		/* NCP has left the OPENED state             */ @     NCPFinished,	/* NCP no longer requires the comm. port     */;     NCPUp,		/* NCP has entered the OPENED state          */ ?     NCPStopped		/* NCP has been stopped by Client            */  } NCPEvent;    /*5 ** Define Events that can be received from management  */ typedef enum _mgmtEvent  { 7     MgmtDisable,   /* The PPP line has been disabled */ 6     MgmtEnable	   /* The PPP line has been enabled  */ } mgmtEvent;   /*% ** Define the states a port can be in  */ typedef enum _portState  {      Enabled,
     Disabled,      DisablePending,      Failed,	     Usable,      Unusable } portState;   /* ** Define a port structure.    **  D ** A port represents a single protocol running over a communications ** port.  (e.g. IP over ASN2:)   */ typedef struct PPPPort { Q     struct PPPPort *next;	  /* Next port in linked list                        */ Q     VCIBPPPDEF     *vcib;	  /* Pointer to the vcib for this port               */ W     fsm            *fsmPtr;       /* Pointer to the FSM for contol protocol          */ W     u_int          protocol;      /* Protocol using this port                        */ P     lineId         line;	  /* Identifier of line this port is using           */Q     portState      state;	  /* State of the port                               */ W     char           NCPTerminated; /* TRUE if the NCP using the port has been stopped */ W     u_int          writes;        /* Count of outstanding writes                     */ T     struct vcrpdef *request;	  /* Queued client request                           */
 } PPPPort;   /* ** Declare VCI routines  */   /* Create Port */ \ #pragma linkage VCICreatePortLnkg = (parameters(r4), preserved(r1,r2,r4,r5), nopreserve(r0))5 #pragma use_linkage VCICreatePortLnkg (VCICreatePort) & int VCICreatePort( VCIBPPPDEF *vcib );   /* Delete Port */ \ #pragma linkage VCIDeletePortLnkg = (parameters(r4), preserved(r1,r2,r4,r5), nopreserve(r0))5 #pragma use_linkage VCIDeletePortLnkg (VCIDeletePort) & int VCIDeletePort( VCIBPPPDEF *vcib );   /* Transmit Initiate */ a #pragma linkage VCITransmitInitLnkg = (parameters(r4,r3), preserved(r2,r4,r5), nopreserve(r0,r1)) 9 #pragma use_linkage VCITransmitInitLnkg (VCITransmitInit) = void VCITransmitInit( VCIBPPPDEF *vcib, PPPBuffer *request );    /* PortMgmt Initiate */ a #pragma linkage VCIPortMgmtInitLnkg = (parameters(r4,r3), preserved(r2,r4,r5), nopreserve(r0,r1)) 9 #pragma use_linkage VCIPortMgmtInitLnkg (VCIPortMgmtInit) B void VCIPortMgmtInit( VCIBPPPDEF *vcib, struct vcrpdef *request );   /*
 ** Prototypes  */6 void  VCIDemuxprotrej( lineId line, u_short protocol);B void  VCIDisablePort( VCIBPPPDEF *vcib, struct vcrpdef *request );D void  VCIDisablePortCompl( PPPPort *port, struct vcrpdef *request );A void  VCIEnablePort( VCIBPPPDEF *vcib, struct vcrpdef *request ); 3 void  VCILineEvent( lineId line, lineEvent event ); 3 void  VCIMgmtEvent( lineId line, mgmtEvent event ); 3 void  VCINCPEvent( PPPPort *port, NCPEvent event ); B int   VCIReceive( lineId line, PPPBuffer *buf, u_short protocol );) void  VCITransmitCompl( PPPBuffer *buf );    #endif /* _PPP_VCI_H */ 