  #pragma module pppd$asnfdt "X-4" /*N  *****************************************************************************  *  2  * Copyright  1996 Digital Equipment Corporation.  * All rights reserved.   *B  * Redistribution and use in source and binary forms are permittedB  * provided that the above copyright notice and this paragraph are;  * duplicated in all such forms and that any documentation, =  * advertising materials, and other materials related to such C  * distribution and use acknowledge that the software was developed 5  * by Digital Equipment Corporation.  The name of the E  * Corporation may not be used to endorse or promote products derived @  * from this software without specific prior written permission.A  * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR A  * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED F  * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  *  N  *****************************************************************************      
 	FACILITY:    		ASNDRIVER    
 	ABSTRACT:     A   		This module contains a the FDT routines used by the Driver.   
 	They are:  + 		asn$read	-	FDT routine for read function  , 		asn$sense	-	FDT routine for sense function) 		asn$set		-	FDT routine for set function , 		asn$write	-	FDT routine for write function     	AUTHOR:   $ 		Forrest A. Kenney	07-February-1996    	REVISION HISTORY:   C         X-4     BWK002          Barry W. Kierstein      17-DEC-1996 <                 Replaced the standard Digital copyright with6                 one compatible with the CMU copyright.  C         X-3     BWK001          Barry W. Kierstein      24-JUL-1996 +                 Corrected copyright notice.   .   	X-2	FAK001	Forrest A. Kenney 	24-April-1996C   		Always return SS$_FDT_COMPL instead of status of last call.  In @ 		the set code make sure we complete the I/O after we queue the  		AST.   */      6 /* Define system data structure types and constants */  7 #include	<acbdef.h>	/* AST control block definitions	*/ : #include	<ccbdef.h>	/* Channel Control Block definitons	*/= #include	<crbdef.h>	/* Controller Request Block definitons	*/ 7 #include	<ddbdef.h>	/* Device data block definitions	*/ ; #include	<ddtdef.h>	/* Driver Dispatch table definitions	*/ 2 #include	<descrip.h>	/* DEscriptor definitions		*/9 #include	<dyndef.h>	/* Data structure type definitions	*/ 1 #include	<fkbdef.h>	/* Fork block definitions		*/ > #include	<idbdef.h>	/* Interrupt Dispatch Block Definitions	*/8 #include	<iodef.h>	/* I/O function code and modifiers	*/. #include	<ints.h>	/* interger definitions			*/8 #include	<irpdef.h>	/* I/O Request Packet definitions	*/9 #include	<orbdef.h>	/* Object rights Block definitions	*/ ; #include	<pcbdef.h>	/* Process Control Block definitions	*/ 3 #include	<splcoddef.h>	/* Spinlock definitions			*/ / #include	<ssdef.h>	/* Status return valuse			*/ 5 #include	<ttdef.h>	/* Terminal definitions TT$xxx		*/ @ #include	<ttysymdef.h>	/* TTY symbols private to class driver	*/. #include	<ttyucbdef.h>	/* TTY UCB offsets			*/( #include	<ucbdef.h>	/* UCB offsets				*/, #include	<vcrpdef.h>	/* VCRP defnitions			*/  G #define		VCIBDEF	vcibdef	/* This is needed to work around an incorrect  $ 				   definition for VCIB in LIB *.    = /* Define ASN specific data structures types and constants */   1 #include	"asndef.h"		/* ASN public definitions	*/ 5 #include	"asnmiscdef.h"		/* ASN miscellanous items	*/ * #include	"asnvcibdef.h"		/* ASN VCIB 			*/> #include	"pppd$asn_hide_ptrs.h"	/* Hide long paths to items	*/: #include	"pppd$asn_linkages.h"	/* JSR register linkages	*/B #include	"pppd$asn_prototypes.h"	/* Prototypes for ASN routines	*/    4 /* Define function prototypes for system routines */  I #include	<com_routines.h> /* Prototypes for com$ and com_sdt$ routines */ I #include	<exe_routines.h> /* Prototypes for exe$ and exe_std$ routines */ I #include	<ioc_routines.h> /* Prototypes for ioc$ and ioc_std$ routines */ I #include	<sch_routines.h> /* Prototypes for sch$ and sch_std$ routines */     ) /* Define various device driver macros */   F #include	<vms_drivers.h>	/* Device driver support macros, including */3 				/* table initialization macros and prototypes*/     4 /* Define the DEC C functions used by this driver */  D #include	<builtins.h>	/* OpenVMS AXP specific C builtin functions */C #include	<string.h>	/* String routines provided by "kernel CRTL" */        /* **++, **	asn$read - FDT routine for read function  ** ** Functional description: **J **	This routine is called by the FDT dispatcher in the $QIO system serviceG ** to process read functions.  This FDT routine validates the request,  G ** allocates a buffered I/O packet and queues the IRP to this driver's   ** start I/O routine.  **I **	When the IRP is successfully queued to the driver's start I/O routine, O ** IRP$L_SVAPTE points to the buffered I/O packet, IRP$L_BOFF is the number of  K ** bytes that have been charged against the process, and IRP$L_BCNT is the  M ** actual count of data bytes available for data in the buffered I/O packet.  N ** Note that the contents of the IRP$L_SVAPTE and IRP$L_BOFF cells must not beM ** changed since I/O post processing will use these to deallocate the buffer  $ ** packet and to credit the process. **I **	Since this is an upper-level FDT routine, this routine always returns  L ** the SS$_FDT_COMPL status.  The $QIO status that is to be returned to the G ** caller of the $QIO system service is returned indirectly by the FDT  F ** completion routine exe_std$qiodrvpkt via the FDT context structure. ** ** Calling convention: **> **	int	asn$read (IRP *irp, PCB *pcb, ASNUCB *asnucb, CCB *ccb) ** ** Input parameters: **$ **	IRP	pointer to I/O request packet$ **	PCB	pointer process control block' **	ASNUCB	pointer to unit control block ' **	CCB	pointer to channel control block  ** ** Output parameters:  ** **	None  ** ** Return value: ** **      SS$_FDT_COMPL  ** ** Environment:  **, **	Kernel mode, user process context, IPL 2. ** **-- */: int	asn$read(IRP *irp, PCB *pcb, ASNUCB *asnucb, CCB *ccb) {    char		*data_ptr; char		*user_buffer;    int		buffer_length;  int32		return_length;  int		status;   SYSBUF_HDR	*system_buffer;    ) user_buffer = (char *) irp->irp$l_qio_p1; " buffer_length = irp->irp$l_qio_p2;  = if (((void *)asnucb->ASNLOG.ucb$l_tl_phyucb != (void *) 0) && !     (!asnucb->ucb$v_asn_delpend))  { Q    if ((buffer_length > MINIMUM_MRU) && (buffer_length <= asnucb->ucb$l_asn_mru))     {E       status = exe_std$readchk(irp, pcb, (UCB *) asnucb, user_buffer, .                                buffer_length);       if (status & SS$_NORMAL)       { <          buffer_length = buffer_length + sizeof(SYSBUF_HDR);O          status = exe_std$debit_bytcnt_alo(buffer_length, pcb, &return_length,  E                                            (void **) &system_buffer); !          if (status & SS$_NORMAL) 
          {7             irp->irp$l_svapte = (void *) system_buffer; ,             irp->irp$l_boff = return_length;0             irp->irp$l_bcnt = irp->irp$l_qio_p2;C             data_ptr = (char *) system_buffer + sizeof(SYSBUF_HDR); 0             system_buffer->pkt_datap = data_ptr;2             system_buffer->usr_bufp = user_buffer;4             system_buffer->pkt_size = return_length;9             status = call_qiodrvpkt(irp, (UCB *) asnucb); 
          }
          else 
          {D             status = call_abortio(irp, pcb, (UCB *) asnucb, status);
          }       } 
       else       { A          status = call_abortio(irp, pcb, (UCB *) asnucb, status);        }     }    else     {D       status = call_abortio(irp, pcb, (UCB *) asnucb, SS$_IVBUFLEN);    } }  else { B     status = call_abortio(irp, pcb, (UCB *) asnucb, SS$_DEVINACT); }    return SS$_FDT_COMPL;    }        /* **++- **	asn$sense - FDT routine for sense function  ** ** Functional description: **C **		This routine is called by the FDT dispatcher in the $QIO system O ** service to process sense mode and sense characteristics functions.  The item M ** list is checked for read access, and that the list is the correct length.  L ** If all is ok, the list is gone through one item at a time and the routineP ** asn$do_sense_item is called.  It an error occurs the walk is stopped and the  ** error is returned.  **H **	Since this is an upper-level FDT routine, this routine always returnsL ** the SS$_FDT_COMPL status.  The $QIO status that is to be returned to the G ** caller of the $QIO system service is returned indirectly by the FDT  L ** completion routines (e. g. EXE_STD$ABORTIO, EXE_STD$FINISHIO) viathe FDT  ** context structure.  ** ** Calling convention: **? **	int	asn$sense (IRP *irp, PCB *pcb, ASNUCB *asnucb, CCB *ccb)  ** ** Input parameters: **$ **	IRP	pointer to I/O request packet$ **	PCB	pointer process control block' **	ASNUCB	pointer to unit control block ' **	CCB	pointer to channel control block  ** ** Output parameters:  ** **	None  ** ** Return value: ** **	SS$_FDT_COMPL ** ** Environment:  **, **	Kernel mode, user process context, IPL 2. ** **-- */; int	asn$sense(IRP *irp, PCB *pcb, ASNUCB *asnucb, CCB *ccb)  {    char		*buffer; char		*buffer_end;   int		acmode = 0; int		buffer_len; int		status;     if (!asnucb->ucb$v_asn_delpend)  { '    buffer = (char *) irp->irp$l_qio_p1; "    buffer_len = irp->irp$l_qio_p2;)    if ((buffer_len%sizeof(LSTITM)) == 0)      {C       status = exe_std$prober((void *) buffer, buffer_len, acmode);        if (status & SS$_NORMAL)       { *          buffer_end = buffer + buffer_len;  ?          while ((buffer < buffer_end) && (status & SS$_NORMAL)) 
          {I             status = asn$do_sense_item(asnucb, (LSTITM *) buffer, PROBE); $             if (status & SS$_NORMAL)
             { (                buffer += sizeof(LSTITM);
             } 
          }"          if (buffer >= buffer_end)
          {8             status = call_finishio(irp, (UCB *) asnucb, A                                    buffer_len << 16 | status, 0); 
          }
          else 
          {D             status = call_abortio(irp, pcb, (UCB *) asnucb, status);
          }       }e
       else       {*A          status = call_abortio(irp, pcb, (UCB *) asnucb, status);*       }*    }    elsep    {D       status = call_abortio(irp, pcb, (UCB *) asnucb, SS$_BADPARAM);    } }r else {nB     status = call_abortio(irp, pcb, (UCB *) asnucb, SS$_DEVINACT); }o   return SS$_FDT_COMPL;h   }r     a /* **++) **	asn$set	- FDT routine for set functionm ** ** Functional description: **C **	This routine is called by the FDT dispatcher in the $QIO system wL ** service to process set mode and set characteristics functions.  The item L ** list is checked for read access, and that the list is the correct length.M ** If all is ok, the list is gone through one item at a time and the rotuine *N ** asn$do_set_item is called.  If the hang-up AST is being enabled or disabledO ** the item list validation steps are skipped.  Instead the AST will be enabledIN ** or disabled by calling COM_STD$SETATTNAST.  This FDT routine completes the B ** I/O request without sending it to the driver start I/O routine. **I **	Since this is an upper-level FDT routine, this routine always returns uL ** the SS$_FDT_COMPL status.  The $QIO status that is to be returned to the G ** caller of the $QIO system service is returned indirectly by the FDT TM ** completion routines (e. g. exe_std$abortio, exe_std$finishio) via the FDT A ** context structure.. ** ** Calling convention: **= **	int	asn$set (IRP *irp, PCB *pcb, ASNUCB *asnucb, CCB *ccb)K ** ** Input parameters: **$ **	IRP	pointer to I/O request packet$ **	PCB	pointer process control block' **	ASNUCB	pointer to unit control block ' **	CCB	pointer to channel control blockK ** ** Output parameters:  ** **	None  ** ** Return value: ** **	SS$_FDT_COMPL ** ** Environment:  **, **	Kernel mode, user process context, IPL 2. ** **-- */9 int	asn$set(IRP *irp, PCB *pcb, ASNUCB *asnucb, CCB *ccb)t {I   char		*buffer; char		*buffer_end;   int		acmode = 0; int		buffer_len; int		status;   LSTITM		*item;     if (!asnucb->ucb$v_asn_delpend)d {n%    if (irp->irp$l_func & IO$M_HANGUP)n    {A       status = com_std$setattnast(irp, pcb, (UCB *) asnucb, ccb,  K                                   (ACB **) &asnucb->ASNLOG.ucb$l_tl_ctrly); =       status = call_finishio(irp, (UCB *) asnucb, status, 0);     }    elsei    {*       buffer = (char *) irp->irp$l_qio_p1;%       buffer_len = irp->irp$l_qio_p2;s,       if ((buffer_len%sizeof(LSTITM)) == 0)        { F          status = exe_std$prober((void *) buffer, buffer_len, acmode);!          if (status & SS$_NORMAL)n
          {-             buffer_end = buffer + buffer_len;	    iB             while ((buffer < buffer_end) && (status & SS$_NORMAL))
             {c(                item = (LSTITM *) buffer;6                if (item->itm$w_type == ASN$_ACCM_XMIT)                {@                   status = exe_std$prober(item->itm$l_buffaddr, F                                           item->itm$w_length, acmode);                }    /'                if (status & SS$_NORMAL)                 {F                   status = asn$do_set_item(asnucb, (LSTITM *) buffer);*                   if (status & SS$_NORMAL)                   {v.                      buffer += sizeof(LSTITM);                   }t                }
             }f%             if (buffer >= buffer_end)a
             { ;                status = call_finishio(irp, (UCB *) asnucb, uD                                       buffer_len << 16 | status, 0);
             }B             else
             {tG                status = call_abortio(irp, pcb, (UCB *) asnucb, status);S
             }a
          }
          elsep
          {D             status = call_abortio(irp, pcb, (UCB *) asnucb, status);
          }       }/
       else       {tG          status = call_abortio(irp, pcb, (UCB *) asnucb, SS$_BADPARAM);o       }     } }y else {xB     status = call_abortio(irp, pcb, (UCB *) asnucb, SS$_DEVINACT); }o   return SS$_FDT_COMPL;n   }      u /* **++- **	asn$write - FDT routine for write functiono ** ** Functional description: **J **	This routine is called by the FDT dispatcher in the $QIO system serviceH ** to process write functions.  This FDT routine validates the request, N ** allocates a buffered I/O packet and copies the contents of the user buffer N ** into the buffered I/O packet, and queues the IRP to this driver's alternate ** start I/O routine." **I **	When the IRP is successfully queued to the driver's start I/O routine, L ** IRP$L_SVAPTE points to the buffered I/O packet, IRP$L_BOFF is the number N ** of bytes that have been charged against the process, and IRP$L_BCNT is the M ** actual count of data bytes in the buffered I/O packet that are to be sent  K ** to be sent .  Note that the contents of the IRP$L_SVAPTE and IRP$L_BOFF sI ** cells must not be changed since I/O post processing will use these to  : ** deallocate the buffer packet and to credit the process. **I **	Since this is an upper-level FDT routine, this routine always returns tL ** the SS$_FDT_COMPL status.  The $QIO status that is to be returned to the G ** caller of the $QIO system service is returned indirectly by the FDT eJ ** completion routines (e. g. exe_std$abortio, exe_std$altquepkt) via the  ** FDT context structure.i ** ** Calling convention: **? **	int	asn$write (IRP *irp, PCB *pcb, ASNUCB *asnucb, CCB *ccb)* ** ** Input parameters: **$ **	IRP	pointer to I/O request packet$ **	PCB	pointer process control block' **	ASNUCB	pointer to unit control block ' **	CCB	pointer to channel control block  ** ** Output parameters:r ** **	Nonel ** ** Return value: ** **	SS$_FDT_COMPL ** ** Environment:  **, **	Kernel mode, user process context, IPL 2. ** **-- */; int	asn$write(IRP *irp, PCB *pcb, ASNUCB *asnucb, CCB *ccb)  {A   char		*data_ptr; char		*user_buffer;C   int		buffer_length;o int32		return_length;t int		status;   SYSBUF_HDR	*system_buffer;    > if (((void *) asnucb->ASNLOG.ucb$l_tl_phyucb != (void *) 0) &&!     (!asnucb->ucb$v_asn_delpend))P {.,    user_buffer = (char *) irp->irp$l_qio_p1;%    buffer_length = irp->irp$l_qio_p2;r  0    if (((buffer_length + 4) >= MINIMUM_MTU ) && 0        (buffer_length <= asnucb->ucb$l_asn_mtu))    {F       status = exe_std$writechk(irp, pcb, (UCB *) asnucb, user_buffer,.                                buffer_length);       if (status & SS$_NORMAL)       { <          buffer_length = buffer_length + sizeof(SYSBUF_HDR);O          status = exe_std$debit_bytcnt_alo(buffer_length, pcb, &return_length,  E                                            (void **) &system_buffer); !          if (status & SS$_NORMAL)g
          {7             irp->irp$l_svapte = (void *) system_buffer;h,             irp->irp$l_boff = return_length;0             irp->irp$l_bcnt = irp->irp$l_qio_p2;C             data_ptr = (char *) system_buffer + sizeof(SYSBUF_HDR);(0             system_buffer->pkt_datap = data_ptr;2             system_buffer->usr_bufp = user_buffer;4             system_buffer->pkt_size = return_length;=             memcpy(data_ptr, user_buffer, irp->irp$l_qio_p2);l3             exe_std$altquepkt(irp, (UCB *) asnucb);e
          }
          else 
          {D             status = call_abortio(irp, pcb, (UCB *) asnucb, status);
          }       } 
       else       {-A          status = call_abortio(irp, pcb, (UCB *) asnucb, status);,       }a    }    else     {D       status = call_abortio(irp, pcb, (UCB *) asnucb, SS$_IVBUFLEN);    } }  else {tA    status = call_abortio(irp, pcb, (UCB *) asnucb, SS$_DEVINACT);  }a   return SS$_FDT_COMPL;    }n  