" #pragma module pppd$asnmisc "X-10" /*N  *****************************************************************************  *  2  * Copyright  1996 Digital Equipment Corporation.  * All rights reserved.   *B  * Redistribution and use in source and binary forms are permittedB  * provided that the above copyright notice and this paragraph are;  * duplicated in all such forms and that any documentation, =  * advertising materials, and other materials related to such C  * distribution and use acknowledge that the software was developed 5  * by Digital Equipment Corporation.  The name of the E  * Corporation may not be used to endorse or promote products derived @  * from this software without specific prior written permission.A  * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR A  * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED F  * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  *  N  *****************************************************************************      
 	FACILITY:    		ASNDRIVER    
 	ABSTRACT:     C   		This module contains a number of misceallanous routines used by  	the driver.  They are:   6 		asn$cancel_active_io	-	Cancels active read and write# 						if any are active.            / 		asn$cancel_all_io	-	Kills off all pending and  						current I/O requests" 		asn$delete_ucb		-	Delete ASN UCB7 		asn$do_sense_item	-	Get value for specified parameter , 		asn$do_set_item		-	Set specified parameter+ 		asn$enable_receive	-	Allow input to start 6 		asn$fcs_check		-	Check received packets FCS is valid: 		asn$fcs_compute		-	Compute the FCS and save it in buffer( 		asn$fcs16_compute	-	Compute 16 bit FCS( 		asn$fcs32_compute	-	Compute 32 bit FCS4 		asn$fork_dispatch	-	Dispatch various fork requests1 		asn$input_resume	-	Start reception of chracters . 		asn$input_stop 		-	Stop receipt of chractersE 		asn$move_sense_data	-	Copy data from system data area to user bufer 9 		asn$prepare_for_delete	-	Get device ready to be deleted  		asn$quote		-	Quote a buffer - 		asn$unquote		-	Remove quoting from a buffer * 		asn$write_start		-	Start a write request   	AUTHOR:   # 		Forrest A. Kenney	13-January-1996     	REVISION HISTORY:  , 	X-10	FAK009	Forrest A. Kenney	17-march-1997) 		Remove extra fork lock and unlock from    . 	X-9	FAK008	Forrest A. Kenney	26-February-1997/ 		In asn$write_start change exe_std$allocbuf to = 		exe_std$alononpaged, exe_std$allocbuf sets IPL 2 not a good + 		idea when the routine is called at IPL 8.   0   	X-8	FAK007	Forrest A. Kenney	30-December-1996A 		In the asn$write_start add comment to explain the addition of 2 A 		to the size of the packet to be sent.  Also add code to delete  ? 		the write buffer if the quote operation should fail.  Note at = 		the present time this should be impossible as the buffer is = 		always allocated to be large enough to have every character 	 		quoted.   , 		BWK001	Barry W. Kierstein	17-December-1996. 		Replaced the standard Digital copyright with( 		one compatible with the CMU copyright.  . 	X-7	FAK006	Forrest A. Kenney	04-November-1996? 		We are now going to get a write buffer when we start a write  < 		and free it when a write is completed.  This allows us to @ 		clear the write flag when we abort a write or when it is done.@ 		We loose a little performance in the worse case allocating and9 		deallocating pool but we simplify the logic for writes.   5 			1) asn$write_start add code to allocate the write  
 			   buffer. / 			2) asn$delete_ucb do not delete write buffer 7 			3) asn$cancel_active_io clear the writing state flag   /   	X-6	FAK005	Forrest A. Kenney	03-October-1996 = 		Do not clear the writing state when aborting the write.  It 6 		will be cleared when the write completion fork runs.  * 	X-5	FAK004	Forrest A. Kenney	17-July-1996: 		Remove infinite loop from the asn$fork_dispatch routine.  * 	X-4	FAK003	Forrest A. Kenney	13-June-19963 		Return correct status when setting transmit ACCM.   + 	X-3	FAK002	Forrest A. Kenney	24-April-1996 6 		Fix up some problems found during a code inspection.  6 			a) Comment in cancel_all_io about IPL was incorrect: 			b) Treated IRP as VCRP and VCRP as IRP in cancel_all_io4 			c) In asn$do_set_item for the disconnect call set% 			   return status to normal always. : 			d) In asn$do_set_item and asn$do_sense_item fix broken 2 			   attempt to make sure we only got the bits we 			   expected. : 			e) In asn$do_sense_item was passing was passing counter$ 			   instead of address of counter.  -   	X-2	FAK001	Forrest A. Kenney	12-April-1996 ( 		Fix a number of bugs found in testing.  < 		   a) Reset counters on a set was using wrong item length.= 		   b) In the reset counters set return status to success it - 		      will be changed if there is an error.      */      6 /* Define system data structure types and constants */  7 #include	<acbdef.h>	/* AST control block definitions	*/ : #include	<ccbdef.h>	/* Channel Control Block definitons	*/= #include	<crbdef.h>	/* Controller Request Block definitons	*/ 2 #include	<descrip.h>	/* DEscriptor definitions		*/7 #include	<ddbdef.h>	/* Device data block definitions	*/ ; #include	<ddtdef.h>	/* Driver Dispatch table definitions	*/ 9 #include	<dyndef.h>	/* Data structure type definitions	*/ 1 #include	<fkbdef.h>	/* Fork block definitions		*/ 1 #include	<iocdef.h>	/* I/O database constants		*/ > #include	<idbdef.h>	/* Interrupt Dispatch Block Definitions	*/. #include	<ints.h>	/* interger definitions			*/+ #include	<ipldef.h>	/* IPL definitions			*/ 8 #include	<irpdef.h>	/* I/O Request Packet definitions	*/9 #include	<orbdef.h>	/* Object rights Block definitions	*/ ; #include	<pcbdef.h>	/* Process Control Block definitions	*/ 3 #include	<splcoddef.h>	/* Spinlock definitions			*/ / #include	<ssdef.h>	/* Status return valuse			*/ 5 #include	<ttdef.h>	/* Terminal definitions TT$xxx		*/ @ #include	<ttysymdef.h>	/* TTY symbols private to class driver	*/. #include	<ttyucbdef.h>	/* TTY UCB offsets			*/( #include	<ucbdef.h>	/* UCB offsets				*/, #include	<vcrpdef.h>	/* VCRP defnitions			*/  G #define		VCIBDEF	vcibdef	/* This is needed to work around an incorrect  $ 				   definition for VCIB in LIB *.    = /* Define ASN specific data structures types and constants */   1 #include	"asndef.h"		/* ASN public definitions	*/ 5 #include	"asnmiscdef.h"		/* ASN miscellanous items	*/ * #include	"asnvcibdef.h"		/* ASN VCIB 			*/5 #include	"pppd$asn_fcstab.h"	/* FSC lookup tables		*/ > #include	"pppd$asn_hide_ptrs.h"	/* Hide long paths to items	*/: #include	"pppd$asn_linkages.h"	/* JSR register linkages	*/8 #include	"pppd$asn_msgtbl.h"	/* Abort packet message		*/B #include	"pppd$asn_prototypes.h"	/* Prototypes for ASN routines	*/    4 /* Define function prototypes for system routines */  I #include	<com_routines.h> /* Prototypes for com$ and com_sdt$ routines */ I #include	<exe_routines.h> /* Prototypes for exe$ and exe_std$ routines */ I #include	<ioc_routines.h> /* Prototypes for ioc$ and ioc_std$ routines */ I #include	<sch_routines.h> /* Prototypes for sch$ and sch_std$ routines */     ) /* Define various device driver macros */   F #include	<vms_drivers.h>	/* Device driver support macros, including */3 				/* table initialization macros and prototypes*/     4 /* Define the DEC C functions used by this driver */  D #include	<builtins.h>	/* OpenVMS AXP specific C builtin functions */C #include	<string.h>	/* String routines provided by "kernel CRTL" */        /* **++U **	asn$cancel_active_io - Cancels active read and write if any are active.             ** ** Functional description: **? **	This routine will cancel the active read and write requests.  ** ** Calling convention: **- **	void	asn$cancel_active_io (ASNUCB *asnucb)  ** ** Input parameters: **! **	asnucb		Address of the ASN UCB  ** ** Output parameters:  ** **	None  ** ** Return value: ** **	None  ** ** Environment:  **J **	Kernel mode IPL 8 fork thread with the fork lock held.  The device lock **	is acquired and released. ** **-- */) void	asn$cancel_active_io(ASNUCB *asnucb)  {    unsigned char	out_char;    int		saved_dipl;   ASNRD		*asnrd; ASNWRT		*asnwrt; TTY_UCB		*phyucb;     
 asnrd = 0; asnwrt = 0;   @ device_lock(asnucb->ASNBASE.ucb$l_dlck, RAISE_IPL, &saved_dipl);  7    phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;   %    if ((void *) phyucb != (void *) 0)     {!       if (phyucb->tty$v_st_write)        { <          asnwrt = (ASNWRT *) asnucb->ucb$l_asn_write_buffer;-          asnwrt->asnwrt$l_status = SS$_ABORT; $          phyucb->tty$v_st_write = 0;;          __ADD_ATOMIC_LONG(&asnucb->ucb$l_asn_fork_cnt, 1); ,          exe_std$queue_fork((FKB *) asnwrt);          port$abort(phyucb);          port$resume(phyucb); >          phyucb->ucb$w_tt_multilen = strlen(asn$abort_string);3          phyucb->ucb$l_tt_multi = asn$abort_string; $          phyucb->tty$v_st_multi = 1;*          out_char = class$getnext(phyucb);*          if (phyucb->ucb$b_tt_outype != 0)
          {+             port$startio(out_char, phyucb); 
          }       }             asn$input_stop(asnucb);         if (phyucb->tty$v_st_read)       { *          asnucb->ucb$v_asn_drop_chars = 1;3          asnrd = (ASNRD *) phyucb->ucb$l_tt_typahd; *          if ((void *) asnrd != (void *) 0)
          {(             phyucb->ucb$l_tt_typahd = 0;.             asnrd->asnrd$l_status = SS$_ABORT;/             asnrd->asnrd$l_fpc = asn$read_done; >             __ADD_ATOMIC_LONG(&asnucb->ucb$l_asn_fork_cnt, 1);.             exe_std$queue_fork((FKB *) asnrd);
          }       }     }C device_unlock(asnucb->ASNBASE.ucb$l_dlck, saved_dipl, SMP_RESTORE);      return;    }        /* **++E **	asn$cancel_all_io - Kills off all pending and current I/O requests  ** ** Functional description: **J **	This routine will unconditionally cancel all I/Os that are queued or on! ** going.  It does the following:  **9 **		1) Walks the queue of pending writes and aborts them. 8 **		2) Walks the queue of pending reads and aborts them.A **		3) Call asn$cancel_active_io to abort current read and write   ** ** Calling convention: *** **	void	asn$cancel_all_io (ASNUCB *asnucb) ** ** Input parameters: ** **	UCB	Pointer to the ASN UCB  ** ** Output parameters:* ** **	None* ** ** Return value: ** **	None* ** ** Environment:g **= **	Kernel mode, system context, fork IPL with fork lock held.  ** **-- */& void	asn$cancel_all_io(ASNUCB *asnucb) {a   int		saved_fipl; int		status;  
 IRP		*irp; TTY_UCB		*phyucb;p ASNVCIB		*asnvcib; VCRP		*vcrp;    - asnvcib = (ASNVCIB *) asnucb->ucb$l_asn_vcib;i /* m **% ** Clear the queue of pending writes c ** */0 while ((void *) &asnucb->ucb$l_asn_writeq_fl != ,        (void *) asnucb->ucb$l_asn_writeq_bl) {o@    status = __PAL_REMQUEL((void *) asnucb->ucb$l_asn_writeq_fl, )                           (void *) &irp);f    if (status >= 0)c    {'       if (irp->irp$b_type == DYN$C_IRP)        {`'          irp->irp$l_iost1 = SS$_CANCEL;I          irp->irp$l_iost2 = 0;!          com_std$post_nocnt(irp);W       } 
       else       {D          vcrp = (VCRP *) irp;S2          vcrp->vcrp$q_request_status = SS$_CANCEL;2          VCI$XXX_Transmit_Complete(vcrp, asnvcib);       }     } }E     /* **I ** Flush the queue of pending read I/O request.  In normal operation thiss! ** should never really be needed.  ** */0 while ((void *) &asnucb->ASNBASE.ucb$l_ioqfl != ,        (void *) asnucb->ASNBASE.ucb$l_ioqbl) {aO    status = __PAL_REMQUEL((void *) asnucb->ASNBASE.ucb$l_ioqfl, (void *) &irp);	    if (status >= 0)s    {$       irp->irp$l_iost1 = SS$_CANCEL;       irp->irp$l_iost2 = 0;-       com_std$post_nocnt(irp);    } }c   asn$cancel_active_io(asnucb);s   }_     - /* **++" **	asn$delete_ucb - Delete ASN UCB ** ** Functional description: **G **	The delete device routine is called from the fork dispatcher and is pK ** responsible for the actual deletion of the UCB.  This routine is called sM ** holding the fork and must acquire the I/O database mutex for write access  N ** before doing any significant processing.  If the mutex cannot be accessed, N ** the fork must be rescheduled to try again in one second.  Once the routine M ** acquires the mutex it performs a series of tests  to make sure the device $L ** is truly idle and can be deleted.  If any of the tests fails the process ' ** will be started again in one second.X ** ** Calling convention: **@ **	void	asn$delete_ucb (uint64 fr3, ASNUCB *asnucb, FKB *asnfkb) ** ** Input parameters: ** **	R3		zeron **	R4		pointer to ASN UCB_ **	R5		pointer to fork block ** ** Output parameters:  ** **	Nonet ** ** Return value: ** **	Nones ** ** Environment:  **F **	This routine is called holding the fork lock;  it acquires the I/O  **	database mutex. ** **-- */< void	asn$delete_ucb(uint64 fr3, ASNUCB *asnucb, FKB *asnfkb) {    int32		buffer_size;u int		saved_pid;  int		saved_quota;i int		status;   void		*packet;  
 ACB		*acb;
 PCB		*pcb;   extern		IOC$GQ_MUTEX;a    $ if (asnucb->ASNBASE.ucb$w_unit != 0) { <    status = sch_std$lockwexec_quad((MUTEX *) &IOC$GQ_MUTEX);    if (status & SS$_NORMAL)d    {.       if ((asnucb->ASNBASE.ucb$l_refc == 0) &&.           (asnucb->ASNBASE.ucb$q_fr4 == 0)  &&<           ((void *) asnucb->ucb$l_asn_vcib == (void *) 0) &&,           (asnucb->ucb$l_asn_fork_cnt == 0))       {pC          if ((void *) asnucb->ASNLOG.ucb$l_tl_phyucb != (void *) 0)i
          {             dyn$revert(asnucb);e
          }-          asnucb->ASNBASE.ucb$v_deleteucb = 1;p              /*f          **o=          **  Clean queue of free read packets and delete themi          **u          */ 9          while ((void *) &asnucb->ucb$l_asn_readq_fl !=  l4                 (void *) asnucb->ucb$l_asn_readq_fl)
          {H             status = __PAL_REMQUEL((void *) asnucb->ucb$l_asn_readq_fl, 5                                    (void *) &packet);l             if (status >= 0)
             {n+                exe_std$deanonpaged(packet); 
             }s
          }            /*0          **K?          **  Clean queue of filled read packets and delete them           **3          */s:          while ((void *) &asnucb->ucb$l_asn_packetq_fl != 6                 (void *) asnucb->ucb$l_asn_packetq_fl)
          {J             status = __PAL_REMQUEL((void *) asnucb->ucb$l_asn_packetq_fl, J                                    (void *) &packet);                                  if (status >= 0)
             {a+                exe_std$deanonpaged(packet);o
             }n
          }            /*x          **eM          **  Now save away the quota and PID of process that created the UCB.sL          **  Then allocate a ACB and fill it in.  If cannot get an ACB then O          **  quota will not be returned.  Then queue the AST to the procees whomN          **  created the UCB.  If the process is gone the the queue of the AST:          **  will delete the ACB.  Finally delete the UCB.          **m          */r0          saved_pid = asnucb->ASNBASE.ucb$l_cpid;4          saved_quota = asnucb->ASNBASE.ucb$w_charge;Q          status = exe_std$alononpaged(ACB$K_LENGTH, &buffer_size, (void *) &acb); !          if (status & SS$_NORMAL)c
          {*             acb->acb$w_size = buffer_size;(             acb->acb$b_type = DYN$C_ACB;)             acb->acb$b_rmod = ACB$M_KAST;d'             acb->acb$l_pid = saved_pid;t,             acb->acb$l_astprm = saved_quota;/             acb->acb$l_kast = asn$return_quota;<8             status = sch_std$qast(0, acb, (PCB *) &pcb);
          },          ioc_std$delete_ucb((UCB *) asnucb);:          sch_std$unlockexec_quad((MUTEX *) &IOC$GQ_MUTEX);       }n
       else       {e:          sch_std$unlockexec_quad((MUTEX *) &IOC$GQ_MUTEX);X          fork_wait(asn$delete_ucb, 0, (uint64) asnucb, (FKB *) &asnucb->ucb$l_asn_fqfl);       }n    }    elsec    {U       fork_wait(asn$delete_ucb, 0, (uint64) asnucb, (FKB *) &asnucb->ucb$l_asn_fqfl);	    } }c   }<     /* **++ **I **	Local kernel AST routine to return quota back to process that created o ** the pseudo terminal.e **
 ** Inputs: **# **	ACB	pointer to AST control blockh ** ** Outputs:	 ** **	Nonee ** ** Returns:C ** **	None	 ** ** Environment:D ** **	Kernel mode IPL 2 ** **-- */) void	asn$return_quota(PCB *pcb, ACB *acb)C {i    4 exe_std$credit_bytcnt_bytlm(acb->acb$l_astprm, pcb); exe_std$deanonpaged(acb);u   }s     	 /* **++8 **	asn$do_sense_item - Get value for specified parameter ** ** Functional description: **F **	This routine handles the determining what item to get data for and K ** getting that data  It take a pointer to the itemlist item that is to be iN ** handled.  It also takes a flag that indicates if it is being called from a N ** trusted mode or not.  This routine is common code for both the FDT and VCI 4 ** set code.  The VCI call is assumed to be trusted. ** ** Calling convention: **I **	int	asn$do_sense_item (ASNUCB *asnucb, LSTITM *item, int trusted_flag)i ** ** Input parameters: ** **	ASNUCB		Pointer to ASN UCBo= **	itemlist_item	Pointer to the itemlist item to be processedd? **	trusted		Flag that indicates that the call is trusted or noto ** ** Output parameters:s **, **	Various fields in the UCB may be changed. ** ** Return value: **( **	SS$_NORMAL	Call completed successfuly) **	SS$_ACCVIO	Could not access the buffers% **	SS$_BADPARAM	Parameter was invalidEB **	SS$_DEVINACT	Device is not in a state where the request can be  **			honored	 **	Othersi ** ** Environment:u **I **	Kernel mode, user process context, IPL 2, or as an IPL 8 fork thread  +J ** 	During execution IPL may be as high as DEVICE IPL and both the device ! **	and the fork lock may be held.c ** **-- */E int	asn$do_sense_item(ASNUCB *asnucb, LSTITM *item, int trusted_flag)* {l   char		*out_addr;   int		byte_count; int		item_counter;
 int		mask; int		status;   __int64		*src_item;	     switch (item->itm$w_type)* {t    /*a    **     **  Receive ACCM*    **     */     case ASN$_ACCM_RCV :r!      if (item->itm$w_length == 4)f      {I         status = asn$move_sense_data((char*) &asnucb->ucb$l_asn_rcv_accm, C                                      (char *) item->itm$l_retaddr, nG                                      item->itm$w_length, trusted_flag);;      }	      else       {         status = SS$_BADPARAM;      }         break;          /*S    **&    ** Transmit ACCMy    **T    */*    case ASN$_ACCM_XMIT :"      if (item->itm$w_length == 32)      {L         status = asn$move_sense_data((char *) &asnucb->ucb$l_asn_xmit_accm, C                                      (char *) item->itm$l_retaddr, _G                                      item->itm$w_length, trusted_flag);D      }	      elseb      {         status = SS$_BADPARAM;      }        break;           /*     **r    **  Connection type    **$    */p    case ASN$_CONNECT_TYPE :b!      if (item->itm$w_length == 4)t      {J         status = asn$move_sense_data((char*) &asnucb->ucb$l_asn_con_type, C                                      (char *) item->itm$l_retaddr, iG                                      item->itm$w_length, trusted_flag);t      }	      else       {         status = SS$_BADPARAM;      }        break;           /*t    **r    ** Receive FCS     **n    */b    case ASN$_FCS_RCV :!      if (item->itm$w_length == 4)u      {I         status = asn$move_sense_data((char*) &asnucb->ucb$l_asn_fcs_rcv,  C                                      (char *) item->itm$l_retaddr, SG                                      item->itm$w_length, trusted_flag);_      }	      elsen      {         status = SS$_BADPARAM;      }        break;K          /*     **     ** Transmit FCS    **u    */s    case ASN$_FCS_XMIT : !      if (item->itm$w_length == 4)u      {J         status = asn$move_sense_data((char*) &asnucb->ucb$l_asn_fcs_xmit, C                                      (char *) item->itm$l_retaddr,  G                                      item->itm$w_length, trusted_flag);       }	      else       {         status = SS$_BADPARAM;      }        break;           /*s    **e    ** Type of Flow control    **.    */)    case ASN$_FLOW :v!      if (item->itm$w_length == 4)e      {F         status = asn$move_sense_data((char*) &asnucb->ucb$l_asn_flow, C                                      (char *) item->itm$l_retaddr, OG                                      item->itm$w_length, trusted_flag);       }	      else*      {         status = SS$_BADPARAM;      }        break;           /*/    **a!    ** Maximum receive packet sizea    **	    */f    case ASN$_MRU :!      if (item->itm$w_length == 4)S      {E         status = asn$move_sense_data((char*) &asnucb->ucb$l_asn_mru, bC                                      (char *) item->itm$l_retaddr, (G                                      item->itm$w_length, trusted_flag);s      }	      else       {         status = SS$_BADPARAM;      }        break;           /*     ** !    ** Maximum tansmit packet size     **     */     case ASN$_MTU :!      if (item->itm$w_length == 4)       {E         status = asn$move_sense_data((char*) &asnucb->ucb$l_asn_mtu, mC                                      (char *) item->itm$l_retaddr,  G                                      item->itm$w_length, trusted_flag);       }	      elsei      {         status = SS$_BADPARAM;      }      break;*          /*e    **e    ** Read counterst    **o    */e    case ASN$_READ_COUNTERS :Q      if ((item->itm$w_length >= 8)  && ((int) item->itm$l_buffaddr <= ASN$M_ALL))       {         byte_count = 0;o         item_counter = 0;_I         mask = (int) item->itm$l_buffaddr & (ASN$M_ALL | (ASN$M_ALL -1));u0         out_addr = (char *) item->itm$l_retaddr;.         src_item = &asnucb->ucb$q_asn_bad_fcs;           if (mask & ASN$M_ALL)$	         {v             mask = ASN$M_ALL - 1;	         }n         /*  
         **;         ** Now loop through mask of items and pick them up r
         **
         */         while (mask)	         {s            if (mask & 1)            {               byte_count += 8;3               if (byte_count <= item->itm$w_length)                {cP                  status = asn$move_sense_data((char *) &src_item[item_counter], I                                               out_addr, 8, trusted_flag); ,                  if (!(status & SS$_NORMAL))                  {                     break;                  }                  out_addr += 8;                }                else               {o'                  status = SS$_BADPARAM;v                  break;4               }u            }            mask = mask >> 1;            item_counter += 1;r	         }_      }	      else       {         status = SS$_BADPARAM;      }      break;R          /*     **N"    ** Default case nothing matched    **t    */c    default :      status = SS$_BADPARAM;h      break;t }s   return status;   }      n /* **+++ **	asn$do_set_item	- Set specified paramter  ** ** Functional description: **J **	This routine handles the actual work of setting the specified item.  ItM ** takes a pointer to the itemlist item that is to be handled.  This routine  6 ** is common code for both the FDT and VCI set code.   ** ** Calling convention: **5 **	int	asn$do_set_item (ASNUCB *asnucb, LSTITM *item)  ** ** Input parameters: ** **	ASNUCB		Pointer to ASN UCB = **	itemlist_item	Pointer to the itemlist item to be processeda ** ** Output parameters:= **, **	Various fields in the UCB may be changed. ** ** Return value: **( **	SS$_NORMAL	Call completed successfuly) **	SS$_ACCVIO	Could not access the bufferA% **	SS$_BADPARAM	Parameter was invalid @ **	SS$_BADCONTEXT	Request was made and an IPL that was not validB **	SS$_DEVINACT	Device is not in a state where the request can be  **			honored	 **	Otherse ** ** Environment:  **I **	Kernel mode, user process context, IPL 2, or as an IPL 8 fork thread  _J ** 	During execution IPL may be as high as DEVICE IPL and both the device ! **	and the fork lock may be held.  ** **-- */1 int	asn$do_set_item(ASNUCB *asnucb, LSTITM *item)d {o   char		*devname_ptr;    int		item_counter;
 int		mask; int		saved_dipl; int		saved_fipl; int		status;   __int64		*src_item;e   struct	dsc$descriptor *devname;s   ASNRD		*asnrd; TTY_UCB		*phyucb;c     switch (item->itm$w_type)  {     /*i    **n    ** Receive ACCM    **     */     case ASN$_ACCM_RCV :_!      if (item->itm$w_length == 4)_      {I         asnucb->ucb$l_asn_rcv_accm = (unsigned int) item->itm$l_buffaddr;          status = SS$_NORMAL;      }	      else       {         status = SS$_BADPARAM;      }      break;           /*     **     ** Transmit ACCM*    **     */     case ASN$_ACCM_XMIT :"      if (item->itm$w_length == 32)      {6         memcpy((void *) &asnucb->ucb$l_asn_xmit_accm, B                (void *) item->itm$l_buffaddr, item->itm$w_length);         status = SS$_NORMAL;      }	      elsee      {         status = SS$_BADPARAM;      }      break;T          /*     **e    ** Bind to a physical device     **     */*    case ASN$_BIND : "      if (item->itm$w_length == 8)       {A         if ((void *)asnucb->ASNLOG.ucb$l_tl_phyucb == (void *) 0)a	         {t/            if (__PAL_MFPR_IPL() == IPL$_ASTDEL))            {H               status = exe_std$prober_dsc((void *)item->itm$l_buffaddr);&               if (status & SS$_NORMAL)               { 0                  devname = item->itm$l_buffaddr;6                  status = dyn$switch(asnucb, devname);               }u            }            elses            {&               status = SS$_BADCONTEXT;            }	         };         else	         {c
            /*(
            **;I            **	Terminal already bound so return an error saying we did not             ** bind it 
            **c
            */E"            status = SS$_OPINCOMPL;	         }l      }	      else)      {         status = SS$_BADPARAM;      }      break;             /*     **k    ** Set connection typei    **s    */F    case ASN$_CONNECT_TYPE :)&      if ((item->itm$w_length == 4) && D          (((unsigned int) item->itm$l_buffaddr & ASN$M_PERMANENT) ||C           ((unsigned int) item->itm$l_buffaddr & ASN$M_TRANSIENT)))S      {I         asnucb->ucb$l_asn_con_type = (unsigned int) item->itm$l_buffaddr;*         status = SS$_NORMAL;      }	      else       {         status = SS$_BADPARAM;      }      break;         /*d    **n)    ** Close down a line but keep it bounde    **e    */u    case ASN$_DEVICE_CLOSED :      status = SS$_BADPARAM;f      break;p          /*     **t%    ** Disable reception of characters     **     */e    case ASN$_DISABLE_RCV:t8      fork_lock(asnucb->ASNBASE.ucb$b_flck, &saved_fipl);<         phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;*         if ((void *) phyucb != (void *) 0)	         {uK            device_lock(asnucb->ASNBASE.ucb$l_dlck, RAISE_IPL, &saved_dipl);s"            asn$input_stop(asnucb);N            device_unlock(asnucb->ASNBASE.ucb$l_dlck, saved_dipl, SMP_RESTORE);            status = SS$_NORMAL;_	         }          else	         { !            status = SS$_DEVINACT;i	         }mF      fork_unlock(asnucb->ASNBASE.ucb$b_flck, saved_fipl, SMP_RESTORE);      break;t          /*u    ** I    ** Break the connection between the physical terminal and the logical h    **     */R    case ASN$_DISCONNECT :R8      fork_lock(asnucb->ASNBASE.ucb$b_flck, &saved_fipl);&         asnucb->ucb$v_asn_delpend = 1;"         asn$cancel_all_io(asnucb);  B         if ((void *) asnucb->ASNLOG.ucb$l_tl_phyucb != (void *) 0)	         {*            dyn$revert(asnucb);	         }oF      fork_unlock(asnucb->ASNBASE.ucb$b_flck, saved_fipl, SMP_RESTORE);      status = SS$_NORMAL;C      break;h          /*     **t    ** Enable receipt of data    **     */	    case ASN$_ENABLE_RCV :s9      phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;d'      if ((void *) phyucb != (void *) 0);      {4         status = asn$enable_receive(asnucb, phyucb);      }	      else*      {         status = SS$_DEVINACT;      }      break;           /*C    **r    ** Receive FCS size    **=    */     case ASN$_FCS_RCV :&      if ((item->itm$w_length == 4) && .          (((int) item->itm$l_buffaddr == 0) ||/           ((int) item->itm$l_buffaddr == 16) || .           ((int) item->itm$l_buffaddr == 32)))  t      {?         asnucb->ucb$l_asn_fcs_rcv = (int) item->itm$l_buffaddr;          status = SS$_NORMAL;      }	      else       {         status = SS$_BADPARAM;      }      break;           /*m    **t    ** Transmit FCS size     **=    */v    case ASN$_FCS_XMIT :n&      if ((item->itm$w_length == 4) && .          (((int) item->itm$l_buffaddr == 0) ||/           ((int) item->itm$l_buffaddr == 16) ||e.           ((int) item->itm$l_buffaddr == 32)))  b      {@         asnucb->ucb$l_asn_fcs_xmit = (int) item->itm$l_buffaddr;         status = SS$_NORMAL;      }	      else*      {         status = SS$_BADPARAM;      }      break;           /*{    **     ** Flow control type_    **h    */s    case ASN$_FLOW :y&      if ((item->itm$w_length == 4) && :          (((int) item->itm$l_buffaddr & ASN$M_XON_XOFF) ||3           ((int) item->itm$l_buffaddr & ASN$M_HW)))       {<         asnucb->ucb$l_asn_flow = (int) item->itm$l_buffaddr;         status = SS$_NORMAL;      }	      else       {         status = SS$_BADPARAM;      }      break;w          /*u    **{    ** Maximum recive size_    **a    */r    case ASN$_MRU :&      if ((item->itm$w_length == 4) && 8          (((int) item->itm$l_buffaddr <= MAXIMUM_MRU) &&7           ((int) item->itm$l_buffaddr >= MINIMUM_MRU)))_      {;         asnucb->ucb$l_asn_mru = (int) item->itm$l_buffaddr;          status = SS$_NORMAL;      }	      elsem      {         status = SS$_BADPARAM;      }      break;e          /*t    **u    ** Maximum transmit sizen    **e    */a    case ASN$_MTU :&      if ((item->itm$w_length == 4) && 8          (((int) item->itm$l_buffaddr <= MAXIMUM_MTU) &&7           ((int) item->itm$l_buffaddr >= MINIMUM_MTU)))f      {;         asnucb->ucb$l_asn_mtu = (int) item->itm$l_buffaddr;          status = SS$_NORMAL;      }	      else       {         status = SS$_BADPARAM;      }      break;           /*i    **n    ** Reset the line counter(s)s    **m    */s    case ASN$_RESET_COUNTERS:Q      if ((item->itm$w_length == 4)  && ((int) item->itm$l_buffaddr <= ASN$M_ALL))       {         status = SS$_NORMAL;         item_counter = 0;aI         mask = (int) item->itm$l_buffaddr & (ASN$M_ALL | (ASN$M_ALL -1)); .         src_item = &asnucb->ucb$q_asn_bad_fcs;           if (mask & ASN$M_ALL) 	         {s             mask = ASN$M_ALL - 1;	         }4         /*  
         **;         ** Now loop through mask of items and set them to 0 
         **
         */         while (mask)	         {a            if (mask & 1)            {)               src_item[item_counter] = 0;             }            mask = mask >> 1;            item_counter += 1;e	         }       }	      else*      {         status = SS$_BADPARAM;      }      break;M          /*     **i"    ** Default case nothing matched    **=    */v    default :      status = SS$_BADPARAM;,      break;  }    return status;   }(       /* **++, **	asn$enable_receive - Allow input to start ** ** Functional description: **C **	This routine will allows input to start.  If there is no current K ** read buffer it will attempt to get a read buffer and make it the current  ** read buffer._ ** ** Calling convention: **; **	int	asn$enable_receive (ASNUCB *asnucb, TTY_UCB *phyucb)  ** ** Input parameters: ** **	None  ** ** Output parameters:  ** **	Nonen ** ** Return value: **
 **	SS$_NORMALS ** ** Environment:  **I **	Kernel mode, system context, fork IPL with fork lock held.  The devices! ** lock is acquired and released.N ** **-- */7 int	asn$enable_receive(ASNUCB *asnucb, TTY_UCB *phyucb)  {    int	saved_dipl;  int	status;l  
 ASNRD	*asnrd;o    @ device_lock(asnucb->ASNBASE.ucb$l_dlck, RAISE_IPL, &saved_dipl);    if (!phyucb->tty$v_st_read)    {        phyucb->tty$v_st_read = 1;C       status = __PAL_REMQUEL((void *) asnucb->ucb$l_asn_readq_fl,   .                              (void *) &asnrd);       if (status >= 0)       {m          /*]          ** )          **	Should never not get a packetr          **f          */ @          asnrd->asnrd$l_putptr = (void *) &asnrd->asnrd$t_frame;,          asnrd->asnrd$l_status = SS$_NORMAL;2          phyucb->ucb$l_tt_typahd = (void *) asnrd;"          asn$input_resume(asnucb);       }     }    elseS    {9       if ((void *) phyucb->ucb$l_tt_typahd == (void *) 0)        { E          status = __PAL_REMQUEL((void *) asnucb->ucb$l_asn_readq_fl,  1                                 (void *) &asnrd);A          if (status >= 0) 
          {C             asnrd->asnrd$l_putptr = (void *) &asnrd->asnrd$t_frame;u/             asnrd->asnrd$l_status = SS$_NORMAL; 5             phyucb->ucb$l_tt_typahd = (void *) asnrd;_%             asn$input_resume(asnucb); 
          }       }t    }(    asnucb->ucb$v_asn_input_disabled = 0;$    asnucb->ucb$v_asn_drop_chars = 0;C device_unlock(asnucb->ASNBASE.ucb$l_dlck, saved_dipl, SMP_RESTORE);r   return SS$_NORMAL;   }      h /* **++7 **	asn$fcs_check - See if recieved packet has valid FCSt ** ** Functional description: **H **	Check that the packet we received is valid.  The way this is done is L ** to compute an FCS for the whole packet including the FCS.  The resulting % ** FCS is checked against a constant.n ** ** Calling convention: **? **	int asn$fcs_check (ASNUCB *asnucb, char *buffer, int length)S ** ** Input parameters: **# **	ucb		pointer to the physical UCBa% **	buffer		pointer to start of packeta: **	length		length of packet in bytes includes received FCS ** ** Output parameters:e ** **	Noneb ** ** Return value: **
 **	SS$_NORMALr **	SS$_BADCHKSUM ** ** Environment:e **8 **	Kernel mode IPL 8 fork thread with the fork lock held ** **-- */D int	asn$fcs_check(ASNUCB *asnucb, unsigned char *buffer, int length) {y   unsigned short int	fcs16;	 unsigned int		fcs32;    $ if (asnucb->ucb$l_asn_fcs_rcv == 16) {e-    fcs16 = asn$fcs16_compute(buffer, length);s    if (fcs16 == 0xf0b8)p    {       return SS$_NORMAL;    }    elseu    {       return SS$_BADCHKSUM;R    } }; else {	-    fcs32 = asn$fcs32_compute(buffer, length);     if (fcs32 == 0xdebb20e3)     {       return SS$_NORMAL;    }    else     {       return SS$_BADCHKSUM;     } }    }      > /* **++: **	asn$fcs_compute - Compute the FCS and save it in buffer ** ** Functional description: **H **	The supplied buffer has the FCS computed and added to it.  The buffer8 ** is assumed to have sufficeint space to store the FCS. ** ** Calling convention: **@ **	int	asn$fcs_compute (ASNUCB *asnucb, unsigned char *in_buff, , **                               int length) ** ** ** Input parameters: **% **	asnucb		Pointer to ASN devices UCB  **	in_buff		Pointer to buffer * **	length		Length of input buffer in bytes ** ** Output parameters:  **- **	buffer		FCS added to the end of the buffer  ** ** Return value: **& **	length of string with FCS added in  ** ** Environment:u **5 **	Kernel mode, IPL 2 or IPL 8 depending upon caller.  ** **-- */G int	asn$fcs_compute(ASNUCB *asnucb, unsigned char *in_buff, int length)s {p unsigned int	fcs;t    % if (asnucb->ucb$l_asn_fcs_xmit == 16)t {&,    fcs = asn$fcs16_compute(in_buff, length);    fcs = fcs ^ 0xffff;&    *(in_buff + length++) = fcs & 0xff;-    *(in_buff + length++) = (fcs >> 8) & 0xff;  } * else if (asnucb->ucb$l_asn_fcs_xmit == 32) { ,    fcs = asn$fcs32_compute(in_buff, length);    fcs = fcs ^ 0xffffffff;&    *(in_buff + length++) = fcs & 0xff;-    *(in_buff + length++) = (fcs >> 8) & 0xff;n.    *(in_buff + length++) = (fcs >> 16) & 0xff;.    *(in_buff + length++) = (fcs >> 24) & 0xff; }a   return length;   }      l /* **++) **	asn$fcs16_compute - Compute 16 bit FCSD ** ** Functional description: **J **	Compute a 16 bit FCS for the string.  The FCS is computed by looking upO ** the FCS value in a table and and the result with 0xff and XORing it with the  ** low 8 bits of the old FCS.R ** ** Calling convention: **B **	unsigned short int asn$fcs16_compute (char *buffer, int length) ** ** Input parameters: **/ **	buffer		Pointer to packet to compute FCS fors# **	length		Length in byte of buffer  ** ** Output parameters:B ** **	None  ** ** Return value: **
 **	16 bit FCS* ** ** Environment:u **? **	Kernel mode either IPL 2 or IPL 8 depending upon the caller.s ** **-- */G unsigned short int asn$fcs16_compute(unsigned char *buffer, int length)c {a   unsigned short int fcs;c    
 fcs = 0xffff;V   while (length--) {c:    fcs = (fcs >> 8) ^ fcstab_16[(fcs ^ *buffer++) & 0xff]; }    return fcs;O   }$     y /* **++) **	asn$fcs32_compute - Compute 32 bit FCS  ** ** Functional description: **J **	Compute a 32 bit FCS for the string.  The FCS is computed by looking upN ** the FCS value in a table and and the result with 0xffff and XORing it with ! ** the low 8 bits of the old FCS.O ** ** Calling convention: **; **	unsigned int asn$fcs32_comput (char *buffer, int length)  ** ** Input parameters: **/ **	buffer		Pointer to packet to compute FCS fore# **	length		Length in byte of buffera ** ** Output parameters:e ** **	Nonem ** ** Return value: **
 **	32 bit FCS  ** ** Environment:  **? **	Kernel mode either IPL 2 or IPL 8 depending upon the caller.  ** **-- */A unsigned int	asn$fcs32_compute(unsigned char *buffer, int length)( {i   unsigned int	fcs;c     fcs = 0xffffffff;*   while (length--) { B    fcs = (((fcs) >> 8) ^ fcstab_32[((fcs) ^ (*buffer++)) & 0xff]); }u   return fcs;d   },     S /* **++- **	asn$fork_dispatch - Handle fork on ASN UCB  ** ** Functional description: **J **	This routine take care of performing all the forking for the ASN driverL ** and for the terminal port driver.  It roughly emulates what the TTDRIVER M ** does for forking.  The code will use the same fork flags as ttdriver does *O ** but only has code for a small subset of the possible forks used by TTDRIVER.* ** ** Calling convention: **? **	void	asn$fork_dispatch (uint64 fr3, uint64 fr4, ASNUCB *ucb)= ** ** Input parameters: ** **	FR3		saved R3 (unused) ) **	FR4		saved R4 (flag bits for the fork)) **	UCB		pointer to the ASN UCB ** ** Output parameters:  ** **	None  ** ** Return value: ** **	Nonet ** ** Environment:  **E **	Kernel mode IPL8 with the fork lock held.  The device lock will beS **	acquired and released.b ** **-- */> void	asn$fork_dispatch(uint64 fr3, uint64 fr4, ASNUCB *asnucb) {S   int		bit_count; 
 uint64		flag;$ int		original_ipl;   ASNVCIB		*asnvcib; TTY_UCB		*phyucb;0      1 while (asnucb->ASNBASE.ucb$q_fr4 & TTY$M_FD_BUSY)  { E    device_lock(asnucb->ASNBASE.ucb$l_dlck, RAISE_IPL, &original_ipl);c       bit_count = 0;4       flag = asnucb->ASNBASE.ucb$q_fr4 & 0xffffffff;:       while (!(flag & 1))		/* Find Next task to perform */       {            bit_count += 1;            flag = flag >> 1;p       }h       flag = 1 << bit_count;G       asnucb->ASNBASE.ucb$q_fr4 =  asnucb->ASNBASE.ucb$q_fr4 & (~flag);fH    device_unlock(asnucb->ASNBASE.ucb$l_dlck, original_ipl, SMP_RESTORE);  B    if (flag  == TTY$M_FD_DISCONNECT)	/* This is really a hangup */    {        asn$cancel_all_io(asnucb);3       asnvcib = (ASNVCIB *) asnucb->ucb$l_asn_vcib;A  )       if ((void *) asnvcib != (void *) 0){       {a'          VCI$XXX_Report_Event(asnvcib);s       }U   ?       if ((void *) asnucb->ASNLOG.ucb$l_tl_ctrly != (void *) 0)m       {dE          com_std$delattnast((ACB **) &asnucb->ASNLOG.ucb$l_tl_ctrly, M,                             (UCB *) asnucb);       }t    }(    else if (flag ==   TTY$M_FD_PORTFORK)    {:       phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;(       if ((void *) phyucb != (void *) 0)       {i          port$forkret(phyucb);       }s    } }U   }      ( /* **++2 **	asn$input_resume - Start reception of chracters ** ** Functional description: **J **	This routine is used to resume input from the remote node..  It has twoM ** paths of execution for hardware flow control it will raise the RTS signal. L ** For XON/XOFF flow control it will send an XON character.  Note that if a K ** users has changed flow control methods while input is stopped they will S ** remain stopped. ** ** Calling convention: **) **	void asn$input_resume (ASNUCB *asnucb)_ ** ** Input parameters: ** **	ucb	pointer the the ASN UCB ** ** Output parameters:( ** **	Nonem ** ** Return value: ** **	NoneL ** ** Environment:_ **A **	Kernel mode with the device lock for the physical device held.  ** **-- */% void	asn$input_resume(ASNUCB *asnucb)4 {    unsigned int	bits;   TTY_UCB		*phyucb;     % asnucb->ucb$l_asn_rcv_state = RCV_ON; 4 phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;  # if ((void *) phyucb != (void *) 0)	{ { *    if (asnucb->ucb$l_asn_flow == ASN$M_HW)    {G       bits = TT$M_DS_RTS | TT$M_DS_DTR;		/* leAve DTR on and set RTS */         port$ds_set(bits, phyucb);    }    else=    {       port$xon(0x11, phyucb);     } }/   }        /* **++, **	asn$input_stop - Stop the receipt of data ** ** Functional description: **I **	This routine is used to disable input from the remote node.  It cannot_M ** insure that input is stopped only that an attempt is made to stop input.  tM ** It has two paths of execution for hardware flow control it will lower the lK ** RTS signal.  For XON/XOFF flow control it will send an XOFF character.   N ** Note that if a users chooses to switch methods while input is stopped they  ** will remain stopped.r ** ** Calling convention: **( **	void	asn$input_stop (TTY_UCB *asnucb) ** ** Input parameters: ** **	ucb		pointer to the ASN UCB ** ** Output parameters:t ** **	Nonet ** ** Return value: ** **	Nonel ** ** Environment:e **A **	Kernel mode with the device lock for the physical device held.* ** **-- */# void	asn$input_stop(ASNUCB *asnucb)S {	   unsigned int	bits;   TTY_UCB		*phyucb;c    & asnucb->ucb$l_asn_rcv_state = RCV_OFF;4 phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;  # if ((void *) phyucb != (void *) 0)	( {d*    if (asnucb->ucb$l_asn_flow == ASN$M_HW)    {?       bits = TT$M_DS_RTS << 8 | TT$M_DS_DTR;	/* Leave DTR on */m        port$ds_set(bits, phyucb);    }    elsen    {       port$xoff(0x13, phyucb);    } }*   }      a /* **++F **	asn$move_sense_data - Copy data from system data area to user bufer ** ** Functional description: **G **	This routine is used to move data from the sysem bufer to the users  L ** buffer.  It can be called at IPL 2 for the sense mode QIO case, and from L ** IPL 8 when doing a VCI port management request.  In the VCI case it does I ** not bother to probe the users buffer it trusts that the buffer can be   ** written to. ** ** Calling convention:I **	int asn$move_sense_data (char *src_buf, char *target_buf, int buf_len,-0 **                               int probe_flag) ** Input parameters: **/ **	src_buf		pointer to buffer to copy data from 7 **	target_buf	pointer to the buffer to receive the datad) **	buf_len		length in bytes of the bufferrC **	probe_flag	flag to indicate if targer buffer should be probed.  T ** ** Output parameters:; **  **	target_buf	will have the data ** ** Return value: ** **	SS$_NORMAL	data copied fine( **	SS$_ACCVIO	target buffer no writeable ** ** Environment:  **A **	Kernel mode IPL 2.users process context, or kernel mode IPL 8.c ** **-- */F int	asn$move_sense_data(char *src_buf, char *target_buf, int buf_len, +                             int probe_flag)k {S   int		acmode = 0; int		status;     status = SS$_NORMAL;   if (probe_flag == PROBE) {tA    status = exe_std$probew((void *) target_buf, buf_len, acmode);	 }n   if (status & SS$_NORMAL) { :    memcpy((void *) target_buf, (void *) src_buf, buf_len); }R   return status;   }$     r /* **++: **	asn$prepare_for_delete - Get device ready to be deleted ** ** Functional description: **H **	Prepare the device for later deletion.  This routine will cancel all O ** outstanding I/O on the device, try to block any new input, and indicate thatcO ** we want to drop any characters that arrive from this point forward.  It will O ** break the connection between the physical terminal and the ASN device.  ThiseP ** will insure that the device can no longer be used.  This code will start the L ** once a second deletion fork running.  The actual deletion will take place" ** later when it is safe to do so. ** ** Calling convention: **/ **	void	asn$prepare_for_delete (ASNUCB *asnucb)d ** ** Input parameters: ** ** ** ** Output parameters:e ** **	Nonef ** ** Return value: ** **	Noneo ** ** Environment:i **H **	Kernel mode, user process context, IPL 2, or as an IPL 8 fork thread. ** **-- */+ void	asn$prepare_for_delete(ASNUCB *asnucb)a {i   int		saved_fipl; int		status;    3 fork_lock(asnucb->ASNBASE.ucb$b_flck, &saved_fipl);*  "    if (!asnucb->ucb$v_asn_delpend)    { u%        asnucb->ucb$v_asn_delpend = 1;t    }      asn$cancel_all_io(asnucb);u  =    if ((void *) asnucb->ASNLOG.ucb$l_tl_phyucb != (void *) 0)     {       dyn$revert(asnucb);n    }  $    if (!asnucb->ucb$v_asn_delactive)    {&       asnucb->ucb$v_asn_delactive = 1;)       asnucb->ucb$b_asn_type = DYN$C_FRK;s-       asnucb->ucb$b_asn_flck = SPL$C_IOLOCK8;_U       fork_wait(asn$delete_ucb, 0, (uint64) asnucb, (FKB *) &asnucb->ucb$l_asn_fqfl);     }  A fork_unlock(asnucb->ASNBASE.ucb$b_flck, saved_fipl, SMP_RESTORE);    }_     l /* **++C **	asn$quote - Take users output buffer and quote control charcterse ** ** Functional description: **I **	This routine will take the supplied buffer and examine each character fN ** one at a time and decide if it needs to be quoted.  If the character needs N ** to be quoted it will add the quote character to the output buffer and then N ** xor the character with 0x20 and add it to the output buffer.  It is assumedM ** that the FCS has already been computed and added to the end of the packet.C ** ** Calling convention: **= **	int asn$quote (ASNUCB *ucb, char *in_char, int in_length, aE **                     char *out_char, int out_length, int *ret_len);  ** ** Input parameters: ** **	ucb		pointer the ASN UCBe( **	in_char		pointer to start input bufer# **	in_length	length of input bufferr- **	out_char	pointer to start of output buffer % **	out_length	length of output bufferbD **	ret_length	pointer to variable to receive actual length of buffer ** ** Output parameters:* **% **	out_char	quoted packet to transmitP> **	ret_length	will contain actual number of characters to send ** ** Return value: ** **	SS$_NORMAL	quote completed / **	SS$_BUFFEROVF	to much data for output buffer  ** ** Environment:n **9 **	Kernel mode IPL 8 fork thread with the fork lock held.  ** **-- */  F int 	asn$quote(ASNUCB *asnucb, unsigned char *in_char, int in_length, H                   unsigned char *out_char, int out_length, int *ret_len) {t  
 int		bit_pos; 
 int		slot; int		status;     status = SS$_NORMAL;
 *ret_len = 0;u   if (out_length >= in_length) {     dol    {       slot = (int)*in_char/32;#       bit_pos = (int)*in_char % 32;         if ((*in_char == 0x5e) || D           (!(asnucb->ucb$l_asn_xmit_accm[slot] & (1 << bit_pos))) ||5           ((*in_char >= 0x20) && (*in_char <= 0x3f)))e       {*"          *out_char++ = *in_char++;          *ret_len += 1;          }C-       else	/* If here must quote character */t       {           *out_char++ = 0x7d;          out_length -= 1;n          *ret_len += 1;u          if (out_length)
          {,             *out_char++ = *in_char++ ^ 0x20;             *ret_len += 1;
          }
          elsea
          {$              status = SS$_BUFFEROVF;              break; 
          }       }_-    } while ((--in_length) && (--out_length));t }a else {t    status = SS$_BUFFEROVF; }c   return status;   }h     n /* **++4 **	ans$unquote - Remove quoting from received packet ** ** Functional description: **I **	This routine will remove the quoting from the buffer.  This is done bysN ** examining each character if it is 0x7d it is removed and the next characterO ** is XORed with 0x20.  This resulting character is saved in the output buffer.6 ** ** Calling convention: **A **	int asn$unquote (char *in_char, int in_length, char *out_char)l ** ** Input parameters: **& **	in_char		pointer to packet received **	in_length	length of packet / **	out_char	pointer of buffer to receive packett ** ** Output parameters:  **' **	out_buf		packet with quoting removedl ** ** Return value: **' **	Number of chracters in output buffert ** ** Environment:  **9 **	Kernel mode IPL 8 fork thread with the fork lock held.n ** **-- */O int	asn$unquote(unsigned char *in_char, int in_length, unsigned char *out_char)f {&   int		i = 0; 
 int		out_len;_     out_len = 0;     do d {,
    i += 1;    if (*in_char != 0x7d)    {       *out_char++ = *in_char++;A       out_len += 1;f    }    elsel    {       in_char++;&       *out_char++ = *in_char++ ^ 0x20;       out_len += 1; 
       i += 1;g    } } while (i < in_length); return out_len;o   }      s /* **++* **	asn$write_start - Start a write request ** ** Functional description: **F **	This routine will take a transmit IRP or VCRP and do the necessary H ** steps to get it set to the physical device.  It will add the framing N ** characters and quote the data, and finally call the port driver to send the ** packet out over the wire. ** ** Calling convention: **B **	int	asn$write_start (ASNUCB *asnucb, TTY_UCB *phyucb, IRP *irp) ** ** Input parameters: ** **	asnucb			pointer to ASN UCB# **	phyucb			pointer to physical UCBu+ **	vcrp/irp		pointer to current VCRP or IRP  ** ** Output parameters:  **1 **	packet if aborted or writen to physical device  ** ** Return value: ** **	SS$_NORMAL		worked : **	SS$_BUFFEROVF		Insufficient space to hold output packet+ **	SS$_xxxx		Failed to allocate pool errors} ** ** Environment:* **( **	Kernel mode IPL 8 with fork lock held ** **-- */> int	asn$write_start(ASNUCB *asnucb, TTY_UCB *phyucb, IRP *irp) {m   unsigned char	*in_buffer;. unsigned char	*out_buffer; unsigned char	out_char;    int		buffer_len; int		frame_len;  int		frame_size; int		request_size; int32		return_size;r int		saved_dipl; int		status;   ASNWRT		*asnwrt; VCRP		*vcrp;     /* **/ ** Allocate a write packet and save its addressl **J **  Request size = 2 * mtu + (16 bytes for address, control, and protocol D **                             fields) + SIZE of write buffer header ** */L request_size = 2 * asnucb->ucb$l_asn_mtu + PACKET_OVERHEAD + sizeof(ASNWRT);K status = exe_std$alononpaged(request_size, &return_size, (void *) &asnwrt);    if (status & SS$_NORMAL) {s'    asnwrt->asnwrt$w_size = return_size;C%    asnwrt->asnwrt$b_type = DYN$C_FRK;_)    asnwrt->asnwrt$b_flck = SPL$C_IOLOCK8;c)    asnwrt->asnwrt$l_fpc = asn$write_done;p    asnwrt->asnwrt$q_fr3 = 0;    asnwrt->asnwrt$q_fr4 = 0;*    asnwrt->asnwrt$a_ucb = (void *) asnucb;<    asnwrt->asnwrt$ps_data = (void *) &asnwrt->asnwrt$t_data;:    asnucb->ucb$l_asn_write_buffer = (void *) asnwrt;        %    if (irp->irp$b_type == DYN$C_VCRP)     {       vcrp = (VCRP *) irp;@       in_buffer = (unsigned char *) vcrp->vcrp$l_buffer_address;%       buffer_len = vcrp->vcrp$l_bcnt;e,       asnwrt->asnwrt$a_vcrp = (void *) vcrp;    }    elset    {6       in_buffer = (unsigned char *) irp->irp$l_svapte;#       buffer_len = irp->irp$l_bcnt;l+       asnwrt->asnwrt$a_vcrp = (void *) irp;/    }  ;    frame_size = asnwrt->asnwrt$w_size - sizeof(ASNWRT) - 1; 9    out_buffer = (unsigned char *) &asnwrt->asnwrt$t_data;e(    *out_buffer++ = (unsigned char) 0x7e;  N    status = asn$quote(asnucb, in_buffer, buffer_len, out_buffer,  frame_size, #                       &buffer_len);U    if (status & SS$_NORMAL)t    {F       device_lock(asnucb->ASNBASE.ucb$l_dlck, RAISE_IPL, &saved_dipl);            /*           **eM          ** Account for start & stop of frame characters finish write buffer *          ** and send it           **T          */b0          asnwrt->asnwrt$l_bcnt = buffer_len + 2;9          asnwrt->asnwrt$ps_data = &asnwrt->asnwrt$t_data;v.          asnwrt->asnwrt$l_status = SS$_NORMAL;9          *(out_buffer+buffer_len) = (unsigned char) 0x7e;R$          phyucb->tty$v_st_write = 1;*          out_char = class$getnext(phyucb);*          if (phyucb->ucb$b_tt_outype != 0)
          {+             port$startio(out_char, phyucb);_
          }I       device_unlock(asnucb->ASNBASE.ucb$l_dlck, saved_dipl, SMP_RESTORE);*    }    elsen    {       /*       **L       ** The quote operation failed, free up the write buffer and return the       ** error.c       **       */"       exe_std$deanonpaged(asnwrt);    } }.   return status;   }e