# #pragma module pppd$dynswitch "X-7"  /*N  *****************************************************************************  *  2  * Copyright  1996 Digital Equipment Corporation.  * All rights reserved.   *B  * Redistribution and use in source and binary forms are permittedB  * provided that the above copyright notice and this paragraph are;  * duplicated in all such forms and that any documentation, =  * advertising materials, and other materials related to such C  * distribution and use acknowledge that the software was developed 5  * by Digital Equipment Corporation.  The name of the E  * Corporation may not be used to endorse or promote products derived @  * from this software without specific prior written permission.A  * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR A  * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED F  * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  *  N  *****************************************************************************      
 	FACILITY:    		ASNDRIVER    
 	ABSTRACT:     B   		This module contains a the terminal driver switching rotuines.
 	They are:  3 		dyn$revert - switch physical UCB back to TTDRIVER : 		dyn$switch - switch physical terminal to ASNDRIVER from  			     TTDRIVER     	AUTHOR:   $ 		Forrest A. Kenney	29-February-1996    	REVISION HISTORY:   , 	X-7	FAK005		Forrest A. Kenney	23-March-1997A 		If the type-ahead buffer still exists when we go to switch the  = 		line delete it.  If not this hunk of pool is lost forever.  ? 		This is only the case when we dial out.  When we dial in the  , 		buffer gets cleaned up for us by TTDRIVER.  , 	X-6	FAK004		Forrest A. Kenney	03-March-1997< 		If the line being switched is modem don't switch it if the: 		remote attribute is not set.  Also for modem lines being; 		switched clear the timer and remove it from the count of  @ 		devices on the controller that the modem timer is ticking for.  0 	X-5	FAK003		Forrest A. Kenney	05-September-1996A 		Copy DIPL from physical UCB to ASN UCB.  Unless the line is set B 		permanently to no hangup hang the modem up and flip the current  		attribute back to hangup.   + 	X-4	FAK002		Forrest A. Kenney	25-July-1996 > 		It is now time remove the development quality line switchingA 		logic and do the real thing.  The real code needs to make sure  % 		that the following things are true:   " 			a) The class driver is TTDRIVER% 			b) That we are not using OPAx port ) 			c) That we own the line to be switched  			d) That the line is idle   ? 		If any of these are not true then the request will be aborted  		with an error.  * 	X-3	FAK001		Forrest A. Kenney	30-May-1996@ 		Make sure that we clear out the PID field when we give up the 3 		device.  If not it has a dangling owner of sorts.    */      6 /* Define system data structure types and constants */  7 #include	<acbdef.h>	/* AST control block definitions	*/ : #include	<ccbdef.h>	/* Channel Control Block definitons	*/= #include	<crbdef.h>	/* Controller Request Block definitons	*/ 6 #include	<descrip.h>	/* VMS descriptor definitions		*/6 #include	<devdef.h>	/* Device characteristics bits		*/7 #include	<ddbdef.h>	/* Device data block definitions	*/ ; #include	<ddtdef.h>	/* Driver Dispatch table definitions	*/ 9 #include	<dyndef.h>	/* Data structure type definitions	*/ 1 #include	<fkbdef.h>	/* Fork block definitions		*/ 1 #include	<iocdef.h>	/* I/O routines constants		*/ > #include	<idbdef.h>	/* Interrupt Dispatch Block Definitions	*/. #include	<ints.h>	/* interger definitions			*/8 #include	<irpdef.h>	/* I/O Request Packet definitions	*/9 #include	<orbdef.h>	/* Object rights Block definitions	*/ ; #include	<pcbdef.h>	/* Process Control Block definitions	*/ 6 #include	<sbdef.h>	/* System data block definitions	*/3 #include	<splcoddef.h>	/* Spinlock definitions			*/ / #include	<ssdef.h>	/* Status return valuse			*/ 4 #include	<ttdef.h>	/* Terminal attrubutes TT$xxx		*/5 #include	<tt2def.h>	/* Terminal attributes TT2$xx		*/ @ #include	<ttysymdef.h>	/* TTY symbols private to class driver	*/. #include	<ttyucbdef.h>	/* TTY UCB offsets			*/9 #include	<ttyvecdef.h>	/* Terminal vector definitions		*/ ( #include	<ucbdef.h>	/* UCB offsets				*/, #include	<vcrpdef.h>	/* VCRP defnitions			*/  G #define		VCIBDEF	vcibdef	/* This is needed to work around an incorrect  $ 				   definition for VCIB in LIB *.    = /* Define ASN specific data structures types and constants */   1 #include	"asndef.h"		/* ASN public definitions	*/ 5 #include	"asnmiscdef.h"		/* ASN miscellanous items	*/ * #include	"asnvcibdef.h"		/* ASN VCIB 			*/> #include	"pppd$asn_hide_ptrs.h"	/* Hide long paths to items	*/: #include	"pppd$asn_linkages.h"	/* JSR register linkages	*/B #include	"pppd$asn_prototypes.h"	/* Prototypes for ASN routines	*/    4 /* Define function prototypes for system routines */  I #include	<com_routines.h> /* Prototypes for com$ and com_sdt$ routines */ I #include	<exe_routines.h> /* Prototypes for exe$ and exe_std$ routines */ I #include	<ioc_routines.h> /* Prototypes for ioc$ and ioc_std$ routines */ I #include	<sch_routines.h> /* Prototypes for sch$ and sch_std$ routines */     ) /* Define various device driver macros */   F #include	<vms_drivers.h>	/* Device driver support macros, including */3 				/* table initialization macros and prototypes*/     4 /* Define the DEC C functions used by this driver */  D #include	<builtins.h>	/* OpenVMS AXP specific C builtin functions */C #include	<string.h>	/* String routines provided by "kernel CRTL" */        /* **++4 **	dyn$revert - switch physical UCB back to TTDRIVER ** ** Functional description: **I **	The dyn$revert routine is used to restore the terminal class driver as M ** the class driver for the specified terminal port.  The routine will place  N ** the class driver vector address in the class field of the UCB.  Fill in theN ** get and put pointers with the addresses of the get and put routines in the M ** class driver.  Finally it will drive the unit to a idle state.  This will  L ** cause the class driver to reset the unit to the state it had when it was K ** switched from the default terminal class driver.  This routine makes no  H ** sanity checks it trusts that is it safe to do what it is about to do. ** ** Calling convention: **" **	int	dyn$revert (ASNUCB *asnucb) ** ** Input parameters: **) **	ASNUCB		Pointer to the ASN devices UCB  ** ** Output parameters:  ** **	None  ** ** Return value: **$ **	SS$_NORMAL	Terminal switched back> **	SS$_DEVINACT	Could not swith terminal back already switched ** ** Environment:  **I **	Called at IPL 8 with the fork lock held. Upon exit the IPL will be at  , ** 	callers IPL this is assumed to be IPL 8. ** **-- */ int	dyn$revert(ASNUCB *asnucb) {    int		saved_ipl;  int		status;   extern DPT	*TTY$GL_DPT;    TT_CLASS	*CLASS_VECTOR;  TTY_UCB		*phyucb;     4 phyucb = (TTY_UCB *) asnucb->ASNLOG.ucb$l_tl_phyucb;  " if ((void *) phyucb != (void *) 0) { B    device_lock(asnucb->ASNBASE.ucb$l_dlck, RAISE_IPL, &saved_ipl);M       phyucb->PHYBASE.ucb$l_ddt = (DDT *) asnucb->ASNLOG.ucb$l_tl_posix_data; /       CLASS_VECTOR = TTY$GL_DPT->dpt$ps_vector; /       phyucb->ucb$l_tt_logucb = (UCB *) phyucb; 2       phyucb->ucb$l_tt_class = (int) CLASS_VECTOR;;       phyucb->ucb$l_tt_getnxt = CLASS_VECTOR->class_getnxt; ;       phyucb->ucb$l_tt_putnxt = CLASS_VECTOR->class_putnxt; "       phyucb->ucb$l_tt_state1 = 0;"       phyucb->ucb$l_tt_state2 = 0;       /*       **3       **	Retore devices original PORT CONTROL flags        **       */@       phyucb->ucb$w_tt_prtctl = asnucb->ASNLOG.ucb$l_tl_outband;     ;       if ((phyucb->PHYBASE.ucb$l_devdepend & TT$M_MODEM) && 3           (phyucb->ucb$l_tt_decha1 & TT2$M_HANGUP))        {           /*           **           **	Drop DTR & RTS            **           */ B          port$ds_set(((TT$M_DS_DTR | TT$M_DS_RTS) << 8) , phyucb);8          phyucb->PHYBASE.ucb$l_devdepnd2 | TT2$M_HANGUP;       }        port$abort(phyucb);        port$resume(phyucb);       /*       **C       **	Use real class driver code instead of ASN code to force a         ** hangup and UCB reset        **       */#       tty$class_disconnect(phyucb); !       tty$class_setupucb(phyucb);        port$set_line(phyucb);&       phyucb->PHYBASE.ucb$l_refc -= 1;*       if ( phyucb->PHYBASE.ucb$l_refc < 0)       { )           phyucb->PHYBASE.ucb$l_refc = 0;        } $       phyucb->PHYBASE.ucb$l_pid = 0;'       phyucb->PHYBASE.ucb$v_online = 1; P       phyucb->PHYBASE.ucb$l_devchar = phyucb->PHYBASE.ucb$l_devchar | DEV$M_AVL;S       phyucb->PHYBASE.ucb$l_devchar2 = phyucb->PHYBASE.ucb$l_devchar2 & ~DEV$M_RED;   )       asnucb->ASNLOG.ucb$l_tl_phyucb = 0;        status = SS$_NORMAL;E    device_unlock(asnucb->ASNBASE.ucb$l_dlck, saved_ipl, SMP_RESTORE);  }  else {     status = SS$_DEVINACT;  }      return status;   }        /* **++C **	dyn$switch - switch physical terminal to ASNDRIVER from TTDRIVER  ** ** Functional description: ** **	Describe routine  ** ** Calling convention: **3 **	int	dyn$switch (ASNUCB *asnucb, TTY_UCB *phyucb)  ** ** Input parameters: ** **	asnucb	Pointer to ASN UCB> **	devname	String descriptor with name of device to connect to ** ** Output parameters:  ** **	None  ** ** Return value: **$ **	SS$_NORMAL	Terminal switched backC **	SS$_DEVALLOC	Device to be bound to is beind used by another user ( **	SS$_IVDEVNAM	Illegal device specified* **	SS$_BADPARAM	Device name length to long ** ** Environment:  **I **	Called at IPL 2, IPL is raised to IPL 8. Upon exit the IPL will be at   ** 	callers IPL. ** **-- */> int	dyn$switch(ASNUCB *asnucb, struct dsc$descriptor *devname) {    extern DDT	asndummy_ddt; extern TT_CLASS	CLASS_VECTOR;  extern PCB	*CTL$GL_PCB;  extern DPT	*TTY$GL_DPT;    char		*devname_ptr;  char		devname_str[64];  & int		flags_in = IOC$M_ANY | IOC$M_PHY; int32		flags_out;  int32		name_length;  int		saved_dipl; int		saved_fipl; int32		scs_length; int		status; int32		unit;   void		*dummy_lock;  
 DDB		*ddb; MUTEX		*mutex; SB		*sb; TTY_UCB		*phyucb;  TTY_UCB		*tmpucb;     0 if (devname->dsc$w_length > sizeof(devname_str)) {m    return SS$_BADPARAM;X }      /* **H **	We have a valid starting point for looking at the physical device to K ** see if it can be switched.  From here on out we need to insure that the vN ** I/O database will not change underneath us.  So we will grab the MUTEX for 4 ** read access.  It will be released on the way out. ** h */D memcpy(devname_str, devname->dsc$a_pointer,  devname->dsc$w_length);$ mutex = sch_std$iolockr(CTL$GL_PCB);? status = ioc_std$parsdevnam(devname->dsc$w_length,devname_str, sH                             flags_in, &unit, &scs_length, &name_length, 6                             &devname_ptr, &flags_out); if (status & SS$_NORMAL) {   J    status = ioc_std$searchint(unit, scs_length, name_length, devname_ptr, E                               flags_in, (UCB **) &tmpucb, &ddb, &sb, I+                               &dummy_lock);*    if (status & SS$_NORMAL)Y    {=       if (tmpucb->PHYBASE.ucb$l_pid == CTL$GL_PCB->pcb$l_pid)*       {*;          if ((tmpucb->PHYBASE.ucb$l_devchar & DEV$M_TRM) &&T?              (tmpucb->PHYBASE.ucb$w_size >= UCB$K_TL_LENGTH) &&iE              ((void *) tmpucb->PHYLOG.ucb$l_tl_phyucb != (void *) 0))t
          {             /*             **L             **	We have a UCB that claim to be a terminal UCB and it is largeO             ** enough.  Now lets make sure we have the physical UCB, and it is  M             ** not OPAX, and that the driver being used is the terminal classe             ** driver.             **             */?             fork_lock(asnucb->ASNBASE.ucb$b_flck, &saved_fipl); O                if ((void *) tmpucb  != (void *) tmpucb->PHYLOG.ucb$l_tl_phyucb)I                {E                   phyucb= (TTY_UCB *) tmpucb->PHYLOG.ucb$l_tl_phyucb;e                }                elsei                {"                   phyucb = tmpucb;                }/                ddb = phyucb->PHYBASE.ucb$l_ddb;tN                if (((void *) TTY$GL_DPT != (void *) phyucb->ucb$l_tt_class) &&C                    (strcmp("OPA", (char *) &ddb->ddb$t_name) != 0))l                {                   /*                   **K                   **	We have a viable candiate to try and switch.  Set the eM                   ** phyucb and potential logical UCB to nohangup.  Bump the eK                   ** reference count in phyucb and force a line disconnect.                    ** t                   */2                   phyucb->PHYBASE.ucb$l_refc += 1;d                   phyucb->PHYBASE.ucb$l_devdepnd2 = phyucb->PHYBASE.ucb$l_devdepnd2 & ~TT2$M_HANGUP;d                   tmpucb->PHYBASE.ucb$l_devdepnd2 = tmpucb->PHYBASE.ucb$l_devdepnd2 & ~TT2$M_HANGUP;R                   device_lock(phyucb->PHYBASE.ucb$l_dlck, RAISE_IPL, &saved_dipl);2                      tty$class_disconnect(phyucb);U                   device_unlock(phyucb->PHYBASE.ucb$l_dlck, saved_dipl, SMP_RESTORE);eS                   fork_unlock(asnucb->ASNBASE.ucb$b_flck, saved_fipl, SMP_RESTORE);r                   /*                   **L                   **	Now check if it is still ok to switch the device.  The M                   ** the reference count must be 2 or lower, and the logical iN                   ** UCB must point at the physical one.  The device also needO                   ** to be quiet.  If it set to modem the remote attribute mustd                   ** be set.                   **                   */9                   if ((phyucb->PHYBASE.ucb$l_refc > 2) ||dN                       ((void *) phyucb != (void *) phyucb->ucb$l_tt_logucb) ||L                       (phyucb->tty$v_st_read) || (phyucb->tty$v_st_write) ||/                       (phyucb->tty$v_st_multi))o                   {d5                      phyucb->PHYBASE.ucb$l_refc -= 1;e+                      status = SS$_DEVALLOC;/                   }.                }                elseu                {(                   status = SS$_IVDEVNAM;S                   fork_unlock(asnucb->ASNBASE.ucb$b_flck, saved_fipl, SMP_RESTORE);x                }             /* T             **O             **	Do not need to release fork lock here as all paths to here have t             ** already done so.i             **             */
          }
          elsec
          {"             status = SS$_IVDEVNAM;
          }       }/
       else       {o          status = SS$_DEVALLOC;d       }     } }i     /* **I **	We have found a device and got it all ready to do the line switch.  SoeP ** If everthing up to this point was successful then we can go ahead and swtich P ** it.  If not we will just fall through release the I/O database MUTEX and and  ** return with the error.t ** */ if (status & SS$_NORMAL) {n6    fork_lock(asnucb->ASNBASE.ucb$b_flck, &saved_fipl);>       if ((void *) phyucb->ucb$l_tt_logucb == (void *) phyucb)       {pI          device_lock(phyucb->PHYBASE.ucb$l_dlck, RAISE_IPL, &saved_dipl);              /*             **M             **	We need to block out device interrupts to do this check if the E             **  line is set to modem then the remote bit must be set.*             **             */>             if (phyucb->PHYBASE.ucb$l_devdepend & TT$M_MODEM) 
             {i.                if ((phyucb->ucb$b_tt_ds_rcv & C                     (TT$M_DS_DSR | TT$M_DS_CTS | TT$M_DS_CARRIER)))                 {.                   phyucb->ucb$w_tt_ds_tim = 0;                }                elseh                {)                   status = SS$_DEVREQERR;t                }
             }e$             if (status & SS$_NORMAL)
             {r                /*                 **RE                **	Save away PORT CONTROL flags.  They are going to be K                ** altered and the original values will need to be restored e:                ** when the line is given back to TTDRIVER.                **i                */fI                asnucb->ASNLOG.ucb$l_tl_outband = phyucb->ucb$w_tt_prtctl;e       W                asnucb->ASNLOG.ucb$l_tl_posix_data = (void *) phyucb->PHYBASE.ucb$l_ddt;i9                phyucb->PHYBASE.ucb$l_ddt = &asndummy_ddt;e    e                /*                 **tA                **	Now switch from TT to ASN and point at ASN UCB.t                **t                */o?                asnucb->ASNLOG.ucb$l_tl_phyucb = (UCB *) phyucb;dG                asnucb->ASNBASE.ucb$l_dlck = phyucb->PHYBASE.ucb$l_dlck;tG                asnucb->ASNBASE.ucb$b_dipl = phyucb->PHYBASE.ucb$b_dipl; Y                asnucb->ucb$l_asn_flags = UCB$M_ASN_DROP_CHARS | UCB$M_ASN_INPUT_DISABLED; 5                asnucb->ucb$l_asn_rcv_state = RCV_OFF;*8                phyucb->ucb$l_tt_logucb = (UCB *) asnucb;0                phyucb->PHYBASE.ucb$v_online = 0;-                phyucb->PHYBASE.ucb$v_tim = 0;NY                phyucb->PHYBASE.ucb$l_devchar = phyucb->PHYBASE.ucb$l_devchar &~DEV$M_AVL;*[                phyucb->PHYBASE.ucb$l_devchar2 = phyucb->PHYBASE.ucb$l_devchar2 | DEV$M_RED; +                phyucb->ucb$l_tt_state1 = 0;d+                phyucb->ucb$l_tt_state2 = 0;IB                if ((void *) phyucb->ucb$l_tt_typahd != (void *) 0)                {>                   com_std$drvdealmem(phyucb->ucb$l_tt_typahd);                }+                phyucb->ucb$l_tt_typahd = 0;c<                phyucb->ucb$l_tt_class = (int) &CLASS_VECTOR;C                phyucb->ucb$l_tt_getnxt = CLASS_VECTOR.class_getnxt;LC                phyucb->ucb$l_tt_putnxt = CLASS_VECTOR.class_putnxt; S                phyucb->ucb$w_tt_prtctl = phyucb->ucb$w_tt_prtctl | TTY$M_PC_NOTIME;R#                status = SS$_NORMAL; 
             }c             else
             {b/                phyucb->PHYBASE.ucb$l_refc -= 1;u3                if (phyucb->PHYBASE.ucb$l_refc < 0) u                {1                   phyucb->PHYBASE.ucb$l_refc = 0;                 }
             } L          device_unlock(phyucb->PHYBASE.ucb$l_dlck, saved_dipl, SMP_RESTORE);       }u
       else       {-)          phyucb->PHYBASE.ucb$l_refc -= 1; -          if (phyucb->PHYBASE.ucb$l_refc < 0) r
          {+             phyucb->PHYBASE.ucb$l_refc = 0;s
          }          status = SS$_DEVALLOC;        }*D    fork_unlock(asnucb->ASNBASE.ucb$b_flck, saved_fipl, SMP_RESTORE);   }c   sch_std$iounlock(CTL$GL_PCB);y      return status;   }(