 #pragma module pppdutil "X-17" /*M *****************************************************************************  * 1 * Copyright  1996 Digital Equipment Corporation.  * All rights reserved. * A * Redistribution and use in source and binary forms are permitted A * provided that the above copyright notice and this paragraph are : * duplicated in all such forms and that any documentation,< * advertising materials, and other materials related to suchB * distribution and use acknowledge that the software was developed4 * by Digital Equipment Corporation.  The name of theD * Corporation may not be used to endorse or promote products derived? * from this software without specific prior written permission. @ * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR@ * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIEDE * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * M *****************************************************************************     
 	FACILITY:   		PPPD  
 	ABSTRACT:  N                 This module contains the main line code for the user interface-         to the Point to Point (PPPD) Utility.    	AUTHOR:  + 		Iris Langstein Realmuto 	21-December-1995    	REVISION HISTORY:  ( 	X-17	JPT003		Joe P. Tavares		9-Apr-1997 		QAR EVMS-RAVEN #944 		   Fixed case when ASN device is bound to terminal8 		   so the QIO to get the line speed failed. Therefore,4 		   when an ASN device is bound to the terminal the6 		   utility just displays DEFAULT instead of the line; 		   speed since there is no way for the utility to get it.   < 	X-16    JPT002          Joe P. Tavares          24-Mar-1997 	        QAR EVMS-RAVEN #94 - 		    Changed initialization of device struct / 		    so that it contains the actual values for 0 		    transmit and receive speed.  Also, made it3 		    so that the hangup field in the device struct " 		    is defined at initialization  < 	X-15    JPT001          Joe P. Tavares          06-Mar-1997 	        QAR EVMS-RAVEN #841: 2 		    Needed to put in check to make sure that the3 		    remote bit before connecting when the line is  		    set to modem.   C         X-14    BWK014          Barry W. Kierstein      17-DEC-1996 @                     Replaced the standard Digital copyright with:                     one compatible with the CMU copyright.    C         X-13    BWK013          Barry W. Kierstein      26-SEP-1996 G                 In conjunction with standardizing the error handling in E                 PPPDUTIL_KERNEL.C, changed calls to these routines as E                 necessary.  Also, cleaned up the exit_handler routine I                 and the privileges in the SET_PRIV and REMOVE_PRIV pairs. '                 QAR EVMS-GRYPHON #2454: >                     Check was needed to catch invalid settingsB                     between combinations of permanent connections,?                     hardware flow control, /MODEM and /COMMSYNC $                     device settings.'                 QAR EVMS-GRYPHON #2474: B                     Needed to check that permanent connections areC                     not made on incoming connections.  This is done D                     by assuming that permanent connections will haveE                     the same physical device name as the device name. '                 QAR EVMS-GRYPHON #2505: B                     Fix problem where one can have trace processes)                     with duplicate names. '                 QAR EVMS-GRYPHON #2533: F                     Put in check for the possible NULL return from the:                     call to malloc in create_ppp_itemlist.#                 QAR EVMS-RAVEN #93: *                     Implement SET/NOTRACE.'                 QAR EVMS-GRYPHON #2647: F                     The SET_PRIV and REMOVE_PRIV macros only needed toI                     be invoked if the serial port speed needed to change, G                     or the hangup setting.  Conditionalized these calls 5                     as appropriate in set_line_items. '                 QAR EVMS-GRYPHON #2649: M                     Fixed the status and IOSB status checks in set_line_items J                     to remove the PHY_IO privilege if either the status orB                     IOSB status contained an error condition code.  C         X-12    BWK012          Barry W. Kierstein      30-AUG-1996 H                 Changed NOTSET error message ID to NOTCONNECT by request,                 of the documentation people.C                 QAR EVMS-GRYPHON #2429:  At the PPPD> prompt, could I                     not DISCONNECT a device with the PERMANENT connection 8                     attribute right after CONNECTing it.F                 QAR EVMS-GRYPHON #2434:  When using virtual terminals,D                     utility would not keep settings from one command4                     to the next at the PPPD> prompt.  C         X-11    BWK011          Barry W. Kierstein      21-AUG-1996 -                 Some misc. bug fixes in SHOW. )                 QAR EVMS-GRYPHON-FT #123: M                     SET/PERM ttxn:, SHOW ttxn: would not show PERM line type. )                 QAR EVMS-GRYPHON-FT #125: ?                     SHOW would not show the results of SET/MTU. )                 QAR EVMS-GRYPHON-FT #128: ;                     SET/FSC_SIZE not implemented correctly. )                 QAR EVMS-GRYPHON-FT #131: H                     SHOW would show the internal coded port speed rates,6                     not the human-understandable ones.  C         X-10    BWK010          Barry W. Kierstein      13-AUG-1996 )                 QAR EVMS-GRYPHON-FT #107: K                     Set/Checked ppp_callback_registered field of DEVICE_REC L                     when initializing and potentially using the PPP callback                     routine.)                 QAR EVMS-GRYPHON-FT #114: J                     Took out masking of switch characters for the DIAL_OUT                     command.  C         X-9     BWK009          Barry W. Kierstein      12-AUG-1996 8                 Added support for SHOW/ALL={BRIEF,LONG}.  C         X-8     BWK008          Barry W. Kierstein      08-Aug-1996 J                 ASN device behavior change.  Made calls to get_device_infoH                 use the physical device name instead of the device name,.                 which is now the ASNn: device.M                 QAR EVMS-GRYPHON-FT 112:  CONNECT on virtual terminals fails. E                 QAR EVMS-GRYPHON-FT 105:  Took out DELPRC workaround. M                 QAR EVMS-GRYPHON-FT 100:  Unnecessary term type restrictions.   C         X-7     BWK007          Barry W. Kierstein      07-Aug-1996 R                 Added CONNECTTERM message to signal the user that a PPP connection#                 is being attempted.   C         X-6     BWK006          Barry W. Kierstein      16-JUL-1996 @                 Added code to manage the trace_mbx field for the=                 shutdown_logger routine.  Fixed several bugs. @                 Put all SHOW option text tables into the messageD                 file.  Put in CHECK_AND_REPORT* macros in for better                  error reporting.  C         X-5     BWK005          Barry W. Kierstein      11-JUL-1996 I                 Finished DIAL_OUT and HELP commands, fixed numerous bugs.   C         X-4     BWK004          Barry W. Kierstein      14-JUN-1996 L                 Finished the SET and SHOW commands, and fixed numerous bugs.L                 Also added code to make sure that elevated privileges are on                 only as needed.   C         X-3     BWK003          Barry W. Kierstein      20-MAY-1996 H                 Incorporated fix to kill off the starting process if theJ                 process' SYS$COMMAND is TT:.  Also added code to make sure?                 that elevated privileges are on only as needed.   C         X-2     BWK002          Barry W. Kierstein      14-MAY-1996 I                 Implemented initial SHOW command and fixed numerous bugs. F                 Also incorporated the PPPD$DECODE_LOG_FILE.C code into-                 the PPPD$UTIL.EXE image file.   C         X-1     BWK001          Barry W. Kierstein      12-APR-1996 0                 Initial check in of this module. */   #define  PPPD_MAIN      1  #include <stdio.h> #include <stdlib.h>  #include <stdarg.h>  #include <starlet.h> #include <ssdef.h> #include <descrip.h> #include <string.h>  #include <ctype.h> #include <stsdef.h>  #include <jpidef.h>  #include <chfdef.h>  #include <libdef.h>  #include <lib$routines.h>  #include <smgdef.h>  #include <smg$routines.h>  #include <rmsdef.h>  #include <climsgdef.h> #include <dvidef.h>  #include <ttdef.h> #include <tt2def.h>  #include <str$routines.h>  #include <lnmdef.h>  #include <dcdef.h> #include <devdef.h>  #include <prvdef.h>  #include <iodef> #include <prcdef.h>  #include <lbrdef.h>  #include <lbr$routines.h>  #include "pppddef.h" #include "asndef.h"  #include "ppp_mgmt_if.h" #include "pppdutil_common.h" #include "pppdutil.h"  #include "pppdutil_dialout.h"  #include "pppdutil_kernel.h"   /* Debug section */    #ifdef DEBUG_CODE   H int     asn_itemlist_dump;      /* Show additions/changes/extractions */Y int     line_item_trace;        /* Show serial port items that aren't in the itemlists */ H int     ppp_itemlist_dump;      /* Show additions/changes/extractions */Q int     ppp_itemlist_trace;     /* Show address computation in traversing list */ Z int     tracefile_trace;        /* Show information useful in debugging the /TRACE code */M int     disable_term_type_check;/* Disable the terminal type checking code */    #endif   /* Constants */  #define MAX_BUFFER_SIZE    255 #define UNDERSCORE_CHAR    '_' #define BLANK_CHAR         ' ' #define BASE_PRIORITY        4 #define MBX_TMPFLG           0 #define MBX_PRMFLG           1I #define CONTROL_CHAR_MASK 0x1F  /* Generate a control character out of */ I                                 /* a printable character               */     /* Minimum and Maximum Ranges */* /*** Barry: confirm next two max values */ #define MIN_ECHO_FAILURE      0  #define MAX_ECHO_FAILURE    255  #define MIN_ECHO_INTERVALS    0p #define MAX_ECHO_INTERVALS  255*   #define MIN_MAGIC_NUMBER      0* #define MAX_MAGIC_NUMBER    255  #define MIN_MAX_CONFIGURE     0t #define MAX_MAX_CONFIGURE   255r #define MIN_MAX_FAILURE       0e #define MAX_MAX_FAILURE     255e #define MIN_MAX_TERMINATE     0v #define MAX_MAX_TERMINATE   255r #define MIN_MRU     6i #define MAX_MRU  1500a #define MIN_MTU     6  #define MAX_MTU  1500a #define MIN_RECEIVE_ACCM    0u& #define MAX_RECEIVE_ACCM    0xFFFFFFFF #define MIN_RESTART_TIMER   1  #define MAX_RESTART_TIMER  90i   /* Values for trace settings */ % #define TRACE_FILE_CLEAR        FALSEr$ #define TRACE_FILE_SET          TRUE! #define TRACE_FILE_UNSPECIFIED  2s  % /* Values for serial port settings */I= /* Note: HANGUP_CLEAR and HANGUP_SET or defined to correspond,:    to TRUE/FALSE returned from GETDVI call, changing these?    definitions will break the GETDVI call in get_device_info */*1 #define HANGUP_CLEAR            0 /* No hangup */*1 #define HANGUP_SET              1 /* Hangup    */ ! #define HANGUP_UNSPECIFIED      2i  ! #define SPEED_UNSPECIFIED       0t  * /* Values for qualifier_present routine */M #define QUALIFIER_PRESENT       TRUE  /* correlates with PPP mgmt routines */OM #define QUALIFIER_NEGATED       FALSE /* correlates with PPP mgmt routines */	! #define QUALIFIER_ABSENT        2u! #define QUALIFIER_DEFAULTED     3g   /* Default Attributes */) #define DEFAULT_CLEAR_COUNTERS  ASN$M_ALLt) #define DEFAULT_SHOW_COUNTERS   ASN$M_ALLa. #define DEFAULT_FLOW_CONTROL    ASN$M_XON_XOFF2 #define DEFAULT_HANGUP          HANGUP_UNSPECIFIED1 #define DEFAULT_SPEED           SPEED_UNSPECIFIED-   /* Default Values */+ #define DEFAULT_BREAK_CHAR              '~'e, #define DEFAULT_DISCONNECT_CHAR         '\\'+ #define DEFAULT_SWITCH_CHAR             '@'s+ #define DEFAULT_BREAK_CHAR_STR          "~"p, #define DEFAULT_DISCONNECT_CHAR_STR     "\\"+ #define DEFAULT_SWITCH_CHAR_STR         "@"   ^ VAR_STATIC char  default_break_char             = DEFAULT_BREAK_CHAR      & CONTROL_CHAR_MASK;^ VAR_STATIC char  default_disconnect_char        = DEFAULT_DISCONNECT_CHAR & CONTROL_CHAR_MASK;^ VAR_STATIC char  default_switch_char            = DEFAULT_SWITCH_CHAR     & CONTROL_CHAR_MASK;  7 VAR_STATIC u_int default_address_compression    = TRUE; 7 VAR_STATIC u_int default_echo_failure           =    0; 7 VAR_STATIC u_int default_echo_intervals         =    0;97 VAR_STATIC u_int default_magic_number           =    5; 7 VAR_STATIC u_int default_max_configure          =   10;a7 VAR_STATIC u_int default_max_failure            =    5;r7 VAR_STATIC u_int default_max_terminate          =    2; 7 VAR_STATIC u_int default_mru                    = 1500;p7 VAR_STATIC u_int default_mtu                    = 1500; @ VAR_STATIC u_int default_passive                = PPPD$K_ACTIVE;B VAR_STATIC u_int asn_default_permanent          = ASN$M_TRANSIENT;C VAR_STATIC u_int ppp_default_permanent          = PPPD$K_TRANSIENT; 7 VAR_STATIC u_int default_protocol_compression   = TRUE;#= VAR_STATIC u_int default_receive_accm           = 0xFFFFFFFF;e7 VAR_STATIC u_int default_receive_fcs_size       =   16;e7 VAR_STATIC u_int default_restart_timer          =   30;h8 VAR_STATIC u_int default_trace                  = FALSE;) VAR_STATIC u_int default_transmit_accm[]=a4     {0xFFFFFFFF,0x0,0x0,0x60000000,0x0,0x0,0x0,0x0};7 VAR_STATIC u_int default_transmit_fcs_size      =   16;s  ; VAR_STATIC $DESCRIPTOR(default_network_protocol, "TCP/IP"); 4 VAR_STATIC $DESCRIPTOR(trace_file_extension,".LOG");  " /* Settings for discrete values */ #define END_OF_VALUE_LIST  -1t" VAR_STATIC u_int fcs_size_list[] =< /*     { 0, 16, 32, 48, END_OF_VALUE_LIST }; for later on */     { 16, END_OF_VALUE_LIST }; VAR_STATIC struct# {7     u_int  number;     u_int  code; }   port_speed_list[] =y     { 0         { SPEED_UNSPECIFIED, DEFAULT_SPEED    },0         {                50, TT$C_BAUD_50     },0         {                75, TT$C_BAUD_75     },0         {               110, TT$C_BAUD_110    },0         {               134, TT$C_BAUD_134    },0         {               150, TT$C_BAUD_150    },0         {               300, TT$C_BAUD_300    },0         {               600, TT$C_BAUD_600    },0         {              1200, TT$C_BAUD_1200   },0         {              1800, TT$C_BAUD_1800   },0         {              2400, TT$C_BAUD_2400   },0         {              3600, TT$C_BAUD_3600   },0         {              4800, TT$C_BAUD_4800   },0         {              7200, TT$C_BAUD_7200   },0         {              9600, TT$C_BAUD_9600   },0         {             19200, TT$C_BAUD_19200  },0         {             38400, TT$C_BAUD_38400  },0         {             57600, TT$C_BAUD_57600  },0         {             76800, TT$C_BAUD_76800  },0         {            115200, TT$C_BAUD_115200 },/         { END_OF_VALUE_LIST, 0                }t     };  ) VAR_STATIC u_int illegal_tx_accm_mask[] =a=     { 0x0, 0xFFFFFFFF, 0x80000000, 0x0, 0x0, 0x0, 0x0, 0x0 };b   /* Qualifier list tables */  typedef struct {N     char  *text;     u_int mask;/ }   KEYWORD_TABLE;  2 VAR_STATIC KEYWORD_TABLE counter_keyword_table[] = {V4     { "ALL",                 ASN$M_ALL            },4     { "BAD_FCS_PACKETS",     ASN$M_BAD_FCS_RCV    },4     { "DATA_LOST",           ASN$M_DATA_LOST      },4     { "DROPPED_CHARACTERS",  ASN$M_DROPPED_CHARS  },4     { "FRAMING_ERRORS",      ASN$M_FE             },4     { "LONG_PACKETS",        ASN$M_LONG_PACKETS   },4     { "RECEIVED_PACKETS",    ASN$M_PACKETS_RCV    },4     { "TRANSMITTED_PACKETS", ASN$M_PACKETS_XMIT   },4     { "RUNT_PACKETS",        ASN$M_RUNT_PACKETS   },3     { "TOTAL_CHARACTERS",    ASN$M_TOTAL_CHARS    }  };  0 /* SHOW output related tables and definitions */  * #define SHOW$M_ADDR_COMP         (1 <<  0)* #define SHOW$M_COUNTERS          (1 <<  1)* #define SHOW$M_ECHO_FAILURE      (1 <<  2)* #define SHOW$M_ECHO_INTERVAL     (1 <<  3)* #define SHOW$M_FLOW_CONTROL      (1 <<  4)* #define SHOW$M_HANGUP            (1 <<  5)* #define SHOW$M_MAGIC_RETRIES     (1 <<  6)* #define SHOW$M_MAX_CONFIGURE     (1 <<  7)* #define SHOW$M_MAX_FAILURE       (1 <<  8)* #define SHOW$M_MAX_TERMINATE     (1 <<  9)* #define SHOW$M_MRU               (1 << 10)* #define SHOW$M_MTU               (1 << 11)* #define SHOW$M_NETWORK_PROTOCOL  (1 << 12)* #define SHOW$M_PASSIVE           (1 << 13)* #define SHOW$M_PERMANENT         (1 << 14)* #define SHOW$M_PROTOCOL_COMP     (1 << 15)* #define SHOW$M_RECEIVE_ACCM      (1 << 16)* #define SHOW$M_RECEIVE_FCS_SIZE  (1 << 17)* #define SHOW$M_RESTART_TIMER     (1 << 18)* #define SHOW$M_SPEED             (1 << 19)* #define SHOW$M_TRACE             (1 << 20)* #define SHOW$M_TRANSMIT_ACCM     (1 << 21)* #define SHOW$M_TRANSMIT_FCS_SIZE (1 << 22)* #define SHOW$M_ALL               (1 << 23)B     /* ALL must be last, so (SHOW$M_ALL-1) = all other bits set */1 #define SHOW$M_ALL_OPTIONS       (SHOW$M_ALL - 1)d* #define SHOW$M_ALL_BRIEF         (1 << 24)D     /* This must be after SHOW$M_ALL_OPTIONS since it is not part */6     /* of the SHOW$M_ALL_OPTIONS display (/ALL=LONG */0 #define ASN_ALL_COUNTERS         (ASN$M_ALL - 1)   #define SHOW_MASK u_int  #define COUNTER_MASK u_int  ? /* Structures to hold the text choices for the SHOW command. */A, /* Actual text is in the PPPDMSG.MSG file */   D_DESCRIPTOR    text_on; D_DESCRIPTOR    text_off;  D_DESCRIPTOR    text_hw; D_DESCRIPTOR    text_xon_xoff; D_DESCRIPTOR    text_set;o D_DESCRIPTOR    text_notset; D_DESCRIPTOR    text_default;l D_DESCRIPTOR    text_transient;  D_DESCRIPTOR    text_permanent;  D_DESCRIPTOR    text_passive;  D_DESCRIPTOR    text_active;! D_DESCRIPTOR    text_trans_error;t D_DESCRIPTOR    text_null;   typedef struct { 
     int code;S     D_DESCRIPTOR *text_desc; }   MSG_TEXT_TRANS_TABLE;   ! #define END_OF_CODE_LIST        0o! #define INFO_NOT_FOUND         -1 = VAR_STATIC MSG_TEXT_TRANS_TABLE show_msg_text_trans_table[] =  { 1     { PPPD$_TEXT_ON,        &text_on           },r1     { PPPD$_TEXT_OFF,       &text_off          },P1     { PPPD$_TEXT_HW,        &text_hw           }, 1     { PPPD$_TEXT_XON_XOFF,  &text_xon_xoff     },11     { PPPD$_TEXT_SET,       &text_set          }, 1     { PPPD$_TEXT_NOTSET,    &text_notset       }, 1     { PPPD$_TEXT_DEFAULT,   &text_default      },i1     { PPPD$_TEXT_TRANSIENT, &text_transient    },<1     { PPPD$_TEXT_PERMANENT, &text_permanent    },>1     { PPPD$_TEXT_PASSIVE,   &text_passive      },e1     { PPPD$_TEXT_ACTIVE,    &text_active       },f1     { PPPD$_TEXT_TRNERR,    &text_trans_error  },h0     { END_OF_CODE_LIST,     &text_null         } };   typedef struct {      int  value;e     D_DESCRIPTOR *text_desc; }   OUTPUT_TRANS_TABLE;e  5 VAR_STATIC OUTPUT_TRANS_TABLE on_off_output_table[] =f { 2     { TRUE,                   &text_on          },2     { FALSE,                  &text_off         },1     { END_OF_VALUE_LIST,      &text_trans_error }  };  : VAR_STATIC OUTPUT_TRANS_TABLE debug_trace_output_table[] = { 2     { TRACE_FILE_CLEAR,       &text_off         },2     { TRACE_FILE_SET,         &text_on          },2     { TRACE_FILE_UNSPECIFIED, &text_on          },1     { END_OF_VALUE_LIST,      &text_trans_error }i };  ; VAR_STATIC OUTPUT_TRANS_TABLE flow_control_output_table[] =o {e2     { ASN$M_HW,               &text_hw          },2     { ASN$M_XON_XOFF,         &text_xon_xoff    },1     { END_OF_VALUE_LIST,      &text_trans_error }  };  5 VAR_STATIC OUTPUT_TRANS_TABLE hangup_output_table[] =r {f2     { HANGUP_SET,             &text_set         },2     { HANGUP_CLEAR,           &text_notset      },2     { HANGUP_UNSPECIFIED,     &text_default     },1     { END_OF_VALUE_LIST,      &text_trans_error }S };  8 VAR_STATIC OUTPUT_TRANS_TABLE line_type_output_table[] = { 2     { PPPD$K_TRANSIENT,       &text_transient   },2     { PPPD$K_PERMANENT,       &text_permanent   },1     { END_OF_VALUE_LIST,      &text_trans_error }o };  3 VAR_STATIC OUTPUT_TRANS_TABLE mode_output_table[] =a {i2     { PPPD$K_PASSIVE,         &text_passive     },2     { PPPD$K_ACTIVE,          &text_active      },1     { END_OF_VALUE_LIST,      &text_trans_error }n };  K /* There is no PCBDEF for DEC C on VAX. In that case, we define PCB$M_BATCHRJ    here. It is ugly but the definition of the mask will not change because"    it will break existing code. */   #ifndef PCB$M_BATCHF #define PCB$M_BATCH 0x04000_ #endif   /* Commands */. VAR_STATIC $DESCRIPTOR(operation,"OPERATION");. VAR_STATIC $DESCRIPTOR(help_text,"HELP_TEXT");1 VAR_STATIC $DESCRIPTOR(physical_device,"DEVICE");n= VAR_STATIC $DESCRIPTOR(connect_command, "OPERATION.CONNECT");CC VAR_STATIC $DESCRIPTOR(convert_command, "OPERATION.CONVERT_TRACE");_> VAR_STATIC $DESCRIPTOR(dialout_command, "OPERATION.DIAL_OUT");C VAR_STATIC $DESCRIPTOR(disconnect_command, "OPERATION.DISCONNECT");_7 VAR_STATIC $DESCRIPTOR(help_command, "OPERATION.HELP");s5 VAR_STATIC $DESCRIPTOR(set_command, "OPERATION.SET");N7 VAR_STATIC $DESCRIPTOR(show_command, "OPERATION.SHOW");   " /* Qualifiers - DIALOUT command */, VAR_STATIC $DESCRIPTOR(break_char, "BREAK");6 VAR_STATIC $DESCRIPTOR(disconnect_char, "DISCONNECT");. VAR_STATIC $DESCRIPTOR(switch_char, "SWITCH");  # /* Qualifiers - SET/SHOW command */fC VAR_STATIC $DESCRIPTOR(address_compression, "ADDRESS_COMPRESSION"); # VAR_STATIC $DESCRIPTOR(all, "ALL");t/ VAR_STATIC $DESCRIPTOR(all_brief, "ALL.BRIEF");c- VAR_STATIC $DESCRIPTOR(all_long, "ALL.LONG");U9 VAR_STATIC $DESCRIPTOR(clear_counters, "CLEAR_COUNTERS");t+ VAR_STATIC $DESCRIPTOR(connect, "CONNECT"); - VAR_STATIC $DESCRIPTOR(counters, "COUNTERS");t% VAR_STATIC $DESCRIPTOR(echo, "ECHO");O5 VAR_STATIC $DESCRIPTOR(echo_failure, "ECHO.FAILURE");$8 VAR_STATIC $DESCRIPTOR(echo_intervals, "ECHO.INTERVAL");- VAR_STATIC $DESCRIPTOR(fcs_size, "FCS_SIZE");D5 VAR_STATIC $DESCRIPTOR(flow_control, "FLOW_CONTROL"); G VAR_STATIC $DESCRIPTOR(flow_control_hardware, "FLOW_CONTROL.HARDWARE");nG VAR_STATIC $DESCRIPTOR(flow_control_xon_xoff, "FLOW_CONTROL.XON_XOFF"); ) VAR_STATIC $DESCRIPTOR(hangup, "HANGUP"); = VAR_STATIC $DESCRIPTOR(magic_number, "MAGIC_NUMBER_RETRIES");f6 VAR_STATIC $DESCRIPTOR(max_configure, "MAXCONFIGURE");2 VAR_STATIC $DESCRIPTOR(max_failure, "MAXFAILURE");6 VAR_STATIC $DESCRIPTOR(max_terminate, "MAXTERMINATE");# VAR_STATIC $DESCRIPTOR(mru, "MRU");C# VAR_STATIC $DESCRIPTOR(mtu, "MTU");_= VAR_STATIC $DESCRIPTOR(network_protocol, "NETWORK_PROTOCOL");A+ VAR_STATIC $DESCRIPTOR(passive, "PASSIVE");t/ VAR_STATIC $DESCRIPTOR(permanent, "PERMANENT");TE VAR_STATIC $DESCRIPTOR(protocol_compression, "PROTOCOL_COMPRESSION");u5 VAR_STATIC $DESCRIPTOR(receive_accm, "RECEIVE_ACCM");f7 VAR_STATIC $DESCRIPTOR(restart_timer, "RESTART_TIMER");f' VAR_STATIC $DESCRIPTOR(speed, "SPEED");_' VAR_STATIC $DESCRIPTOR(trace, "TRACE"); 7 VAR_STATIC $DESCRIPTOR(transmit_accm, "TRANSMIT_ACCM");   8 VAR_STATIC const $DESCRIPTOR(help_library, "PPPD$HELP");4 VAR_STATIC const $DESCRIPTOR(pppd_facility, "PPPD");5 VAR_STATIC const $DESCRIPTOR(pppd_facility_2c, "PD"); 5 VAR_STATIC const $DESCRIPTOR(sys$input, "SYS$INPUT");rA VAR_STATIC const $DESCRIPTOR(process_tabnam,"LNM$PROCESS_TABLE");r? VAR_STATIC const $DESCRIPTOR(system_tabnam,"LNM$SYSTEM_TABLE");o  = VAR_STATIC $DESCRIPTOR(protocol_lookup,"SYS$NET_SERVICES_5");c@ VAR_STATIC $DESCRIPTOR(protocol_callback,"SYS$NET_SERVICES_13");9 VAR_STATIC $DESCRIPTOR(open_routine,"PPPD$open_connect"); , VAR_STATIC $DESCRIPTOR(underscore_desc,"_");( VAR_STATIC $DESCRIPTOR(dollar_desc,"$");' VAR_STATIC $DESCRIPTOR(colon_desc,":");F8 VAR_STATIC $DESCRIPTOR(unsupported_dev_types,"_RT _OP");2 VAR_STATIC $DESCRIPTOR(supported_dev_types,"_VT");8 VAR_STATIC $DESCRIPTOR(virtual_terminal_dev_type,"_VT");B VAR_STATIC $DESCRIPTOR(logger_image,"sys$system:pppd$logger.exe");, VAR_STATIC $DESCRIPTOR(null_device,"NLA0:");' char   asn_device_template[] = "ASN0:";=   /* external definitions */ extern pppd$command_table;  Q /* The following CLI functions are not defined in a h file so define them here */  VMS_STATUS cli$dispatch(void);9 VMS_STATUS cli$dcl_parse(D_DESCRIPTOR *, void *, void *); 7 VMS_STATUS cli$get_value(DESCRIPTOR *, D_DESCRIPTOR *); % VMS_STATUS cli$present(DESCRIPTOR *);   O /* Exit handler control block. We declare the structure here because there does3N    not appear to be any H file definition of it. See the $DCLEXH documentation    for the details. */C #pragma __nostandard  /* Don't allow this structure to be packed */ ! #pragma __member_alignment __saveA #pragma __nomember_alignment  ! VAR_STATIC struct tagVMSExitBlock  { :         u_int *flink;                   /* Forward link */G         VMS_STATUS (*exit_handler)(void);    /* Exit handler address */0         u_int must_be_zero; G         u_int *condition_value;         /* addr to write file status */ 
 } exit_block;    /* Turn alignment back on. */ $ #pragma __member_alignment __restoreC #pragma __standard  /* This file uses non-ANSI-Standard features */    /* Global Variables */: VAR_STATIC u_short max_buffer_size      = MAX_BUFFER_SIZE;, VAR_STATIC u_int   keyboard_id          = 0;, VAR_STATIC u_int   key_table_id         = 0;U VAR_STATIC u_int   final_status;    /* Location where final status will be written */ 0 VAR_STATIC int     exit_utility         = FALSE;0 VAR_STATIC int     connect_init_done    = FALSE;  / VAR_STATIC DEVICE_REC *current_device   = NULL;b/ VAR_STATIC DEVICE_REC *device_list      = NULL;L   /* Functions */ M PROC_STATIC void add_ppp_item(NETWORK_ITEMLIST *items, u_int tag, void *data,A+                               u_short len);TA PROC_STATIC int assign_channel(D_DESCRIPTOR *name, CHAN *channel,F4                                u_int priv_required);< PROC_STATIC int bind_asn_device(DEVICE_REC *current_device);S PROC_STATIC int call_kernel_routine(KERNEL_RETURN_STATUS_TYPE *(*kernel_routine)(), @                                     DEVICE_REC *current_device);I PROC_STATIC int check_port_and_line_settings(DEVICE_REC *current_device); 8 PROC_STATIC NETWORK_ITEMLIST *create_ppp_itemlist(void); #ifdef DEBUG_CODE >     void dump_asn_itemlist(char *header, VMS_ITEMLIST *items);B     void dump_ppp_itemlist(char *header, NETWORK_ITEMLIST *items); #endifL PROC_STATIC int edit_device_name(D_DESCRIPTOR *input, D_DESCRIPTOR *output); VMS_STATUS exit_handler(void);U PROC_STATIC int extract_ppp_int_item(NETWORK_ITEMLIST *items, u_int tag, void *data);XX PROC_STATIC int extract_ppp_string_item(NETWORK_ITEMLIST *items, u_int tag, char *data);O PROC_STATIC int find_device_type (DESCRIPTOR *device_type, D_DESCRIPTOR *name);MG PROC_STATIC int get_asn_name(CHAN asn_channel, D_DESCRIPTOR *asn_name); a PROC_STATIC int get_asn_name_from_device_name(D_DESCRIPTOR *device_name, D_DESCRIPTOR *asn_name);W8 PROC_STATIC int get_clear_counters(VMS_ITEMLIST *items);M PROC_STATIC int get_counter_items(DESCRIPTOR *qualifier, COUNTER_MASK *mask);Aq PROC_STATIC int get_device_info(D_DESCRIPTOR *device_name, D_DESCRIPTOR *physical_device_name, int *line_inited);dR PROC_STATIC int get_device_name(D_DESCRIPTOR *device_name, D_DESCRIPTOR *tt_name);= PROC_STATIC int get_device_translation(D_DESCRIPTOR *lognam);WP PROC_STATIC int get_device_UIC(D_DESCRIPTOR device_name, UIC_VALUE *device_UIC);; PROC_STATIC int get_fcs_sizes(NETWORK_ITEMLIST *ppp_items);H6 PROC_STATIC int get_flow_control(VMS_ITEMLIST *items);3 PROC_STATIC void get_hangup(u_int *hangup_setting); 5 VMS_STATUS get_input(D_DESCRIPTOR *user_command_desc,h>                      D_DESCRIPTOR *prompt_desc, u_short *len);S PROC_STATIC int get_int_qualifier(DESCRIPTOR *qualifier, int *value, int min_value, 1                                   int max_value);xA PROC_STATIC int get_network_callback(DEVICE_REC *current_device);EF PROC_STATIC int get_network_translation(DESCRIPTOR *lognam, int index,J                                         D_DESCRIPTOR *lookup, int *found);Q /*PROC_STATIC char *get_output_text(OUTPUT_TRANS_TABLE *text_table, int value);*/ U PROC_STATIC D_DESCRIPTOR *get_output_text(OUTPUT_TRANS_TABLE *text_table, int value); T PROC_STATIC int get_permanent(NETWORK_ITEMLIST *ppp_items, VMS_ITEMLIST *asn_items);I PROC_STATIC int get_speed(u_char *input_speed,  u_int *input_show_speed,  J                           u_char *output_speed, u_int *output_show_speed);V PROC_STATIC int get_show_qualifiers(SHOW_MASK *show_mask, COUNTER_MASK *counter_mask);; PROC_STATIC int get_transmit_accm(NETWORK_ITEMLIST *items); N PROC_STATIC int get_tt_name(D_DESCRIPTOR *device_name, D_DESCRIPTOR *tt_name);Y PROC_STATIC int get_u_int_qualifier(DESCRIPTOR *qualifier, u_int *value, u_int min_value, 5                                     u_int max_value);P2 PROC_STATIC int get_user_UIC(UIC_VALUE *user_UIC);? PROC_STATIC void initialize_asn_set_items(VMS_ITEMLIST *items);R9 PROC_STATIC NETWORK_ITEMLIST *initialize_ppp_items(void);tV PROC_STATIC VMS_STATUS load_message_text_table(MSG_TEXT_TRANS_TABLE msg_text_table[]);O PROC_STATIC VMS_STATUS pppd_condition_handler(struct chf$signal_array *sigargs,lO                                               struct chf$mech_array *mechargs); * PROC_STATIC int process_cli_command(void);- PROC_STATIC int process_noncli_command(void); I PROC_STATIC int output_msg_line(VMS_STATUS msg_code, int arg_count, ...);_6 PROC_STATIC VMS_STATUS put_output(D_DESCRIPTOR *desc);9 PROC_STATIC int qualifier_present(DESCRIPTOR *qualifier);IP PROC_STATIC int sense_asn_items(D_DESCRIPTOR *device_name, VMS_ITEMLIST *items);H PROC_STATIC int set_asn_items(CHAN device_channel, VMS_ITEMLIST *items);; PROC_STATIC int set_line_items(DEVICE_REC *current_device);O< PROC_STATIC int start_ppp_trace(DEVICE_REC *current_device);6 PROC_STATIC int strtoint(int *nbr, D_DESCRIPTOR *str); int util$connect(void);l int util$dialout(void);S int util$disconnect(void); int util$exit(void); int util$help(void); int util$set(void);  int util$show(void);P PROC_STATIC int update_asn_item(VMS_ITEMLIST *items, u_int item_code, int data);P PROC_STATIC int update_ppp_item(NETWORK_ITEMLIST *items, u_int tag, void *data);A PROC_STATIC int validate_device_name(DEVICE_REC *current_device);xV PROC_STATIC int validate_device_type(D_DESCRIPTOR *device_name, VMS_ITEMLIST items[]);$ PROC_STATIC int validate_mode(void);> PROC_STATIC int verify_line_items(DEVICE_REC *current_device); P /* ** Function Name ** **    add_ppp_item ** ** Functional Descriptionx **F **    This routine adds a ppp data item into the ppp item list for the **    current device ** ** Environment ** **    User moden **	 ** Inputsl **) **    items     - ptr to the ppp itemlist  **    tag       - item code tag - **    data      - ptr to the data item to adda/ **                if 0, then clear item insteadO+ **    len       - length of the item to addT **
 ** Outputs **% **    items - ptr to the ppp itemlist  **
 ** Returns **
 **    None ** */M PROC_STATIC void add_ppp_item(NETWORK_ITEMLIST *items, u_int tag, void *data,E%                          u_short len)a {t% NETWORK_ITEM_INT_ENTRY *current_item;T  9     if ((items->item_length + NETWORK_ITEMLIST_HDR_SIZE +_O                              (NETWORK_ITEM_HDR_SIZE + len)) > items->item_size)R     {m\         signal_error (PPPD$_PPPLISTOVER, 4, tag, items->item_size, items->item_length, len);         exit(SS$_ACCVIO);      }T   #ifdef DEBUG_CODEc         if (ppp_itemlist_dump)7             dump_ppp_itemlist ("Add_ppp_items", items);I           if (ppp_itemlist_trace)Qm             printf ("Add_ppp_items:  Before current_item calc, items->item_length, len , tag = %d, %d, %d\n",T3                      items->item_length, len, tag);a #endif  K     current_item = (NETWORK_ITEM_INT_ENTRY *)((char *)items->item_address +E(                     items->item_length);   #ifdef DEBUG_CODEI     if (ppp_itemlist_trace)AK         printf ("Add_ppp_items:  current_item = %d\n", (long)current_item);C #endif  <     current_item->item_length = NETWORK_ITEM_HDR_SIZE + len;!     current_item->item_tag = tag;O     if (data == 0)!     {   /* Clear the data area */E/         memset(&current_item->item_data,0,len);C     })     else%     {   /* Copy the passed in data */ 2         memcpy(&current_item->item_data,data,len);     }t4     items->item_length += current_item->item_length;   #ifdef DEBUG_CODEA     if (ppp_itemlist_trace)TU         printf ("Add_ppp_items:  new items->item_length = %d\n", items->item_length);O     if (ppp_itemlist_dump)3         dump_ppp_itemlist ("Add_ppp_items", items);I #endif   }i e /* ** Function Name ** **    assign_channel ** ** Functional DescriptionR **0 **    This routine assigns a channel to a device ** ** Environment ** **    User modeC **	 ** Inputs  **A **    name - ptr to the name of the device as a string descriptorT( **    priv_required - privilige required **
 ** Outputs **- **    channel - pointer to the channel device_ **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  ** */A PROC_STATIC int assign_channel(D_DESCRIPTOR *name, CHAN *channel,A.                           u_int priv_required)   {  VMS_STATUS status; VMS_STATUS ret_status; PRIV prev_priv; 
 PRIV mask;       if (priv_required)     {P9         SET_PRIV(mask.prv$v_sysprv,mask,prev_priv,status))/         CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0IJ             ("assign_channel (SET_PRIV)", PPPD$_ASSIGNCHAN, status, name);     }T  7     ret_status = sys$assign(name,     /* device name */ :                             channel,  /* channel number */2                             0,        /* acmode */2                             0,        /* mbxnam */1                             0);       /* flags */u  +     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0lI         ("Assign_channel ($assign)", PPPD$_ASSIGNCHAN, ret_status, name);I       if (priv_required)     {O=         /* remove the privilege if it was not there before */TA         REMOVE_PRIV(prev_priv.prv$v_sysprv,mask,prev_priv,status)C/         CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0;M             ("assign_channel (REMOVE_PRIV)", PPPD$_ASSIGNCHAN, status, name);"     }=  "     /* return the assign status */     return TRUE; }  * /* ** Function Name ** **    bind_asn_device  ** ** Functional Description  **A **    This routine binds the asynch device to the physical device, ** ** Environment ** **    User model **	 ** Inputs, **G **    current_device - pointer to the current device in the device list  **
 ** Outputs **
 **    None **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  */; PROC_STATIC int bind_asn_device(DEVICE_REC *current_device)m {_ VMS_STATUS status; IOSB iosb, iosbTerminal_Info;k VMS_ITEMLIST items[1];& VMS_ITEMLIST itemlistTerminal_Info[2];) unsigned long ulTerminal_Info_Buffer = 0;c  ,     VMS_ITEMLIST_INIT(itemlistTerminal_Info)     H     /* Populate itemlistTerminal_Info to get terminal characteristics */&     VMS_ITEMLIST_ADDR(DVI$_DEVDEPEND, ' 		      sizeof(ulTerminal_Info_Buffer), ! 		      &ulTerminal_Info_Buffer,   		      0);   B     VMS_ITEMLIST_ADDR(0,             /* Null terminate itemlist */ 		      0, _ 		      0, T 		      0);        VMS_ITEMLIST_INIT(items)  )     if (current_device->virtual_terminal)m     {e*         status = SYS$GETDVIW(PPPD_EFN, 0, 4 			     &current_device->edited_virtual_device_name,3 			     &itemlistTerminal_Info, &iosbTerminal_Info,a 			     NULL, 0, NULL); $ 	CHECK_AND_REPORT_CONTEXT_AND_STATUS8 	  ("bind_asn_device (status)", PPPD$_ASNSETUP, status);$ 	CHECK_AND_REPORT_CONTEXT_AND_STATUSB 	  ("bind_asn_device (iosbTerminal_Info.status)", PPPD$_ASNSETUP,  	   iosbTerminal_Info.status);  8 	/* If the line is set to modem then the remote bit must< 	   be set or we should not switch the line.              */  0 	if ((ulTerminal_Info_Buffer & TT$M_MODEM) != 0)3 	  if ((ulTerminal_Info_Buffer & TT$M_REMOTE) == 0)  	    {G 	      REPORT_CONTEXT_AND_STATUS("bind_asn_device(PPPD$MODEMNOREMOTE)",RF 	                                PPPD$_ASNSETUP, PPPD$_MODEMNOREMOTE); 	      return FALSE; 	    }$         VMS_ITEMLIST_ADDR(ASN$_BIND,N                           8,                       /* desc. length and addr */N                           (char *)&current_device->edited_virtual_device_name,                           0)     }d     else     {c*         status = SYS$GETDVIW(PPPD_EFN, 0, , 			     &current_device->edited_device_name,3 			     &itemlistTerminal_Info, &iosbTerminal_Info,e 			     NULL, 0, NULL);E$ 	CHECK_AND_REPORT_CONTEXT_AND_STATUS8 	  ("bind_asn_device (status)", PPPD$_ASNSETUP, status);$ 	CHECK_AND_REPORT_CONTEXT_AND_STATUSB 	  ("bind_asn_device (iosbTerminal_Info.status)", PPPD$_ASNSETUP,  	   iosbTerminal_Info.status);  8 	/* If the line is set to modem then the remote bit must< 	   be set or we should not switch the line.              */  2   	if ((ulTerminal_Info_Buffer & TT$M_MODEM) != 0)3 	  if ((ulTerminal_Info_Buffer & TT$M_REMOTE) == 0)S 	    {G 	      REPORT_CONTEXT_AND_STATUS("bind_asn_device(PPPD$MODEMNOREMOTE)",RF 	                                PPPD$_ASNSETUP, PPPD$_MODEMNOREMOTE); 	      return FALSE; 	    }  $         VMS_ITEMLIST_ADDR(ASN$_BIND,N                           8,                       /* desc. length and addr */F                           (char *)&current_device->edited_device_name,                           0)     }l  >     status = sys$qiow(PPPD_EFN,                      /* EFN */?                       current_device->asn_channel,   /* chan */T?                       IO$_SETMODE,                   /* func */S?                       &iosb,                         /* iosb */ A                       0,                             /* astadr */ A                       0,                             /* astprm */ =                       &items,                        /* p1 */l=                       sizeof(items),                 /* p2 */SB                       0, 0, 0, 0);                   /* p3 - p6 */  '     CHECK_AND_REPORT_CONTEXT_AND_STATUSR=         ("bind_asn_device (status)", PPPD$_ASNSETUP, status);_'     CHECK_AND_REPORT_CONTEXT_AND_STATUSSG         ("bind_asn_device (iosb.status)", PPPD$_ASNSETUP, iosb.status);        return TRUE; }T * /* ** Function Name ** **    call_kernel_routinea ** ** Functional Descriptionm **E **    This routine does the necessary processing to call a routine innI **    kernel mode. This includes locking down the pages and changing mode  **    to kernel. ** ** Environment ** **    User mode; **	 ** Inputsn **9 **    kernel_routine - pointer to the kernel mode routineeG **    current_device - pointer to the current device in the device listR **
 ** Outputs **
 **    None **
 ** Returns ** **    TRUE if successful= **    FALSE if not successful (as a result of *STATUS macros)t ** */S PROC_STATIC int call_kernel_routine(KERNEL_RETURN_STATUS_TYPE *(*kernel_routine)(),I?                                     DEVICE_REC *current_device)l {_ VMS_STATUS status; PRIV prev_priv; 
 PRIV mask; u_int arglst[4];) KERNEL_RETURN_STATUS_TYPE *kernel_status;M  <     /* Lock down the pages before changing to kernel mode */     STORE_DEBUG_LOCATION(2,1);!     kernel_status = lock_pages();s4     STORE_DEBUG_LONGWORD(2,2,kernel_status->status);R     CHECK_AND_REPORT_CONTEXT_AND_STATUS("call_kernel_routine (lock_pages status)",S                                          PPPD$_NOPPPACCESS, kernel_status->status);g  %     /* Set the privilege to CMKRNL */      STORE_DEBUG_LOCATION(2,3);5     SET_PRIV(mask.prv$v_cmkrnl,mask,prev_priv,status)e  %     STORE_DEBUG_LONGWORD(2,4,status);S     if FAILURE(status)     {C"         STORE_DEBUG_LOCATION(2,5);!         REPORT_CONTEXT_AND_STATUSm5             ("call_kernel_routine (SET_PRIV status)",I)               PPPD$_NOPPPACCESS, status);v         unlock_pages();t         return FALSE;C     }n       STORE_DEBUG_LOCATION(2,6);?     arglst[0] = 3;                         /* Argument count */tN     arglst[1] = (u_int)current_device;     /* address of the current device */?     arglst[2] = (u_int)&mask;              /* privilege mask */II     arglst[3] = (u_int)&prev_priv;         /* previous priv to restore */C       STORE_DEBUG_LOCATION(2,7);S     kernel_status = (KERNEL_RETURN_STATUS_TYPE *)sys$cmkrnl(kernel_routine,arglst);C4     STORE_DEBUG_LONGWORD(2,8,kernel_status->status);%     if FAILURE(kernel_status->status)_     {T"         STORE_DEBUG_LOCATION(2,9);!         REPORT_CONTEXT_AND_STATUSy$             (kernel_status->context,<              kernel_status->context, kernel_status->status);         unlock_pages();*         return FALSE;d     }        STORE_DEBUG_LOCATION(2,10);r     unlock_pages();e     STORE_DEBUG_LOCATION(2,11);        return TRUE; }p l /* ** Function Name **" **    check_port_and_line_settings ** ** Functional Descriptiona **K **    This routine checks for certain illegal combinations of hardware flowt= **    control, serial device settings and type of connection.u ** ** Environment ** **    User model **	 ** Inputst **O **    current_device - ptr to the current device information in the device listu **
 ** Outputs **O **    current_device - ptr to the current device information in the device listt **
 ** Returns ** **    TRUE if successful **    FALSE if not successful    ** */H PROC_STATIC int check_port_and_line_settings(DEVICE_REC *current_device) {  VMS_STATUS      status;S DEV_CHAR        device_chars;,& int             hardware_flow_control; int             line_type; int             permanent_line;_ int             commsync_on; int             modem_on;t unsigned int    i;  /     /* Get the hardware flow control setting */(A     if (!lookup_asn_item(current_device->asn_items,ASN$_FLOW,&i)),     {%'         REPORT_CONTEXT_AND_STATUS_1_1P2s>             ("check_port_and_line_settings (lookup_asn_item)",               PPPD$_PORTSETUP,               PPPD$_INVASNCODE, *              &current_device->device_name,               ASN$_FLOW);t         return FALSE;(     }p"     hardware_flow_control       = I         ((int)current_device->asn_items[i].itm$l_bufadr & ASN$M_HW) != 0;R  #     /* Get the line type setting */gW     if (!extract_ppp_int_item(current_device->ppp_items, PPPD$K_LINE_TYPE, &line_type))_     {t'         REPORT_CONTEXT_AND_STATUS_1_1P2 C             ("check_port_and_line_settings (extract_ppp_int_item)",d               PPPD$_PORTSETUP,               PPPD$_INVPPPCODE,t*              &current_device->device_name,                PPPD$K_LINE_TYPE);         return FALSE;i     }t:     permanent_line      = (line_type == PPPD$K_PERMANENT);  *     /* Get the terminal characteristics */;     device_chars        = current_device->old_device_chars; K     commsync_on         = (device_chars.tt2_chars   & TT2$M_COMMSYNC) != 0;aK     modem_on            = (device_chars.basic_chars & TT$M_MODEM)     != 0;*  @     /* Rule 1:  Cannot have a permanent line on a port set to */@     /*          /MODEM or /COMMSYNC                           */4     if (permanent_line && (modem_on || commsync_on))     { %         REPORT_CONTEXT_AND_STATUS_1_0l=             ("check_port_and_line_settings (perm line test)",n               PPPD$_PORTSETUP,                PPPD$_INVPERMFLOW,+              &current_device->device_name);s         return FALSE;s     }   A     /* Rule 2:  Hardware flow control cannot be used on a port */ A     /*          that has neither /MODEM nor /COMMSYNC set      */_=     if (hardware_flow_control && (!modem_on && !commsync_on))l     {R%         REPORT_CONTEXT_AND_STATUS_1_0 A             ("check_port_and_line_settings (hardward flow test)",                PPPD$_PORTSETUP,                PPPD$_INVFLOWCTRL,+              &current_device->device_name);          return FALSE;      }        return TRUE; }    /* ** Function Name ** **    create_ppp_itemlistC ** ** Functional Description_ **Q **    This routine will allocate memory for a PPP device itemlist, and initialize  **    the itemlist header. ** ** Environment ** **    User mode  **	 ** Inputse **
 **    None **
 ** Outputs **
 **    None **
 ** Returns **B **    items - pointer to the newly created PPP device item list or= **            NULL if an error in memory allocation occurred.) */7 PROC_STATIC NETWORK_ITEMLIST *create_ppp_itemlist(void)T {; NETWORK_ITEMLIST *items; u_int size;         size = PPPD$K_ITEMLIST_SIZE;  8     /* Allocate the PPP item list to its maximum size */-     items = (NETWORK_ITEMLIST *)malloc(size);      if (items == NULL)         return items;   1     /* Initialize the network item list header */   F     items->item_length  = 0; /* Length does not include this header */2     items->item_address = &items->item_entries[0];     items->item_size    = size;('     items->item_type    = DYN$C_DECNET;T)     items->item_subtype = DYN$C_NET_ITEM;        return items;; }M T /* ** Function Name ** **    disable_installed_priv ** ** Functional Description_ **< **    This routine is called to disable installed privileges ** ** Environment ** **    User modei **	 ** InputsM **
 **    None **
 ** Outputs **
 **    None **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  ** */  int disable_installed_priv(void) {l VMS_STATUS status; u_int imagpriv[2]; u_int procpriv[2]; u_int mask[2]; VMS_ITEMLIST items[2];
 IOSB iosb;       VMS_ITEMLIST_INIT(items)D     VMS_ITEMLIST_ADDR(JPI$_IMAGPRIV, sizeof(imagpriv), &imagpriv, 0)D     VMS_ITEMLIST_ADDR(JPI$_PROCPRIV, sizeof(procpriv), &procpriv, 0)     VMS_ITEMLIST_TERM   1     status = sys$getjpiw(PPPD_EFN,      /* efn */T4                          0,             /* pidadr */4                          0,             /* prcnam */7                          &items,        /* item list */P2                          &iosb,         /* IOSB */6                          0,             /* AST addr */7                          0);            /* AST param */(  '     CHECK_AND_REPORT_CONTEXT_AND_STATUS M         ("disable_installed_priv ($getjpiw status)", PPPD$_PROGINIT, status);T'     CHECK_AND_REPORT_CONTEXT_AND_STATUSMW         ("disable_installed_priv ($getjpiw iosb.status)", PPPD$_PROGINIT, iosb.status);   E     /* Leave on only those privileges that the user originally had */ 9     mask[0] = imagpriv[0] & (!procpriv[0] & imagpriv[0]);d9     mask[1] = imagpriv[1] & (!procpriv[1] & imagpriv[1]);-  <     status = sys$setprv(DISABLE_PRIVS,          /* enbflg */=                         mask,                   /* prvaddr */ <                         PRIV_PRMPRV,            /* prmflg */<                         0);                     /* prvprv */  '     CHECK_AND_REPORT_CONTEXT_AND_STATUS E         ("disable_installed_priv ($setprv)", PPPD$_PROGINIT, status);R       return TRUE;   }( n /* ** Function Name ** **    dump_asn_itemlistS ** ** Functional Descriptiont **F **    This routine prints out the asn itemlist for debugging purposes. **? **    NOTE: This routine assumes the data size will not change.m ** ** Environment ** **    User modei **	 ** InputsI **F **    header_str- call specific string to print out in the dump headerF **    items     - ptr to the asn itemlist (terminated with null entry) **
 ** Outputs **
 **    none **
 ** Returns ** **    None.  ** */ #ifdef DEBUG_CODEA9 void dump_asn_itemlist(char *header, VMS_ITEMLIST *items)  {  VMS_ITEMLIST *itemlist;d       /* Init the routine */:     printf ("%s:  asn itemlist dump follows\n\n", header);     itemlist = items;l        /* Print out the itemlist */J     while ((itemlist->itm$w_bufsiz != 0) && (itemlist->itm$w_itmcod != 0))     { i         printf ("    buffer size, code, buffer addr (hex) & return length addr (hex) = %4d%4d %8X %8X\n",,@                  itemlist->itm$w_bufsiz, itemlist->itm$w_itmcod,A                  itemlist->itm$l_bufadr, itemlist->itm$l_retlen);          itemlist++;      }s       printf("\n");      return;e }  #endif   /* ** Function Name ** **    dump_ppp_itemlisti ** ** Functional DescriptionS **F **    This routine prints out the ppp itemlist for debugging purposes. **? **    NOTE: This routine assumes the data size will not change.u ** ** Environment ** **    User mode_ **	 ** InputsE **F **    header_str- call specific string to print out in the dump header) **    items     - ptr to the ppp itemlist* **
 ** Outputs **
 **    none **
 ** Returns ** **    None.o ** */ #ifdef DEBUG_CODE = void dump_ppp_itemlist(char *header, NETWORK_ITEMLIST *items)n {*% NETWORK_ITEM_INT_ENTRY *current_item;d' char    temp_string[PPPD$K_MAX_NAME+1];o int     temp_int[10];n       /* Init the routine */:     printf ("%s:  ppp itemlist dump follows\n\n", header);(     temp_string[PPPD$K_MAX_NAME] = '\0';  /     /* Look up the itemcode in the item list */*'     current_item = items->item_address;r       do     {E;         if (current_item->item_length == 0) /* Null item */ 	         {r(             printf ("    Empty list\n");	         }NC         else if (current_item->item_length == 8) /* Integer item */ 	         { 9             memcpy(&temp_int[0],&current_item->item_data,pE                     current_item->item_length-NETWORK_ITEM_HDR_SIZE);r;             printf ("    tag, length, item = %4d%4d %8X\n", G                      current_item->item_tag, current_item->item_length,p"                      temp_int[0]);	         }tJ         else if (current_item->item_length == 36) /* Transmit ACCM item */	         {s9             memcpy(&temp_int[0],&current_item->item_data,NE                     current_item->item_length-NETWORK_ITEM_HDR_SIZE);R;             printf ("    tag, length, item = %4d%4d %8X\n",$G                      current_item->item_tag, current_item->item_length,S"                      temp_int[0]);K             printf ("                                 %8X\n", temp_int[1]); K             printf ("                                 %8X\n", temp_int[2]);SK             printf ("                                 %8X\n", temp_int[3]); K             printf ("                                 %8X\n", temp_int[4]);uK             printf ("                                 %8X\n", temp_int[5]);cK             printf ("                                 %8X\n", temp_int[6]);kK             printf ("                                 %8X\n", temp_int[7]);*	         }T         else /* String item */	         { 8             memcpy(temp_string,&current_item->item_data,E                     current_item->item_length-NETWORK_ITEM_HDR_SIZE);F<             printf ("    tag, length, item = %4d%4d >%s<\n",G                      current_item->item_tag, current_item->item_length,t"                      temp_string);	         }x  H         current_item = (NETWORK_ITEM_INT_ENTRY *)((char *)current_item +M                                                   current_item->item_length);E     } while (current_item <eZ             (NETWORK_ITEM_INT_ENTRY *)((char *)items->item_address + items->item_length));       printf("\n");      return;s }u #endif   /* ** Function Name ** **    edit_device_name ** ** Functional Descriptions **G **    This routine will take a physical device name, and copy it to the*E **    destination descriptor without any leading '_' or trailing ':'.rE **    Certain routines require the device name to be only in the formp **    xxxnnnn. ** ** Environment ** **    User mode  **	 ** Inputs  **> **    input  - dynamic descriptor with the device name to edit **
 ** Outputs **L **    output - dynamic descriptor where the device name will be copied after **             editing **
 ** Returns **= **    True/False depending on the status of STR$POS_EXTR call; ** */K PROC_STATIC int edit_device_name(D_DESCRIPTOR *input, D_DESCRIPTOR *output)e {n VMS_STATUS status;  int start_pos, beg_pos, end_pos;       start_pos   = 1;I     beg_pos     = str$position (input, &underscore_desc, &start_pos) + 1; B     end_pos     = str$position (input, &colon_desc, &beg_pos) - 1;F     end_pos     = (end_pos == -1 ? input->dsc$w_length - (beg_pos - 1),                                  : end_pos);C     status      = str$pos_extr (output, input, &beg_pos, &end_pos);n  +     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0 H         ("edit_device_name ($setprv)", PPPD$_EDITDEVICE, status, input);       return TRUE; }e n /* ** Function Name ** **    exit_handler ** ** Functional DescriptionP **6 **    This routine does the necessary exit processing. ** **    Currently this includes: **1 **	1. Deassigning the physical and asynch devices  ** **	2. Freeing the device list  ** ** Environment ** **    User mode  **	 ** Inputse ** **    ImplicitN **        current_device->device_channel - the current physical device channelB **        current_device->asn_channel - the current asynch channelL **        device_list - the list of device settings for each physical device) **                      specified to date. **
 ** Outputs **
 **    None **
 ** Returns ** **    VMS condition valuea */ VMS_STATUS exit_handler(void)  {  VMS_STATUS status; DEVICE_REC *next_device; SENSE_IOSB set_iosb; DEV_CHAR device_chars; u_short speed;  !     current_device = device_list;n"     while (current_device != NULL)     { +         next_device = current_device->next;   >         FREE_DYNAMIC_DESCRIPTOR(&current_device->device_name);E         FREE_DYNAMIC_DESCRIPTOR(&current_device->edited_device_name); F         FREE_DYNAMIC_DESCRIPTOR(&current_device->virtual_device_name);M         FREE_DYNAMIC_DESCRIPTOR(&current_device->edited_virtual_device_name);            /** free PPP items */S=         FREE_DYNAMIC_DESCRIPTOR(&current_device->trace_file);&<         FREE_DYNAMIC_DESCRIPTOR(&current_device->trace_mbx);(         free(current_device->ppp_items);           /* free ASN items */;         FREE_DYNAMIC_DESCRIPTOR(&current_device->asn_name);,B         FREE_DYNAMIC_DESCRIPTOR(&current_device->edited_asn_name);  '         /* free the network protocol */ C         FREE_DYNAMIC_DESCRIPTOR(&current_device->network_protocol);e  4         /* restore the device settings if changed */0         if (current_device->device_channel != 0)	         {t4             sys$dassgn(current_device->asn_channel);/             if (current_device->restore_device) 
             { ;                 sys$cancel(current_device->device_channel);P@                 device_chars = current_device->old_device_chars;:                 speed = current_device->old_output_speed |>                        (current_device->old_input_speed << 8);     D                 sys$qiow(PPPD_EFN,                         /* EFN */E                          current_device->device_channel,   /* chan */ E                          IO$_SETMODE,                      /* func */eE                          &set_iosb,                        /* iosb */eG                          0,                                /* astadr */iG                          0,                                /* astprm */_C                          &device_chars,                    /* p1 */eC                          sizeof(device_chars),             /* p2 */ K                          speed,                            /* p3 - speed */nH                          0, 0, 0);                         /* p4 - p6 */
             }o7             sys$dassgn(current_device->device_channel);*	         }   6         /* restore the terminal settings if changed */2         if (current_device->terminal_channel != 0)	         {r1             if (current_device->restore_terminal)M
             { B                 device_chars = current_device->old_terminal_chars;     =                 sys$cancel(current_device->terminal_channel);PD                 sys$qiow(PPPD_EFN,                         /* EFN */E                          current_device->terminal_channel, /* chan */ E                          IO$_SETMODE,                      /* func */ E                          &set_iosb,                        /* iosb */*G                          0,                                /* astadr */ G                          0,                                /* astprm */ C                          &device_chars,                    /* p1 */ C                          sizeof(device_chars),             /* p2 */uK                          0,                                /* p3 - speed */rH                          0, 0, 0);                         /* p4 - p6 */
             }p9             sys$dassgn(current_device->terminal_channel);m	         }            free(current_device);   %         current_device = next_device;      }v       return SS$_CONTINUE; }r I /* ** Function Name ** **    extract_ppp_int_item ** ** Functional Description* **N **    This routine copies the desired data field of a particular PPP attribute= **    into the caller's buffer as is (assuming integer data).C **? **    NOTE: This routine assumes the data size will not change.s ** ** Environment ** **    User mode  **	 ** Inputs  **) **    items     - ptr to the ppp itemlistn **    tag       - item code tagc **
 ** Outputs **, **    data      - ptr to the caller's buffer **
 ** Returns ** **    TRUE if successful **    FALSE if not successfulo ** */H int extract_ppp_int_item(NETWORK_ITEMLIST *items, u_int tag, void *data) {r% NETWORK_ITEM_INT_ENTRY *current_item;   /     /* Look up the itemcode in the item list */n'     current_item = items->item_address;*   #ifdef DEBUG_CODE      if (ppp_itemlist_dump):         dump_ppp_itemlist ("Extract_ppp_int_item", items);     if (ppp_itemlist_trace)S`         printf ("Extract_ppp_int_item:  current_item, tag = %d, %d\n", (long)current_item, tag); #endif       do     {e*         if (current_item->item_tag == tag)	         {i;             /* copy the data field to the caller's buffer*/l1             memcpy(data,&current_item->item_data, D                    current_item->item_length-NETWORK_ITEM_HDR_SIZE);             return TRUE;	         }i #ifdef DEBUG_CODEi         if (ppp_itemlist_trace) p             printf ("Extract_ppp_int_item:  current_item->item_length = %d\n", (long)current_item->item_length); #endifH         current_item = (NETWORK_ITEM_INT_ENTRY *)((char *)current_item +I                                               current_item->item_length);t #ifdef DEBUG_CODEg     if (ppp_itemlist_trace)hR         printf ("Extract_ppp_int_item:  current_item = %d\n", (long)current_item); #endif     } while (current_item <eZ             (NETWORK_ITEM_INT_ENTRY *)((char *)items->item_address + items->item_length));   #ifdef DEBUG_CODE*     if (ppp_itemlist_dump):         dump_ppp_itemlist ("Extract_ppp_int_item", items); #endif       return FALSE;h }e N /* ** Function Name ** **    extract_ppp_string_itemr ** ** Functional Description[ **N **    This routine copies the desired data field of a particular PPP attributeM **    into the caller's buffer, and appending a '\0' at the end, assuming theN **    data is a string.o **? **    NOTE: This routine assumes the data size will not change.m ** ** Environment ** **    User mode( **	 ** Inputst **) **    items     - ptr to the ppp itemlist  **    tag       - item code tag\ **
 ** Outputs **, **    data      - ptr to the caller's buffer **
 ** Returns ** **    TRUE if successful **    FALSE if not successfule ** */K int extract_ppp_string_item(NETWORK_ITEMLIST *items, u_int tag, char *data)r { % NETWORK_ITEM_INT_ENTRY *current_item;m  /     /* Look up the itemcode in the item list */e'     current_item = items->item_address;    #ifdef DEBUG_CODEt     if (ppp_itemlist_dump)=         dump_ppp_itemlist ("Extract_ppp_string_item", items);M     if (ppp_itemlist_trace) d         printf ("Extract_ppp_string_items:  current_item, tag = %d, %d\n", (long)current_item, tag); #endif       do     { *         if (current_item->item_tag == tag)	         {$;             /* copy the data field to the caller's buffer*/i1             memcpy(data,&current_item->item_data, D                    current_item->item_length-NETWORK_ITEM_HDR_SIZE);d             data[current_item->item_length-NETWORK_ITEM_HDR_SIZE] = '\0'; /* End of string marker */             return TRUE;	         }8 #ifdef DEBUG_CODE          if (ppp_itemlist_trace) t             printf ("Extract_ppp_string_items:  current_item->item_length = %d\n", (long)current_item->item_length); #endifH         current_item = (NETWORK_ITEM_INT_ENTRY *)((char *)current_item +M                                                   current_item->item_length);  #ifdef DEBUG_CODE      if (ppp_itemlist_trace) V         printf ("Extract_ppp_string_items:  current_item = %d\n", (long)current_item); #endif     } while (current_item <RZ             (NETWORK_ITEM_INT_ENTRY *)((char *)items->item_address + items->item_length));   #ifdef DEBUG_CODEa     if (ppp_itemlist_dump)=         dump_ppp_itemlist ("Extract_ppp_string_item", items);u #endif       return FALSE;T }T * /* ** Function Name ** **    find_device_type ** ** Functional Descriptionn **> **    This routine will test the device type (_xx) against the% **    specified list of device types.> ** ** Environment ** **    User mode  **	 ** Inputs  **. **    device_list       - list of device types7 **    name              - ptr to the name of the deviceo **
 ** Outputs **
 **    None **
 ** Returns **& **    TRUE if the device type is found< **    FALSE if not successful or the device is not supported ** */N PROC_STATIC int find_device_type (DESCRIPTOR *device_list, D_DESCRIPTOR *name) { E D_DESCRIPTOR device_type;  /* _dd part of the physical device name */- VMS_STATUS status; int start_position = 1;d int num_chars,     substring_index;  :     INIT_DYNAMIC_DESCRIPTOR(device_type, max_buffer_size);     num_chars = 3;.     str$left (&device_type, name, &num_chars);;     str$find_first_substring (device_list, &start_position, =                              &substring_index, &device_type);e*     FREE_DYNAMIC_DESCRIPTOR(&device_type);=     return ((start_position != 0) || (substring_index != 0));o }i ( /* ** Function Name ** **    get_asn_name ** ** Functional Descriptionn **- **    This routine get the asnych device name  ** ** Environment ** **    User modee **	 ** Inputs  **& **    asn_channel - the asynch channel **
 ** Outputs **. **    asn_name - ptr to the asynch device name **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  ** */F PROC_STATIC int get_asn_name(CHAN asn_channel, D_DESCRIPTOR *asn_name) {t VMS_ITEMLIST items[2]; VMS_STATUS status;
 IOSB iosb;  0     status = str$get1_dx(&ppp_str_len,asn_name);'     CHECK_AND_REPORT_CONTEXT_AND_STATUSsF         ("get_asn_name (str$get1_dx status)", PPPD$_ASNSETUP, status);       VMS_ITEMLIST_INIT(items)F     VMS_ITEMLIST_ADDR(DVI$_DEVNAM,ppp_str_len,asn_name->dsc$a_pointer,.                       &asn_name->dsc$w_length)     VMS_ITEMLIST_TERMe  7     status = sys$getdviw(PPPD_EFN,            /* EFN */u8                          asn_channel,         /* chan */;                          0,                   /* devname */ =                          &items,              /* item list */R8                          &iosb,               /* IOSB */<                          0,                   /* AST addr */=                          0,                   /* AST param */e;                          0);                  /* nullarg */d  '     CHECK_AND_REPORT_CONTEXT_AND_STATUS F         ("get_asn_name (sys$getdviw status)", PPPD$_ASNSETUP, status);'     CHECK_AND_REPORT_CONTEXT_AND_STATUSDP         ("get_asn_name (sys$getdviw iosb.status)", PPPD$_ASNSETUP, iosb.status);       return TRUE; }l v /* ** Function Name **# **    get_asn_name_from_device_namei ** ** Functional Description  **J **    This routine finds the ASNn device name associated with the physical **    device name passed to it.C ** ** Environment ** **    User mode  **	 ** Inputsr **K **    device_name - ptr to the physical device name as a dynamic descriptorS **
 ** Outputs **G **    asn_name - ptr to the asynch. device name as a dynamic descriptor_ **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  */- PROC_STATIC int get_asn_name_from_device_name B                (D_DESCRIPTOR *device_name, D_DESCRIPTOR *asn_name) {_ VMS_ITEMLIST items[2]; D_DESCRIPTOR asn_name_template;$ D_DESCRIPTOR temp_asn_name;a D_DESCRIPTOR temp_device_name;
 IOSB iosb; VMS_STATUS status; int64 search_context = 0;y  *     /* Set up various descriptors, etc. */?     INIT_DYNAMIC_DESCRIPTOR(asn_name_template,max_buffer_size); 6     SET_DYNAMIC_DESCRIPTOR(asn_name_template,"*ASN*");  :     INIT_DYNAMIC_DESCRIPTOR(temp_asn_name,max_buffer_size)=     INIT_DYNAMIC_DESCRIPTOR(temp_device_name,max_buffer_size)   L     /* For each ASNn device found, is it associated with the device_name? */=     while (SUCCESS (status = sys$device_scan (&temp_asn_name, J                                               &temp_asn_name.dsc$w_length,A                                               &asn_name_template, 1                                               0L, @                                               &search_context)))     {c=         /* Set up the itemlist for the current ASNn device */zC         RESET_DYNAMIC_DESCRIPTOR(temp_device_name,max_buffer_size);e            VMS_ITEMLIST_INIT(items)<         VMS_ITEMLIST_ADDR(DVI$_TT_PHYDEVNAM,max_buffer_size,9                           temp_device_name.dsc$a_pointer,a9                           &temp_device_name.dsc$w_length)          VMS_ITEMLIST_TERMe  L         /* Get any physical device name associated with this ASNn: device */;         status = sys$getdviw(PPPD_EFN,            /* EFN */ <                              0,                   /* chan */?                              &temp_asn_name,      /* devname */-A                              &items,              /* item list */ <                              &iosb,               /* IOSB */@                              0,                   /* AST addr */A                              0,                   /* AST param */e?                              0);                  /* nullarg */   /         CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0 B             ("get_asn_name_from_device_name (sys$getdviw status)",4               PPPD$_PORTSETUP, status, device_name);/         CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0zG             ("get_asn_name_from_device_name (sys$getdviw iosb.status)", 9               PPPD$_PORTSETUP, iosb.status, device_name);   M         /* If we have a match, then copy the ASNn: device name, and return */ G         if (str$case_blind_compare(device_name,&temp_device_name) == 0) 	         {e:             status = str$copy_dx(asn_name,&temp_asn_name);3             CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0oQ                 ("get_asn_name_from_device_name (str$case_blind_compare status)",h8                   PPPD$_PORTSETUP, status, device_name);             return TRUE;	         }   6         /* Prepare for getting the next ASNn device */@         RESET_DYNAMIC_DESCRIPTOR(temp_asn_name,max_buffer_size);     }*  J     /* Test for various error conditions, and handle them appropriately */       if (SUCCESS (status))c     {c         return TRUE;     }aD     else if ((status == SS$_NOMOREDEV) || (status == SS$_NOSUCHDEV))     {sD         return FALSE;   /* Failed to find an ASNn: device for the */D     }                   /* passed in device name                  */     else     {t/         CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0iF             ("get_asn_name_from_device_name (sys$device_scan status)",4               PPPD$_PORTSETUP, status, device_name);         return FALSE;,     }; }  f /* ** Function Name ** **    get_clear_counters ** ** Functional Description  **J **    This routine gets the user setting for the /CLEAR_COUNTERS qualifierH **    on the SET command. It then updates the value in the ASN itemlist. ** ** Environment ** **    User modee **	 ** Inputse ** **     Nonea **
 ** Outputs **/ **    items - pointer to the ASN item list itemE **
 ** Returns ** **    TRUE if successful **    FALSE if not successful_ ** */7 PROC_STATIC int get_clear_counters(VMS_ITEMLIST *items)r {_ VMS_STATUS status; D_DESCRIPTOR str;t COUNTER_MASK mask; int i;  #     /* Get the counter item mask */I.     get_counter_items(&clear_counters, &mask);       /* Update the ASN mask */ 9     if (!update_asn_item(items,ASN$_RESET_COUNTERS,mask))p         return FALSE;        return TRUE; }p t /* ** Function Name ** **    get_counter_items  ** ** Functional Descriptione **G **    This routine gets the user setting for the /*_COUNTERS qualifierse! **    on the SET or SHOW command.C ** ** Environment **L **    User mode, assumes the cli$present(qualifier) has been called previous9 **    to calling this routine, and that qualifier exists.  **	 ** Inputst ** **     None* **
 ** Outputs **/ **    items - pointer to the ASN item list itema **
 ** Returns ** **    TRUE if successful **    FALSE if not successfulp ** */L PROC_STATIC int get_counter_items(DESCRIPTOR *qualifier, COUNTER_MASK *mask) {r VMS_STATUS status; D_DESCRIPTOR str;h COUNTER_MASK temp_mask = 0;* int i;       /* Initialization */1     INIT_DYNAMIC_DESCRIPTOR(str,max_buffer_size);   I     /* Fill in the mask while there are keywords to process.  At least */eI     /* one keyword will be found since ALL is the default.             */      do     {u1         status = cli$get_value (qualifier, &str);Ml         for (i = 0; strncmp (str.dsc$a_pointer, counter_keyword_table[i].text, str.dsc$w_length) != 0; i++);>         temp_mask = temp_mask | counter_keyword_table[i].mask;I         str.dsc$w_length = MAX_BUFFER_SIZE; /* Reinit the desc. length */s@     } while ((status != CLI$_ABSENT) && (status != SS$_NORMAL));"     FREE_DYNAMIC_DESCRIPTOR(&str);  )     /* Set the counter mask and return */o     *mask       = temp_mask;       return TRUE; }    /* ** Function Name ** **    get_device_info  ** ** Functional Descriptiond **D **    This routine establishes this device as the current device andG **    either creates and initializes a new device in the device list or;H **    points to the information already specified for this device in the **    device list. ** ** Environment ** **    User mode  **	 ** InputsB **K **    device_name          - ptr to the device name as a dynamic descriptornT **    device_physical_name - ptr to the physical device name as a dynamic descriptor ** **    Implicit1 **        device_list - list of device attributesm **
 ** Outputs **G **    line_inited          - was this line data structure just created?B ** **    ImplicitK **        current_device - pointer to the current device in the device list= **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  */p PROC_STATIC int get_device_info(D_DESCRIPTOR *device_name, D_DESCRIPTOR *physical_device_name, int *line_inited) {i) DEVICE_REC *new_device, *previous_device;c VMS_STATUS status;
 CHAN channel;f SENSE_IOSB iosb; unsigned long ulP1[8]; int iSizeofP1 = 8; int line_active; unsigned long ulstatus;i VMS_ITEMLIST item[2];r) unsigned long ulTerminal_Info_Buffer = 0;n    J     /* See if the device specified by the user has already been set up. */J     /* If so, set the current device to this device record.  Otherwise  */J     /* create and initialize a new device record.                       */&     current_device      = device_list;     previous_device     = NULL;d     while (TRUE)     {e#         if (current_device == NULL) (             break;  /* At end-of-list */  "         if (str$case_blind_compareI                 (physical_device_name,&current_device->device_name) == 0)a&             break;  /* Found record */  )         previous_device = current_device;n/         current_device  = current_device->next;m     };  A     /* If the caller requests it, return the state of the line */c     if (line_inited != NULL)3         *line_inited    = (current_device == NULL);   4     /* If we have found the device record, return */     if (current_device != NULL)e         return TRUE;  <     /* Device is not in device list so add it to the list */:     new_device = (DEVICE_REC *)malloc(sizeof(DEVICE_REC));  D     /* Is the user specified device name the same as the physical */D     /* device name?                                               */1     new_device->user_device_is_physical_device  =aI         (str$case_blind_compare (physical_device_name,device_name) == 0);s        /* Physical device fields */B     INIT_DYNAMIC_DESCRIPTOR(new_device->device_name, ppp_str_len);?     INIT_DYNAMIC_DESCRIPTOR(new_device->edited_device_name, 0);BI     status = str$copy_dx(&new_device->device_name, physical_device_name);E     if (FAILURE(status))     { %         REPORT_CONTEXT_AND_STATUS_1_0P@             ("get_device_info (str$copy_dx device_name status)",=               PPPD$_PORTSETUP, status, physical_device_name); :         FREE_DYNAMIC_DESCRIPTOR(&new_device->device_name);         free(new_device);s         return FALSE;      }*#     new_device->device_channel = 0;n       /* Virtual device fields */ J     INIT_DYNAMIC_DESCRIPTOR(new_device->virtual_device_name, ppp_str_len);G     INIT_DYNAMIC_DESCRIPTOR(new_device->edited_virtual_device_name, 0);b*     new_device->virtual_terminal        = C         find_device_type (&virtual_terminal_dev_type, device_name); %     if (new_device->virtual_terminal)      { L         status = str$copy_dx(&new_device->virtual_device_name, device_name);         if (FAILURE(status))	         {e)             REPORT_CONTEXT_AND_STATUS_1_0tL                 ("get_device_info (str$copy_dx virtual_device_name status)",8                   PPPD$_PORTSETUP, status, device_name);>             FREE_DYNAMIC_DESCRIPTOR(&new_device->device_name);F             FREE_DYNAMIC_DESCRIPTOR(&new_device->virtual_device_name);             free(new_device);              return FALSE;l	         }i     }        /* PPP fields */&     new_device->trace = default_trace;6     INIT_DYNAMIC_DESCRIPTOR(new_device->trace_file,0);5     INIT_DYNAMIC_DESCRIPTOR(new_device->trace_mbx,0); 3     new_device->ppp_items = initialize_ppp_items();d&     if (new_device->ppp_items == NULL)     {R!         REPORT_CONTEXT_AND_STATUStX             ("get_device_info (initialize_ppp_items (create_ppp_itemlist NULL return))",/               PPPD$_PORTSETUP, LIB$_INSVIRMEM);M:         FREE_DYNAMIC_DESCRIPTOR(&new_device->device_name);B         FREE_DYNAMIC_DESCRIPTOR(&new_device->virtual_device_name);9         FREE_DYNAMIC_DESCRIPTOR(&new_device->trace_file);S8         FREE_DYNAMIC_DESCRIPTOR(&new_device->trace_mbx);         free(new_device);_         return FALSE;_     }_       /* ASN fields */4     INIT_DYNAMIC_DESCRIPTOR(new_device->asn_name,0);;     INIT_DYNAMIC_DESCRIPTOR(new_device->edited_asn_name,0);c      new_device->asn_channel = 0;4     initialize_asn_set_items(new_device->asn_items);        /* network callout fields */J     INIT_DYNAMIC_DESCRIPTOR(new_device->network_protocol,max_buffer_size);7     status = str$copy_dx(&new_device->network_protocol, 4                          &default_network_protocol);     if (FAILURE(status))     { %         REPORT_CONTEXT_AND_STATUS_1_0 E             ("get_device_info (str$copy_dx network_protocol status)", 4               PPPD$_PORTSETUP, status, device_name);:         FREE_DYNAMIC_DESCRIPTOR(&new_device->device_name);?         FREE_DYNAMIC_DESCRIPTOR(&new_device->network_protocol);V         free(new_device);s         return FALSE;      }   0     new_device->ppp_callback_registered = FALSE;/     new_device->network_callback        = NULL;      >     /* Get channel so that we can check device characteristics6        to initialize new_device data structure with */  6     if (!assign_channel(device_name, &channel, FALSE)) 	return FALSE;   /*  J    Check to see if there is an ASN device bound to the device, if there isH    just set the speed to DEFAULT speed, if there isn't then display the     actual line speed */-   line_active = get_asn_name_from_device_name 4 			(&new_device->device_name,&new_device->asn_name);    if (!line_active) { !    ulstatus = sys$qiow(PPPD_EFN, m 			channel,  			IO$_SENSEMODE,                  	&iosb,n 			0,0,  			ulP1,
 			iSizeofP1,O
 			0,0,0,0); S'     CHECK_AND_REPORT_CONTEXT_AND_STATUSoB         ("get_device_info (ulstatus)", PPPD$_TERMSETUP, ulstatus);'     CHECK_AND_REPORT_CONTEXT_AND_STATUS_H         ("get_device_info (iosb.status)", PPPD$_TERMSETUP, iosb.status);                                      /* line attributes */,(     new_device->restore_device  = FALSE;(     new_device->restore_terminal= FALSE;     if (iosb.rcv_speed != 0)1       new_device->input_speed   = iosb.rcv_speed;d     else2       new_device->input_speed   = iosb.xmit_speed;2     new_device->output_speed    = iosb.xmit_speed;  7     /*  Speed codes our offset by 1 in our table, so wea3 	need to subtract 1 to get the proper speed      */h%     new_device->output_show_speed  = a9       port_speed_list[new_device->output_speed-1].number; %     new_device->input_show_speed   =  8       port_speed_list[new_device->input_speed-1].number;  }   else {_,     new_device->input_speed = DEFAULT_SPEED;.     new_device->output_speed = DEFAULT_SPEED; $     new_device->output_show_speed = 7       port_speed_list[new_device->output_speed].number;_"     new_device->input_show_speed =7       port_speed_list[new_device->input_speed].number; n }     VMS_ITEMLIST_INIT(item)     H     /* Populate itemlistTerminal_Info to get terminal characteristics */&     VMS_ITEMLIST_ADDR(DVI$_TT_HANGUP, ' 		      sizeof(ulTerminal_Info_Buffer),o! 		      &ulTerminal_Info_Buffer, u 		      0);   B     VMS_ITEMLIST_ADDR(0,             /* Null terminate itemlist */ 		      0, f 		      0, t 		      0);     H     ulstatus = SYS$GETDVIW(PPPD_EFN, channel, 0, item, &iosb, 0, 0, 0); '     CHECK_AND_REPORT_CONTEXT_AND_STATUSO= 	  ("get_device_info (ulstatus)", PPPD$_TERMSETUP, ulstatus); '     CHECK_AND_REPORT_CONTEXT_AND_STATUSnC 	  ("get_device_info (iosb.status)", PPPD$_TERMSETUP, iosb.status);O  9     new_device->hangup          = ulTerminal_Info_Buffer;   $     ulstatus  = sys$dassgn(channel);E     CHECK_AND_REPORT_CONTEXT_AND_STATUS("get_device_info (ulstatus)",_ 	PPPD$_DEASSIGNCHAN, ulstatus);_  .     /* insert the device in the device list */     new_device->next = NULL;     if (device_list == NULL)     {_,        device_list             = new_device;     }t     else     { -         previous_device->next   = new_device;N     }s      current_device = new_device;       return TRUE; }    /* ** Function Name ** **    get_device_name* ** ** Functional Description* **F **    This routine gets the physical device name supplied by the user. ** ** Environment ** **    User mode* **	 ** Inputs* **
 **    None **
 ** Outputs **K **    device_name - ptr to the physical device name as a dynamic descriptordD **    tt_name     - ptr to the terminal name as a dynamic descriptor **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  */Q PROC_STATIC int get_device_name(D_DESCRIPTOR *device_name, D_DESCRIPTOR *tt_name)_ {n VMS_ITEMLIST items[5]; D_DESCRIPTOR user_device_name;
 IOSB iosb; VMS_STATUS status; int start_position = 1;m u_int correct_format;  u_int devclass;t u_int devchar2;D int   line_type;  3     /* Get the user value for the physical device*/ =     INIT_DYNAMIC_DESCRIPTOR(user_device_name,max_buffer_size)d?     if (!get_str_qualifier(&physical_device,&user_device_name))      { 3         FREE_DYNAMIC_DESCRIPTOR(&user_device_name);          return FALSE;m     }d       VMS_ITEMLIST_INIT(items)I     VMS_ITEMLIST_ADDR(DVI$_DEVNAM,ppp_str_len,device_name->dsc$a_pointer, 1                       &device_name->dsc$w_length)eK     VMS_ITEMLIST_ADDR(DVI$_TT_PHYDEVNAM,ppp_str_len,tt_name->dsc$a_pointer,!-                       &tt_name->dsc$w_length) A     VMS_ITEMLIST_ADDR(DVI$_DEVCLASS,sizeof(devclass),&devclass,0)eA     VMS_ITEMLIST_ADDR(DVI$_DEVCHAR2,sizeof(devchar2),&devchar2,0)      VMS_ITEMLIST_TERM*  7     status = sys$getdviw(PPPD_EFN,            /* EFN */*8                          0,                   /* chan */;                          &user_device_name,   /* devname */c=                          &items,              /* item list */d8                          &iosb,               /* IOSB */<                          0,                   /* AST addr */=                          0,                   /* AST param */d;                          0);                  /* nullarg */d       if (FAILURE(status))     { %         REPORT_CONTEXT_AND_STATUS_1_0s4             ("get_device_name (sys$getdviw status)",:               PPPD$_PORTSETUP, status, &user_device_name);3         FREE_DYNAMIC_DESCRIPTOR(&user_device_name);i         return FALSE;r     };     if (FAILURE(iosb.status))R     { %         REPORT_CONTEXT_AND_STATUS_1_0S9             ("get_device_name (sys$getdviw iosb.status)",_9               PPPD$_PORTSETUP, iosb.status, device_name);,3         FREE_DYNAMIC_DESCRIPTOR(&user_device_name);i         return FALSE;S     };  4     /* check that the device is a terminal device */     if (devclass != DC$_TERM)e     {;'         signal_error(PPPD$_TERMINAL,0);i         return FALSE;      }n  B     /* check that the device has remote terminal UCB extensions */     if (devchar2 & DEV$M_RTT)      {I%         signal_error(PPPD$_REMOTE,0);v         return FALSE;      }   5     /* device names need to be in the form of _xxx */      correct_format = FALSE;i       do     {lL         if (str$position(device_name,&underscore_desc,&start_position) == 1)"             correct_format = TRUE;         else5             if (!get_device_translation(device_name))                  return FALSE;eD     } while ((!correct_format) && (device_name->dsc$w_length != 0));       if (!correct_format)     {v%         signal_error(PPPD$_FORMAT,0);_         return FALSE;e     }m  1     /* tt names need to be in the form of _xxx */t     do     { H         if (str$position(tt_name,&underscore_desc,&start_position) == 1)"             correct_format = TRUE;         else1             if (!get_device_translation(tt_name))                  return FALSE; @     } while ((!correct_format) && (tt_name->dsc$w_length != 0));       if (!correct_format)     {i%         signal_error(PPPD$_FORMAT,0);r         return FALSE;t     }        return TRUE; }  d /* ** Function Name ** **    get_device_translation ** ** Functional Descriptionc **8 **    Get the translation for the logical name specified ** ** Environment ** **    User mode  **	 ** Inputs  **> **    lognam - ptr to the logical name descriptor to translate **
 ** Outputs **3 **    lognam - ptr to the equivalence name returneda **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  */< PROC_STATIC int get_device_translation(D_DESCRIPTOR *lognam) {S VMS_ITEMLIST items[2]; u_int attr = LNM$M_CASE_BLIND; char str[MAX_BUFFER_SIZE]; u_short len; VMS_STATUS status;      /* set up the item list */R     VMS_ITEMLIST_INIT(items):     VMS_ITEMLIST_ADDR(LNM$_STRING,MAX_BUFFER_SIZE,str,len)     VMS_ITEMLIST_TERM   @     status = sys$trnlnm(&attr,&process_tabnam,&lognam,0,&items);+     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0t6         ("get_device_translation (sys$trnlnm status)",+           PPPD$_PORTSETUP, status, lognam);)       if (len > ppp_str_len)     { &         signal_error(PPPD$_LOGNAME,0);         return FALSE;      }n  +     strncpy(lognam->dsc$a_pointer,str,len);      lognam->dsc$w_length = len;_       return(TRUE);a }e e /* ** Function Name ** **    get_device_UIC ** ** Functional DescriptionO **I **    This routine will retrieve the UIC associated with the given deviceu ** ** Environment ** **    User mode  **	 ** InputsU **9 **    device_name - name of the device for the UIC lookupn **
 ** Outputs **1 **    device_UIC - UIC associated with the devicec **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  ** */O PROC_STATIC int get_device_UIC(D_DESCRIPTOR device_name, UIC_VALUE *device_UIC); {  VMS_ITEMLIST items[2]; VMS_STATUS status;
 IOSB iosb;       VMS_ITEMLIST_INIT(items)B     VMS_ITEMLIST_ADDR(DVI$_OWNUIC,sizeof(UIC_VALUE),device_UIC,0L)     VMS_ITEMLIST_TERMi  7     status = sys$getdviw(PPPD_EFN,            /* EFN */S8                          0,                   /* chan */;                          &device_name,        /* devname */O=                          &items,              /* item list */w8                          &iosb,               /* IOSB */<                          0,                   /* AST addr */=                          0,                   /* AST param */(;                          0);                  /* nullarg */   +     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0 /         ("get_device_UIC (sys$getdviw status)",0/           PPPD$_PORTDISC, status, device_name);d+     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0 4         ("get_device_UIC (sys$getdviw iosb.status)",4           PPPD$_PORTDISC, iosb.status, device_name);       return TRUE; }e e /* ** Function Name ** **    get_fsc_size ** ** Functional Descriptionr **D **    This routine gets the user setting for the /FCS_SIZE qualifierK **    on the SET command. It then updates the values in the current device.  ** ** Environment ** **    User modep **	 ** Inputs" ** **     None  **
 ** Outputs **< **    receive_fcs  - pointer to the current receive fcs size= **    transmit_fcs - pointer to the current transmit fcs sizen **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  ** */: PROC_STATIC int get_fcs_sizes(NETWORK_ITEMLIST *ppp_items) {e VMS_STATUS status; D_DESCRIPTOR str1, str2;& int receive_setting, transmit_setting; int i;  @     /* Retrieve the fcs size setting(s).  The CLI definition  */@     /* will guarentee at least one value, and that all the    */@     /* text returned is numeric.                              */2     INIT_DYNAMIC_DESCRIPTOR(str1,max_buffer_size);2     INIT_DYNAMIC_DESCRIPTOR(str2,max_buffer_size);,     status = cli$get_value(&fcs_size,&str1);     if (status == CLI$_COMMA)v     {v)         strtoint(&receive_setting,&str1);i0         status = cli$get_value(&fcs_size,&str2);*         strtoint(&transmit_setting,&str2);= /*      if (status != SS$_NORMAL), warning?, list too long */0     }      else /* SS$_NORMAL */A     {U)         strtoint(&receive_setting,&str1);P+         transmit_setting = receive_setting;O!         str$copy_dx(&str2,&str1);e     };  :     /* Check to see if the receive value is in the list */8     for (i = 0; (fcs_size_list[i] != receive_setting) &&>                 (fcs_size_list[i] != END_OF_VALUE_LIST); i++);.     if (fcs_size_list[i] == END_OF_VALUE_LIST)     {_7         signal_error(PPPD$_INVVALUE,2,&fcs_size,&str1); '         FREE_DYNAMIC_DESCRIPTOR(&str1);e'         FREE_DYNAMIC_DESCRIPTOR(&str2);b         return FALSE;      }o  ;     /* Check to see if the transmit value is in the list */o9     for (i = 0; (fcs_size_list[i] != transmit_setting) &&_>                 (fcs_size_list[i] != END_OF_VALUE_LIST); i++);.     if (fcs_size_list[i] == END_OF_VALUE_LIST)     {o7         signal_error(PPPD$_INVVALUE,2,&fcs_size,&str2);l'         FREE_DYNAMIC_DESCRIPTOR(&str1);A'         FREE_DYNAMIC_DESCRIPTOR(&str2);=         return FALSE;e     }e  #     FREE_DYNAMIC_DESCRIPTOR(&str1);d#     FREE_DYNAMIC_DESCRIPTOR(&str2);r  "     /* Update the real settings */C     if (!update_ppp_item(ppp_items,PPPD$K_FCS_RX,&receive_setting))S         return FALSE; D     if (!update_ppp_item(ppp_items,PPPD$K_FCS_TX,&transmit_setting))         return FALSE;T       return TRUE; }    /* ** Function Name ** **    get_flow_control ** ** Functional Description  **H **    This routine gets the user setting for the /FLOW_CONTROL qualifierH **    on the SET command. It then updates the value in the ASN itemlist. ** ** Environment ** **    User mode  **	 ** Inputs_ ** **     NoneD **
 ** Outputs **/ **    items - pointer to the ASN item list item) **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  ** */5 PROC_STATIC int get_flow_control(VMS_ITEMLIST *items)  { 3     if SUCCESS(cli$present(&flow_control_hardware))$9         return update_asn_item(items,ASN$_FLOW,ASN$M_HW);g  3     if SUCCESS(cli$present(&flow_control_xon_xoff))a?         return update_asn_item(items,ASN$_FLOW,ASN$M_XON_XOFF);_       return TRUE; }  f /* ** Function Name ** **    get_hangup ** ** Functional Description; **B **    This routine gets the user setting for the /HANGUP qualifier **    on the SET command.i ** ** Environment ** **    User mode  **	 ** Inputst **
 **    None **
 ** Outputs **? **    hangup_setting - ptr to the current device hangup setting  **
 ** Returns **
 **    None ** */2 PROC_STATIC void get_hangup(u_int *hangup_setting) {p VMS_STATUS status;  '     status      = cli$present(&hangup);t     if (status == CLI$_PRESENT)a     {c%         *hangup_setting = HANGUP_SET;o         return;e     }y     if (status == CLI$_NEGATED)      { '         *hangup_setting = HANGUP_CLEAR;s         return;R     }I   #ifdef DEBUG_CODE(     if (line_item_trace)     {R?         printf ("Get_hangup:  Hangup = %d\n", *hangup_setting);e     }m #endif       return;T }s u /* ** Function Name ** **    get_input_ ** ** Functional Descriptionn **" **    Read a string from SYS$INPUT ** ** Environment ** **    User modec **	 ** InputsD **1 **    prompt_desc  - ptr to the prompt descriptor  ** **    Implicit1 **        keyboard_id  - keyboard id to read from E **        key_table_id - key table to be used to translate keystrokesL **
 ** Outputs **P **    user_command_desc - ptr to the command entered by the user as a descriptor6 **    len               - number of characters read in **
 ** Returns ** **    VMS condition code ** */5 VMS_STATUS get_input(D_DESCRIPTOR *user_command_desc, =                      D_DESCRIPTOR *prompt_desc, u_short *len)L {, VMS_STATUS status;  1     status = smg$read_composed_line(&keyboard_id,f2                                     &key_table_id,6                                     user_command_desc,0                                     prompt_desc,)                                     len);v  B     /* Check the status value for data overrun or end-of-input. */     if (status == SMG$_EOF)      {          status = RMS$_EOF;         return status;     }      else?         if ((status == RMS$_TNS) || (status == SS$_DATAOVERUN))               status = SS$_NORMAL;       if (FAILURE(status))     { +         CHECK_AND_REPORT_CONTEXT_AND_STATUSt'             ("get_input (read status)",S%               PPPD$_CMDPROC, status);m         return status;     }   ;     status = str$trim(user_command_desc,user_command_desc);R  W     /* In the rare event that str$trim fails let the user know but continue anyway.  */(     if (FAILURE(status))     {E+         CHECK_AND_REPORT_CONTEXT_AND_STATUSe+             ("get_input (str$trim status)", %               PPPD$_CMDPROC, status);s     }e       return SS$_NORMAL; }C S /* ** Function Name ** **    get_int_qualifierS ** ** Functional Descriptionh **J **    This routine gets the integer value specified for the given qualifer: **    and verify that it is within acceptable value ranges ** ** Environment ** **    User modes **	 ** Inputsl **< **    qualifier - the qualifier value as a string descriptor* **    min_value - minimum acceptable value) **    max_value - maximum accetable value  **
 ** Outputs **) **    value - pointer to the user's valuei **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  ** */S PROC_STATIC int get_int_qualifier(DESCRIPTOR *qualifier, int *value, int min_value,v0                                   int max_value) {n VMS_STATUS status; D_DESCRIPTOR str;)  0     /* Get the value as a string from the user*/0     INIT_DYNAMIC_DESCRIPTOR(str,max_buffer_size)+     if (!get_str_qualifier(qualifier,&str))      {*&         FREE_DYNAMIC_DESCRIPTOR(&str);         return FALSE;      }f  (     /* Convert the string to a number */     if (!strtoint(value,&str))     {_8         signal_error(PPPD$_NOTNUMERIC,2,qualifier,&str);&         FREE_DYNAMIC_DESCRIPTOR(&str);         return FALSE;h     }c  &     /* Test the boundary conditions */7     if ((*value >= min_value) && (*value <= max_value))l     {P&         FREE_DYNAMIC_DESCRIPTOR(&str);         return TRUE;     }      else     {nJ         signal_error(PPPD$_INVRANGE,4,qualifier,&str,min_value,max_value);&         FREE_DYNAMIC_DESCRIPTOR(&str);         return FALSE;      }E }r e /* ** Function Name ** **    get_network_callback ** ** Functional Descriptiond **F **    This routine lookups up the appropriate callback routine for theM **    network protocol selected by the user. The network information has been < **    previously registered through the SET NETWORK command. ** ** Environment ** **    User modei **	 ** Inputs  **G **    current_device - pointer to the current device in the device listS **
 ** Outputs **G **    current_device - pointer to the current device in the device listD **
 ** Returns ** **    TRUE if successful **    FALSE if not successful= ** */@ PROC_STATIC int get_network_callback(DEVICE_REC *current_device) {N VMS_STATUS status; int index = 0; D_DESCRIPTOR lookup;
 int found;! $DESCRIPTOR(blank_callback, " ");s  4     INIT_DYNAMIC_DESCRIPTOR(lookup,max_buffer_size);M     /* Look up the protocol listed under the /NETWORK_TYPE on the SET NETWORKtH        command.  Then use that index to find the /PPPD_CALLBACK value */     do     {UL         if (!get_network_translation(&protocol_lookup,index,&lookup,&found))             return FALSE;h  @         /* If there is no translation then this protocol has not            been registered */s         if (!found)t	         { )             signal_error(PPPD$_NOTREG,0);U-             FREE_DYNAMIC_DESCRIPTOR(&lookup);C             return FALSE;d	         }   <         /* If this protocol is the one we are looking for */M         if (str$case_blind_compare(&lookup,&current_device->network_protocol)V             == 0) 	         {MH             /* Found the correct network type, now get callback value */B             if (!get_network_translation(&protocol_callback,index,9                                          &lookup,&found))P
             { 1                 FREE_DYNAMIC_DESCRIPTOR(&lookup);                  return FALSE; 
             }e  D             /* If there is no translation then this protocol has not3                registered a PPP callback routine */o             if (!found) 
             { ,                 signal_error(PPPD$_NOPPP,0);1                 FREE_DYNAMIC_DESCRIPTOR(&lookup);*                 return FALSE; 
             }   :             /* See whether the callback is there or not */5             current_device->ppp_callback_registered =t@                 (str$compare_eql(&lookup,&blank_callback) != 0);  A             /* Find the symbol in the protocol shareable image */$8             if (current_device->ppp_callback_registered)
             {eE                 status = lib$find_image_symbol(&lookup,&open_routine,_R                                                &current_device->network_callback);"                 if FAILURE(status)                 {t-                     REPORT_CONTEXT_AND_STATUS P                         ("get_network_callback (lib$find_image_symbol status)", 2                           PPPD$_PROTOERR, status);5                     FREE_DYNAMIC_DESCRIPTOR(&lookup);t!                     return FALSE;*                 }*
             }c  9             /* free the intermediate translation value */n-             FREE_DYNAMIC_DESCRIPTOR(&lookup);e               return TRUE;	         },         else.             /* look at the next /type value */             index++;     } while (found);   }i i /* ** Function Name ** **    get_network_translationt ** ** Functional Descriptionu **I **    Get the translation for the logical name specified for this networkt ** ** Environment ** **    User modeS **	 ** Inputsx **> **    lognam - ptr to the logical name descriptor to translate7 **    index  - index value to reference the translationv **
 ** Outputs **3 **    lookup - ptr to the equivalence name returned F **    found - ptr to whether or not this network translation was found **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  */F PROC_STATIC int get_network_translation(DESCRIPTOR *lognam, int index,I                                         D_DESCRIPTOR *lookup, int *found)e {f VMS_ITEMLIST items[3]; u_int attr = LNM$M_CASE_BLIND; VMS_STATUS status;       *found = TRUE;      /* set up the item list */=     VMS_ITEMLIST_INIT(items);     VMS_ITEMLIST_ADDR(LNM$_INDEX,MAX_BUFFER_SIZE,&index,0); H     VMS_ITEMLIST_ADDR(LNM$_STRING,MAX_BUFFER_SIZE,lookup->dsc$a_pointer,-                       &lookup->dsc$w_length);O     VMS_ITEMLIST_TERMu  >     status = sys$trnlnm(&attr,&system_tabnam,lognam,0,&items);  C     /* A match was not found if the length was returned as 0 or the)        status was set */@     if ((lookup->dsc$w_length == 0) || (status == SS$_NOLOGNAM))         *found = FALSE;      else     {i+         CHECK_AND_REPORT_CONTEXT_AND_STATUSl<             ("get_network_translation (sys$trnlnm status)", &               PPPD$_PROTOERR, status);     }        return TRUE; }M D /* ** Function Name ** **    get_output_texts ** ** Functional Descriptionl **C **    This routine translates the numeric values for a setting intoe% **    text form for the SHOW command.f ** ** Environment ** **    User modeX **	 ** Inputsi **: **    text_table - translation table from numeric to alpha- **    value      - numeric value to translate  **
 ** Outputs **
 **    None **
 ** Returns **' **    Address of text string descriptorL ** */U PROC_STATIC D_DESCRIPTOR *get_output_text (OUTPUT_TRANS_TABLE *text_table, int value)v {n int i;  $     /* Find the value in the list */1     for (i = 0; (text_table[i].value != value) &&nA                 (text_table[i].value != END_OF_VALUE_LIST); i++);u        /* Return the translation */%     return (text_table[i].text_desc);c }r V /* ** Function Name ** **    get_passivep ** ** Functional Description$ **C **    This routine gets the user setting for the /PASSIVE qualifierCH **    on the SET command. It then updates the value in the PPP itemlist. ** ** Environment ** **    User mode  **	 ** Inputs  **. **    ppp_items - pointer to the PPP item list **
 ** Outputs **. **    ppp_items - pointer to the PPP item list **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  ** */8 PROC_STATIC int get_passive(NETWORK_ITEMLIST *ppp_items) {u VMS_STATUS status;
 int value;  (     status      = cli$present(&passive);     if (status == CLI$_PRESENT)      {C!         value   = PPPD$K_PASSIVE;u;         if (!update_ppp_item(ppp_items,PPPD$K_MODE,&value))r             return FALSE;t     } $     else if (status == CLI$_NEGATED)     {n          value   = PPPD$K_ACTIVE;;         if (!update_ppp_item(ppp_items,PPPD$K_MODE,&value))h             return FALSE;R     }      return TRUE; }  i /* ** Function Name ** **    get_permanent  ** ** Functional Description: **E **    This routine gets the user setting for the /PERMANENT qualifieruG **    on the SET command. It then updates the value in both the ASN ando ***   PPP itemlist.s ** ** Environment ** **    User mode  **	 ** Inputsm **. **    ppp_items - pointer to the PPP item list. **    asn_items - pointer to the ASN item list **
 ** Outputs **. **    ppp_items - pointer to the PPP item list. **    asn_items - pointer to the ASN item list **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  ** */S PROC_STATIC int get_permanent(NETWORK_ITEMLIST *ppp_items, VMS_ITEMLIST *asn_items)R {r VMS_STATUS status;
 int value;  *     status      = cli$present(&permanent);     if (status == CLI$_PRESENT)      {D#         value   = PPPD$K_PERMANENT;n@         if (!update_ppp_item(ppp_items,PPPD$K_LINE_TYPE,&value))             return FALSE; "         value   = ASN$M_PERMANENT;@         if (!update_asn_item(asn_items,ASN$_CONNECT_TYPE,value))             return FALSE;      }t$     else if (status == CLI$_NEGATED)     {e#         value   = PPPD$K_TRANSIENT; @         if (!update_ppp_item(ppp_items,PPPD$K_LINE_TYPE,&value))             return FALSE;R"         value   = ASN$M_TRANSIENT;@         if (!update_asn_item(asn_items,ASN$_CONNECT_TYPE,value))             return FALSE;      }=     return TRUE; }f A /* ** Function Name ** **    get_show_qualifiersE ** ** Functional Descriptione **H **    This routine will set a mask each for the SHOW qualifiers, and the **    SHOW/COUNTERS items. ** ** Environment ** **    User modem **	 ** Inputs  **
 **    None **
 ** Outputs **: **    show_qualifiers - pointer to the SHOW qualifier mask9 **    counter_items   - pointer to the counter items maskT **
 ** Returns ** **    TRUE if successful **    FALSE if not successfulD ** */U PROC_STATIC int get_show_qualifiers(SHOW_MASK *show_mask, COUNTER_MASK *counter_mask)  {_ SHOW_MASK    temp_show_mask; COUNTER_MASK temp_counter_mask;r int i;       /* Initialization */     temp_show_mask      = 0;     temp_counter_mask   = 0;  1     /* Retrieve and record the SHOW qualifiers */*:     if (cli$present(&address_compression) == CLI$_PRESENT)<         temp_show_mask  = temp_show_mask | SHOW$M_ADDR_COMP;/     if (cli$present(&counters) == CLI$_PRESENT)e;         temp_show_mask  = temp_show_mask | SHOW$M_COUNTERS;e3     if (cli$present(&echo_failure) == CLI$_PRESENT)c?         temp_show_mask  = temp_show_mask | SHOW$M_ECHO_FAILURE;e5     if (cli$present(&echo_intervals) == CLI$_PRESENT)m@         temp_show_mask  = temp_show_mask | SHOW$M_ECHO_INTERVAL;/     if (cli$present(&fcs_size) == CLI$_PRESENT)GB         temp_show_mask  = temp_show_mask | SHOW$M_RECEIVE_FCS_SIZED                                          | SHOW$M_TRANSMIT_FCS_SIZE;3     if (cli$present(&flow_control) == CLI$_PRESENT) ?         temp_show_mask  = temp_show_mask | SHOW$M_FLOW_CONTROL; -     if (cli$present(&hangup) == CLI$_PRESENT) 9         temp_show_mask  = temp_show_mask | SHOW$M_HANGUP; 3     if (cli$present(&magic_number) == CLI$_PRESENT)E@         temp_show_mask  = temp_show_mask | SHOW$M_MAGIC_RETRIES;4     if (cli$present(&max_configure) == CLI$_PRESENT)@         temp_show_mask  = temp_show_mask | SHOW$M_MAX_CONFIGURE;2     if (cli$present(&max_failure) == CLI$_PRESENT)>         temp_show_mask  = temp_show_mask | SHOW$M_MAX_FAILURE;4     if (cli$present(&max_terminate) == CLI$_PRESENT)@         temp_show_mask  = temp_show_mask | SHOW$M_MAX_TERMINATE;*     if (cli$present(&mru) == CLI$_PRESENT)6         temp_show_mask  = temp_show_mask | SHOW$M_MRU;*     if (cli$present(&mtu) == CLI$_PRESENT)6         temp_show_mask  = temp_show_mask | SHOW$M_MTU;7     if (cli$present(&network_protocol) == CLI$_PRESENT)rC         temp_show_mask  = temp_show_mask | SHOW$M_NETWORK_PROTOCOL;e.     if (cli$present(&passive) == CLI$_PRESENT):         temp_show_mask  = temp_show_mask | SHOW$M_PASSIVE;0     if (cli$present(&permanent) == CLI$_PRESENT)<         temp_show_mask  = temp_show_mask | SHOW$M_PERMANENT;;     if (cli$present(&protocol_compression) == CLI$_PRESENT) @         temp_show_mask  = temp_show_mask | SHOW$M_PROTOCOL_COMP;3     if (cli$present(&receive_accm) == CLI$_PRESENT) ?         temp_show_mask  = temp_show_mask | SHOW$M_RECEIVE_ACCM; 4     if (cli$present(&restart_timer) == CLI$_PRESENT)@         temp_show_mask  = temp_show_mask | SHOW$M_RESTART_TIMER;,     if (cli$present(&speed) == CLI$_PRESENT)8         temp_show_mask  = temp_show_mask | SHOW$M_SPEED;,     if (cli$present(&trace) == CLI$_PRESENT)8         temp_show_mask  = temp_show_mask | SHOW$M_TRACE;4     if (cli$present(&transmit_accm) == CLI$_PRESENT)@         temp_show_mask  = temp_show_mask | SHOW$M_TRANSMIT_ACCM;/     if (cli$present(&all_long) == CLI$_PRESENT)C-         temp_show_mask  = SHOW$M_ALL_OPTIONS; 0     if (cli$present(&all_brief) == CLI$_PRESENT)+         temp_show_mask  = SHOW$M_ALL_BRIEF;o       if (temp_show_mask == 0)N         temp_show_mask  = SHOW$M_ALL_BRIEF; /* Make /ALL=BRIEF the default  */  @     /* Retrieve and record the /COUNTERS items, if they exist */)     if (temp_show_mask | SHOW$M_COUNTERS) 3         if (cli$present(&counters) == CLI$_PRESENT) 5         {       /* Retrieve the items from the CLI */l=             get_counter_items(&counters, &temp_counter_mask); 5             if ((temp_counter_mask & ASN$M_ALL) != 0)l5                 temp_counter_mask = ASN_ALL_COUNTERS;i	         } 9         else    /* From /ALL, so set all counter items */l1             temp_counter_mask = ASN_ALL_COUNTERS;C  (     /* Set the parameters, and return */)     *show_mask          = temp_show_mask;*,     *counter_mask       = temp_counter_mask;       return TRUE; }i > /* ** Function Name ** **    get_speed  ** ** Functional Description_ **A **    This routine gets the user setting for the /SPEED qualifiereK **    on the SET command. It then updates the values in the current device.  ** ** Environment ** **    User modef **	 ** Inputsl ** **     Noneu **
 ** Outputs **A **    input_speed       - pointer to the current input speed codek< **    input_show_speed  - pointer to the current input speedB **    output_speed      - pointer to the current output speed code= **    output_show_speed - pointer to the current output speed  **
 ** Returns ** **    TRUE if successful **    FALSE if not successfulM ** */I PROC_STATIC int get_speed(u_char *input_speed,  u_int *input_show_speed,  I                           u_char *output_speed, u_int *output_show_speed)  {  VMS_STATUS status; D_DESCRIPTOR str1, str2;, int receive_setting,  receive_show_setting, ,     transmit_setting, transmit_show_setting; int i;  =     /* Retrieve the speed setting(s).  The CLI definition  */t=     /* will guarentee at least one value, and that all the */ =     /* text returned is numeric.                           */e2     INIT_DYNAMIC_DESCRIPTOR(str1,max_buffer_size);2     INIT_DYNAMIC_DESCRIPTOR(str2,max_buffer_size);)     status = cli$get_value(&speed,&str1);a     if (status == CLI$_COMMA)l     {e.         strtoint(&receive_show_setting,&str1);-         status = cli$get_value(&speed,&str2);e/         strtoint(&transmit_show_setting,&str2);o= /*      if (status != SS$_NORMAL), warning?, list too long */c     }      else /* SS$_NORMAL */u     { /         strtoint(&transmit_show_setting,&str1);R1         receive_show_setting = SPEED_UNSPECIFIED; !         str$copy_dx(&str2,&str1);      };  0     /* Translate the speeds into a tt setting */F     for (i = 0; (port_speed_list[i].number != receive_show_setting) &&G                 (port_speed_list[i].number != END_OF_VALUE_LIST); i++);D7     if (port_speed_list[i].number == END_OF_VALUE_LIST)$     {,4         signal_error(PPPD$_INVVALUE,2,&speed,&str1);'         FREE_DYNAMIC_DESCRIPTOR(&str1);_'         FREE_DYNAMIC_DESCRIPTOR(&str2);(         return FALSE;g     }i     else     {A2         receive_setting = port_speed_list[i].code;     })  G     for (i = 0; (port_speed_list[i].number != transmit_show_setting) &&=G                 (port_speed_list[i].number != END_OF_VALUE_LIST); i++);C7     if (port_speed_list[i].number == END_OF_VALUE_LIST)r     {l4         signal_error(PPPD$_INVVALUE,2,&speed,&str2);'         FREE_DYNAMIC_DESCRIPTOR(&str1);;'         FREE_DYNAMIC_DESCRIPTOR(&str2);          return FALSE;*     }o     else     { 3         transmit_setting = port_speed_list[i].code;f     }t  #     FREE_DYNAMIC_DESCRIPTOR(&str1);W#     FREE_DYNAMIC_DESCRIPTOR(&str2);*  )     *input_speed       = receive_setting;t.     *input_show_speed  = receive_show_setting;*     *output_speed      = transmit_setting;/     *output_show_speed = transmit_show_setting;r   #ifdef DEBUG_CODE      if (line_item_trace)     {/H         printf ("Get_speed:  Input & Output speed/code = %d %d %d %d\n",9                  receive_setting,  receive_show_setting, l:                  transmit_setting, transmit_show_setting);     }  #endif       return TRUE; }  _ /* ** Function Name ** **    get_str_qualifiert ** ** Functional Descriptioni **O **    This routine gets the user string value specified for the given qualifiera ** ** Environment ** **    User modet **	 ** Inputsi **< **    qualifier - the qualifier value as a string descriptor **
 ** Outputs **> **    str - pointer to the user's value as a string descriptor **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  ** */? int get_str_qualifier(DESCRIPTOR *qualifier, D_DESCRIPTOR *str)* {* VMS_STATUS status;  *     status = cli$get_value(qualifier,str);     CHECK_STATUS(status)       return TRUE; }t ) /* ** Function Name ** **    get_transmit_accm  ** ** Functional Description  **I **    This routine gets the user setting for the /TRANSMIT_ACCM qualifier H **    on the SET command. It then updates the value in the PPP itemlist. ** ** Environment ** **    User mode= **	 ** Inputs  **
 **    None **
 ** Outputs **/ **    items - pointer to the PPP item list item$ **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  ** */: PROC_STATIC int get_transmit_accm(NETWORK_ITEMLIST *items) {c VMS_STATUS status; D_DESCRIPTOR str;h" int temp_accm[TRANSMIT_ACCM_SIZE]; int i;       /* Initialization */1     INIT_DYNAMIC_DESCRIPTOR(str,max_buffer_size);   2     /* Load the temp space with what is current */A     if (!extract_ppp_int_item (items, PPPD$K_TX_ACCM, temp_accm))      {*&         FREE_DYNAMIC_DESCRIPTOR(&str);         return FALSE;*     }   /     /* Get and load each value from the user */_     status = 0;oH     for (i = 0; (i < TRANSMIT_ACCM_SIZE) && (status != SS$_NORMAL); i++)     {n4         status = cli$get_value(&transmit_accm,&str);&         strtoint (&temp_accm[i],&str);     }i"     FREE_DYNAMIC_DESCRIPTOR(&str);        /* Check for illegal bits */,     for (i = 0; i < TRANSMIT_ACCM_SIZE; i++)     { :         if ((temp_accm[i] & illegal_tx_accm_mask[i]) != 0)	         {m3             signal_error (PPPD$_ILLEGALACCM,1,i+1);u             return FALSE; 	         }M     }   "     /* Update the real settings */9     if (!update_ppp_item(items,PPPD$K_TX_ACCM,temp_accm))          return FALSE;        return TRUE; }e   /* ** Function Name ** **    get_tt_namef ** ** Functional DescriptionP **D **    This routine gets the device name and physical device name for **    the TT: device.f ** ** Environment ** **    User mode_ **	 ** Inputs  **
 **    None **
 ** Outputs **K **    device_name - ptr to the physical device name as a dynamic descriptor D **    tt_name     - ptr to the terminal name as a dynamic descriptor **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  */M PROC_STATIC int get_tt_name(D_DESCRIPTOR *device_name, D_DESCRIPTOR *tt_name)  {  VMS_ITEMLIST items[5];" $DESCRIPTOR(tt_device_name,"TT:");
 IOSB iosb; VMS_STATUS status; int start_position = 1;* u_int correct_format;  u_int devclass;l u_int devchar2;n int   line_type;       /* Initialization */     VMS_ITEMLIST_INIT(items)I     VMS_ITEMLIST_ADDR(DVI$_DEVNAM,ppp_str_len,device_name->dsc$a_pointer,E1                       &device_name->dsc$w_length)lK     VMS_ITEMLIST_ADDR(DVI$_TT_PHYDEVNAM,ppp_str_len,tt_name->dsc$a_pointer, -                       &tt_name->dsc$w_length)      VMS_ITEMLIST_TERMd  7     status = sys$getdviw(PPPD_EFN,            /* EFN */ 8                          0,                   /* chan */;                          &tt_device_name,     /* devname */s=                          &items,              /* item list */)8                          &iosb,               /* IOSB */<                          0,                   /* AST addr */=                          0,                   /* AST param */|;                          0);                  /* nullarg */$  +     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0_,         ("get_tt_name (sys$getdviw status)",3           PPPD$_PORTSETUP, status, tt_device_name);;+     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0P1         ("get_tt_name (sys$getdviw iosb.status)",|8           PPPD$_PORTSETUP, iosb.status, tt_device_name);       return TRUE; }e s /* ** Function Name ** **    get_u_int_qualifier( ** ** Functional DescriptionL **J **    This routine gets the integer value specified for the given qualifer: **    and verify that it is within acceptable value ranges ** ** Environment ** **    User mode$ **	 ** Inputs; **< **    qualifier - the qualifier value as a string descriptor* **    min_value - minimum acceptable value) **    max_value - maximum accetable value  **
 ** Outputs **+ **    u_value - pointer to the user's value$ **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  ** */[ PROC_STATIC int get_u_int_qualifier(DESCRIPTOR *qualifier, u_int *u_value, u_int min_value,_4                                     u_int max_value) {( VMS_STATUS status; D_DESCRIPTOR str; 1 int value; /* strtoint and CLI use signed ints */W  0     /* Get the value as a string from the user*/0     INIT_DYNAMIC_DESCRIPTOR(str,max_buffer_size)+     if (!get_str_qualifier(qualifier,&str))r     { &         FREE_DYNAMIC_DESCRIPTOR(&str);         return FALSE;O     }M  (     /* Convert the string to a number */     if (!strtoint(&value,&str))      {o8         signal_error(PPPD$_NOTNUMERIC,2,qualifier,&str);&         FREE_DYNAMIC_DESCRIPTOR(&str);         return FALSE;_     }   I     memcpy(u_value,&value,4); /* Do a raw copy to keep the bits intact */=  &     /* Test the boundary conditions */;     if ((*u_value >= min_value) && (*u_value <= max_value))s     {=&         FREE_DYNAMIC_DESCRIPTOR(&str);         return TRUE;     }E     else     {rJ         signal_error(PPPD$_INVRANGE,4,qualifier,&str,min_value,max_value);&         FREE_DYNAMIC_DESCRIPTOR(&str);         return FALSE;N     }  }  p /* ** Function Name ** **    get_user_UIC ** ** Functional Descriptionl **L **    This routine will retrieve the UIC associated with the process running **    this utility.f ** ** Environment ** **    User modek **	 ** InputsB **
 **    None **
 ** Outputs **1 **    user_UIC - UIC associated with this processM **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  ** */1 PROC_STATIC int get_user_UIC(UIC_VALUE *user_UIC)E {  VMS_ITEMLIST items[2]; VMS_STATUS status;
 IOSB iosb;       VMS_ITEMLIST_INIT(items)=     VMS_ITEMLIST_ADDR(JPI$_UIC,sizeof(UIC_VALUE),user_UIC,0L),     VMS_ITEMLIST_TERM   7     status = sys$getjpiw(PPPD_EFN,            /* EFN */ ?                          0,                   /* PID address */ @                          0,                   /* process name */=                          &items,              /* item list */r8                          &iosb,               /* IOSB */<                          0,                   /* AST addr */=                          0);                  /* AST param */   '     CHECK_AND_REPORT_CONTEXT_AND_STATUS :         ("get_user_UIC (status)", PPPD$_PORTDISC, status);'     CHECK_AND_REPORT_CONTEXT_AND_STATUSeD         ("get_user_UIC (iosb.status)", PPPD$_PORTDISC, iosb.status);       return TRUE; }l * /* ** Function Name ** **    initialize_asn_set_items ** ** Functional Descriptiont **< **    This routine initializes the asynch device attributes. ** ** Environment ** **    User modee **	 ** Inputst **
 **    None **
 ** Outputs **3 **    items - pointer to the asych device item list* **
 ** Returns **
 **    None */> PROC_STATIC void initialize_asn_set_items(VMS_ITEMLIST *items) {e<     /* Setup the default attributes for the Asynch driver */     VMS_ITEMLIST_INIT(*items)sB     VMS_ITEMLIST_VALUE(ASN$_RESET_COUNTERS,DEFAULT_CLEAR_COUNTERS)6     VMS_ITEMLIST_VALUE(ASN$_FLOW,DEFAULT_FLOW_CONTROL),     VMS_ITEMLIST_VALUE(ASN$_MRU,default_mru),     VMS_ITEMLIST_VALUE(ASN$_MTU,default_mtu)?     VMS_ITEMLIST_VALUE(ASN$_CONNECT_TYPE,asn_default_permanent)o     VMS_ITEMLIST_TERMtD     /* The QIO doesn't need the terminating 0 itemlist entry, but */(     /* other PPPD utility routines do */   #ifdef DEBUG_CODED     if (asn_itemlist_dump)>         dump_asn_itemlist ("Initialize_asn_set_items", items); #endif       return;l }  e /* ** Function Name ** **    initialize_ppp_items ** ** Functional Descriptione **9 **    This routine initializes the PPP device attributes.* ** ** Environment ** **    User mode, **	 ** Inputs* **
 **    None **
 ** Outputs **
 **    None **
 ** Returns **4 **    items - pointer to the PPP device item list or< **            NULL if an error occurred in creating the list */8 PROC_STATIC NETWORK_ITEMLIST *initialize_ppp_items(void) {  NETWORK_ITEMLIST *items;  9     /* Create and initialize a new PPP device itemlist */r"     items = create_ppp_itemlist();     if (items == NULL)         return items;m  6     /* Now, add the defaults for the PPP connection */G     add_ppp_item(items,PPPD$K_AC_COMPRESS,&default_address_compression,                    sizeof(u_int));P     add_ppp_item(items,PPPD$K_ECHO_FAILURE,&default_echo_failure,sizeof(u_int));E     add_ppp_item(items,PPPD$K_ECHO_INTERVALS,&default_echo_intervals,i                   sizeof(u_int));?     add_ppp_item(items,PPPD$K_FCS_RX,&default_receive_fcs_size,L                   sizeof(u_int));@     add_ppp_item(items,PPPD$K_FCS_TX,&default_transmit_fcs_size,                   sizeof(u_int));B     add_ppp_item(items,PPPD$K_MAGIC_RETRIES,&default_magic_number,                   sizeof(u_int));C     add_ppp_item(items,PPPD$K_MAX_CONFIGURE,&default_max_configure,_                   sizeof(u_int));?     add_ppp_item(items,PPPD$K_MAX_FAILURE,&default_max_failure,*                   sizeof(u_int));C     add_ppp_item(items,PPPD$K_MAX_TERMINATE,&default_max_terminate,t                   sizeof(u_int));>     add_ppp_item(items,PPPD$K_MRU,&default_mru,sizeof(u_int));>     add_ppp_item(items,PPPD$K_MTU,&default_mtu,sizeof(u_int));C     add_ppp_item(items,PPPD$K_MODE,&default_passive,sizeof(u_int)); N     add_ppp_item(items,PPPD$K_LINE_TYPE,&ppp_default_permanent,sizeof(u_int));K     add_ppp_item(items,PPPD$K_PROTO_COMPRESS,&default_protocol_compression,n                   sizeof(u_int));K     add_ppp_item(items,PPPD$K_RX_ACCM,&default_receive_accm,sizeof(u_int));sR     add_ppp_item(items,PPPD$K_RESTART_TIMER,&default_restart_timer,sizeof(u_int));B     add_ppp_item(items,PPPD$K_DEBUG,&default_trace,sizeof(u_int));=     add_ppp_item(items,PPPD$K_TX_ACCM,&default_transmit_accm,t3                  TRANSMIT_ACCM_SIZE*sizeof(u_int));s     return items;  }c f /* ** Function Name ** **    load_message_text_tableu ** ** Functional DescriptionD **D **    This routine fetches the text for each message descriptor in aG **    message text translation table.  This enables the program to have 3 **    all the user output text in the message file.* ** ** Environment ** **    User moder **	 ** Inputs  **8 **    msg_text_table    - message text translation table **
 ** Outputs **= **    msg_text_table    - message text translation table with 2 **                        all the messages loaded. **
 ** Returns **( **    Status of sys$getmsg or SS$_NORMAL ** */V PROC_STATIC VMS_STATUS load_message_text_table (MSG_TEXT_TRANS_TABLE msg_text_table[]) {A VMS_STATUS status;3 int  msg_flags  = 1; /* Text of the message only */; char msg_info[4];h int i;       /* Load the table */@     for (i = 0; msg_text_table[i].code != END_OF_CODE_LIST; i++)     {_;         /* Prepare the control string and output buffers */rP         INIT_DYNAMIC_DESCRIPTOR(msg_text_table[i].text_desc[0],max_buffer_size);     R         /* Get the control string and number of arguments from the message file */S         status = sys$getmsg(msg_text_table[i].code,                     /* msgid */CT                            &msg_text_table[i].text_desc->dsc$w_length,  /* msglen */T                             msg_text_table[i].text_desc,                /* bufadr */S                             msg_flags,                                  /* flags */_T                             msg_info);                                  /* outadr */         if FAILURE(status)             return status;     };       return SS$_NORMAL; }  M /* ** Function Name ** **    lookup_asn_item  ** ** Functional DescriptionP **E **    This routine returns the item code in the item list and returns  **    the index. ** ** Environment ** **    User modet **	 ** Inputso **3 **    items - pointer to the asych device item listc+ **    item_code - item code to be looked up* ** **
 ** Outputs **- **    index - ptr to the index to be returned  **
 ** Returns ** **    TRUE - if found  **    FALSE - if not found */G int lookup_asn_item(VMS_ITEMLIST *items, u_int item_code, u_int *index)y {i u_int i;  /     for (i = 0; (items[i].itm$w_bufsiz != 0) ||*2                 (items[i].itm$w_itmcod != 0); i++)/         if (items[i].itm$w_itmcod == item_code) 	         {              *index = i;;             return TRUE;	         }        return FALSE;S }a ; /* ** Function Name ** **    output_msg_line  ** ** Functional Descriptiona **A **    Formats output from a condition code and optional passed inI2 **    arguments, and then writes it to SYS$OUTPUT. ** ** Environment ** **    User mode  **	 ** Inputsd **  **    ccode     - condition codeG **    outparams - optional output parameters needed for the output line  **
 ** Outputs **
 **    None **
 ** Returns ** **    VMS Condition code ** */H PROC_STATIC int output_msg_line(VMS_STATUS msg_code, int arg_count, ...) {  FILE *outfile  = stdout; VMS_STATUS status;3 int  msg_flags  = 1; /* Text of the message only */  char msg_info[4];  int  fao_argv[20]; va_list arg_ptr; int i;   D_DESCRIPTOR msg_desc; D_DESCRIPTOR output_desc;   7     /* Prepare the control string and output buffers */ 6     INIT_DYNAMIC_DESCRIPTOR(msg_desc,max_buffer_size);9     INIT_DYNAMIC_DESCRIPTOR(output_desc,max_buffer_size);   N     /* Get the control string and number of arguments from the message file */@     status = sys$getmsg(msg_code,                    /* msgid */A                        &msg_desc.dsc$w_length,       /* msglen */sA                        &msg_desc,                    /* bufadr */t@                         msg_flags,                   /* flags */A                         msg_info);                   /* outadr */ '     CHECK_AND_REPORT_CONTEXT_AND_STATUS I         ("output_msg_line (sys$getmsg status)", PPPD$_OUTPUTERR, status);a  #     /* Format the output message */*A     if (msg_info[1] <= arg_count) /* Sufficient args for $FAOL */f     {u3         /* Load the arguments for the $FAOL call */c%         va_start(arg_ptr, arg_count);u'         for (i = 0; i < arg_count; i++)*/             fao_argv[i] = va_arg(arg_ptr, int);*         va_end(arg_ptr);  '         /* Format the output message */ A         status = sys$faol(&msg_desc,                 /* ctrstr */,A                           &output_desc.dsc$w_length, /* msglen */ A                           &output_desc,              /* bufadr */nA                            fao_argv);                /* prmlst */v         if (!SUCCESS(status))/	         {D%             REPORT_CONTEXT_AND_STATUS O                 ("output_msg_line (sys$faol status)", PPPD$_OUTPUTERR, status);PL             REPORT_LOCATION_AND_STATUS("output_msg_line (sys$faol)",status);/             FREE_DYNAMIC_DESCRIPTOR(&msg_desc);o2             FREE_DYNAMIC_DESCRIPTOR(&output_desc);             return FALSE;C	         }(     } -     else /* Just output the message string */v     {a-         str$copy_dx(&output_desc, &msg_desc);t     }        /* Output the message */?     output_desc.dsc$a_pointer[output_desc.dsc$w_length] = '\0';)9     fprintf (outfile, "%s\n", output_desc.dsc$a_pointer); '     FREE_DYNAMIC_DESCRIPTOR(&msg_desc); *     FREE_DYNAMIC_DESCRIPTOR(&output_desc); }s m /* ** Function Name ** **    pppd_condition_handler ** ** Functional Description  **- **    Condition handler for the PPPD utility.s. **    Display the error message using $PUTMSG. **L **    This will be the last PPPD interface condition handler executed in the **    event of an error. ** ** Environment ** **    User modet **	 ** Inputso **1 **    sigargs - ptr to chf$signal_array structure 0 **    mechargs - ptr to chf$mech_array structure **
 ** Outputs **
 **    None **
 ** Returns ** **    VMS Condition code ** */O PROC_STATIC VMS_STATUS pppd_condition_handler(struct chf$signal_array *sigargs, N                                               struct chf$mech_array *mechargs) {e #define PC_PSL_ARG_COUNT 2 VMS_STATUS status; union stsdef *signame;  @     /* Gain access to the different fields of the error code. */8     signame = (union stsdef *) &sigargs->chf$l_sig_name;  :     /* Display the error if the inhibit bit is not set. */"     if (!signame->sts$v_inhib_msg)     { )         /* Ignore the PC/PSL arguments *//4         sigargs->chf$l_sig_args -= PC_PSL_ARG_COUNT;  <         sys$putmsg(&sigargs->chf$l_sig_args,    /* msgvec */;                    put_output,                  /* actrn */ <                    0,                           /* facnam */<                    0);                          /* actprm */4         sigargs->chf$l_sig_args += PC_PSL_ARG_COUNT;     }l  7     /* Save the error code with the inhibit bit set. */e7     status = sigargs->chf$l_sig_name | STS$M_INHIB_MSG;e #if VAXz'     mechargs->chf$l_mch_savr0 = status;E #elsee'     mechargs->chf$q_mch_savr0 = status;  #endif  8     /* If it was a severe error then get out of here. */0     if (signame->sts$v_severity == STS$K_SEVERE)          return sys$exit(status);     else         return SS$_CONTINUE;   #undef PC_PSL_ARG_COUNTa }i e /* ** Function Name ** **    process_cli_commande ** ** Functional DescriptionN **J **    This routine processes the commands as specified on the command line ** ** Environment ** **    User modeA **	 ** Inputs_ **
 **    None **
 ** Outputs **
 **    None **
 ** Returns ** **    TRUE if successful **    FALSE if not successful_ ** */) PROC_STATIC int process_cli_command(void)m {t  %     /* process the connect command */r/     if (SUCCESS(cli$present(&connect_command)))D     {f`         connect_init_done = FALSE;   /* connect processing is a result of the connect command */         return util$connect();     }e  %     /* process the convert command */F/     if (SUCCESS(cli$present(&convert_command)))i'         return util$convert_log_file();   %     /* process the dialout command */ /     if (SUCCESS(cli$present(&dialout_command)))*         return util$dialout();  (     /* process the disconnect command */2     if (SUCCESS(cli$present(&disconnect_command)))!         return util$disconnect();E  "     /* process the help command */,     if (SUCCESS(cli$present(&help_command)))         return util$help();P  !     /* process the set command */a+     if (SUCCESS(cli$present(&set_command)))          return util$set();  "     /* process the show command */,     if (SUCCESS(cli$present(&show_command)))         return util$show();m       return FALSE;    }  z /* ** Function Name ** **    process_noncli_command ** ** Functional Description_ **H **    This routine processes the commands the user specifies from within **    the PPPD utility ** ** Environment ** **    User mode_ **	 ** Inputs_ **
 **    None **
 ** Outputs **
 **    None **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  ** */, PROC_STATIC int process_noncli_command(void) {_ D_DESCRIPTOR prompt_desc;c D_DESCRIPTOR user_command_desc;( u_short len; VMS_STATUS status;  B     status = smg$create_virtual_keyboard(&keyboard_id,&sys$input);'     CHECK_AND_REPORT_CONTEXT_AND_STATUSAG         ("process_noncli_command (smg$create_virtual_keyboard status)",d#           PPPD$_TERMSETUP, status);,  1     status = smg$create_key_table(&key_table_id);n'     CHECK_AND_REPORT_CONTEXT_AND_STATUSd@         ("process_noncli_command (smg$create_key_table status)",#           PPPD$_TERMSETUP, status);_  8     INIT_DYNAMIC_DESCRIPTOR(prompt_desc,max_buffer_size)  0     /* Build the command prompt such as PPPD> */@     status = sys$getmsg(PPPD$_CMDPROMPT,             /* msgid */A                         &prompt_desc.dsc$w_length,   /* msglen */)A                         &prompt_desc,                /* bufadr */e@                         0x0001,                      /* flags */A                         0);                          /* outadr */,'     CHECK_AND_REPORT_CONTEXT_AND_STATUSp6         ("process_noncli_command (sys$getmsg status)",#           PPPD$_OUTPUTERR, status);e  >     INIT_DYNAMIC_DESCRIPTOR(user_command_desc,max_buffer_size)     do     {sA         status = get_input(&user_command_desc,&prompt_desc,&len);u           if (SUCCESS(status))	         {r0             /* parse the user entered command */6             status = cli$dcl_parse(&user_command_desc,?                                    (void *)&pppd$command_table,s6                                    (void *)get_input);                if (SUCCESS(status))
             { /                 /* Call the command routine. */n                 cli$dispatch(); 
             }e	         }e         else              exit_utility = TRUE;       } while (!exit_utility);  *     FREE_DYNAMIC_DESCRIPTOR(&prompt_desc);0     FREE_DYNAMIC_DESCRIPTOR(&user_command_desc);     return TRUE; }a   /* ** Function Name ** **    put_output ** ** Functional DescriptionL **H **    Use lib$put_output to display a string called as an action routine: **    to $PUTMSG so that the string is not displayed twice ** ** Environment ** **    User modeR **	 ** Inputst **3 **    desc - ptr to descriptor of string to displayG **
 ** Outputs **
 **    None **
 ** Returns **	 **      0f ** */) VMS_STATUS put_output(D_DESCRIPTOR *desc)i {o     lib$put_output(desc);m  G     /* Return 0 so that $PUTMSG does not display the message itself. */n
     return 0;  }    /* ** Function Name ** **    qualifier_present, ** ** Functional Description  **> **    This routine detects the presence of a certain qualifier ** ** Environment ** **    User mode  **	 ** Inputs  **G **    qualifier - pointer to the qualifier value as a string descriptor  **
 ** Outputs **
 **    None **
 ** Returns **( **    TRUE if qualifier value is present( **    FALSE if qualifier value is absent ** */8 PROC_STATIC int qualifier_present(DESCRIPTOR *qualifier) {s VMS_STATUS status;  )     status      = cli$present(qualifier);s     if (status == CLI$_ABSENT)          return QUALIFIER_ABSENT;     if (status == CLI$_PRESENT) !         return QUALIFIER_PRESENT;*     if (status == CLI$_NEGATED)t!         return QUALIFIER_NEGATED; !     if (status == CLI$_DEFAULTED)n#         return QUALIFIER_DEFAULTED;n }o p /* ** Function Name ** **    sense_asn_items_ ** ** Functional Description  **A **    This routine senses the asynch device attributes associatedi **    with a physical device ** ** Environment ** **    User modeo **	 ** Inputs  **( **    device_name - physical device nameB **    items - pointer to the itemlist of the asynch items to sense **
 ** Outputs **
 **    None **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  */O PROC_STATIC int sense_asn_items(D_DESCRIPTOR *device_name, VMS_ITEMLIST *items)E {r D_DESCRIPTOR asn_device_name;* CHAN asn_device_channel;$ D_DESCRIPTOR edited_asn_device_name; VMS_STATUS status;
 IOSB iosb; int item_size; int num_items; int itemlist_size;  G     /* Get the ASNn: device name associated with the physical device */ 9     INIT_DYNAMIC_DESCRIPTOR(asn_device_name,ppp_str_len);)F     if (!get_asn_name_from_device_name(device_name, &asn_device_name))     {t)         signal_error(PPPD$_NOTCONNECT,0); 2         FREE_DYNAMIC_DESCRIPTOR(&asn_device_name);         return FALSE;_     }T  ,     /* Open a channel to the ASNn: device */C     if (!assign_channel(&asn_device_name,&asn_device_channel,TRUE))x         return FALSE;T.     FREE_DYNAMIC_DESCRIPTOR(&asn_device_name);       item_size = sizeof(*items);       num_items = ASN_SENSE_ITEMS;*     itemlist_size = item_size * num_items;8     status = sys$qiow(PPPD_EFN,                /* EFN */9                      asn_device_channel,       /* chan */ 9                      IO$_SENSEMODE,            /* func */ 9                      &iosb,                    /* iosb *//;                      0,                        /* astadr */a;                      0,                        /* astprm */u7                      items,                    /* p1 */u7                      itemlist_size,            /* p2 */_<                      0, 0, 0, 0);              /* p3 - p6 */  '     CHECK_AND_REPORT_CONTEXT_AND_STATUSO@         ("sense_asn_items (status)", PPPD$_NOASNACCESS, status);'     CHECK_AND_REPORT_CONTEXT_AND_STATUSaJ         ("sense_asn_items (iosb.status)", PPPD$_NOASNACCESS, iosb.status);       /* Cleanup and return */#     sys$dassgn(asn_device_channel);      return TRUE; }r , /* ** Function Name ** **    set_asn_itemsl ** ** Functional Description  **4 **    This routine sets the asynch device attributes ** ** Environment ** **    User mode  **	 ** Inputsr **- **    device_channel - ASN device channel nbrD@ **    items - pointer to the itemlist of the asynch items to set **
 ** Outputs **
 **    None **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  */G PROC_STATIC int set_asn_items(CHAN device_channel, VMS_ITEMLIST *items)  {  VMS_STATUS status;
 IOSB iosb; int item_size; int num_items; int itemlist_size;       item_size = sizeof(*items);h     num_items = ASN_SET_ITEMS;*     itemlist_size = item_size * num_items;8     status = sys$qiow(PPPD_EFN,                /* EFN */9                      device_channel,           /* chan */t9                      IO$_SETMODE,              /* func */D9                      &iosb,                    /* iosb */(;                      0,                        /* astadr */c;                      0,                        /* astprm */o7                      items,                    /* p1 */ 7                      itemlist_size,            /* p2 */l> /*                     sizeof(*items)*ASN_SET_ITEMS, /* p2, */>                      /* compiler generates 61 instead of 72 */<                      0, 0, 0, 0);              /* p3 - p6 */  '     CHECK_AND_REPORT_CONTEXT_AND_STATUSs;         ("set_asn_items (status)", PPPD$_ASNSETUP, status); '     CHECK_AND_REPORT_CONTEXT_AND_STATUSAE         ("set_asn_items (iosb.status)", PPPD$_ASNSETUP, iosb.status);        return TRUE; }    /* ** Function Name ** **    set_line_items ** ** Functional DescriptionU **7 **    This routine set the values for hangup and speed.i **M **    If the speeds are still at the default settings, they are not modified.  ** ** Environment ** **    User modes **	 ** Inputsi **O **    current_device - ptr to the current device information in the device list  **
 ** Outputs **P **     current_device - ptr to the current device information in the device list **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  */: PROC_STATIC int set_line_items(DEVICE_REC *current_device) {  VMS_STATUS status; SENSE_IOSB set_iosb; DEV_CHAR device_chars; u_char input_speed;  u_char output_speed; u_short speed; int change_eightbit = FALSE; int change_hangup   = FALSE; int change_speed    = FALSE; PRIV prev_priv;s
 PRIV mask;  ;     device_chars        = current_device->old_device_chars;r  4     /* Detect if we need to change anything first */J     change_eightbit     = (device_chars.basic_chars & TT$M_EIGHTBIT) == 0;y     change_hangup       = ((current_device->hangup == HANGUP_SET)   && ((device_chars.tt2_chars & TT2$M_HANGUP) == 0)) || w                           ((current_device->hangup == HANGUP_CLEAR) && ((device_chars.tt2_chars & TT2$M_HANGUP) != 0)); M     change_speed        = ((current_device->input_speed  != DEFAULT_SPEED) && `                            (current_device->input_speed  != current_device->old_input_speed)) ||M                           ((current_device->output_speed != DEFAULT_SPEED) &&s_                            (current_device->output_speed != current_device->old_output_speed));d #if DEBUG_CODE     if (line_item_trace)     {d         printf ("Set_line_items:\n\n    Device chars (hex), TT$M_EIGHTBIT (hex), hangup, input_speed & output speed = %X %X %d %d %d\n",h                                         device_chars.basic_chars, TT$M_EIGHTBIT, current_device->hangup,c                                         current_device->input_speed, current_device->output_speed);lS         printf ("    Change_eightbit, Change_hangup & Change_speed = %d %d %d\n\n",dD                      change_eightbit, change_hangup,  change_speed);     }  #endif<     if (!change_eightbit && !change_hangup && !change_speed)         return TRUE;  F     /* Set what needs to be changed.  If a setting is what is there */F     /* already, no privs are needed for that particular change, as  */F     /* the terminal driver detects this.  So, if only the eightbit  */F     /* needs changing, then keeping the speed and hangup the same   */F     /* will result in not needing PHY_IO (setting either requires   */F     /* PHY_IO).                                                     */       /* Set the 8-bit bit */fH     device_chars.basic_chars = device_chars.basic_chars | TT$M_EIGHTBIT;       /* Set the hangup bit */-     if (current_device->hangup == HANGUP_SET)rG         device_chars.tt2_chars = device_chars.tt2_chars | TT2$M_HANGUP; /     if (current_device->hangup == HANGUP_CLEAR) H         device_chars.tt2_chars = device_chars.tt2_chars & ~TT2$M_HANGUP;  F     /* If the input speed has been set by the user, use that speed. */*     /* Otherwise don't change the speed */5     if (current_device->input_speed == DEFAULT_SPEED)r6         input_speed = current_device->old_input_speed;     else2         input_speed = current_device->input_speed;  G     /* If the output speed has been set by the user, use that speed. */c*     /* Otherwise don't change the speed */6     if (current_device->output_speed == DEFAULT_SPEED)8         output_speed = current_device->old_output_speed;     else4         output_speed = current_device->output_speed;  .     speed = output_speed | (input_speed << 8);  (     /* Set the device characteristics */&     if (change_hangup || change_speed)     { :         SET_PRIV(mask.prv$v_phy_io,mask,prev_priv,status);/         CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0 A             ("set_line_items (SET_PRIV status)", PPPD$_PORTSETUP,E4               status, &current_device->device_name);     }y  A     status = sys$qiow(PPPD_EFN,                         /* EFN */DB                       current_device->device_channel,   /* chan */B                       IO$_SETMODE,                      /* func */B                       &set_iosb,                        /* iosb */D                       0,                                /* astadr */D                       0,                                /* astprm */@                       &device_chars,                    /* p1 */@                       sizeof(device_chars),             /* p2 */H                       speed,                            /* p3 - speed */E                       0, 0, 0);                         /* p4 - p6 */      if (FAILURE (status))y     { %         REPORT_CONTEXT_AND_STATUS_1_0;A             ("set_line_items (sys$qiow status)", PPPD$_PORTSETUP,;4               status, &current_device->device_name);*         if (change_hangup || change_speed)	         {uF             REMOVE_PRIV(prev_priv.prv$v_phy_io,mask,prev_priv,status);	         }s         return FALSE;t     }*"     if (FAILURE (set_iosb.status))     { %         REPORT_CONTEXT_AND_STATUS_1_0cF             ("set_line_items (sys$qiow iosb.status)", PPPD$_PORTSETUP,=               set_iosb.status, &current_device->device_name);R*         if (change_hangup || change_speed)	         {rF             REMOVE_PRIV(prev_priv.prv$v_phy_io,mask,prev_priv,status);	         }          return FALSE;      }   &     if (change_hangup || change_speed)     {oB         REMOVE_PRIV(prev_priv.prv$v_phy_io,mask,prev_priv,status);/         CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0 D             ("set_line_items (REMOVE_PRIV status)", PPPD$_PORTSETUP,4               status, &current_device->device_name);     }t       /* Store line state */*     current_device->restore_device = TRUE;       return TRUE; }    /* ** Function Name ** **    signal_error ** ** Functional Descriptionu **J **    This routine looks up the specified message code in the message file5 **    and displays the associated message to the userL ** ** Environment ** **    User modeE **	 ** Inputs( **: **    status    - the VMS condition status to be displayedF **    arg_count - number of optional arguments passed into the routine; **    ...       - optional arguments for the FAO directives  **
 ** Outputs **
 **    None **
 ** Returns **
 **    None ** */8 void signal_error(VMS_STATUS status, int arg_count, ...) {  #define BUFFER_MAX 20  u_int buffer[BUFFER_MAX];  va_list arg_ptr; int i;  F     /* Fill in the SYS$PUTMSG argument buffer for the error message */F     /* BUFFER_MAX-3 is the total number of $FAO arguments allowed   */c     buffer[0] = (arg_count < BUFFER_MAX-3 ? arg_count+2 : (BUFFER_MAX-3)+2); /* # args to follow */R     buffer[1] = status;S     buffer[2] = arg_count;     if (arg_count > 0)     {v%         va_start(arg_ptr, arg_count);e?         for (i = 0; (i < arg_count) && (i < BUFFER_MAX-3); i++)u/             buffer[i+3] = va_arg(arg_ptr, int);N         va_end(arg_ptr);     }e       sys$putmsg(buffer,0,0,0);N }C S /* ** Function Name ** **    start_ppp_traceg ** ** Functional Descriptionv **F **    This routine creates a mailbox file to be used by the PPP driverJ **    to store trace information, and starts the logger process to captureF **    the messages sent to the mailbox from the PPP management driver. ** ** Environment ** **    User modee **	 ** Inputsx **O **    current_device - ptr to the current device information in the device lists **
 ** Outputs **O **    current_device - ptr to the current device information in the device list  **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  a ** */; PROC_STATIC int start_ppp_trace(DEVICE_REC *current_device)O {  VMS_STATUS status; VMS_TIME   current_time; D_DESCRIPTOR time_desc_4d; D_DESCRIPTOR time_desc_8d; D_DESCRIPTOR logname;  D_DESCRIPTOR procname; D_DESCRIPTOR mbxname;  D_DESCRIPTOR edited_mbxname;
 CHAN mbxchan; 
 u_int pid; VMS_ITEMLIST items[2];
 IOSB iosb; u_int trace_flag = TRUE; PRIV prev_priv; 
 PRIV mask; char temp_str[MAX_BUFFER_SIZE];  short i;  *     /* Return if tracing is not desired */     if (!current_device->trace)s         return TRUE;  6     /* Init the descriptors holding the time digits */'     status = sys$gettim (current_time);.     if FAILURE(status)     {s!         REPORT_CONTEXT_AND_STATUStN             ("start_ppp_trace (sys$gettim status)", PPPD$_TRACESETUP, status);         return FALSE;      }_  1     sprintf (temp_str, "%8.8X", current_time[0]);s  6     INIT_DYNAMIC_DESCRIPTOR(time_desc_8d,ppp_str_len);
     i = 8;5     status = str$copy_r(&time_desc_8d, &i, temp_str);l     if FAILURE(status)     { !         REPORT_CONTEXT_AND_STATUSf[             ("start_ppp_trace (str$copy_r time_desc_8d status)", PPPD$_TRACESETUP, status);u/         FREE_DYNAMIC_DESCRIPTOR(&time_desc_8d);C         return FALSE;m     }d  6     INIT_DYNAMIC_DESCRIPTOR(time_desc_4d,ppp_str_len);
     i = 4;9     status = str$copy_r(&time_desc_4d, &i, &temp_str[4]);      if FAILURE(status)     { !         REPORT_CONTEXT_AND_STATUS [             ("start_ppp_trace (str$copy_r time_desc_4d status)", PPPD$_TRACESETUP, status); /         FREE_DYNAMIC_DESCRIPTOR(&time_desc_8d); /         FREE_DYNAMIC_DESCRIPTOR(&time_desc_4d);          return FALSE;      }    #ifdef DEBUG_CODE      if (tracefile_trace)     { R         strncpy (temp_str, time_desc_8d.dsc$a_pointer, time_desc_8d.dsc$w_length);3         temp_str[time_desc_8d.dsc$w_length] = '\0'; 8         printf ("8 digit time string = %s\n", temp_str);R         strncpy (temp_str, time_desc_4d.dsc$a_pointer, time_desc_4d.dsc$w_length);3         temp_str[time_desc_4d.dsc$w_length] = '\0';g8         printf ("4 digit time string = %s\n", temp_str);     }  #endif  C     /* Process name for the logger is PD$xxxx_yyyy where xxxx    */"C     /* is the device name and yyyy is the last 4 hex digits of   */OC     /* the system time's low-order longword.                     */_2     INIT_DYNAMIC_DESCRIPTOR(procname,ppp_str_len);A     status = str$concat(&procname,&pppd_facility_2c,&dollar_desc, <                         &current_device->edited_device_name,8                         &underscore_desc,&time_desc_4d);     if FAILURE(status)     {i!         REPORT_CONTEXT_AND_STATUS W             ("start_ppp_trace (str$concat procname status)", PPPD$_TRACESETUP, status);a/         FREE_DYNAMIC_DESCRIPTOR(&time_desc_8d); /         FREE_DYNAMIC_DESCRIPTOR(&time_desc_4d);o+         FREE_DYNAMIC_DESCRIPTOR(&procname);*         return FALSE;f     }    #ifdef DEBUG_CODEs     if (tracefile_trace)     {eJ         strncpy (temp_str, procname.dsc$a_pointer, procname.dsc$w_length);/         temp_str[procname.dsc$w_length] = '\0'; 8         printf ("Logger process name = %s\n", temp_str);     }S #endif  E     /* Mailbox logical name is PPPD$_xxx_nnnnnnnn where xxx is the */ E     /* device name and nnnnnnnn is the low longword of the system  */sE     /* time.                                                       */e1     INIT_DYNAMIC_DESCRIPTOR(logname,ppp_str_len);T=     status = str$concat(&logname,&pppd_facility,&dollar_desc,=<                         &current_device->edited_device_name,8                         &underscore_desc,&time_desc_8d);     if FAILURE(status)     {_!         REPORT_CONTEXT_AND_STATUS0V             ("start_ppp_trace (str$concat logname status)", PPPD$_TRACESETUP, status);/         FREE_DYNAMIC_DESCRIPTOR(&time_desc_8d);p/         FREE_DYNAMIC_DESCRIPTOR(&time_desc_4d); +         FREE_DYNAMIC_DESCRIPTOR(&procname);t*         FREE_DYNAMIC_DESCRIPTOR(&logname);         return FALSE;e     }u  +     FREE_DYNAMIC_DESCRIPTOR(&time_desc_8d);)+     FREE_DYNAMIC_DESCRIPTOR(&time_desc_4d);    #ifdef DEBUG_CODEf     if (tracefile_trace)     {cH         strncpy (temp_str, logname.dsc$a_pointer, logname.dsc$w_length);.         temp_str[logname.dsc$w_length] = '\0';9         printf ("Mailbox logical name = %s\n", temp_str);v     }n #endif  ?     /* Construct the default trace filename if not specified */c8     if (current_device->trace == TRACE_FILE_UNSPECIFIED)     {bB         status = str$concat(&current_device->trace_file,&procname,3                             &trace_file_extension);          if FAILURE(status)	         {t%             REPORT_CONTEXT_AND_STATUS C                 ("start_ppp_trace (str$concat trace_file status)", i,                   PPPD$_TRACESETUP, status);/             FREE_DYNAMIC_DESCRIPTOR(&procname); .             FREE_DYNAMIC_DESCRIPTOR(&logname);             return FALSE; 	         }a/         current_device->trace = TRACE_FILE_SET; J         signal_error (PPPD$_TRACEDEFFILE, 1, &current_device->trace_file);     }*   #ifdef DEBUG_CODE      if (tracefile_trace)     { E         strncpy (temp_str, current_device->trace_file.dsc$a_pointer, =D                            current_device->trace_file.dsc$w_length);A         temp_str[current_device->trace_file.dsc$w_length] = '\0';e3         printf ("Trace filename = %s\n", temp_str);G     }  #endif  <     /* Create the mailbox to the PPPD management routines */6     SET_PRIV(mask.prv$v_prmmbx,mask,prev_priv,status);     if FAILURE(status)     {s!         REPORT_CONTEXT_AND_STATUS L             ("start_ppp_trace (SET_PRIV status)", PPPD$_TRACESETUP, status);+         FREE_DYNAMIC_DESCRIPTOR(&procname);u*         FREE_DYNAMIC_DESCRIPTOR(&logname);         return FALSE;r     }i  9     status = sys$crembx(MBX_PRMFLG,          /* prmflg */y7                         &mbxchan,            /* chan */a9                         0,                   /* maxmsg */E9                         0,                   /* bufquo */t9                         0,                   /* promsk */-9                         0,                   /* acmode */<9                         &logname,            /* lognam */h:                         0);                  /* nullarg */     if FAILURE(status)     {t!         REPORT_CONTEXT_AND_STATUSE4             ("start_ppp_trace (sys$crembx status)", (               PPPD$_TRACESETUP, status);+         FREE_DYNAMIC_DESCRIPTOR(&procname); *         FREE_DYNAMIC_DESCRIPTOR(&logname);         return FALSE;*     }D&     FREE_DYNAMIC_DESCRIPTOR(&logname);  >     REMOVE_PRIV(prev_priv.prv$v_prmmbx,mask,prev_priv,status);     if FAILURE(status)     { !         REPORT_CONTEXT_AND_STATUS O             ("start_ppp_trace (REMOVE_PRIV status)", PPPD$_TRACESETUP, status); +         FREE_DYNAMIC_DESCRIPTOR(&procname);          return FALSE;      }*  '     /* Get the mailbox's device name */h1     INIT_DYNAMIC_DESCRIPTOR(mbxname,ppp_str_len);      VMS_ITEMLIST_INIT(items)D     VMS_ITEMLIST_ADDR(DVI$_DEVNAM,ppp_str_len,mbxname.dsc$a_pointer,,                       &mbxname.dsc$w_length)     VMS_ITEMLIST_TERM   7     status = sys$getdviw(PPPD_EFN,            /* EFN */ 8                          mbxchan,             /* chan */;                          0,                   /* devname */ =                          &items,              /* item list */n8                          &iosb,               /* IOSB */<                          0,                   /* AST addr */=                          0,                   /* AST param */);                          0);                  /* nullarg */      if FAILURE(status)     {.!         REPORT_CONTEXT_AND_STATUS O             ("start_ppp_trace (sys$getdviw status)", PPPD$_TRACESETUP, status); +         FREE_DYNAMIC_DESCRIPTOR(&procname);O*         FREE_DYNAMIC_DESCRIPTOR(&mbxname);         return FALSE;      }      if FAILURE(iosb.status)      {n!         REPORT_CONTEXT_AND_STATUS 9             ("start_ppp_trace (sys$getdviw iosb.status)",t-               PPPD$_TRACESETUP, iosb.status);A+         FREE_DYNAMIC_DESCRIPTOR(&procname);E*         FREE_DYNAMIC_DESCRIPTOR(&mbxname);         return FALSE;v     }v   #ifdef DEBUG_CODE      if (tracefile_trace)     {uH         strncpy (temp_str, mbxname.dsc$a_pointer, mbxname.dsc$w_length);.         temp_str[mbxname.dsc$w_length] = '\0';8         printf ("Mailbox device name = %s\n", temp_str);     }e #endif  A     /* Copy the mailbox name into the current_device structure */ C     INIT_DYNAMIC_DESCRIPTOR(current_device->trace_mbx,ppp_str_len);(>     status = str$copy_dx(&current_device->trace_mbx,&mbxname);     if FAILURE(status)     {p!         REPORT_CONTEXT_AND_STATUSuY             ("start_ppp_trace (str$copy_dx trace_mbx status)", PPPD$_TRACESETUP, status); +         FREE_DYNAMIC_DESCRIPTOR(&procname);/*         FREE_DYNAMIC_DESCRIPTOR(&mbxname);         return FALSE;f     }F  #     /* Create the logger process */ B     status = sys$creprc(&pid,                         /* pidadr */A                         &logger_image,                /* image */mA                         &mbxname,                     /* input */FB                         &current_device->trace_file,  /* output */A                         &null_device,                 /* error */_B                         0,                            /* prvadr */A                         0,                            /* quota */ C                         &procname,                    /* prcname */ B                         BASE_PRIORITY,                /* baspri */?                         0,                            /* uic */*B                         0,                            /* mbxunt */B                         PRC$M_DETACH);                /* stsflg */     if FAILURE(status)     {n!         REPORT_CONTEXT_AND_STATUSe4             ("start_ppp_trace (sys$creprc status)", (               PPPD$_TRACESETUP, status);+         FREE_DYNAMIC_DESCRIPTOR(&procname);h*         FREE_DYNAMIC_DESCRIPTOR(&mbxname);         return FALSE;h     }n'     FREE_DYNAMIC_DESCRIPTOR(&procname);    #ifdef DEBUG_CODE*     if (tracefile_trace)     {S8         printf ("Created log process PID = %8X\n", pid);     }E #endif  7     /* Add the trace information to the PPP itemlist */e8     INIT_DYNAMIC_DESCRIPTOR(edited_mbxname,ppp_str_len);5     if (!edit_device_name(&mbxname, &edited_mbxname))      {I*         FREE_DYNAMIC_DESCRIPTOR(&mbxname);1         FREE_DYNAMIC_DESCRIPTOR(&edited_mbxname);;         return FALSE;c     }=S     add_ppp_item(current_device->ppp_items,PPPD$K_DEBUG,&trace_flag,sizeof(u_int)); <     add_ppp_item(current_device->ppp_items,PPPD$K_DEBUG_MBX,K                  edited_mbxname.dsc$a_pointer,edited_mbxname.dsc$w_length);   &     FREE_DYNAMIC_DESCRIPTOR(&mbxname);-     FREE_DYNAMIC_DESCRIPTOR(&edited_mbxname);        return TRUE; }A S /* ** Function Name ** **    strtoint ** ** Functional DescriptionT **> **    This routine converts a dynamic descriptor to an integer ** ** Environment ** **    User modeT **	 ** InputsP **- **    str - string descriptor to be convertedt **
 ** Outputs **, **    nbr - pointer to the converted integer **
 ** Returns ** **    TRUE if successful **    FALSE if not successfulc ** */5 PROC_STATIC int strtoint(int *nbr, D_DESCRIPTOR *str)u {  int i; char tmpstr[MAX_BUFFER_SIZE+1];8  N     if (!(isdigit(str->dsc$a_pointer[0])) && (str->dsc$a_pointer[0] != '-') ||E         ((str->dsc$a_pointer[0] == '-') && (str->dsc$w_length == 1)))e         return FALSE;I  +     for (i = 1; i < str->dsc$w_length; i++)D,         if (!isdigit(str->dsc$a_pointer[i]))             return FALSE;,  9     strncpy(tmpstr,str->dsc$a_pointer,str->dsc$w_length);(*     tmpstr[str->dsc$w_length] = NULL_CHAR;     *nbr = atoi(tmpstr);       return TRUE; }    /* ** Function Name ** **    update_asn_item  ** ** Functional Descriptiont **N **    This routine updates a value in the asn item list based on the ASN code. ** ** Environment ** **    User moden **	 ** Inputsm **3 **    items - pointer to the asych device item listt) **    item_code - item code to be updated$ **    data - new data valuet ** **
 ** Outputs **3 **    items - pointer to the asych device item list\ **
 ** Returns ** **    TRUE - if foundo **    FALSE - if not found */O PROC_STATIC int update_asn_item(VMS_ITEMLIST *items, u_int item_code, int data)d {t u_int index;   #ifdef DEBUG_CODEs     if (asn_itemlist_dump)>         dump_asn_itemlist ("Update_asn_item (before)", items); #endif     /* Look up the ASN item */1     if (!lookup_asn_item(items,item_code,&index))          return FALSE;e       /* Update the data field */ -     items[index].itm$l_bufadr = (void *)data;f   #ifdef DEBUG_CODE      if (asn_itemlist_dump)=         dump_asn_itemlist ("Update_asn_item (after)", items);s #endif       return TRUE; }u a /* ** Function Name ** **    update_ppp_item  ** ** Functional DescriptionO **J **    This routine updates a the data field of a particular PPP attribute. **? **    NOTE: This routine assumes the data size will not change.  ** ** Environment ** **    User modes **	 ** Inputso **) **    items     - ptr to the ppp itemlist. **    tag       - item code tagr- **    data      - ptr to the data item to add  **
 ** Outputs **2 **    item      - pointer to the updated item list **
 ** Returns ** **    TRUE if successful **    FALSE if not successfuls ** */C int update_ppp_item(NETWORK_ITEMLIST *items, u_int tag, void *data)  {e% NETWORK_ITEM_INT_ENTRY *current_item;p  /     /* Look up the itemcode in the item list */d'     current_item = items->item_address;    #ifdef DEBUG_CODEc     if (ppp_itemlist_dump)>         dump_ppp_itemlist ("Update_ppp_item (before)", items);     if (ppp_itemlist_trace) [         printf ("Update_ppp_item:  current_item, tag = %d, %d\n", (long)current_item, tag);_ #endif       do     { *         if (current_item->item_tag == tag)	         {R'             /* update the data field */ 1             memcpy(&current_item->item_data,data, E                     current_item->item_length-NETWORK_ITEM_HDR_SIZE);  #ifdef DEBUG_CODER"             if (ppp_itemlist_dump)E                 dump_ppp_itemlist ("Update_ppp_item (after)", items);l #endif             return TRUE;	         }l #ifdef DEBUG_CODEr         if (ppp_itemlist_trace) k             printf ("Update_ppp_item:  current_item->item_length = %d\n", (long)current_item->item_length);e #endifH         current_item = (NETWORK_ITEM_INT_ENTRY *)((char *)current_item +M                                                   current_item->item_length);c #ifdef DEBUG_CODEc     if (ppp_itemlist_trace) M         printf ("Update_ppp_item:  current_item = %d\n", (long)current_item);  #endif       } while (current_item <DZ             (NETWORK_ITEM_INT_ENTRY *)((char *)items->item_address + items->item_length));   #ifdef DEBUG_CODEP     if (ppp_itemlist_dump)F         dump_ppp_itemlist ("Update_ppp_item (item not found)", items); #endif  K     /* Item was not found in the list and should have been - issue error */_%     signal_error(PPPD$_INVPPPCODE,0);_     return FALSE;u }n e /* ** Function Name ** **    util$connect ** ** Functional Description  **E **    This routine processes the CONNECT command or CONNECT qualifier=L **    which is used to establish a connection to the current physical device ** ** Environment ** **    User mode$ **	 ** Inputs' ** **    ImplicitG **        current_device - pointer to the current device information in * **                         the device listS **        connect_init_done - that the connect is a result of the connect qualifiersH **                            so that the initialization is already done **
 ** Outputs ** **    ImplicitD **        current_device - pointer to the current device information- **                         in the device listr **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  */ int util$connect(void) {  D_DESCRIPTOR asn_device_name;  D_DESCRIPTOR device_name;  D_DESCRIPTOR tt_name;  VMS_STATUS status;  L /* if the connect has been issued as a qualifier to the SET command, the  */L /* device information has already been initialized. If this connect is as */L /* a result of the CONNECT command, initialize the device information.    */       if (!connect_init_done)l     { 9         INIT_DYNAMIC_DESCRIPTOR(device_name,ppp_str_len);S5         INIT_DYNAMIC_DESCRIPTOR(tt_name,ppp_str_len);s  "         /* Get device parameter */4         if (!get_device_name(&device_name,&tt_name))	         {R2             FREE_DYNAMIC_DESCRIPTOR(&device_name);.             FREE_DYNAMIC_DESCRIPTOR(&tt_name);             return FALSE;v	         }_  B         /* Report back to the user what we are attempting to do */:         signal_error (PPPD$_CONNECTTERM, 1, &device_name);  &         /* Make this device current */7         if (!get_device_info(&device_name,&tt_name,0L)) 	         {n2             FREE_DYNAMIC_DESCRIPTOR(&device_name);.             FREE_DYNAMIC_DESCRIPTOR(&tt_name);             return FALSE;I	         }m  1         /* Validate that it is correctly setup */n2         if (!validate_device_name(current_device))	         {)2             FREE_DYNAMIC_DESCRIPTOR(&device_name);.             FREE_DYNAMIC_DESCRIPTOR(&tt_name);             return FALSE; 	         }   &         /* Validate the device type *//         if (!validate_device_type(&device_name,&=                                   current_device->asn_items))&	         { 2             FREE_DYNAMIC_DESCRIPTOR(&device_name);.             FREE_DYNAMIC_DESCRIPTOR(&tt_name);             return FALSE; 	         }m  .         FREE_DYNAMIC_DESCRIPTOR(&device_name);*         FREE_DYNAMIC_DESCRIPTOR(&tt_name);     } <     else /* The connection initialization is already done */     {gB         /* Report back to the user what we are attempting to do */J         signal_error (PPPD$_CONNECTTERM, 1, &current_device->device_name);  1         /* Validate that it is correctly setup */ 2         if (!validate_device_name(current_device))             return FALSE;g  &         /* Validate the device type */?         if (!validate_device_type(&current_device->device_name,o>                                    current_device->asn_items))             return FALSE;d     }G  <     /* Edit the physical device name for certain routines */M     INIT_DYNAMIC_DESCRIPTOR (current_device->edited_device_name,ppp_str_len);c7     if (!edit_device_name(&current_device->device_name,=?                           &current_device->edited_device_name))e         return FALSE;e)     if (current_device->virtual_terminal)(     {_Y         INIT_DYNAMIC_DESCRIPTOR (current_device->edited_virtual_device_name,ppp_str_len);aC         if (!edit_device_name(&current_device->virtual_device_name,UK                               &current_device->edited_virtual_device_name))E             return FALSE;R     }M  K     /* Check if the device name is already associated with an ASN device */ 9     INIT_DYNAMIC_DESCRIPTOR(asn_device_name,ppp_str_len);*C     if (get_asn_name_from_device_name(&current_device->device_name,/8                                       &asn_device_name))     {*&         signal_error(PPPD$_PREVSET,0);         return FALSE;p     }   1     /* Assign a channel to the physical device */ ,     if (current_device->device_channel == 0)9         if (!assign_channel(&current_device->device_name, C                             &current_device->device_channel,FALSE)),             return FALSE;   2     /* Verify that the line is set to no parity */+     if (!verify_line_items(current_device))          return FALSE;   ;     /* Check for invalid combinations of line attributes */ ;     /* and SET attributes                                */ 6     if (!check_port_and_line_settings(current_device))         return FALSE;   1     /* Set the hangup and line speeds settings */n(     if (!set_line_items(current_device))         return FALSE;c  ?     /* Assign the asynch device template to get a new device */ @     SET_DYNAMIC_DESCRIPTOR(asn_device_name,asn_device_template);L     if (!assign_channel(&asn_device_name,&current_device->asn_channel,TRUE))         return FALSE;i.     FREE_DYNAMIC_DESCRIPTOR(&asn_device_name);       /* Set the ASN items */g3     if (!set_asn_items(current_device->asn_channel,*2                        current_device->asn_items))         return FALSE;P  !     /* Get the ASN device name */ M     if (!get_asn_name(current_device->asn_channel,&current_device->asn_name))C         return FALSE;   7     /* Edit the ASN device name for certain routines */ J     INIT_DYNAMIC_DESCRIPTOR (current_device->edited_asn_name,ppp_str_len);4     if (!edit_device_name(&current_device->asn_name,<                           &current_device->edited_asn_name))         return FALSE;e  N     /* Now that we have the ASN device name, store it for the mgmt routines */;     add_ppp_item(current_device->ppp_items,PPPD$K_COM_PORT, ?                  current_device->edited_asn_name.dsc$a_pointer,a?                  current_device->edited_asn_name.dsc$w_length);t  *     /* Get the network protocol routine */.     if (!get_network_callback(current_device))         return FALSE;o  $     /* Setup up tracing if needed */)     if (!start_ppp_trace(current_device))R         return FALSE;i       /* Bind the ASN device */s)     if (!bind_asn_device(current_device))t         return FALSE;   7     /* Set the PPP items and kick off the PPP engine */      STORE_DEBUG_LOCATION(1,1);;     if (!call_kernel_routine(set_ppp_items,current_device))c         return FALSE;&       return TRUE; }1 e /* ** Function Name ** **    util$dialout ** ** Functional Description  **J **    This routine will set up the dial out mode of the utility.  In doingH **    so it will pick up the switch qualifiers if any, and will find theG **    data structure for the serial port.  The bulk of the work is done E **    in PPPDUTIL_DIALOUT.C.  After the dialout session is done, thiseC **    routine will start a PPP session or just return with a statuss **    to the caller. ** ** Environment ** **    User moded **	 ** Inputst **
 **    None **
 ** Outputs **
 **    None **
 ** Returns ** **    TRUE if successful **    FALSE if not successfult */ int util$dialout(void) {* VMS_STATUS     status; DIALOUT_STATUS dialout_status; D_DESCRIPTOR   asn_name; D_DESCRIPTOR   device_name;  D_DESCRIPTOR   tt_name;S D_DESCRIPTOR   temp;" char           dialout_break_char,H                dialout_break_char_str[2]       = DEFAULT_BREAK_CHAR_STR,'                dialout_disconnect_char,pM                dialout_disconnect_char_str[2]  = DEFAULT_DISCONNECT_CHAR_STR,f#                dialout_switch_char,nI                dialout_switch_char_str[2]      = DEFAULT_SWITCH_CHAR_STR;m       /* Initialization */2     INIT_DYNAMIC_DESCRIPTOR(asn_name,ppp_str_len);5     INIT_DYNAMIC_DESCRIPTOR(device_name,ppp_str_len);a1     INIT_DYNAMIC_DESCRIPTOR(tt_name,ppp_str_len);a.     INIT_DYNAMIC_DESCRIPTOR(temp,ppp_str_len);       /* Get device parameter */0     if (!get_device_name(&device_name,&tt_name))     {r.         FREE_DYNAMIC_DESCRIPTOR(&device_name);*         FREE_DYNAMIC_DESCRIPTOR(&tt_name);         return FALSE;*     }   "     /* Make this device current */3     if (!get_device_info(&device_name,&tt_name,0L))      {c.         FREE_DYNAMIC_DESCRIPTOR(&device_name);*         FREE_DYNAMIC_DESCRIPTOR(&tt_name);         return FALSE;t     }   *     FREE_DYNAMIC_DESCRIPTOR(&device_name);&     FREE_DYNAMIC_DESCRIPTOR(&tt_name);  E     /* Check to see if the device is associated with an ASN device */ N     if (get_asn_name_from_device_name(&current_device->device_name,&asn_name))     { &         signal_error(PPPD$_PREVSET,0);         return FALSE;B     }c  5     /* Set the defaults for the special characters */"5     dialout_break_char          = default_break_char;t:     dialout_disconnect_char     = default_disconnect_char;6     dialout_switch_char         = default_switch_char;  .     /* Get the break character if specified */<     if (qualifier_present(&break_char) == QUALIFIER_PRESENT)2         if (!get_str_qualifier(&break_char,&temp))             return FALSE;_         else	         {_T             dialout_break_char          = temp.dsc$a_pointer[0] & CONTROL_CHAR_MASK;@             dialout_break_char_str[0]   = temp.dsc$a_pointer[0];	         }   3     /* Get the disconnect character if specified */ /     RESET_DYNAMIC_DESCRIPTOR(temp,ppp_str_len);dA     if (qualifier_present(&disconnect_char) == QUALIFIER_PRESENT)m7         if (!get_str_qualifier(&disconnect_char,&temp))_             return FALSE;u         else	         { W             dialout_disconnect_char        = temp.dsc$a_pointer[0] & CONTROL_CHAR_MASK; C             dialout_disconnect_char_str[0] = temp.dsc$a_pointer[0];t	         }n  /     /* Get the switch character if specified */r/     RESET_DYNAMIC_DESCRIPTOR(temp,ppp_str_len); =     if (qualifier_present(&switch_char) == QUALIFIER_PRESENT)f3         if (!get_str_qualifier(&switch_char,&temp))p             return FALSE;i         else	         {eT             dialout_switch_char         = temp.dsc$a_pointer[0] & CONTROL_CHAR_MASK;@             dialout_switch_char_str[0]  = temp.dsc$a_pointer[0];	         }*  <     /* Output what the special characters are to the user */C     output_msg_line (PPPD$_SPECIALCHARS, 3, dialout_break_char_str,OH                                             dialout_disconnect_char_str,E                                             dialout_switch_char_str);I  $     /* Call the dialout workhorse */     dialout_status =%         dialout_main (current_device, )                       dialout_break_char, .                       dialout_disconnect_char,+                       dialout_switch_char);   <     /* Continue processing according to the return status */     switch (dialout_status)m     { *         case DIALOUT_DISCONNECT_FROM_PORT:             return TRUE;  #         case DIALOUT_SWITCH_TO_PPP:e	         { %             connect_init_done = TRUE;l"             return util$connect();	         }c  "         case DIALOUT_MODEM_HANGUP:!         case DIALOUT_ERROR_ABORT:e             return FALSE;            default:             return FALSE;n     }      return TRUE; }    /* ** Function Name ** **    util$disconnectd ** ** Functional Descriptionn **E **    This routine processes the DISCONNECT command which disconnectso **    the physical link. ** ** Environment ** **    User modeT **	 ** InputsP **
 **    None **
 ** Outputs **
 **    None **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  */ int util$disconnect(void)e {e D_DESCRIPTOR asn_name; D_DESCRIPTOR device_name;M D_DESCRIPTOR tt_name;a VMS_STATUS status; UIC_VALUE device_UIC, user_UIC;  PRIV prev_priv;n
 PRIV mask;       /* Initialization */2     INIT_DYNAMIC_DESCRIPTOR(asn_name,ppp_str_len);5     INIT_DYNAMIC_DESCRIPTOR(device_name,ppp_str_len);e1     INIT_DYNAMIC_DESCRIPTOR(tt_name,ppp_str_len);        /* Get device parameter */0     if (!get_device_name(&device_name,&tt_name))     {S.         FREE_DYNAMIC_DESCRIPTOR(&device_name);*         FREE_DYNAMIC_DESCRIPTOR(&tt_name);         return FALSE;      }*  "     /* Make this device current */3     if (!get_device_info(&device_name,&tt_name,0L)))     { .         FREE_DYNAMIC_DESCRIPTOR(&device_name);*         FREE_DYNAMIC_DESCRIPTOR(&tt_name);         return FALSE;      }n  *     FREE_DYNAMIC_DESCRIPTOR(&device_name);&     FREE_DYNAMIC_DESCRIPTOR(&tt_name);  P     /* The ASNn: device has the creator's UIC, so get it from the device name */O     if (!get_asn_name_from_device_name(&current_device->device_name,&asn_name))      {D)         signal_error(PPPD$_NOTCONNECT,0);e         return FALSE;m     }   <     /* Edit the physical device name for certain routines */M     INIT_DYNAMIC_DESCRIPTOR (current_device->edited_device_name,ppp_str_len);r7     if (!edit_device_name(&current_device->device_name,w?                           &current_device->edited_device_name))C         return FALSE;c)     if (current_device->virtual_terminal)t     {cY         INIT_DYNAMIC_DESCRIPTOR (current_device->edited_virtual_device_name,ppp_str_len);FC         if (!edit_device_name(&current_device->virtual_device_name,tK                               &current_device->edited_virtual_device_name))              return FALSE;s     }   .     if (!get_device_UIC(asn_name,&device_UIC))         return FALSE;r  !     if (!get_user_UIC(&user_UIC))C         return FALSE;v  D     /* Does the user have the privilege to disconnect the device? */     if (user_UIC != device_UIC)      { 9         SET_PRIV(mask.prv$v_sysprv,mask,prev_priv,status)e         if FAILURE(status)	         {i-             signal_error(PPPD$_NODISCPRIV,0);D             return FALSE;e	         }a         else	         {)E             REMOVE_PRIV(prev_priv.prv$v_sysprv,mask,prev_priv,status)U              CHECK_STATUS(status)	         }c     }e  @     /* The user does have privilege, so disconnect the device */A     if (!call_kernel_routine(disconnect_ppp_link,current_device))e         return FALSE;D       return TRUE; }m p /* ** Function Name ** **    util$exiti ** ** Functional Description_ **G **    This routine set the exit flag to TRUE so that the users can exit  **    from the utility ** ** Environment ** **    User mode  **	 ** Inputsg **
 **    None **
 ** Outputs **D **    exit_utility - controls whether user stays in utility or exits **
 ** Returns ** **    TRUE if successful **    FALSE if not successfuld */ int util$exit(void)S {,     exit_utility = TRUE;     return TRUE; }h t /* ** Function Name ** **    util$helpr ** ** Functional Description  **I **    This routine processes the HELP command to obtain help information.b ** ** Environment ** **    User mode  **	 ** Inputs  **
 **    None **
 ** Outputs **
 **    None **
 ** Returns ** **    TRUE if successful **    FALSE if not successfule */ int util$help(void)  {( D_DESCRIPTOR help_line;e D_DESCRIPTOR rest_of_line; VMS_STATUS status;  4     /* Get any remaining text on the command line */9     INIT_DYNAMIC_DESCRIPTOR (help_line, max_buffer_size);;1     SET_DYNAMIC_DESCRIPTOR  (help_line, "PPPD ");_<     INIT_DYNAMIC_DESCRIPTOR (rest_of_line, max_buffer_size);<     if (qualifier_present (&help_text) == QUALIFIER_PRESENT)     { ;         if (!get_str_qualifier (&help_text, &rest_of_line)) 	         { 4             FREE_DYNAMIC_DESCRIPTOR (&rest_of_line);             return FALSE;c	         }          else	         {r3             str$append (&help_line, &rest_of_line); 	         }u     }E  <     /* Start the help routine to process the help request */D     status = lbr$output_help (&lib$put_output,  /* Output routine */D                               0L,               /* Output width   */D                               &help_line,       /* Help topic     */D                               &help_library,    /* Help library   */D                               0L,               /* Help flags     */D                               &lib$get_input);  /* Input routine  */     CHECK_STATUS (status);     return TRUE; }_ e /* ** Function Name ** **    util$set ** ** Functional Descriptiong **? **    This routine processes the SET command to set the various*1 **    characteristics for the specified terminal.t ** ** Environment ** **    User modeL **	 ** InputsB **
 **    None **
 ** Outputs **
 **    None **
 ** Returns ** **    TRUE if successful **    FALSE if not successfulc */ int util$set(void) {  D_DESCRIPTOR device_name;; D_DESCRIPTOR tt_name;r VMS_STATUS status; u_int u_value;
 int value;  5     INIT_DYNAMIC_DESCRIPTOR(device_name,ppp_str_len);o1     INIT_DYNAMIC_DESCRIPTOR(tt_name,ppp_str_len);e       /* Get device parameter */0     if (!get_device_name(&device_name,&tt_name))     { .         FREE_DYNAMIC_DESCRIPTOR(&device_name);*         FREE_DYNAMIC_DESCRIPTOR(&tt_name);         return FALSE;      }l  "     /* Make this device current */3     if (!get_device_info(&device_name,&tt_name,0L))i     { .         FREE_DYNAMIC_DESCRIPTOR(&device_name);*         FREE_DYNAMIC_DESCRIPTOR(&tt_name);         return FALSE;      }m  *     FREE_DYNAMIC_DESCRIPTOR(&device_name);&     FREE_DYNAMIC_DESCRIPTOR(&tt_name);  =     /* Update the address compression field if set by user */ N     if ((value = qualifier_present(&address_compression)) != QUALIFIER_ABSENT)R         if (!update_ppp_item(current_device->ppp_items,PPPD$K_AC_COMPRESS,&value))             return FALSE;r  /     /* Clear out the counters if set by user */o@     if (qualifier_present(&clear_counters) == QUALIFIER_PRESENT);         if (!get_clear_counters(current_device->asn_items))c             return FALSE;S  /     /* Update the echo fields if set by user */h6     if (qualifier_present(&echo) == QUALIFIER_PRESENT)     {S:         /* Update the echo failure field if set by user */B         if (qualifier_present(&echo_failure) == QUALIFIER_PRESENT)	         {pI             if (!get_int_qualifier(&echo_failure,&value,MIN_ECHO_FAILURE,D5                                    MAX_ECHO_FAILURE))c                 return FALSE;v  O             if (!update_ppp_item(current_device->ppp_items,PPPD$K_ECHO_FAILURE,a)                                  &value))a                 return FALSE; 	         }   6         /* Update the echo intervals if set by user */D         if (qualifier_present(&echo_intervals) == QUALIFIER_PRESENT)	         {;M             if (!get_int_qualifier(&echo_intervals,&value,MIN_ECHO_INTERVALS, 7                                    MAX_ECHO_INTERVALS))M                 return FALSE;   Q             if (!update_ppp_item(current_device->ppp_items,PPPD$K_ECHO_INTERVALS,a)                                  &value))_                 return FALSE; 	         }r     }$  -     /* Update the FCS sizes if set by user */ :     if (qualifier_present(&fcs_size) == QUALIFIER_PRESENT)6         if (!get_fcs_sizes(current_device->ppp_items))             return FALSE;   0     /* Update the flow control if set by user */5     if (!get_flow_control(current_device->asn_items))a         return FALSE;   *     /* Update the hangup if set by user */(     get_hangup(&current_device->hangup);  8     /* Update the magic number retries if set by user */>     if (qualifier_present(&magic_number) == QUALIFIER_PRESENT)     {aE         if (!get_int_qualifier(&magic_number,&value,MIN_MAGIC_NUMBER, 1                                MAX_MAGIC_NUMBER))t             return FALSE;f  L         if (!update_ppp_item(current_device->ppp_items,PPPD$K_MAGIC_RETRIES,%                              &value))I             return FALSE;g     }q  1     /* Update the max configure if set by user */n?     if (qualifier_present(&max_configure) == QUALIFIER_PRESENT)t     { G         if (!get_int_qualifier(&max_configure,&value,MIN_MAX_CONFIGURE,i&     	          	   MAX_MAX_CONFIGURE))             return FALSE;*  L         if (!update_ppp_item(current_device->ppp_items,PPPD$K_MAX_CONFIGURE,%                              &value))(             return FALSE;P     }f  /     /* Update the max failure if set by user */)=     if (qualifier_present(&max_failure) == QUALIFIER_PRESENT)      {iC         if (!get_int_qualifier(&max_failure,&value,MIN_MAX_FAILURE,;$     	  	           MAX_MAX_FAILURE))             return FALSE;;  R         if (!update_ppp_item(current_device->ppp_items,PPPD$K_MAX_FAILURE,&value))             return FALSE;H     }   1     /* Update the max terminate if set by user */ ?     if (qualifier_present(&max_terminate) == QUALIFIER_PRESENT)      { G         if (!get_int_qualifier(&max_terminate,&value,MIN_MAX_TERMINATE,k(                 		   MAX_MAX_TERMINATE))             return FALSE;   L         if (!update_ppp_item(current_device->ppp_items,PPPD$K_MAX_TERMINATE,%                              &value))l             return FALSE;*     }u  '     /* Update the MRU if set by user */ 5     if (qualifier_present(&mru) == QUALIFIER_PRESENT)D     {D<         if (!get_int_qualifier(&mru,&value,MIN_MRU,MAX_MRU))             return FALSE;   J         if (!update_ppp_item(current_device->ppp_items,PPPD$K_MRU,&value))             return FALSE;   G         if (!update_asn_item(current_device->asn_items,ASN$_MRU,value))              return FALSE;      }:  '     /* Update the MTU if set by user */e5     if (qualifier_present(&mtu) == QUALIFIER_PRESENT)l     {n<         if (!get_int_qualifier(&mtu,&value,MIN_MTU,MAX_MTU))             return FALSE;m  J         if (!update_ppp_item(current_device->ppp_items,PPPD$K_MTU,&value))             return FALSE;P  G         if (!update_asn_item(current_device->asn_items,ASN$_MTU,value))              return FALSE;A     }n  1     /* Update the network protocol set by user */_B     if (qualifier_present(&network_protocol) == QUALIFIER_PRESENT)1         if (!get_str_qualifier(&network_protocol,rB                                &current_device->network_protocol))             return FALSE;s  %     /* Check for passive/nopassive */S0     if (!get_passive(current_device->ppp_items))         return FALSE;p  )     /* Check for permanent/nopermanent *//L     if (!get_permanent(current_device->ppp_items,current_device->asn_items))         return FALSE;a  4     /* Update protocol compression if set by user */O     if ((value = qualifier_present(&protocol_compression)) != QUALIFIER_ABSENT)cM         if (!update_ppp_item(current_device->ppp_items,PPPD$K_PROTO_COMPRESS,v%                              &value))P             return FALSE;u  ,     /* Update receive_accm if set by user */>     if (qualifier_present(&receive_accm) == QUALIFIER_PRESENT)     {AI         if (!get_u_int_qualifier(&receive_accm,&u_value,MIN_RECEIVE_ACCM,f3                                  MAX_RECEIVE_ACCM))i             return FALSE;D  P         if (!update_ppp_item(current_device->ppp_items,PPPD$K_RX_ACCM,&u_value))             return FALSE;      }r  0     /* Update the restart time if set by user */?     if (qualifier_present(&restart_timer) == QUALIFIER_PRESENT)e     {mG         if (!get_int_qualifier(&restart_timer,&value,MIN_RESTART_TIMER,c,     	            	       MAX_RESTART_TIMER))             return FALSE;>  L         if (!update_ppp_item(current_device->ppp_items,PPPD$K_RESTART_TIMER,%                              &value))              return FALSE;m     }e  )     /* Update the speed if set by user */ 7     if (qualifier_present(&speed) == QUALIFIER_PRESENT)n4         if (!get_speed(&current_device->input_speed,9                        &current_device->input_show_speed,E5                        &current_device->output_speed,n;                        &current_device->output_show_speed))n             return FALSE;(  2     /* Update the trace file is set by the user */@     if ((value = qualifier_present(&trace)) != QUALIFIER_ABSENT)     { &         current_device->trace = value;'         if (value == QUALIFIER_PRESENT) 	         { 1             /* Was the trace filename present? */rG             status = cli$get_value(&trace,&current_device->trace_file);a<             current_device->trace = (status == CLI$_ABSENT ?=                                      TRACE_FILE_UNSPECIFIED :s5                                      TRACE_FILE_SET);E	         }e     }U     else     {*1         current_device->trace = TRACE_FILE_CLEAR;o     }c  5     /* Update the transmit accm if set by the user */E?     if (qualifier_present(&transmit_accm) == QUALIFIER_PRESENT)r:         if (!get_transmit_accm(current_device->ppp_items))             return FALSE;   =     /* Check for connect. If present, execute connect code */*(     value = qualifier_present(&connect);G     if ((value == QUALIFIER_PRESENT) || (value == QUALIFIER_DEFAULTED))u     {=L         connect_init_done = TRUE;   /* connect processing is a result of the;                                        connect qualifier */s         return util$connect();     }r       return(TRUE);r }e   /* ** Function Name ** **    util$show* ** ** Functional Description* **A **    This routine processes the SHOW command to show the variousn1 **    characteristics for the specified terminal.C ** ** Environment ** **    User model **	 ** InputsS **
 **    None **
 ** Outputs **
 **    None **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  */ int util$show(void)R {h #define ASN_COUNTER_MAX 9N% NETWORK_ITEMLIST *items, *save_items;x0 VMS_ITEMLIST asn_sense_items[ASN_SENSE_ITEMS+1]; VMS_STATUS status; D_DESCRIPTOR asn_name; D_DESCRIPTOR device_name;l D_DESCRIPTOR tt_name; + uint64 asn_counter_buffer[ASN_COUNTER_MAX];P long   asn_flow_buffer; / SHOW_MASK show_qualifier_mask, show_qualifiers; L SHOW_MASK show_counter_filter_mask = (SHOW$M_ALL_OPTIONS ^ SHOW$M_COUNTERS); COUNTER_MASK counter_item_mask;o  int    line_inited, line_active;/ static int    show_msg_table_loaded    = FALSE;,& char   blank_string[]           = " "; D_DESCRIPTOR blank_string_desc;*$ char   temp_string[PPPD$K_MAX_NAME]; D_DESCRIPTOR *temp_desc;( u_int  temp_tx_accm[TRANSMIT_ACCM_SIZE]; u_int  temp_uint;_ int    temp_int,        temp_int2,         temp_int3;        /* Initialization */;     INIT_DYNAMIC_DESCRIPTOR(blank_string_desc,ppp_str_len);t2     SET_DYNAMIC_DESCRIPTOR(blank_string_desc," ");2     INIT_DYNAMIC_DESCRIPTOR(asn_name,ppp_str_len);5     INIT_DYNAMIC_DESCRIPTOR(device_name,ppp_str_len);*1     INIT_DYNAMIC_DESCRIPTOR(tt_name,ppp_str_len);h     if (!show_msg_table_loaded)      { L         if (!(status = load_message_text_table (show_msg_text_trans_table)))	         { /             CHECK_AND_REPORT_CONTEXT_AND_STATUSr>                 ("util$show (load_message_text_table status)",*                   PPPD$_PROGINIT, status);	         };'         show_msg_table_loaded   = TRUE;u     }n       /* Get device parameter */0     if (!get_device_name(&device_name,&tt_name))     {D.         FREE_DYNAMIC_DESCRIPTOR(&device_name);*         FREE_DYNAMIC_DESCRIPTOR(&tt_name);         return FALSE;t     })  "     /* Make this device current */=     if (!get_device_info(&device_name,&tt_name,&line_inited))      { .         FREE_DYNAMIC_DESCRIPTOR(&device_name);*         FREE_DYNAMIC_DESCRIPTOR(&tt_name);         return FALSE;      }   *     FREE_DYNAMIC_DESCRIPTOR(&device_name);&     FREE_DYNAMIC_DESCRIPTOR(&tt_name);  <     /* Edit the physical device name for certain routines */M     INIT_DYNAMIC_DESCRIPTOR (current_device->edited_device_name,ppp_str_len); 7     if (!edit_device_name(&current_device->device_name,l?                           &current_device->edited_device_name)))         return FALSE;p)     if (current_device->virtual_terminal)C     {,Y         INIT_DYNAMIC_DESCRIPTOR (current_device->edited_virtual_device_name,ppp_str_len); C         if (!edit_device_name(&current_device->virtual_device_name, K                               &current_device->edited_virtual_device_name))L             return FALSE;c     }d  F     /* Check to see if the device is associated with an ASN device. */F     /* If so, get the settings from the ASN and PPP devices, else   */F     /* pull them from the internal data structure.                  */3     line_active     = get_asn_name_from_device_nameuC                           (&current_device->device_name,&asn_name);E     if (line_active)     {           line_inited     = FALSE;     }t     else if (line_inited)p     {s-         SET_DYNAMIC_DESCRIPTOR(asn_name," ");      }   F     /* If the line is active, set up the itemlists and call the     */F     /* necessary routines to get the data.                          */       if (line_active)     {SK         /* Create and initialize a temporary PPP device itemlist for the */I-         /* PPP management showLine routine */ &         items = create_ppp_itemlist();         if (items == NULL)	         {(%             REPORT_CONTEXT_AND_STATUSe?                 ("util$show (create_ppp_itemlist NULL return)",u2                   PPPD$_PROGINIT, LIB$_INSVIRMEM);             return FALSE;C	         }s     >         /* Now, add the desired items as a skeleton for the */>         /* PPP management routine to fill in                */@         add_ppp_item(items,PPPD$K_AC_COMPRESS,0L,sizeof(u_int));;         add_ppp_item(items,PPPD$K_COM_PORT,0L,ppp_str_len);m:         add_ppp_item(items,PPPD$K_DEBUG,0L,sizeof(u_int));<         add_ppp_item(items,PPPD$K_DEBUG_MBX,0L,ppp_str_len);A         add_ppp_item(items,PPPD$K_ECHO_FAILURE,0L,sizeof(u_int));lC         add_ppp_item(items,PPPD$K_ECHO_INTERVALS,0L,sizeof(u_int));f;         add_ppp_item(items,PPPD$K_FCS_RX,0L,sizeof(u_int)); ;         add_ppp_item(items,PPPD$K_FCS_TX,0L,sizeof(u_int)); >         add_ppp_item(items,PPPD$K_LINE_TYPE,0L,sizeof(u_int));B         add_ppp_item(items,PPPD$K_MAGIC_RETRIES,0L,sizeof(u_int));B         add_ppp_item(items,PPPD$K_MAX_CONFIGURE,0L,sizeof(u_int));@         add_ppp_item(items,PPPD$K_MAX_FAILURE,0L,sizeof(u_int));B         add_ppp_item(items,PPPD$K_MAX_TERMINATE,0L,sizeof(u_int));8         add_ppp_item(items,PPPD$K_MRU,0L,sizeof(u_int));8         add_ppp_item(items,PPPD$K_MTU,0L,sizeof(u_int));9         add_ppp_item(items,PPPD$K_MODE,0L,sizeof(u_int));AC         add_ppp_item(items,PPPD$K_PROTO_COMPRESS,0L,sizeof(u_int));u<         add_ppp_item(items,PPPD$K_RX_ACCM,0L,sizeof(u_int));B         add_ppp_item(items,PPPD$K_RESTART_TIMER,0L,sizeof(u_int));O         add_ppp_item(items,PPPD$K_TX_ACCM,0L,TRANSMIT_ACCM_SIZE*sizeof(u_int));;     J         /* Set up the current device structure, and get the information */0         save_items  = current_device->ppp_items;,         current_device->ppp_items   = items;?         if (!call_kernel_routine(get_ppp_items,current_device)) 	         {l4             current_device->ppp_items  = save_items;             free (items);t             return FALSE;v	         }X     /         /* Restore the previous ppp_itemlist */ 0         current_device->ppp_items  = save_items;     B         /* Setup for retrieving information from the ASN driver */+         VMS_ITEMLIST_INIT(asn_sense_items);L;         VMS_ITEMLIST_ADDR2(ASN$_FLOW,4,0,&asn_flow_buffer); O         VMS_ITEMLIST_ADDR2(ASN$_READ_COUNTERS,72,ASN$M_ALL,asn_counter_buffer);q         VMS_ITEMLIST_TERM;     .         /* Get the data from the ASN driver */M         if (!sense_asn_items (&current_device->device_name, asn_sense_items))u             return FALSE;u     }s     else     {v,         /* Init variables needed later on */  %         /* Pointer to PPP itemlist */h4         items           = current_device->ppp_items;           /* ASN flow control */M         if (!lookup_asn_item(current_device->asn_items,ASN$_FLOW,&temp_uint))u             return FALSE;uR         asn_flow_buffer = (long)current_device->asn_items[temp_uint].itm$l_bufadr;     };  M     /* Retrieve the SHOW qualifiers and SHOW/COUNTERS items, if they exist */ B     get_show_qualifiers(&show_qualifier_mask, &counter_item_mask);  /     if (show_qualifier_mask & SHOW$M_ALL_BRIEF)o     {=-         /* Output brief form of everything */i         if (line_inited)W             output_msg_line (PPPD$_SHOWALL01A, 1, &current_device->edited_device_name);L         else if (line_active)eW             output_msg_line (PPPD$_SHOWALL01C, 1, &current_device->edited_device_name);          elseW             output_msg_line (PPPD$_SHOWALL01B, 1, &current_device->edited_device_name);d              if (line_active)	         { Q             temp_int    = (extract_ppp_int_item(items, PPPD$K_DEBUG, &temp_int) ?p6                            temp_int : INFO_NOT_FOUND);O             if (!extract_ppp_string_item(items, PPPD$K_DEBUG_MBX, temp_string)) 3                 strcpy (temp_string, blank_string);n1             output_msg_line (PPPD$_SHOWALL02A, 2,eQ                              get_output_text(debug_trace_output_table, temp_int), *                              temp_string);	         }E         else	         { :             if (current_device->trace != TRACE_FILE_CLEAR)>                 temp_desc       = &current_device->trace_file;             else5                 temp_desc       = &blank_string_desc;*1             output_msg_line (PPPD$_SHOWALL02B, 2,(^                              get_output_text(debug_trace_output_table, current_device->trace),(                              temp_desc);	         }   S         temp_int    = (extract_ppp_int_item(items, PPPD$K_AC_COMPRESS, &temp_int) ?p2                        temp_int : INFO_NOT_FOUND);V         temp_int2   = (extract_ppp_int_item(items, PPPD$K_MAX_CONFIGURE, &temp_int2) ?3                        temp_int2 : INFO_NOT_FOUND);eV         temp_int3   = (extract_ppp_int_item(items, PPPD$K_RESTART_TIMER, &temp_int3) ?3                        temp_int3 : INFO_NOT_FOUND);_,         output_msg_line (PPPD$_SHOWALL03, 3,H                          get_output_text(on_off_output_table, temp_int),/                          temp_int2, temp_int3);U  J         if (!extract_ppp_string_item(items, PPPD$K_COM_PORT, temp_string))/             strcpy (temp_string, blank_string);uS         temp_int    = (extract_ppp_int_item(items, PPPD$K_MAX_FAILURE, &temp_int) ? 2                        temp_int : INFO_NOT_FOUND);D         output_msg_line (PPPD$_SHOWALL04, 2, temp_string, temp_int);  T         temp_int    = (extract_ppp_int_item(items, PPPD$K_ECHO_FAILURE, &temp_int) ?2                        temp_int : INFO_NOT_FOUND);V         temp_int2   = (extract_ppp_int_item(items, PPPD$K_MAX_TERMINATE, &temp_int2) ?3                        temp_int2 : INFO_NOT_FOUND); P         temp_int3   = (extract_ppp_int_item(items, PPPD$K_RX_ACCM, &temp_int3) ?3                        temp_int3 : INFO_NOT_FOUND);(,         output_msg_line (PPPD$_SHOWALL05, 3,9                          temp_int, temp_int2, temp_int3);f  G         if (!extract_ppp_int_item(items, PPPD$K_TX_ACCM, temp_tx_accm));	         {v1             temp_tx_accm[0]     = INFO_NOT_FOUND;E1             temp_tx_accm[1]     = INFO_NOT_FOUND;E1             temp_tx_accm[2]     = INFO_NOT_FOUND; 1             temp_tx_accm[3]     = INFO_NOT_FOUND;*1             temp_tx_accm[4]     = INFO_NOT_FOUND;e1             temp_tx_accm[5]     = INFO_NOT_FOUND; 
         };V         temp_int    = (extract_ppp_int_item(items, PPPD$K_ECHO_INTERVALS, &temp_int) ?2                        temp_int : INFO_NOT_FOUND);L         temp_int2   = (extract_ppp_int_item(items, PPPD$K_MRU, &temp_int2) ?3                        temp_int2 : INFO_NOT_FOUND);R,         output_msg_line (PPPD$_SHOWALL06, 3,?                          temp_int, temp_int2, temp_tx_accm[0]);_  K         temp_int    = (extract_ppp_int_item(items, PPPD$K_MTU, &temp_int) ?i2                        temp_int : INFO_NOT_FOUND);,         output_msg_line (PPPD$_SHOWALL07, 3,U                          get_output_text(flow_control_output_table, asn_flow_buffer),u4                          temp_int, temp_tx_accm[1]);  L         temp_int    = (extract_ppp_int_item(items, PPPD$K_MODE, &temp_int) ?2                        temp_int : INFO_NOT_FOUND);,         output_msg_line (PPPD$_SHOWALL08, 3,V                          get_output_text(hangup_output_table, current_device->hangup),F                          get_output_text(mode_output_table, temp_int),*                          temp_tx_accm[2]);  Q         temp_int    = (extract_ppp_int_item(items, PPPD$K_LINE_TYPE, &temp_int) ?I2                        temp_int : INFO_NOT_FOUND);,         output_msg_line (PPPD$_SHOWALL09, 3,K                          get_output_text(line_type_output_table, temp_int),r;                          &current_device->network_protocol,**                          temp_tx_accm[3]);  U         temp_int    = (extract_ppp_int_item(items, PPPD$K_MAGIC_RETRIES, &temp_int) ?e2                        temp_int : INFO_NOT_FOUND);W         temp_int2   = (extract_ppp_int_item(items, PPPD$K_PROTO_COMPRESS, &temp_int2) ?g3                        temp_int2 : INFO_NOT_FOUND);N,         output_msg_line (PPPD$_SHOWALL10, 3,"                          temp_int,I                          get_output_text(on_off_output_table, temp_int2),)*                          temp_tx_accm[4]);  N         temp_int    = (extract_ppp_int_item(items, PPPD$K_FCS_RX, &temp_int) ?2                        temp_int : INFO_NOT_FOUND);9         if (current_device->input_speed == DEFAULT_SPEED) M             output_msg_line (PPPD$_SHOWALL11B, 2, temp_int, temp_tx_accm[5]);R         else2             output_msg_line (PPPD$_SHOWALL11A, 3, 5 			     current_device->output_show_speed, temp_int, O 			     temp_tx_accm[5]);   N         temp_int    = (extract_ppp_int_item(items, PPPD$K_FCS_TX, &temp_int) ?2                        temp_int : INFO_NOT_FOUND);:         if (current_device->output_speed == DEFAULT_SPEED)<             output_msg_line (PPPD$_SHOWALL12B, 1, temp_int);         elseT             output_msg_line (PPPD$_SHOWALL12A, 2, current_device->output_show_speed,'                              temp_int);i           if (line_active)	         {iV             output_msg_line (PPPD$_SHOWHDR02, 1, &current_device->edited_device_name);1             output_msg_line (PPPD$_SHOWALL13, 2,  L                             &asn_counter_buffer[0], &asn_counter_buffer[5]);1             output_msg_line (PPPD$_SHOWALL14, 2, nL                             &asn_counter_buffer[1], &asn_counter_buffer[6]);1             output_msg_line (PPPD$_SHOWALL15, 2, vL                             &asn_counter_buffer[2], &asn_counter_buffer[7]);1             output_msg_line (PPPD$_SHOWALL16, 2, )L                             &asn_counter_buffer[3], &asn_counter_buffer[8]);1             output_msg_line (PPPD$_SHOWALL17, 1,  4                             &asn_counter_buffer[4]);	         }s     }l!     else /* Not SHOW/ALL=BRIEF */i	     {    t(         /* Output current line status */         if (line_inited)Y             output_msg_line (PPPD$_SHOWLINEINIT, 1, &current_device->edited_device_name);P         else if (line_active)*X             output_msg_line (PPPD$_SHOWLINEACT, 1, &current_device->edited_device_name);         elseZ             output_msg_line (PPPD$_SHOWLINEINACT, 1, &current_device->edited_device_name);     F         /* Output any SHOW qualifier items desired except /COUNTERS */F         /* (/COUNTERS is dealt with in the next section)            */I         show_qualifiers = show_qualifier_mask & show_counter_filter_mask;      !         if (show_qualifiers != 0)L	         {nV             output_msg_line (PPPD$_SHOWHDR01, 1, &current_device->edited_device_name);:             if ((show_qualifiers & SHOW$M_ADDR_COMP) != 0)O                 if (extract_ppp_int_item(items, PPPD$K_AC_COMPRESS, &temp_int))F8                     output_msg_line (PPPD$_SHOWACCMP, 1,U                                      get_output_text(on_off_output_table, temp_int));e     6             if ((show_qualifiers & SHOW$M_TRACE) != 0)
             {                   if (line_active)                 {_U                     if (extract_ppp_string_item(items, PPPD$K_COM_PORT, temp_string))_L                         output_msg_line (PPPD$_SHOWCOMPORT, 1, temp_string);M                     if (extract_ppp_int_item(items, PPPD$K_DEBUG, &temp_int))A:                         output_msg_line (PPPD$_SHOWDBG, 1,^                                          get_output_text(debug_trace_output_table, temp_int));V                     if (extract_ppp_string_item(items, PPPD$K_DEBUG_MBX, temp_string))K                         output_msg_line (PPPD$_SHOWDBGMBX, 1, temp_string);L                 }                  else                 {I6                     output_msg_line (PPPD$_SHOWDBG, 1,g                                      get_output_text(debug_trace_output_table, current_device->trace));nB                     if (current_device->trace != TRACE_FILE_CLEAR)\                         output_msg_line (PPPD$_SHOWDBGFILE, 1, &current_device->trace_file);                 }c             };     =             if ((show_qualifiers & SHOW$M_ECHO_FAILURE) != 0)rP                 if (extract_ppp_int_item(items, PPPD$K_ECHO_FAILURE, &temp_int))F                     output_msg_line (PPPD$_SHOWECHOFAIL, 1, temp_int);>             if ((show_qualifiers & SHOW$M_ECHO_INTERVAL) != 0)R                 if (extract_ppp_int_item(items, PPPD$K_ECHO_INTERVALS, &temp_int))E                     output_msg_line (PPPD$_SHOWECHOINT, 1, temp_int);_=             if ((show_qualifiers & SHOW$M_FLOW_CONTROL) != 0)T7                 output_msg_line (PPPD$_SHOWFLOWCTRL, 1,d^                                  get_output_text(flow_control_output_table, asn_flow_buffer));7             if ((show_qualifiers & SHOW$M_HANGUP) != 0)*5                 output_msg_line (PPPD$_SHOWHANGUP, 1,rE                                  get_output_text(hangup_output_table,mJ                                                  current_device->hangup));:             if ((show_qualifiers & SHOW$M_PERMANENT) != 0)M                 if (extract_ppp_int_item(items, PPPD$K_LINE_TYPE, &temp_int))i;                     output_msg_line (PPPD$_SHOWLINETYPE, 1,nX                                      get_output_text(line_type_output_table, temp_int));>             if ((show_qualifiers & SHOW$M_MAGIC_RETRIES) != 0)Q                 if (extract_ppp_int_item(items, PPPD$K_MAGIC_RETRIES, &temp_int))iC                     output_msg_line (PPPD$_SHOWMAGIC, 1, temp_int);c>             if ((show_qualifiers & SHOW$M_MAX_CONFIGURE) != 0)Q                 if (extract_ppp_int_item(items, PPPD$K_MAX_CONFIGURE, &temp_int)) E                     output_msg_line (PPPD$_SHOWMAXCONF, 1, temp_int);t<             if ((show_qualifiers & SHOW$M_MAX_FAILURE) != 0)O                 if (extract_ppp_int_item(items, PPPD$K_MAX_FAILURE, &temp_int)),E                     output_msg_line (PPPD$_SHOWMAXFAIL, 1, temp_int); >             if ((show_qualifiers & SHOW$M_MAX_TERMINATE) != 0)Q                 if (extract_ppp_int_item(items, PPPD$K_MAX_TERMINATE, &temp_int)) E                     output_msg_line (PPPD$_SHOWMAXTERM, 1, temp_int);t4             if ((show_qualifiers & SHOW$M_MRU) != 0)G                 if (extract_ppp_int_item(items, PPPD$K_MRU, &temp_int)) A                     output_msg_line (PPPD$_SHOWMRU, 1, temp_int); 4             if ((show_qualifiers & SHOW$M_MTU) != 0)G                 if (extract_ppp_int_item(items, PPPD$K_MTU, &temp_int))_A                     output_msg_line (PPPD$_SHOWMTU, 1, temp_int); 8             if ((show_qualifiers & SHOW$M_PASSIVE) != 0)H                 if (extract_ppp_int_item(items, PPPD$K_MODE, &temp_int))7                     output_msg_line (PPPD$_SHOWMODE, 1,tS                                      get_output_text(mode_output_table, temp_int));UA             if ((show_qualifiers & SHOW$M_NETWORK_PROTOCOL) != 0)_Z                 output_msg_line (PPPD$_SHOWNETPROT, 1, &current_device->network_protocol);>             if ((show_qualifiers & SHOW$M_PROTOCOL_COMP) != 0)R                 if (extract_ppp_int_item(items, PPPD$K_PROTO_COMPRESS, &temp_int))<                     output_msg_line (PPPD$_SHOWPROTOCOMP, 1,U                                      get_output_text(on_off_output_table, temp_int));UA             if ((show_qualifiers & SHOW$M_RECEIVE_FCS_SIZE) != 0)mJ                 if (extract_ppp_int_item(items, PPPD$K_FCS_RX, &temp_int))C                     output_msg_line (PPPD$_SHOWFCSRX, 1, temp_int); B             if ((show_qualifiers & SHOW$M_TRANSMIT_FCS_SIZE) != 0)J                 if (extract_ppp_int_item(items, PPPD$K_FCS_TX, &temp_int))C                     output_msg_line (PPPD$_SHOWFCSTX, 1, temp_int); >             if ((show_qualifiers & SHOW$M_RESTART_TIMER) != 0)Q                 if (extract_ppp_int_item(items, PPPD$K_RESTART_TIMER, &temp_int)) D                     output_msg_line (PPPD$_SHOWRTIMER, 1, temp_int);6             if ((show_qualifiers & SHOW$M_SPEED) != 0)
             { A                 if (current_device->input_speed == DEFAULT_SPEED)$?                     output_msg_line (PPPD$_SHOWINSPEEDDEF,  0);p                 else^                     output_msg_line (PPPD$_SHOWINSPEED,  1, current_device->input_show_speed);     B                 if (current_device->output_speed == DEFAULT_SPEED)@                     output_msg_line (PPPD$_SHOWOUTSPEEDDEF,  0);                 else`                     output_msg_line (PPPD$_SHOWOUTSPEED,  1, current_device->output_show_speed);
             }N=             if ((show_qualifiers & SHOW$M_RECEIVE_ACCM) != 0)iK                 if (extract_ppp_int_item(items, PPPD$K_RX_ACCM, &temp_int))mE                     output_msg_line (PPPD$_SHOWRECACCM, 1, temp_int);t>             if ((show_qualifiers & SHOW$M_TRANSMIT_ACCM) != 0)N                 if (extract_ppp_int_item(items, PPPD$K_TX_ACCM, temp_tx_accm))M                     output_msg_line (PPPD$_SHOWTRANSACCM, 6, temp_tx_accm[0],eM                                                              temp_tx_accm[1],mM                                                              temp_tx_accm[2], M                                                              temp_tx_accm[3], M                                                              temp_tx_accm[4],eN                                                              temp_tx_accm[5]);
         };     9         if ((show_qualifier_mask & SHOW$M_COUNTERS) != 0) 	         {              if (line_active)
             {uZ                 output_msg_line (PPPD$_SHOWHDR02, 1, &current_device->edited_device_name);A                 if ((counter_item_mask & ASN$M_BAD_FCS_RCV) != 0) T                     output_msg_line (PPPD$_SHOWBADFCS,   1, &asn_counter_buffer[0]);?                 if ((counter_item_mask & ASN$M_DATA_LOST) != 0)OT                     output_msg_line (PPPD$_SHOWDATALOST, 1, &asn_counter_buffer[1]);C                 if ((counter_item_mask & ASN$M_DROPPED_CHARS) != 0) T                     output_msg_line (PPPD$_SHOWDROPCHAR, 1, &asn_counter_buffer[2]);8                 if ((counter_item_mask & ASN$M_FE) != 0)T                     output_msg_line (PPPD$_SHOWFRAMEERR, 1, &asn_counter_buffer[3]);B                 if ((counter_item_mask & ASN$M_LONG_PACKETS) != 0)T                     output_msg_line (PPPD$_SHOWLONGPKTS, 1, &asn_counter_buffer[4]);A                 if ((counter_item_mask & ASN$M_PACKETS_RCV) != 0)_T                     output_msg_line (PPPD$_SHOWRXPKTS,   1, &asn_counter_buffer[5]);B                 if ((counter_item_mask & ASN$M_PACKETS_XMIT) != 0)T                     output_msg_line (PPPD$_SHOWTXPKTS,   1, &asn_counter_buffer[6]);B                 if ((counter_item_mask & ASN$M_RUNT_PACKETS) != 0)T                     output_msg_line (PPPD$_SHOWRUNTPKTS, 1, &asn_counter_buffer[7]);A                 if ((counter_item_mask & ASN$M_TOTAL_CHARS) != 0)mT                     output_msg_line (PPPD$_SHOWTOTCHARS, 1, &asn_counter_buffer[8]);
             }_^             else if (show_qualifier_mask != SHOW$M_ALL_OPTIONS) /* User specified /COUNTERS */
             {=2                 signal_error (PPPD$_ASNCNTINV, 0);             };
         };     };       /* Cleanup */p     if (line_active)         free (items);i'     FREE_DYNAMIC_DESCRIPTOR(&asn_name); 0     FREE_DYNAMIC_DESCRIPTOR(&blank_string_desc);       return TRUE; }  u /* ** Function Name ** **    validate_device_name ** ** Functional Description  **D **    This routine validates that the device name is the same as the= **    terminal name when establishing a permanent connection.m ** ** Environment ** **    User mode  **	 ** Inputs  **O **    current_device - ptr to the current device information in the device list$ **
 ** Outputs **
 **    None **
 ** Returns ** **    TRUE if successful **    FALSE is not successfulu ** */@ PROC_STATIC int validate_device_name(DEVICE_REC *current_device) {r u_int index; int   line_type;  M     if (!lookup_asn_item(current_device->asn_items,ASN$_CONNECT_TYPE,&index))      {n'         REPORT_CONTEXT_AND_STATUS_1_1P2 6             ("validate_device_name (lookup_asn_item)",               PPPD$_PORTSETUP,               PPPD$_INVASNCODE, *              &current_device->device_name,!               ASN$_CONNECT_TYPE);m         return FALSE;l     }iC     line_type = (int)current_device->asn_items[index].itm$l_bufadr;i  H     /* The physical name and the terminal name must be the same for a */H     /* permanent connection.  This shows the connection is outgoing.  */H     /* Incoming connections made permanent can lead to a new          */H     /* connection to the serial port using the previous connection's  */H     /* access.                                                        */:     if (!current_device->user_device_is_physical_device &&&         (line_type & ASN$M_PERMANENT))     {d%         REPORT_CONTEXT_AND_STATUS_1_0o5             ("validate_device_name (perm line test)",                PPPD$_PORTSETUP,                PPPD$_INVPERMCONN,+              &current_device->device_name);O         return FALSE;      }      return TRUE; }o u /* ** Function Name ** **    validate_device_type ** ** Functional DescriptionO **: **    This routine will check the terminal type for either7 **    type of connection to see if is supported or not.p ** ** Environment ** **    User modep **	 ** Inputs  **@ **    tt_name - ptr to the terminal name as a dynamic descriptor( **    items - ptr to the asych item list **
 ** Outputs **
 **    None **
 ** Returns ** **    TRUE if successful **    FALSE is not successful  ** */U PROC_STATIC int validate_device_type(D_DESCRIPTOR *device_name, VMS_ITEMLIST items[])  {  u_int index; int   line_type; VMS_STATUS status; D_DESCRIPTOR tt_device_name;% D_DESCRIPTOR tt_physical_device_name;$   #ifdef DEBUG_CODEs!     if (!disable_term_type_check)      {  #endif9         /* Check to see if the device is not supported */PC         if (find_device_type (&unsupported_dev_types, device_name))d	         {o=             signal_error (PPPD$_TERMUNSUPP, 1, device_name); (             return FALSE;A
         };         H         /* Now, if the user's terminal and the specified terminal are */H         /* the same, then it must be a virtual terminal.              */A         INIT_DYNAMIC_DESCRIPTOR(tt_device_name, max_buffer_size);xJ         INIT_DYNAMIC_DESCRIPTOR(tt_physical_device_name, max_buffer_size);  %         /* Get the user's terminal */1D         if (!get_tt_name(&tt_device_name, &tt_physical_device_name))	         { 5             FREE_DYNAMIC_DESCRIPTOR(&tt_device_name);_>             FREE_DYNAMIC_DESCRIPTOR(&tt_physical_device_name);             return FALSE;)	         }          B         /* If they are equal, then do the virtual terminal test */F         if (str$case_blind_compare(device_name, &tt_device_name) == 0)	         {tF             if (!find_device_type (&supported_dev_types, device_name))
             {$B                 signal_error (PPPD$_NEEDVIRTTERM, 1, device_name);9                 FREE_DYNAMIC_DESCRIPTOR(&tt_device_name);uB                 FREE_DYNAMIC_DESCRIPTOR(&tt_physical_device_name);                 return FALSE; 
             }_	         }&  1         FREE_DYNAMIC_DESCRIPTOR(&tt_device_name);_:         FREE_DYNAMIC_DESCRIPTOR(&tt_physical_device_name);   #ifdef DEBUG_CODEg     }P #endif       return TRUE; }    /* ** Function Name ** **    verify_line_itemso ** ** Functional Description  **? **    This routine verifies that the line attributes are set to 	 **		8 bitr
 **		no paritym **I **    As a byproduct, it also captures the line speed and hangup settings  **    for the device.m ** ** Environment ** **    User modes **	 ** InputsO **O **    current_device - ptr to the current device information in the device list  **
 ** Outputs **O **    current_device - ptr to the current device information in the device list( **
 ** Returns ** **    TRUE if successful **    FALSE if not successful  n ** */= PROC_STATIC int verify_line_items(DEVICE_REC *current_device)p {m VMS_STATUS status; SENSE_IOSB sense_iosb; DEV_CHAR device_chars;  A     status = sys$qiow(PPPD_EFN,                         /* EFN */pB                       current_device->device_channel,   /* chan */B                       IO$_SENSEMODE,                    /* func */B                       &sense_iosb,                      /* iosb */D                       0,                                /* astadr */D                       0,                                /* astprm */@                       &device_chars,                    /* p1 */@                       sizeof(device_chars),             /* p2 */E                       0, 0, 0, 0);                      /* p3 - p6 */e+     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0fB         ("verify_line_items (status)", PPPD$_NOPORTACCESS, status,'          &current_device->device_name);1+     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0oF         ("verify_line_items (sense_iosb.status)", PPPD$_NOPORTACCESS, ;           sense_iosb.status, &current_device->device_name);t  '     /* Line must be set to no parity */e.     if (sense_iosb.parity_flags & TT$M_PARITY)     {e'         signal_error(PPPD$_NOPARITY,0);          return FALSE;_     }m  6     /* Save the device chars - in particular hangup */4     current_device->old_device_chars = device_chars;  <     /* Save away the input and output speed of the device */<     current_device->old_input_speed  = sense_iosb.rcv_speed;=     current_device->old_output_speed = sense_iosb.xmit_speed;m       return TRUE; }& p /* ** Function Name **
 **    main ** ** Functional Description_ **K **    Main entry point to PPPD utility. Determines type of use: CLI command 7 **    processor, or interactive PPPD command processor.& ** ** Environment ** **    User modeg **	 ** InputsO **
 **    None **
 ** Outputs **
 **    None **
 ** Returns ** **    VMS condition code ** **/  main() {_ VMS_STATUS status; PRIV prev_priv;M
 PRIV mask;   #ifdef DEBUG_CODE   N     asn_itemlist_dump           = (getenv("ASN_ITEMLIST_DUMP")       != NULL);N     line_item_trace             = (getenv("LINE_ITEM_TRACE")         != NULL);N     ppp_itemlist_dump           = (getenv("PPP_ITEMLIST_DUMP")       != NULL);N     ppp_itemlist_trace          = (getenv("PPP_ITEMLIST_TRACE")      != NULL);N     tracefile_trace             = (getenv("TRACEFILE_TRACE")         != NULL);N     disable_term_type_check     = (getenv("DISABLE_TERM_TYPE_CHECK") != NULL);   #endif  *     /* Disable the installed privileges */"     if (!disable_installed_priv())         return(PPPD$_ABORT);  8     /* Establish the exit condition handler for PPPD. */8     /*                                                */8     /* This will be the last condition handler        */8     /* called when an error is signaled in            */8     /* the PPP user interface program.                */  *     lib$establish(pppd_condition_handler);  $     exit_block.flink            = 0;/     exit_block.exit_handler     = exit_handler; $     exit_block.must_be_zero     = 0;0     exit_block.condition_value  = &final_status;     sys$dclexh(&exit_block);  =     /* Make sure this command is not running in batch mode */ >     /* if (!validate_mode())  This command may be run in batch4         return(PPPD$_ABORT);  in the system startup.     */  )     /* Initialize the debug structures */      INIT_DEBUG_STORAGE;   3     /* Initialize the PPP management call vector */ 5     SET_PRIV(mask.prv$v_cmkrnl,mask,prev_priv,status)o     if FAILURE(status)     {EM         REPORT_CONTEXT_AND_STATUS("main (SET_PRIV)", PPPD$_PROGINIT, status);          return(PPPD$_ABORT);     }26     status = sys$cmkrnl(init_ppp_mgmt_call_vector,0L);1     if (status == 0L) /* PPP driver not loaded */0     { *         signal_error(PPPD$_PPPNOTAVAIL,0);A         REMOVE_PRIV(prev_priv.prv$v_cmkrnl,mask,prev_priv,status)i         return(PPPD$_ABORT);     } =     REMOVE_PRIV(prev_priv.prv$v_cmkrnl,mask,prev_priv,status)cW     CHECK_AND_REPORT_CONTEXT_AND_STATUS ("main (REMOVE_PRIV)", PPPD$_PROGINIT, status);   <     /* Check if there is a parameter on the command line. */<     /* If so, we will attempt to send the message from    */<     /* the command line and not invoke the interactive    */<     /* utility.                                           */  ;     if (qualifier_present(&operation) == QUALIFIER_PRESENT)      {p-         /* User entered a one line command */r#         if (!process_cli_command())u              return(PPPD$_ABORT);     }_     else     { 3         /* User want to enter the PPPD subsystem */t&         if (!process_noncli_command())              return(PPPD$_ABORT);     })       return SS$_NORMAL; }m