 /*E ** Copyright  1993, 1994 by Eric M. LaFranchi.  All Rights Reserved.  **J ** This software is Copyright 1993, 1994 by Eric M. LaFranchi.  PermissionJ ** to use, copy, and freely redistributed this software in its entirety isC ** hereby granted provided that the above copyright notice and this L ** permission notice are retained.  This software may not be sold for profitF ** or incorporated in commercial software products without the writtenK ** permission of the author.  This software is provided "as is", the author L ** nor his employer make any representation of warranty, express or implied,J ** with respect to any code or other information herein.  In addition, theI ** author disclaim's any liability whatsoever for any use of such code or  ** other information.  **   **+-+  ** ** Module: PACK_NNTP ** ** Abstract:B **	This module contains function to operate on news articles using@ **	NNTP via TCP/IP. Current these routines have been tested with **	Multinet, UCX and TWG.  **
 ** Author: **	Eric M. LaFranchi ** ** Creation Date:  **	22-MAY-1993 ** ** Modifications History:  **( **	EML002		Eric M. LaFranchi	22-DEC-1993< **	Add code to dump unused part of article in the bit bucket **	if not used.  **( **	EML001		Eric M. LaFranchi	04-NOV-1993F **	Played with ifdefs, trying to get them correct for all the versions **	of TCP Software.  ** **-+-  */: #include <ctype.h>			/* Standard type definitions.	     */9 #include <stdio.h>			/* Standard I/O definitions.	     */ = #include <stdlib.h>			/* Standard library definitions.     */ = #include <string.h>			/* Standard string definitions.      */ < #include <ssdef.h>			/* openVMS system service definitions*/5 #include <rms.h>			/* OpenVMS rms definitions	     */   %     /* socket interface include files       */  #pragma nostandard
 #ifdef UCX #   include <types.h>  #   include <socket.h> #   include <in.h> #   include <inet.h> #   include <netdb.h>  #else 
 #ifdef TWG5 #   include "twg$common:[netdist.include.sys]types.h" 6 #   include "twg$common:[netdist.include.sys]socket.h"6 #   include "twg$common:[netdist.include.netinet]in.h"5 #   include "twg$common:[netdist.include.arpa]inet.h" 1 #   include "twg$common:[netdist.include]netdb.h"  #else  #ifdef	MULTINET 9 #   include "multinet_root:[multinet.include.sys]types.h" : #   include "multinet_root:[multinet.include.sys]socket.h": #   include "multinet_root:[multinet.include.netinet]in.h"9 #   include "multinet_root:[multinet.include.arpa]inet.h" 5 #   include "multinet_root:[multinet.include]netdb.h" 7     int socket( int af, int mess_type, int prot_type ); >     int connect( int sd, struct sockaddr *name, int namelen );:     int send( int sd, char * msg, int length, int flags );:     int recv( int sd, char * buf, int length, int flags );%     int shutdown( int sd, int mode ); 0     struct hostent *gethostbyname( char *host );=     struct servent *getservbyname( char *name, char *proto );  #else  #ifdef TCPWARE% #   include "tcpware_include:types.h" & #   include "tcpware_include:socket.h"" #   include "tcpware_include:in.h"$ #   include "tcpware_include:inet.h"% #   include "tcpware_include:netdb.h"  #   define send socket_send  #   define recv socket_recv 7     int socket( int af, int mess_type, int prot_type ); >     int connect( int sd, struct sockaddr *name, int namelen );:     int send( int sd, char * msg, int length, int flags );:     int recv( int sd, char * buf, int length, int flags );%     int shutdown( int sd, int mode ); 0     struct hostent *gethostbyname( char *host );=     struct servent *getservbyname( char *name, char *proto );  #else 
 #ifdef FUSION  #   include <flip.h> #   include <socket.h> #   include <in.h> #   include <netdb.h> # #   define sockaddr_in	 in_sockaddr ! #   define gethostbyname ghbyname ! #   define gethostbyname gsbyname 0 #else /* by default use CMU, because it links */ #   include <descrip.h>  #   include <ssdef.h>  #   include <iodef.h>  #   define TCP$OPEN IO$_CREATE  #   define TCP$READ IO$_READVBLK! #   define TCP$SEND IO$_WRITEVBLK  #   define TCP$CLOSE IO$_DELETE  #   define NNTP_C_LBUFSIZ 4096/     static const $DESCRIPTOR( cmudev, "IP0:" );  #endif #endif #endif #endif #endif #pragma standard  > #include "packdef.h"			/* local const and macro definitions */< #include "vmsdef.h"			/* local VMS macro definitions	     */: #include "msgdef.h"			/* local message definitions	     */   #define NNTP_PORT	119  #define NNTP_C_BUFSIZ	512  #ifndef NNTP_C_LBUFSIZ #define NNTP_C_LBUFSIZ	16384 #endif   struct context { 
     int s;     size_t len;      char *bptr;       char buffer[NNTP_C_LBUFSIZ];     char server[128];      char newsgroup[128];     size_t count, first, last;     struct FAB fab;      struct RAB rab;  };   #ifdef VAXC  #pragma nostandard #endif  A extern size_t (*pack_connect)( void **const, const char *const ); C extern size_t (*select_articles)( void *const, const char *const ); J extern size_t (*scan_articles)( void *const, size_t (*)(), const void * );[ extern size_t (*extract_articles)( void *const, const size_t, size_t (*)(), const void * ); ? extern size_t (*cleanup_articles)( void *const, const size_t ); , extern size_t (*disconnect)( void **const );  # extern const unsigned int gblflags;    #ifdef VAXC  #pragma standard #endif  B static size_t (*nntp_read_line)( void * cxt, char *const buffer );H static size_t (*nntp_send_line)( void * cxt, const char *const buffer );  F     /* If you need to specify username and password for DECNET logins.      * Specifies as follows:      *1      *  #define AUTHORIZATION "\"user password\""       *E      * The username and password can be specified on the command line       * as follows:      *J      *	cc/define=(authorization="""\""user password\""""") pack_nntp.c ...      */  #ifndef AUTHORIZATION  #define AUTHORIZATION "" #endif   #ifdef htons #undef htons #endif  B #define htons( p )	((((p) << 8) & 0xff00) | (((p) >> 8) & 0x00ff))  ! static const char tcp[ ] = "tcp"; # static const char nntp[ ] = "nntp"; 3 static const char authorization[ ] = AUTHORIZATION;      /*  *+-+   *  * Function: nntp_tcp_read_line   *  * Abstract:?  *	returns one line of input from the nntp server. This routine B  *	maintains a pointer and length to the last buffer read from theC  *	nntp server. If the buffer length is zero or only part of a line :  *	exists, then another read is posted to the nntp server;  *
  * Inputs:$  *	cxt -- pointer NNTP context block  *>  *	input -- pointer to user buffer to recieve next input line.  *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_t " nntp_tcp_read_line( void *context, 		    char *const buf )  {      IOSB iosb;       register status;     register char *p;      register size_t len, idx; !     register struct context *cxt;   $     cxt = (struct context *)context;  I     if ( (cxt->len == 0) || ((p = strchr( cxt->bptr, '\012' )) == NULL) )      {  	if ( cxt->len > 0 )& 	    strcpy( cxt->buffer, cxt->bptr );   	do  	{ 	    idx = cxt->len;- 	    len = (sizeof( cxt->buffer ) - 1) - idx;   n #		if defined ( MULTINET ) || defined ( TCPWARE ) || defined ( FUSION ) || defined ( TWG ) || defined ( UCX )   1 		/* Read in the next buffer from the NNTP server  		 */ 5 	    len = recv( cxt->s, &cxt->buffer[idx], len, 0 );  	    if ( len == -1 ) 5 		raise_exception( PACKASM_RECVERR, 1, cxt->server );    #		else /* CMU */   1 		/* Read in the next buffer from the NNTP server  		 */ 9 	    status = SYS$QIOW( 0, cxt->s, TCP$READ, &iosb, 0, 0, . 			       &cxt->buffer[idx], len, 0, 0, 0, 0);, 	    if ( status & 1 ) status = iosb.status; 	    if ( !(status & 1) ) = 		raise_exception( PACKASM_RECVERR, 1, cxt->server, status );  	    len = iosb.bytcnt;  #		endif /* CMU */   	    cxt->len += len;  	    cxt->bptr = cxt->buffer; " 	    cxt->buffer[cxt->len] = '\0';7 	} while ( (p = strchr( cxt->bptr, '\012' )) == NULL );      }   8 	/* write Null character over CR and advance past the LF 	 */     *--p = '\0';     p += 2;      strcpy( buf, cxt->bptr );       cxt->len -= (p - cxt->bptr);     cxt->bptr = p;       return ( PACKASM_SUCCESS );  }    /*  *+-+   *   * Function: nntp_dnet_read_line  *  * Abstract:?  *	returns one line of input from the nntp server. This routine B  *	maintains a pointer and length to the last buffer read from theC  *	nntp server. If the buffer length is zero or only part of a line :  *	exists, then another read is posted to the nntp server;  *
  * Inputs:$  *	cxt -- pointer NNTP context block  *>  *	input -- pointer to user buffer to recieve next input line.  *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_t # nntp_dnet_read_line( void *context,  		     char *const buf ) {      IOSB iosb;       register status;     register char *p;      register size_t len, idx; !     register struct context *cxt;   $     cxt = (struct context *)context;  L     if ( !((cxt->len != 0) && ((p = strchr( cxt->bptr, '\012' )) != NULL)) )     {  	if ( cxt->len > 0 )& 	    strcpy( cxt->buffer, cxt->bptr );   	do  	{ 	    idx = cxt->len;- 	    len = (sizeof( cxt->buffer ) - 1) - idx;   , 	    cxt->rab.rab$l_ubf = &cxt->buffer[idx]; 	    cxt->rab.rab$w_usz = len;# 	    status = SYS$GET( &cxt->rab );  	    if ( !(status & 1) ) = 		raise_exception( PACKASM_RECVERR, 1, cxt->server, status );  	    len = cxt->rab.rab$w_rsz;;    	    cxt->len += len;  	    cxt->bptr = cxt->buffer; " 	    cxt->buffer[cxt->len] = '\0';7 	} while ( (p = strchr( cxt->bptr, '\012' )) == NULL );      }   8 	/* write Null character over CR and advance past the LF 	 */     *--p = '\0';     p += 2;      strcpy( buf, cxt->bptr );       cxt->len -= (p - cxt->bptr);     cxt->bptr = p;       return ( PACKASM_SUCCESS );  }    /*  *+-+   *  * Function: nntp_tcp_send_line   *  * Abstract:-  *	sends one line of input to the nntp server   *
  * Inputs:$  *	cxt -- pointer NNTP context block  *@  *	sndbuf	-- pointer to the buffer to be sent to the nntp server  *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_t " nntp_tcp_send_line( void *context,  		    const char *const msgbuf ) {      IOSB iosb;     char sndbuf[NNTP_C_BUFSIZ];        register status;!     register struct context *cxt;   $     cxt = (struct context *)context;  9 	/* add carriage return to the end of the line being sent  	 */,     sprintf( sndbuf, "%s\015\012", msgbuf );  q #	    if defined ( MULTINET ) || defined ( TCPWARE ) || defined ( FUSION ) || defined ( TWG ) || defined ( UCX )    * 	/* send specified line to the NNTP server 	 */:     if ( send( cxt->s, sndbuf, strlen( sndbuf ), 0 ) < 0 )4 	raise_exception( PACKASM_SENDERR, 1, cxt->server ); #	    else /* CMU */  * 	/* send specified line to the NNTP server 	 */?     status = SYS$QIOW ( 0, cxt->s, TCP$SEND, &iosb, NULL, NULL, ) 			sndbuf, strlen( sndbuf ), 0, 0, 0, 0); +     if ( status & 1 ) status = iosb.status;      if ( !(status & 1) )< 	raise_exception( PACKASM_SENDERR, 1, cxt->server, status );   #	    endif /* CMU */        return ( PACKASM_SUCCESS );  }    /*  *+-+   *   * Function: nntp_dnet_send_line  *  * Abstract:?  *	returns one line of input from the nntp server. This routine B  *	maintains a pointer and length to the last buffer read from theC  *	nntp server. If the buffer length is zero or only part of a line :  *	exists, then another read is posted to the nntp server;  *
  * Inputs:$  *	cxt -- pointer NNTP context block  *>  *	input -- pointer to user buffer to recieve next input line.  *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_t # nntp_dnet_send_line( void *context, ! 		     const char *const msgbuf )  {      IOSB iosb;     char sndbuf[NNTP_C_BUFSIZ];        register status;!     register struct context *cxt;   $     cxt = (struct context *)context;  9 	/* add carriage return to the end of the line being sent  	 */,     sprintf( sndbuf, "%s\015\012", msgbuf );        cxt->rab.rab$l_rbf = sndbuf;*     cxt->rab.rab$w_rsz = strlen( sndbuf );"     status = SYS$PUT( &cxt->rab );     if ( !(status & 1) )< 	raise_exception( PACKASM_SENDERR, 1, cxt->server, status );  $     status = SYS$FLUSH( &cxt->rab );     if ( !(status & 1) )< 	raise_exception( PACKASM_SENDERR, 1, cxt->server, status );       return ( PACKASM_SUCCESS );  }      /*  *+-+   *  * Function: nntp_tcp_connect   *  * Abstract:  *
  * Inputs:D  *	context -- pointer to a void pointer in which a context block can&  *		   and accessed by these routines.  *F  *	server -- pointer to a character string containing the server name.  *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_t ' nntp_tcp_connect( void **const context, ! 	      const char *const server )  {       char	buf[NNTP_C_BUFSIZ], *p;!     char	hostaddr[NNTP_C_BUFSIZ]; m #	if defined ( MULTINET ) || defined ( TCPWARE ) || defined ( FUSION ) || defined ( TWG ) || defined ( UCX )       struct	hostent *host;      struct	servent *serv;      struct	sockaddr_in sin;  #	else     IOSB	iosb; #	endif   !     register struct context *cxt;      register status;       LIB$ESTABLISH( handler );   8     cxt = (struct context *)calloc( 1, sizeof( *cxt ) );     if ( cxt == NULL )) 	raise_exception( PACKASM_INSVIRMEM, 0 );   m #	if defined ( MULTINET ) || defined ( TCPWARE ) || defined ( FUSION ) || defined ( TWG ) || defined ( UCX )    . 	/* Get the port number for the "nntp" service8 	 * Because UCX is brain dead, check -1 as a failure for 	 * getservbyname. WOW!  	 */-     memset( (char *)&sin, 0, sizeof( sin ) ); 6     serv = getservbyname( (char *)nntp, (char *)tcp );<     if ( (serv == NULL) || (serv = (struct servent *)(-1)) ) #	    ifdef NNTP_PORT # 	sin.sin_port = htons( NNTP_PORT ); 
 #	    else0 	raise_exception( PACKASM_CONNECTERR, 1, server,# 			 PACKASM_UNKNOWNSERV, 1, nntp );  #	    endif      else 	sin.sin_port = serv->s_port;   ' 	/* search host database for host name.  	 */+     host = gethostbyname( (char *)server );      if ( host == NULL )      { > 	    /* check for host address of the form [x.x.x.x] and strip= 	     * off the braces, so we only pass addresses of the form  	     * x.x.x.x  	     */ 	if ( server[0] == '[' ) 	{$ 	    strcpy( hostaddr, &server[1] );- 	    hostaddr[strlen( hostaddr ) - 1] = '\0';  	} 	else   	    strcpy( hostaddr, server );  <  	    /* host name not found, assume internet style address. 	     */ #ifdef TCPWARE. 	sin.sin_addr = inet_addr( (char *)hostaddr ); #else 5 	sin.sin_addr.s_addr = inet_addr( (char *)hostaddr );  #endif  	if ( sin.sin_addr.s_addr == -1)4 	    raise_exception( PACKASM_CONNECTERR, 1, server,) 			     PACKASM_UNKNOWNHOST, 1, server );  	sin.sin_family = AF_INET;     }      else     { # 	sin.sin_family = host->h_addrtype; 7 	memcpy( &sin.sin_addr, host->h_addr, host->h_length );      }   5 	/* create a communication endpoint for TCP/IP socket  	 * services 	 *//     cxt->s = socket( AF_INET, SOCK_STREAM, 0 );      if ( cxt->s < 0 ) 0 	raise_exception( PACKASM_CONNECTERR, 1, server,* 			 PACKASM_SOCKETERR, 0, SS$_NOSUCHDEV );  . 	/* create connection to the specified server. 	 */E     status = connect( cxt->s, (struct sockaddr *)&sin, sizeof(sin) );      if ( status < 0 ) 0 	raise_exception( PACKASM_CONNECTERR, 1, server, 			 PACKASM_CONNECTFAIL, 0 );    #	else /* CMU */  & 	/* Assign a channel to the CMU device 	 */     cxt->s = 0; J     status = SYS$ASSIGN( &cmudev, (unsigned short *)&cxt->s, NULL, NULL );     if ( !(status & 1) )0 	raise_exception( PACKASM_CONNECTERR, 1, server,% 			 PACKASM_CONNECTFAIL, 0, status );   . 	/* create connection to the specified server. 	 */>     status = SYS$QIOW( 0, cxt->s, TCP$OPEN, &iosb, NULL, NULL,) 		       server, NNTP_PORT, 0, 1, 0, 0 ); +     if ( status & 1 ) status = iosb.status;      if ( !(status & 1) )0 	raise_exception( PACKASM_CONNECTERR, 1, server,% 			 PACKASM_CONNECTFAIL, 0, status );  #	endif /* CMU */   ! 	/* get response from nntp server  	 */(     status = nntp_read_line( cxt, buf );     if ( !(status & 1) ) 	return ( status );a  1 	/* check status and display server name to user.m 	 */     status = atol( buf );l-     if ( (status != 200) && (status != 201) )s0 	raise_exception( PACKASM_CONNECTERR, 1, server, 			 PACKASM_INVSERVRESP, 0 );s  +     display( PACKASM_CONNECT, 1, &buf[4] );   - 	/* save the server name in out context blocki 	 */"     strcpy( cxt->server, server );  ; 	/* load context block pointer into external context block., 	 */     *context = cxt;p       return ( PACKASM_SUCCESS );r }t e /*  *+-+m  *  * Function: nntp_dnet_connect  *  * Abstract:  *
  * Inputs:D  *	context -- pointer to a void pointer in which a context block can&  *		   and accessed by these routines.  *F  *	server -- pointer to a character string containing the server name.  *  * Outputs:n  *	Nonet  *  * Returns:s.  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-n  */e
 static size_ti( nntp_dnet_connect( void **const context, 		   const char *const server )a { 5     static const char NNTP_object[] = "::\"0=NNTP\"";*     char buf[NNTP_C_BUFSIZ];       register status;     register char *p;t!     register struct context *cxt;s       LIB$ESTABLISH( handler );a  8     cxt = (struct context *)calloc( 1, sizeof( *cxt ) );     if ( cxt == NULL )) 	raise_exception( PACKASM_INSVIRMEM, 0 );   ; 	/* account for colons that may exist on a DECNET node namec 	 */%     if ( p = strstr( server, "::" ) )	 	*p == '\0';   	/* create decnet task namei 	 */A     sprintf( buf, "%s%s%s", server, authorization, NNTP_object );n  " 	/* set up the RMS data structures 	 */     cxt->fab = cc$rms_fab;     cxt->fab.fab$v_put = 1;      cxt->fab.fab$v_get = 1;*     cxt->fab.fab$l_fna = buf;n'     cxt->fab.fab$b_fns = strlen( buf );d  ) 	/* open DECNET connection to NNTP serverl 	 */#     status = SYS$OPEN( &cxt->fab );l     if ( !(status & 1) )0 	raise_exception( PACKASM_CONNECTERR, 1, server,- 			 cxt->fab.fab$l_sts, cxt->fab.fab$l_stv );d  ) 	/* Establish a stream to the NNTP server  	 */     cxt->rab = cc$rms_rab;#     cxt->rab.rab$l_fab = &cxt->fab;g&     status = SYS$CONNECT( &cxt->rab );     if ( !(status & 1) )     {i 	SYS$CLOSE( &cxt->fab );: 	raise_exception( PACKASM_CONNECTERR, 1, server, status );     }t  ! 	/* get response from nntp server[ 	 */(     status = nntp_read_line( cxt, buf );     if ( !(status & 1) ) 	return ( status );   1 	/* check status and display server name to user.  	 */     status = atol( buf );t-     if ( (status != 200) && (status != 201) ) 2 	raise_exception( PACKASM_CONNECTERR, 1, server );  +     display( PACKASM_CONNECT, 1, &buf[4] );   - 	/* save the server name in our context blockl 	 */"     strcpy( cxt->server, server );  ; 	/* load context block pointer into external context block.  	 */     *context = cxt;s       return ( PACKASM_SUCCESS );s }e   e /*  *+-+(  *"  * Function: nntp_select_newsgroup  *  * Abstract:0  *	This function selects the specified newsgroup  *
  * Inputs:G  *	context -- pointer to a void pointer which contains the NNTP contexte
  *		   block.n  *%  *	newsgroup -- pointer to newsgroup.e  *  * Outputs:   *	Nonei  *  * Returns:c.  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_tt+ nntp_select_newsgroup( void *const context, & 		       const char *const newsgroup ) { ,     static char group_select[NNTP_C_BUFSIZ];        char buf[NNTP_C_BUFSIZ], *q;     char const *p;  !     register struct context *cxt;s     register size_t status;t       LIB$ESTABLISH( handler );   $     cxt = (struct context *)context;  3 	/* convert to lower case, while formatting request  	 */%     strcpy( group_select, "GROUP " ); .     q = &group_select[strlen( group_select )];"     for ( p = newsgroup; *p; p++ ) 	*q++ = _tolower( *p );s     *q = '\0';   	/* send line to nntp server 	 */1     status = nntp_send_line( cxt, group_select );d     if ( !(status & 1) ) 	return ( status );   ! 	/* get response from nntp servere 	 */,     status = nntp_read_line( context, buf );     if ( !(status & 1) ) 	return ( status );   * 	/* Interpret status code from nntp server 	 */     status = atol( buf );e     if ( status == 411 )3 	raise_exception( PACKASM_NOTEXIST, 1, newsgroup );i  P     sscanf( &buf[4], "%d %d %d %s", &cxt->count, &cxt->first, &cxt->last, buf );  (     strcpy( cxt->newsgroup, newsgroup );       return ( PACKASM_SUCCESS );n }N   B /*  *+-+   *  * Function: nntp_scan_articlesC  *  * Abstract:@  *	This routine scans the specified newsgroups for subject linesD  *	that have names that match the specified package name. If a match>  *	is found the newsgroup and article number are passed to the  *	add_part_record function.  *
  * Inputs:G  *	context -- pointer to a void pointer which contains the NNTP contexti
  *		   block.t5  *	callback -- pointer to function to process subjectdB  *	callarg -- pointer to context block passed to callback function  *  * Outputs:*  *	Nonet  *  * Returns:n.  *	returns VMS status error or PACKASM_SUCCESS  *  * Special NotesA  *	This routine uses XHDR command which is not part of the rfc977o<  *	standard, but is implemented by the Berkeley NNTP server.  *-+-n  */t
 static size_tb( nntp_scan_articles( void *const context," 		    size_t (*const callback)( ), 		    const void *callarg )n {b     char buf[NNTP_C_BUFSIZ];     char header[NNTP_C_BUFSIZ];a      char subject[NNTP_C_BUFSIZ];     size_t code, artnum;,     size_t msgid, sublen, *date, datebuf[2];  !     register struct context *cxt;f     register size_t status;s       LIB$ESTABLISH( handler );n  $     cxt = (struct context *)context;   #	ifndef	NOXHDR L     (void) sprintf( header, "XHDR subject %ld-%ld", cxt->first, cxt->last );  / 	/* request article header from the NNTP serverO 	 */+     status = nntp_send_line( cxt, header );s     if ( !(status & 1) ) 	return ( status );(  ! 	/* get response from nntp serverx 	 */,     status = nntp_read_line( context, buf );     if ( !(status & 1) ) 	return ( status );a       code = atol( buf );I     if ( code >= 300 )6 	raise_exception( PACKASM_NOXHDRSUP, 1, cxt->server );       date = NULL;  2 	/* read header looking for subject and date lines 	 */     for ( ;; )     { ) 	status = nntp_read_line( context, buf );e 	if ( !(status & 1) )g 	    return ( status );f   	    /* check for last subject 	     *// 	if ( (strlen( buf ) == 1) && (buf[0] == '.') )- 	    break;P  # 	    /* parse returned subject line  	     */ 	msgid = atol( buf );p- 	strcpy( subject, (strchr( buf, ' ' ) + 1) );t     #	else /* NOXHDR */a       date = datebuf;C  ? 	/* select each article in the newsgroup, then try to determineo: 	 * if it this part of a package we are trying to extract. 	 */;     for ( msgid = cxt->first; msgid <= cxt->last; msgid++ )i     { % 	sprintf( header, "HEAD %d", msgid );   1 	    /* request article body from the NNTP servern 	     */( 	status = nntp_send_line( cxt, header ); 	if ( !(status & 1) )- 	    return ( status );c  % 	    /* get response from nntp server  	     */) 	status = nntp_read_line( context, buf );  	if ( !(status & 1) )i 	    return ( status );e  ( 	sscanf( buf, "%d %d", &code, &artnum );  ) 	    /* if article doesn't exist continuen 	     */ 	if ( code == 423 )s 	    continue;  * 	if ( (code != 221) || (artnum != msgid) )2 	    raise_exception( PACKASM_NOSUCHART, 3, msgid, 			     code, cxt->newsgroup );)  6 	    /* read header looking for subject and date lines 	     */ 	for ( ;; )	 	{- 	    status = nntp_read_line( context, buf );& 	    if ( !(status & 1) )t 		return ( status );  3 	    if ( (strlen( buf ) == 1) && (buf[0] == '.') ); 		break;  / 	    if ( strncmp( buf, "Subject: ", 9 ) == 0 )E 	    { 		strcpy( subject, &buf[9] );n 		continue;t 	    } 	}   #	endif	/* NOXHDR */   	    /* process subject line 	     */4 	status = callback( callarg, subject, msgid, date ); 	if ( !(status & 1) )0 	    continue;     }      return ( PACKASM_SUCCESS );e }R   a /*  *+-+   *!  * Function: nntp_extract_article=  *  * Abstract:E  *	This function locates specified part using the newsgroup and msgid;F  *	information specified by the user. and then calls a callback record  *	for each text record.  *
  * Inputs:  *  * Outputs:n  *	Nonet  *.  * Returns:                                   .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-t  */v
 static size_te* nntp_extract_article( void *const context,! 		      const unsigned int msgid,d$ 		      size_t (*const callback)( ), 		      const void *callarg )b {k     size_t code, artnum;%     char article_body[NNTP_C_BUFSIZ];n     char buf[NNTP_C_BUFSIZ];  !     register struct context *cxt;a$     register size_t status, retstat;       LIB$ESTABLISH( handler );e  $     cxt = (struct context *)context;  .     sprintf( article_body, "BODY %d", msgid );  - 	/* request article body from the NNTP serverz 	 */1     status = nntp_send_line( cxt, article_body );      if ( !(status & 1) ) 	return ( status );(  ! 	/* get response from nntp serverb 	 */,     status = nntp_read_line( context, buf );     if ( !(status & 1) ) 	return ( status );   +     sscanf( buf, "%d %d", &code, &artnum );e  -     if ( (code != 222) || (artnum != msgid) )a. 	raise_exception( PACKASM_NOSUCHART, 3, msgid, 			 code, cxt->newsgroup );Y  -     retstat = PACKASM_SUCCESS;			/* EML002 */   : 	/* read text records from the NNTP server and pass to the 	 * specified callback routine.  	 */     for ( ;; )     { ) 	status = nntp_read_line( context, buf );f 	if ( !(status & 1) )} 	    return ( status );-   	    /* must be done.) 	     *// 	if ( (strlen( buf ) == 1) && (buf[0] == '.') )p 	    break;   / 	if ( retstat == PACKASM_SUCCESS )	/* EML002 */, 	{' 	    status = callback( callarg, buf );r 	    if ( !(status & 1) )  		retstat = status;C 	}     }        return ( retstat );n }o n /*  *+-+d  *!  * Function: nntp_extract_articlel  *  * Abstract:E  *	This function locates specified part using the newsgroup and msgid*F  *	information specified by the user. and then calls a callback record  *	for each text record.  *
  * Inputs:  *  * Outputs:a  *	None   *  * Returns:S.  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-d  */t
 static size_ts" nntp_cleanup( void *const context,! 	      const unsigned int msgid )I {      unsigned int record_length;i!     register struct context *cxt;x     register size_t status;;       LIB$ESTABLISH( handler );e  $     cxt = (struct context *)context;       return ( PACKASM_SUCCESS );u };   /*  *+-+f  *   * Function: nntp_tcp_disconnect  *  * Abstract:G  *	nntp_disconnect contains code to shut down an open TCP/IP connection   *	with an NNTP_SERVER.   *
  * Inputs:G  *	context -- pointer to a void pointer which contains the NNTP contextD
  *		   block.r  *  * Outputs:e  *	None/  *  * Returns:i.  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */t
 static size_t&+ nntp_tcp_disconnect( void **const context )  {0     char buf[NNTP_C_BUFSIZ];  !     register struct context *cxt;(       LIB$ESTABLISH( handler );n  %     cxt = (struct context *)*context;   0 	/* notify the server to shutdown the connect on 	 * both ends. 	 */"     nntp_send_line( cxt, "QUIT" );  m #	if defined ( MULTINET ) || defined ( TCPWARE ) || defined ( FUSION ) || defined ( TWG ) || defined ( UCX ) p     shutdown( cxt->s, 2 ); #	else;     (void)SYS$QIOW( 0, cxt->s, TCP$CLOSE, NULL, NULL, NULL,o 	      2, 0, 0, 0, 0, 0 );     (void)SYS$DASSGN( cxt->s );d #	endifn  . 	/* free context block and set pointer to NULL 	 */     *context = NULL;     free( cxt );       return ( PACKASM_SUCCESS );. }* * /*  *+-+   *!  * Function: nntp_dnet_disconnectV  *  * Abstract:B  *	nntp_dnet_disconnect terminates the session with the NNTP sever  *
  * Inputs:G  *	context -- pointer to a void pointer which contains the NNTP contextd
  *		   block.I  *  * Outputs:t  *	None;  *  * Returns:r.  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_tt, nntp_dnet_disconnect( void **const context ) {      char buf[NNTP_C_BUFSIZ];  !     register struct context *cxt;=       LIB$ESTABLISH( handler );=  %     cxt = (struct context *)*context;   0 	/* notify the server to shutdown the connect on 	 * both ends. 	 */"     nntp_send_line( cxt, "QUIT" );       SYS$CLOSE( &cxt->fab );   . 	/* free context block and set pointer to NULL 	 */     *context = NULL;     free( cxt );       return ( PACKASM_SUCCESS );  }* * /*  *+-+*  *$  * Function: load_nntp_tcp_addresses  *  * Abstract:B  *	this routine loads the addresses of the tcp based NNTP routines"  *	into global function varaibles.  *
  * Inputs:  *	None-  *  * Implicit Inputs:t  *	pack_connecth  *	select_articles  *	scan_articles  *	extract_articles   *	cleanup_articlesu
  *	disconnectA  *  * Outputs:*2  *	global function	pointer to mail routines loaded  *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-_  */Z size_t load_nntp_tcp_routines( )F {]$     pack_connect = nntp_tcp_connect;,     select_articles = nntp_select_newsgroup;'     scan_articles = nntp_scan_articles;t,     extract_articles = nntp_extract_article;$     cleanup_articles = nntp_cleanup;%     disconnect = nntp_tcp_disconnect;r(     nntp_send_line = nntp_tcp_send_line;(     nntp_read_line = nntp_tcp_read_line;       return ( PACKASM_SUCCESS );, }z ( /*  *+-+   *'  * Function: load_nntp_decnet_addressesK  *  * Abstract:B  *	this routine loads the addresses of the tcp based NNTP routines"  *	into global function varaibles.  *
  * Inputs:  *	Noneh  *  * Implicit Inputs:t  *	pack_connecte  *	select_articles  *	scan_articles  *	extract_articless  *	cleanup_articles/
  *	disconnectc  *  * Outputs:z2  *	global function	pointer to mail routines loaded  *  * Returns:;.  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-)  */	 size_t load_nntp_dnet_routines( ) {t%     pack_connect = nntp_dnet_connect;e,     select_articles = nntp_select_newsgroup;'     scan_articles = nntp_scan_articles;n,     extract_articles = nntp_extract_article;$     cleanup_articles = nntp_cleanup;&     disconnect = nntp_dnet_disconnect;)     nntp_send_line = nntp_dnet_send_line; )     nntp_read_line = nntp_dnet_read_line;        return ( PACKASM_SUCCESS );  }f