 /*E ** Copyright  1993, 1994 by Eric M. LaFranchi.  All Rights Reserved.  **J ** This software is Copyright 1993, 1994 by Eric M. LaFranchi.  PermissionJ ** to use, copy, and freely redistributed this software in its entirety isC ** hereby granted provided that the above copyright notice and this L ** permission notice are retained.  This software may not be sold for profitF ** or incorporated in commercial software products without the writtenK ** permission of the author.  This software is provided "as is", the author L ** nor his employer make any representation of warranty, express or implied,J ** with respect to any code or other information herein.  In addition, theI ** author disclaim's any liability whatsoever for any use of such code or  ** other information.  **   **+-+  ** ** MODULE: VMS_HANDLER.C ** ** ABSTRACT:= **	This module contains is a generic exception/signal handler B **	"handler()". The handler will field VMS exceptions and softwareB **	conditions (signals.) Signals and exceptions are handled in the **	following manner: **B **	FATAL SEVERITY codes. These are unrecoverable errors that cause **	the application to abort. **H **	ERROR SEVERITY codes. These are recoverable errors, but have the sideH **	effect of unwinding the call frames back to the to the establisher ofG **	the handler. The error status is returned back to the establisher of  **	the handler.  **  I **	WARNING SEVERITY codes. These are fully recoverable errors. The errors F **	are logged by the exception handler and then execution is continuedJ **	from the place that incurred the exception. (processing continues where **	it left off.) **F **	INFORMATIONAL SEVERITY codes. These are not error conditions, these9 **	are simply messages given to the user in some fashion.  ** ** ENVIRONMENT:  **	OpenVMS operating system. **
 ** AUTHOR: **	Eric M. LaFranchi ** ** CREATION DATE:  **	12-oct-1990 ** ** MODIFICATION HISTORY: ** **-+-  */= #include <chfdef.h>			/* Condition handling facility defs  */ > #include <descrip.h>			/* VMS string descriptor definitions *// #include <rms.h>			/* RMS definitions 		     */ < #include <ssdef.h>			/* VMS system service definitions    */< #include <stddef.h>			/* standard C type definitions	     */= #include <stsdef.h>			/* system service failure and status */ > #include <varargs.h>			/* variable argument definitions     */ #include "vmsdef.h"   % size_t	LIB$CALLG( void *const, ... ); % void	LIB$SIGNAL( const size_t, ... ); % void	SYS$PUTMSG( const void *, ... ); 8 void	SYS$UNWIND( const void *const, const void *const );  L     /* This is a copy of the system message vector that exists in the moduleM      * [...SYS.LIS]SYSPUTMSG.LIS, although its structure is slighty different I      * that better align the data. It contains system error codes and the (      * number of FAO arguments each has.      */  static const struct exceptable { 5     unsigned short message;		/* message number.    */ 4     unsigned short faocnt;		/* fao argument count */F } msgvec[] = { { SS$_ACCVIO, 4 },	/* Access violation - 4 arguments */< 	       { SS$_MCHECK, 2 },	/* Machine check - 2 arguments */G 	       { SS$_ASTFLT, 6 },	/* AST delivery stack fault - 6 arguments */ > 	       { SS$_BREAK, 2 },	/* Breakpoint fault - 2 arguments */J 	       { SS$_CMODSUPR, 3 },	/* Change mode to supervisor trap - 3 args */I 	       { SS$_CMODUSER, 3 },	/* Change mode to user trap - 3 arguments */ G 	       { SS$_COMPAT, 3 },	/* Compatibility mode fault - 3 arguments */ G 	       { SS$_OPCCUS, 2 },	/* Opcode reserved to user fault - 2 args */ F 	       { SS$_OPCDEC, 2 },	/* Opcode reserved to DEC fault - 2 args */@ 	       { SS$_PAGRDERR, 4 },	/* Page read error - 4 arguments */I 	       { SS$_RADRMOD, 2 },	/* Reserved addressing fault - 2 arguments */ F 	       { SS$_ROPRAND, 2 },	/* Reserved operand fault - 2 arguments */E 	       { SS$_SSFAIL, 3 },	/* System service failure - 3 arguments */ ? 	       { SS$_TBIT, 2 },		/* TBIT pending trap - 2 arguments */ 8 	       { SS$_DEBUG, 2 },	/* Debug trap - 2 arguments */? 	       { SS$_ARTRES, 2 },	/* Arithmetic trap, reserved trap */ B 	       { SS$_INTOVF, 2 },	/* Arithmetic trap, integer overflow */H 	       { SS$_INTDIV, 2 },	/* Arithmetic trap, integer divide by zero */C 	       { SS$_FLTOVF, 2 },	/* Arithmetic trap, floating overflow */ Q 	       { SS$_FLTDIV, 2 },	/* Arithmetic trap, floating/decimal divide by zero */ D 	       { SS$_FLTUND, 2 },	/* Arithmetic trap, floating underflow */B 	       { SS$_DECOVF, 2 },	/* Arithmetic trap, decimal overflow */H 	       { SS$_SUBRNG, 2 },	/* Arithmetic trap, subscript out of range */F 	       { SS$_FLTOVF_F, 2 },	/* Arithmetic fault, floating overflow */T 	       { SS$_FLTDIV_F, 2 },	/* Arithmetic fault, floating/decimal divide by zero */G 	       { SS$_FLTUND_F, 2 },	/* Arithmetic fault, floating underflow */ H 	       { SS$_INHCHMK, 3 },	/* Inhibited CHMKernel trap - 3 arguments */J 	       { SS$_INHCHME, 3 }	/* Inhibited CHMExecutive trap - 3 arguments */ #ifdef	SS$_VARITH G 	       ,{ SS$_VARITH, 4 },	/* Vector arithmetic fault - 4 arguments */ L 	       { SS$_ILLVECOP, 3 },	/* Illegal vector opcode fault - 3 arguments */K 	       { SS$_VECALIGN, 4 },	/* Vector alignment exception - 4 arguments */ G 	       { SS$_VECDIS, 3 }	/* Vector disabled exception - 3 arguments */  #endif 				 };                        /*  *+-+   *  * FUNCTION: inhib_msg( )   *  * ABSTRACT:A  *	This routine scans the signal array and sets the inhib message ?  *	bit for all signals in the array. If the exception was a VMS E  *	system message the database pointed to by EXE$EXCEPTION is scanned '  *	to determine the fao argument count.   *  * PARAMETERS:B  *	inhib_msg takes a single argument pointing to the signal array.  *  * RETURNS: !  *	This function returns nothing.   *  *-+-   */  static void 2 inhib_msg( struct chf$signal_array *signal_array ) { 2     register unsigned int facility, *signal, temp;$     register unsigned int msgveclen;     register int sig_args;  ,     sig_args = signal_array->chf$l_sig_args;*     signal = (unsigned int *)signal_array;?     msgveclen = sizeof( msgvec ) / sizeof( struct exceptable );   1     signal++;					/* advance to signal name    */   <     while ( sig_args > 2 )			/* loop until no more args   */     { ( 	facility = $VMS_STATUS_FAC_NO(*signal);$ 	if ( facility == SYSTEM$_FACILITY ) 	{ 	    register unsigned long i;    	    *signal |= STS$M_INHIB_MSG;& 	    for ( i = 0; i < msgveclen; i++ ) 	    {9 		if ( $VMS_STATUS_MSG_NO(*signal) == msgvec[i].message )  		{ - 		    temp = (unsigned long)msgvec[i].faocnt;  		    signal += temp;  		    sig_args -= temp;  		    break; 		}  	    } 	    signal++; 	    --sig_args; 	    continue; 	}  ! 	if ( facility == RMS$_FACILITY )  	{  	    *signal |= STS$M_INHIB_MSG; 	    --sig_args;' 	    if ( *signal++ & RMS$V_STVSTATUS )  	    { 		*signal++ |= STS$M_INHIB_MSG; 
 		--sig_args;  	    } 	    continue; 	}   	*signal++ |= STS$M_INHIB_MSG; 	temp = *signal++; 	signal += temp; 	sig_args -= (temp + 2);     }      return;  }    /*  *+-+   *  * Function: handler  *  * Abstract:>  *	handler is the generic exception/signal handler. It handlesB  *	application specific software conditions (signals.) The handlerE  *	is enabled with the VMS run time library routine LIB$ESTABLISH( ).   *
  * Inputs:D  *	handler will have two parameters. The address of the signal arrayD  *	and mechanism arrays. See Section 4 of the VMS RTL library (LIB$);  *	manual for a description of signal and mechanism arrays.   *  * Returns: =  *	If the exception/signal is sever, the resignal to an outer D  *	mode handler after outputting the message and logging informationA  *	about the exception. Otherwise the exception is dismissed with '  *	the exception status returned in r0.   *  * Side Effects:D  *	Call frames are unwound off from the stack if the severity of the  *	exception was error.   *  *-+-   */ 
 static size_t < vms_handler( register struct chf$signal_array *signal_array,2 	     register struct chf$mech_array *mech_array ) {      register size_t severity;   + 	/* If unwinding stack then simply resignal  	 */5     if ( signal_array->chf$l_sig_name == SS$_UNWIND )  	return ( SS$_RESIGNAL );   6 	/* Adjust count of fao arguments then output message. 	 */&     signal_array->chf$l_sig_args -= 2;7     (void)SYS$PUTMSG( signal_array, NULL, NULL, NULL ); &     signal_array->chf$l_sig_args += 2;   	/* inhibit writing of message.  	 */$     (void)inhib_msg( signal_array );  . 	/* extract severity code from message string. 	 */D     severity = $VMS_STATUS_SEVERITY( signal_array->chf$l_sig_name );       return ( severity ); }   
 static size_t 5 local_handler( struct chf$signal_array *signal_array, + 	       struct chf$mech_array *mech_array )  { "     static const size_t depth = 3;     register size_t severity;   7     severity = vms_handler( signal_array, mech_array );   5 	/* if the exception was a severe error then resignal > 	 * if the exception was an error, unwind the stack and return8 	 * to the caller that established the exception handler6 	 * if the exception was a warning, continue execution 	 */#     if ( severity == STS$K_SEVERE )  	return ( SS$_RESIGNAL );   "     if ( severity == STS$K_ERROR )     {  #	    ifdef __ALPHA < 	mech_array->chf$q_mch_savr0 = signal_array->chf$l_sig_name; #	    else /* __ALPHA */< 	mech_array->chf$l_mch_savr0 = signal_array->chf$l_sig_name; #	    endif /* __ALPHA */  	SYS$UNWIND( &depth, NULL );     }        return ( SS$_CONTINUE ); }    size_t/ handler( struct chf$signal_array *signal_array, % 	 struct chf$mech_array *mech_array )  {      register size_t severity;   7     severity = vms_handler( signal_array, mech_array );   5 	/* if the exception was a severe error then resignal > 	 * if the exception was an error, unwind the stack and return8 	 * to the caller that established the exception handler6 	 * if the exception was a warning, continue execution 	 */#     if ( severity == STS$K_SEVERE )  	return ( SS$_RESIGNAL );   "     if ( severity == STS$K_ERROR )     {  #	    ifdef __ALPHA < 	mech_array->chf$q_mch_savr0 = signal_array->chf$l_sig_name; #	    else /* __ALPHA */< 	mech_array->chf$l_mch_savr0 = signal_array->chf$l_sig_name; #	    endif /* __ALPHA */  	SYS$UNWIND( 0, NULL );      }        return ( SS$_CONTINUE ); }      /*  * Function:  *	raise_exception  *  * Abstract:?  *	The functions signals exceptions and abstracts the VMS stuff   *	from the reset of the code.  *
  * Inputs:B  *	This routine takes variable number of arguments, but is assumed!  *	to have at least one argument.   *  * Outputs:   *	None   *  * Return Value:  *	status value   *  * Special Notes: <  *	This routine makes some assumptions about the way OpenVMS  *	handles exceptions.  *  */  void- raise_exception( const size_t va_alist, ... )  {   
     struct     {  	size_t argcnt;  	void *arg[255];
     } arglst;        register size_t cnt;       va_list ap;      va_count( arglst.argcnt );     va_start( ap );   /     for ( cnt = 0; cnt < arglst.argcnt; cnt++ ) ( 	arglst.arg[cnt] = va_arg( ap, void * );       va_end( ap );   #     LIB$ESTABLISH( local_handler );   %     LIB$CALLG( &arglst, LIB$SIGNAL );        return ; }      /*  * Abstract:.  *	Display informational messages to the user.  *
  * Inputs:D  *	This routine builds a message vector and calls the $PUTMSG system"  *	service to display the message.  *  * Outputs:   *	None   *  * Return Value:  *	status value   *  * Special Notes:   *	What a kludge, for now!<  *	This routine makes assumptions about the specified input.<  *	The first fao argument is assumed to be a string and the )  *	two remaining are expected to integers   *  */  void% display( const size_t va_alist, ... )  { 
     struct     {  	unsigned short	argcnt;  	unsigned short	msg_opt; 	unsigned int	msg_cod; 	unsigned short	fao_cnt; 	unsigned short	new_opt; 	void *fao[8];
     } msgvec;        size_t argcnt, faocnt;      register size_t signal, cnt;       va_list ap;        va_count( argcnt );      va_start( ap );   "     signal = va_arg( ap, size_t );       if ( argcnt >= 2 )     {  	faocnt = va_arg( ap, size_t ); % 	for ( cnt = 0; cnt < faocnt; cnt++ ) , 	    msgvec.fao[cnt] = va_arg( ap, void * );     }        va_end( ap );   5 	/* build message vector and give message to the user  	 */     msgvec.argcnt = argcnt;      msgvec.msg_opt = 0;      msgvec.msg_cod = signal;     msgvec.fao_cnt = faocnt;     msgvec.new_opt = 0;   )     SYS$PUTMSG( &msgvec, NULL, NULL, 0 );  } 