 /*E ** Copyright  1993, 1994 by Eric M. LaFranchi.  All Rights Reserved.  **J ** This software is Copyright 1993, 1994 by Eric M. LaFranchi.  PermissionJ ** to use, copy, and freely redistributed this software in its entirety isC ** hereby granted provided that the above copyright notice and this L ** permission notice are retained.  This software may not be sold for profitF ** or incorporated in commercial software products without the writtenK ** permission of the author.  This software is provided "as is", the author L ** nor his employer make any representation of warranty, express or implied,J ** with respect to any code or other information herein.  In addition, theI ** author disclaim's any liability whatsoever for any use of such code or  ** other information.  **   **+-+  ** ** Module: VMS_MISC  ** ** Abstract:B **	This module includes some misc functions that use of some hairyE **	coding practices and depend on VMS services, in addition to making D **	use of some of the architectural features of VMS (i.e. VMS binary **	time format). **
 ** Author: **	Eric M. LaFranchi ** ** Creation Date:  **	23-APR-1993 ** ** Modification History: ** **-+-  */ #include <ctype.h>@ #include <climsgdef.h>			/* Command definition utility symbols*/< #include <descrip.h>			/* VMS descriptor definitions	     */= #include <jpidef.h>			/* $GETJPI system service definitions*/ 5 #include <rms.h>			/* Include RMS definitions	     */ 9 #include <stdio.h>			/* Standard I/O definitions.	     */ = #include <stdlib.h>			/* Standard library definitions.     */ = #include <string.h>			/* Standard string definitions.      */ : #include <ssdef.h>			/* Standard VMS messages code	     */; #include <strdef.h>			/* str$ routines status codes	     */ ; #include <smgdef.h>			/* smg$ routines status codes	     */  #include "packdef.h" #include "msgdef.h"  #include "vmsdef.h"      /*  *++  * Function: get_username( )  *  * Abstract:<  *	this routine get the username for the current process and&  *	returns it in the specified buffer.  *
  * Inputs:(  *	username - pointer to username buffer%  *	userlen - size of username buffer.   *  * Outputs: ?  *	writes the username of the current process into the username 
  *	buffer.  *  * Return Value:  *	VMS status code  *  *--  */  size_t# get_username( char *const username,  	      const size_t userlen )  { B     static ITMLST useritem[] = { { 0, JPI$_USERNAME, NULL, NULL }, 				 { 0, 0, NULL, NULL } };     register size_t status;   !     useritem[0].buflen = userlen; "     useritem[0].bufadr = username;  F     status = SYS$GETJPIW( 0, NULL, NULL, useritem, NULL, NULL, NULL );     if ( !( status & 1 )  )  	return ( status );        return ( PACKASM_SUCCESS );  }      /*  *++  * Function: ask_user( )  *  * Abstract:E  *	prompts the user with specified question, validates the answer and "  *	returns a TRUE or FALSE answer.  *
  * Inputs:+  *	prompt - pointer to error message string G  *	defans - pointer to default answer -- must be (Y(es),N(o),T(rue), or   *		 F(alse)  *  * Outputs:   *	None   *  * Return Value:  *	VMS status code  *  *--  */  size_t# ask_user( const char *const prompt,  	  const char *const defans )  { #     static $DESCALLOC( promptdsc );      static $DESCALLOC( indsc );      char tmpstr[128], buf[32];     unsigned short int length;       register char *cp;&     register unsigned int status, tmp;  8     sprintf( tmpstr, "%s ? [%c]: ", prompt, defans[0] );#     $DESCINIT( promptdsc, tmpstr ); +     $DESCFILL( indsc, sizeof( buf ), buf );      for ( ;; )     { ! 	    /* prompt user and get input  	     */7 	status = LIB$GET_INPUT( &indsc, &promptdsc, &length ); - 	if ( !(status & 1) && (status != RMS$_EOF) )  	    raise_exception( status );  		    1 	    /* If return key pressed, use default answer  	     */- 	if ( (length == 0) && (status != RMS$_EOF) )  	    buf[0] = (char)defans[0];  / 	    /* convert usable user input to upper case  	     */ 	tmp = *((long *)buf); 	tmp &= ~0x20202020;  5 	    /* take action if user specified a valid answer, ( 	     * otherwise assume invalid answer. 	     */ #	pragma nostandard  	switch ( tmp )  	{ 	    case '\020\0\0\0':  	    case 'N\0\0\0': 	    case 'NO\0\0':  	    case 'F\0\0\0': 	    case 'FA\0\0':  	    case 'FAL\0': 	    case 'FALS':  		return( PACKASM_FALSANS );   	    case '\021\0\0\0':  	    case 'Y\0\0\0': 	    case 'YE\0\0':  	    case 'YES\0': 	    case 'T\0\0\0': 	    case 'TR\0\0':  	    case 'TRU\0': 	    case 'TRUE':  		return( PACKASM_SUCCESS );   	    case '\0\0\0\0':  	    case 'Q\0\0\0': 	    case 'QU\0\0':  	    case 'QUI\0': 	    case 'QUIT':  		SYS$EXIT( PACKASM_SUCCESS );   	    case 'A\0\0\0': 	    case 'AL\0\0':  	    case 'ALL\0': 		return( PACKASM_NOCONFIRM );  
 	    default: 6 		raise_exception( PACKASM_INVALANS, 2, length, buf ); 	} #	pragma standard      }  }      /*  * Function: get_input( )   *  * Abstract:6  *	This routine gets command line input from the user.  *
  * Inputs:.  *	input -- pointer to input string descriptor0  *	prompt -- pointer to prompt string descriptor.  *	retlen -- pointer to return length argument  *  * Outputs:   *	None   *  * Return Value:  *	status value   *  * Special Notes: D  *	This function takes arguments in the same format as LIB$GET_INPUT  *  */  size_t0 get_input( struct dsc$descriptor_s *const input,0 	   const struct dsc$descriptor_s *const prompt," 	   unsigned short *const retlen ) { $     static void *keyboard_id = NULL;%     static void *key_table_id = NULL;        register status;       if ( keyboard_id == NULL )     { 6 	status = SMG$CREATE_VIRTUAL_KEYBOARD( &keyboard_id ); 	if ( !(status & 1) ) 5 	    raise_exception( PACKASM_INTERNERR, 0, status );      }        if ( key_table_id == NULL )      { 0 	status = SMG$CREATE_KEY_TABLE( &key_table_id ); 	if ( !(status & 1) ) 5 	    raise_exception( PACKASM_INTERNERR, 0, status );      }   A     status = SMG$READ_COMPOSED_LINE( &keyboard_id, &key_table_id, ! 				     input, prompt, retlen );      if ( status == SMG$_EOF )  	return ( RMS$_EOF );        if ( !(status & 1) ) 	raise_exception( status );        return ( PACKASM_SUCCESS );  }      /*  * Abstract:>  *	routine to convert the before and since times from the user-  *	specified input to VMS binary time format.   *
  * Inputs:<  *	ascii_time -- pointer to string containing vms ASCII timeH  *	binary_time -- pointer to array an of two long words to get converted+  *		       use specified command line times   *  * Outputs:   *	None   *  * Return Value:  *	status value   *  */  size_t+ convert_time( const char *const ascii_time, ( 	      unsigned int *const binary_time ) {       static $DESCALLOC( timbuf );       char tmpbuf[32];#     unsigned int timadr[2], status;   = 	/* if no time to convert, set converted time zero and return  	 */4     if ( ascii_time == NULL || *ascii_time == '\0' )     { % 	binary_time[0] = binary_time[1] = 0;  	return ( PACKASM_SUCCESS );     }   ,     $DESCINIT( timbuf, (char *)ascii_time );  2     return ( SYS$BINTIM( &timbuf, binary_time ) ); }      /*  *+-+   * Abstract:B  *	Compare delivery date against the date of the time specified in@  *	the before and since qualifier. If the delivery date is afterB  *	the before time or before the since time, an error is returned,   *	otherwise success is returned  *
  * Inputs::  *	delivery_date -- pointer to VMS quadword time test date  *5  *	before_date -- pointer to VMS quadword before time   *3  *	since_date -- pointer to VMS quadword since time   *  * Outputs:   *	None   *  * Return Value:  *	status value   *  * Special Notes: ,  *	This routine only compares absolute time.  *-+-   */  size_t6 compare_time( const unsigned int *const delivery_date,- 	      const unsigned int *const before_date, - 	      const unsigned int *const since_date )  { 2 	/* if a time isn't specified, then assume success 	 */      if ( delivery_date == NULL ) 	return ( PACKASM_SUCCESS );  N     if ( before_date != NULL && (before_date[0] != 0 || before_date[1] != 0) )     { , 	if ( (delivery_date[1] > before_date[1]) ||4             ((delivery_date[1] == before_date[1]) &&. 	     (delivery_date[0] >= before_date[0])) ||; 	    ((delivery_date[0] == 0) && (delivery_date[1] == 0)) )  	return ( PACKASM_INVALDATE );     }   K     if ( since_date != NULL && (since_date[0] != 0 || since_date[1] != 0) )      { + 	if ( (delivery_date[1] < since_date[1]) || 3             ((delivery_date[1] == since_date[1]) && - 	     (delivery_date[0] < since_date[ 0 ])) ) " 	    return ( PACKASM_INVALDATE );     }        return ( PACKASM_SUCCESS );  }    /*  *+-+   *  * Function: compare_string   *  * Abstract:D  *	Compares the candidate string against the pattern string. If theyC  *	match, then success is returned, otherwise, failure is returned.   *
  * Inputs::  *	candidate -- pointer to string candidate for comparison6  *	pattern -- pointer to string pattern for comparison  *  * Outputs: 
  *    None  *  * Return Value:'  *	PACKASM_SUCCESS if the strings match ,  *	PACKASM_NOMATCH if the string don't match  *-+-   */  size_t, compare_string( const char *const candidate, 		const char *const pattern )  { %     static $DESCALLOC( pattern_dsc ); '     static $DESCALLOC( candidate_dsc );        char pack_candidate[256];        register char *q;      register char const *p;      register size_t status;   : 	/* upper case the package name retrieved from the subject 	 * string.  	 */:     for ( p = candidate, q = pack_candidate; *p; p++,q++ ) 	*q = _toupper( *p );      *q = '\0';  .     $DESCINIT( pattern_dsc, (char *)pattern );/     $DESCINIT( candidate_dsc, pack_candidate );    	/* compare the strings  	 */<     status = STR$MATCH_WILD( &candidate_dsc, &pattern_dsc );!     if ( status == STR$_NOMATCH )  	return ( PACKASM_NOMATCH );  ! 	/* strings match, return success  	 */     return ( PACKASM_SUCCESS );  }    /*  *+-+   *  * Function: make_file  *  * Abstract:F  *	This routine builds a filename specification string. If the defaultD  *	string only contains a directory specification, then the filenameC  *	specification is contcatenated. If the filename does not have an 1  *	extention, the the default extention is added.   *
  * Inputs:9  *      defspec -- pointer to default file specification. 4  *      defext -- pointer to default file extention./  *	filenam -- pointer to filename specification /  *	outfil -- pointer to receive output filename   *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */  size_t% make_file( const char *const defspec,  	   const char *const defext,  	   const char *const filenam, 	   char *const outfil ) {      char esa[NAM$C_MAXRSS];      char tmp[256+1];     struct FAB fab;      struct NAM nam;        register char *p; "     register size_t status, i = 0;  " 	/* initialize RMS data structures 	 */     nam = cc$rms_nam;      nam.nam$l_esa = esa;!     nam.nam$b_ess = NAM$C_MAXRSS;      fab = cc$rms_fab;      fab.fab$l_nam = &nam;      fab.fab$l_fop = FAB$M_NAM;  4     if ( (defspec == NULL) || (defspec[0] == '\0') ) 	strcpy( tmp, "[]" );      else 	strcpy( tmp, defspec );  D 	/* check default name specification for validity, and completeness.A 	 * if it doesn't contain a file specification, the the file name  	 * in and try again.  	 */     do     {  	fab.fab$l_fna = tmp;  	fab.fab$b_fns = strlen( tmp );    	status = SYS$PARSE( &fab ); 	if ( !(status & 1) )  	{% 	    strcpy( outfil, "UNKNOWN.TMP" );   	    return ( PACKASM_SUCCESS ); 	}  E 	if ( nam.nam$l_fnb & (NAM$M_EXP_NAME|NAM$M_EXP_TYPE|NAM$M_EXP_VER) )  	    break;    	strcat( tmp, filenam );     } while ( ++i < 2 );  2 	/* extract constructed string into output buffer. 	 */     p = outfil;   , 	/* copy device anme directory specification 	 */G     strncpy( p, (char *)nam.nam$l_dev, nam.nam$b_dev + nam.nam$b_dir ); )     p += (nam.nam$b_dev + nam.nam$b_dir);        if ( nam.nam$b_name != 0 )     { 6 	strncpy( p, (char *)nam.nam$l_name, nam.nam$b_name ); 	p += nam.nam$b_name;      }      else     {  	strncpy( p, "UNKNOWN", 7 ); 	p += 7;     }        if ( nam.nam$b_type > 1 )      { 6 	strncpy( p, (char *)nam.nam$l_type, nam.nam$b_type ); 	p += nam.nam$b_type;  	*p = '\0';      }      else 	strcpy( p, defext );        return ( PACKASM_SUCCESS );  }    /*  *+-+   *  * Function: get_value  *  * Abstract:F  *	This routine determines if the command line argument is present. IfF  *	it's present, it gets the value associated with argument, otherwise  *	no value is returned.  *
  * Inputs:*  *	entity_desc -- pointer to entity string6  *	retbuf -- pointer to string buffer to receive value$  *	bufsiz -- size of retbuf argument  *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */  size_t$ get_value( const char *const entity, 	   char *const retbuf,  	   const size_t buflen )  { %     static $DESCALLOC( entity_desc );       static $DESCALLOC( tmpdsc );     register status;     register len = 0;        LIB$ESTABLISH( handler );   - 	/* set buffer empty in case exception occurs  	 */     retbuf[0] = '\0';   @ 	/* If a list of folders is specified, get the list and put into 	 * comma separated string.  	 */%     $DESCINIT( entity_desc, entity ); )     status = CLI$PRESENT( &entity_desc );   !     if ( status == CLI$_PRESENT )      {  	register stat;    	for ( ;; )  	{5 	    $DESCFILL( tmpdsc, buflen - len, &retbuf[len] ); 1 	    stat = CLI$GET_VALUE( &entity_desc, &tmpdsc,  				  &tmpdsc.dsc$w_length ); ( 	    if ( !(stat & 1) ) return ( stat );  	    len += tmpdsc.dsc$w_length; 	    if ( stat != CLI$_COMMA ) 		break; 	    retbuf[len++] = ',';  	}     }        retbuf[len] = '\0';        return ( status ); }    /*  *+-+   *  * Function: present  *  * Abstract:E  *	The routine test for the presents of a qualifier is on the command *  *	line and return the status accordingly.  *
  * Inputs:%  *	entity -- pointer to entity string   *  * Outputs:   *	None   *  * Returns: ,  *	returns the return value from CLI$PRESENT  *  *-+-   */  size_t# present( const char *const entity )  { %     static $DESCALLOC( entity_desc );    	/* establish exception handler  	 */$     LIB$ESTABLISH( LIB$SIG_TO_RET );  %     $DESCINIT( entity_desc, entity );   +     return ( CLI$PRESENT( &entity_desc ) );  }	