!++
!   DESCRIP.MMS
!
!   MMS/MMK description file for building WATCHER.
!
!   Copyright  1994,1999 MadGoat Software.  All rights reserved.
!
!   To build WATCHER using MMS on OpenVMS AXP, use the command
!
!   	$ MMS/MACRO=__AXP__=1
!
!   MMK automatically defines this macro on AXP systems.
!
!-   

.IFDEF __MADGOAT_BUILD__
.IFDEF __AXP__
MG_VMSVER   	= V6
.ENDIF
.IFDEF __VAX__
MG_VMSVER   	= V543
.ENDIF
MG_FACILITY 	= WATCHER
KITNAME	    	= $(MG_FACILITY).ZIP
PRIMARY_TARGET	= ALL
.INCLUDE MG_TOOLS:HEADER.MMS
.ELSE
ETCDIR =
KITDIR =
.IFDEF __AXP__
ARCH = AXP
OPT  = .ALPHA_OPT
L32  = .L32E
.ELSE
ARCH = VAX
OPT  = .OPT
L32  = .L32
.ENDIF
.SUFFIXES : $(L32) .R32
.R32$(L32) :
    $(BLISS)/LIB=$(MMS$TARGET) $(MMS$SOURCE)
.IFDEF __MMK_V32__
BINDIR = SYS$DISK:[.BIN-$(ARCH)]
.FIRST
    @ IF F$PARSE("$(BINDIR)") .EQS. "" THEN CREATE/DIR $(BINDIR)
    @ DEFINE/NOLOG BIN_DIR $(BINDIR)
{}.R32{}$(L32) :
    $(BLISS)/LIB=$(MMS$TARGET) $(MMS$SOURCE)
{}.B32{$(BINDIR)}.OBJ :
    $(BLISS)$(BFLAGS) $(MMS$SOURCE)
{}.MSG{$(BINDIR)}.OBJ :
    $(MESSAGE) $(MSGFLAGS) $(MMS$SOURCE)
{}.CLD{$(BINDIR)}.OBJ :
    $(SETCMD) $(SETCMDFLAGS) $(MMS$SOURCE)
.ELSE
BINDIR =
.FIRST
    @ DEFINE/NOLOG BIN_DIR SYS$DISK:[]
.ENDIF
.ENDIF

.IFDEF __I64__
REGMAP = /ALPHA_REGISTER_MAPPING
.ELSE
REGMAP =
.ENDIF
.IFNDEF __VAX__
SYSEXE = /SYSEXE
MCH = /NOMACHINE
CHK = /CHECK=ALIGN
.IFDEF DBG
OPTIM = /NOOPT
.ENDIF
.ELSE
SYSSTB = ,SYS$SYSTEM:SYS.STB/SELECT
MCH = /MACHINE=NOOBJ
CHK =
.IFDEF DBG
OPTIM = /OPT=LEVEL:0
.ENDIF
.ENDIF

!LINKFLAGS   = /EXEC=$(MMS$TARGET)/NOMAP$(MAP)/NOTRACE$(DBG)
!BFLAGS	    = /OBJECT=$(MMS$TARGET)$(DBG)/NOLIST$(MCH)$(LIS)$(OPTIM)$(CHK)

WCP_MODULES = WCP,WCP_SHOW,WCP_MISC,WCP_CMDIO,CONFIG,PARSE_TIMES,WCP_CLD,-
    	      WCP_CMD_CLD,WCP_MSG

WCH_MODULES = WATCHER,COLLECT,LOG,FORCE,CONFIG,DECW_DISPLAY,WATCHER_MSG,MEM

.IFDEF __MADGOAT_BUILD__
.IFDEF __AXP__
ALL_EXTRA = ,$(BINDIR)V6_PERFORM_DISCONNECT.OBJ,$(BINDIR)V7_PERFORM_DISCONNECT.OBJ
.ENDIF
.IFDEF __VAX__
ALL_EXTRA = ,$(BINDIR)V5_PERFORM_DISCONNECT.OBJ,$(BINDIR)V6_PERFORM_DISCONNECT.OBJ
.ENDIF
.ENDIF

ALL : $(BINDIR)WATCHER.EXE, $(BINDIR)WCP.EXE, $(BINDIR)FORCE_EXIT.EXE, $(ALL_EXTRA)
    @ !

$(BINDIR)WATCHER.EXE	 : $(BINDIR)WATCHER.OLB($(WCH_MODULES)),-
    	    	           $(BINDIR)PERFORM_DISCONNECT.OBJ,-
    	    	    	   $(SRCDIR)WATCHER$(OPT),$(SRCDIR)VERSION.OPT
    LIBRARY/OUTPUT=$(BINDIR)WATCHER.OLB/COMPRESS $(BINDIR)WATCHER.OLB
    $(LINK)$(LINKFLAGS)$(SYSEXE) $(SRCDIR)WATCHER$(OPT)/OPT,$(SRCDIR)VERSION.OPT/OPT

$(BINDIR)WCP.EXE    	 : $(BINDIR)WCP.OLB($(WCP_MODULES)),$(SRCDIR)VERSION.OPT
    LIBRARY/OUTPUT=$(BINDIR)WCP.OLB/COMPRESS $(BINDIR)WCP.OLB
    $(LINK)$(LINKFLAGS) $(SRCDIR)VERSION.OPT/OPT,$(BINDIR)WCP.OLB/INCLUDE=WCP/LIB

$(BINDIR)FORCE_EXIT.EXE  : $(BINDIR)FORCE_EXIT.OBJ
    $(LINK)$(LINKFLAGS) $(MMS$SOURCE)

$(KITDIR)WCP_HELPLIB.HLB : $(KITDIR)WCP_HELPLIB.HLP
    LIBRARY/CREATE/HELP $(MMS$TARGET) $(MMS$SOURCE)

$(KITDIR)WCP_HELPLIB.HLP : $(SRCDIR)WCP_HELPLIB.RNH

$(BINDIR)MEM.OBJ,-
$(BINDIR)WATCHER.OBJ,-
$(BINDIR)COLLECT.OBJ,-
$(BINDIR)FORCE.OBJ,-
$(BINDIR)LOG.OBJ    	 : $(SRCDIR)WATCHER$(L32),$(SRCDIR)WATCHER_PRIVATE$(L32)

$(BINDIR)WCP.OBJ,-
$(BINDIR)WCP_SHOW.OBJ,-
$(BINDIR)WCP_MISC.OBJ,-
$(BINDIR)CONFIG.OBJ 	 : $(SRCDIR)WATCHER$(L32),$(SRCDIR)WCP$(L32)

$(BINDIR)WCP_CMDIO.OBJ 	 : $(SRCDIR)WCP$(L32)

$(BINDIR)PERFORM_DISCONNECT.OBJ : $(SRCDIR)PERFORM_DISCONNECT.B32
    DEFINE/NOLOG LIBREQ_DIR SYS$LIBRARY:
    $(BLISS)$(BFLAGS)$(REGMAP) $(MMS$SOURCE)
$(BINDIR)DECW_DISPLAY.OBJ : $(SRCDIR)DECW_DISPLAY.B32
    $(BLISS)$(BFLAGS)$(REGMAP) $(MMS$SOURCE)

.IFDEF __AXP__
$(BINDIR)V6_PERFORM_DISCONNECT.OBJ : $(SRCDIR)PERFORM_DISCONNECT.B32
    DEFINE/NOLOG LIBREQ_DIR SYS$SYSDEVICE:[SYSTEM_ROOTS.AXP.V6COMMON.SYSLIB]
    $(BLISS)$(BFLAGS) $(MMS$SOURCE)
$(BINDIR)V7_PERFORM_DISCONNECT.OBJ : $(SRCDIR)PERFORM_DISCONNECT.B32
    DEFINE/NOLOG LIBREQ_DIR SYS$SYSDEVICE:[SYSTEM_ROOTS.AXP.V7COMMON.SYSLIB]
    $(BLISS)$(BFLAGS) $(MMS$SOURCE)
.ENDIF
.IFDEF __VAX__
$(BINDIR)V5_PERFORM_DISCONNECT.OBJ : $(SRCDIR)PERFORM_DISCONNECT.B32
    DEFINE/NOLOG LIBREQ_DIR SYS$SYSDEVICE:[SYSTEM_ROOTS.VAX.V5COMMON.SYSLIB]
    $(BLISS)$(BFLAGS) $(MMS$SOURCE)
$(BINDIR)V6_PERFORM_DISCONNECT.OBJ : $(SRCDIR)PERFORM_DISCONNECT.B32
    DEFINE/NOLOG LIBREQ_DIR SYS$SYSDEVICE:[SYSTEM_ROOTS.VAX.V6COMMON.SYSLIB]
    $(BLISS)$(BFLAGS) $(MMS$SOURCE)
.ENDIF

$(SRCDIR)WATCHER$(L32)	    	: $(SRCDIR)FIELDS$(L32)
$(SRCDIR)WATCHER_PRIVATE$(L32)	: $(SRCDIR)WATCHER$(L32), $(SRCDIR)FIELDS$(L32)
$(SRCDIR)WCP$(L32)   	     	: $(SRCDIR)WATCHER$(L32), $(SRCDIR)FIELDS$(L32)

DOC      = DOCUMENT
DOCFLAGS = /CONTENTS/NOPRINT/OUTPUT=$(MMS$TARGET)/DEVICE=BLANK_PAGES/SYMBOLS=$(ETCDIR)DYNAMIC_SYMBOLS.SDML
BRFLAGS  = /CONTENTS/NOPRINT/OUTPUT=$(MMS$TARGET)/SYMBOLS=$(ETCDIR)DYNAMIC_SYMBOLS.SDML

$(KITDIR)WATCHER_DOC.PS : $(SRCDIR)WATCHER_DOC.SDML, $(ETCDIR)DYNAMIC_SYMBOLS.SDML
    @ IF F$TRNLNM("DECC$SHR") .NES. "" THEN DEFINE/USER DECC$SHR SYS$SYSROOT:[SYSLIB]DECC$SHR
    $(DOC) $(DOCFLAGS) $(MMS$SOURCE) SOFTWARE.REFERENCE PS

$(KITDIR)WATCHER_DOC.TXT : $(SRCDIR)WATCHER_DOC.SDML, $(ETCDIR)DYNAMIC_SYMBOLS.SDML
    @ IF F$TRNLNM("DECC$SHR") .NES. "" THEN DEFINE/USER DECC$SHR SYS$SYSROOT:[SYSLIB]DECC$SHR
    $(DOC) $(DOCFLAGS) $(MMS$SOURCE) SOFTWARE.REFERENCE MAIL

$(KITDIR)WATCHER_DOC.HTML : $(SRCDIR)WATCHER_DOC.SDML, $(ETCDIR)DYNAMIC_SYMBOLS.SDML
    @ IF F$TRNLNM("DECC$SHR") .NES. "" THEN DEFINE/USER DECC$SHR SYS$SYSROOT:[SYSLIB]DECC$SHR
    $(DOC) $(BRFLAGS) $(MMS$SOURCE) SOFTWARE.REFERENCE HTML /INDEX

.IFDEF __MADGOAT_BUILD__
$(ETCDIR)DYNAMIC_SYMBOLS.SDML : $(SRCDIR)VERSION.OPT
    @MG_TOOLS:GENERATE_SYMBOLS $(MMS$SOURCE) $(MMS$TARGET)

DIST_TOP : $(SRCDIR)AAAREADME.DOC,$(SRCDIR)AAAREADME.TOO,$(SRCDIR)VERSION.OPT,-
    	   $(SRCDIR)LINK.COM,$(SRCDIR)WATCHER.OPT,-
    	   $(SRCDIR)V5_WATCHER.OPT,$(SRCDIR)V6_WATCHER.OPT,$(SRCDIR)WATCHER.IA64_OPT,-
    	   $(SRCDIR)WATCHER.ALPHA_OPT,$(SRCDIR)V6_WATCHER.ALPHA_OPT,-
    	   $(SRCDIR)V7_WATCHER.ALPHA_OPT,$(SRCDIR)DECW_STARTLOGIN.COM,-
    	   $(SRCDIR)WATCHER_STARTUP.COM,$(SRCDIR)WATCHER_SHUTDOWN.COM,-
    	   $(SRCDIR)WATCHER.COM,$(SRCDIR)WATCHER_LOGOUT.TEMPLATE,-
    	   $(SRCDIR)SAMPLE_CONFIG.WCP,$(SRCDIR)WATCHER_MAIL.COM,$(KITDIR)WCP_HELPLIB.HLB
    PURGE $(MMS$SOURCE_LIST)
    BACKUP $(MMS$SOURCE_LIST) DIST_ROOT:[DIST]/OWNER=PARENT

DIST_VAX : $(BINVAX)WATCHER.OLB,$(BINVAX)WCP.OLB,-
    	   $(BINVAX)V5_PERFORM_DISCONNECT.OBJ,-
    	   $(BINVAX)V6_PERFORM_DISCONNECT.OBJ,-
    	   $(BINVAX)FORCE_EXIT.OBJ
    PURGE $(MMS$SOURCE_LIST)
    BACKUP $(MMS$SOURCE_LIST) DIST_ROOT:[DIST.BIN-VAX]/OWNER=PARENT

DIST_AXP : $(BINAXP)WATCHER.OLB,$(BINAXP)WCP.OLB,-
    	   $(BINAXP)V6_PERFORM_DISCONNECT.OBJ,-
    	   $(BINAXP)V7_PERFORM_DISCONNECT.OBJ,-
    	   $(BINAXP)FORCE_EXIT.OBJ
    PURGE $(MMS$SOURCE_LIST)
    BACKUP $(MMS$SOURCE_LIST) DIST_ROOT:[DIST.BIN-ALPHA]/OWNER=PARENT

DIST_I64 : $(BINI64)WATCHER.OLB,$(BINI64)WCP.OLB,-
    	   $(BINI64)PERFORM_DISCONNECT.OBJ,-
    	   $(BINI64)FORCE_EXIT.OBJ
    PURGE $(MMS$SOURCE_LIST)
    BACKUP $(MMS$SOURCE_LIST) DIST_ROOT:[DIST.BIN-IA64]/OWNER=PARENT

DIST_DOC : $(KITDIR)WATCHER_DOC.PS,$(KITDIR)WATCHER_DOC.TXT !,$(KITDIR)WATCHER_DOC.HTML
    PURGE $(MMS$SOURCE_LIST)
    BACKUP $(MMS$SOURCE_LIST) DIST_ROOT:[DIST.DOC]/OWNER=PARENT

SRC1	  = $(SRCDIR)COLLECT.B32,$(SRCDIR)CONFIG.B32,$(SRCDIR)DECW_DISPLAY.B32,$(SRCDIR)VERSION.OPT,-
    	    $(SRCDIR)FIELDS.R32,$(SRCDIR)FORCE.B32,$(SRCDIR)LOG.B32,$(SRCDIR)MEM.B32,$(SRCDIR)PARSE_TIMES.B32,$(SRCDIR)WATCHER.B32,-
    	    $(SRCDIR)WATCHER.R32,$(SRCDIR)WATCHER_DOC.SDML,$(SRCDIR)WATCHER_MSG.MSG,$(SRCDIR)WATCHER_PRIVATE.R32,-
    	    $(SRCDIR)WCP.B32,$(SRCDIR)WCP.R32,$(SRCDIR)WCP_CLD.CLD,$(SRCDIR)WCP_CMDIO.B32,$(SRCDIR)PERFORM_DISCONNECT.B32
SRC2	  = $(SRCDIR)WCP_CMD_CLD.CLD,$(SRCDIR)WATCHER.OPT,$(SRCDIR)V5_WATCHER.OPT,$(SRCDIR)V6_WATCHER.OPT,-
    	    $(SRCDIR)WATCHER.ALPHA_OPT,$(SRCDIR)V6_WATCHER.ALPHA_OPT,$(SRCDIR)V7_WATCHER.ALPHA_OPT,-
    	    $(SRCDIR)WCP_HELPLIB.RNH,$(SRCDIR)WCP_MISC.B32,$(SRCDIR)WCP_MSG.MSG,$(SRCDIR)WCP_SHOW.B32,-
    	    $(SRCDIR)DESCRIP.MMS,$(SRCDIR)COMPILE.COM,$(SRCDIR)FORCE_EXIT.B32,$(ETCDIR)DYNAMIC_SYMBOLS.SDML

SOURCE    : $(SRC1),$(SRC2)
    PURGE $(SRC1)
    PURGE $(SRC2)
    BACKUP $(SRC1) DIST_ROOT:[DIST.SOURCE]/OWNER=PARENT
    BACKUP $(SRC2) DIST_ROOT:[DIST.SOURCE]/OWNER=PARENT
.ENDIF
