F C=============================================================/SCANUAF          PROGRAM SCANUAF   F **********************************************************************F *                                                                    *F *   This program allows a VAX/VMS system manager to examine the      *F *   system User Authorization File(s) SYSUAF.DAT on multiple VAX     *F *   systems.                                                         *F *                                                                    *F *   J.D. Snyder   Princeton Plasma Physics Laboratory   18-FEB-1988  *F *   Internet: JSNYDER@PPPL.GOV                                       *F *   Phone:    (609) 243-2814                                         *F *   Address:  P.O. Box 451                                           *F *             Princeton, New Jersey 08540                            *F *                                                                    *F *   Modified:  20-SEP-1988  JDS  Sorted parameters in HELP message.  *F *                                Put example in HELP message.        *F *               9-AUG-1989  JDS  Cleaned up output display.          *F *              28-SEP-1989  JDS  Upped maximum nodes from 16 to 50.  *F *              14-NOV-1989  JDS  Added UAI symbols for flags and     *F *                                days of week, including RESTRICTED  *F *                                flag, which is new for VMS V5.2.    *F *               2-APR-1993  JDS  Added UAI symbols introduced in     *F *                                VMS V5.4 for password dictionary;   *F *                                thanks to Mark D. Schuster of Kodak *F *                                (hawkeye@kodak.com).                *F *                                Fixed bug that occurred when UIC    *F *                                group or member was more than 5     *F *                                octal digits; thanks to Claudio R.  *F *                                De Vincenzi of Universidade de Sao  *F *                                Paulo (CLAUDIO@ifqsc.usp.ansp.br).  *F *              21-JAN-1994  JDS  SCANUAF V2.0                        *F *                                Includes enhancements and bug fixes *F *                                requested/pointed out by Mark       *F *                                Schuster (hawkeye@kodak.com).       *F *                                See release notes for details.      *F *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC'   %       CHARACTER*400 TBUFF(MAX_PARAMS)        CHARACTER*32  USERNAME8       CHARACTER*21  EQ_SIGNS / '=====================' /       CHARACTER*6   CTEMP   "       LOGICAL       COUNTED, DELTA'       LOGICAL       RESULT, THIS_RESULT !       CHARACTER*255 ZSTRING_PARSE                                   &       INTEGER       TBUFF_FLAG(MASTER)       INTEGER       IDVK          INTEGER       STR$POSITION  #       RECORD /SYSUAF_RECORD/ RECORD    *-------------------------*  *     EXECUTABLE CODE     *  *-------------------------*   E       CALL AST_ENABLE         ! Queue an I/O request for trapping ^C.   C                               ! Read the list of node names and UAF +                               !  filenames.          OPEN (UNIT=12,,      +      FILE='SYS$SYSTEM:SCANUAF.NODES',      +      STATUS='OLD',        +      ACCESS='SEQUENTIAL',"      +      RECORDTYPE='VARIABLE',      +      FORM='FORMATTED',       +      READONLY,       +      SHARED,       +      IOSTAT=IOS_NODES,       +      ERR=850)                       G                               ! Verify the list of nodes and filenames.          NUM_NODES = 0           DO 50 NODE = 1, MAX_NODES   :          READ (12, '(A15,1X,A)', END=60) CNODE_LIST(NODE),;      +                                   UAF_FILENAME(NODE)   @          CALL STR$UPCASE( CNODE_LIST(NODE),   CNODE_LIST(NODE) )B          CALL STR$UPCASE( UAF_FILENAME(NODE), UAF_FILENAME(NODE) )  1          IF (CNODE_LIST(NODE) .EQ. 'ALL'     .OR. 1      +       CNODE_LIST(NODE) .EQ. 'CLUSTER' .OR. 1      +       CNODE_LIST(NODE) .EQ. 'DECNET') THEN E             TYPE *, 'Illegal node specification - ', CNODE_LIST(NODE) 6             CNODE_LIST(NODE) = '#' // CNODE_LIST(NODE)A             TYPE *, 'SCANUAF will rename node ', CNODE_LIST(NODE)           ENDIF  "          NUM_NODES = NUM_NODES + 1    50 ENDDO        60 CLOSE (UNIT=12)           IF (NUM_NODES .LE. 0) THENF          TYPE *, 'SCANUAF.NODES contains no data - program terminated'          GO TO 900       ENDIF   .       CALL SMG$CREATE_VIRTUAL_KEYBOARD( IDVK )  D       DO 800 WHILE (.TRUE.)   ! This loop constitutes a DO group, toF                               !  execute until the user terminates the)                               !  program.   >          CLOSE (UNIT=11)      ! Make sure no UAF file is open.  <          CALL GET_PARAMS(IDVK, IDISP)      ! Get user input.  D          IF (IDISP .EQ. 1) GO TO 810      ! User terminates program.            VALID_INPUT = .TRUE.                                "          RESET_DATE_CHECK = .TRUE."          RESET_PRIV_CHECK = .TRUE."          RESET_FLAG_CHECK = .TRUE."          RESET_HOUR_CHECK = .TRUE."          RESET_DAY_CHECK  = .TRUE.          INDEX_DATE_CHECK = 0           INDEX_PRIV_CHECK = 0           INDEX_FLAG_CHECK = 0           INDEX_HOUR_CHECK = 0           INDEX_DAY_CHECK  = 0                    :          DO 750 NODE = 1, NUM_NODES   ! Process each node.  )          IF (NODESET .EQ. 'ALL') GO TO 90 4          IF (NODESET .EQ. CNODE_LIST(NODE)) GO TO 909          ICOLONS = STR$POSITION(UAF_FILENAME(NODE), '::') B          IF (NODESET .EQ. 'CLUSTER' .AND. ICOLONS .EQ. 0) GO TO 90B          IF (NODESET .EQ. 'DECNET'  .AND. ICOLONS .GT. 0) GO TO 90  4          GO TO 750    ! Node is not to be processed.  @    90    CLOSE (UNIT=11)      ! Make sure unit 11 is not in use.  2          ICONTROL_C = 0       ! Reset ^C variable.  N          OPEN ( UNIT=11,                        ! Open UAF file for this node.(      +          FILE=UAF_FILENAME(NODE),      +          STATUS='OLD', $      +          ACCESS='SEQUENTIAL',&      +          RECORDTYPE='VARIABLE',#      +          FORM='UNFORMATTED',       +          READONLY,       +          SHARED,        +          IOSTAT=IOS_OPEN,      +          ERR=740)  >                               ! Display heading for this node.  C          CALL STR$TRIM( CNODE_LIST(NODE), CNODE_LIST(NODE), LNODE )   /          WRITE (LUN, 100) EQ_SIGNS(1:LNODE+6),  4      +                    CNODE_LIST(NODE)(1:LNODE),-      +                    EQ_SIGNS(1:LNODE+6) 2   100    FORMAT (/1X, A, /1X, 'Node: ', A, /1X, A)!                                   H                               ! If output is not to the user's terminal,E                               !  then print a message on the terminal E                               !  telling the user which node is being +                               !  processed.             IF (LUN .EQ. 10) THEN8             TYPE *, 'Processing node ', CNODE_LIST(NODE)          ENDIF  2          ICOUNT = 0                                         NMATCH = 0   H          DO 700 WHILE (.TRUE.)      ! This loop is a DO group to processH                                     !  each record in the UAF file.  TheJ                                     !  loop is exited when an EOF is read.  L             READ (11, END=720, ERR=640, IOSTAT=IOS_READ) RECORD   ! Read UAFL             ICOUNT = ICOUNT + 1                                   !  record.  J             USERNAME = RECORD.UAF$T_USERNAME    ! Set USERNAME for output.  M             RESULT = .TRUE.         ! Composite logical value for input line. N             THIS_RESULT = .FALSE.   ! Logical value for this param-value pair.               DO M = 1, MASTER                 TBUFF_FLAG(M) = 0             ENDDO   N             DO 600 ITEM = 1, NUM_PARAMS     ! Loop to process each param-valueF                                             !  pair on the input line.  I                IPARAM = IPARAM_LIST(ITEM)   ! Index of current parameter.   J                THIS_BUFF = ' '              ! These variables are used for>                MASTER_INDEX = IPARAM        !  program output.  G                               ! Process the input data depending on the K                               !  parameter index.  The variable THIS_RESULT I                               !  will be set to the logical result of the L                               !  evaluation of the current param-value pair.  E                IF      (IPARAM .EQ.  1) THEN        ! UAF record type   /                   LONGWORD = RECORD.UAF$B_RTYPE   1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   H                ELSE IF (IPARAM .EQ.  2) THEN        ! UAF format version  1                   LONGWORD = RECORD.UAF$B_VERSION   1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   <                ELSE IF (IPARAM .EQ.  3) THEN        ! OffsetE                                                                       3                   LONGWORD = RECORD.UAF$W_USRDATOFF   1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   I                ELSE IF (IPARAM .EQ.  4) THEN        ! Username of account   #                   COUNTED = .FALSE.   >                   CALL COMPARE_STRING( RECORD.UAF$T_USERNAME, 9      +                                 CVALUE_LIST(ITEM), :      +                                 COMPARE_LIST(ITEM),/      +                                 COUNTED, 4      +                                 THIS_RESULT )  @                ELSE IF (IPARAM .EQ.  5) THEN        ! UIC member  N                   WRITE (CTEMP,'(O6)') RECORD.UAF$W_MEM   ! Convert from octalH                   READ  (CTEMP,'(I6)') LONGWORD           !  to decimal.  1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )    ?                ELSE IF (IPARAM .EQ.  6) THEN        ! UIC group    N                   WRITE (CTEMP,'(O6)') RECORD.UAF$W_GRP   ! Convert from octalH                   READ  (CTEMP,'(I6)') LONGWORD           !  to decimal.  1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   I                ELSE IF (IPARAM .EQ.  7) THEN        ! User sub-identifier   <                   CALL COMPARE_INTEGER( RECORD.UAF$L_SUB_ID,:      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   C                ELSE IF (IPARAM .EQ.  8) THEN        ! Account owner   C                   THIS_RESULT = .FALSE.   ! Inaccessible parameter.   B                ELSE IF (IPARAM .EQ.  9) THEN        ! Account name  #                   COUNTED = .FALSE.   =                   CALL COMPARE_STRING( RECORD.UAF$T_ACCOUNT,  9      +                                 CVALUE_LIST(ITEM), :      +                                 COMPARE_LIST(ITEM),/      +                                 COUNTED, 4      +                                 THIS_RESULT )  A                ELSE IF (IPARAM .EQ. 10) THEN        ! Owners name 	           "                   COUNTED = .TRUE.  :                   CALL COMPARE_STRING( RECORD.UAF$T_OWNER,9      +                                 CVALUE_LIST(ITEM), :      +                                 COMPARE_LIST(ITEM),/      +                                 COUNTED, 4      +                                 THIS_RESULT )  D                ELSE IF (IPARAM .EQ. 11) THEN        ! Default device  "                   COUNTED = .TRUE.  ;                   CALL COMPARE_STRING( RECORD.UAF$T_DEFDEV, 9      +                                 CVALUE_LIST(ITEM), :      +                                 COMPARE_LIST(ITEM),/      +                                 COUNTED, 4      +                                 THIS_RESULT )  G                ELSE IF (IPARAM .EQ. 12) THEN        ! Default directory   "                   COUNTED = .TRUE.  ;                   CALL COMPARE_STRING( RECORD.UAF$T_DEFDIR, 9      +                                 CVALUE_LIST(ITEM), :      +                                 COMPARE_LIST(ITEM),/      +                                 COUNTED, 4      +                                 THIS_RESULT )  H                ELSE IF (IPARAM .EQ. 13) THEN        ! Login command file  "                   COUNTED = .TRUE.  ;                   CALL COMPARE_STRING( RECORD.UAF$T_LGICMD, 9      +                                 CVALUE_LIST(ITEM), :      +                                 COMPARE_LIST(ITEM),/      +                                 COUNTED, 4      +                                 THIS_RESULT )  A                ELSE IF (IPARAM .EQ. 14) THEN        ! Default CLI   "                   COUNTED = .TRUE.  ;                   CALL COMPARE_STRING( RECORD.UAF$T_DEFCLI, 9      +                                 CVALUE_LIST(ITEM), :      +                                 COMPARE_LIST(ITEM),/      +                                 COUNTED, 4      +                                 THIS_RESULT )  E                ELSE IF (IPARAM .EQ. 15) THEN        ! User CLI tables   "                   COUNTED = .TRUE.  >                   CALL COMPARE_STRING( RECORD.UAF$T_CLITABLES,9      +                                 CVALUE_LIST(ITEM), :      +                                 COMPARE_LIST(ITEM),/      +                                 COUNTED, 4      +                                 THIS_RESULT )  F                ELSE IF (IPARAM .EQ. 16) THEN        ! Primary password  C                    THIS_RESULT = .FALSE.  ! Inaccessible parameter.   H                ELSE IF (IPARAM .EQ. 17) THEN        ! Secondary password  C                    THIS_RESULT = .FALSE.  ! Inaccessible parameter.   D                ELSE IF (IPARAM .EQ. 18) THEN        ! Login failures  2                   LONGWORD = RECORD.UAF$W_LOGFAILS  1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   J                ELSE IF (IPARAM .EQ. 19) THEN        ! Random password salt  .                   LONGWORD = RECORD.UAF$W_SALT  1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   E                ELSE IF (IPARAM .EQ. 20) THEN        ! Encrypt primary   1                   LONGWORD = RECORD.UAF$B_ENCRYPT   1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   G                ELSE IF (IPARAM .EQ. 21) THEN        ! Encrypt secondary   2                   LONGWORD = RECORD.UAF$B_ENCRYPT2  1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   M                ELSE IF (IPARAM .EQ. 22) THEN        ! Minimum password length   4                   LONGWORD = RECORD.UAF$B_PWD_LENGTH  1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )*  J                ELSE IF (IPARAM .EQ. 23) THEN        ! Exp date for account  !                   DELTA = .FALSE.A  =                   CALL COMPARE_DATE( RECORD.UAF$Q_EXPIRATION,r7      +                               CVALUE_LIST(ITEM),t8      +                               COMPARE_LIST(ITEM),+      +                               DELTA, 2      +                               THIS_RESULT )  G                ELSE IF (IPARAM .EQ. 24) THEN        ! Password lifetimeP                      DELTA = .TRUE.  ?                   CALL COMPARE_DATE( RECORD.UAF$Q_PWD_LIFETIME, 7      +                               CVALUE_LIST(ITEM), 8      +                               COMPARE_LIST(ITEM),+      +                               DELTA, 2      +                               THIS_RESULT )  M                ELSE IF (IPARAM .EQ. 25) THEN        ! Date of prim pwd changea  !                   DELTA = .FALSE.   ;                   CALL COMPARE_DATE( RECORD.UAF$Q_PWD_DATE,-7      +                               CVALUE_LIST(ITEM), 8      +                               COMPARE_LIST(ITEM),+      +                               DELTA,U2      +                               THIS_RESULT )  L                ELSE IF (IPARAM .EQ. 26) THEN        ! Date of sec pwd change  !                   DELTA = .FALSE.   <                   CALL COMPARE_DATE( RECORD.UAF$Q_PWD2_DATE,7      +                               CVALUE_LIST(ITEM),o8      +                               COMPARE_LIST(ITEM),+      +                               DELTA, 2      +                               THIS_RESULT )  L                ELSE IF (IPARAM .EQ. 27) THEN        ! Date of last int login  !                   DELTA = .FALSE.   >                   CALL COMPARE_DATE( RECORD.UAF$Q_LASTLOGIN_I,7      +                               CVALUE_LIST(ITEM), 8      +                               COMPARE_LIST(ITEM),+      +                               DELTA,L2      +                               THIS_RESULT )  N                ELSE IF (IPARAM .EQ. 28) THEN        ! Date of last n-int login  !                   DELTA = .FALSE.*  >                   CALL COMPARE_DATE( RECORD.UAF$Q_LASTLOGIN_N,7      +                               CVALUE_LIST(ITEM),e8      +                               COMPARE_LIST(ITEM),+      +                               DELTA, 2      +                               THIS_RESULT )  J                ELSE IF (IPARAM .EQ. 29) THEN        ! Authorized privleges  5                   CALL PRIV_CHECK( RECORD.UAF$Q_PRIV, 5      +                             CVALUE_LIST(ITEM), 6      +                             COMPARE_LIST(ITEM),0      +                             THIS_RESULT )  G                ELSE IF (IPARAM .EQ. 30) THEN        ! Default privlegesS  9                   CALL PRIV_CHECK( RECORD.UAF$Q_DEF_PRIV, 5      +                             CVALUE_LIST(ITEM), 6      +                             COMPARE_LIST(ITEM),0      +                             THIS_RESULT )  H                ELSE IF (IPARAM .EQ. 31) THEN        ! Min security class  *                   COUNTED = .FALSE.  ! ???  >                   CALL COMPARE_STRING( RECORD.UAF$R_MIN_CLASS,9      +                                 CVALUE_LIST(ITEM), :      +                                 COMPARE_LIST(ITEM),/      +                                 COUNTED, 4      +                                 THIS_RESULT )  H                ELSE IF (IPARAM .EQ. 32) THEN        ! Max security class  *                   COUNTED = .FALSE.  ! ???  >                   CALL COMPARE_STRING( RECORD.UAF$R_MAX_CLASS,9      +                                 CVALUE_LIST(ITEM),_:      +                                 COMPARE_LIST(ITEM),/      +                                 COUNTED,,4      +                                 THIS_RESULT )  A                ELSE IF (IPARAM .EQ. 33) THEN        ! Login flagsN  6                   CALL FLAG_CHECK( RECORD.UAF$L_FLAGS,5      +                             CVALUE_LIST(ITEM),'6      +                             COMPARE_LIST(ITEM),0      +                             THIS_RESULT )  J                ELSE IF (IPARAM .EQ. 34) THEN        ! Hourly net acc, prim  A                   CALL HOUR_CHECK( RECORD.UAF$B_NETWORK_ACCESS_P, 5      +                             CVALUE_LIST(ITEM),O6      +                             COMPARE_LIST(ITEM),0      +                             THIS_RESULT )  I                ELSE IF (IPARAM .EQ. 35) THEN        ! Hourly net acc, seca  A                   CALL HOUR_CHECK( RECORD.UAF$B_NETWORK_ACCESS_S,A5      +                             CVALUE_LIST(ITEM),W6      +                             COMPARE_LIST(ITEM),0      +                             THIS_RESULT )  J                ELSE IF (IPARAM .EQ. 36) THEN        ! Hourly bat acc, prim  ?                   CALL HOUR_CHECK( RECORD.UAF$B_BATCH_ACCESS_P,L5      +                             CVALUE_LIST(ITEM), 6      +                             COMPARE_LIST(ITEM),0      +                             THIS_RESULT )  I                ELSE IF (IPARAM .EQ. 37) THEN        ! Hourly bat acc, secP  ?                   CALL HOUR_CHECK( RECORD.UAF$B_BATCH_ACCESS_S,S5      +                             CVALUE_LIST(ITEM),U6      +                             COMPARE_LIST(ITEM),0      +                             THIS_RESULT )  J                ELSE IF (IPARAM .EQ. 38) THEN        ! Hourly loc acc, prim  ?                   CALL HOUR_CHECK( RECORD.UAF$B_LOCAL_ACCESS_P, 5      +                             CVALUE_LIST(ITEM),S6      +                             COMPARE_LIST(ITEM),0      +                             THIS_RESULT )  I                ELSE IF (IPARAM .EQ. 39) THEN        ! Hourly loc acc, secT  ?                   CALL HOUR_CHECK( RECORD.UAF$B_LOCAL_ACCESS_S,05      +                             CVALUE_LIST(ITEM),N6      +                             COMPARE_LIST(ITEM),0      +                             THIS_RESULT )  K                ELSE IF (IPARAM .EQ. 40) THEN        ! Hourly dial acc, prim   @                   CALL HOUR_CHECK( RECORD.UAF$B_DIALUP_ACCESS_P,5      +                             CVALUE_LIST(ITEM), 6      +                             COMPARE_LIST(ITEM),0      +                             THIS_RESULT )  J                ELSE IF (IPARAM .EQ. 41) THEN        ! Hourly dial acc, sec  @                   CALL HOUR_CHECK( RECORD.UAF$B_DIALUP_ACCESS_S,5      +                             CVALUE_LIST(ITEM),N6      +                             COMPARE_LIST(ITEM),0      +                             THIS_RESULT )  J                ELSE IF (IPARAM .EQ. 42) THEN        ! Hourly rem acc, prim  @                   CALL HOUR_CHECK( RECORD.UAF$B_REMOTE_ACCESS_P,5      +                             CVALUE_LIST(ITEM),s6      +                             COMPARE_LIST(ITEM),0      +                             THIS_RESULT )  I                ELSE IF (IPARAM .EQ. 43) THEN        ! Hourly rem acc, sec   @                   CALL HOUR_CHECK( RECORD.UAF$B_REMOTE_ACCESS_S,5      +                             CVALUE_LIST(ITEM),E6      +                             COMPARE_LIST(ITEM),0      +                             THIS_RESULT )  B                ELSE IF (IPARAM .EQ. 44) THEN        ! Primary days  9                   CALL DAY_CHECK( RECORD.UAF$B_PRIMEDAYS, 4      +                            CVALUE_LIST(ITEM),5      +                            COMPARE_LIST(ITEM),0/      +                            THIS_RESULT )   K                ELSE IF (IPARAM .EQ. 45) THEN        ! Base process priority   -                   LONGWORD = RECORD.UAF$B_PRIA  1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM),.5      +                                  THIS_RESULT )F  O                ELSE IF (IPARAM .EQ. 46) THEN        ! Max job queueing priorityp  0                   LONGWORD = RECORD.UAF$B_QUEPRI  1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )E  F                ELSE IF (IPARAM .EQ. 47) THEN        ! Max jobs for UIC  1                   LONGWORD = RECORD.UAF$W_MAXJOBS   1                   CALL COMPARE_INTEGER( LONGWORD,S:      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM),a5      +                                  THIS_RESULT )   J                ELSE IF (IPARAM .EQ. 48) THEN        ! Max jobs for account  5                   LONGWORD = RECORD.UAF$W_MAXACCTJOBSL  1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )F  L                ELSE IF (IPARAM .EQ. 49) THEN        ! Max detached processes  3                   LONGWORD = RECORD.UAF$W_MAXDETACHA  1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )R  F                ELSE IF (IPARAM .EQ. 50) THEN        ! Subprocess limit  0                   LONGWORD = RECORD.UAF$W_PRCCNT  1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   H                ELSE IF (IPARAM .EQ. 51) THEN        ! Buffered I/O limit  /                   LONGWORD = RECORD.UAF$W_BIOLM   1                   CALL COMPARE_INTEGER( LONGWORD,A:      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   F                ELSE IF (IPARAM .EQ. 52) THEN        ! Direct I/O limit  /                   LONGWORD = RECORD.UAF$W_DIOLMH  1                   CALL COMPARE_INTEGER( LONGWORD,E:      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM),a5      +                                  THIS_RESULT )   M                ELSE IF (IPARAM .EQ. 53) THEN        ! Timer queue entry limit   /                   LONGWORD = RECORD.UAF$W_TQCNT   1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )'  E                ELSE IF (IPARAM .EQ. 54) THEN        ! AST queue limitE  /                   LONGWORD = RECORD.UAF$W_ASTLM   1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM),P5      +                                  THIS_RESULT )   C                ELSE IF (IPARAM .EQ. 55) THEN        ! Enqueue limit   /                   LONGWORD = RECORD.UAF$W_ENQLM+  1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )n  E                ELSE IF (IPARAM .EQ. 56) THEN        ! Open file limit   /                   LONGWORD = RECORD.UAF$W_FILLMF  1                   CALL COMPARE_INTEGER( LONGWORD,R:      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM),M5      +                                  THIS_RESULT )   G                ELSE IF (IPARAM .EQ. 57) THEN        ! Shared file limit   2                   LONGWORD = RECORD.UAF$W_SHRFILLM  1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )M  L                ELSE IF (IPARAM .EQ. 58) THEN        ! Working set size quota  =                   CALL COMPARE_INTEGER( RECORD.UAF$L_WSQUOTA, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM),A5      +                                  THIS_RESULT )A  N                ELSE IF (IPARAM .EQ. 59) THEN        ! Default working set size  =                   CALL COMPARE_INTEGER( RECORD.UAF$L_DFWSCNT, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )A  L                ELSE IF (IPARAM .EQ. 60) THEN        ! Working set size limit  >                   CALL COMPARE_INTEGER( RECORD.UAF$L_WSEXTENT,:      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )m  E                ELSE IF (IPARAM .EQ. 61) THEN        ! Page file quotaC  ?                   CALL COMPARE_INTEGER( RECORD.UAF$L_PGFLQUOTA, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   D                ELSE IF (IPARAM .EQ. 62) THEN        ! CPU time quota  <                   CALL COMPARE_INTEGER( RECORD.UAF$L_CPUTIM,:      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )+  M                ELSE IF (IPARAM .EQ. 63) THEN        ! Buff I/O byte cnt limit   ;                   CALL COMPARE_INTEGER( RECORD.UAF$L_BYTLM, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM),T5      +                                  THIS_RESULT )I  J                ELSE IF (IPARAM .EQ. 64) THEN        ! Paged buff I/O limit  <                   CALL COMPARE_INTEGER( RECORD.UAF$L_PBYTLM,:      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   K                ELSE IF (IPARAM .EQ. 65) THEN        ! Job log nam tab quota   =                   CALL COMPARE_INTEGER( RECORD.UAF$L_JTQUOTA,r:      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM),O5      +                                  THIS_RESULT )O  N                ELSE IF (IPARAM .EQ. 66) THEN        ! Num of proxies can grant  3                   LONGWORD = RECORD.UAF$W_PROXY_LIM   1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   L                ELSE IF (IPARAM .EQ. 67) THEN        ! Num of proxies granted  1                   LONGWORD = RECORD.UAF$W_PROXIES   1                   CALL COMPARE_INTEGER( LONGWORD, :      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   L                ELSE IF (IPARAM .EQ. 68) THEN        ! Num sub-accnts allowed  5                   LONGWORD = RECORD.UAF$W_ACCOUNT_LIM   1                   CALL COMPARE_INTEGER( LONGWORD,F:      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )   K                ELSE IF (IPARAM .EQ. 69) THEN        ! Num sub-accnts in use   2                   LONGWORD = RECORD.UAF$W_ACCOUNTS  1                   CALL COMPARE_INTEGER( LONGWORD,P:      +                                  IVALUE_LIST(ITEM),;      +                                  COMPARE_LIST(ITEM), 5      +                                  THIS_RESULT )                   ELSE   B                   THIS_RESULT = .FALSE.  ! Unrecognized parameter.                  ENDIF  M                IF (.NOT. VALID_INPUT) THEN     ! Invalid input; abort search.Q*                   TYPE *, 'Search aborted'                   TYPE *, ' 'E3                   IF (LUN .EQ. 10) THEN            $%                      WRITE (LUN, 550) :   550                FORMAT (/,' * Invalid input *', /)                      ENDIFT                   GO TO 800                 ENDIF  M                                                ! Fill in ZSTRING with logicalR9                                                !  result.   $                IF (THIS_RESULT) THEN:                   ZSTRING(ZINDEX(ITEM):ZINDEX(ITEM)) = '1'                ELSE :                   ZSTRING(ZINDEX(ITEM):ZINDEX(ITEM)) = '0'                ENDIF  2                IF (TBUFF_FLAG(IPARAM) .EQ. 0) THENA                   TBUFF(ITEM) = THIS_BUFF    ! Set output buffer. (                   TBUFF_FLAG(IPARAM) = 1                ELSE #                   TBUFF(ITEM) = ' '                 ENDIF  O   600       ENDDO                     ! End of loop to process each param-valueI@                                       !  pair on the input line.  J                                       ! Evaluate logical value of ZSTRING.  #             ZSTRING_PARSE = ZSTRING @             CALL LOGICAL_PARSE( ZSTRING_PARSE(1:ZSIZE), RESULT )  J             IF (.NOT. VALID_INPUT) THEN     ! Invalid input; abort search.'                TYPE *, 'Search aborted'                 TYPE *, ' '0                IF (LUN .EQ. 10) THEN            "                   WRITE (LUN, 550)                ENDIF                GO TO 800             ENDIFI  L                               ! If the composite logical value for the inputN                               !  line (RESULT) is .TRUE., then this UAF recordL                               !  is a match, so output the appropriate data.               IF (RESULT) THENC                IF (REPORTSET .EQ. 'FULL') WRITE (LUN, 610) USERNAME /   610          FORMAT (/, ' Username    : ', A) D                IF (REPORTSET .EQ. 'BRIEF') WRITE (LUN, 620) USERNAME(   620          FORMAT (' Username: ', A).                IF (REPORTSET .EQ. 'FULL') THEN)                   DO ITEM = 1, NUM_PARAMS,3                      IF (TBUFF(ITEM) .NE. ' ') THENE;                         WRITE (LUN, 630) (TBUFF(ITEM)(I:I),,K      +                                    I = 1, ISTRING_LAST(TBUFF(ITEM))) B   630                   FORMAT ( 1X, 78A1, '-', 7(/15X,64A1,'-') )                      ENDIF                   ENDDOA                ENDIF"                NMATCH = NMATCH + 1             ENDIF_  &             RESET_DATE_CHECK = .FALSE.&             RESET_PRIV_CHECK = .FALSE.&             RESET_FLAG_CHECK = .FALSE.&             RESET_HOUR_CHECK = .FALSE.&             RESET_DAY_CHECK  = .FALSE.              INDEX_DATE_CHECK = 0              INDEX_PRIV_CHECK = 0              INDEX_FLAG_CHECK = 0              INDEX_HOUR_CHECK = 0>             INDEX_DAY_CHECK  = 0                                !   640       IF (IOS_READ .NE. 0) SH      +         TYPE *, 'Read error ', UAF_FILENAME(NODE), '  ', IOS_READ  .                               ! ^C processing.  '             IF (ICONTROL_C .GT. 0) THEN O                IF (LUN .EQ. 10) THEN            ! If output is going to a file, N                   WRITE (LUN, 670)              !  then print a message in the8   670             FORMAT (/,' * CANCEL *', /)   !  file.                ENDIF/                IF (ICONTROL_C .EQ. 1) GO TO 750y                GO TO 800             ENDIF   K   700    ENDDO        ! End of loop to process each record in the UAF file.+  7   720    IF (REPORTSET .EQ. 'FULL') WRITE (LUN, '(1X)')+(          WRITE (LUN, 730) ICOUNT, NMATCHF   730    FORMAT (1X, 32('-'), /1X, 'Records:', I6, '    Matches:', I6,      +          /1X, 32('-'))I     740    IF (IOS_OPEN .NE. 0) E      +      TYPE *, 'Open error ', UAF_FILENAME(NODE), '  ', IOS_OPENL  9   750    ENDDO        ! End of loop to process each node.             WRITE (LUN, '(1X)')  H   800 ENDDO           ! End of loop to process until the user terminates%                       !  the program.   <   810 CLOSE (UNIT = 11)    ! Make sure all files are closed.       CLOSE (UNIT = 10)H     850 IF (IOS_NODES .NE. 0)_<      +   TYPE *, 'Open error on SCANUAF.NODES - ', IOS_NODES       CLOSE (UNIT=12)      900 CONTINUE	       END(F C==========================================================/GET_PARAMS  E(       SUBROUTINE GET_PARAMS(IDVK, IDISP)  F **********************************************************************F *                                                                    *F *   Read and parse user's input.                                     *F *                                                                    *F *   OUTPUT ARGUMENTS                                                 *F *   ----------------                                                 *2       INTEGER IDVK              ! Virtual keyboard-       INTEGER IDISP             ! Disposition F *                                                                    *F **********************************************************************         INCLUDE '($SMGMSG)'        INCLUDE 'SCANUAF.INC'   $       INTEGER SMG$READ_COMPOSED_LINE         CHARACTER*255 LINE         DATA IFORCE  / 0 /   *-------------------------*  *     EXECUTABLE CODE     *R *-------------------------*r    I       DO 800 WHILE (.TRUE.)   ! Loop to process user input until a valid,SA                               !  parameter-value line is entered.+  3          LINE = ' '           ! Line of user input.+  G                               ! Get the input line from the user.  If aMG                               !  ^Z was entered (SMG$_EOF), then branchU:                               !  to terminate the program.  A C        ISTATUS = LIB$GET_FOREIGN( LINE, 'SCANUAF> ', , IFORCE ) F          ISTATUS = SMG$READ_COMPOSED_LINE( IDVK, , LINE, 'SCANUAF> ' )               (          IF (ISTATUS .EQ. SMG$_EOF) THEN             IDISP = 1              GO TO 200H          ENDIF           IF (.NOT. ISTATUS) THEN'             CALL ERROR_MESSAGE(ISTATUS)E             IDISP = 0              GO TO 200E          ENDIF  G          CALL STR$UPCASE( LINE, LINE )   ! Convert input to upper case.P            ILO = 0          IQUOTE = 0c          ZSIZE = 0          ZSTRING = ' '          IDISP = 0          ISPECIAL = 0 =          NUM_PARAMS = 0       ! Number of parameters on line.             DO 100 I = 1, 255  H             IF (LINE(I:I) .EQ. '"') IQUOTE = 1 - IQUOTE   ! Check for ".  #             IF (IQUOTE .EQ. 0 .AND.r(      +          (LINE(I:I) .EQ. '(' .OR.(      +           LINE(I:I) .EQ. ')' .OR.(      +           LINE(I:I) .EQ. '&' .OR.(      +           LINE(I:I) .EQ. '|' .OR.,      +           LINE(I:I) .EQ. ' ' ) ) THEN  #                IF (ILO .GT. 0) THEN                    IHI = I - 1 E                   CALL VALIDATE_INPUT(LINE(ILO:IHI), ISPECIAL, IDISP)H0                   IF (IDISP .EQ. 0) GO TO 200   -                   IF (IDISP .EQ. 1) GO TO 200+#                   ZSIZE = ZSIZE + 1L,                   ZSTRING(ZSIZE:ZSIZE) = 'Z'C                   IF (NUM_PARAMS .GT. 0) ZINDEX(NUM_PARAMS) = ZSIZE                 ENDIF                   ZSIZE = ZSIZE + 1/                ZSTRING(ZSIZE:ZSIZE) = LINE(I:I)                   ILO = 0               ELSE  &                IF (ILO .EQ. 0) ILO = I               ENDIF      100    ENDDO             IF (IQUOTE .EQ. 1) THEN             TYPE *, ' 'e=             TYPE *, 'Illegal specification - unclosed quotes'_             TYPE *, ' '              IDISP = 0O             GO TO 200           ENDIF  2          IF (ISPECIAL .EQ. 1) THEN                ,             TYPE *, ' '                     B             TYPE *, 'Illegal special command; no action performed'             TYPE *, ' 'N             IDISP = 0i             GO TO 200 /          ENDIF                                    2          IF (ISPECIAL .EQ. 2) THEN                             CALL DO_NODE('ALL')V             IDISP = 0+             GO TO 200 /          ENDIF                                    2          IF (ISPECIAL .EQ. 3) THEN                "             CALL DO_REPORT('FULL')             IDISP = 0              GO TO 200O/          ENDIF                                 A  2          IF (ISPECIAL .EQ. 4) THEN                (             CALL DO_OUTPUT('SYS$OUTPUT')             IDISP = 0              GO TO 200T/          ENDIF                                    ?   200    IF (IDISP .GT. 0) GO TO 810           ! 0 ==> Reprompt C                                                ! 1 ==> Exit program_G                                                ! 2 ==> Leave to process+L                                                !       parameter-value pairs     800 ENDDO    810 CONTINUE  H                               ! If output is going to a file, then print8                               !  input line in the file.         IF (LUN .EQ. 10)  2      +   WRITE (LUN, '(/1X,A,/1X,A,/1X,A,/1X,A)') <      +   LINE(1:79),LINE(80:158),LINE(159:237),LINE(238:255)         RETURN	       END(F C=====================================================/VALIDATE_PVPAIR  :       SUBROUTINE VALIDATE_INPUT( PVPAIR, ISPECIAL, IDISP )  F **********************************************************************F *                                                                    *F *   Validate input string as a parameter-value pair.                 *F *                                                                    *F *   INPUT ARGUMENTS                                                  *F *   ---------------                                                  *@       CHARACTER*(*) PVPAIR      ! Potential parameter-value pairF *                                                                    *F *   OUTPUT ARGUMENTS                                                 *F *   ----------------                                                 *;       INTEGER ISPECIAL          ! Processing special input l-       INTEGER IDISP             ! Disposition$F *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC'T              INTEGER      IPARAM_LOCAL        INTEGER      IVALUE_LOCAL        CHARACTER*64 CVALUE_LOCALH        CHARACTER*1  COMPARE_LOCAL         CHARACTER*64 CTEMP          INTEGER      STR$POSITION    *-------------------------*R *     EXECUTABLE CODE     *  *-------------------------*E  I                               ! Check for special input commands.                  IF (ISPECIAL .EQ. 2) THEN           CALL DO_NODE(PVPAIR)           ISPECIAL = 0           IDISP = 0          GO TO 900       ENDIF          IF (ISPECIAL .EQ. 3) THEN           CALL DO_REPORT(PVPAIR)T          ISPECIAL = 0+          IDISP = 0          GO TO 900       ENDIF          IF (ISPECIAL .EQ. 4) THEN           CALL DO_OUTPUT(PVPAIR)           ISPECIAL = 0           IDISP = 0          GO TO 900       ENDIFR         IF (ISPECIAL .EQ. 1) THENi/          IF (PVPAIR .EQ. 'NODE')   ISPECIAL = 2_/          IF (PVPAIR .EQ. 'REPORT') ISPECIAL = 3 /          IF (PVPAIR .EQ. 'OUTPUT') ISPECIAL = 4           IDISP = 2  "          IF (ISPECIAL .EQ. 1) THEN,             TYPE *, ' '                     B             TYPE *, 'Illegal special command; no action performed'             TYPE *, ' 'p             IDISP = 0           ENDIF          GO TO 900       ENDIF   9       IF (NUM_PARAMS .EQ. 0 .AND. PVPAIR .EQ. 'SET') THEN           ISPECIAL = 1           IDISP = 2          GO TO 900       ENDIF   :       IF (NUM_PARAMS .EQ. 0 .AND. PVPAIR .EQ. 'HELP') THEN          CALL DO_HELP           IDISP = 0          GO TO 900       ENDIF   :       IF (NUM_PARAMS .EQ. 0 .AND. PVPAIR .EQ. 'SHOW') THEN          CALL DO_SHOW           IDISP = 0          GO TO 900       ENDIF   ?       IF (NUM_PARAMS .EQ. 0 .AND. PVPAIR .EQ. 'AUTHORIZE') THEN           CALL DO_AUTHORIZE          IDISP = 0          GO TO 900       ENDIF   :       IF (NUM_PARAMS .EQ. 0 .AND. PVPAIR .EQ. 'EXIT') THEN          IDISP = 1          GO TO 900       ENDIF   G                               ! Check for parameter-value pair.           *       IF (NUM_PARAMS .GE. MAX_PARAMS) THEN          TYPE *, ' '>          TYPE *, 'Illegal specification - too many parameters'          TYPE *, ' '          IDISP = 0          GO TO 900       ENDIFe         LPVPAIR = LEN(PVPAIR)   >       DO J = 1, LPVPAIR       ! Find the comparison character.          MARK = J &          IF (PVPAIR(J:J) .EQ. '=' .OR.,      +       PVPAIR(J:J) .EQ. '\' .OR.      ,      +       PVPAIR(J:J) .EQ. '>' .OR.      -      +       PVPAIR(J:J) .EQ. '<' ) GO TO 350R       ENDDOH  H                               ! Make sure the comparison character is in.                               !  a valid spot.  2   350 IF (MARK .LE. 1 .OR. MARK .GE. LPVPAIR) THEN          TYPE *, ' '6          TYPE *, 'Illegal entry - ', PVPAIR(1:LPVPAIR)          TYPE *, ' '          IDISP = 0          GO TO 900       ENDIF          MHI = MARK - 1  @                               ! Check master list of parameters.         DO 400 J = 1, MASTER  )          IF (MHI .LT. ISTAR(J)) GO TO 400 )          IF (MHI .GT. 12)       GO TO 400 E          IF (PVPAIR(1:MHI) .EQ. PARAM(J)(1:MHI)) THEN  ! Entry valid. L             IPARAM_LOCAL = J                           ! Index of parameter.             GO TO 410O          ENDIF         400 ENDDO   L                               ! If control gets here, then the entry was not:                               !  found in the master list.          TYPE *, ' ' E       TYPE *, 'Illegal parameter specification - ', PVPAIR(1:LPVPAIR)i       TYPE *, ' '        IDISP = 0E       GO TO 900U  <                               ! Check comparison chararcter.  2   410 IF ( STR$POSITION( COMPCHARS(IPARAM_LOCAL) ,?      +                   PVPAIR(MARK:MARK) ) .GT. 0 ) GO TO 420S         TYPE *, ' ' B       TYPE *, 'Illegal comparison character - ', PVPAIR(1:LPVPAIR)       TYPE *, ' 'L       IDISP = 0        GO TO 900L  '   420 COMPARE_LOCAL = PVPAIR(MARK:MARK)                       MLO = MARK + 1       LTEMP = 0        CTEMP = ' 'E  H                               ! Store entry string in temporary variableE                               !  CTEMP, eliminating any " characters.          DO J = MLO, LPVPAIRT;          IF (PVPAIR(J:J) .NE. '"' .AND. LTEMP .LT. 64) THEN              LTEMP = LTEMP + 1 ,             CTEMP(LTEMP:LTEMP) = PVPAIR(J:J)          ENDIF       ENDDO   5       IF (LTEMP .EQ. 0) GO TO 430    ! Invalid field.S  H                               ! Store the entry is either CVALUE_LIST orG                               !  IVALUE_LIST, depending on if the valueEN                               !  should be character or integer, respectively.  +       IF (TYPE(IPARAM_LOCAL) .EQ. 'C') THENR&          CVALUE_LOCAL = CTEMP(1:LTEMP)          IVALUE_LOCAL = 0 
       ELSE;          READ (CTEMP(1:LTEMP), '(I)', ERR=430) IVALUE_LOCALs          CVALUE_LOCAL = ' '        ENDIFC  .       GO TO 450      430 TYPE *, ' 'LA       TYPE *, 'Illegal value specification - ', PVPAIR(1:LPVPAIR)        TYPE *, ' ',       IDISP = 0        GO TO 900   !   450 NUM_PARAMS = NUM_PARAMS + 1 -       IPARAM_LIST(NUM_PARAMS)  = IPARAM_LOCAL .       COMPARE_LIST(NUM_PARAMS) = COMPARE_LOCAL-       IVALUE_LIST(NUM_PARAMS)  = IVALUE_LOCAL -       CVALUE_LIST(NUM_PARAMS)  = CVALUE_LOCAL        IDISP = 2C     900 CONTINUE       RETURN	       END   F C=============================================================/DO_NODE          SUBROUTINE DO_NODE(VALUE)+  F **********************************************************************F *                                                                    *F *   Set nodename for subsequent scans.                               *F *                                                                    *F *   INPUT ARGUMENTS                                                  *F *   ---------------                                                  *0       CHARACTER*(*) VALUE      ! Nodename to setF *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC'                 *-------------------------*  *     EXECUTABLE CODE     *  *-------------------------*   I       IF (VALUE .EQ. ' '        .OR.                  ! Check for special J      +    VALUE .EQ. 'ALL'      .OR.                  !  SET NODE keyword.$      +    VALUE .EQ. 'CLUSTER'  .OR.$      +    VALUE .EQ. 'DECNET' ) THEN          NODESET = VALUE.          IF (NODESET .EQ. ' ') NODESET = 'ALL'6          GO TO 120                                           ENDIFI  G       DO 100 I = 1, NUM_NODES                         ! Check for validIB          IF (VALUE .EQ. CNODE_LIST(I)) THEN           !  nodename.#             NODESET = CNODE_LIST(I)N             GO TO 120F          ENDIF   100 ENDDOo  u       TYPE *, ' ' 8       TYPE *, 'Illegal SET NODE specification - ', VALUE#       TYPE *, 'No action performed'        TYPE *, ' '      120 CONTINUE       RETURN	       ENDn  F C===========================================================/DO_REPORT   !       SUBROUTINE DO_REPORT(VALUE)   F **********************************************************************F *                                                                    *F *   Set report type for subsequent scans.                            *F *                                                                    *F *   INPUT ARGUMENTS                                                  *F *   ---------------                                                  *3       CHARACTER*(*) VALUE      ! Report type to set F *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC'    *-------------------------*e *     EXECUTABLE CODE     *  *-------------------------*   "       IF (VALUE .EQ. ' '      .OR."      +    VALUE .EQ. 'FULL'   .OR."      +    VALUE .EQ. 'BRIEF') THEN          REPORTSET = VALUE3          IF (REPORTSET .EQ. ' ') REPORTSET = 'FULL' 
       ELSE          TYPE *, ' '=          TYPE *, 'Illegal SET REPORT specification - ', VALUE &          TYPE *, 'No action performed'          TYPE *, ' '       ENDIFE         RETURN	       END   F C===========================================================/DO_OUTPUT   !       SUBROUTINE DO_OUTPUT(VALUE)   F **********************************************************************F *                                                                    *F *   Set output for subsequent scans.                                 *F *                                                                    *F *   INPUT ARGUMENTS                                                  *F *   ---------------                                                  *.       CHARACTER*(*) VALUE      ! Output to setF *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC'T   *-------------------------*A *     EXECUTABLE CODE     *  *-------------------------*   >       CLOSE (UNIT=10)            ! Close existing output file.A       LUN = 6                    ! Initialize output unit number. A       OUTPUTSET = 'SYS$OUTPUT'   ! Initialize output destination.n  K       IF (VALUE .EQ. ' '          .OR.        ! Check for values that would F      +    VALUE .EQ. 'SYS$OUTPUT') GO TO 220  !  send output to user's:                                               !  terminal.  E       OPEN (UNIT=10,                          ! Open new output file.       +      FILE=VALUE,'       +      ACCESS='SEQUENTIAL',#      +      CARRIAGECONTROL='LIST',       +      FORM='FORMATTED',e      +      STATUS='NEW',,      +      ERR=200,      +      IOSTAT=IOS) L   200 IF (IOS .NE. 0) THEN                         ! Open error; output goesI          TYPE *, 'Open error ', VALUE, '  ', IOS   !  to user's terminal.eK       ELSE                                         ! File opened ok, outputpC          LUN = 10                                  !  goes to file.m          OUTPUTSET = VALUE       ENDIFu  6   220 CALL STR$TRIM( OUTPUTSET, OUTPUTSET, LOUTPUTSET)C       TYPE *, 'Output will be written to ', OUTPUTSET(1:LOUTPUTSET)E          RETURN	       END   F C=============================================================/DO_HELP  =       SUBROUTINE DO_HELP  F **********************************************************************F *                                                                    *F *   Display help.                                                    *F *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC' ,       EXTERNAL LIB$PUT_OUTPUT, LIB$GET_INPUT   *-------------------------*  *     EXECUTABLE CODE     *E *-------------------------*   E       CALL LBR$OUTPUT_HELP(LIB$PUT_OUTPUT,,'SCANUAF',,,LIB$GET_INPUT)        RETURN	       END   F C=============================================================/DO_SHOW  *       SUBROUTINE DO_SHOW  F **********************************************************************F *                                                                    *F *   Display current special input parameter settings.                *F *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC'           INTEGER      STR$POSITION    *-------------------------*  *     EXECUTABLE CODE     *  *-------------------------*          TYPE *, ' ' J       TYPE *, 'Current settings for special input command parameters are:'       TYPE *, ' 'm,       TYPE *, '   <nodename>    = ', NODESET.       TYPE *, '   <reporttype>  = ', REPORTSET.       TYPE *, '   <destination> = ', OUTPUTSET       TYPE *, ' ' F       TYPE *, 'The list of nodes that can be processed is as follows:'       TYPE *, ' ' )       TYPE *, '   Node(s)         Access'.       DO I = 1, NUM_NODES =          IF (STR$POSITION(UAF_FILENAME(I), '::') .EQ. 0) THEN 4             TYPE *, '   ', CNODE_LIST(I), ' CLUSTER'
          ELSEI3             TYPE *, '   ', CNODE_LIST(I), ' DECNET'O          ENDIF       ENDDO        TYPE *, ' '          RETURN	       END   F C========================================================/DO_AUTHORIZE  o%       SUBROUTINE DO_AUTHORIZE        0  F **********************************************************************F *                                                                    *F *   Run the AUTHORIZE system utility.                                *F *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC'        INCLUDE '($LNMDEF)'        INCLUDE '($PSLDEF)'N       INCLUDE '($SSDEF)'       INCLUDE '($SYSSRVNAM)'         STRUCTURE /ITEM_LIST_3/ !          INTEGER*2 IBUFFER_LENGTHO          INTEGER*2 ITEM_CODE"          INTEGER   IBUFFER_ADDRESS)          INTEGER   IRETURN_LENGTH_ADDRESS        END STRUCTURE $       RECORD /ITEM_LIST_3/ ITMLST(2)  %       CHARACTER*60 SYSUAF_TRANSLATIONZ       INTEGER*2 LST          CHARACTER*60 TEMPSYSUAFI       CHARACTER*15 TEMPNODE    *-------------------------*  *     EXECUTABLE CODE     *  *-------------------------* 6                                                              TEMPNODE = NODESET  N       DO 100 WHILE (.TRUE.)   ! Loop to prompt user until a valid node is set.  ?          DO 70 I = 1, NUM_NODES   ! Check for valid node entry.              NODE = IE             IF (TEMPNODE .EQ. CNODE_LIST(I)) GO TO 110  ! Valid node.     70    ENDDO  ?          ISTATUS = LIB$GET_INPUT( TEMPNODE, 'For which node? ')E  C                               ! If some error occurred in the read,FA                               ! or the user entered a blank node, ?                               !  then cancel the AUTHORIZE run.              IF (.NOT. ISTATUS) THEN'             CALL ERROR_MESSAGE(ISTATUS) '             TYPE *, 'Action cancelled'               GO TO 200           ENDIF  $          IF (TEMPNODE .EQ. ' ') THEN'             TYPE *, 'Action cancelled'               GO TO 200           ENDIF  M          CALL STR$UPCASE( TEMPNODE, TEMPNODE ) ! Convert input to upper case.U  E   100 ENDDO   ! End of loop to process until a valid node is entered.   J                               ! Tell the user the node for which AUTHORIZE-                               !  will be run.     %   110 TEMPSYSUAF = UAF_FILENAME(NODE)   (       IF (TEMPSYSUAF .EQ. 'SYSUAF') THEN&          ITMLST(1).IBUFFER_LENGTH = 60*          ITMLST(1).ITEM_CODE = LNM$_STRING=          ITMLST(1).IBUFFER_ADDRESS = %LOC(SYSUAF_TRANSLATION) 5          ITMLST(1).IRETURN_LENGTH_ADDRESS = %LOC(LST) %          ITMLST(2).IBUFFER_LENGTH = 0            ITMLST(2).ITEM_CODE = 0  M          ISTATUS = SYS$TRNLNM( , 'LNM$SYSTEM', 'SYSUAF', PSL$C_EXEC, ITMLST )+L          IF (ISTATUS .EQ. SS$_NORMAL) TEMPSYSUAF = SYSUAF_TRANSLATION(1:LST)       ENDIF=  (       IF (TEMPSYSUAF .EQ. 'SYSUAF') THENJ          TYPE *, 'Unable to determine SYSUAF filename for node ', TEMPNODE          GO TO 200       ENDIF*         TYPE *, ' '*9       TYPE *, 'AUTHORIZE will be run for node ', TEMPNODE *       TYPE *, 'SYSUAF file = ', TEMPSYSUAF       TYPE *, ' 'sN       TYPE *, '*** Warning:  In running the AUTHORIZE utility from within ' //$      +        'SCANUAF for a remote'N       TYPE *, '              node, use caution in modifying the rightlist ' //      +        'file and/or the' J       TYPE *, '              DECnet proxy file.  SCANUAF will use the ' //      +        'remote node''s'O       TYPE *, '              authorization file, but it will use the local ' // "      +        'node''s rightslist'N       TYPE *, '              file and DECnet proxy file, which may not be ' //!      +        'the same as those' 1       TYPE *, '              of the remote node.'        TYPE *, ' 't  L                               ! Assign SYSUAF to the UAF on the proper node.  ;       ISTATUS = LIB$SET_LOGICAL('SYSUAF', TEMPSYSUAF, , , )*       IF (.NOT. ISTATUS) THENI*          TYPE *, 'LIB$SET_LOGICAL status:'$          CALL ERROR_MESSAGE(ISTATUS)       ENDIFE  D                               ! Spawn a subprocess to run AUTHORIZE.  5       ISTATUS = LIB$SPAWN('RUN SYS$SYSTEM:AUTHORIZE')-       IF (.NOT. ISTATUS) THENT$          TYPE *, 'LIB$SPAWN status:'$          CALL ERROR_MESSAGE(ISTATUS)       ENDIFo       TYPE *, ' 'm  0                               ! Deassign SYSUAF.  .       ISTATUS = LIB$DELETE_LOGICAL('SYSUAF', )       IF (.NOT. ISTATUS) THEN -          TYPE *, 'LIB$DELETE_LOGICAL status:'L$          CALL ERROR_MESSAGE(ISTATUS)       ENDIF      200 CONTINUE         RETURN	       END   F C=======================================================/LOGICAL_PARSE  L0       SUBROUTINE LOGICAL_PARSE( STRING, RESULT )  F **********************************************************************F *                                                                    *F *   Evaluate logical expression.                                     *F *                                                                    *F *   INPUT ARGUMENTS                                                  *F *   ---------------                                                  *2       CHARACTER*(*) STRING   ! Logical expression.  F *                                                                    *F *   OUTPUT ARGUMENTS                                                 *F *   ----------------                                                 *<       LOGICAL     RESULT     ! Result of logical expression.  F *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC'_         CHARACTER*1 OP       INTEGER I, L, R, LSTRING       LOGICAL LAST         VALID_INPUT = .TRUE.       LAST = .FALSE.       LSTRING = LEN(STRING).              DO 300 WHILE (.TRUE.)           L = 0          R = 0          DO I = 1, LSTRING*             IF (STRING(I:I) .EQ. '(') THEN                L = I/             ELSE IF (STRING(I:I) .EQ. ')') THEN                 R = I             ENDIFl2             IF (L .GT. 0 .AND. R .GT. 0) GO TO 200          ENDDO  )          IF (L .GT. 0 .OR. R .GT. 0) THENN             TYPE *, ' 'E3             TYPE *, 'Error - unmatched parentheses'e!             VALID_INPUT = .FALSE.R             GO TO 310P          ENDIF            L = 0          R = LSTRING+1          LAST = .TRUE.     200    RESULT = .TRUE.          OP = '&'P          DO I = L+1,R-1T*             IF (STRING(I:I) .EQ. '1') THEN<                IF (OP .EQ. '&') RESULT = RESULT .AND. .TRUE.<                IF (OP .EQ. '|') RESULT = RESULT .OR.  .TRUE./             ELSE IF (STRING(I:I) .EQ. '0') THEN'=                IF (OP .EQ. '&') RESULT = RESULT .AND. .FALSE. =                IF (OP .EQ. '|') RESULT = RESULT .OR.  .FALSE. I             ELSE IF (STRING(I:I) .EQ. '&' .OR. STRING(I:I) .EQ. '|') THENt                OP = STRING(I:I)O/             ELSE IF (STRING(I:I) .NE. ' ') THEN(                TYPE *, ' 'E                TYPE *, 'Error - unrecognized character ', STRING(I:I))$                VALID_INPUT = .FALSE.                GO TO 310             ENDIF              STRING(I:I) = ' '           ENDDO          IF (LAST) GO TO 310          STRING(L:L) = ' '          STRING(R:R) = '0'&          IF (RESULT) STRING(R:R) = '1'   300 ENDDO      310 CONTINUE       RETURN	       END   F C=====================================================/COMPARE_INTEGER  1-       SUBROUTINE COMPARE_INTEGER( INT_FILE,  E-      +                            INT_SPEC,   -      +                            COMP,      (-      +                            RESULT )   +  F **********************************************************************F *                                                                    *F *   Compare input integer value with UAF file integer value.         *F *                                                                    *F *   INPUT ARGUMENTS                                                  *F *   ---------------                                                  *5       INTEGER     INT_FILE   ! Integer from UAF file.M6       INTEGER     INT_SPEC   ! User-specified integer.=       CHARACTER*1 COMP       ! Comparison character (\, <, >, *                              !  or blank).F *                                                                    *F *   OUTPUT ARGUMENTS                                                 *F *   ----------------                                                 *4       LOGICAL     RESULT     ! Result of comparison.F *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC'R         CHARACTER*20 CTEMP   *-------------------------*  *     EXECUTABLE CODE     *N *-------------------------*   F                               ! Set RESULT based on the input integers>                               !  and the comparison character.         IF (COMP .EQ. '\') THENR       (          RESULT = INT_FILE .NE. INT_SPEC  "       ELSE IF (COMP .EQ. '>') THEN  C(          RESULT = INT_FILE .GT. INT_SPEC  "       ELSE IF (COMP .EQ. '<') THEN  _(          RESULT = INT_FILE .LT. INT_SPEC   
       ELSE   (          RESULT = INT_FILE .EQ. INT_SPEC  =       ENDIF=  A                               ! Save the data for output display.V  E%       IF (REPORTSET .EQ. 'FULL') THEN*0          THIS_BUFF = PARAM(MASTER_INDEX) // ': '(          WRITE (CTEMP, '(I20)') INT_FILE          J = 1          DO 100 I = 1, 20e)             IF (CTEMP(I:I) .NE. ' ') THEN*                J = I                GO TO 110             ENDIF    100    ENDDO,   110    THIS_BUFF(15:15+20-J) = CTEMP(J:20)3 C        WRITE (THIS_BUFF(15:24), '(I10)') INT_FILE        ENDIF           RETURN	       ENDRF C========================================================/COMPARE_DATE  ,       SUBROUTINE COMPARE_DATE( IDATE_FILE,  ,      +                         CDATE_SPEC,  ,      +                         COMP,        %      +                         DELTA,-,      +                         RESULT )       F **********************************************************************F *                                                                    *F *   Compare input date value with UAF file date value.               *F *                                                                    *F *   INPUT ARGUMENTS                                                  *F *   ---------------                                                  *A       INTEGER      IDATE_FILE(2)   ! Quadword date from UAF file.DC       CHARACTER*64 CDATE_SPEC      ! User-specified character date.IC       CHARACTER*1  COMP            ! Comparison character (\, <, >, 0                                    !  or blank).<       LOGICAL      DELTA           ! Absolute or delta time.F *                                                                    *F *   OUTPUT ARGUMENTS                                                 *F *   ----------------                                                 *:       LOGICAL      RESULT          ! Result of comparison.F *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC'   &       INTEGER IDATE_SPEC(2,MAX_PARAMS)         LOGICAL BJTEST         INTEGER SYS$BINTIM       INTEGER SYS$ASCTIM   *-------------------------*  *     EXECUTABLE CODE     *A *-------------------------*   F                               ! Compute the binary date for this input9                               !  parameter, if necessary.*  -       INDEX_DATE_CHECK = INDEX_DATE_CHECK + 1-       II = INDEX_DATE_CHECK *       IF (.NOT. RESET_DATE_CHECK) GO TO 50  E                               ! Convert the character date to binary.U  :       ISTATUS = SYS$BINTIM( CDATE_SPEC, IDATE_SPEC(1,II) )       IF (.NOT. ISTATUS) THENR$          CALL ERROR_MESSAGE(ISTATUS)          VALID_INPUT = .FALSE.          GO TO 900       ENDIFO  H                               ! Do a bit by bit comparison of the binary=                               !  to see which value is later.=      50 INT_FILE = 00       INT_SPEC = 0                                       DO 100 I = 62, 0, -1            ISUB = ( I / 32 ) + 1          IPOS = MOD( I, 32 )  B          IF      (       BJTEST( IDATE_FILE(ISUB),    IPOS ) .AND.C      +             .NOT. BJTEST( IDATE_SPEC(ISUB,II), IPOS ) ) THEN    ?             INT_FILE = 1     ! UAF date is later (absolute), or D             GO TO 110        ! User-specified date is later (delta).   B          ELSE IF ( .NOT. BJTEST( IDATE_FILE(ISUB),    IPOS ) .AND.C      +                   BJTEST( IDATE_SPEC(ISUB,II), IPOS ) ) THENt  J             INT_SPEC = 1     ! User-specified date is later (absolute), or9             GO TO 110        ! UAF date is later (delta).*  *          ENDIF      100 ENDDOT      110 CONTINUE  G                               ! Set RESULT based on INT_FILE, INT_SPEC, C                               !  and the comparison character COMP.          IF (COMP .EQ. '\') THENi       (          RESULT = INT_FILE .NE. INT_SPEC  "       ELSE IF (COMP .EQ. '>') THEN  n          IF (DELTA) THEN+             RESULT = INT_FILE .LT. INT_SPECt
          ELSE +             RESULT = INT_FILE .GT. INT_SPECs          ENDIF  "       ELSE IF (COMP .EQ. '<') THEN             IF (DELTA) THEN9             RESULT = INT_FILE .GT. INT_SPEC              t
          ELSE +             RESULT = INT_FILE .LT. INT_SPECU          ENDIF   
       ELSE  O(          RESULT = INT_FILE .EQ. INT_SPEC          ENDIFT  A                               ! Save the data for output display.(  %       IF (REPORTSET .EQ. 'FULL') THEN!0          THIS_BUFF = PARAM(MASTER_INDEX) // ': 'B          IF (IDATE_FILE(1) .EQ. 0 .AND. IDATE_FILE(2) .EQ. 0) THEN'             THIS_BUFF(15:40) = '(None)' 
          ELSEuC             ISTATUS = SYS$ASCTIM( , THIS_BUFF(15:40), IDATE_FILE, )e7             IF (.NOT. ISTATUS) THIS_BUFF(15:40) = '???'L          ENDIF       ENDIFE  L   900 RETURN	       END F C======================================================/COMPARE_STRING  -       SUBROUTINE COMPARE_STRING( STRING_FILE,=.      +                           STRING_SPEC, .      +                           COMP,        )      +                           COUNTED,*.      +                           RESULT )       F **********************************************************************F *                                                                    *F *   Compare input string value with UAF file string value.           *F *                                                                    *F *   INPUT ARGUMENTS                                                  *F *   ---------------                                                  *8       CHARACTER*(*) STRING_FILE  ! String from UAF file.9       CHARACTER*64  STRING_SPEC  ! User-specified string.=A       CHARACTER*1   COMP         ! Comparison character (\, <, >,*.                                  !  or blank).9       LOGICAL       COUNTED      ! Counted string or not. F *                                                                    *F *   OUTPUT ARGUMENTS                                                 *F *   ----------------                                                 *8       LOGICAL       RESULT       ! Result of comparison.F *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC'r         CHARACTER*1 CHAR_COUNT       BYTE BYTE_COUNT')       EQUIVALENCE (CHAR_COUNT,BYTE_COUNT)d   *-------------------------*Y *     EXECUTABLE CODE     *R *-------------------------*d  A                               ! If this is a counted string, thens:                               !  eliminate the count byte.         IF (COUNTED) THEN &          CHAR_COUNT = STRING_FILE(1:1)$          IF (BYTE_COUNT .LE. 0) THEN             STRING_FILE = ' ')
          ELSE <             STRING_FILE = STRING_FILE(2:BYTE_COUNT+1) // ' '          ENDIF       ENDIFO  J                               ! Set RESULT based on the input data and the6                               !  comparison character.         IF (COMP .EQ. '\') THENT       .          RESULT = STRING_FILE .NE. STRING_SPEC  "       ELSE IF (COMP .EQ. '>') THEN  *.          RESULT = STRING_FILE .GT. STRING_SPEC  "       ELSE IF (COMP .EQ. '<') THEN   .          RESULT = STRING_FILE .LT. STRING_SPEC   
       ELSE   .          RESULT = STRING_FILE .EQ. STRING_SPEC          ENDIF   A                               ! Save the data for output display.*  %       IF (REPORTSET .EQ. 'FULL') THENA?          THIS_BUFF = PARAM(MASTER_INDEX) // ': ' // STRING_FILEN       ENDIFD  (       RETURN	       END(F C==========================================================/PRIV_CHECK  (       SUBROUTINE PRIV_CHECK( MASK,      (      +                       PTEST,     (      +                       COMP,      (      +                       RESULT)      F **********************************************************************F *                                                                    *F *   Compare input privledge value with UAF privledge mask.           *F *                                                                    *F *   INPUT ARGUMENTS                                                  *F *   ---------------                                                  *A       INTEGER      MASK(2)    ! Quadword priv mask from UAF file.(;       CHARACTER*64 PTEST      ! Privledge being tested for. 5       CHARACTER*1  COMP       ! Comparison character. F *                                                                    *F *   OUTPUT ARGUMENTS                                                 *F *   ----------------                                                 *5       LOGICAL      RESULT     ! Result of comparison. F *                                                                    *F **********************************************************************         INCLUDE '($PRVDEF)'*       INCLUDE 'SCANUAF.INC'                                   INTEGER       JIBSET       LOGICAL       BJTEST  "       PARAMETER     NUM_PRIVS = 36  (       CHARACTER*9   PRIV_LIST(NUM_PRIVS)         CHARACTER*400 CHARPRIV  >       INTEGER       ICHECK(2,MAX_PARAMS), INMASK(2,MAX_PARAMS)  $       INTEGER       IPMIN(NUM_PRIVS)  *       INTEGER       IPRIV_INDEX(NUM_PRIVS)  G       DATA (PRIV_LIST(I), IPMIN(I), IPRIV_INDEX(I), I = 1, NUM_PRIVS) /U+      +   'ALL      ' , 3 , 0              ,E+      +   'ACNT     ' , 2 , PRV$V_ACNT     ,D+      +   'ALLSPOOL ' , 4 , PRV$V_ALLSPOOL ,M+      +   'ALTPRI   ' , 3 , PRV$V_ALTPRI   , +      +   'BUGCHK   ' , 2 , PRV$V_BUGCHK   , +      +   'BYPASS   ' , 2 , PRV$V_BYPASS   ,=+      +   'CMEXEC   ' , 3 , PRV$V_CMEXEC   ,E+      +   'CMKRNL   ' , 3 , PRV$V_CMKRNL   ,_+      +   'DETACH   ' , 2 , PRV$V_DETACH   ,)+      +   'DIAGNOSE ' , 2 , PRV$V_DIAGNOSE ,S+      +   'EXQUOTA  ' , 1 , PRV$V_EXQUOTA  ,e+      +   'GROUP    ' , 3 , PRV$V_GROUP    , +      +   'GRPNAM   ' , 4 , PRV$V_GRPNAM   ,*+      +   'GRPPRV   ' , 4 , PRV$V_GRPPRV   ,f+      +   'LOG_IO   ' , 1 , PRV$V_LOG_IO   ,i+      +   'MOUNT    ' , 1 , PRV$V_MOUNT    , +      +   'NETMBX   ' , 1 , PRV$V_NETMBX   ,Z+      +   'OPER     ' , 1 , PRV$V_OPER     ,A+      +   'PFNMAP   ' , 2 , PRV$V_PFNMAP   , +      +   'PHY_IO   ' , 2 , PRV$V_PHY_IO   ,s+      +   'PRMCEB   ' , 4 , PRV$V_PRMCEB   , +      +   'PRMGBL   ' , 4 , PRV$V_PRMGBL   ,S+      +   'PRMMBX   ' , 4 , PRV$V_PRMMBX   ,t+      +   'PSWAPM   ' , 2 , PRV$V_PSWAPM   ,o+      +   'READALL  ' , 1 , PRV$V_READALL  , +      +   'SECURITY ' , 3 , PRV$V_SECURITY ,Y+      +   'SETPRV   ' , 3 , PRV$V_SETPRV   ,l+      +   'SHARE    ' , 3 , PRV$V_SHARE    ,s+      +   'SHMEM    ' , 3 , PRV$V_SHMEM    ,o+      +   'SYSGBL   ' , 4 , PRV$V_SYSGBL   , +      +   'SYSLCK   ' , 4 , PRV$V_SYSLCK   ,o+      +   'SYSNAM   ' , 4 , PRV$V_SYSNAM   , +      +   'SYSPRV   ' , 4 , PRV$V_SYSPRV   ,*+      +   'TMPMBX   ' , 1 , PRV$V_TMPMBX   ,P+      +   'VOLPRO   ' , 1 , PRV$V_VOLPRO   , +      +   'WORLD    ' , 1 , PRV$V_WORLD    /   / CCC     +   'SETPRI   ' , ? , PRV$V_SETPRI    , / CCC     +   'UPGRADE  ' , 1 , PRV$V_UPGRADE   ,S/ CCC     +   'DOWNGRADE' , 2 , PRV$V_DOWNGRADE ,T/ CCC     +   'TMPJNL   ' , ? , PRV$V_TMPJNL    ,C/ CCC     +   'PRMJNL   ' , 4 , PRV$V_PRMJNL    ,Y                  *-------------------------*e *     EXECUTABLE CODE     *U *-------------------------*F  I                               ! Compute the mask for the input parameter,a.                               !  if necessary.  -       INDEX_PRIV_CHECK = INDEX_PRIV_CHECK + 1        II = INDEX_PRIV_CHECK=+       IF (.NOT. RESET_PRIV_CHECK) GO TO 300P         MARK = 1F       ICHECK(1,II) = 0    ! ICHECK tells which bits are to be checked..       ICHECK(2,II) = 0                        F       INMASK(1,II) = 0    ! INMASK is the privilege mask for the input'       INMASK(2,II) = 0    !  parameter.           DO 260 WHILE (.TRUE.)              J                               ! Find the next privilege in the input spec.            DO 100 I = MARK, 64(             IF (PTEST(I:I) .EQ. ' ' .OR.(      +          PTEST(I:I) .EQ. ',' .OR.(      +          PTEST(I:I) .EQ. '(' .OR./      +          PTEST(I:I) .EQ. ')' ) GO TO 100              ILO = I              GO TO 120P   100    ENDDO                           GO TO 270      120    DO 140 I = ILO, 64              IHI = I - 1 (             IF (PTEST(I:I) .EQ. ' ' .OR.(      +          PTEST(I:I) .EQ. ',' .OR.(      +          PTEST(I:I) .EQ. '(' .OR./      +          PTEST(I:I) .EQ. ')' ) GO TO 160*   140    ENDDO  *          IHI = IHI + 1            160    LEN = IHI - ILO + 1"                                   H          ISWITCH = 1           ! See if the privilege is preceded by NO.          IF (LEN .GE. 2) THENN0             IF (PTEST(ILO:ILO+1) .EQ. 'NO') THEN                ISWITCH = 0                ILO = ILO + 2                LEN = LEN - 2             ENDIFN          ENDIF  F          IF (LEN .LE. 0) GO TO 250      ! Privilege spec is too short.E          IF (LEN. GT. 9) GO TO 280      ! Privilege spec is too long.O     8          IALL = 0                       ! Check for ALL.$          IF (LEN .GE. IPMIN(1)) THENA             IF (PTEST(ILO:IHI) .EQ. PRIV_LIST(1)(1:LEN)) IALL = 1U          ENDIF  B          DO 200 I = 2, NUM_PRIVS        ! Build ICHECK and INMASK.&             IF (IALL .EQ. 1) GO TO 180  ,             IF (LEN .LT. IPMIN(I)) GO TO 200B             IF (PTEST(ILO:IHI) .NE. PRIV_LIST(I)(1:LEN)) GO TO 200  "   180       INDEX = IPRIV_INDEX(I)  %             ISUB = ( INDEX / 32 ) + 1 #             IPOS = MOD( INDEX, 32 ).  :             ICHECK(ISUB,II) = JIBSET(ICHECK(ISUB,II),IPOS)N             IF (ISWITCH .EQ. 1) INMASK(ISUB,II) = JIBSET(INMASK(ISUB,II),IPOS)  &             IF (IALL .EQ. 0) GO TO 250   200    ENDDO#          IF (IALL .EQ. 0) GO TO 280)     250    MARK = IHI + 1 $          IF (MARK .GT. 64) GO TO 270     260 ENDDO:  H                               ! Verify that there is something to check.  A   270 IF (ICHECK(1,II) .NE. 0 .OR. ICHECK(2,II) .NE. 0) GO TO 300T     280 TYPE *, ' ' 3       TYPE *, 'Invalid privilege specification - ',G*      +        PTEST(1:ISTRING_LAST(PTEST))       VALID_INPUT = .FALSE.N       GO TO 900      <   300 RESULT = .FALSE.        ! Compare the privilege masks.       DO I = 2, NUM_PRIVS +          ISUB = ( IPRIV_INDEX(I) / 32 ) + 1=)          IPOS = MOD( IPRIV_INDEX(I), 32 )E/          IF (BJTEST(ICHECK(ISUB,II),IPOS)) THENN#             IF (COMP .EQ. '=') THEN :                RESULT = BJTEST(INMASK(ISUB,II),IPOS) .EQ. /      +                  BJTEST(MASK(ISUB),IPOS)T*                IF (.NOT. RESULT) GO TO 400             ELSE:                RESULT = BJTEST(INMASK(ISUB,II),IPOS) .NE. /      +                  BJTEST(MASK(ISUB),IPOS) $                IF (RESULT) GO TO 400             ENDIF           ENDIF       ENDDO   +   400 IF (REPORTSET .EQ. 'BRIEF') GO TO 900 :       CHARPRIV = 'X'            ! Build the output string.       DO 500 I = 2, NUM_PRIVS +          ISUB = ( IPRIV_INDEX(I) / 32 ) + 1 )          IPOS = MOD( IPRIV_INDEX(I), 32 ) *          IF (BJTEST(MASK(ISUB),IPOS)) THEN'             LL = ISTRING_LAST(CHARPRIV)P<             CHARPRIV = CHARPRIV(1:LL) // ' ' // PRIV_LIST(I)          ENDIF   500 ENDDO 2       IF (CHARPRIV .EQ. 'X') CHARPRIV = '  (None)'  (       THIS_BUFF = PARAM(MASTER_INDEX) //;      +            ':' // CHARPRIV(2:ISTRING_LAST(CHARPRIV))-                    900 RETURN7       END                                               F C==========================================================/FLAG_CHECK  (       SUBROUTINE FLAG_CHECK( MASK,      (      +                       FTEST,     (      +                       COMP,      (      +                       RESULT)      F **********************************************************************F *                                                                    *F *   Compare input flag value with UAF flag mask.                     *F *                                                                    *F *   INPUT ARGUMENTS                                                  *F *   ---------------                                                  *@       INTEGER      MASK       ! Integer flag mask from UAF file.6       CHARACTER*64 FTEST      ! Flag being tested for.5       CHARACTER*1  COMP       ! Comparison character.EF *                                                                    *F *   OUTPUT ARGUMENTS                                                 *F *   ----------------                                                 *5       LOGICAL      RESULT     ! Result of comparison. F *                                                                    *F **********************************************************************         INCLUDE '($UAIDEF)'N       INCLUDE 'SCANUAF.INC'=                                  INTEGER       JIBSET       LOGICAL       BJTEST  "       PARAMETER     NUM_FLAGS = 21  (       CHARACTER*20  FLAG_LIST(NUM_FLAGS)         CHARACTER*420 CHARFLAG  :       INTEGER       ICHECK(MAX_PARAMS), INMASK(MAX_PARAMS)  $       INTEGER       IFMIN(NUM_FLAGS)  *       INTEGER       IFLAG_INDEX(NUM_FLAGS)(                                         G       DATA (FLAG_LIST(I), IFMIN(I), IFLAG_INDEX(I), I = 1, NUM_FLAGS) /dC      +   'ALL                 ' , 2 ,  0                         ,  C      +   'DISCTLY             ' , 4 ,  UAI$V_DISCTLY             ,  C      +   'DEFCLI              ' , 2 ,  UAI$V_DEFCLI              ,  C      +   'LOCKPWD             ' , 1 ,  UAI$V_LOCKPWD             , !B      +   'RESTRICTED          ' , 1 ,  UAI$V_RESTRICTED          ,C      +   'DISUSER             ' , 4 ,  UAI$V_DISACNT             , !C      +   'DISWELCOME          ' , 4 ,  UAI$V_DISWELCOM           , !C      +   'DISMAIL             ' , 4 ,  UAI$V_DISMAIL             , tC      +   'DISNEWMAIL          ' , 4 ,  UAI$V_NOMAIL              ,  C      +   'GENPWD              ' , 1 ,  UAI$V_GENPWD              ,  C      +   'PWD_EXPIRED         ' , 4 ,  UAI$V_PWD_EXPIRED         ,  C      +   'PWD2_EXPIRED        ' , 4 ,  UAI$V_PWD2_EXPIRED        , .C      +   'AUDIT               ' , 3 ,  UAI$V_AUDIT               ,  C      +   'DISREPORT           ' , 6 ,  UAI$V_DISREPORT           , *C      +   'DISRECONNECT        ' , 6 ,  UAI$V_DISRECONNECT        , XC      +   'AUTOLOGIN           ' , 3 ,  UAI$V_AUTOLOGIN           , ND      +   'DISFORCE_PWD_CHANGE ' , 4 ,  UAI$V_DISFORCE_PWD_CHANGE ,  B      +   'CAPTIVE             ' , 1 ,  UAI$V_CAPTIVE             ,C      +   'DISIMAGE            ' , 4 ,  UAI$V_DISIMAGE            ,  C      +   'DISPWDDIC           ' , 7 ,  UAI$V_DISPWDDIC           , DB      +   'DISPWDHIS           ' , 7 ,  UAI$V_DISPWDHIS           /   *-------------------------*  *     EXECUTABLE CODE     *r *-------------------------*y       I                               ! Compute the mask for the input parameter,S.                               !  if necessary.  -       INDEX_FLAG_CHECK = INDEX_FLAG_CHECK + 1O       II = INDEX_FLAG_CHECK +       IF (.NOT. RESET_FLAG_CHECK) GO TO 300r         MARK = 1D       ICHECK(II) = 0    ! ICHECK tells which bits are to be checked.J       INMASK(II) = 0    ! INMASK is the flag mask for the input parameter.         DO 260 WHILE (.TRUE.)   E                               ! Find the next flag in the input spec.(            DO 100 I = MARK, 64(             IF (FTEST(I:I) .EQ. ' ' .OR.(      +          FTEST(I:I) .EQ. ',' .OR.(      +          FTEST(I:I) .EQ. '(' .OR./      +          FTEST(I:I) .EQ. ')' ) GO TO 100              ILO = Ic             GO TO 120l   100    ENDDO            GO TO 270     120    DO 140 I = ILO, 64)             IHI = I - 1 (             IF (FTEST(I:I) .EQ. ' ' .OR.(      +          FTEST(I:I) .EQ. ',' .OR.(      +          FTEST(I:I) .EQ. '(' .OR./      +          FTEST(I:I) .EQ. ')' ) GO TO 160t   140    ENDDO            IHI = IHI + 1     160    LEN = IHI - ILO + 1  C          ISWITCH = 1           ! See if the flag is preceded by NO.           IF (LEN .GE. 2) THEN 0             IF (FTEST(ILO:ILO+1) .EQ. 'NO') THEN                ISWITCH = 0                ILO = ILO + 2                LEN = LEN - 2             ENDIFH          ENDIF  A          IF (LEN .LE. 0)  GO TO 250     ! Flag spec is too short. @          IF (LEN. GT. 12) GO TO 280     ! Flag spec is too long.     8          IALL = 0                       ! Check for ALL.$          IF (LEN .GE. IFMIN(1)) THENA             IF (FTEST(ILO:IHI) .EQ. FLAG_LIST(1)(1:LEN)) IALL = 1=          ENDIF  B          DO 200 I = 2, NUM_FLAGS        ! Build ICHECK and INMASK.&             IF (IALL .EQ. 1) GO TO 180  ,             IF (LEN .LT. IFMIN(I)) GO TO 200B             IF (FTEST(ILO:IHI) .NE. FLAG_LIST(I)(1:LEN)) GO TO 200  "   180       INDEX = IFLAG_INDEX(I)  7             ICHECK(II) = JIBSET(ICHECK(II),INDEX)      EE             IF (ISWITCH .EQ. 1) INMASK(II) = JIBSET(INMASK(II),INDEX)   &             IF (IALL .EQ. 0) GO TO 250   200    ENDDO#          IF (IALL .EQ. 0) GO TO 280U     250    MARK = IHI + 1L$          IF (MARK .GT. 64) GO TO 270     260 ENDDO   H                               ! Verify that there is something to check.  &   270 IF (ICHECK(II) .NE. 0) GO TO 300     280 TYPE *, ' ' .       TYPE *, 'Invalid flag specification - ',*      +        FTEST(1:ISTRING_LAST(FTEST))       VALID_INPUT = .FALSE.U1       GO TO 900                                     7   300 RESULT = .FALSE.        ! Compare the flag masks.*       DO I = 2, NUM_FLAGS           IPOS = IFLAG_INDEX(I)*          IF (BJTEST(ICHECK(II),IPOS)) THEN#             IF (COMP .EQ. '=') THEN F                RESULT = BJTEST(INMASK(II),IPOS) .EQ. BJTEST(MASK,IPOS)*                IF (.NOT. RESULT) GO TO 400             ELSEF                RESULT = BJTEST(INMASK(II),IPOS) .NE. BJTEST(MASK,IPOS)$                IF (RESULT) GO TO 400             ENDIFF9          ENDIF                                           E       ENDDOc  +   400 IF (REPORTSET .EQ. 'BRIEF') GO TO 900 8       CHARFLAG = 'X'          ! Build the output string.       DO 500 I = 2, NUM_FLAGS           IPOS = IFLAG_INDEX(I)$          IF (BJTEST(MASK,IPOS)) THEN'             LL = ISTRING_LAST(CHARFLAG) <             CHARFLAG = CHARFLAG(1:LL) // ' ' // FLAG_LIST(I)          ENDIF   500 ENDDO-2       IF (CHARFLAG .EQ. 'X') CHARFLAG = '  (None)'  (       THIS_BUFF = PARAM(MASTER_INDEX) //;      +            ':' // CHARFLAG(2:ISTRING_LAST(CHARFLAG))      900 RETURN	       END F C==========================================================/HOUR_CHECK  (       SUBROUTINE HOUR_CHECK( BMASK,     (      +                       HTEST,     (      +                       COMP,      (      +                       RESULT)      F **********************************************************************F *                                                                    *F *   Compare input hour value with UAF hour mask.                     *F *                                                                    *F *   INPUT ARGUMENTS                                                  *F *   ---------------                                                  *=       BYTE         BMASK(3)   ! Byte flag mask from UAF file. 6       CHARACTER*64 HTEST      ! Hour being tested for.5       CHARACTER*1  COMP       ! Comparison character. F *                                                                    *F *   OUTPUT ARGUMENTS                                                 *F *   ----------------                                                 *5       LOGICAL      RESULT     ! Result of comparison. F *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC'U(                                         :       INTEGER       ICHECK(MAX_PARAMS), INMASK(MAX_PARAMS)         CHARACTER*72  CHARHOUR  #       CHARACTER*4   FORM / '(I_)' / $                                     )       INTEGER       JIBSET, JIAND, JISHFT        LOGICAL       BJTEST       !       INTEGER       LIB$GET_INPUTL        INTEGER       STR$POSITION   *-------------------------** *     EXECUTABLE CODE     *  *-------------------------*   I                               ! Compute the mask for the input parameter,d.                               !  if necessary.  -       INDEX_HOUR_CHECK = INDEX_HOUR_CHECK + 1        II = INDEX_HOUR_CHECK +       IF (.NOT. RESET_HOUR_CHECK) GO TO 300-         MARK = 1D       ICHECK(II) = 0    ! ICHECK tells which bits are to be checked.J       INMASK(II) = 0    ! INMASK is the hour mask for the input parameter.         IF (HTEST .EQ. '()') THEN G          IF (COMP .EQ. '=' .OR. COMP .EQ. '\') ICHECK(II) = '00FFFFFF'X           GO TO 270       ENDIF          DO 260 WHILE (.TRUE.)   E                               ! Find the next hour in the input spec.-            DO 100 I = MARK, 64(             IF (HTEST(I:I) .EQ. ' ' .OR.(      +          HTEST(I:I) .EQ. ',' .OR.(      +          HTEST(I:I) .EQ. '(' .OR./      +          HTEST(I:I) .EQ. ')' ) GO TO 100*             ILO = I*             GO TO 120    100    ENDDO                           GO TO 270      120    DO 140 I = ILO, 64              IHI = I - 1 (             IF (HTEST(I:I) .EQ. ' ' .OR.(      +          HTEST(I:I) .EQ. ',' .OR.(      +          HTEST(I:I) .EQ. '(' .OR./      +          HTEST(I:I) .EQ. ')' ) GO TO 160X   140    ENDDO  M          IHI = IHI + 1            160    LEN = IHI - ILO + 1  >          IF (LEN .LE. 0) GO TO 250   ! Hour spec is too short.=          IF (LEN. GT. 5) GO TO 280   ! Hour spec is too long.'  4                               ! Parse the hour spec.            IF (LEN .LE. 2) THENL)             WRITE (FORM(3:3), '(I1)') LENI9             READ (HTEST(ILO:IHI), FORM, ERR=280) IHOUR_LOV             IHOUR_HI = IHOUR_LO 
          ELSEB4             IDASH = STR$POSITION(HTEST(ILO:IHI),'-');             IF (IDASH .LE. 1 .OR. IDASH .GE. LEN) GO TO 280E             JDASH = IDASH - 1)+             WRITE (FORM(3:3), '(I1)') JDASHSA             READ (HTEST(ILO:ILO+JDASH-1), FORM, ERR=280) IHOUR_LO'             JDASH = LEN - IDASH +             WRITE (FORM(3:3), '(I1)') JDASH ?             READ (HTEST(ILO+IDASH:IHI), FORM, ERR=280) IHOUR_HIP          ENDIF  =          IF (IHOUR_LO .LT. 0 .OR. IHOUR_HI .GT. 23) GO TO 280 .          IF (IHOUR_LO .GT. IHOUR_HI) GO TO 280             H          DO 200 I = IHOUR_LO, IHOUR_HI        ! Build ICHECK and INMASK.-             ICHECK(II) = JIBSET(ICHECK(II),I) -             INMASK(II) = JIBSET(INMASK(II),I)'   200    ENDDO     250    MARK = IHI + 1 $          IF (MARK .GT. 64) GO TO 270     260 ENDDO,  H                               ! Verify that there is something to check.  &   270 IF (ICHECK(II) .NE. 0) GO TO 300     280 TYPE *, ' 'P.       TYPE *, 'Invalid hour specification - ',*      +        HTEST(1:ISTRING_LAST(HTEST))       VALID_INPUT = .FALSE.Y       GO TO 900V        300 RESULT = .FALSE.  7                               ! Compare the hour masks.P         MASK1 = BMASK(1)&       MASK1 = JIAND(MASK1,'000000FF'X)         MASK2 = BMASK(2)&       MASK2 = JIAND(MASK2,'000000FF'X)       MASK2 = JISHFT(MASK2,8)          MASK3 = BMASK(3)&       MASK3 = JIAND(MASK3,'000000FF'X)       MASK3 = JISHFT(MASK3,16)  "       MASK = MASK1 + MASK2 + MASK3)                                          N       IF (COMP .EQ. '<') THEN           MARK = 24          DO IPOS = 0, 23-             IF (BJTEST(INMASK(II),IPOS)) THEN                 MARK = IPOS                GO TO 320             ENDIF-          ENDDO   320    DO IPOS = 0, 23-             IF (.NOT. BJTEST(MASK,IPOS)) THENt2                IF (IPOS .LT. MARK) RESULT = .TRUE.                GO TO 400             ENDIF           ENDDO          GO TO 400       ENDIFT         IF (COMP .EQ. '>') THEN           MARK = -1          DO IPOS = 23, 0, -1-             IF (BJTEST(INMASK(II),IPOS)) THENE                MARK = IPOS                GO TO 340             ENDIFi          ENDDO   340    DO IPOS = 23, 0, -1-             IF (.NOT. BJTEST(MASK,IPOS)) THENW2                IF (IPOS .GT. MARK) RESULT = .TRUE.                GO TO 400             ENDIFt          ENDDO          GO TO 400       ENDIF      (         DO IPOS = 0, 23 *          IF (BJTEST(ICHECK(II),IPOS)) THEN#             IF (COMP .EQ. '=') THEN.F                RESULT = BJTEST(INMASK(II),IPOS) .NE. BJTEST(MASK,IPOS)*                IF (.NOT. RESULT) GO TO 400             ELSEF                RESULT = BJTEST(INMASK(II),IPOS) .EQ. BJTEST(MASK,IPOS)$                IF (RESULT) GO TO 400             ENDIF           ENDIF       ENDDO.  +   400 IF (REPORTSET .EQ. 'BRIEF') GO TO 900 F       IF (MASK .EQ. 0) THEN                 ! Build the output string.#          CHARHOUR = '(Full access)'L*       ELSE IF (MASK .EQ. '00FFFFFF'X) THEN!          CHARHOUR = '(No access)' 
       ELSE          CHARHOUR = ' 'e          DO 500 IPOS = 0, 23,             IF (BJTEST(MASK,IPOS)) GO TO 500'             LL = ISTRING_LAST(CHARHOUR)=4             WRITE (CHARHOUR(LL+2:LL+3), '(I2)') IPOS   500    ENDDO       ENDIF   9       THIS_BUFF = PARAM(MASTER_INDEX) // ': ' // CHARHOURr     900 RETURN	       END F C===========================================================/DAY_CHECK                             (       SUBROUTINE DAY_CHECK( BMASK,      '      +                      DTEST,      '      +                      COMP,      N'      +                      RESULT)    D  F **********************************************************************F *                                                                    *F *   Compare input day value with UAF day mask.                       *F *                                                                    *F *   INPUT ARGUMENTS                                                  *F *   ---------------                                                  *<       BYTE         BMASK      ! Byte day mask from UAF file.5       CHARACTER*64 DTEST      ! Day being tested for.E5       CHARACTER*1  COMP       ! Comparison character.IF *                                                                    *F *   OUTPUT ARGUMENTS                                                 *F *   ----------------                                                 *5       LOGICAL      RESULT     ! Result of comparison.+F *                                                                    *F **********************************************************************#                                            INCLUDE '($UAIDEF)'E       INCLUDE 'SCANUAF.INC'O                                  INTEGER       JIBSET       LOGICAL       BJTEST          PARAMETER     NUM_DAYS = 8  &       CHARACTER*9   DAY_LIST(NUM_DAYS)                          CHARACTER*100 CHARDAYM  :       INTEGER       ICHECK(MAX_PARAMS), INMASK(MAX_PARAMS)                           #       INTEGER       IDMIN(NUM_DAYS)I  (       INTEGER       IDAY_INDEX(NUM_DAYS)(                                         D       DATA (DAY_LIST(I), IDMIN(I), IDAY_INDEX(I), I = 1, NUM_DAYS) /      +   'ALL      ' , 1,  0 ,,      +   'MONDAY   ' , 1 , UAI$V_MONDAY    ,,      +   'TUESDAY  ' , 2 , UAI$V_TUESDAY   ,,      +   'WEDNESDAY' , 1 , UAI$V_WEDNESDAY ,,      +   'THURSDAY ' , 2 , UAI$V_THURSDAY  ,,      +   'FRIDAY   ' , 1 , UAI$V_FRIDAY    ,,      +   'SATURDAY ' , 2 , UAI$V_SATURDAY  ,,      +   'SUNDAY   ' , 2 , UAI$V_SUNDAY    /                  *-------------------------*  *     EXECUTABLE CODE     *C *-------------------------*   I                               ! Compute the mask for the input parameter,N.                               !  if necessary.  +       INDEX_DAY_CHECK = INDEX_DAY_CHECK + 1        II = INDEX_DAY_CHECK*       IF (.NOT. RESET_DAY_CHECK) GO TO 300         MARK = 1E       ICHECK(II) = 0     ! ICHECK tells which bits are to be checked.EJ       INMASK(II) = 0     ! INMASK is the day mask for the input parameter.         DO 260 WHILE (.TRUE.)*  D                               ! Find the next day in the input spec.                 DO 100 I = MARK, 64(             IF (DTEST(I:I) .EQ. ' ' .OR.(      +          DTEST(I:I) .EQ. ',' .OR.(      +          DTEST(I:I) .EQ. '(' .OR./      +          DTEST(I:I) .EQ. ')' ) GO TO 100              ILO = I              GO TO 120    100    ENDDO             GO TO 270      120    DO 140 I = ILO, 64              IHI = I - 1E(             IF (DTEST(I:I) .EQ. ' ' .OR.(      +          DTEST(I:I) .EQ. ',' .OR.(      +          DTEST(I:I) .EQ. '(' .OR./      +          DTEST(I:I) .EQ. ')' ) GO TO 160    140    ENDDO             IHI = IHI + 1            160    LEN = IHI - ILO + 1                                  B          ISWITCH = 1           ! See if the day is preceded by NO.          IF (LEN .GE. 2) THENA0             IF (DTEST(ILO:ILO+1) .EQ. 'NO') THEN                ISWITCH = 0                ILO = ILO + 28                LEN = LEN - 2                                         ENDIF*          ENDIF  ?          IF (LEN .LE. 0) GO TO 250     ! Day spec is too short. >          IF (LEN. GT. 9) GO TO 280     ! Day spec is too long.     7          IALL = 0                      ! Check for ALL.L$          IF (LEN .GE. IDMIN(1)) THEN@             IF (DTEST(ILO:IHI) .EQ. DAY_LIST(1)(1:LEN)) IALL = 1          ENDIF  A          DO 200 I = 2, NUM_DAYS        ! Build ICHECK and INMASK.L&             IF (IALL .EQ. 1) GO TO 180  ,             IF (LEN .LT. IDMIN(I)) GO TO 200A             IF (DTEST(ILO:IHI) .NE. DAY_LIST(I)(1:LEN)) GO TO 200   !   180       INDEX = IDAY_INDEX(I)   1             ICHECK(II) = JIBSET(ICHECK(II),INDEX) E             IF (ISWITCH .EQ. 1) INMASK(II) = JIBSET(INMASK(II),INDEX)   &             IF (IALL .EQ. 0) GO TO 250   200    ENDDO#          IF (IALL .EQ. 0) GO TO 280T     250    MARK = IHI + 1I$          IF (MARK .GT. 64) GO TO 270     260 ENDDO   H                               ! Verify that there is something to check.  &   270 IF (ICHECK(II) .NE. 0) GO TO 300     280 TYPE *, ' ' -       TYPE *, 'Invalid day specification - ',+*      +        DTEST(1:ISTRING_LAST(DTEST))       VALID_INPUT = .FALSE.'       GO TO 900   6   300 RESULT = .FALSE.        ! Compare the day masks.       MASK = BMASK   U       DO I = 2, NUM_DAYS          IPOS = IDAY_INDEX(I) *          IF (BJTEST(ICHECK(II),IPOS)) THEN#             IF (COMP .EQ. '=') THENUF                RESULT = BJTEST(INMASK(II),IPOS) .NE. BJTEST(MASK,IPOS)*                IF (.NOT. RESULT) GO TO 400             ELSEF                RESULT = BJTEST(INMASK(II),IPOS) .EQ. BJTEST(MASK,IPOS)$                IF (RESULT) GO TO 400             ENDIFC          ENDIF       ENDDO_  +   400 IF (REPORTSET .EQ. 'BRIEF') GO TO 900 8       CHARDAY = 'X'           ! Build the output string.       DO 500 I = 2, NUM_DAYS          IPOS = IDAY_INDEX(I)P*          IF (.NOT. BJTEST(MASK,IPOS)) THEN&             LL = ISTRING_LAST(CHARDAY)9             CHARDAY = CHARDAY(1:LL) // ' ' // DAY_LIST(I)-          ENDIF   500 ENDDOC0       IF (CHARDAY .EQ. 'X') CHARDAY = '  (None)'  (       THIS_BUFF = PARAM(MASTER_INDEX) //9      +            ':' // CHARDAY(2:ISTRING_LAST(CHARDAY))      900 RETURN	       END F C==========================================================/AST_ENABLE         SUBROUTINE AST_ENABLEK  F **********************************************************************F *                                                                    *F *   This subroutine queues an I/O request for trapping a ^C entry.   *F *                                                                    *F **********************************************************************  D       INCLUDE '($IODEF)'                ! Symbols for I/O operations  @       EXTERNAL AST_HANDLER              ! AST handler subroutine         INTEGER*2 ICHANO         INTEGER SYS$ASSIGN,       +        SYS$QIOW         LOGICAL FIRST  / .TRUE. /   H<       STRUCTURE /IOSTAT_BLOCK/          ! Structure for IOSB!                  INTEGER*2 IOSTAT $                  BYTE      TRANSMIT,#      +                     RECEIVE, "      +                     CRFILL,"      +                     LFFILL,"      +                     PARITY,      +                     ZERO        END STRUCTURE           RECORD /IOSTAT_BLOCK/ IOSB   *-------------------------*N *     EXECUTABLE CODE     *T *-------------------------*I  H                                 ! If this is the first call, then assign3                                 !  the I/O channel.s         IF (FIRST) THEN           FIRST = .FALSE.6          ISTATUS = SYS$ASSIGN( 'SYS$INPUT', ICHAN, , )           IF (.NOT. ISTATUS) THENB             TYPE *, 'SYS$ASSIGN error ', ISTATUS, ' - ^C Disabled'             GO TO 900L          ENDIF       ENDIFF  ;       ICODE = IO$_SETMODE .OR. IO$M_CTRLCAST    ! QIO code.I  8                                 ! Queue the I/O request.         ISTATUS = SYS$QIOW( ,2&      +                    %VAL(ICHAN),&      +                    %VAL(ICODE),      +                    IOSB,       +                    , ,C&      +                    AST_HANDLER,      +                    ,J!      +                    , , , )   H                                 ! If the request didn't work, then close,                                 !  the show.         IF (.NOT. ISTATUS) THEN <          TYPE *, 'SYS$QIO error ', ISTATUS, ' - ^C Disabled'          GO TO 900       ENDIF   !       IF (.NOT. IOSB.IOSTAT) THEN E          TYPE *, 'SYS$QIO IOSB error ', IOSB.IOSTAT, ' - ^C Disabled'+          GO TO 900       ENDIFT     900 RETURN	       ENDLF C=========================================================/AST_HANDLER         SUBROUTINE AST_HANDLER  F **********************************************************************F *                                                                    *F *   This subroutine is used to handle a ^C interrupt (AST).          *F *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC'O         CHARACTER*1 CHAR         INTEGER LIB$GET_INPUT    *-------------------------*  *     EXECUTABLE CODE     *E *-------------------------*   J                               ! Set the flag for a ^C interrupt, according>                               !  to what the user wants to do.       J   100 ISTATUS = LIB$GET_INPUT( CHAR, 'Enter 0 to continue, 1 to abort ' //M      +                       'this node, 2 to abort the entire search [2]: ')R  C                               ! If some error occurred in the read,I>                               !  then abort the entire search.         IF (.NOT. ISTATUS) THEN $          CALL ERROR_MESSAGE(ISTATUS)          ICONTROL_C = 2O<       ELSE IF (CHAR .EQ. '0') THEN                                    ICONTROL_C = 0T"       ELSE IF (CHAR .EQ. '1') THEN          ICONTROL_C = 1 5       ELSE IF (CHAR .EQ. '2' .OR. CHAR .EQ. ' ') THEN*          ICONTROL_C = 2*
       ELSE          GO TO 100       ENDIF   L                                 ! Queue another I/O request for ^C handling.J                                 !  (Once an interrupt has been handled, it8                                 !  is no longer queued.)         CALL AST_ENABLE          RETURN	       END F C========================================================/ISTRING_LAST  -       INTEGER FUNCTION ISTRING_LAST( STRING )A  F **********************************************************************F *                                                                    *F *   This function is used to find the position of the last           *F *   non-blank character in a character string.                       *F *                                                                    *F *   INPUT ARGUMENTS                                                  *F *   ---------------                                                  *5       CHARACTER*(*) STRING   ! String to be searched.FF *                                                                    *F **********************************************************************   *---------------------*' *   EXECUTABLE CODE   *  *---------------------*          L = LEN(STRING)I         ISTRING_LAST = 0  D                                 ! Find the last non-blank character.         IF (L.GT.0) THEN          DO I = L, 1, -1*             IF (STRING(I:I) .NE. ' ') THEN                ISTRING_LAST = I                 GO TO 100             ENDIFp          ENDDO       ENDIF      100 RETURN	       ENDsF C=======================================================/ERROR_MESSAGE  4       SUBROUTINE ERROR_MESSAGE( MESSAGE_DESCRIPTOR )  F **********************************************************************F *                                                                    *F *   This subroutine is used to print error messages.                 *F *                                                                    *F *   INPUT ARGUMENTS                                                  *F *   ---------------                                                  *A       INTEGER MESSAGE_DESCRIPTOR      ! VAX/VMS error descriptor. F *                                                                    *F **********************************************************************         INTEGER MSGVEC(2)          INTEGER SYS$PUTMSG   *---------------------*  *   EXECUTABLE CODE   *6 *---------------------*   9                               ! Build the message vector.          MSGVEC(1) = 1.$       MSGVEC(2) = MESSAGE_DESCRIPTOR  )       ISTATUS = SYS$PUTMSG( MSGVEC, , , )O         RETURN	       ENDMF C==========================================================/BLOCK_DATA         BLOCK DATA BLOCK_DATA   F **********************************************************************F *                                                                    *F *   Block data to initialize common variables in 'SCANUAF.INC'.      *F *                                                                    *F **********************************************************************         INCLUDE 'SCANUAF.INC'   J       DATA (PARAM(I),       ISTAR(I), TYPE(I), COMPCHARS(I), I=1,MASTER) /9      +      'RTYPE       ',   2,       'I',       '=\<>', 9      +      'VERSION     ',   1,       'I',       '=\<>',R9      +      'USRDATOFF   ',   3,       'I',       '=\<>',F9      +      'USERNAME    ',   3,       'C',       '=\<>',:9      +      'MEMBER      ',   2,       'I',       '=\<>',I9      +      'GROUP       ',   1,       'I',       '=\<>', 9      +      'SUBID       ',   4,       'I',       '=\<>', 9      +      'PARENTID    ',   3,       'C',       '=\<>',d9      +      'ACCOUNT     ',   2,       'C',       '=\<>', 9      +      'OWNER       ',   1,       'C',       '=\<>',O9      +      'DEVICE      ',   3,       'C',       '=\<>', 9      +      'DIRECTORY   ',   3,       'C',       '=\<>',e9      +      'LGICMD      ',   2,       'C',       '=\<>',I9      +      'CLI         ',   3,       'C',       '=\<>',I9      +      'CLITABLES   ',   4,       'C',       '=\<>',N9      +      'PASSWORD    ',   8,       'C',       '=\<>',09      +      'PASSWORD2   ',   9,       'C',       '=\<>', 9      +      'LOGFAILS    ',   4,       'I',       '=\<>', 9      +      'SALT        ',   2,       'I',       '=\<>',S9      +      'ENCRYPT     ',   7,       'I',       '=\<>', 9      +      'ENCRYPT2    ',   8,       'I',       '=\<>',I9      +      'PWDMINIMUM  ',   4,       'I',       '=\<>', 9      +      'EXPIRATION  ',   2,       'C',       '=\<>', 9      +      'PWDLIFETIME ',   4,       'C',       '=\<>',M9      +      'PWDDATE     ',   7,       'C',       '=\<>',I9      +      'PWDDATE2    ',   8,       'C',       '=\<>', 9      +      'LOGINT      ',   4,       'C',       '=\<>', 9      +      'LOGNONINT   ',   4,       'C',       '=\<>',)7      +      'PRIVILEGE   ',   4,       'C',       '=\',.7      +      'DEFPRIVILEGE',   3,       'C',       '=\',E9      +      'MINCLASS    ',   2,       'C',       '=\<>',Q9      +      'MAXCLASS    ',   4,       'C',       '=\<>', 7      +      'FLAGS       ',   2,       'C',       '=\', 9      +      'NETWORKPRIME',   8,       'C',       '=\<>', 9      +      'NETWORKSEC  ',   8,       'C',       '=\<>', 9      +      'BATCHPRIME  ',   6,       'C',       '=\<>', 9      +      'BATCHSEC    ',   6,       'C',       '=\<>', 9      +      'LOCALPRIME  ',   6,       'C',       '=\<>', 9      +      'LOCALSEC    ',   6,       'C',       '=\<>',S9      +      'DIALUPPRIME ',   7,       'C',       '=\<>',E9      +      'DIALUPSEC   ',   7,       'C',       '=\<>',T9      +      'REMOTEPRIME ',   7,       'C',       '=\<>', 9      +      'REMOTESEC   ',   7,       'C',       '=\<>',,7      +      'PRIMEDAYS   ',   4,       'C',       '=\',G9      +      'PRIORITY    ',   4,       'I',       '=\<>', 9      +      'QUEPRI      ',   1,       'I',       '=\<>',A9      +      'MAXJOBS     ',   4,       'I',       '=\<>', 9      +      'MAXACCTJOBS ',   4,       'I',       '=\<>',E9      +      'MAXDETACH   ',   4,       'I',       '=\<>', 9      +      'PRCLM       ',   3,       'I',       '=\<>',09      +      'BIOLM       ',   2,       'I',       '=\<>', 9      +      'DIOLM       ',   3,       'I',       '=\<>',U9      +      'TQELM       ',   1,       'I',       '=\<>', 9      +      'ASTLM       ',   2,       'I',       '=\<>', 9      +      'ENQLM       ',   3,       'I',       '=\<>',=9      +      'FILLM       ',   2,       'I',       '=\<>', 9      +      'SHRFILLM    ',   2,       'I',       '=\<>', 9      +      'WSQUOTA     ',   3,       'I',       '=\<>', 9      +      'WSDEFAULT   ',   3,       'I',       '=\<>', 9      +      'WSEXTENT    ',   3,       'I',       '=\<>',*9      +      'PGFLQUOTA   ',   2,       'I',       '=\<>', 9      +      'CPUTIME     ',   2,       'I',       '=\<>',F9      +      'BYTLM       ',   2,       'I',       '=\<>', 9      +      'PBYTLM      ',   2,       'I',       '=\<>',R9      +      'JTQUOTA     ',   1,       'I',       '=\<>', 9      +      'PROXYLIM    ',   6,       'I',       '=\<>', 9      +      'PROXYUSE    ',   6,       'I',       '=\<>',r9      +      'SUBACCLIM   ',   7,       'I',       '=\<>',t9      +      'SUBACCUSE   ',   7,       'I',       '=\<>'/t         DATA NODESET    / 'ALL' /         DATA REPORTSET  / 'FULL' /&       DATA OUTPUTSET  / 'SYS$OUTPUT' /       DATA LUN        / 6 /   	       END 