 	INTEGER FUNCTION list_command 	IMPLICIT NONE   	INCLUDE '($ssdef)'   % 	CHARACTER *  32 identifier, username  	CHARACTER * 255 outfile  A 	INTEGER context, ident_value, ilen, olen, status, uic( 2 ), ulen   A 	INTEGER cli$get_value, cli$present, sys$asctoid, sys$find_holder  	INTEGER sys$idtoasc   	LOGICAL more, none_held  7 C	Obtain the identifier whose holders are to be listed.   9 	status = cli$get_value( 'identifier', identifier, ilen )  	IF( status )THEN   I C	    Obtain the specification for the output file into which the listing , C	    will be placed.  Open the output file.  6 	    status = cli$get_value( 'output', outfile, olen ) 	    IF( .NOT. status )THEN    		outfile = 'SYS$OUTPUT' 		olen = 10    	    END IF H 	    OPEN( FILE = outfile( : olen ), UNIT = 1, CARRIAGECONTROL = 'list',< 	1	  DEFAULTFILE = '.dis', IOSTAT = status, STATUS = 'new' ) 	    IF( status .EQ. 0 )THEN  % C		Place a header in the output file.   2 		WRITE( 1, '( ''!Holders of identifier '', A )' ) 	1	       identifier( : ilen )8 		WRITE( 1, '( ''!-------------------------------'' )' )  @ C		Handle the special case of a _READER_ADMIN identifiers.  They0 C		don't really exist.  Remove the _READER part.   		IF( ilen .GT. 13 )THEN  - 		    IF( identifier( ilen - 12 : ilen ) .EQ.  	1		'_READER_ADMIN' )THEN   5 			identifier = identifier( : ilen - 13 ) // '_ADMIN'  			ilen = ilen - 7   		    END IF   		END IF  0 C		Obtain the value of the specified identifier.  < 		status = sys$asctoid( identifier( : ilen ), ident_value, ) 		IF( status )THEN  A C		    Determine each holder of the specified identifier, writing C C		    the results to the listing file.  Establish a search context 3 C		    and assume that no one holds the identifier.    		    context = 0  		    none_held = .TRUE. 		    more = .TRUE.  		    DO WHILE( more )  8 			status = sys$find_holder( %val( ident_value ), uic, , 	1					  context ) 			IF( status )THEN   ; C			    A holder has been found.  Convert the UIC to a name ( C			    and write it to the output file.   			    none_held = .FALSE.5 			    status = sys$idtoasc( %val( uic ( 1 ) ), ulen,  	1					  username, , , ) 			    IF( .NOT. status )THEN   4 C				The UIC is not in the rightslist.  Format it as C				a UIC.   , 				CALL lib$sys_fao( '!%U', ulen, username, 	1					  %val( uic( 1 ) ) )   
 			    END IF , 			    WRITE( 1, '( A )' )username( : ulen )  * 			ELSE IF( status .EQ. SS$_NOSUCHID )THEN  6 C			    All holders have been found.  Stop the search.   			    more = .FALSE.    			ELSE   ; C			    An error occurred while searching for holders.  Let  C			    the user know.  : 			    CALL error( status , 'E-ERRFINDHELD, could not ' // 	1				'find holder for ' //  	2				identifier( : ilen ) ) 			    more = .FALSE.   	 			END IF    		    END DO   		ELSE  B C		    An error occurred while converting the specified identifier& C		    to a value.  Let the user know.   		    CALL error( status, 2 	1			'E-ERRASCTOID, error obtaining value for ' // 	2			identifier( : ilen ) )    		END IF 		CLOSE( UNIT = 1 )   	 	    ELSE  	 A C		Could not open the output file.  Find out why and let the user  C		know.   		CALL errsns( , status ) @ 		CALL error( status, 'E-OPENFAIL, could not open output file' )   	    END IF    	ELSE   B C	    Could not obtain the identifier value.  Let the caller know.  E 	    CALL error( status, 'E-NOIDENT, unable to obtain Identifier ' //  	1		'from command line' )    	END IF  	list_command = SS$_NORMAL 	RETURN  	END< C	 VAX/DEC CMS REPLACEMENT HISTORY, Element LIST_COMMAND.FORJ C	 *1    31-MAR-1994 12:05:25 TILLMAN "LIST command processor for PROJECT"< C	 VAX/DEC CMS REPLACEMENT HISTORY, Element LIST_COMMAND.FOR