/***************************************************************************
                          MyWidgets.cpp  -  description
                             -------------------
    begin                : Mon Dec 11 2000
    copyright            : (C) 2000 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>
#include <ctype.h>
#include "opt.h"
#include "MyWidgets.h"
#include "interpreter.h"

#include "qtabbar.h"
#include "qpainter.h"
#include "qmessagebox.h"
#include <QPixmap>
#include <QMouseEvent>
#include "tcputil.h"

extern OPT opt;

////////////////////////////////////////////////////////////////////////////////
MyDialog::MyDialog(Interpreter *inter, int *sock, int ident, QWidget * parent, const char *name, bool modal, Qt::WFlags f)
         :QDialog(parent,name,modal,f)
{
  s  = sock;
  id = ident;
  interpreter = inter;
  QIcon appIcon(":/images/app.png");
  setWindowIcon(appIcon);
}

MyDialog::~MyDialog()
{
  interpreter->slotModalTerminate();
}

void MyDialog::done(int result)
{
  interpreter->slotModalTerminate();
  if(result == 0) return;
}

////////////////////////////////////////////////////////////////////////////////
MyQWidget::MyQWidget(int *sock, int ident, QWidget * parent, const char * name)
          :QWidget(parent,name)
{
  s = sock;
  id = ident;
}

MyQWidget::~MyQWidget()
{
}

void MyQWidget::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == Qt::RightButton)
  {
    char buf[80];

    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}

////////////////////////////////////////////////////////////////////////////////
MyQPushButton::MyQPushButton(int *sock, int ident, QWidget * parent, const char * name)
              :QPushButton(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(pressed()),  SLOT(slotPressed()));
  connect(this, SIGNAL(released()), SLOT(slotReleased()));
  connect(this, SIGNAL(clicked()),  SLOT(slotClicked()));
}

MyQPushButton::~MyQPushButton()
{
}

void MyQPushButton::slotClicked()
{
char buf[80];

  sprintf(buf,"QPushButton(%d)\n",id);
  tcp_send(s,buf,strlen(buf));
}

void MyQPushButton::slotPressed()
{
char buf[80];

  sprintf(buf,"QPushButtonPressed(%d)\n",id);
  tcp_send(s,buf,strlen(buf));
}

void MyQPushButton::slotReleased()
{
char buf[80];

  sprintf(buf,"QPushButtonReleased(%d)\n",id);
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyLineEdit::MyLineEdit(int *sock, int ident, QWidget * parent, const char * name)
           :QLineEdit(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(textChanged(const QString &)), SLOT(slotTextChanged(const QString &)));
  connect(this, SIGNAL(returnPressed()), SLOT(slotReturnPressed()));
}

MyLineEdit::~MyLineEdit()
{
}

void MyLineEdit::slotTextChanged(const QString &txt)
{
  char buf[MAX_PRINTF_LENGTH];

  if(txt.length()+40 > MAX_PRINTF_LENGTH) return;
  sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) txt.toUtf8());
  tcp_send(s,buf,strlen(buf));
}

void MyLineEdit::slotReturnPressed()
{
  char buf[MAX_PRINTF_LENGTH];

  sprintf(buf,"QPushButton(%d,\"%s\")\n",id,(const char *) text());
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyComboBox::MyComboBox(int *sock, int ident, QWidget * parent, const char * name)
           :QComboBox(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(activated(const QString &)), SLOT(slotActivated(const QString &)));
}

MyComboBox::~MyComboBox()
{
}

void MyComboBox::slotActivated(const QString &txt)
{
  char buf[MAX_PRINTF_LENGTH];

  if(txt.length()+40 > MAX_PRINTF_LENGTH) return;
  sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) txt.toUtf8());
  tcp_send(s,buf,strlen(buf));
}

void MyComboBox::removeItemByName(QString name)
{
  int i = 0;
  while(i < count())
  {
    if(text(i) == name) removeItem(i);
    i++;
  }
}

////////////////////////////////////////////////////////////////////////////////
MySlider::MySlider(int *sock, int ident, int minValue, int maxValue, int pageStep, int value, Qt::Orientation orientation, QWidget * parent, const char * name)
         :QSlider(minValue,maxValue,pageStep,value,orientation,parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(int)), SLOT(slotValueChanged(int)));
}

MySlider::~MySlider()
{
}

void MySlider::slotValueChanged(int value)
{
char buf[80];

  sprintf(buf,"slider(%d,%d)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyCheckBox::MyCheckBox(int *sock, int ident, QWidget * parent, const char * name)
           :QCheckBox(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(clicked()), SLOT(slotClicked()));
}

MyCheckBox::~MyCheckBox()
{
}

void MyCheckBox::slotClicked()
{
char buf[80];

  if(isChecked()) sprintf(buf,"check(%d,1)\n",id);
  else            sprintf(buf,"check(%d,0)\n",id);
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyRadioButton::MyRadioButton(int *sock, int ident, QWidget * parent, const char * name)
              :QRadioButton(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(toggled(bool)), SLOT(slotToggled(bool)));
}

MyRadioButton::~MyRadioButton()
{
}

void MyRadioButton::slotToggled(bool on)
{
char buf[80];

  if(on) sprintf(buf,"radio(%d,1)\n",id);
  else   sprintf(buf,"radio(%d,0)\n",id);
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyButtonGroup::MyButtonGroup(int *sock, int ident, int columns, Qt::Orientation o, QString title, QWidget * parent, const char * name)
              :Q3ButtonGroup(columns,o,title,parent,name)
{
  s = sock;
  id = ident;
}

MyButtonGroup::~MyButtonGroup()
{
}

void MyButtonGroup::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == Qt::RightButton)
  {
    char buf[80];

    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}

////////////////////////////////////////////////////////////////////////////////
MyFrame::MyFrame(int *sock, int ident, int shape, int shadow, int line_width, int margin,
                 QWidget * parent, const char * name, Qt::WFlags f)
        :Q3Frame(parent,name,f)
{
  s = sock;
  id = ident;
  setFrameShape  ((Q3Frame::Shape)  shape);
  setFrameShadow ((Q3Frame::Shadow) shadow);
  setLineWidth   (line_width);
  setMargin      (margin);
}

MyFrame::~MyFrame()
{
}

void MyFrame::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == Qt::RightButton)
  {
    char buf[80];

    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}

////////////////////////////////////////////////////////////////////////////////
MyQTabWidget::MyQTabWidget(int *sock, int ident, QWidget *parent, const char *name, Qt::WFlags f)
             :QTabWidget(parent,name,f)
{
  id = ident;
  s  = sock;
  connect(this, SIGNAL(currentChanged(QWidget *)), SLOT(slotCurrentChanged(QWidget *)));
}

MyQTabWidget::~MyQTabWidget()
{
}

void MyQTabWidget::slotCurrentChanged(QWidget *w)
{
char buf[80];

#if QT_VERSION > 220
  sprintf(buf,"tab(%d,%d)\n",id,currentPageIndex());
#else
  sprintf(buf,"tab(%d,%d)\n",id,tabBar()->currentTab());
#endif
  tcp_send(s,buf,strlen(buf));
  if(w == NULL) return;
}

void MyQTabWidget::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == Qt::RightButton)
  {
    char buf[80];

    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}

////////////////////////////////////////////////////////////////////////////////
#if QT_VERSION >=0x030201
MyQToolBox::MyQToolBox(int *sock, int ident, QWidget *parent, const char *name, Qt::WFlags f)
             :QToolBox(parent,name,f)
{
  id = ident;
  s  = sock;
  connect(this, SIGNAL(currentChanged(int)), SLOT(slotCurrentChanged(int)));
}

MyQToolBox::~MyQToolBox()
{
}

void MyQToolBox::slotCurrentChanged(int index)
{
char buf[80];

  sprintf(buf,"tab(%d,%d)\n",id,index);
  tcp_send(s,buf,strlen(buf));
}

void MyQToolBox::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == Qt::RightButton)
  {
    char buf[80];

    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}
#endif
////////////////////////////////////////////////////////////////////////////////
MyGroupBox::MyGroupBox(int *sock, int ident, int columns, Qt::Orientation o, QString title, QWidget * parent, const char * name)
           :Q3GroupBox(columns,o,title,parent,name)
{
  s = sock;
  id = ident;
}

MyGroupBox::~MyGroupBox()
{
}

void MyGroupBox::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == Qt::RightButton)
  {
    char buf[80];

    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}

////////////////////////////////////////////////////////////////////////////////
MyListBox::MyListBox(int *sock, int ident, QWidget * parent, const char * name, Qt::WFlags f)
          :Q3ListBox(parent,name,f)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(clicked(Q3ListBoxItem *)), SLOT(slotClicked(Q3ListBoxItem *)));
  connect(this, SIGNAL(currentChanged(Q3ListBoxItem *)), SLOT(slotCurrentChanged(Q3ListBoxItem *)));
  connect(this, SIGNAL(selectionChanged()), SLOT(slotSendSelected()));
}

MyListBox::~MyListBox()
{
}

void MyListBox::insertItem(QPixmap &pixmap, const QString &text, int index)
{
  if(pixmap.isNull()) Q3ListBox::insertItem(text,index);
  else                Q3ListBox::insertItem(pixmap,text,index);
}

void MyListBox::changeItem(QPixmap &pixmap, const QString & text, int index)
{
  if(pixmap.isNull()) Q3ListBox::changeItem(text,index);
  else                Q3ListBox::changeItem(pixmap,text,index);
}

void MyListBox::removeItem(int index)
{
  Q3ListBox::removeItem(index);
}

void MyListBox::removeItemByName(QString name)
{
  while(1)
  {
    Q3ListBoxItem *item = findItem(name);
    if(item != NULL) removeItem(index(item));
    if(item == NULL) return;
  }
}

void MyListBox::clear()
{
  Q3ListBox::clear();
}

void MyListBox::slotClicked(Q3ListBoxItem *item)
{
char buf[80];

  if(item == NULL) return;
  sprintf(buf,"QListBox(%d,\"%s\")\n",id,(const char *) item->text());
  tcp_send(s,buf,strlen(buf));
}

void MyListBox::slotCurrentChanged(Q3ListBoxItem *item)
{
char buf[80];

  if(item == NULL) return;
  sprintf(buf,"QListBox(%d,\"%s\")\n",id,(const char *) item->text());
  tcp_send(s,buf,strlen(buf));
}

void MyListBox::slotSendSelected()
{
char buf[MAX_PRINTF_LENGTH];
int i,cnt;

  cnt = count();
  for(i=0; i<cnt; i++)
  {
    if(isSelected(i))
    {
      sprintf(buf,"selected(%d,%d,\"%s\")\n",id,i,(const char *) text(i));
      tcp_send(s,buf,strlen(buf));
    }
  }
  sprintf(buf,"selected(%d,-1,\"(null)\")\n",id);
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyTable::MyTable(int *sock, int ident, int numRows, int numColumns, QWidget *parent, const char *name)
        :Q3Table(numRows,numColumns,parent,name)
{
  s = sock;
  id = ident;
  wrap = 0;
  connect(horizontalHeader(), SIGNAL(clicked(int)), SLOT(slotColClicked(int)));
  connect(verticalHeader()  , SIGNAL(clicked(int)), SLOT(slotRowClicked(int)));
  connect(this, SIGNAL(clicked(int,int,int,const QPoint &)), SLOT(slotClicked(int,int,int,const QPoint &)));
  connect(this, SIGNAL(currentChanged(int,int)), SLOT(slotCurrentChanged(int,int)));
  connect(this, SIGNAL(valueChanged(int,int)), SLOT(slotValueChanged(int,int)));
  connect(this, SIGNAL(pressed(int,int,int,const QPoint &)), SLOT(slotPressed(int,int,int,const QPoint &)));
}

MyTable::~MyTable()
{
}

void MyTable::paintCell(QPainter *p, int row, int col, const QRect &cr, bool selected, const QColorGroup &cg)
{
  QString celltext = text(row,col);
  int r,g,b;

  if(celltext.startsWith("color("))
  {
    QRect crect;
    crect = cellRect(row,col);
    p->setClipRect(crect, Qt::ReplaceClip);
    if(selected == false)
    {
      sscanf(celltext,"color(%d,%d,%d",&r,&g,&b);
      p->fillRect(crect,QBrush(QColor(r,g,b)));
      p->drawText(crect,Qt::AlignRight | Qt::AlignVCenter,
                  celltext.mid(1+celltext.find(')')));
    }
    else
    {
      sscanf(celltext,"color(%d,%d,%d",&r,&g,&b);
      p->fillRect(crect,QBrush(cg.highlight()));
      p->drawText(crect,Qt::AlignRight | Qt::AlignVCenter,
                  celltext.mid(1+celltext.find(')')));
    }
    p->setClipping(FALSE);
  }
  else
  {
    Q3Table::paintCell(p,row,col,cr,selected,cg);
  }
}

QWidget *MyTable::beginEdit(int row, int col, bool replace)
{
  QString celltext = text(row,col);
  if(celltext.startsWith("color("))
  {
    cellbuf = celltext.left(1+celltext.find(')'));
    setText(row,col,celltext.mid(1+celltext.find(')')));
    return Q3Table::beginEdit(row,col,replace);
  }
  else
  {
    return Q3Table::beginEdit(row,col,replace);
  }
}

void MyTable::endEdit(int row, int col, bool accept, bool replace)
{
  if(cellbuf == "")
  {
    Q3Table::endEdit(row,col,accept,replace);
  }
  else
  {
    Q3Table::endEdit(row,col,accept,replace);
    QString buf = text(row,col);
    setText(row,col,cellbuf+buf);
    cellbuf = "";
  }
}

void MyTable::setTableCheckBox(int row, int col, int state, QString text)
{
  Q3CheckTableItem *item = new Q3CheckTableItem(this, text);
  item->setChecked(state);
  setItem(row,col,item);
  //printf("CheckBox(%d,%d,%d,%s)\n",row,col,state,text);
}

void MyTable::setTableComboBox(int row, int col, int editable, const char *menu)
{
  char buf[800];
  int  i,ifirst;
  QStringList list;
  ifirst = 0;
  for(i=0;; i++)
  {
    if(menu[i] == ',' || menu[i] == '\0')
    {
      if(i == ifirst && i == 0)
      {
      }
      else if(menu[i] != '\0' && menu[i+1] == ',')
      {
        if(i > 0 && menu[i-1] != ',')
        {
          strncpy(buf,&menu[ifirst],i-ifirst);
          buf[i-ifirst] = '\0';
          list.append(buf);
        }
      }
      else
      {
        if(i > 0 && menu[i-1] != ',')
        {
          strncpy(buf,&menu[ifirst],i-ifirst);
          buf[i-ifirst] = '\0';
          list.append(buf);
        }
      }
      ifirst = i+1;
    }
    if(menu[i] == '\0') break;
  }

  setItem(row,col, new Q3ComboTableItem(this, list, editable));
  //printf("ComboBox(%d,%d,%d,%s)\n",row,col,editable,text);
}

void MyTable::slotRowClicked(int section)
{
char buf[80];

  sprintf(buf,"QTable(%d,%d,%d,%d)\n",id,section,-1,1);
  tcp_send(s,buf,strlen(buf));
}

void MyTable::slotColClicked(int section)
{
char buf[80];

  sprintf(buf,"QTable(%d,%d,%d,%d)\n",id,-1,section,1);
  tcp_send(s,buf,strlen(buf));
}

void MyTable::slotClicked(int row, int col, int button, const QPoint &mousePos)
{
char buf[80];

  sprintf(buf,"QTable(%d,%d,%d,%d)\n",id,row,col,button);
  tcp_send(s,buf,strlen(buf));
  if(mousePos.isNull()) return;
}
   
void MyTable::slotCurrentChanged( int row, int col)
{
char buf[80];
  
  sprintf(buf,"QTable(%d,%d,%d,0)\n",id,row,col);
  tcp_send(s,buf,strlen(buf));
}
   
void MyTable::slotValueChanged(int row, int col)
{
  char buf[80];
  QString txt;
  QString celltext = text(row,col);
  if(celltext.startsWith("color("))
  {
    txt = celltext.mid(1+celltext.find(')'));
  }
  else
  {
    txt = text(row,col);
  }

  if(item(row,col)->rtti() == 2) //CheckTableItem
  {
    Q3CheckTableItem *tableitem = (Q3CheckTableItem *) item(row,col);
    QString sbuf = txt;
    if(tableitem->isChecked()) txt = "1," + sbuf;
    else                       txt = "0," + sbuf;
  }
  sprintf(buf,"QTableValue(%d,%d,%d,\"%s\")\n",id,row,col,(const char *) txt);
  tcp_send(s,buf,strlen(buf));
}

void MyTable::slotPressed(int row, int col, int button, const QPoint &mousePos)
{
  char buf[80];

  if(button == 3)
  {
    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
  if(row == col) return;
  if(mousePos.x() == 0) return;
}

void MyTable::saveTextfile()
{
  QFileDialog dlg;
  QString name,cell;
  FILE *fp;
  int x,y,ret;

  name = dlg.getSaveFileName(QString::null,"*.csv");
  if(name.isEmpty()) return;
  fp = fopen(name,"r");
  if(fp != NULL)
  {
    fclose(fp);
    ret = QMessageBox::warning(this,"Save Table","File already exists: Overwrite ?",QMessageBox::Yes,QMessageBox::No,0);
    if(ret == QMessageBox::No) return;
  }
  fp = fopen(name,"w");
  if(fp == NULL)
  {
    QMessageBox::warning(this,"Save Table","could not write file",QMessageBox::Ok,0,0);
    return;
  }
  for(y=-1; y<numRows(); y++)
  {
    if(y == -1)        cell = "";
    else               cell = horizontalHeader()->label(y);
    if(cell.isEmpty()) cell = "";
    else        fprintf(fp,"%s",(const char *) cell);
    for(x=0; x<numCols(); x++)
    {
      if(y == -1)        cell = verticalHeader()->label(x);
      else               cell = text(y,x);
      if(cell.isEmpty()) cell = "";
      fprintf(fp,"\t%s",(const char *) cell);
    }
    fprintf(fp,"\n");
  }
  fclose(fp);
}

////////////////////////////////////////////////////////////////////////////////
MySpinBox::MySpinBox(int *sock, int ident, int minValue, int maxValue, int step, QWidget *parent, const char *name)
          :QSpinBox(minValue,maxValue,step,parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(int)), SLOT(slotValueChanged(int)));
}

MySpinBox::~MySpinBox()
{
}

void MySpinBox::slotValueChanged(int value)
{
char buf[80];

  sprintf(buf,"slider(%d,%d)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyDial::MyDial(int *sock, int ident, int minValue, int maxValue, int pageStep, int value, QWidget *parent, const char *name)
       :QDial(minValue,maxValue,pageStep,value,parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(int)), SLOT(slotValueChanged(int)));
}

MyDial::~MyDial()
{
}

void MyDial::setValue(int value)
{
  QDial::setValue(value);
}

void MyDial::slotValueChanged(int value)
{
char buf[80];

  sprintf(buf,"slider(%d,%d)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyProgressBar::MyProgressBar(int *sock, int ident, int totalSteps, QWidget *parent, const char *name)
              :Q3ProgressBar(totalSteps,parent,name)
{
  s = sock;
  id = ident;
}

MyProgressBar::~MyProgressBar()
{
}

void MyProgressBar::setValue(int value)
{
  setProgress(value);
}

////////////////////////////////////////////////////////////////////////////////
MyMultiLineEdit::MyMultiLineEdit(int *sock, int ident, int editable, int maxLines, QWidget *parent, const char *name)
                :Q3TextEdit(parent,name)
{
  s = sock;
  id = ident;
  maxlines = maxLines;
  //setMaxLines(maxLines);
  if     (editable == 0) setReadOnly(true);
  else if(editable == 1) setReadOnly(false);
  setWordWrap(Q3TextEdit::NoWrap);
}

MyMultiLineEdit::~MyMultiLineEdit()
{
}

void MyMultiLineEdit::setText(const QString &text)
{
  if(maxlines != -1)
  {
    if(lines() >= maxlines)
    {
      removeParagraph(0);
    }
  }
  append(text);
  setCursorPosition(lines()-1,paragraphLength(lines()-1));
}

void MyMultiLineEdit::slotSendToClipboard()
{
  char buf[80];

  sprintf(buf,"@clipboard(%d,%d)\n", id,length()+lines());
  tcp_send(s,buf,strlen(buf));
  tcp_send(s,text(),length()+lines());
}

////////////////////////////////////////////////////////////////////////////////
MyTextBrowser::MyTextBrowser(int *sock, int ident, QWidget *parent, const char *name)
              :QTextBrowser(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(anchorClicked(const QUrl &)), SLOT(slotAnchorClicked(const QUrl &)));
}

MyTextBrowser::~MyTextBrowser()
{
}

void MyTextBrowser::moveContent(int pos)
{
  if     (pos == 0) home();
  else if(pos == 1) backward();
  else if(pos == 2) forward();
}

void MyTextBrowser::slotLinkClicked(const QString &txt)
{
  char buf[MAX_PRINTF_LENGTH];

  if(opt.arg_debug) printf("slotLinkClicked(%s)\n", (const char *) txt.toAscii());
  if(txt.length()+40 > MAX_PRINTF_LENGTH) return;
  sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) txt.toUtf8());
  tcp_send(s,buf,strlen(buf));
}

void MyTextBrowser::slotAnchorClicked(const QUrl &link)
{
  QString file = link.toLocalFile();
  if(!file.isEmpty()) slotLinkClicked(file);
  else
  {
    char buf[MAX_PRINTF_LENGTH];
    QString url;

    url = link.toString();
    if(opt.arg_debug) printf("slotAnchorClicked(%s)\n", (const char *) url.toAscii());
    if(url.length()+40 > MAX_PRINTF_LENGTH) return;
    sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) url.toUtf8());
    tcp_send(s,buf,strlen(buf));
  }
}

////////////////////////////////////////////////////////////////////////////////
static int starts_with(const char *path1, const char *path2)
{
  int i;
  for(i=0; path1[i] != '\0'; i++)
  {
    if(path2[i] == '\0')
    {
      if(path1[i] == '/') return 1;
      else                return 0;
    }
    if(path1[i] != path2[i]) return 0;
  }
  if(path2[i] != '/' && path2[i] != '\0') return 0; // RL 15.10.2004
  return 1;
}

const char *root_path(const char *path, int num_slash)
{
  static char buf[1024];
  int i,cnt;

  i   = 0;
  cnt = -1;
  while(i < (int) sizeof(buf))
  {
    if(path[i] == '/') cnt++;
    if(cnt == num_slash) break;
    if(path[i] == '\0')  break;
    buf[i] = path[i];
    i++;
  }
  buf[i] = '\0';
  return buf;
}

MyListView::MyListView(int *sock, int ident, QWidget *parent, const char *name)
           :Q3ListView(parent,name)
{
  s = sock;
  id = ident;
  setSorting(-1);
  connect(this, SIGNAL(clicked(Q3ListViewItem *)), SLOT(slotClicked(Q3ListViewItem *)));
  connect(this, SIGNAL(selectionChanged()), SLOT(slotSendSelected()));
  connect(this, SIGNAL(rightButtonPressed(Q3ListViewItem *, const QPoint &, int)), SLOT(slotRightButtonPressed(Q3ListViewItem *, const QPoint &, int)));
}

MyListView::~MyListView()
{
}

void MyListView::nameVersionSetListViewText(const char *path, int column, QString &text, MyListViewItem *parent, const char *relpath, int num_slash)
{
  MyListViewItem *item;
  char *cptr;

  if(parent == NULL) item = (MyListViewItem *) firstChild();
  else               item = (MyListViewItem *) parent->firstChild();
  while(item != NULL)
  {
    if(strcmp(path,item->path) == 0) { item->setText(column,text); return; }      // update existing item
    if(starts_with(path,item->path))
    {
      cptr = strchr(&relpath[1],'/');
      if(cptr == NULL) return;
      nameVersionSetListViewText(path,column,text,item,cptr,num_slash+1);         // recurse
      return;
    }
    item = (MyListViewItem *) item->nextSibling();
  }
  if(num_slash == 1)   item = new MyListViewItem(this);                           // add root path
  else                 item = new MyListViewItem(parent);                         // add root path
  item->path = root_path(path,num_slash);
  if(num_slash == 1)   insertItem(item);                                          // insert new item
  else                 parent->insertItem(item);
  if(item->path == path) { item->setText(column,text); return; }
  cptr = strchr(&relpath[1],'/');
  if(cptr == NULL) return;
  nameVersionSetListViewText(path,column,text,item,cptr,num_slash+1);             // recurse
  return;
}

void MyListView::nameVersionSetListViewPixmap(const char *path, int column, QPixmap &pixmap, MyListViewItem *parent, const char *relpath, int num_slash)
{
  MyListViewItem *item;
  char *cptr;

  if(parent == NULL) item = (MyListViewItem *) firstChild();
  else               item = (MyListViewItem *) parent->firstChild();
  while(item != NULL)
  {
    if(strcmp(path,item->path) == 0) { item->setPixmap(column,pixmap); return; }  // update existing item
    if(starts_with(path,item->path))
    {
      cptr = strchr(&relpath[1],'/');
      if(cptr == NULL) return;
      nameVersionSetListViewPixmap(path,column,pixmap,item,cptr,num_slash+1);     // recurse
      return;
    }
    item = (MyListViewItem *) item->nextSibling();
  }
  if(num_slash == 1)   item = new MyListViewItem(this);                           // add root path
  else                 item = new MyListViewItem(parent);                         // add root path
  item->path = root_path(path,num_slash);
  if(num_slash == 1)   insertItem(item);                                          // insert new item
  else                 parent->insertItem(item);
  if(item->path == path) { item->setPixmap(column,pixmap); return; }
  cptr = strchr(&relpath[1],'/');
  if(cptr == NULL) return;
  nameVersionSetListViewPixmap(path,column,pixmap,item,cptr,num_slash+1);         // recurse
  return;
}

void MyListView::setListViewText(const char *path, int column, QString &text)
{
  if(path[0] != '/') return;
  triggerUpdate();
  nameVersionSetListViewText(path,column,text,NULL,path,1);
}

void MyListView::setListViewPixmap(const char *path, int column, QPixmap &pixmap)
{
  if(path[0] != '/') return;
  triggerUpdate();
  nameVersionSetListViewPixmap(path,column,pixmap,NULL,path,1);
}

int MyListView::deleteListViewItem(const char *path, MyListViewItem *item)
{
  MyListViewItem *child;
  int ret;

  while(item != NULL)
  {
    if(strcmp(item->path,path) == 0)
    {
      delete item;
      return 1;
    }
    child = (MyListViewItem *) item->firstChild();
    if(child != NULL)
    {
      ret = deleteListViewItem(path,child);
      if(ret != 0) return ret;
    }
    item = (MyListViewItem *) item->nextSibling();
  }
  return 0;
}

int MyListView::ensureVisible(const char *path, MyListViewItem *item)
{
  MyListViewItem *child;
  int ret;

  while(item != NULL)
  {
    if(strcmp(item->path,path) == 0)
    {
      ensureItemVisible(item);
      return 1;
    }
    child = (MyListViewItem *) item->firstChild();
    if(child != NULL)
    {
      ret = ensureVisible(path,child);
      if(ret != 0) return ret;
    }
    item = (MyListViewItem *) item->nextSibling();
  }
  return 0;
}

int MyListView::setItemOpen(const char *path, int open, MyListViewItem *item)
{
  MyListViewItem *child;
  int ret;

  while(item != NULL)
  {
    if(strcmp(item->path,path) == 0)
    {
      setOpen(item,open);
      return 1;
    }
    child = (MyListViewItem *) item->firstChild();
    if(child != NULL)
    {
      ret = setItemOpen(path,open,child);
      if(ret != 0) return ret;
    }
    item = (MyListViewItem *) item->nextSibling();
  }
  return 0;
}

void MyListView::closeTree(MyListViewItem *lvi, int mode)
{
  if(lvi)
  {
    if(mode==2) lvi->setOpen(0);
    lvi->setSelected(0);
    lvi->repaint();
    closeTree((MyListViewItem *)lvi->firstChild(), mode);
    closeTree((MyListViewItem *)lvi->nextSibling(), mode);
  }
  return;
}

void MyListView::setSelected(int mode, const char *path)
{
  const char *ptr;

  ptr = &path[1];
  MyListViewItem *plvi, *lvi = (MyListViewItem *) firstChild();

  plvi=lvi;
  closeTree(plvi, mode);

  while((ptr=strchr(ptr, '/')))
  {
    do
    {
      if((!strncmp((const char *) plvi->path.data(), path, ptr-(const char *)path)) &&
          (strlen((const char *) plvi->path.data())==(unsigned)(ptr-(const char *)path)))
      {
        plvi->setOpen(mode);
        break;
      }
      plvi=(MyListViewItem *)plvi->nextSibling();
    }
    while(plvi);
    if(!plvi) break;
    plvi=(MyListViewItem *)plvi->firstChild();
    ptr++;
  }

  do
  {
    if(!strcmp((const char *) plvi->path.data(), path))
    {
      plvi->setOpen(mode);
      plvi->setSelected(mode);
      doSendSelected(plvi);
      break;
    }
    plvi=(MyListViewItem *)plvi->nextSibling();
  }
  while(plvi);

  repaint();
}

void MyListView::slotClicked(Q3ListViewItem *item)
{
char buf[MAX_PRINTF_LENGTH];
MyListViewItem *myitem = (MyListViewItem *) item;
int  col;

  if(item == NULL) return;
  col = columns();
  while( col > 0)
  {
    col--;
    //sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) item->text(col));
    sprintf(buf,"selected(%d,%d,\"%s\")\n", id, col, (const char *) item->text(col));
    tcp_send(s,buf,strlen(buf));
  }
  sprintf(buf,"selected(%d,-1,\"%s\")\n", id, (const char *) myitem->path);
  tcp_send(s,buf,strlen(buf));
}

void MyListView::slotSendSelected()
{
char buf[MAX_PRINTF_LENGTH];

  doSendSelected(firstChild());
  sprintf(buf,"selected(%d,-2,\"(null)\")\n",id);
  tcp_send(s,buf,strlen(buf));
}

void MyListView::doSendSelected(Q3ListViewItem *item)
{
char buf[MAX_PRINTF_LENGTH];

int column;

  while(item != NULL)
  {
    if(item->isSelected())
    {
      column = columns();
      while( column > 0)
      {
        column--;
        sprintf(buf,"selected(%d,%d,\"%s\")\n", id, column, (const char *) item->text(column));
        tcp_send(s,buf,strlen(buf));
      }
      MyListViewItem *myitem = (MyListViewItem *) item;
      sprintf(buf,"selected(%d,-1,\"%s\")\n", id, (const char *) myitem->path);
      tcp_send(s,buf,strlen(buf));
    }
    if(item->firstChild() != NULL) doSendSelected(item->firstChild());
    item = item->nextSibling();
  }
}

void MyListView::slotRightButtonPressed(Q3ListViewItem *item, const QPoint &p, int i)
{
  char buf[80];

  if(item == NULL)
  {
    sprintf(buf,"QMouseRight(%d,\"%d,\")\n",id,i);
  }
  else
  {
    MyListViewItem *myitem = (MyListViewItem *) item;
    sprintf(buf,"QMouseRight(%d,\"%d,%s\")\n",id,i,(const char *) myitem->path);
  }
  tcp_send(s,buf,strlen(buf));
  if(item == NULL) return;
  if(i == 0) return;
  if(p.x() == 0) return;
}

////////////////////////////////////////////////////////////////////////////////
MyIconView::MyIconView(int *sock, int ident, QWidget *parent, const char *name)
           :Q3IconView(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(clicked(Q3IconViewItem *)), SLOT(slotClicked(Q3IconViewItem *)));
}

MyIconView::~MyIconView()
{
}

void MyIconView::setIconViewItem(QString &text, QPixmap &pixmap)
{
  insertItem(new Q3IconViewItem(this,text,pixmap));
}

void MyIconView::deleteIconViewItem(QString &text)
{
  if(text.isEmpty()) return;
  return;
/*
  QIconViewItem *item = firstItem();
  while(1)
  {
    if(item == NULL) return;
    if(item->text() == text)
    {
      delete item;
      return;
    }
    item = item->nextItem();
  }
*/
}

void MyIconView::slotClicked(Q3IconViewItem *item)
{
char buf[MAX_PRINTF_LENGTH];

  if(item == NULL) return;
  if(item->text().length()+40 > MAX_PRINTF_LENGTH) return;
  sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) item->text().toUtf8());
  tcp_send(s,buf,strlen(buf));
}

#ifndef NO_QWT
// --- QWT --------------------------------------------------------------
MyQwtScale::MyQwtScale(int *sock, int ident, int position, QWidget *parent, const char *name)
           :QwtScaleWidget((QwtScaleDraw::Alignment)position,parent)
{
  s = sock;
  id = ident;
  if(name == NULL) return;
}

MyQwtScale::~MyQwtScale()
{
}

MyQwtThermo::MyQwtThermo(int *sock, int ident, QWidget *parent, const char *name)
            :QwtThermo(parent)
{
  s = sock;
  id = ident;
  if(name == NULL) return;
}

MyQwtThermo::~MyQwtThermo()
{
}

MyQwtKnob::MyQwtKnob(int *sock, int ident, QWidget *parent, const char *name)
          :QwtKnob(parent)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(double)), SLOT(slotValueChanged(double)));
  if(name == NULL) return;
}

MyQwtKnob::~MyQwtKnob()
{
}

void MyQwtKnob::slotValueChanged(double value)
{
char buf[80];

  sprintf(buf,"slider(%d,%lf)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

MyQwtCounter::MyQwtCounter(int *sock, int ident, QWidget *parent, const char *name)
             :QwtCounter(parent)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(double)), SLOT(slotValueChanged(double)));
  if(name == NULL) return;
}

MyQwtCounter::~MyQwtCounter()
{
}

void MyQwtCounter::slotValueChanged(double value)
{
char buf[80];

  sprintf(buf,"slider(%d,%lf)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

MyQwtWheel::MyQwtWheel(int *sock, int ident, QWidget *parent, const char *name)
           :QwtWheel(parent)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(double)), SLOT(slotValueChanged(double)));
  if(name == NULL) return;
}

MyQwtWheel::~MyQwtWheel()
{
}

void MyQwtWheel::slotValueChanged(double value)
{
char buf[80];

  sprintf(buf,"slider(%d,%lf)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

MyQwtSlider::MyQwtSlider(int *sock, int ident, QWidget *parent, const char *name)
            :QwtSlider(parent)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(double)), SLOT(slotValueChanged(double)));
  if(name == NULL) return;
}

MyQwtSlider::~MyQwtSlider()
{
}

void MyQwtSlider::slotValueChanged(double value)
{
char buf[80];

  sprintf(buf,"slider(%d,%lf)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

MyQwtCompass::MyQwtCompass(int *sock, int ident, QWidget *parent, const char *name)
             :QwtCompass(parent)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(double)), SLOT(slotValueChanged(double)));
  if(name == NULL) return;
}

MyQwtCompass::~MyQwtCompass()
{
}

void MyQwtCompass::slotValueChanged(double value)
{
char buf[80];

  sprintf(buf,"slider(%d,%lf)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}
#endif // #ifndef NO_QWT

MyQDateEdit::MyQDateEdit(int *sock, int ident, QWidget *parent, const char *name)
            :Q3DateEdit(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(const QDate &)), SLOT(slotValueChanged(const QDate &)));
}

MyQDateEdit::~MyQDateEdit()
{
}

void MyQDateEdit::slotValueChanged(const QDate &date)
{
char buf[80];

  sprintf(buf,"text(%d,\"%d:%d:%d\")\n", id, date.year(), date.month(), date.day());
  if(date.isValid()) tcp_send(s,buf,strlen(buf));
}

MyQTimeEdit::MyQTimeEdit(int *sock, int ident, QWidget *parent, const char *name)
            :Q3TimeEdit(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(const QTime &)), SLOT(slotValueChanged(const QTime &)));
}

MyQTimeEdit::~MyQTimeEdit()
{
}

void MyQTimeEdit::slotValueChanged(const QTime &time)
{
char buf[80];

  sprintf(buf,"text(%d,\"%d.%d.%d.%d\")\n", id, time.hour(), time.minute(), time.second(), time.msec());
  if(time.isValid()) tcp_send(s,buf,strlen(buf));
}

MyQDateTimeEdit::MyQDateTimeEdit(int *sock, int ident, QWidget *parent, const char *name)
                :Q3DateTimeEdit(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(const QDateTime &)), SLOT(slotValueChanged(const QDateTime &)));
}

MyQDateTimeEdit::~MyQDateTimeEdit()
{
}

void MyQDateTimeEdit::slotValueChanged(const QDateTime &date_time)
{
char buf[200];

  sprintf(buf,"text(%d,\"%d:%d:%d-%d.%d.%d.%d\")\n", id, date_time.date().year(),
                                                         date_time.date().month(),
                                                         date_time.date().day(),
                                                         date_time.time().hour(),
                                                         date_time.time().minute(),
                                                         date_time.time().second(),
                                                         date_time.time().msec());
  if(date_time.isValid()) tcp_send(s,buf,strlen(buf));
}
