/***************************************************************************
                          MyWidgets.h  -  description
                             -------------------
    begin                : Mon Dec 11 2000
    copyright            : (C) 2000 by Rainer Lehrig
                         : Martin Bangieff
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _MY_WIDGETS_H_
#define _MY_WIDGETS_H_

#include <QMouseEvent>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qslider.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qtabwidget.h>
#include <qtoolbox.h>
#include <qspinbox.h>
#include <qdial.h>
#include <qpixmap.h>
#include <qdialog.h>
#include <q3groupbox.h>
#include <q3listbox.h>
#include <q3table.h>
#include <q3progressbar.h>
#include <q3buttongroup.h>
#include <q3frame.h>
#include <q3datetimeedit.h>
#include <q3textedit.h>
#include <q3listview.h>
#include <q3iconview.h>
#include <QTextBrowser>

// --- QWT ---
#ifndef NO_QWT
#include "qwtwidgets.h"
#endif

class Interpreter;

class MyDialog : public QDialog
{
    Q_OBJECT
public:
    MyDialog(Interpreter *interpreter, int *sock, int ident, QWidget * parent=0, const char *name=0, bool modal=TRUE, Qt::WFlags f=0);
    ~MyDialog();
private:
    int *s,id;
    void done(int result);
    Interpreter *interpreter;
};

class MyQWidget : public QWidget
{
    Q_OBJECT
public:
    MyQWidget(int *sock, int ident, QWidget * parent, const char * name=0 );
    ~MyQWidget();

public slots:

protected:
    virtual void mousePressEvent(QMouseEvent *e);

private:

    int *s,id;
};

class MyQPushButton : public QPushButton
{
    Q_OBJECT
public:
    MyQPushButton(int *sock, int ident, QWidget * parent, const char * name=0 );
    ~MyQPushButton();

public slots:
    void slotClicked();
    void slotPressed();
    void slotReleased();

private:
    int *s,id;
};

class MyLineEdit : public QLineEdit
{
    Q_OBJECT
public:
    MyLineEdit(int *sock, int ident, QWidget * parent, const char * name=0 );
    ~MyLineEdit();

public slots:
    void slotTextChanged(const QString &txt);
    void slotReturnPressed();

private:
    int *s,id;
};

class MyComboBox : public QComboBox
{
    Q_OBJECT
public:
    MyComboBox(int *sock, int ident, QWidget * parent, const char * name=0 );
    ~MyComboBox();
    void removeItemByName(QString name);

public slots:
    void slotActivated(const QString &txt);

private:
    int *s,id;
};

class MySlider : public QSlider
{
    Q_OBJECT
public:
    MySlider(int *sock, int ident, int minValue, int maxValue, int pageStep, int value, Qt::Orientation, QWidget * parent, const char * name=0 );
    ~MySlider();

public slots:
    void slotValueChanged(int value);

private:
    int *s,id;
};

class MyCheckBox : public QCheckBox
{
    Q_OBJECT
public:
    MyCheckBox(int *sock, int ident, QWidget * parent, const char * name=0 );
    ~MyCheckBox();

public slots:
    void slotClicked();

private:
    int *s,id;
};

class MyRadioButton : public QRadioButton
{
    Q_OBJECT
public:
    MyRadioButton(int *sock, int ident, QWidget * parent, const char * name=0 );
    ~MyRadioButton();

public slots:
    void slotToggled(bool on);

private:
    int *s,id;
};

class MyButtonGroup : public Q3ButtonGroup
{
    Q_OBJECT
public:
    MyButtonGroup(int *sock, int ident, int columns, Qt::Orientation o, QString title, QWidget * parent=0, const char * name=0 );
    ~MyButtonGroup();

protected:
    virtual void mousePressEvent(QMouseEvent *e);

private:
    int *s,id;
};

class MyFrame : public Q3Frame
{
    Q_OBJECT
public:
    MyFrame(int *sock, int ident, int shape, int shadow, int line_width, int margin,
            QWidget * parent=0, const char * name=0, Qt::WFlags f=0);
    ~MyFrame();

protected:
    virtual void mousePressEvent(QMouseEvent *e);

private:
    int *s,id;
};

class MyQTabWidget : public QTabWidget
{
    Q_OBJECT
public:
    MyQTabWidget(int *sock, int ident, QWidget * parent=0, const char * name=0, Qt::WFlags f=0);
    ~MyQTabWidget();

public slots:
    void slotCurrentChanged(QWidget *w);

protected:
    virtual void mousePressEvent(QMouseEvent *e);

private:
    int *s,id;
};

#if QT_VERSION >=0x030201
class MyQToolBox : public QToolBox
{
    Q_OBJECT
public:
    MyQToolBox(int *sock, int ident, QWidget * parent=0, const char * name=0, Qt::WFlags f=0);
    ~MyQToolBox();

public slots:
    void slotCurrentChanged(int index);

protected:
    virtual void mousePressEvent(QMouseEvent *e);

private:
    int *s,id;
};
#endif

class MyGroupBox : public Q3GroupBox
{
    Q_OBJECT
public:
    MyGroupBox(int *sock, int ident, int columns, Qt::Orientation o, QString title, QWidget * parent=0, const char * name=0 );
    ~MyGroupBox();

protected:
    virtual void mousePressEvent(QMouseEvent *e);

private:
    int *s,id;
};

class MyListBox : public Q3ListBox
{
    Q_OBJECT
public:
    MyListBox(int *sock, int ident, QWidget * parent=0, const char * name=0, Qt::WFlags f=0);
    ~MyListBox();
    virtual void insertItem(QPixmap &pixmap, const QString &text, int index=-1);
    virtual void changeItem(QPixmap &pixmap, const QString &text, int index);
    virtual void removeItem(int index);
    virtual void removeItemByName(QString name);
    virtual void clear();

public slots:
    void slotClicked(Q3ListBoxItem *item);
    void slotCurrentChanged(Q3ListBoxItem *item);
    void slotSendSelected();

private:
    int *s,id;
};

#if QT_VERSION > 220
class MyTable : public Q3Table
{
    Q_OBJECT
public:
    MyTable(int *sock, int ident, int numRows, int numColumns, QWidget *parent=0, const char *name=0);
    ~MyTable();
    //virtualvoidsetText(introw, intcol, constQString&text)
    //virtual	void	setPixmap(int row, int col, QPixmap &pm);
    //void updateCell ( int row, int col )
    //virtualvoidsetColumnWidth(intcol, intw)
    virtual void paintCell(QPainter *p, int row, int col, const QRect &cr, bool selected, const QColorGroup &cg);
    virtual QWidget *beginEdit(int row, int col, bool replace);
    virtual void endEdit(int row, int col, bool accept, bool replace);
    void setTableCheckBox(int row, int col, int state, QString text);
    void setTableComboBox(int row, int col, int editable, const char *text);
    void saveTextfile();
    int wrap;

public slots:
   void slotRowClicked(int section);
   void slotColClicked(int section);
   void slotClicked( int row, int col, int button, const QPoint & mousePos);
   void slotCurrentChanged( int row, int col);
   void slotValueChanged(int row, int col);
   void slotPressed(int row, int col, int button, const QPoint &mousePos);
private:
    int *s,id;
    QString cellbuf;
};
#endif

class MySpinBox : public QSpinBox
{
    Q_OBJECT
public:
    MySpinBox(int *sock, int ident, int minValue, int maxValue, int step=1, QWidget *parent=0, const char *name=0);
    ~MySpinBox();
    // virtual void setValue(int)

public slots:
   void slotValueChanged(int value);

private:
    int *s,id;
};

class MyDial : public QDial
{

    Q_OBJECT
public:
    MyDial(int *sock, int ident, int minValue, int maxValue, int pageStep, int value, QWidget *parent=0, const char *name=0);
    ~MyDial();
    virtual void setValue(int);

public slots:
   void slotValueChanged(int value);

private:
    int *s,id;
};

class MyProgressBar : public Q3ProgressBar
{
    Q_OBJECT
public:
    MyProgressBar(int *sock, int ident, int totalSteps, QWidget *parent=0, const char *name=0);
    ~MyProgressBar();
    virtual void setValue(int);

private:
    int *s,id;
};

class MyMultiLineEdit : public Q3TextEdit
{
    Q_OBJECT
public:
    MyMultiLineEdit(int *sock, int ident, int editable, int maxLines, QWidget * parent=0, const char * name=0);
    ~MyMultiLineEdit();
    virtual void setText(const QString &text);

public slots:
    void slotSendToClipboard();

private:
    int *s,id,maxlines;
};

class MyTextBrowser : public QTextBrowser
{
    Q_OBJECT
public:
    MyTextBrowser(int *sock, int ident, QWidget * parent=0, const char * name=0);
    ~MyTextBrowser();
    void moveContent(int pos);

public slots:
    void slotLinkClicked(const QString &txt);
    void slotAnchorClicked(const QUrl &link);

private:
    int *s,id;
};

class MyListViewItem;

class MyListView : public Q3ListView
{
    Q_OBJECT
public:
    MyListView(int *sock, int ident, QWidget * parent=0, const char * name=0);
    ~MyListView();
    void setListViewText(const char *path, int column, QString &text);
    void setListViewPixmap(const char *path, int column, QPixmap &pixmap);
    int  deleteListViewItem(const char *path, MyListViewItem *item);
    void doSendSelected(Q3ListViewItem *item);
    int  ensureVisible(const char *path, MyListViewItem *item);
    int  setItemOpen(const char *path, int open, MyListViewItem *item);
    void setSelected(int mode, const char *path);

public slots:
    void slotClicked(Q3ListViewItem *item);
    void slotSendSelected();
    void slotRightButtonPressed(Q3ListViewItem *, const QPoint &, int i);

private:
    void closeTree(MyListViewItem *lvi, int mode);
    void nameVersionSetListViewText(const char *path, int column, QString &text, MyListViewItem *item, const char *relpath, int num_slash);
    void nameVersionSetListViewPixmap(const char *path, int column, QPixmap &pixmap, MyListViewItem *item, const char *relpath, int num_slash);
    int *s,id;
};

class MyListViewItem : public Q3ListViewItem
{
public:
  QString path;
  MyListViewItem ( MyListView *parent ) :
    Q3ListViewItem(parent) {};
  MyListViewItem ( MyListViewItem *parent ) :
    Q3ListViewItem (parent) {};
  MyListViewItem ( MyListView *parent, MyListViewItem *after ) :
    Q3ListViewItem (parent,after) {};
  MyListViewItem ( MyListViewItem *parent, MyListViewItem *after ) :
    Q3ListViewItem ( parent, after) {};
  MyListViewItem ( MyListView *parent, QString label1, QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null ) :
    Q3ListViewItem (parent, label1, label2, label3, label4, label5, label6, label7, label8) {};
  MyListViewItem ( MyListViewItem *parent, QString label1, QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null ) :
    Q3ListViewItem (parent, label1, label2, label3, label4, label5, label6, label7, label8) {};
  MyListViewItem ( MyListView *parent, MyListViewItem *after, QString label1, QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null ) :
    Q3ListViewItem ( parent, after, label1, label2, label3, label4, label5, label6, label7, label8) {};
  MyListViewItem ( MyListViewItem *parent, MyListViewItem *after, QString label1, QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null ) :
    Q3ListViewItem ( parent, after, label1, label2, label3, label4, label5, label6, label7, label8) {};
  virtual ~MyListViewItem() {};
};

class MyIconView : public Q3IconView
{
    Q_OBJECT
public:
    MyIconView(int *sock, int ident, QWidget * parent=0, const char * name=0);
    ~MyIconView();
    virtual void setIconViewItem(QString &text, QPixmap &pixmap);
    virtual void deleteIconViewItem(QString &text);

public slots:
    void slotClicked(Q3IconViewItem *item);

private:
    int *s,id;
};

class MyQDateEdit : public Q3DateEdit
{
    Q_OBJECT
public:
    MyQDateEdit(int *sock, int ident, QWidget *parent=0, const char *name=0);
    ~MyQDateEdit();

public slots:
   void slotValueChanged(const QDate &date);

private:
    int *s,id;
};

class MyQTimeEdit : public Q3TimeEdit
{
    Q_OBJECT
public:
    MyQTimeEdit(int *sock, int ident, QWidget *parent=0, const char *name=0);
    ~MyQTimeEdit();

public slots:
   void slotValueChanged(const QTime &time);

private:
    int *s,id;
};

class MyQDateTimeEdit : public Q3DateTimeEdit
{
    Q_OBJECT
public:
    MyQDateTimeEdit(int *sock, int ident, QWidget *parent=0, const char *name=0);
    ~MyQDateTimeEdit();

public slots:
   void slotValueChanged(const QDateTime &date_time);

private:
    int *s,id;
};

#endif
