/***************************************************************************
                          QImageWidget.cpp  -  description
                             -------------------
    begin                : Fri Nov 17 2000
    copyright            : (C) 2000 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qwidget.h>
#include <qimage.h>
#include <qbitmap.h>
#include <qpainter.h>
#include <qpoint.h>
#include "qimagewidget.h"
//Added by qt3to4:
#include <QMouseEvent>
#include <QPaintEvent>
#include "tcputil.h"

QImageWidget::QImageWidget(int *sock, int ident, QWidget *parent, const char *name, int wFlags )
             : QWidget( parent, name, (Qt::WFlags) wFlags )
{
  image = QImage(); // construct a null image
  xx = yy = w = h = 0;
  s = sock;
  id = ident;
  setBackgroundMode(Qt::NoBackground);
}

QImageWidget::~QImageWidget()
{
}

void QImageWidget::setImage(const QImage *newimage)
{
  image = newimage->copy();
  if(w > 0 && h > 0 && ( w < image.width() || h < image.height() ) )
  {
    image = image.scaled(w, h, Qt::KeepAspectRatio);
  }
  else if(w > image.width() || h > image.height())
  {
    image = image.smoothScale(w,h,Qt::KeepAspectRatio);
  }
  clearMask();
  if(image.hasAlphaBuffer())
  {
    mask = image.createAlphaMask();
    setMask(mask);
  }
  w = image.width();
  h = image.height();
}

void QImageWidget::paintEvent( QPaintEvent *e )
{
  if( !image.isNull() )
  {
    QPainter p;
    p.begin(this);
    p.setClipRect(e->rect());
    p.drawImage(QPoint(0,0), image);
    p.end();
  }
}

void QImageWidget::mousePressEvent( QMouseEvent *e)
{
char buf[80];

  if(e->button() == Qt::LeftButton)
  {
    sprintf(buf,"QPushButton(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
  else if(e->button() == Qt::RightButton)
  {
    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}

void QImageWidget::setGeometry(int nx, int ny, int nw, int nh)
{
  xx = nx;
  yy = ny;
  w  = nw;
  h  = nh;
  move(xx,yy);
  resize(w,h);
  if(w > 0 && h > 0 && ( w < image.width() || h < image.height() ) )
  {
    image = image.scaled(w, h, Qt::KeepAspectRatio);
    clearMask();
    if(image.hasAlphaBuffer())
    {
      mask = image.createAlphaMask();
      setMask(mask);
    }
  }
  else if(w > image.width() || h > image.height())
  {
    image = image.smoothScale(w,h,Qt::KeepAspectRatio);
    clearMask();
    if(image.hasAlphaBuffer())
    {
      mask = image.createAlphaMask();
      setMask(mask);
    }
  }
  repaint(0,0,w,h,false);
}

void QImageWidget::setImage(const char *filename)
{
  image.load(filename);
  clearMask();
  if(w > 0 && h > 0 && ( w < image.width() || h < image.height() ) )
  {
    image = image.scaled(w, h, Qt::KeepAspectRatio);
  }
  else if(w > image.width() || h > image.height())
  {
    image = image.smoothScale(w,h,Qt::KeepAspectRatio);
  }

  if(strstr(filename,".bmp") != NULL || strstr(filename,".BMP") != NULL)
  { // it may be a bmp with transparent background
    int n = image.numColors();
    for(int icol=0; icol<n; icol++)
    {
      QRgb qcol = image.color(icol);
      if(qRed(qcol) == 1 && qGreen(qcol) == 1 && qBlue(qcol) == 1)
      { // image has transparent background
        image.setAlphaBuffer(true);
        image.setColor(icol,qRgba(1,1,1,0));
      }
    }
  }
  if(image.hasAlphaBuffer())
  {
    mask = image.createAlphaMask();
    setMask(mask);
  }
  repaint();
}
