/****************************************************************************
**
** Copyright (C) 2000-2006 Lehrig Software Engineering.
**
** This file is part of the pvbrowser project.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include <QApplication>
#include <QIcon>
#include <QSplashScreen>
#include "images/splash.xpm"
#include "mainwindow.h"
#include "opt.h"

extern OPT opt;

void init(int ac, char **av)
{
  opt.arg_debug    = 0;     // default command line args
  opt.arg_localini = 0;
  opt.arg_font[0]  = '\0';
  opt.arg_host[0]  = '\0';
  opt.arg_disable  = 0;
  opt.arg_x        = -1;
  opt.arg_y        = -1;
  opt.arg_w        = -1;
  opt.arg_h        = -1;
  for(int i=0; i<ac; i++)  // read command line args
  {
    if(strncmp(av[i],"-h",2) == 0 || strncmp(av[i],"--",2) == 0)
    {
      printf("pvbrowser %s (C) Lehrig Software Engineering, lehrig@t-online.de\n", VERSION);
      printf("usage:   pvbrowser <-debug<=level>> <-localini> <-font=name<:size>> <host<:port></mask>> <-disable> <-geometry=x:y:w:h>\n");
      printf("example: pvbrowser\n");
      printf("example: pvbrowser localhost\n");
      printf("example: pvbrowser localhost:5050\n");
      printf("example: pvbrowser -font=courier localhost\n");
      printf("example: pvbrowser -font=arial:14 localhost:5050 -disable\n");
      printf("example: pvbrowser -geometry=0:0:640:480\n");
      exit(0);
    }
    if(strncmp(av[i],"-debug",6) == 0)
    {
      opt.arg_debug = 1; // print debugging info
      if(strncmp(av[i],"-debug=",7) == 0)
      {
        sscanf(av[i],"-debug=%d",&opt.arg_debug);
      }
    }
    if(strncmp(av[i],"-localini",9) == 0)
    {
      opt.arg_localini = 1; // use inifile in local directory
    }
    if(strncmp(av[i],"-font=",6) == 0)
    {
      sscanf(av[i],"-font=%s",opt.arg_font); // use font from command line
    }
    if(strncmp(av[i],"-disable",8) == 0)
    {
      opt.arg_disable = 1; // disable some menus
    }
    if(strncmp(av[i],"-geometry=",10) == 0)
    {
      sscanf(av[i],"-geometry=%d:%d:%d:%d",&opt.arg_x,&opt.arg_y,&opt.arg_w,&opt.arg_h); // define geometry of window
    }
    if(i>0 && strncmp(av[i],"-",1) != 0)
    {
      strcpy(opt.arg_host,av[i]);
    }
  }
}

int main(int argc, char *argv[])
{
  Q_INIT_RESOURCE(pvbrowser);

  wsa(); // init windows sockets
  QApplication app(argc, argv);
  QPixmap pm(splash);
  QSplashScreen *splash = new QSplashScreen(pm);
  splash->show();
  init(argc,argv);
  QIcon appIcon(":/images/app.png");
  app.setWindowIcon(appIcon);
  MainWindow mainWin;
  mainWin.show();
  splash->finish(&mainWin);
  delete splash;
  return app.exec();
}
