/****************************************************************************
**
** Copyright (C) 2000-2006 Lehrig Software Engineering.
**
** This file is part of the pvbrowser project.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#define VERSION "3.0.0-beta-2"

#include "interpreter.h"

#include <QMainWindow>
#include <QScrollArea>
#include <QThread>
#include <QSemaphore>

class QAction;
class QMenu;
class QTextEdit;
class QComboBox;
class QLabel;
class MainWindow;
class MyQWidget;


class MyThread : public QThread
{
  Q_OBJECT
  public:
    void run();
    MainWindow *pv;
  signals:
    void dataReady();
};

class MainWindow : public QMainWindow
{
  Q_OBJECT

public:
  MainWindow();
  int s; // the socket
  QSemaphore semaphore;
  void setCurrentFile(const QString &fileName);
  QScrollArea *scroll;
  MyQWidget *view;
  QString curFile;

public slots:
  void slotUrl(const QString &url);
  void dataReceived();

protected:
  void keyPressEvent(QKeyEvent *e);
  void closeEvent(QCloseEvent *event);

private slots:
  void slotFileOpt();
  void slotWindow();
  void slotReconnect();
  void slotStorebmp();
  void slotLogbmp();
  void slotLogpvm();
  void slotPrint();
  void slotCopy();
  void slotEditmenu();
  void slotToolbar();
  void slotStatusbar();
  void slotMaximized();
  void slotFullscreen();
  void slotTimeOut();
  void about();

private:
  void createActions();
  void createMenus();
  void createToolBars();
  void createStatusBar();
  QString strippedName(const QString &fullFileName);
  //void resizeEvent(QResizeEvent *event);
  void snapshot(QPixmap &pm);
  void readHosts();
  void add_host(const char *host);
  void appendIniFile(const char *host);

  QMenu *fileMenu;
  QMenu *editMenu;
  QMenu *viewMenu;
  QMenu *helpMenu;
  QToolBar *fileToolBar;
  QAction *optionAct;
  QAction *windowAct;
  QAction *reconnectAct;
  QAction *storebmpAct;
  QAction *logbmpAct;
  QAction *logpvmAct;
  QAction *printAct;
  QAction *newAct;
  QAction *openAct;
  QAction *saveAct;
  QAction *saveAsAct;
  QAction *exitAct;
  QAction *copyAct;
  QAction *editmenuAct;
  QAction *toolbarAct;
  QAction *statusbarAct;
  QAction *maximizedAct;
  QAction *fullscreenAct;
  QAction *aboutAct;
  QAction *aboutQtAct;
  QAction *logoAct;

  Interpreter interpreter;
  int isReconnect;
  QComboBox *urlComboBox;
  QString url;
  QLabel *logoLabel;
  MyThread mythread;
  QTimer *timer;
};

#endif
