/***************************************************************************
                          pvglwidget.cpp  -  description
                             -------------------
    begin                : Wed Nov 29 2000
    copyright            : (C) 2000 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include "pvglwidget.h"
#include "tcputil.h"

#ifdef USE_OPEN_GL
PvGLWidget::PvGLWidget(QWidget *parent, int ident, int *socket, const char *name, const QGLWidget* shareWidget)
           : QGLWidget(parent, name, shareWidget)
{
  id = ident;
  s  = socket;
  minobject = maxobject = -1;
  makeCurrent();
  //printf("construct\n");
}

PvGLWidget::~PvGLWidget()
{
  //if(isValid()) printf("valid\n");
  //else          printf("not valid\n");
  makeCurrent();
  glDeleteLists(minobject, maxobject-minobject+1);
}

void PvGLWidget::gl_interpret()
{
  char line[1024];
  while(1)
  {
#ifdef _WIN32
retry: //XXXLEHRIG
#endif
    if(tcp_rec(s,line,sizeof(line)-1) < 0) 
    {

#ifdef _WIN32
      goto retry;
#else
      return;
#endif
    }
    if(interpret(line) == -1) 
    {
      return;
    }
  }
}

void PvGLWidget::initializeGL()
{
  //printf("init\n");
  // empty (done by the server)
}

void PvGLWidget::resizeGL( int w, int h )
{
  //printf("resize\n");
  if(w == h) return;
  // empty (done by the server)
}

void PvGLWidget::paintGL()
{
  //printf("paint\n");
  // empty (done by the server)
}

/*
void PvGLWidget::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == RightButton)
  {
    char buf[80];

    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}
*/

#endif
