/***************************************************************************
                          qdrawwidget.h  -  description
                             -------------------
    begin                : Fri Nov 17 2000
    copyright            : (C) 2000 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _QDRAW_WIDGET_H_
#define _QDRAW_WIDGET_H_

#include <stdio.h>
#include <QtGui>

#define MAXARRAY 1024*4  // maximum array size for line(x,y,n)

/* font alignment */
enum FontAlignment {     /*                  */
ALIGN_LEFT=0,            /*  example         */
ALIGN_CENTER,            /*      example     */
ALIGN_RIGHT,             /*          example */
ALIGN_VERT_CENTER        /*      e           */
};                       /*      x           */
                         /*      a           */
                         /*      m           */
                         /*      p           */
                         /*      l           */
                         /*      e           */
                         /*                  */
/* linestyle for lines in axis */
enum Linestyle {
LINESTYLE_NONE=0,
LINESTYLE_CIRCLE,
LINESTYLE_CROSS,
LINESTYLE_RECT
};

class QDrawWidget : public QWidget
{
    Q_OBJECT
public:
    QDrawWidget( QWidget *parent=0, const char *name=0, int wFlags=0, int *sock=NULL, int ident=0);
    ~QDrawWidget();

    void beginDraw();
    void endDraw();
    void showFromSocket(int *s);
    void showFromFile(const char *filename);
    void getDimensions(const char *filename, int *width, int *height);
    void print();
    void logToFile(const char *filename);
    void logBmpToFile(const char *filename);
    void copyToClipboard();
    void moveTo(int x, int y);
    void lineTo(int x, int y);
    void text(int x, int y, int alignment, const char *text);
    void textInAxis(float x, float y, int alignment, const char *text);
    void box(int x, int y, int w, int h);
    void rect(int x, int y, int w, int h);
    void xAxis(float start, float delta, float end, int draw);
    void yAxis(float start, float delta, float end, int draw);
    void xGrid();
    void yGrid();
    void rightYAxis(float start, float delta, float end, int draw);
    void drawSymbol(int x, int y, int type);
    void line(float *x, float *y, int n);
    void setColor(int r, int g, int b);
    void setFont(const char *family, int size, int weight, int italic);
    void setLinestyle(int style);
    void setZoomX(float zx);
    void setZoomY(float zy);
    void setBackgroundColor(int r, int g, int b);
    void playSVG(const char *filename);
    void socketPlaySVG();

    virtual void resize(int w, int h);
    virtual void setGeometry(int x, int y, int w, int h);
    virtual void setGeometry(const QRect &r);

    int      interpret(const char *command);

protected:
    virtual void paintEvent( QPaintEvent * );

private:
    int      interpretall();
    int      gets(char *line, int len);
    int      getText(const char *line, char *text);
    QString  filename;
    int      *s;
    int      id;
    FILE     *fp;
    FILE     *flog;
    QPainter p;
    QPixmap  buffer;
    int      xold, yold;
    int      zx(int x);
    int      zy(int y);
    float    xmin,dx,xmax;
    float    ymin,dy,ymax;
    int      tx(float x);
    int      ty(float y);
    float    zoomx,zoomy;
    int      linestyle;
    int      boxx,boxy,boxw,boxh;
    int      br,bg,bb; // background colors
    int      fontsize;
    int      sr;       // symbol radius
    char     floatFormat[80];
};

#endif
