//******************************************************
//
// Filename: vtkQGLWidget.cpp
//
// Author: Jan Ehrhardt
// Email : ehrhardt@medinf.mu-luebeck.de
//
// Description: Qt-Widget class to incorporate a VTK Renderwindow
//              
//******************************************************
// Copyright (C) 1998 Jan Ehrhardt
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the 
// Free Software Foundation version 2.. 
//
// This program is distributed in the hope that it will be useful, but 
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
// for more details. 
//
//******************************************************
// RCS - Info:
//
// $Id: vtkQGLWidget.cpp,v 1.1.1.1 2003/07/24 08:16:25 lehrig Exp $
// $Log: vtkQGLWidget.cpp,v $
// Revision 1.1.1.1  2003/07/24 08:16:25  lehrig
// Version 1.7
//
// Revision 1.1.1.1  2003/02/04 13:46:02  lehrig
// This is ProcessViewBrowser + ProcessViewServer Version 1.5
// Checked in on 04.feb.2003
//
// Revision 1.4  1999/07/09 13:38:00  ehrhardt
// Updated for VTK version 2.3
//
// Revision 1.3  1999/06/16 07:29:54  ehrhardt
// fuer vtk 2.3 angepasst
//
// Revision 1.2  1999/01/25 08:48:57  ehrhardt
// *** empty log message ***
//
// Revision 1.1  1998/10/22 15:16:01  ehrhardt
// Initial revision
//
//

#include <assert.h>
#include "vtkQGLWidget.h"
#include "vtkSphereSource.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include "vtkConeSource.h"
#include "vtkGlyph3D.h"

/*!
  Create a vtkQGLWidget widget
*/

vtkQGLWidget::vtkQGLWidget( QWidget* parent, const char* name )
    : QGLWidget( parent, name )
{
  QGLFormat f;
  f = format();
  f.setStereo( TRUE );
  setFormat(f);

  setAutoBufferSwap(FALSE);

  m_UpdateBlockCount = 0;
  m_UpdateNeeded = FALSE; 

  m_Renderer = NULL;

  m_bRenWinIsInitialized = false;
  m_RenderWindow = vtkRenderWindow::New();
  m_RenderWindow->StereoUpdate();
  m_RenderWindow->SwapBuffersOn();

  makeCurrent();

  setBackgroundMode( Qt::NoBackground );
}

vtkQGLWidget::~vtkQGLWidget()
{
  m_RenderWindow->Delete();

#ifndef _WIN32
  // Rainer Lehrig lehrig@t-online.de:
  // can anybody tell me why this results in an access violation under windows ?
  if(m_Renderer != NULL)
    m_Renderer->Delete();
#endif    
}   

void vtkQGLWidget::AddRenderer(vtkRenderer *ren)
{
  // falls es zufaellig dem ersten renderer entspricht
  if(m_Renderer == ren) return;
    
  if(m_Renderer == NULL)
    {
      m_Renderer = ren;
      m_Renderer->Register(NULL);
    }

  m_RenderWindow->AddRenderer(ren);
m_Renderer->BackingStoreOff();
m_Renderer->Clear();

  updateGL();
}

void vtkQGLWidget::RemoveRenderer(vtkRenderer *ren)
{
  if(NULL == ren) return;

  m_RenderWindow->RemoveRenderer(m_Renderer);
    
  if(m_Renderer == ren)
    {
      m_Renderer->Delete();
      m_RenderWindow->GetRenderers()->InitTraversal();
      m_Renderer = m_RenderWindow->GetRenderers()->GetNextItem();

      if(m_Renderer != NULL) m_Renderer->Register(NULL);
    }



  updateGL();
}

vtkRenderer *vtkQGLWidget::GetRenderer()
{
  if(m_Renderer == NULL)
    {
      AddRenderer(CreateDefaultRenderer());
    }

  return m_Renderer;
}


/*!
  Paint the box. The actual openGL commands for drawing the box are
  performed here.
*/

void vtkQGLWidget::paintGL()
{
  // only Render if widget is visible
  //if(!isVisibleToTLW()) return;
  // this is the new function from qt: (bolten)
  if(!isVisible()) return;

  //cout<<"paintGL()"<<flush;
  glClear( GL_COLOR_BUFFER_BIT );
  //makeCurrent();
  //glFlush();
  if( !m_bRenWinIsInitialized)
    {
      WId nId = winId(); 
      m_RenderWindow->SetWindowId((void*) nId); 
      m_bRenWinIsInitialized = true;
    }

  m_RenderWindow->Render();

  setUpdateNeeded(FALSE);
}

void vtkQGLWidget::blockUpdate()
{
  m_UpdateBlockCount++; 
}

void vtkQGLWidget::unblockUpdate()
{
  m_UpdateBlockCount = (m_UpdateBlockCount > 0) ? --m_UpdateBlockCount : 0;
  if(!updateBlocked() && updateNeeded()) updateGL();
}


//  Tell the renderwindow the new Size
void vtkQGLWidget::resizeGL( int w, int h )
{
  m_RenderWindow->SetSize(w, h);
}

//  Get stereo type
int vtkQGLWidget::GetStereoType()
{
  return(m_RenderWindow->GetStereoType());
}

//  Select stereo type
void vtkQGLWidget::SetStereoType(int type)
{
  m_RenderWindow->SetStereoType(type);
}

// Get status of stereo rendering
int vtkQGLWidget::GetStereoRender()
{
  return(m_RenderWindow->GetStereoRender());
}

//  Turn stereo rendering on/off
void vtkQGLWidget::SetStereoRender(int stereo)
{
  m_RenderWindow->SetStereoRender(stereo);
}

//  New makeCurrent
void vtkQGLWidget::makeCurrent()
{
  m_RenderWindow->MakeCurrent();
}

////////////////////////////////////////////////////////////
// the Default - Methods
//

vtkRenderer *vtkQGLWidget::CreateDefaultRenderer()
{
  return vtkRenderer::New();
}

