/****************************************************************************
**
** Copyright (C) 2000-2006 Lehrig Software Engineering.
**
** This file is part of the pvbrowser project.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#ifndef OPT_H
#define OPT_H

#define MAX_PRINTF_LENGTH 1024
#define MAXOPT 1024

typedef struct
{
  // inifile args
  int port;                 //=5050   # default port
  int sshport;              //=50500  # local port for ssh connections
  int zoom;                 //=100    # zoom factor in %
  int autoreconnect;        //=0      # 0|1
  int exitpassword;         //=0      # 0|1
  int menubar;              //=1      # 0|1
  int toolbar;              //=1      # 0|1
  int statusbar;            //=1      # 0|1
  int scrollbars;           //=1      # 0|1
  int fullscreen;           //=0      # 0|1
  int maximized;            //=0      # 0|1
  char temp[MAXOPT];        //=/tmp
  char customlogo[MAXOPT];  //=/home/lehrig/cc/joschi/custom.bmp
  char newwindow[MAXOPT];   //=pvbrowser
  char ssh[MAXOPT];         //=ssh
  char initialhost[MAXOPT]; //=pv://localhost
  char language[MAXOPT];    // = german
  char language_section[MAXOPT];

  // command line args
  int  arg_debug;
  int  arg_localini;
  char arg_font[MAXOPT];
  char arg_host[MAXOPT];
  int  arg_disable;
  int  arg_x;
  int  arg_y;
  int  arg_w;
  int  arg_h;
}OPT;

const char *inifile();
const char *readIniFile();
int mysystem(const char *command);

#endif
