/****************************************************************************
**
** Copyright (C) 2000-2006 Lehrig Software Engineering.
**
** This file is part of the pvbrowser project.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#include "syntax.h"
#include <ctype.h>
const char *cKeywords[] = {
  "break", "case", "continue", "default", "do", "else", "enum", "extern",
  "for", "goto", "if", /*"interrupt",*/  "return", "sizeof", "struct",
  "switch", "typedef", "union", "while", 0L};

const char *cTypes[] = {
  "auto", "char", "const", "double", "float", "int", "long", "register",
  "short", "signed", "static", "unsigned", "void", "volatile", 0L};

// ISO/IEC 14882:1998 . Sec. 2.11.1 (aka ANSI C++)
// keyword "const" (apart from a type spec.) is also a keyword, so it is named inside this array
// what about typeof?
const char *cppKeywords[] = {
  "asm", "catch", "class", "const_cast", "const", "delete", "dynamic_cast",
  "explicit", "export", "false", "friend", "inline", "namespace", "new",
  "operator", "private", "protected", "public", "reinterpret_cast",
  "static_cast", "template", "this", "throw", "true", "try", "typeid",
  "typename", "using", "virtual",
  // alternative representations  (these words are reserved and shall not be used otherwise)
  //  ISO/IEC 14882:1998 . Sec. 2.11.2
  "and_eq", "and", "bitand", "bitor", "compl", "not_eq", "not", "or_eq", "or",
  "xor_eq", "xor", 0L};

const char *cppTypes[] = {
  "bool", "wchar_t", "mutable", 0L};

syntax::syntax(QTextEdit *edit) 
       :QSyntaxHighlighter(edit)
{
  e = edit;
}

syntax::~syntax()
{
}

void syntax::highlightBlock(const QString &text)
{
  char buf[1024];
  int start;
  int i,len;
  QColor red(255,0,0); 
  QColor green(0,255,0); 
  QColor blue(0,0,255);
  QColor grey(128,128,128);
  QColor black(0,0,0);

  if(text.isNull()) return;
  if(text.length() >= (int) sizeof(buf)) return;
  strcpy(buf,text.toAscii());

  setFormat(0,sizeof(buf)-1,black);
  //##########################################################################
  for(i=0; cKeywords[i] != 0L; i++)
  {
    len = strlen(cKeywords[i]);
    for(start=0; buf[start] != '\0'; start++)
    {
      if(strncmp(&buf[start],cKeywords[i],len) == 0 && (isspace(buf[start+len]) || buf[start+len] == '(' || buf[start+len] == ':' || buf[start+len] == ';'))
      {
        if(start == 0)                 setFormat(start,len,red);
        else if(isspace(buf[start-1])) setFormat(start,len,red);
      }
    }
  }
  //##########################################################################
  for(i=0; cppKeywords[i] != 0L; i++)
  {
    len = strlen(cppKeywords[i]);
    for(start=0; buf[start] != '\0'; start++)
    {
      if(strncmp(&buf[start],cppKeywords[i],len) == 0 && (isspace(buf[start+len]) || buf[start+len] == '(' || buf[start+len] == ':' || buf[start+len] == ';'))
      {
        if(start == 0)                 setFormat(start,len,red);
        else if(isspace(buf[start-1])) setFormat(start,len,red);
      }
    }
  }
  //##########################################################################
  for(i=0; cTypes[i] != 0L; i++)
  {
    len = strlen(cTypes[i]);
    for(start=0; buf[start] != '\0'; start++)
    {
      if(strncmp(&buf[start],cTypes[i],len) == 0 && (isspace(buf[start+len]) || buf[start+len] == '(' || buf[start+len] == ':' || buf[start+len] == ';'))
      {
        if(start == 0)                 setFormat(start,len,blue);
        else if(isspace(buf[start-1])) setFormat(start,len,blue);
        else if(buf[start-1] == '(')   setFormat(start,len,blue);
      }
    }
  }
  //##########################################################################
  for(i=0; cppTypes[i] != 0L; i++)
  {
    len = strlen(cppTypes[i]);
    for(start=0; buf[start] != '\0'; start++)
    {
      if(strncmp(&buf[start],cppTypes[i],len) == 0 && (isspace(buf[start+len]) || buf[start+len] == '(' || buf[start+len] == ':' || buf[start+len] == ';'))
      {
        if(start == 0)                 setFormat(start,len,blue);
        else if(isspace(buf[start-1])) setFormat(start,len,blue);
        else if(buf[start-1] == '(')   setFormat(start,len,blue);
      }
    }
  }
  //##########################################################################
  for(start=0; buf[start] != '\0'; start++)
  {
    if(buf[start] == '/' && buf[start+1] == '/')
    {
      setFormat(start,strlen(&buf[start]),grey);
      return;
    }
    else if(buf[start] == '(' || buf[start] == ')')
    {
      setFormat(start,1,blue);
    }
    else if(buf[start] == '[' || buf[start] == ']')
    {
      setFormat(start,1,blue);
    }
    else if(buf[start] == '{' || buf[start] == '}')
    {
      setFormat(start,1,blue);
    }
  }

  return;
}
