.\" 
.\" $Header: xblackjack.man,v 1.7 92/08/12 23:34:46 kirke Locked $
.\"
.\" xblackjack -- the game of blackjack
.\"
.\" (c) Copyright 1992, Kirk Erickson and Silicon Graphics Inc.
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software
.\" and its documentation for any purpose is hereby granted without fee,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of Kirk Erickson and
.\" Silicon Graphics Inc. not be used in advertising or publicity pertaining
.\" to distribution of the software without specific, written prior
.\" permission.  Kirk Erickson and Silicon Graphics Inc. make no
.\" representations about the suitability of this software for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\" 
.\" THE ABOVE-NAMED DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
.\" EVENT SHALL THE ABOVE-NAMED BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
.\" OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.
.\"
.TH xblackjack 1
.SH NAME
xblackjack \- game of blackjack
.SH SYNOPSIS
.B xblackjack
.SH DESCRIPTION

Xblackjack is a
.B MOTIF/OLIT
based tool constructed to get you ready for the casino.  It
was inspired by a book called "Beat the Dealer" by Edward O. Thorp, Ph.D.
of UCLA.  A number of important statistics are maintained for display,
and used by the program to implement Thorp's "Complete Point System"
(high-low system).
Harvey Dubner presented the strategy at a panel session of the
1963 Fall Joint Computer Conference.

The
.B COUNT
used by the strategy starts at zero after the shuffle.
When you see a 2, 3, 4, 5, or 6 you add one to the COUNT.
Subtract one when you see a ten, face card, or ace.
The 7, 8, and 9 have no effect on the COUNT.
When the COUNT is positive your odds are favorable;  you should bet more,
and then stand, double down, and split more often.

The complete system takes the number of uplayed cards into account; a
COUNT of 2 in the last hand is better than a COUNT of 2 in the first hand.

All selections are made using the
.B LEFT
mouse button.
Bets are placed using the scale labelled "your bet".
Choices are made by clicking on the
pushbuttons (split, double down, hit, or stand).

Game status and results are shown in the message pushbutton
below the card area.  Pressing it will reveal the high-low
.B INDEX
calculation:

.br
		(COUNT*100)/UNSEEN

The strategy recommends you bet half the INDEX in favorable situations,
and only buy insurance when the INDEX is greater than 8.
When  making a choice, the relevant table corresponding to the best
choice is revealed too:

.br
		Pair Spliting
.br
		Doubling Down
.br
		Drawing or Standing with Hard Hands
.br
		Drawing or Standing with Soft Hands

Press the message button repeatedly to cycle through the relevant tables.
There are separate standing tables for HARD and SOFT hands.  A hand is
.B SOFT
if it contains an Ace that can contribute 11 to the total without
exceeding 21.  All other hands are 
.B HARD.

When making choices, first decide if you should split (when you can), then
whether or not to double down, and finally if you should hit or stand.

Test the strategy using the slider to the right of the card area.
The program will play unattended, until you return the slider to the 
bottom.  You can stop by pressing the bottom area of the scale to return
the slider there immediately, or click on the message pushbutton. 

.SH EXAMPLES
xblackjack
.SH AUTHORS
Kirk Erickson (kirk@sgi.com)
.br
Guy Renard (grenard@elrond.stg.trw.com)

Cards courtesy of the folks that built Spider:
.br
	Heather Rose (hrose@sun.com)
.br
	Dave Lemke (lemke@ncd.com)
.br
	Don Woods (woods@sun.com)

.SH CAVEATS
Single deck, Reno rules.  You can double down on 10 or 11 only.
Dealer hits soft 17.

.SH KEYWORDS
  blackjack, twenty-one, van-john, pontoon, Ein-und-Zwanzig
