= 	subroutine clu_broadcast (identification, text, destination)    C+ C Version:	V1-001  C - C Facility:	Library routines - cluster stuff.  C D C Abstract:	Broadcast a formatted message to selected terminals on a C		cluster.  C + C Environment:	As required for SYS$BRKTHRU.  C 
 C History: C " C	28-Sep-1990, DBS; Version V1-001 C 001 -	Original version.  C-   C++  C Functional Description: E C	The information supplied is formatted as shown below then broadcast F C	the the terminal(s) listed.  Note that multi-line text messages must C	be formatted by the caller.  C	5 C	##########  <ident>  <current_date_time>  #########  C	<text> C  C Calling Sequence: 2 C	call clu_broadcast (prog_id, message, term_list) C		-or-  C	pushaq	term_list C	pushaq	message C	pushaq	prog_id C	calls	#3, g^clu_broadcast  C  C Formal Argument(s): B C	identification.rt.ds  Address of a string descriptor pointing to5 C			the text to be used in the identification line of  C			for formatted message.B C	text.rt.ds	Address of a string descriptor pointing to the actual7 C			text of the message.  This must be formatted by the  C			caller. ? C	destination.rt.ds  Address of a descriptor pointing to string 5 C			containing the terminal (or list of terminals) to  C			receive the broadcast. C  C Implicit Inputs: C	None C  C Implicit Outputs:  C	None C  C Completion Codes:  C	None C  C Side Effects:  C	None C--    	implicit none  " C External references and includes   	external	lib$date_time  	integer*4	str_len 	external	str_len  	integer*4	str$element 	external	str$element  	integer*4	sys$brkthru 	external	sys$brkthru    	include '($BRKDEF)/nolist'  	include '($STRDEF)/nolist'   ; C Type declarations for parameters and PARAMETER statements    	character	crlf*(*) " 	character	default_destination*(*)% 	character	default_identification*(*)  	character	delimiter*(*)  & 	parameter	(crlf = char(13)//char(10))* 	parameter	(default_destination = 'OPA0:')< 	parameter	(default_identification = 'Unidentified Message') 	parameter	(delimiter = ',')  ! C Type declarations for variables    	character	identification*(*)  	character	text*(*)  	character	destination*(*)   	character	broadcast_dest*256  	character	broadcast_ident*32  	character	date_time*23  	integer*4	destination_len 	integer*4	element 	integer*4	ident_len 	integer*4	message_len 	character	message_text*2048 	integer*4	terminal_len  	character	terminal*32 	integer*4	text_len  	integer*4	status    C+
 C Mainline C-   	call lib$date_time (date_time)   % 	ident_len = str_len (identification)    	if (ident_len .eq. 0) then * 		broadcast_ident = default_identification 	else ! 	broadcast_ident = identification  	end if   ( 	destination_len = str_len (destination)  ! 	if (destination_len .eq. 0) then & 		broadcast_dest = default_destination 	else  	broadcast_dest = destination  	end if   & 	ident_len = str_len (broadcast_ident) 	text_len = str_len (text)+ 	destination_len = str_len (broadcast_dest)   B 	message_text = crlf//'##########  '//broadcast_ident(1:ident_len)& 	1			//'  '//date_time//'  ##########' 	1		//crlf//text(1:text_len)
 	1		//crlf% 	message_len = str_len (message_text)    	element = 0  C 	status = str$element(terminal, element, delimiter, broadcast_dest)   # 	do while (status .ne. str$_noelem) # 		terminal_len = str_len (terminal)   0 		call sys$brkthru (,message_text(1:message_len) 	1			,terminal(1:terminal_len) 	1			,%val(brk$c_device),, 	1			,%val(brk$m_cluster),,,,,)    		element = element + 1 ) 		status  = str$element(terminal, element ! 	1				,delimiter, broadcast_dest)  	end do    	return  	end