	subroutine julian (d1, m1, y1, d2, m2, y2, f, j2, w2, t2)

C	see end of routine for full documentation

	implicit	integer*4	(a-z)

	real*4		fd1, fm1, fy1, fd2, fm2, fy2, ff, fj2, fw2, ft2

	fd1 = d1
	fm1 = m1
	fy1 = y1

	fj2 = 1.0

	if ((fy1 .lt. 0.0) .or. (fm1 .lt. -1.0) .or. (fm1 .gt. 14.0))
	1	fj2 = 0.0

	if (fj2 .eq. 1.0) then
		fy2 = fy1
		if (fy2 .le. 99.0) fy2 = fy2 + 1900.
		ff  = aint((14.0 - fm1)/12.0)
		fj2 = aint(30.61*(fm1 + 1.0 + ff*12.0))
	1		+ fd1 + aint(365.25*(fy2 - ff))
		fj2 = fj2 - aint((((fy2 - ff)/100.0) + 1.0)*0.75) + 1720997.0
		fw2 = aint(fj2 + 1.0 - aint((fj2 + 1.0)/7.0)*7.0)
		fy2 = fj2 - 1721119.1
	1		+ aint(0.75*aint((fj2 - 1684594.75)/36524.25))
		fd2 = aint(fy2 - aint(365.25*aint(fy2/365.25)) + 122.2)
		fy2 = aint(fy2/365.25) + aint(fd2/429.0)
		fm2 = aint(fd2/30.61) - 1.0 - aint(fd2/429.0)*12.0
		fd2 = fd2 - aint(30.61*aint(fd2/30.61))
		ft2 = int(30.61*(fm2 + 1.0 + ff*12.0)) + fd2 - fw2 + 1000.0
		ft2 = aint(ft2/1177.0) - aint(ft2/1361.0)
		if (fj2 .lt. 2361222.0) fj2 = 0.0
	endif !(fj2 .eq. 1.0) then

	d1 = fd1
	m1 = fm1
	y1 = fy1
	d2 = fd2
	m2 = fm2
	y2 = fy2
	f  = ff
	j2 = fj2
	w2 = fw2
	t2 = ft2

	return
	end

C
C	ALGORITHM DERIVED FROM HART: SOFTWARE - PRACTICE AND EXPERIENCE
C				       VOL 10, 405-417 (1980)
C	WHERE A MOST COMPLETE SYNTHESIS IS GIVEN.
C	
C	CONVERTED FROM HART'S BASIC TO FORTRAN BY R.J.WRIGHT
C	(WAIT COMPUTING CENTRE, SEPTEMBER 1980)
C
C	LANGUAGE-CONVERSION PROBLEM:
C		BASIC STORES ALL NUMBERS IN FLOATING POINT AND
C		TRULY TRUNCATES WHEN CONVERTING TO INTEGER.
C		FORTRAN IN MANY IMPLEMENTATIONS ROUNDS WHEN
C		DOING THIS CONVERSION. THUS THIS ROUTINE FIRSTLY
C		CONVERTS ALL ARGUMENTS TO FLOATING POINT, WORKS
C		IN FLOATING POINT, AND DELIBERATELY TRUNCATES
C		USING THE AINT FUNCTION. THIS IS NOT QUITE AS EFFICIENT
C		AS MAY BE DESIRED, BUT IT WORKS!
C
C	THE OTHER SIGNIFICANT CHANGE MADE WAS TO RE-ORDER THE M-D-Y
C	DATE CONVENTION TO THE MORE INTERNATIONALLY ACCEPTIBLE D-M-Y.
C
C	***** THE FOLLOWING COMMENTS ARE REPRODUCED ALMOST VERBATIM FROM HART *****
C
C	Julian conversion and inverse -- takes into account
C	leap years and the omission of February 29 in years evenly
C	divisible by 100 but not by 400 (the Gregorian convention).
C
C	J2, the Julian date, is the exact number of days since
C	BC 4714 December 31. Noon on 1981 January 1 marks the
C	beginning of JD 2444606.
C
C	D-M-Y, the Gregorian calendar, was adapted in the United
C	States on 1752 September 14 (JD 2361222). Prior to this
C	date the algorithm has no real meaning although it will
C	calculate imaginary dates back to AD 0 March 1.
C
C	In the United States daylight saving time begins at 2:00 AM
C	the last Sunday of April and extends to 2:00 AM the last
C	Sunday of October. (These are respectively the first Sunday
C	beginning day 55, and the first Sunday beginning day 239).
C	This algorithm provides T2=0 during standard time and T2=1
C	during daylight saving time.
C	Today's T2 minus yesterday's T2 is the daily adjustment to
C	the clock at 2:00 AM.
C	
C	Input arguments:
C			D1	day	usually 0..31, can also be any integer
C			M1	month	0,1..12,13,14
C			Y1	year	1753..future, must be 4 digits 
C					(xx means 19xx)
C
C	Output arguments:
C			D2	day	1..31
C			M2	month	1..12
C			Y2	year	1753..future
C			F	flag	1=Jan,Feb; 0=Mar..Dec
C			J2	JD	2361222..future; 2444606=1-1-1981
C				NOTE: J2 IS RETURNED AS 0 FOR INVALID DATE.
C			W2	weekday	0..6; Sunday..Saturday; (J2+1) MOD 7
C			T2	time	0=standard; 1=daylight saving time
C			2:00 AM adjustment = today's T2 minus yesterday's T2
C
C
C	SOME POSSIBLE USES:
C		LAST MONTH
C			first day = JULIAN(1,M-1,Y,.......)
C			last day = JULIAN(0,M,Y,...)
C
C		THIS MONTH
C			first day = JULIAN(1,M,Y,...)
C			last day = JULIAN(0,M+1,Y,...)
C
C		NEXT MONTH
C			first day = JULIAN(1,M+1,Y,...)
C			last day = JULIAN(0,M+2,Y,...)
C
C		X OR -X DAYS FROM D-M-Y
C			JULIAN(D+X,M,Y,...)
C
C		DATE FOR THE XTH DAY OF THE YEAR
C			JULIAN(X,1,Y,...)
C
C		DAYS BETWEEN TWO DATES
C			JULIAN(D1,M1,Y1,...,J1,...)
C			JULIAN(D2,M2,Y2,...,J2,...)
C			then take J2-J1
C
C		DAY OF THE YEAR
C			JULIAN(M,D,Y,...,J1,...)
C			JULIAN(0,1,Y,...,J2,...)
C			then take J2-J1
C
C
