0 	integer function lib_cvt_t_l*4 (source, result)   C+ C Version:	V1-001  C  C Facility:	Library routines.  C C C Abstract:	Convert a character string to a longword integer in the  C		specified radix.  C  C Environment:	User mode.  C 
 C History: C " C	22-Dec-1988, DBS, Version V1-001 C 001 -	Original version.  C-   C++  C Functional Description: C C	The source string is converted to a longword value by calling the : C	appropriate ots$ routine.  All conversions are unsigned./ C	The string can contain the following formats:  C		digits		use decimal radix C		%Bdigits	use binary radix C		%Ddigits	use decimal radix  C		%Odigits	use octal radix ! C		%Xdigits	use hexadecimal radix  C  C Calling Sequence: & C	status = lib_cvt_t_l (string, value) C		-or-  C	pushal	value C	pushaq	string  C	calls	#2, g^lib_cvt_t_l  C  C Formal Argument(s): D C	source.rt.ds	Address of a string descriptor pointing to the string C			to be converted.@ C	result.wl.r	Address of a longword into which the result can be C			placed.  C  C Implicit Inputs: C	None C  C Implicit Outputs:  C	None C  C Completion Codes: + C	ss$_ivchar	Returned for an invalid radix. & C	As returned by the ots$cvt routines. C  C Side Effects:  C	None C--     	implicit none    C External references    	integer*4	ots$cvt_tb_l  	external	ots$cvt_tb_l 	integer*4	ots$cvt_to_l  	external	ots$cvt_to_l 	integer*4	ots$cvt_tu_l  	external	ots$cvt_tu_l 	integer*4	ots$cvt_tz_l  	external	ots$cvt_tz_l 	external	str$upcase 	integer*4	str_len 	external	str_len   ! C Type declarations for variables    	character	source*(*)  	integer*4	radix 	integer*4	result  	integer*4	status  	integer*4	digit_count 	character	digits*32 	integer*2	first 	character	radix_op*1    C Commons (and includes)   	include '($OTSDEF)' 	include '($SSDEF)'    C+
 C Mainline C-  ! 	call str$upcase (digits, source)    	lib_cvt_t_l = ss$_normal  	digit_count = str_len (digits)  	first	    = 1 	radix	    = 10    	if (digits(1:1) .eq. '%') then  		first    = 3 		radix_op = digits(2:2) 		if (radix_op .eq. 'B') then  		    	radix = 2 		else 		if (radix_op .eq. 'O') then  		    	radix = 8 		else 		if (radix_op .eq. 'D') then  		    	radix = 10  		else 		if (radix_op .eq. 'X') then  		    	radix = 16  		else 		radix = -1 		end if ! radix_op .eq. X 		end if ! radix_op .eq. D 		end if ! radix_op .eq. O 		end if ! radix_op .eq. B 	end if ! digits(1:1) .eq. '%'   	if (radix .eq. 2) then ? 		lib_cvt_t_l = ots$cvt_tb_l (%descr(digits(first:digit_count)) ) 	1				   ,%ref(result), %val(4), %val(0))  	else  	if (radix .eq. 8) then ? 		lib_cvt_t_l = ots$cvt_to_l (%descr(digits(first:digit_count)) ) 	1				   ,%ref(result), %val(4), %val(0))  	else  	if (radix .eq. 10) then? 		lib_cvt_t_l = ots$cvt_tu_l (%descr(digits(first:digit_count)) ) 	1				   ,%ref(result), %val(4), %val(0))  	else  	if (radix .eq. 16) then? 		lib_cvt_t_l = ots$cvt_tz_l (%descr(digits(first:digit_count)) ) 	1				   ,%ref(result), %val(4), %val(0))  	else      	lib_cvt_t_l = ss$_ivchar  	end if ! radix .eq. 16  	end if ! radix .eq. 10  	end if ! radix .eq. 8 	end if ! radix .eq. 2   	return    	end