& 	subroutine lib_output_seg_tzb (buffer 	1				,alleged_buffer_size 	1				,requested_segment_size)   C+ C Version:	V1-001  C  C Facility:	Library routines.  C D C Abstract:	To take a buffer and generate a formatted display of the' C		buffer as ascii and hex byte values.  C  C Environment:	User mode.  C 
 C History: C " C	15-Jun-1990, DBS, Version V1-001 C 001 -	Original version.  C-   C++  C Functional Description: D C	Take the buffer as byte values and format them into ascii and hex.A C	Displays are generated from SYS$FAO and directed to sys$output. B C	Output is generated in segments of the specified size and a byteD C	offset from the start of the buffer is included with each segment. C  C Calling Sequence: = C	call lib_output_seg_tzb (buffer, buffer_size, segment_size)  C		-or-  C	pushal	segment_size  C	pushal	buffer_size C	pushaq	buffer   C	calls	#3, g^lib_output_seg_tzb C  C Formal Argument(s): @ C	buffer.rt.ds	Address of a string descriptor that points to the C			characters to be displayed. G C	alleged_buffer_size.rl.r  Address of a longword containing the number  C			of bytes to display.C C	requested_segment_size.rl.r  Address of a longword containing the 4 C			number of bytes to be displayed in each segment. C  C Implicit Inputs: C	None C  C Implicit Outputs: # C	Output is directed to SYS$OUTPUT.  C  C Completion Codes:  C	None C  C Side Effects:  C	None C--     	implicit none    C External references    	external	lib$put_output 	external	sys$faol  ; C Type declarations for parameters and PARAMETER statements    	integer*4	default_segment_size  	integer*4	max_segment_size  	character	fao_data*(*)   & 	parameter	(default_segment_size = 16)" 	parameter	(max_segment_size = 32)8 	parameter	(fao_data = '  [!#<!AF!>]-!5UL-[!XB!#(3XB)]')  ! C Type declarations for variables    	character	buffer*(*)  	integer*4	alleged_buffer_size! 	integer*4	requested_segment_size   % 	integer*4	b_byte(max_segment_size+6)  	integer*4	buffer_size 	integer*4	bytes_this_segment  	integer*4	count 	integer*4	fao_len 	integer*4	first 	integer*4	last  	character	line*512  	integer*4	loop  	integer*4	number_of_segments  	integer*4	segment_size    C+
 C Mainline C-   	buffer_size = len(buffer)! 	if ((alleged_buffer_size .ge. 1) 1 	1		.and. (alleged_buffer_size .le. buffer_size)) $ 	1	buffer_size = alleged_buffer_size  & 	segment_size = requested_segment_size= 	if (segment_size .lt. 1) segment_size = default_segment_size ( 	if (segment_size .gt. max_segment_size)" 	1	segment_size = max_segment_size  C 	number_of_segments = (buffer_size - 1 + segment_size)/segment_size 	 	loop = 0   ( 	do while (loop .lt. number_of_segments) 		first = loop*segment_size + 1 " 		last  = first + segment_size - 1/ 		if (last .gt. buffer_size) last = buffer_size ' 		bytes_this_segment = last - first + 1    		b_byte(1) = segment_size  		b_byte(2) = bytes_this_segment& 		b_byte(3) = %loc(buffer) + first - 1 		b_byte(4) = first - 1 # 		b_byte(5) = ichar(buffer(first:)) $ 		b_byte(6) = bytes_this_segment - 1  " 		do count = 2, bytes_this_segment2 			b_byte(count+5) = ichar(buffer(first+count-1:))& 		enddo !count = 2, bytes_this_segment  ! 		call sys$faol (%descr(fao_data)  	1			,%ref(fao_len)  	1			,%descr(line) 	1			,%ref(b_byte))   ' 		call lib$put_output (line(1:fao_len))    		loop = loop + 1 - 	end do !while (loop .lt. number_of_segments)    	return  	end