@ 	integer*4 function str_evaluate (expression, dot, q, z, result)   C+ C Version:	V1-003  C  C Facility:	Library routines.  C ) C Abstract:	Evaluate a string expression.  C  C Environment:	User mode.  C 
 C History: C " C	27-Nov-1989, DBS, Version V1-001 C 001 -	Original version. " C	01-Dec-1989, DBS; Version V1-002C C 002 -	Added call to lib$int_over () to disable integer overflows. " C	09-Apr-1990, DBS; Version V1-003K C 003 -	Check for upper and lowercase q's and z's.  (An oversight earlier.)  C-   C++  C Functional Description: C C	This routine will take a string and parse and evaluate the simple E C	arithmetic expression contained within it.  The evaluation does not E C	handle any form of bracketing and the string is parsed from left to 5 C	right and terminates on any error or end of string. 3 C	Valid operators are (all operations are INTEGER): 
 C		+	addition  C		-	subtraction C		*	multiplication 
 C		/	division  C		!	logical OR  C		#	logical XOR C		&	logical AND C		_	logical NOTI C	The following symbols are accepted and will be given the values passed,  C	"." and "Q" and "Z".E C	[Because of the history of this routine and its original use, these $ C	values have the following meaning:& C		.	the current location (or address) C		Q	the last value displayed $ C		Z	the base location (or address)] C  C Calling Sequence:  C 3 C	call str_evaluate (expression, dot, q, z, result)  C  C Formal Argument(s): H C	expression.rt.ds The string containing the expression to be evaluated.$ C	dot.rl.r	The value to use for ".".# C	q.rl.r		The value to use for "Q". # C	z.rl.r		The value to use for "Z". - C	result.wl.r	Somewhere to return the answer.  C  C Implicit Inputs: C	None C  C Implicit Outputs:  C	None C  C Completion Codes: 4 C	Similar to those returned by the ots$cvt routines. C  C Side Effects:  C	None C--     	implicit none    C External references    	include '($SSDEF)/nolist'   	external	lib$int_over 	integer*4	lib_cvt_t_l 	external	lib_cvt_t_l  	integer*4	str_len 	external	str_len   ; C Type declarations for parameters and PARAMETER statements    	integer*4	disable_  	parameter	(disable_ = 0)   ! C Type declarations for variables    	character	expression*(*)  	integer*4	dot 	integer*4	q 	integer*4	z 	integer*4	result    	integer*4	cvtstatus 	logical*4	do_compliment 	integer*4	expression_len  	integer*4	first 	logical*4	keep_looking  	integer*4	last  	character	operator*1 ' 	character	operator_list*7		/'+-*/!&#'/  	integer*4	total 	integer*4	value   C+
 C Mainline C-   	call lib$int_over (disable_)   * 	str_evaluate = ss$_normal	! be optimistic  & 	expression_len = str_len (expression)    	if (expression_len .eq. 0) then 		str_evaluate = ss$_ivchar  	else  	result = 0  	total  = 0  	first  = 1  	operator = '+' % 	do while (first .le. expression_len)  		last = first 		keep_looking = .true.    		do while (keep_looking) % 			if (last .ge. expression_len) then  				keep_looking = .false. 			else : 			if (index(operator_list, expression(last:last)) .ne. 0)	 	1			then  				last = last - 1  				keep_looking = .false. 			else  			last = last + 16 			endif !(index(operator_list, expression(last:last))) 			endif !(last .ge. expression_len) then  		enddo !while (keep_looking)   , 		if (expression(first:first) .eq. '_') then 			do_compliment = .true.  			first = first + 1 		else 		do_compliment = .false. 0 		endif !(expression(first:first) .eq. '_') then  + 		if (expression(first:last) .eq. '.') then  			value = dot 			cvtstatus = ss$_normal  		else' 		if ((expression(first:last) .eq. 'Q') 0 	1		.or. (expression(first:last) .eq. 'q')) then 			value = q 			cvtstatus = ss$_normal  		else' 		if ((expression(first:last) .eq. 'Z') 0 	1		.or. (expression(first:last) .eq. 'z')) then 			value = z 			cvtstatus = ss$_normal  		else9 		cvtstatus = lib_cvt_t_l (expression(first:last), value) / 		endif !(expression(first:last) .eq. 'Z') then / 		endif !(expression(first:last) .eq. 'Q') then / 		endif !(expression(first:last) .eq. '.') then    		if (.not. cvtstatus) then  			first = expression_len + 1  			str_evaluate = cvtstatus  		else* 		if (do_compliment) value = (.not. value). 		if (operator .eq. '+') total = total + value. 		if (operator .eq. '-') total = total - value, 		if (operator .eq. '*') total = total*value3 		if (operator .eq. '!') total = (total .or. value) 4 		if (operator .eq. '&') total = (total .and. value)4 		if (operator .eq. '#') total = (total .xor. value) 		if (operator .eq. '/') then  			if (value .eq. 0) then  				first = expression_len + 1 				str_evaluate = ss$_intdiv  			else  			total = total/value 			endif !(value .eq. 0) then ! 		endif !(operator .eq. '/') then  		if (last .lt. expression_len) ( 	1		operator = expression(last+1:last+1) 		first = last + 2 		endif !(.not. cvtstatus) then ) 	enddo !while (first .le. expression_len)    	result = total $ 	endif !(expression_len .eq. 0) then   	return  	end